/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class UserGroupStandardListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(UserGroupStandardListPlugin.class);
    private static final String TBL_LISTEN = "tbllisten";
    private static final String TBL_SYNCHRONIZATION = "tblsynchronization";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{TBL_LISTEN});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{TBL_SYNCHRONIZATION, TBL_LISTEN});
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("id", "!=", (Object)PermHelperConst.NOTCLASSIFY_STDID));
        e.setOrderBy("id asc");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String systemType = "bos-permission-formplugin";
        String chooseDataTips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"UserGroupStandardListPlugin_0", (String)systemType, (Object[])new Object[0]);
        String onlyOneTips = ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u3002", (String)"UserGroupStandardListPlugin_1", (String)systemType, (Object[])new Object[0]);
        IFormView view = this.getView();
        if (evt.getItemKey().equals(TBL_LISTEN)) {
            BillList billList = (BillList)view.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)rows)) {
                view.showTipNotification(chooseDataTips, Integer.valueOf(2000));
                return;
            }
            if (rows.size() > 1) {
                view.showTipNotification(onlyOneTips, Integer.valueOf(2000));
                return;
            }
            Long userGroupStandardId = (Long)rows.get(0).getPrimaryKeyValue();
            this.getPageCache().put("userGroupStandardId", String.valueOf(userGroupStandardId));
            this.showEvtEventPage(userGroupStandardId);
        } else if (evt.getItemKey().equals(TBL_SYNCHRONIZATION)) {
            // empty if block
        }
    }

    private void showEvtEventPage(Long userGroupStandardId) {
        DynamicObject userGroupStandard = BusinessDataServiceHelper.loadSingleFromCache((Object)userGroupStandardId, (String)"perm_usergroupstandard", (String)"id, entry_srcent.source_entity");
        DynamicObjectCollection sourceEntityCollection = userGroupStandard.getDynamicObjectCollection("entry_srcent");
        if (CollectionUtils.isEmpty((Collection)sourceEntityCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u672a\u8bbe\u7f6e\u201c\u6570\u636e\u6e90\u201d\u3002", (String)"UserGroupStandardListPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        ArrayList<String> sourceNum = new ArrayList<String>(10);
        for (DynamicObject sourceEntity : sourceEntityCollection) {
            sourceNum.add(sourceEntity.getString("source_entity.number"));
        }
        String sourceNumJson = SerializationUtils.toJsonString(sourceNum);
        this.getPageCache().put("sourceNum", sourceNumJson);
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"perm_choosecustomfield", (boolean)true, (int)0, (boolean)true);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chooseCustomField"));
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setCustomParam("show_page", (Object)"event_listen");
        lsp.setCustomParam("userGroupStandardId", (Object)String.valueOf(userGroupStandardId));
        lsp.setCaption(ResManager.loadKDString((String)"\u5f85\u76d1\u542c\u64cd\u4f5c", (String)"UserGroupStandardListPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        lsp.setShowTitle(true);
        lsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("chooseCustomField".equals(actionId)) {
            ListSelectedRowCollection retData = (ListSelectedRowCollection)e.getReturnData();
            if (retData != null) {
                String number;
                List sourceNum = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("sourceNum"), List.class);
                DynamicObject[] events = BusinessDataServiceHelper.load((String)"evt_event", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("entity", "in", (Object)sourceNum)});
                HashMap<String, Long> existNum = new HashMap<String, Long>(16);
                for (DynamicObject event : events) {
                    Long id = event.getLong("id");
                    number = event.getString("number");
                    existNum.put(number, id);
                }
                ArrayList<Long> ids = new ArrayList<Long>(retData.size());
                for (ListSelectedRow retDatum : retData) {
                    String eventNum;
                    Long eventId;
                    String idStr = (String)retDatum.getPrimaryKeyValue();
                    String[] info = idStr.split("\\|");
                    number = info[0];
                    String eventName = info[1];
                    String[] numberInfo = number.split("\\.");
                    String[] nameInfo = eventName.split("\\.");
                    String entityNum = numberInfo[0];
                    String operationKey = numberInfo[1];
                    String entityName = nameInfo[0];
                    String operationName = nameInfo[1];
                    String appId = BizAppServiceHelp.getAppIdByFormNum((String)entityNum);
                    if (existNum.containsKey(number)) {
                        eventId = (Long)existNum.get(number);
                        eventNum = number;
                    } else {
                        Object[] eventInfo = this.createEvent(entityNum, appId, operationName, operationKey, number, eventName);
                        eventId = (Long)eventInfo[0];
                        eventNum = (String)eventInfo[1];
                    }
                    Long subscriptionId = this.createSubscription(eventId, eventNum, eventName);
                    ids.add(subscriptionId);
                }
                this.eventCacheHandle(ids);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u201c\u76d1\u542c\u4e8b\u4ef6\u201d\u8bbe\u7f6e\u6210\u529f\u3002", (String)"UserGroupStandardListPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            this.getPageCache().remove("userGroupStandardId");
            this.getPageCache().remove("sourceNum");
        }
    }

    private void eventCacheHandle(List<Long> ids) {
        DynamicObject[] savedSubscriptions = BusinessDataServiceHelper.load((String)"evt_subscription", (String)"eventnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashMap<String, ArrayList<String>> needCachedEvtNums = new HashMap<String, ArrayList<String>>();
        for (DynamicObject o : savedSubscriptions) {
            String evtNumber = o.getString("eventnumber");
            String groupNumber = evtNumber.contains(".") ? evtNumber.split("\\.")[0] : "defaultGroup";
            ArrayList<String> needRemovedEvent = (ArrayList<String>)needCachedEvtNums.get(groupNumber);
            if (needRemovedEvent == null) {
                needRemovedEvent = new ArrayList<String>();
                needCachedEvtNums.put(groupNumber, needRemovedEvent);
            }
            needRemovedEvent.add(evtNumber);
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("workflow", new DistributeCacheHAPolicy(true, true));
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getAccountId()).append(".evt.").append("cacheEvent");
        Set entrySet = needCachedEvtNums.entrySet();
        for (Map.Entry entry : entrySet) {
            String deleteKey = String.format("%s.%s", sb, entry.getKey());
            cache.addToSet(deleteKey, (String[])((List)entry.getValue()).toArray((Object[])new String[0]), Integer.MAX_VALUE);
        }
    }

    private Long createSubscription(Long eventId, String eventNum, String eventName) {
        DynamicObject opEventSubscrpObj = BusinessDataServiceHelper.newDynamicObject((String)"evt_subscription");
        opEventSubscrpObj.set("event", (Object)eventId);
        opEventSubscrpObj.set("service", (Object)904236026388547584L);
        opEventSubscrpObj.set("number", (Object)(eventNum + ".executePlugin"));
        opEventSubscrpObj.set("eventnumber", (Object)eventNum);
        opEventSubscrpObj.set("isconcurrent", (Object)"1");
        opEventSubscrpObj.set("status", (Object)"1");
        opEventSubscrpObj.set("errorstrategy", (Object)"retry");
        opEventSubscrpObj.set("servicenumber", (Object)"executePlugin");
        StringBuilder mes = new StringBuilder(eventName).append(ResManager.loadKDString((String)".\u81ea\u52a8\u540c\u6b65", (String)"UserGroupStandardListPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        opEventSubscrpObj.set("name", (Object)mes.toString());
        opEventSubscrpObj.set("ispreinsdata", (Object)"0");
        opEventSubscrpObj.set("ismodified", (Object)"1");
        opEventSubscrpObj.set("serviceconfig", (Object)"{\"scriptid\":\"\",\"type\":\"class\",\"value\":\"{\\\"appid\\\":\\\"base\\\",\\\"class\\\":\\\"kd.bos.permission.formplugin.plugin.eventcenter.UgStdEvtListenPlugin\\\"}\"}");
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])ArrayUtils.toArray((Object[])new DynamicObject[]{opEventSubscrpObj})));
        return (Long)opEventSubscrpObj.getPkValue();
    }

    private Object[] createEvent(String entityNum, String appId, String operationName, String operationKey, String eventNum, String eventName) {
        DynamicObject opEventObj = BusinessDataServiceHelper.newDynamicObject((String)"evt_event");
        opEventObj.set("type", (Object)"cosmic");
        opEventObj.set("entity", (Object)entityNum);
        opEventObj.set("source", (Object)appId);
        opEventObj.set("operation", (Object)operationName);
        opEventObj.set("opernumber", (Object)operationKey);
        opEventObj.set("scene", (Object)"operate");
        opEventObj.set("numberview", (Object)eventNum);
        opEventObj.set("number", (Object)eventNum);
        opEventObj.set("name", (Object)eventName);
        opEventObj.set("description", (Object)eventName);
        opEventObj.set("status", (Object)"1");
        opEventObj.set("ismodified", (Object)"1");
        opEventObj.set("ispreinsdata", (Object)"0");
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])ArrayUtils.toArray((Object[])new DynamicObject[]{opEventObj})));
        return new Object[]{opEventObj.getPkValue(), opEventObj.getString("number")};
    }
}

