/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.sql.ResultSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.util.StringUtils;

public class UserGroupStandardPlugin
extends AbstractFormPlugin
implements IBillPlugin {
    private static final Log logger = LogFactory.getLog(UserGroupStandardPlugin.class);
    private static final String ENTITY = "perm_usergroupstandard";
    private static final String ENTRYENTITY = "entry_srcent";
    private static final String LISTEN_ENTITY = "entry_listenconfig";
    private static final String PROP_SOURCE_ENTITY = "source_entity";

    public void initialize() {
        TextEdit a = (TextEdit)this.getControl("userfieldname");
        a.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                EntryGrid sourceEntity = (EntryGrid)UserGroupStandardPlugin.this.getControl(UserGroupStandardPlugin.ENTRYENTITY);
                int[] selectRows = sourceEntity.getSelectRows();
                DynamicObject[] dataEntitys = sourceEntity.getEntryData().getDataEntitys();
                if (dataEntitys != null) {
                    DynamicObject dataEntity = dataEntitys[selectRows[0]];
                    String number = dataEntity.getString("source_entity.number");
                    if (StringUtils.isNotEmpty((String)number)) {
                        UserGroupStandardPlugin.this.showFieldPage(number);
                    } else {
                        UserGroupStandardPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6570\u636e\u6e90\u5b9e\u4f53\u201d\u3002", (String)"UserGroupStandardPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    }
                }
            }
        });
    }

    private void setEnable() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", PROP_SOURCE_ENTITY});
        }
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterLoadData(EventObject e) {
        EntryGrid sourceEntity = (EntryGrid)this.getControl(ENTRYENTITY);
        DynamicObject[] dataEntitys = sourceEntity.getEntryData().getDataEntitys();
        int count = 0;
        this.getModel().beginInit();
        if (dataEntitys != null && dataEntitys.length > 0) {
            for (DynamicObject dataEntity : dataEntitys) {
                String number = dataEntity.getString("source_entity.number");
                this.getView().setEnable(Boolean.FALSE, count, new String[]{PROP_SOURCE_ENTITY, "userfieldname"});
                String userFieldKey = dataEntity.getString("userfieldkey");
                Map entityUserFieldMap = PermCommonUtil.getEntityUserFieldMap((String)number);
                String fieldName = (String)entityUserFieldMap.get(userFieldKey);
                this.getModel().setValue("userfieldname", (Object)fieldName, count++);
            }
        }
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        Long currentId;
        super.afterBindData(e);
        Object id = this.getModel().getValue("id");
        if (id != null && PermHelperConst.NOTCLASSIFY_STDID.equals(currentId = (Long)id)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"sourceflex", "listenflex"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        EntryGrid sourceEntity;
        DynamicObject[] dataEntitys;
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (e.getOperationResult().isSuccess() && "save".equals(operateKey) && (dataEntitys = (sourceEntity = (EntryGrid)this.getControl(ENTRYENTITY)).getEntryData().getDataEntitys()) != null && dataEntitys.length > 0) {
            this.getModel().beginInit();
            for (int i = 0; i < dataEntitys.length; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{PROP_SOURCE_ENTITY, "userfieldname"});
            }
            this.getModel().endInit();
            this.getModel().setDataChanged(false);
            this.getView().updateView(LISTEN_ENTITY);
        }
    }

    private void refreshListenConfig() {
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (rowCount > 0) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            StringBuilder param = new StringBuilder("(");
            for (DynamicObject dataEntity : entryEntity) {
                String number = dataEntity.getString("source_entity.number");
                param.append("'").append(number).append("',");
            }
            param.deleteCharAt(param.length() - 1).append(") ");
            String sql = " SELECT a.fid,a.fnumber,b.fid FROM t_evt_event a INNER JOIN t_evt_subscription b ON a.fid = b.fevent WHERE a.fentity IN " + param + " AND b.fserviceconfig LIKE '%kd.bos.permission.formplugin.plugin.eventcenter.UgStdEvtListenPlugin%' ";
            Map result = (Map)DB.query((DBRoute)DBRoute.workflow, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<Long, Long>>(){

                public Map<Long, Long> handle(ResultSet rs) throws Exception {
                    HashMap<Long, Long> result = new HashMap<Long, Long>(16);
                    while (rs.next()) {
                        result.put(rs.getLong(1), rs.getLong(3));
                    }
                    return result;
                }
            });
            TableValueSetter vs = new TableValueSetter(new String[]{"event", "subscription"});
            for (Map.Entry event : result.entrySet()) {
                vs.addRow(new Object[]{event.getKey(), event.getValue()});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(LISTEN_ENTITY, vs);
            EntryGrid entryGrid = (EntryGrid)this.getControl(LISTEN_ENTITY);
            entryGrid.getEntryState().setCurrentPageIndex(Integer.valueOf(1));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    private void showFieldPage(String entityNum) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"perm_choosecustomfield", (boolean)false, (int)0, (boolean)true);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chooseCustomField"));
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setCustomParam("entityNum", (Object)entityNum);
        lsp.setCustomParam("show_page", (Object)"user_group_source_field");
        lsp.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"UserGroupStandardPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        lsp.setShowTitle(true);
        lsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection retData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("chooseCustomField".equals(actionId) && (retData = (ListSelectedRowCollection)e.getReturnData()) != null) {
            String idStr = (String)retData.get(0).getPrimaryKeyValue();
            String[] info = idStr.split("\\|");
            EntryGrid sourceEntity = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = sourceEntity.getSelectRows();
            this.getModel().setValue("userfieldname", (Object)info[1], selectRows[0]);
            this.getModel().setValue("userfieldkey", (Object)info[0], selectRows[0]);
        }
    }
}

