/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.service.UserGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class UserGroupTemplateTreePlugin
extends AbstractTreeListPlugin {
    private static final String ID_ROOTNODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String TREE_USERGROUP = "treeview";
    private static final String BTN_SEARCH = "searchap";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String FORMSHOWPARAMETER_NOTPERMPAGE = "FormShowParameter_notPermPage";

    public static void setSearchEvent(SearchEnterEvent k, TreeView tree, Long usrGrpStd) {
        String text = k.getText();
        if (StringUtils.isEmpty((String)text)) {
            UserGroupService.initTree((TreeView)tree, (String)ID_ROOTNODE, (Long)usrGrpStd);
            return;
        }
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(ID_ROOTNODE);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"UserGroupTemplateTreePlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        tree.addNode(root);
        String lang = RequestContext.get().getLang().name();
        boolean isChineseLang = "zh_CN".equals(lang);
        Object[] params = null;
        params = isChineseLang ? new Object[]{lang, usrGrpStd, "%" + text + "%"} : new Object[]{lang, usrGrpStd, "%" + text + "%", "%" + text + "%"};
        StringBuilder sbsql = new StringBuilder("select ug.fid, ugl.fname usrgrpname ");
        if (!isChineseLang) {
            sbsql.append(", ugl2.fname usrgrpname2 ");
        }
        sbsql.append(" from t_sec_usergroup ug ");
        sbsql.append(" left join t_sec_usergroup_l ugl on (ug.fid = ugl.fid and ugl.flocaleid = ?) ");
        if (!isChineseLang) {
            sbsql.append(" left join t_sec_usergroup_l ugl2 on (ug.fid = ugl2.fid and ugl2.flocaleid = 'zh_CN') ");
        }
        sbsql.append(" where ug.fusrgrpstdid = ? ");
        if (!isChineseLang) {
            sbsql.append(" and (ugl.fname like ? or ugl2.fname like ? )");
        } else {
            sbsql.append(" and ugl.fname like ? ");
        }
        DB.query((DBRoute)DBRoute.basedata, (String)sbsql.toString(), (Object[])params, r -> {
            while (r.next()) {
                String id = r.getString("fid");
                String name = "";
                if (isChineseLang) {
                    name = r.getString("usrgrpname");
                } else {
                    String otherName = r.getString("usrgrpname");
                    String chName = r.getString("usrgrpname2");
                    name = StringUtils.isNotEmpty((String)otherName) ? otherName : chName;
                }
                if (!StringUtils.isNotEmpty((String)name) || !name.contains(text)) continue;
                TreeNode treeNode = new TreeNode(ID_ROOTNODE, id, name, false);
                tree.addNode(treeNode);
            }
            return true;
        });
        tree.expand(ID_ROOTNODE);
    }

    public void registerListener(EventObject e) {
        Vector btnDel;
        Vector btnNew;
        super.registerListener(e);
        Search userGroupTreeSearch = (Search)this.getControl(BTN_SEARCH);
        if (userGroupTreeSearch != null) {
            TreeView tree = (TreeView)this.getControl(TREE_USERGROUP);
            Long usrGrpStd = Long.valueOf((String)this.getModel().getValue("usrgrpstd"));
            userGroupTreeSearch.addEnterListener(k -> UserGroupTemplateTreePlugin.setSearchEvent(k, tree, usrGrpStd));
        }
        if ((btnNew = (Vector)this.getControl(BTN_NEW)) != null) {
            btnNew.addClickListener(new ClickListener(){

                public void beforeClick(BeforeClickEvent evt) {
                    if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"83bfebc8000037ac", (String)"bos_usrgrp", (String)"47156aff000000ac")) {
                        evt.setCancel(true);
                        UserGroupTemplateTreePlugin.this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserGroupTemplateTreePlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), FormMetadataCache.getFormConfig((String)"bos_usrgrp").getCaption().toString(), PermItemHelper.getPermItemNameById((String)"47156aff000000ac")));
                    }
                }
            });
        }
        if ((btnDel = (Vector)this.getControl(BTN_DEL)) != null) {
            btnDel.addClickListener(new ClickListener(){

                public void beforeClick(BeforeClickEvent evt) {
                    if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"83bfebc8000037ac", (String)"bos_usrgrp", (String)"4715e1f1000000ac")) {
                        evt.setCancel(true);
                        UserGroupTemplateTreePlugin.this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserGroupTemplateTreePlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), FormMetadataCache.getFormConfig((String)"bos_usrgrp").getCaption().toString(), PermItemHelper.getPermItemNameById((String)"4715e1f1000000ac")));
                    }
                }
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("usrgrpstd");
        comboEdit.setMustInput(true);
        comboEdit.setComboItems(UserGroupService.getAllUsrGrpStd());
        this.getModel().setValue("usrgrpstd", (Object)"1404221671421785088");
        TreeView tree = (TreeView)this.getControl(TREE_USERGROUP);
        UserGroupService.initTree((TreeView)tree, (String)ID_ROOTNODE);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        TreeView source = (TreeView)e.getSource();
        Map focusNode = source.getTreeState().getFocusNode();
        if (focusNode != null) {
            String curUserGroupName = String.valueOf(focusNode.get("text"));
            this.getView().getPageCache().put("userGroupName", curUserGroupName);
            String focusNodeId = String.valueOf(focusNode.get("id"));
            this.getView().getPageCache().put("focusNodeId", focusNodeId);
            String parentId = String.valueOf(focusNode.get("parentid"));
            this.getView().getPageCache().put("focusNodeParentId", parentId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        if ("chkincludechild".equals(proName)) {
            TreeView tv = this.treeListView.getTreeView();
            Map focusMap = tv.getTreeState().getFocusNode();
            if (focusMap != null) {
                tv.treeNodeClick(String.valueOf(focusMap.get("parentid")), String.valueOf(focusMap.get("id")));
            }
        } else if ("usrgrpstd".equals(proName) && StringUtils.isNotEmpty((String)(newValue = (String)e.getChangeSet()[0].getNewValue()))) {
            TreeView treeView = (TreeView)this.getControl(TREE_USERGROUP);
            UserGroupService.initTree((TreeView)treeView, (String)ID_ROOTNODE, (Long)Long.parseLong(newValue), (boolean)true);
            treeView.treeNodeClick("", ID_ROOTNODE);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String billFormIdStr;
        e.setCancel(true);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object billFormId = formShowParameter.getCustomParam("billFormId");
        List extEntNumList = FormHelper.getInheritedEntity((String)"bos_usergroup_user", (boolean)true);
        if (billFormId != null ? extEntNumList.contains(billFormId + "") : formShowParameter instanceof ListShowParameter && extEntNumList.contains(billFormIdStr = ((ListShowParameter)formShowParameter).getBillFormId())) {
            return;
        }
        String nodeIdStr = e.getNodeId().toString();
        if (ID_ROOTNODE.equals(nodeIdStr)) {
            return;
        }
        long nodeId = Long.parseLong(nodeIdStr.split("-")[0]);
        HashSet<Long> usrGrpIds = new HashSet<Long>(10);
        usrGrpIds.add(nodeId);
        if (((Boolean)this.getModel().getValue("chkincludechild")).booleanValue()) {
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)"perm_usrgrp_inh", (String)"parent,children", null);
            usrGrpIds.addAll(UserGroupService.getAllParentOrChildrenGroup((DynamicObject[])objects, (Long)nodeId, (int)1));
        }
        e.addQFilter(new QFilter("id", "in", usrGrpIds));
    }
}

