/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.utils.BaseUtils;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.utils.StrategeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.AdminUserCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.log.helper.PermDirectLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.permission.model.AdminType;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.service.UserGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class UserGroupTreeListPlugin
extends AbstractTreeListPlugin
implements AfterSearchClickListener,
RowClickEventListener,
ICloseCallBack {
    private static final String ID_ROOTNODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String TREE_USERGROUP = "treeview";
    private static final String USER_LIST = "billlistap";
    private static final String BARITEM_ASSIGNROLE = "btn_allocprem";
    private static final String BARITEM_ASSIGNROLEMULTI = "btn_allocpremmulti";
    private static final String BARITEM_ASSIGN_COMROLELIST = "btn_assign_comrolelist";
    private static final String BARITEM_ASSIGN_BUSIROLELIST = "btn_assign_busirolelist";
    private static final String BARITEM_USERDIRECTLIST = "btn_userdirectlist";
    private static final String BARITEM_USERDIRECTDISLIST = "btn_userdirectdislist";
    private static final String BARITEM_ASSIGN_BIZROLE = "btn_assign_bizrole";
    protected static final String BARITEM_ASSIGNPERM = "baritem_assignperm";
    protected static final String BARITEM_ASSIGNPERMMULTI = "baritem_assignpermmulti";
    protected static final String BTN_DIRECTDISFUN = "btn_directdisfun";
    protected static final String BTN_DIRECTDISFUNMULTI = "btn_directdisfunmulti";
    protected static final String BARITEM_COPYPERM = "btn_copyperm";
    private static final String BARITEM_CLEARCACHE = "btn_clearcache";
    protected static final String BARITEM_SHARE = "tbn_share";
    private static final String BARITEM_UNLOCK = "btn_unlock";
    private static final String BTN_RESETPWD = "btn_resetpwd";
    private static final String BTN_PWDSTRATEGY = "btn_pwdstrategy";
    private static final String BARITEM_CLEARPERM = "btn_clearperm";
    private static final String BARITEM_REFRESH = "btn_refresh";
    private static final String BARITEM_CLOSE = "btn_close";
    private static final String CTRL_FILTERCONTAINER = "filtercontainerap";
    private static final String BARITEM_ALERTUSERPERM = "baritem_alteruserperm";
    private static final String BARITEM_USERASSIGNUSRGRP = "btn_userassignusrgrp";
    private static final String BARITEM_USRGRPASSIGNUSER = "btn_usrgrpassignuser";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String BARITEM_SUBDISABLE = "tblsubdisable";
    private static final String BARITEM_SUBENABLE = "tblsubscriberenable";
    private static final String CONFIRMCALLBACK_DELUSERGROUP = "confirmCallBack_deleteUserGroup";
    private static final String FSP_FORMNAME_ASSIGNROLE = "formShowParam_formName_assignRole";
    private static final String FSP_FORMNAME_ASSIGNBIZROLE = "formShowParam_formName_assignBizRole";
    private static final String FSP_FORMNAME_ASSIGNPERM = "formShowParam_formName_assignPerm";
    private static final String FORMSHOWPARAMETER_NOTPERMPAGE = "FormShowParameter_notPermPage";
    public static final String BILLLIST = "billlistap";
    private static final String CONFIRMCALLBACK_CLEARPERM = "confirmCallBack_clearPerm";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final String BOS_USER_ENTITY = "bos_user";
    private static List<String> NEED_SELECT_USER_ITEM;
    private static final String PSW_SETTING = "psw_setting";
    private static final String BTN_USERPERIOD = "btn_userperiod";
    private static final Log logger;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter fsp = e.getFormShowParameter();
        String showFormSpecial = (String)fsp.getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        String unableShowInfo = (String)fsp.getCustomParam("formShowParm_show_unableInfo");
        if (StringUtils.isNotEmpty((String)unableShowInfo)) {
            e.setCancel(true);
            e.setCancelMessage(unableShowInfo);
            return;
        }
        ListShowParameter lsp = (ListShowParameter)fsp;
        if (!lsp.isLookUp()) {
            PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer fc = (FilterContainer)this.getControl(CTRL_FILTERCONTAINER);
        fc.addAfterSearchClickListener((AfterSearchClickListener)this);
        this.addClickListeners(new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if (BTN_NEW.equals(ctrlKey)) {
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId("bos_usrgrp");
            bsp.setStatus(OperationStatus.ADDNEW);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            TreeView userGroupTree = (TreeView)this.getControl(TREE_USERGROUP);
            String focusNodeId = this.getView().getPageCache().get("focusNodeId");
            if (StringUtils.isEmpty((String)focusNodeId)) {
                focusNodeId = userGroupTree.getTreeState().getFocusNodeId();
            }
            if (focusNodeId != null && !ID_ROOTNODE.equals(focusNodeId)) {
                focusNodeId = focusNodeId.split("-")[0];
                bsp.setCustomParam("FormShowParameter_parentGroup", (Object)Long.valueOf(focusNodeId));
            }
            this.getView().showForm((FormShowParameter)bsp);
        } else if (BTN_EDIT.equals(ctrlKey)) {
            String focusNodeId = this.getView().getPageCache().get("focusNodeId");
            if (StringUtils.isEmpty((String)focusNodeId)) {
                TreeView userGroupTree = (TreeView)this.getControl(TREE_USERGROUP);
                focusNodeId = userGroupTree.getTreeState().getFocusNodeId();
            }
            if (focusNodeId == null || ID_ROOTNODE.equals(focusNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u201c\u7528\u6237\u7ec4\u201d\u8282\u70b9\u3002", (String)"UserGroupTreeListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            focusNodeId = focusNodeId.split("-")[0];
            String parentPageId = this.getView().getPageId();
            String prePageId = parentPageId + "_showForm_" + "bos_usergroup_user" + focusNodeId;
            IFormView iformView = this.getView().getViewNoPlugin(prePageId);
            if (iformView != null) {
                PermCommonUtil.redirectToExistedPage((String)prePageId, (IFormView)this.getView());
                return;
            }
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId("bos_usrgrp");
            bsp.setPkId((Object)focusNodeId);
            bsp.setStatus(OperationStatus.EDIT);
            bsp.setPageId(prePageId);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bsp);
        } else if (BTN_DEL.equals(ctrlKey)) {
            String focusNodeId = this.getView().getPageCache().get("focusNodeId");
            String curUserGroupName = this.getView().getPageCache().get("userGroupName");
            if (StringUtils.isEmpty((String)focusNodeId) || ID_ROOTNODE.equals(focusNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u201c\u7528\u6237\u7ec4\u201d\u8282\u70b9\u3002", (String)"UserGroupTreeListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            if (ResManager.loadKDString((String)"\u5168\u90e8", (String)"UserGroupTreeListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]).equals(curUserGroupName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u201c\u7528\u6237\u7ec4\u201d\u8282\u70b9\u3002", (String)"UserGroupTreeListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            Long nodeId = Long.valueOf(focusNodeId.split("-")[0]);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_usergroupstaff", (String)"id", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)nodeId).and(new QFilter("user.enable", "=", (Object)Boolean.TRUE))});
            if (dynamicObject != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u201c%s\u201d\u5220\u9664\u4e0d\u6210\u529f\uff0c\u56e0\u4e3a\u8be5\u7528\u6237\u7ec4\u4e0b\u8fd8\u5b58\u5728\u7528\u6237\u3002", (String)"UserGroupTreeListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[]{curUserGroupName}));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u7528\u6237\u5206\u7ec4 \u201c%s\u201d\uff1f\r\n\u5220\u9664\u7528\u6237\u7ec4\u4ee3\u8868\u5220\u9664\u8be5\u7528\u6237\u7ec4\u5bf9\u5e94\u7684\u7ec4\u4e0e\u7ec4\u7ee7\u627f\u5173\u7cfb\u3001\u7ec4\u548c\u4eba\u5458\u7684\u5173\u7cfb\u3002", (String)"UserGroupTreeListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[]{curUserGroupName}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_DELUSERGROUP));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        Map customParamsFromFsp;
        String operateKey = e.getOperateKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long userIdl = 0L;
        if (rows != null && rows.size() > 0) {
            String userId = String.valueOf(rows.get(0).getPrimaryKeyValue());
            userIdl = (Long)rows.get(0).getPrimaryKeyValue();
            params.put("paramUserId", userId);
        }
        if ((customParamsFromFsp = this.getView().getFormShowParameter().getCustomParams()).get("FormShowParam_dimension") == null) {
            params.put("FormShowParam_dimension", "DIM_ORG");
        }
        Long adminId = RequestContext.get().getCurrUserId();
        switch (operateKey) {
            case "assignrole": {
                PermCommonUtil.checkRobots((Long)userIdl, (String)ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u901a\u8fc7\u201c\u901a\u7528\u89d2\u8272\u201d\u8fdb\u884c\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                if (adminId.toString().equals(params.get("paramUserId"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                this.showDynamicFormByOper("perm_user_assignrole", params, null, ShowType.MainNewTabPage, e);
                break;
            }
            case "assignrolemulti": {
                PermCommonUtil.checkRobots((Long)userIdl, (String)ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u901a\u8fc7\u201c\u901a\u7528\u89d2\u8272\u201d\u8fdb\u884c\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                if (adminId.toString().equals(params.get("paramUserId"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                this.showDynamicFormByOper("perm_userassignrole_multi", params, null, ShowType.MainNewTabPage, e);
                break;
            }
            case "donothing_userassignrolelist": 
            case "donothing_userassignbizrolelist": 
            case "donothing_userdirectlist": 
            case "donothing_userdirectdislist": {
                ListShowParameter lsp = new ListShowParameter();
                String billFormId = UserGroupTreeListPlugin.getListBillFormId(operateKey);
                lsp.setBillFormId(billFormId);
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                String newPageId = this.getView().getPageId() + "|" + billFormId;
                lsp.setPageId(newPageId);
                Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
                if (params != null) {
                    params.putAll(originalCustParams);
                    lsp.setCustomParams(params);
                }
                String dimType = (String)customParamsFromFsp.get("FormShowParam_dimension");
                params.put("FormShowParam_dimension", dimType);
                String appNumStr = (String)customParamsFromFsp.get("FormShowParam_appNum");
                this.getPageCache().put("PERM_PAGECHE_KEY_PREFIX_FormShowParam_dimension", dimType);
                this.getPageCache().put("PERM_PAGECHE_KEY_PREFIX_FormShowParam_appNum", appNumStr);
                this.getView().showForm((FormShowParameter)lsp);
                break;
            }
            case "assignbizrole": {
                PermCommonUtil.checkRobots((Long)userIdl, (String)ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u901a\u8fc7\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u8fdb\u884c\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                if (adminId.toString().equals(params.get("paramUserId"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                this.showDynamicFormByOper("perm_user_assignbizrole", params, null, ShowType.MainNewTabPage, e);
                break;
            }
            case "directassign": {
                PermCommonUtil.checkRobots((Long)userIdl, (String)ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u76f4\u63a5\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                if (adminId.toString().equals(params.get("paramUserId"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                this.showDynamicFormByOper("perm_user_assignperm", params, null, ShowType.MainNewTabPage, e);
                break;
            }
            case "directassignmulti": {
                PermCommonUtil.checkRobots((Long)userIdl, (String)ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u76f4\u63a5\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                if (adminId.toString().equals(params.get("paramUserId"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                this.showDynamicFormByOper("perm_direct_perm_multi", params, null, ShowType.MainNewTabPage, e);
                break;
            }
            case "assigndisfun": {
                PermCommonUtil.checkRobots((Long)userIdl, (String)ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u76f4\u63a5\u7981\u6743\u3002", (String)"UserGroupTreeListPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                if (adminId.toString().equals(params.get("paramUserId"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                this.showDynamicFormByOper("perm_user_assigndisfun", params, null, ShowType.MainNewTabPage, e);
                break;
            }
            case "directdisfunmulti": {
                PermCommonUtil.checkRobots((Long)userIdl, (String)ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u76f4\u63a5\u7981\u6743\u3002", (String)"UserGroupTreeListPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                if (adminId.toString().equals(params.get("paramUserId"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                this.showDynamicFormByOper("perm_direct_disperm_multi", params, null, ShowType.MainNewTabPage, e);
                break;
            }
            case "subscriberdisable": 
            case "subscriberenable": {
                billList.refresh();
                break;
            }
            case "copypermoper": {
                PermCommonUtil.checkRobots((Long)userIdl, (String)ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u590d\u5236\u6743\u9650\u3002", (String)"UserGroupTreeListPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.showDynamicForm("bos_copyperm", params, null, ShowType.Modal);
                break;
            }
        }
    }

    private static String getListBillFormId(String operateKey) {
        switch (operateKey) {
            case "donothing_userassignrolelist": {
                return "perm_userrole_layout";
            }
            case "donothing_userassignbizrolelist": {
                return "perm_userbusirole_layout";
            }
            case "donothing_userdirectlist": {
                return "perm_userpermdetail";
            }
            case "donothing_userdirectdislist": {
                return "perm_direct_disperm";
            }
        }
        return "";
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        HashSet<Long> userIds = new HashSet<Long>();
        ListSelectedRowCollection rows = this.getSelectedUsers(userIds);
        switch (itemKey = evt.getItemKey()) {
            case "tblsubdisable": 
            case "tblsubscriberenable": {
                this.itemClickValidate(userIds, false);
                break;
            }
            case "tbn_share": {
                this.chatYZJ(rows);
                break;
            }
            case "btn_clearcache": {
                this.clearAllCache();
                break;
            }
            case "btn_unlock": {
                if (!this.itemClickValidate(userIds, true)) break;
                this.userUnlock(rows, userIds);
                break;
            }
            case "btn_resetpwd": {
                if (!this.itemClickValidate(userIds, true)) break;
                this.setUserPsw(rows, userIds);
                break;
            }
            case "btn_pwdstrategy": {
                if (!this.itemClickValidate(userIds, true)) break;
                this.setUserPswStrategy(rows);
                break;
            }
            case "btn_refresh": {
                this.refresh();
                break;
            }
            case "btn_clearperm": {
                if (!this.itemClickValidate(userIds, true)) break;
                this.deleteUserPerm(rows);
                break;
            }
            case "btn_userassignusrgrp": {
                if (!this.itemClickValidate(userIds, false)) break;
                this.userAssignUserGroup(rows);
                break;
            }
            case "btn_usrgrpassignuser": {
                this.userGroupAssignUser();
                break;
            }
            case "btn_userperiod": {
                if (!this.itemClickValidate(userIds, false)) break;
                this.setUserPeriod(rows);
                break;
            }
        }
    }

    private ListSelectedRowCollection getSelectedUsers(Set<Long> userIds) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection oriRows = billList.getSelectedRows();
        ListSelectedRowCollection rows = new ListSelectedRowCollection();
        if (null == oriRows || oriRows.isEmpty()) {
            return rows;
        }
        for (ListSelectedRow oriRow : oriRows) {
            Object userId = oriRow.getPrimaryKeyValue();
            if (!userIds.add((Long)userId)) continue;
            rows.add((Object)oriRow);
        }
        return rows;
    }

    private boolean itemClickValidate(Set<Long> userIds, boolean mustCheck) {
        if (userIds.isEmpty()) {
            if (mustCheck) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u201c\u7528\u6237\u201d\u3002", (String)"UserGroupTreeListPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2500));
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean singleChoiceValidate(ListSelectedRowCollection rows) {
        if (rows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u3002", (String)"UserGroupTreeListPlugin_20", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2500));
            return false;
        }
        return true;
    }

    protected void clearAllCache() {
        CacheMrg.clearAllCache();
        CacheMrg.clearHasEnableOldAdmin();
        CacheMrg.clearAllLocalCache();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6743\u9650\u7f13\u5b58\u5df2\u6e05\u7406\u3002", (String)"UserGroupTreeListPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2500));
    }

    protected void userUnlock(ListSelectedRowCollection rows, Set<Long> userIds) {
        try (TXHandle h = TX.required();){
            try {
                DynamicObject[] objects;
                int i = 0;
                for (DynamicObject user : objects = BusinessDataServiceHelper.load((String)BOS_USER_ENTITY, (String)"id,islocked,errcount,lockedtime,username,number", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)})) {
                    boolean isLocked = (Boolean)user.get("islocked");
                    if (!isLocked) {
                        ++i;
                        if (rows.size() == 1) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u672a\u9501\u5b9a\uff0c\u65e0\u9700\u89e3\u9501\u3002", (String)"UserGroupTreeListPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(7000));
                        }
                        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u89e3\u9501", "UserGroupTreeListPlugin_43", SYSTEM_TYPE);
                        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u7528\u6237\uff1a%1$s\uff0c\u672a\u9501\u5b9a\uff0c\u65e0\u9700\u89e3\u9501\u3002", "UserGroupTreeListPlugin_23", SYSTEM_TYPE);
                        String[] opDescParam = new String[]{user.getString("username")};
                        String oldOpDescription = String.format(ResManager.loadKDString((String)"\u7528\u6237\uff1a%1$s\uff0c\u672a\u9501\u5b9a\uff0c\u65e0\u9700\u89e3\u9501\u3002", (String)"UserGroupTreeListPlugin_23", (String)SYSTEM_TYPE, (Object[])new Object[0]), user.get("username"));
                        PermCommonUtil.addLog(null, null, (String)BOS_USER_ENTITY, (String)user.getString("number"), (String)"0", (String)"unlock", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)"base");
                        continue;
                    }
                    user.set("islocked", (Object)Boolean.FALSE);
                    user.set("errcount", (Object)0);
                    user.set("lockedtime", null);
                    if (rows.size() == 1) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u9501\u6210\u529f\u3002", (String)"UserGroupTreeListPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2500));
                    }
                    Account currentAccount = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
                    StrategeUtils.clearPasswordWrongTimes((Account)currentAccount, (String)user.get("id").toString(), (String)LoginClientEnum.WEB.toString());
                    MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u89e3\u9501", "UserGroupTreeListPlugin_43", SYSTEM_TYPE);
                    MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge(" \u89e3\u9501\u6210\u529f\u3002", "UserGroupTreeListPlugin_45", SYSTEM_TYPE);
                    String[] opDescParam = null;
                    String oldOpDescription = ResManager.loadKDString((String)"\u7528\u6237\uff1a", (String)"UserGroupTreeListPlugin_44", (String)SYSTEM_TYPE, (Object[])new Object[0]) + user.get("username") + ResManager.loadKDString((String)" \u89e3\u9501\u6210\u529f\u3002", (String)"UserGroupTreeListPlugin_45", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    PermCommonUtil.addLog(null, null, (String)BOS_USER_ENTITY, (String)user.getString("number"), (String)"1", (String)"unlock", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, opDescParam, (String)oldOpDescription, null, null, (String)"base");
                }
                if (i != rows.size()) {
                    SaveServiceHelper.save((DynamicObject[])objects);
                }
                if (rows.size() != 1) {
                    String mes = String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u7528\u6237\uff0c\u6210\u529f\u89e3\u9501%2$s\u4e2a\u7528\u6237\uff0c%3$s\u4e2a\u7528\u6237\u672a\u9501\u5b9a", (String)"UserGroupTreeListPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]), rows.size(), rows.size() - i, i);
                    this.getView().showConfirm(mes, MessageBoxOptions.OKCancel);
                }
                BillList billList = (BillList)this.getView().getControl("billlistap");
                billList.refresh();
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
                h.markRollback();
            }
        }
    }

    protected void setUserPsw(ListSelectedRowCollection rows, Set<Long> userIds) {
        if (rows.size() > 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u91cd\u7f6e\u5bc6\u7801\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u7528\u6237\u3002", (String)"UserGroupTreeListPlugin_19", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2500));
            return;
        }
        if (userIds.contains(RequestContext.get().getCurrUserId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bf9\u81ea\u5df1\u91cd\u7f6e\u5bc6\u7801\uff0c\u8bf7\u901a\u8fc7\u3010\u4e2a\u4eba\u8bbe\u7f6e-\u4fee\u6539\u5bc6\u7801\u3011\u5904\u7406\u3002", (String)"UserGroupTreeListPlugin_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        if (PermCommonUtil.permResetInitPwd()) {
            this.getView().showConfirm(ConstantsHelper.getResetPsswConfirmMsg(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("RESETPSSW", (IFormPlugin)this));
        } else {
            if (!this.singleChoiceValidate(rows)) {
                return;
            }
            FormShowParameter resetPw_fsp = new FormShowParameter();
            resetPw_fsp.setFormId("bos_passwordsetting");
            resetPw_fsp.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> customMap = new HashMap<String, String>();
            customMap.put("userId", String.valueOf(rows.get(0).getPrimaryKeyValue()));
            resetPw_fsp.setCustomParams(customMap);
            resetPw_fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PSW_SETTING));
            this.getView().showForm(resetPw_fsp);
        }
    }

    protected void setUserPswStrategy(ListSelectedRowCollection rows) {
        if (!this.singleChoiceValidate(rows)) {
            return;
        }
        BillShowParameter fsp = new BillShowParameter();
        fsp.setPkId(rows.get(0).getPrimaryKeyValue());
        fsp.setFormId("bos_usergroup_user");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)fsp);
    }

    protected void deleteUserPerm(ListSelectedRowCollection rows) {
        if (!this.singleChoiceValidate(rows)) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6e05\u9664\u7528\u6237\u6743\u9650\u6570\u636e\u540e\u5c06\u65e0\u6cd5\u590d\u539f\uff0c\u7ee7\u7eed\u64cd\u4f5c\uff1f\uff08\u5982\u679c\u7528\u6237\u6240\u5728\u7528\u6237\u7ec4\u6709\u5206\u914d\u6743\u9650\uff0c\u5c06\u4f1a\u5c06\u7528\u6237\u79fb\u51fa\u5bf9\u5e94\u7528\u6237\u7ec4\uff09", (String)"UserGroupTreeListPlugin_21", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_CLEARPERM));
    }

    protected void userAssignUserGroup(ListSelectedRowCollection rows) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        StringBuilder userIds = new StringBuilder();
        StringBuilder userNames = new StringBuilder();
        StringBuilder userNumbers = new StringBuilder();
        for (ListSelectedRow row : rows) {
            String userId = String.valueOf(row.getPrimaryKeyValue());
            String userName = String.valueOf(row.getName());
            String userNumber = String.valueOf(row.getNumber());
            userIds.append(userId).append(',');
            userNames.append(StringUtils.isEmpty((String)userName) ? " " : userName).append(',');
            userNumbers.append(StringUtils.isEmpty((String)userNumber) ? " " : userNumber).append(',');
        }
        params.put("userIds", userIds.substring(0, userIds.length() - 1));
        params.put("userNames", userNames.substring(0, userNames.length() - 1));
        params.put("userNumbers", userNumbers.substring(0, userNumbers.length() - 1));
        boolean notPermPage = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam(FORMSHOWPARAMETER_NOTPERMPAGE));
        if (!notPermPage) {
            params.put("isFromPermPage", "true");
        }
        this.showDynamicForm("bos_userassignusrgrp", params, null, ShowType.Modal);
    }

    protected void userGroupAssignUser() {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        String focusNodeId = this.getView().getPageCache().get("focusNodeId");
        if (StringUtils.isEmpty((String)focusNodeId)) {
            TreeView userGroupTree = (TreeView)this.getControl(TREE_USERGROUP);
            focusNodeId = userGroupTree.getTreeState().getFocusNodeId();
        }
        params.put("usrgrpid", focusNodeId.split("-")[0]);
        params.put("formIdentity", "bos_usergroup_user");
        boolean enablePermLog = PermCommonUtil.isEnablePermLog();
        if (enablePermLog) {
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"ug_assign_user");
            params.put("permLogBusiType", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
        } else {
            params.put("permLogBusiType", "");
        }
        if (StringUtils.isNotEmpty((String)focusNodeId) && !ID_ROOTNODE.equals(focusNodeId)) {
            this.showDynamicForm("perm_usrgrpassignuser", params, new CloseCallBack((IFormPlugin)this, "CloseCallBack_usrgrpAssignUser"), ShowType.Modal);
        }
    }

    protected void setUserPeriod(ListSelectedRowCollection rows) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        StringJoiner sj = new StringJoiner(",");
        for (ListSelectedRow row : rows) {
            sj.add(row.getPrimaryKeyValue().toString());
        }
        params.put("userids", sj.toString());
        CloseCallBack userPeriodCloseCallBack = new CloseCallBack((IFormPlugin)this, BTN_USERPERIOD);
        this.showDynamicForm("bos_usergroup_userperiod", params, userPeriodCloseCallBack, ShowType.Modal);
    }

    private void showDynamicFormByOper(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, AfterDoOperationEventArgs e) {
        String assignPermFormName;
        FormShowParameter fsp = new FormShowParameter();
        if ("perm_user_assignperm".equals(formId) || "perm_user_assigndisfun".equals(formId) || "perm_direct_disperm_multi".equals(formId) || "perm_user_assignrole".equals(formId) || "perm_user_assignbizrole".equals(formId) || "perm_direct_perm_multi".equals(formId) || "perm_userassignrole_multi".equals(formId)) {
            String pageId = this.getView().getPageId();
            String userId = (String)params.get("paramUserId");
            String newPageId = pageId + "|" + formId + "|" + userId;
            fsp.setPageId(newPageId);
            if ("perm_user_assignperm".equals(formId)) {
                this.fillFsp(userId, "directassign", e, fsp);
            } else if ("perm_direct_perm_multi".equals(formId)) {
                this.fillFsp(userId, "directassignmulti", e, fsp);
            } else if ("perm_user_assigndisfun".equals(formId)) {
                this.fillFsp(userId, "assigndisfun", e, fsp);
            } else if ("perm_direct_disperm_multi".equals(formId)) {
                this.fillFsp(userId, "directdisfunmulti", e, fsp);
            } else if ("perm_user_assignrole".equals(formId)) {
                this.fillFsp(userId, "assignrole", e, fsp);
            } else if ("perm_userassignrole_multi".equals(formId)) {
                this.fillFsp(userId, "assignrole", e, fsp);
            } else if ("perm_user_assignbizrole".equals(formId)) {
                this.fillFsp(userId, "assignbizrole", e, fsp);
            }
        }
        Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
        if (params != null) {
            params.putAll(originalCustParams);
            fsp.setCustomParams(params);
        }
        if (formId.equals("perm_user_assignrole")) {
            String assignRoleFormName = (String)originalCustParams.get(FSP_FORMNAME_ASSIGNROLE);
            if (StringUtils.isNotEmpty((String)assignRoleFormName)) {
                formId = assignRoleFormName;
            }
        } else if (formId.equals("perm_user_assignperm")) {
            assignPermFormName = (String)originalCustParams.get(FSP_FORMNAME_ASSIGNPERM);
            if (StringUtils.isNotEmpty((String)assignPermFormName)) {
                formId = assignPermFormName;
            }
        } else if (formId.equals("perm_user_assignbizrole") && StringUtils.isNotEmpty((String)(assignPermFormName = (String)originalCustParams.get(FSP_FORMNAME_ASSIGNBIZROLE)))) {
            formId = assignPermFormName;
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(showType);
        this.getView().showForm(fsp);
    }

    private void fillFsp(String userId, String opKey, AfterDoOperationEventArgs e, FormShowParameter fsp) {
        StringBuilder sbErrorInfo = new StringBuilder();
        boolean require = MutexHelper.require((String)"bos_usergroup_user", (Object)userId, (String)opKey, (StringBuilder)sbErrorInfo);
        this.browserCloseAndListTipsMutexDeal(e, userId, require, opKey);
        if (!require) {
            this.getView().showMessage(sbErrorInfo.toString());
            fsp.setStatus(OperationStatus.VIEW);
        } else {
            fsp.setStatus(OperationStatus.EDIT);
        }
    }

    private void browserCloseAndListTipsMutexDeal(AfterDoOperationEventArgs e, String userId, boolean require, String opKey) {
        OperationResult operationResult;
        if (require) {
            IPageCache pageCache = this.getPageCache();
            pageCache.put("MUTEX_ENTITY_KEY", "bos_usergroup_user");
            pageCache.put("MUTEX_OPER_KEY", opKey);
            pageCache.put("MUTEX_OBJ_ID", userId);
        }
        if (null != e && !(operationResult = e.getOperationResult()).isSuccess()) {
            operationResult.setSuccess(true);
            List allErrorInfos = operationResult.getAllErrorInfo();
            if (!CollectionUtils.isEmpty((Collection)allErrorInfos)) {
                allErrorInfos.removeIf(allErrorInfo -> "datamutex".equals(allErrorInfo.getErrorCode()));
            }
        }
    }

    private void showDynamicForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        String assignPermFormName;
        FormShowParameter fsp = new FormShowParameter();
        Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
        if (params != null) {
            params.putAll(originalCustParams);
            fsp.setCustomParams(params);
        }
        if (formId.equals("perm_user_assignrole")) {
            String assignRoleFormName = (String)originalCustParams.get(FSP_FORMNAME_ASSIGNROLE);
            if (StringUtils.isNotEmpty((String)assignRoleFormName)) {
                formId = assignRoleFormName;
            }
        } else if (formId.equals("perm_user_assignperm")) {
            String assignPermFormName2 = (String)originalCustParams.get(FSP_FORMNAME_ASSIGNPERM);
            if (StringUtils.isNotEmpty((String)assignPermFormName2)) {
                formId = assignPermFormName2;
            }
        } else if (formId.equals("perm_user_assignbizrole") && StringUtils.isNotEmpty((String)(assignPermFormName = (String)originalCustParams.get(FSP_FORMNAME_ASSIGNBIZROLE)))) {
            formId = assignPermFormName;
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(showType);
        this.getView().showForm(fsp);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate formOperate = (FormOperate)args.getSource();
            String operationKey = formOperate.getOperateKey();
            String newPageId = "";
            String pageId = this.getView().getPageId();
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            Long userId = CollectionUtils.isEmpty((Collection)listSelectedData) ? Long.valueOf(0L) : (Long)listSelectedData.get(0).getPrimaryKeyValue();
            switch (operationKey) {
                case "donothing_userassignrolelist": 
                case "donothing_userassignbizrolelist": 
                case "donothing_userdirectlist": 
                case "donothing_userdirectdislist": {
                    String billFormId = UserGroupTreeListPlugin.getListBillFormId(operationKey);
                    newPageId = pageId + "|" + billFormId;
                    break;
                }
                case "assignrole": {
                    newPageId = pageId + "|" + "perm_user_assignrole" + "|" + userId;
                    break;
                }
                case "assignrolemulti": {
                    newPageId = pageId + "|" + "perm_userassignrole_multi" + "|" + userId;
                    break;
                }
                case "assignbizrole": {
                    newPageId = pageId + "|" + "perm_user_assignbizrole" + "|" + userId;
                    break;
                }
                case "directassign": {
                    newPageId = pageId + "|" + "perm_user_assignperm" + "|" + userId;
                    break;
                }
                case "directassignmulti": {
                    newPageId = pageId + "|" + "perm_direct_perm_multi" + "|" + userId;
                    break;
                }
                case "directdisfunmulti": {
                    newPageId = pageId + "|" + "perm_direct_disperm_multi" + "|" + userId;
                    break;
                }
            }
            IFormView iformView = this.getView().getViewNoPlugin(newPageId);
            if (iformView != null) {
                PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
                args.setCancel(true);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        Object[] selectedRealRows = this.getSelectedRealRows();
        if (NEED_SELECT_USER_ITEM.contains(itemKey) && (selectedRealRows == null || 0 == selectedRealRows.length)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u201c\u7528\u6237\u201d\u3002", (String)"UserGroupTreeListPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        boolean ifNeedCancel = false;
        switch (itemKey) {
            case "btn_allocprem": 
            case "btn_allocpremmulti": 
            case "btn_assign_bizrole": 
            case "baritem_assignperm": 
            case "baritem_assignpermmulti": 
            case "btn_copyperm": 
            case "baritem_alteruserperm": 
            case "btn_directdisfun": 
            case "btn_directdisfunmulti": {
                if (selectedRealRows.length <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u3002", (String)"UserGroupTreeListPlugin_24", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                ifNeedCancel = true;
                break;
            }
            case "btn_usrgrpassignuser": {
                String focusNodeId = this.getView().getPageCache().get("focusNodeId");
                if (StringUtils.isEmpty((String)focusNodeId)) {
                    TreeView userGroupTree = (TreeView)this.getControl(TREE_USERGROUP);
                    focusNodeId = userGroupTree.getTreeState().getFocusNodeId();
                }
                if (focusNodeId != null && !focusNodeId.equals(ID_ROOTNODE)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u201c\u7528\u6237\u7ec4\u201d\u3002", (String)"UserGroupTreeListPlugin_25", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                ifNeedCancel = true;
                break;
            }
            case "btn_userperiod": {
                DynamicObjectCollection userDoc = QueryServiceHelper.query((String)BOS_USER_ENTITY, (String)"isforbidden", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRealRows)});
                List filterUserDoc = userDoc.stream().filter(object -> object.getBoolean("isforbidden")).collect(Collectors.toList());
                if (filterUserDoc.size() < userDoc.size()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7528\u6237\u7981\u7528\u201d\u4e3a\u5426\u7684\u8bb0\u5f55\u624d\u80fd\u8bbe\u7f6e\u7528\u6237\u65f6\u6548\u3002", (String)"UserGroupTreeListPlugin_26", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
        if (ifNeedCancel) {
            evt.setCancel(true);
        }
    }

    private String getOpenIdString(List<Long> lstUserId) {
        StringBuilder result = new StringBuilder();
        List userOpenIdList = OrgViewServiceHelper.getOpenIdByUserId(lstUserId);
        if (userOpenIdList != null && userOpenIdList.size() != 0) {
            boolean isFirst = true;
            boolean hasEmptyOpenId = false;
            for (String openId : userOpenIdList) {
                if (StringUtils.isEmpty((String)openId)) {
                    hasEmptyOpenId = true;
                    continue;
                }
                if (isFirst) {
                    isFirst = false;
                    result.append(openId);
                    continue;
                }
                result.append(',');
                result.append(openId);
            }
            if (hasEmptyOpenId) {
                String SuName = "";
                String phoneNumber = "";
                String Email = "";
                DynamicObject[] adminIdObjects = BusinessDataServiceHelper.load((String)"perm_admin", (String)"user_id", (QFilter[])new QFilter[]{new QFilter("admintype", "=", (Object)Long.valueOf(AdminType.Administrator.toString())), new QFilter("type", "=", (Object)"10")});
                Long SuperAdminId = adminIdObjects[0].getLong("user_id");
                DynamicObject[] adminObjects = BusinessDataServiceHelper.load((String)BOS_USER_ENTITY, (String)"name,phone,email", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)SuperAdminId)});
                if (adminObjects != null && adminObjects.length > 0) {
                    SuName = adminObjects[0].getString("name");
                    phoneNumber = adminObjects[0].getString("phone");
                    Email = adminObjects[0].getString("email");
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u7684\u4e91\u4e4b\u5bb6\u8d26\u53f7\u5931\u8d25\uff0c\u8bf7\u5148\u6267\u884c\u201c\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u201d\u7684\u201c\u540c\u6b65\u4e91\u4e4b\u5bb6\u8d26\u53f7\u201d\u64cd\u4f5c\u3002", (String)"UserGroupTreeListPlugin_27", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
        return result.toString();
    }

    private void chatYZJ(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u201c\u7528\u6237\u201d\u3002", (String)"UserGroupTreeListPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2500));
            return;
        }
        int rowSize = rows.size();
        ArrayList<Long> lstUserId = new ArrayList<Long>(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            long userId = (Long)rows.get(i).getPrimaryKeyValue();
            lstUserId.add(userId);
        }
        String openId = this.getOpenIdString(lstUserId);
        if (StringUtils.isEmpty((String)openId)) {
            return;
        }
        YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
        yzj.setView(this.getView());
        HashMap<String, String> mData = new HashMap<String, String>();
        mData.put("openId", openId);
        mData.put("userName", "");
        mData.put("chattype", "chat_pc");
        yzj.yzjInterface("createAndChat", mData);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        boolean isRootNode;
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        String nodeId = e.getNodeId().toString();
        boolean bl = isRootNode = root != null && Objects.equals(root.getId(), nodeId);
        if (isRootNode) {
            return;
        }
        Set<Long> userIds = this.getUserInGroup(nodeId, isRootNode);
        if (userIds != null && !userIds.isEmpty()) {
            QFilter groupFilter = BaseUtils.getSplitIdFilter(null, new ArrayList<Long>(userIds));
            if (groupFilter != null) {
                e.getFilters().add(groupFilter);
            }
        } else {
            e.getFilters().add(new QFilter("id", "in", new HashSet(1)));
        }
    }

    private Set<Long> getUserInGroup(String nodeId, boolean isRootNode) {
        Set userIds = null;
        if (isRootNode) {
            Object usrgrpstd = this.getModel().getValue("usrgrpstd");
            if (usrgrpstd == null) {
                return userIds;
            }
            Long usrGrpStd = Long.valueOf(usrgrpstd.toString());
            if (!PermHelperConst.NOTCLASSIFY_STDID.equals(usrGrpStd)) {
                userIds = UserGroupService.getAllUsersIdByUsrGrpStdId((Long)usrGrpStd);
            }
        } else {
            String focusNodeId = nodeId.split("-")[0];
            userIds = this.isIncludeNextLevel() ? UserGroupService.getAllUsersIdByUsrGrpId((Long)Long.valueOf(focusNodeId)) : UserGroupService.getUsersIdByUsrGrpId((Long)Long.valueOf(focusNodeId), null);
        }
        return userIds;
    }

    private boolean isIncludeNextLevel() {
        boolean isIncludeNextLevel = true;
        Object includeChild = this.getModel().getValue("chkincludechild");
        if (includeChild != null) {
            isIncludeNextLevel = Boolean.parseBoolean(includeChild.toString());
        }
        return isIncludeNextLevel;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String showForSpecial = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        if (!"true".equals(showForSpecial) && !lsp.isLookUp()) {
            lsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
        }
        Object isOrgBaseAdmin = lsp.getCustomParam("isOrgBaseAdmin");
        long currUserId = RequestContext.get().getCurrUserId();
        if (isOrgBaseAdmin != null && ((Boolean)isOrgBaseAdmin).booleanValue() && AdminUserCache.isAdminUser((String)(currUserId + ""))) {
            lsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
        }
        ArrayList<QFilter> allFilter = new ArrayList<QFilter>(10);
        List qFilters = e.getQFilters();
        allFilter.addAll(qFilters);
        this.addUserEnableFilter(allFilter);
        List customQFilters = e.getCustomQFilters();
        allFilter.addAll(customQFilters);
        allFilter.add(new QFilter("id", "not in", (Object)Sets.newHashSet((Object[])new Long[]{1L, 2L, 3L, 10L})));
        QFilter adminChargeUsersFilter = UserUtils.getAdminChargeUsersFilter((long)currUserId, (ListShowParameter)lsp, (IPageCache)this.getPageCache());
        if (adminChargeUsersFilter != null) {
            allFilter.add(adminChargeUsersFilter);
        }
        e.setCustomQFilters(allFilter);
        e.setQFilters(new ArrayList(1));
    }

    protected void addUserEnableFilter(List<QFilter> qFilters) {
        BillList billList = (BillList)this.getControl("billlistap");
        List listFields = billList.getListFields();
        if (CollectionUtils.isEmpty((Collection)listFields)) {
            return;
        }
        boolean hasEnableField = false;
        for (ListField listField : listFields) {
            if (!"enable".equals(listField.getListFieldKey())) continue;
            hasEnableField = true;
            break;
        }
        if (!hasEnableField) {
            qFilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        TreeView userGroupTree = (TreeView)this.getControl(TREE_USERGROUP);
        if (CONFIRMCALLBACK_DELUSERGROUP.equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                String strNodeId = this.getView().getPageCache().get("focusNodeId");
                if (StringUtils.isEmpty((String)strNodeId)) {
                    strNodeId = userGroupTree.getTreeState().getFocusNodeId();
                }
                if (strNodeId.equals(ID_ROOTNODE)) {
                    return;
                }
                strNodeId = strNodeId.split("-")[0];
                Long nodeId = Long.parseLong(strNodeId);
                try (TXHandle h = TX.required();){
                    try {
                        UserGroupService.deleteUsrGrpRelatedData((Long)nodeId);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"UserGroupTreeListPlugin_28", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                    catch (Exception e) {
                        logger.warn("\u5220\u9664\u7528\u6237\u7ec4\u5931\u8d25", (Throwable)e);
                        h.markRollback();
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"UserGroupTreeListPlugin_29", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                }
                UserGroupService.initTree((TreeView)((TreeView)this.getControl(TREE_USERGROUP)), (String)ID_ROOTNODE, (Long)Long.valueOf((String)this.getModel().getValue("usrgrpstd")));
            }
        } else if (CONFIRMCALLBACK_CLEARPERM.equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                BillList billList = (BillList)this.getControl("billlistap");
                if (billList == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u201c\u7528\u6237\u201d\u3002", (String)"UserGroupTreeListPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows == null || selectedRows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u201c\u7528\u6237\u201d\u3002", (String)"UserGroupTreeListPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                Long userId = Long.valueOf(selectedRows.get(0).toString());
                Set editingPermUserId = UserHelper.getEditingPermUserId();
                if (editingPermUserId.contains(userId + "")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6e05\u9664\u5931\u8d25\uff0c\u5982\u9700\u201c\u6e05\u9664\u6743\u9650\u201d\u8bf7\u5148\u5173\u95ed\u8be5\u7528\u6237\u7684\u6388\u6743\u754c\u9762\u3002", (String)"UserGroupTreeListPlugin_30", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                String name = selectedRows.get(0).getName();
                String userNumber = selectedRows.get(0).getNumber();
                ArrayList<Long> userIDs = new ArrayList<Long>(1);
                userIDs.add(userId);
                StringBuilder errorInfo = new StringBuilder();
                boolean isSuccess = PermissionServiceHelper.deleteUserPermission(userIDs, (StringBuilder)errorInfo);
                if (isSuccess) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"UserGroupTreeListPlugin_31", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    String curLogAppId = AppHelper.getCurAppId((String)"perm_userperm", (String)this.getView().getFormShowParameter().getAppId());
                    MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u6e05\u9664\u6743\u9650", "UserGroupTreeListPlugin_32", SYSTEM_TYPE);
                    MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u6e05\u9664\u7528\u6237\uff1a%1$s\uff08id = %2$s\uff09\u6240\u6709\u6743\u9650\u914d\u7f6e\uff0c\u6210\u529f", "UserGroupTreeListPlugin_34", SYSTEM_TYPE);
                    String[] opDescParam = new String[]{name, String.valueOf(userId)};
                    String oldOpDescription = String.format(ResManager.loadKDString((String)"\u6e05\u9664\u7528\u6237\uff1a%1$s\uff08id = %2$s\uff09\u6240\u6709\u6743\u9650\u914d\u7f6e\uff0c\u6210\u529f", (String)"UserGroupTreeListPlugin_34", (String)SYSTEM_TYPE, (Object[])new Object[0]), name, userId);
                    PermCommonUtil.addLog(null, null, (String)"perm_userperm", (String)userNumber, (String)"1", (String)BARITEM_CLEARPERM, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
                    if (PermCommonUtil.isEnablePermLog()) {
                        String langStr = RequestContext.get().getLang().name();
                        String afterData = PermDirectLogHelper.clearPermSaveImage((Long)userId, (String)langStr, (boolean)true);
                        String opbtn = ConstantsHelper.getClearPerm();
                        this.clearPermSave2PermLog(BARITEM_CLEARPERM, opbtn, String.valueOf(userId), userNumber, name, "", afterData);
                    }
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002", (String)"UserGroupTreeListPlugin_35", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    String oldOpDescription = String.format(ResManager.loadKDString((String)"\u6e05\u9664\u7528\u6237\uff1a%1$s\uff08id = %2$s\uff09\u6240\u6709\u6743\u9650\u914d\u7f6e\uff0c\u5931\u8d25", (String)"UserGroupTreeListPlugin_36", (String)SYSTEM_TYPE, (Object[])new Object[0]), name, userId);
                    logger.warn(oldOpDescription);
                    String curLogAppId = AppHelper.getCurAppId((String)"perm_userperm", (String)this.getView().getFormShowParameter().getAppId());
                    MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u6e05\u9664\u6743\u9650", "UserGroupTreeListPlugin_32", SYSTEM_TYPE);
                    MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u6e05\u9664\u7528\u6237\uff1a%1$s\uff08id = %2$s\uff09\u6240\u6709\u6743\u9650\u914d\u7f6e\uff0c\u5931\u8d25", "UserGroupTreeListPlugin_36", SYSTEM_TYPE);
                    String[] opDescParam = new String[]{name, String.valueOf(userId)};
                    PermCommonUtil.addLog(null, null, (String)"perm_userperm", (String)userNumber, (String)"0", (String)BARITEM_CLEARPERM, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
                }
            }
        } else if (Objects.equals("RESETPSSW", callBackId) && event.getResult() == MessageBoxResult.Yes && PermCommonUtil.permResetInitPwd()) {
            BillList billList = (BillList)this.getControl("billlistap");
            if (billList == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u201c\u7528\u6237\u201d\u3002", (String)"UserGroupTreeListPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows == null || selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u201c\u7528\u6237\u201d\u3002", (String)"UserGroupTreeListPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            Set userIdSet = selectedRows.stream().map(x -> (Long)x.getPrimaryKeyValue()).collect(Collectors.toSet());
            Map userInfoMap = UserHelper.getUserInfoMapByIds(userIdSet, (String)RequestContext.get().getLang().name());
            PermResult resetPsswPermResult = UserHelper.resetPssw((Map)userInfoMap);
            String resetPsswMsg = resetPsswPermResult.getMsg();
            if (resetPsswPermResult.isOk()) {
                this.getView().showSuccessNotification(resetPsswMsg, Integer.valueOf(10000));
            } else {
                this.getView().showTipNotification(resetPsswMsg, Integer.valueOf(10000));
            }
            ArrayList<StringBuilder> sblogList = new ArrayList<StringBuilder>(userInfoMap.size());
            StringBuilder sb = new StringBuilder();
            String full_phoneemail = ResManager.loadKDString((String)"\u7528\u6237\u624b\u673a\u548c\u90ae\u7bb1\u5747\u672a\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u901a\u8fc7\u627e\u56de\u5bc6\u7801\u8bbe\u7f6e\u65b0\u5bc6\u7801\uff0c\u8bf7\u8865\u5145\u624b\u673a\u6216\u90ae\u7bb1\u4fe1\u606f\u3002", (String)"UserGroupTreeListPlugin_37", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            sb.append(full_phoneemail);
            int noPhoneAndEmailCount = 0;
            for (Map.Entry userInfo : userInfoMap.entrySet()) {
                User value = (User)userInfo.getValue();
                if (null == value) continue;
                String ftruename = value.getFtruename();
                String fnumber = value.getFnumber();
                sblogList.add(new StringBuilder().append("\n").append(ftruename).append("  ").append(fnumber));
                sb.append("\n");
                String fphone = value.getFphone();
                String femail = value.getFemail();
                if (!StringUtils.isEmpty((String)fphone) || !StringUtils.isEmpty((String)femail)) continue;
                sb.append(ftruename).append("  ").append(fnumber);
                ++noPhoneAndEmailCount;
            }
            if (Objects.equals(1, userIdSet.size()) && noPhoneAndEmailCount > 0) {
                this.getView().showTipNotification(full_phoneemail, Integer.valueOf(15000));
            } else if (noPhoneAndEmailCount > 0) {
                this.getView().showTipNotification(sb.toString(), Integer.valueOf(15000));
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String appId = null == formShowParameter || StringUtils.isEmpty((String)formShowParameter.getAppId()) ? "0XWTKVOQW+ML" : formShowParameter.getAppId();
            for (StringBuilder sblog : sblogList) {
                MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u91cd\u7f6e\u5bc6\u7801", "UserGroupTreeListPlugin_38", SYSTEM_TYPE);
                MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge(" \u91cd\u7f6e\u5bc6\u7801\u6210\u529f\u3002\u7528\u6237\u5982\u4e0b\uff1a%s\u3002", "UserGroupTreeListPlugin_39", SYSTEM_TYPE);
                String[] opDescParam = new String[]{sblog.toString()};
                String oldOpDescription = ResManager.loadKDString((String)"\u91cd\u7f6e\u5bc6\u7801\u6210\u529f\u3002\u7528\u6237\u5982\u4e0b\uff1a%s", (String)"UserGroupTreeListPlugin_39", (String)SYSTEM_TYPE, (Object[])new Object[]{sblog.toString()});
                PermCommonUtil.addLog(null, null, (String)"bos_usergroup_user", null, (String)"1", (String)BTN_RESETPWD, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)appId);
            }
        }
    }

    private void clearPermSave2PermLog(String op, String opbtn, String opItemId, String opItemNumber, String opItemName, String preData, String afterData) {
        try {
            String formNum = "perm_user_assignperm";
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"userclearperm_save");
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.plugin.UserGroupTreeListPlugin.clearPermSave2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("pre_data", preData);
            map.put("after_data", afterData);
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("UserGroupTreeListPlugin.clearPermSave2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private QFilter getSearchFilter() {
        FilterContainer fc = (FilterContainer)this.getControl(CTRL_FILTERCONTAINER);
        FilterContainerFilterValues filterContainerAp = fc.getCachedFilterValues();
        FilterKeyValueCollections fastFilterFilterKeyValueCollections = filterContainerAp.getFastFilterValues();
        if (fastFilterFilterKeyValueCollections != null) {
            List fastFilterValues = fastFilterFilterKeyValueCollections.createFilterValuesList();
            if (CollectionUtils.isEmpty((Collection)fastFilterValues)) {
                return null;
            }
            Map map = (Map)fastFilterValues.get(0);
            List fieldNames = (List)map.get("FieldName");
            List values = (List)map.get("Value");
            if (fieldNames == null || fieldNames.size() == 0) {
                return null;
            }
            if (values == null || values.size() == 0) {
                return null;
            }
            QFilter qFilter = null;
            for (Object fieldName : fieldNames) {
                QFilter curFilter = new QFilter(fieldName.toString(), "like", (Object)("%" + values.get(0) + "%"));
                if (qFilter == null) {
                    qFilter = curFilter;
                    continue;
                }
                qFilter = qFilter.or(curFilter);
            }
            return qFilter;
        }
        return null;
    }

    public void click(SearchClickEvent e) {
        long curUserId = RequestContext.get().getCurrUserId();
        Object source = e.getSource();
        if (source instanceof FilterContainer) {
            List fastQFilters = e.getFastQFilters();
            if (!CollectionUtils.isEmpty((Collection)fastQFilters)) {
                this.getPageCache().put("isSearchMode", "1");
            } else {
                this.getPageCache().remove("isSearchMode");
            }
            FormShowParameter fsp = this.getView().getFormShowParameter();
            boolean isLookUp = false;
            if (fsp instanceof ListShowParameter) {
                isLookUp = ((ListShowParameter)fsp).isLookUp();
            }
            if (isLookUp) {
                return;
            }
            String showFormSpecial = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
            boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)curUserId);
            if (StringUtils.isEmpty((String)showFormSpecial) && !isAdminUser) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_40", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = this.getSearchFilter();
            if (qFilter == null) {
                return;
            }
        }
    }

    private static AppLogInfo wrapLogInfo(String bizAppId, String bizObjId, String opName, String message, Long orgId) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID(bizAppId);
        logInfo.setBizObjID(bizObjId);
        logInfo.setOrgID(orgId);
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(message);
        return logInfo;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("CloseCallBack_usrgrpAssignUser".equals(actionId)) {
            String focusNodeId = this.getView().getPageCache().get("focusNodeId");
            String parentId = this.getView().getPageCache().get("focusNodeParentId");
            TreeView tree = (TreeView)this.getControl(TREE_USERGROUP);
            if (StringUtils.isNotEmpty((String)focusNodeId) && StringUtils.isNotEmpty((String)parentId)) {
                tree.treeNodeClick(parentId, focusNodeId);
            } else {
                tree.treeNodeClick("", ID_ROOTNODE);
            }
        } else if (PSW_SETTING.equals(actionId)) {
            Object returnDataObj = e.getReturnData();
            if (returnDataObj != null) {
                this.getView().showSuccessNotification(returnDataObj.toString());
            }
        } else if (BTN_USERPERIOD.equals(actionId) && (returnData = e.getReturnData()) instanceof OperationResult) {
            OperationResult operationResult = (OperationResult)returnData;
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7528\u6237\u65f6\u6548\u8bbe\u7f6e\u6210\u529f\u3002", (String)"UserGroupTreeListPlugin_42", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(operationResult);
            }
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
        }
    }

    private void refresh() {
        this.getPageCache().remove("isSearchMode");
        TreeView tree = (TreeView)this.getControl(TREE_USERGROUP);
        boolean notPermPage = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam(FORMSHOWPARAMETER_NOTPERMPAGE));
        String focusNodeId = this.getView().getPageCache().get("focusNodeId");
        String parentId = this.getView().getPageCache().get("focusNodeParentId");
        if (notPermPage) {
            String curUsrGrpStd = (String)this.getModel().getValue("usrgrpstd");
            ComboEdit comboEdit = (ComboEdit)this.getControl("usrgrpstd");
            comboEdit.setMustInput(true);
            List usrGrpStds = UserGroupService.getAllUsrGrpStd();
            comboEdit.setComboItems(usrGrpStds);
            boolean curUsrGrpStdStillExists = false;
            for (ComboItem item : usrGrpStds) {
                if (!curUsrGrpStd.equals(item.getValue())) continue;
                curUsrGrpStdStillExists = true;
                break;
            }
            if (curUsrGrpStdStillExists) {
                this.getModel().setValue("usrgrpstd", (Object)curUsrGrpStd);
                UserGroupService.initTree((TreeView)tree, (String)ID_ROOTNODE, (Long)Long.valueOf(curUsrGrpStd));
            } else {
                this.getModel().setValue("usrgrpstd", (Object)"1404221671421785088");
                UserGroupService.initTree((TreeView)tree, (String)ID_ROOTNODE);
            }
        } else {
            this.getModel().setValue("usrgrpstd", (Object)"1404221671421785088");
            UserGroupService.initTree((TreeView)tree, (String)ID_ROOTNODE, null, (boolean)true);
        }
        if (StringUtils.isNotEmpty((String)focusNodeId) && StringUtils.isNotEmpty((String)parentId)) {
            tree.treeNodeClick(parentId, focusNodeId);
        } else {
            tree.treeNodeClick("", ID_ROOTNODE);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        FilterContainer fc = (FilterContainer)this.getControl(CTRL_FILTERCONTAINER);
        fc.clearFast();
        this.getPageCache().remove("isSearchMode");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean notPermPage = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam(FORMSHOWPARAMETER_NOTPERMPAGE));
        if (notPermPage) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BARITEM_ASSIGNROLE, BARITEM_ASSIGNROLEMULTI, BARITEM_ASSIGN_COMROLELIST, BARITEM_ASSIGN_BUSIROLELIST, BARITEM_USERDIRECTLIST, BARITEM_USERDIRECTDISLIST, BARITEM_ASSIGN_BIZROLE, BARITEM_ASSIGNPERM, BARITEM_ASSIGNPERMMULTI, BARITEM_COPYPERM, BARITEM_CLEARCACHE, BARITEM_SHARE, BARITEM_UNLOCK, BTN_RESETPWD, BTN_PWDSTRATEGY, BARITEM_CLEARPERM, BARITEM_SUBDISABLE});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"usrgrpstd"});
        }
    }

    public void initialize() {
        super.initialize();
        String dimType = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimension");
        if (IsoDimHelper.checkAuthInSysTree((String)dimType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BARITEM_ASSIGNPERM});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BARITEM_ASSIGNROLE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BARITEM_ASSIGNPERMMULTI});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BARITEM_ASSIGNROLEMULTI});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BARITEM_ASSIGNPERMMULTI});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BARITEM_ASSIGNROLEMULTI});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BARITEM_ASSIGNPERM});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BARITEM_ASSIGNROLE});
        }
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        boolean notPermPage = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam(FORMSHOWPARAMETER_NOTPERMPAGE));
        if (notPermPage) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
        }
    }

    private Object[] getSelectedRealRows() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        return billList.getSelectedRows().getPrimaryKeyValues();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        this.getView().getPageCache().put(FORMSHOWPARAMETER_NOTPERMPAGE, (String)this.getView().getFormShowParameter().getCustomParam(FORMSHOWPARAMETER_NOTPERMPAGE));
        FormShowParameter fsp = this.getView().getFormShowParameter();
        ListShowParameter lsp = (ListShowParameter)fsp;
        if (!lsp.isLookUp()) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            Object focusRowPkId = billList.getFocusRowPkId();
            if (null == focusRowPkId || Objects.equals(focusRowPkId, 0)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u201c\u7528\u6237\u201d\u3002", (String)"UserGroupTreeListPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            PermCommonUtil.checkRobots((Long)((Long)focusRowPkId), (String)ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u76f4\u63a5\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            String pageId = this.getView().getPageId();
            String newPageId = pageId + "|" + "perm_direct_perm_multi" + "|" + focusRowPkId;
            IFormView iformView = this.getView().getViewNoPlugin(newPageId);
            if (iformView != null) {
                PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
                args.setCancel(true);
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("paramUserId", String.valueOf(focusRowPkId));
            Map customParamsFromFsp = this.getView().getFormShowParameter().getCustomParams();
            params.putAll(customParamsFromFsp);
            String formId = "perm_direct_perm_multi";
            if (customParamsFromFsp.get("FormShowParam_dimension") == null) {
                params.put("FormShowParam_dimension", "DIM_ORG");
            } else if (customParamsFromFsp.get("FormShowParam_dimension") != "DIM_ORG") {
                formId = "perm_user_assignperm";
            }
            Long adminId = RequestContext.get().getCurrUserId();
            if (adminId.toString().equals(params.get("paramUserId"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.showDynamicFormByOper(formId, params, null, ShowType.MainNewTabPage, null);
            args.setCancel(true);
        }
    }

    static {
        logger = LogFactory.getLog(UserGroupTreeListPlugin.class);
        NEED_SELECT_USER_ITEM = new ArrayList<String>(16);
        NEED_SELECT_USER_ITEM.add(BARITEM_USERASSIGNUSRGRP);
        NEED_SELECT_USER_ITEM.add(BARITEM_ASSIGNROLE);
        NEED_SELECT_USER_ITEM.add(BARITEM_ASSIGNROLEMULTI);
        NEED_SELECT_USER_ITEM.add(BARITEM_ASSIGN_BIZROLE);
        NEED_SELECT_USER_ITEM.add(BARITEM_ASSIGNPERM);
        NEED_SELECT_USER_ITEM.add(BARITEM_ASSIGNPERMMULTI);
        NEED_SELECT_USER_ITEM.add(BTN_DIRECTDISFUN);
        NEED_SELECT_USER_ITEM.add(BTN_DIRECTDISFUNMULTI);
        NEED_SELECT_USER_ITEM.add(BARITEM_COPYPERM);
        NEED_SELECT_USER_ITEM.add(BARITEM_SHARE);
        NEED_SELECT_USER_ITEM.add(BARITEM_UNLOCK);
        NEED_SELECT_USER_ITEM.add(BTN_RESETPWD);
        NEED_SELECT_USER_ITEM.add(BTN_PWDSTRATEGY);
        NEED_SELECT_USER_ITEM.add(BARITEM_SUBDISABLE);
        NEED_SELECT_USER_ITEM.add(BARITEM_SUBENABLE);
        NEED_SELECT_USER_ITEM.add(BARITEM_CLEARPERM);
        NEED_SELECT_USER_ITEM.add(BTN_USERPERIOD);
    }
}

