/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.service.EventCenterService;
import kd.bos.permission.service.UserGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class UserGroupUserSyncRuleNewPlugin
extends AbstractFormPlugin
implements TabSelectListener,
RowClickEventListener,
IBillPlugin {
    private static final Log logger = LogFactory.getLog(UserGroupUserSyncRuleNewPlugin.class);
    private static final String BTN_REFRESH = "tblrefresh";
    private static final String SOURCE_ENTITY = "source_entity";
    private static final String TIPS_FLEX_1 = "tipsflex1";
    private static final String TIPS_FLEX_2 = "tipsflex2";
    private static final String SYNC_CONFIG = "syncruleconfig";
    private static final String USER_CONFIG = "userconfig";
    private static final String CUSTOMER_CONFIG = "customerconfig";
    private static final String USER_CONFIG_EG = "userconfigeg";
    private static final String CUSTOMER_CONFIG_EG = "customerconfigeg";
    private static final String USER_CONFIG_TYPE = "1";
    private static final String CUSTOMER_CONFIG_TYPE = "2";
    private static final String ENTITY_NUM = "bos_usrgrp";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.setBillFormId(ENTITY_NUM);
        this.addClickListeners(new String[]{"btnsave", "btndel", "btnclear"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        TextEdit userGrpRefFieldName = (TextEdit)this.getControl("usergrpreffieldname");
        userGrpRefFieldName.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                UserGroupUserSyncRuleNewPlugin.this.showFieldPage("bos_user", "user_group_sync_rule");
            }
        });
        TextEdit grpRefFieldName = (TextEdit)this.getControl("cusgrpreffieldname");
        grpRefFieldName.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                DynamicObject sourceEntity = (DynamicObject)UserGroupUserSyncRuleNewPlugin.this.getModel().getValue(UserGroupUserSyncRuleNewPlugin.SOURCE_ENTITY);
                if (sourceEntity == null) {
                    UserGroupUserSyncRuleNewPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u57fa\u7840\u8d44\u6599\u201d\u3002", (String)"UserGroupUserSyncRuleNewPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                String number = sourceEntity.getString("number");
                if (StringUtils.isNotEmpty((String)number)) {
                    UserGroupUserSyncRuleNewPlugin.this.showFieldPage(number, "user_group_sync_rule");
                }
            }
        });
        TextEdit userGrpRefValueName = (TextEdit)this.getControl("usergrprefvaluename");
        userGrpRefValueName.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                String grpRefFieldName = (String)UserGroupUserSyncRuleNewPlugin.this.getModel().getValue("usergrpreffieldname");
                String grpRefBdType = (String)UserGroupUserSyncRuleNewPlugin.this.getModel().getValue("usergrprefbdtype");
                if (StringUtils.isEmpty((String)grpRefFieldName)) {
                    UserGroupUserSyncRuleNewPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5206\u7ec4\u5b57\u6bb5\u201d\u3002", (String)"UserGroupUserSyncRuleNewPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                } else {
                    UserGroupUserSyncRuleNewPlugin.this.showValuePage(grpRefBdType);
                }
            }
        });
        TextEdit grpRefValueName = (TextEdit)this.getControl("cusgrprefvaluename");
        grpRefValueName.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                String grpRefFieldName = (String)UserGroupUserSyncRuleNewPlugin.this.getModel().getValue("cusgrpreffieldname");
                String grpRefBdType = (String)UserGroupUserSyncRuleNewPlugin.this.getModel().getValue("cusgrprefbdtype");
                if (StringUtils.isEmpty((String)grpRefFieldName)) {
                    UserGroupUserSyncRuleNewPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u57fa\u7840\u8d44\u6599\u201d\u3002", (String)"UserGroupUserSyncRuleNewPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                } else {
                    UserGroupUserSyncRuleNewPlugin.this.showValuePage(grpRefBdType);
                }
            }
        });
        TextEdit operationName = (TextEdit)this.getControl("operationname");
        operationName.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                DynamicObject sourceEntity = (DynamicObject)UserGroupUserSyncRuleNewPlugin.this.getModel().getValue(UserGroupUserSyncRuleNewPlugin.SOURCE_ENTITY);
                if (sourceEntity == null) {
                    UserGroupUserSyncRuleNewPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u57fa\u7840\u8d44\u6599\u201d\u3002", (String)"UserGroupUserSyncRuleNewPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                String number = sourceEntity.getString("number");
                if (StringUtils.isNotEmpty((String)number)) {
                    UserGroupUserSyncRuleNewPlugin.this.showFieldPage(number, "event_listen");
                }
            }
        });
        TextEdit userFieldName = (TextEdit)this.getControl("userfieldname");
        userFieldName.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                DynamicObject sourceEntity = (DynamicObject)UserGroupUserSyncRuleNewPlugin.this.getModel().getValue(UserGroupUserSyncRuleNewPlugin.SOURCE_ENTITY);
                if (sourceEntity == null) {
                    UserGroupUserSyncRuleNewPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u57fa\u7840\u8d44\u6599\u201d\u3002", (String)"UserGroupUserSyncRuleNewPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                String number = sourceEntity.getString("number");
                if (StringUtils.isNotEmpty((String)number)) {
                    UserGroupUserSyncRuleNewPlugin.this.showFieldPage(number, "user_group_source_field");
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Object customParam_usrGrpStdId = this.getView().getFormShowParameter().getCustomParams().get("usrGrpStdId");
        this.getView().getPageCache().put("pageCache_selectedTab", String.valueOf(customParam_usrGrpStdId));
        this.getView().setVisible(Boolean.FALSE, new String[]{SYNC_CONFIG, "usergrpreffieldkey", "usergrprefbdtype", "usergrprefvalue", "cusgrpreffieldkey", "cusgrprefbdtype", "cusgrprefvalue", "userfieldkey", "operationkey", "cusgrpreffieldname"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        UserGroupService.initTab((Tab)((Tab)this.getControl("tabap")), (IFormView)this.getView());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        treeEntryGrid.addRowClickListener((RowClickEventListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addSearchClickListener(searchClickEvent -> {
            List fastFilterValues = searchClickEvent.getFastFilterValues();
            if (CollectionUtils.isEmpty((Collection)fastFilterValues)) {
                this.getPageCache().remove("pageCache_isSearchMode");
                this.refresh();
                return;
            }
            QFilter[] qFilters = new QFilter[fastFilterValues.size()];
            for (int index = 0; index < fastFilterValues.size(); ++index) {
                Map fastFilterValue = (Map)fastFilterValues.get(index);
                List fieldNameList = (List)fastFilterValue.get("FieldName");
                List valueList = (List)fastFilterValue.get("Value");
                if (CollectionUtils.isEmpty((Collection)fieldNameList) || CollectionUtils.isEmpty((Collection)valueList)) continue;
                QFilter qFilter = new QFilter(USER_CONFIG_TYPE, "=", (Object)0);
                for (Object fieldName : fieldNameList) {
                    for (Object value : valueList) {
                        qFilter.or(String.valueOf(fieldName), "like", (Object)("%" + value + "%"));
                    }
                }
                qFilters[index] = qFilter;
            }
            if (qFilters.length == 0) {
                this.getPageCache().remove("pageCache_isSearchMode");
                this.refresh();
                return;
            }
            this.getModel().beginInit();
            this.getModel().deleteEntryData("treeentryentity");
            TableValueSetter vs = new TableValueSetter(new String[]{"id", "pid", "usrgrp"});
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NUM, (String)"id", (QFilter[])qFilters);
            ArrayList<Long> searchIdsList = new ArrayList<Long>(dynamicObjects.length);
            for (DynamicObject dynamicObject : dynamicObjects) {
                long id = dynamicObject.getLong("id");
                searchIdsList.add(id);
                vs.addRow(new Object[]{id, "0", id});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("treeentryentity", vs);
            this.getModel().endInit();
            this.getView().setVisible(Boolean.FALSE, new String[]{TIPS_FLEX_1, SYNC_CONFIG});
            this.getView().setVisible(Boolean.TRUE, new String[]{TIPS_FLEX_2});
            this.getView().updateView("treeentryentity");
            this.getPageCache().put("pageCache_searchResultIds", JSON.toJSONString(searchIdsList));
            UserGroupService.addSearchTab((Tab)((Tab)this.getControl("tabap")), (IFormView)this.getView());
        });
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_REFRESH.equals(itemKey)) {
            Tab tab = (Tab)this.getControl("tabap");
            FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
            fc.clearFast();
            this.getView().getPageCache().remove("pageCache_isSearchMode");
            this.getPageCache().remove("pageCache_selectedTab");
            UserGroupService.initTab((Tab)tab, (IFormView)this.getView());
        }
    }

    public void click(EventObject evt) {
        Button btn;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && "btnclear".equals(key = (btn = (Button)source).getKey())) {
            String clickUsrGrp = this.getPageCache().get("pageCache_clickUsrGrp");
            if (StringUtils.isEmpty((String)clickUsrGrp)) {
                return;
            }
            Long usrGrpId = Long.valueOf(clickUsrGrp);
            if (!this.checkDataExist(usrGrpId)) {
                return;
            }
            this.clearSyncConfig();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        String clickUsrGrp = this.getPageCache().get("pageCache_clickUsrGrp");
        if (e.getOperationResult().isSuccess()) {
            if ("donothing_save".equals(opKey)) {
                if (!this.checkDataExist(Long.valueOf(clickUsrGrp))) {
                    return;
                }
                this.save();
            } else if ("donothing_del".equals(opKey)) {
                if (!this.checkDataExist(Long.valueOf(clickUsrGrp))) {
                    return;
                }
                String emptyConfig = this.getPageCache().get("empty_config");
                if (StringUtils.isNotEmpty((String)emptyConfig)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u7ec4\u672a\u8bbe\u7f6e\u540c\u6b65\u89c4\u5219\u3002", (String)"UserGroupUserSyncRuleNewPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540c\u6b65\u89c4\u5219\u914d\u7f6e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"UserGroupUserSyncRuleNewPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("del_sync_rule", (IFormPlugin)this));
            }
        }
    }

    private void save() {
        DynamicObject syncRule = BusinessDataServiceHelper.newDynamicObject((String)"perm_usrgrpsync_rule");
        Long usrGrpId = Long.parseLong(this.getPageCache().get("pageCache_clickUsrGrp"));
        syncRule.set("usergroup", (Object)usrGrpId);
        syncRule.set("iscomplexrule", (Object)false);
        String ruleConfigType = (String)this.getModel().getValue("radiogroupfield");
        if (USER_CONFIG_TYPE.equals(ruleConfigType)) {
            String grpRefValue = (String)this.getModel().getValue("usergrprefvalue");
            String grpRefValueName = (String)this.getModel().getValue("usergrprefvaluename");
            String grpRefDdType = (String)this.getModel().getValue("usergrprefbdtype");
            String grpRefFieldKey = (String)this.getModel().getValue("usergrpreffieldkey");
            String grpRefFieldName = (String)this.getModel().getValue("usergrpreffieldname");
            if (StringUtils.isEmpty((String)grpRefFieldKey) || StringUtils.isEmpty((String)grpRefFieldName) || StringUtils.isEmpty((String)grpRefValue) || StringUtils.isEmpty((String)grpRefValueName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u914d\u7f6e\u201c\u7528\u6237\u540c\u6b65\u89c4\u5219\u201d\u3002", (String)"UserGroupUserSyncRuleNewPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            syncRule.set("ruleconftype", (Object)USER_CONFIG_TYPE);
            syncRule.set("oper", (Object)"save");
            syncRule.set(SOURCE_ENTITY, (Object)"bos_user");
            syncRule.set("userfieldkey", (Object)"id");
            syncRule.set("grpreffieldkey", (Object)grpRefFieldKey);
            syncRule.set("grprefbdtype", (Object)grpRefDdType);
            syncRule.set("grprefvalue", (Object)grpRefValue);
        } else if (CUSTOMER_CONFIG_TYPE.equals(ruleConfigType)) {
            syncRule.set("ruleconftype", (Object)CUSTOMER_CONFIG_TYPE);
            DynamicObject sourceEntity = (DynamicObject)this.getModel().getValue(SOURCE_ENTITY);
            if (sourceEntity == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u914d\u7f6e\u201c\u7528\u6237\u540c\u6b65\u89c4\u5219\u201d\u3002", (String)"UserGroupUserSyncRuleNewPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            String entityNum = sourceEntity.getString("number");
            String userFieldKey = (String)this.getModel().getValue("userfieldkey");
            String operationKey = (String)this.getModel().getValue("operationkey");
            String grpRefFieldKey = (String)this.getModel().getValue("cusgrpreffieldkey");
            String grpRefFieldName = (String)this.getModel().getValue("cusgrpreffieldname");
            String grpRefDdType = (String)this.getModel().getValue("cusgrprefbdtype");
            String grpRefValue = (String)this.getModel().getValue("cusgrprefvalue");
            String grpRefValueName = (String)this.getModel().getValue("cusgrprefvaluename");
            if (StringUtils.isEmpty((String)userFieldKey) || StringUtils.isEmpty((String)grpRefValue) || StringUtils.isEmpty((String)grpRefValueName) || StringUtils.isEmpty((String)operationKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u914d\u7f6e\u201c\u7528\u6237\u540c\u6b65\u89c4\u5219\u201d\u3002", (String)"UserGroupUserSyncRuleNewPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            syncRule.set(SOURCE_ENTITY, (Object)entityNum);
            syncRule.set("userfieldkey", (Object)userFieldKey);
            syncRule.set("oper", (Object)operationKey);
            syncRule.set("grpreffieldkey", (Object)"id");
            syncRule.set("grprefbdtype", (Object)grpRefDdType);
            syncRule.set("grprefvalue", (Object)grpRefValue);
        }
        DynamicObject userGroup = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NUM, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)usrGrpId)});
        userGroup.set("seted_usrsycrule", (Object)true);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{userGroup});
        DeleteServiceHelper.delete((String)"perm_usrgrpsync_rule", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)usrGrpId)});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncRule});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserGroupUserSyncRuleNewPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        String uGNumber = userGroup.getString("number");
        String appId = AppHelper.getCurAppId((String)"perm_usrgrpsyncrule_new", (String)this.getView().getFormShowParameter().getAppId());
        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "UserGroupUserSyncRuleNewPlugin_17", "bos-permission-formplugin");
        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u7528\u6237\u7ec4\u4eba\u5458\u540c\u6b65\u89c4\u5219\u4fdd\u5b58\u6210\u529f", "UserGroupUserSyncRuleNewPlugin_18", "bos-permission-formplugin");
        String[] opDescParam = new String[]{};
        String oldOpDescription = ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4eba\u5458\u540c\u6b65\u89c4\u5219\u4fdd\u5b58\u6210\u529f", (String)"UserGroupUserSyncRuleNewPlugin_18", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        String opNameZh_CN = new MultiLangEnumBridge("\u4fdd\u5b58", "UserGroupUserSyncRuleNewPlugin_17", "bos-permission-formplugin").getDescription();
        PermCommonUtil.addLog((String)"", (String)opNameZh_CN, (String)"perm_usrgrpsync_rule", (String)uGNumber, (String)USER_CONFIG_TYPE, (String)"btnsave", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)appId);
        this.getPageCache().remove("empty_config");
        boolean autoCreate = (Boolean)this.getModel().getValue("autocreate");
        if (autoCreate) {
            this.autoCreateSyncRule(userGroup, syncRule);
        }
        String oldOperation = this.getPageCache().get("oldOperationKey");
        String newOperation = syncRule.getString("oper");
        EventCenterService.createListenEvent((String)syncRule.getString(SOURCE_ENTITY), (String)newOperation, (String)oldOperation);
        this.refresh();
    }

    private void refresh() {
        this.clearSyncConfig();
        String tabKey = this.getPageCache().get("pageCache_selectedTab");
        String pageCache_isSearchMode = this.getPageCache().get("pageCache_isSearchMode");
        if (StringUtils.isNotEmpty((String)pageCache_isSearchMode) && "searchresult".equals(tabKey)) {
            UserGroupService.addSearchTab((Tab)((Tab)this.getControl("tabap")), (IFormView)this.getView());
        } else {
            UserGroupService.initTab((Tab)((Tab)this.getControl("tabap")), (IFormView)this.getView());
        }
        this.clickRow();
    }

    private void clickRow() {
        String lastClickUsrGrp = this.getPageCache().get("pageCache_clickUsrGrp");
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        DynamicObject[] dataEntitys = treeEntryGrid.getEntryData().getDataEntitys();
        int length = dataEntitys.length;
        if (length > 0 && StringUtils.isNotEmpty((String)lastClickUsrGrp)) {
            Long userGroupId = Long.parseLong(lastClickUsrGrp);
            treeEntryGrid.addRowClickListener((RowClickEventListener)this);
            for (int i = 0; i < length; ++i) {
                DynamicObject dataEntity = dataEntitys[i];
                Long id = dataEntity.getLong("id");
                if (!userGroupId.equals(id)) continue;
                treeEntryGrid.entryRowClick(Integer.valueOf(i));
                treeEntryGrid.selectRows(i);
                break;
            }
        }
    }

    private void autoCreateSyncRule(DynamicObject userGroup, DynamicObject syncRule) {
        String sourceEntity = syncRule.getString(SOURCE_ENTITY);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)sourceEntity);
        DynamicProperty nameProp = entityType.getProperty("name");
        if (nameProp == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u5b57\u6bb5\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\u201c\u540d\u79f0\u201d\u5b57\u6bb5\uff0c\u65e0\u6cd5\u81ea\u52a8\u751f\u6210\u5176\u4ed6\u7ec4\u7684\u540c\u6b65\u89c4\u5219\u3002", (String)"UserGroupUserSyncRuleNewPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
        long userGroupStandardId = userGroup.getLong("usrgrpstd.id");
        Map notSetRuleGroupMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_NUM, (QFilter[])new QFilter[]{new QFilter("seted_usrsycrule", "=", (Object)false), new QFilter("usrgrpstd", "=", (Object)userGroupStandardId)});
        if (!CollectionUtils.isEmpty((Map)notSetRuleGroupMap)) {
            Set names = notSetRuleGroupMap.values().stream().map(x -> x.getString("name")).collect(Collectors.toSet());
            String grpRefDdType = syncRule.getString("grprefbdtype");
            DynamicObject[] values = BusinessDataServiceHelper.load((String)grpRefDdType, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("name", "in", names)});
            if (values.length > 0) {
                HashMap<String, Object> valueMap = new HashMap<String, Object>(values.length);
                for (DynamicObject value : values) {
                    Object id = value.get("id");
                    String name = value.getString("name");
                    valueMap.put(name, id);
                }
                IDataEntityType dataEntityType = syncRule.getDataEntityType();
                ArrayList<DynamicObject> updateGroups = new ArrayList<DynamicObject>(10);
                ArrayList<DynamicObject> addSyncRules = new ArrayList<DynamicObject>(10);
                for (Map.Entry groupEntry : notSetRuleGroupMap.entrySet()) {
                    Object groupId = groupEntry.getKey();
                    DynamicObject group = (DynamicObject)groupEntry.getValue();
                    String groupName = group.getString("name");
                    Object id = valueMap.get(groupName);
                    if (id == null) continue;
                    group.set("seted_usrsycrule", (Object)true);
                    updateGroups.add(group);
                    DynamicObject currentSyncRule = (DynamicObject)OrmUtils.clone((Object)syncRule, (IDataEntityType)dataEntityType, (boolean)false, (boolean)true);
                    currentSyncRule.set("usergroup_id", groupId);
                    currentSyncRule.set("grprefvalue", (Object)String.valueOf(id));
                    addSyncRules.add(currentSyncRule);
                }
                if (!CollectionUtils.isEmpty(addSyncRules)) {
                    SaveServiceHelper.save((DynamicObject[])addSyncRules.toArray(new DynamicObject[0]));
                }
                if (!CollectionUtils.isEmpty(updateGroups)) {
                    SaveServiceHelper.update((DynamicObject[])updateGroups.toArray(new DynamicObject[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u5c5e\u6027\u503c\u81ea\u52a8\u751f\u6210\u5176\u4ed6\u7ec4\u7684\u540c\u6b65\u89c4\u5219\u3002", (String)"UserGroupUserSyncRuleNewPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
        this.getModel().setValue("autocreate", (Object)false);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        String pageCache_isSearchMode = this.getView().getPageCache().get("pageCache_isSearchMode");
        if (StringUtils.isNotEmpty((String)pageCache_isSearchMode) && !"searchresult".equals(tabKey)) {
            this.getPageCache().put("pageCache_selectedTab", tabKey);
            FilterContainerFilterValues filterContainerAp = ((FilterContainer)this.getControl("filtercontainerap")).getCachedFilterValues();
            FilterKeyValueCollections fastFilterFilterKeyValueCollections = filterContainerAp.getFastFilterValues();
            if (fastFilterFilterKeyValueCollections != null) {
                DynamicObject[] dynamicObjects;
                List fastFilterValues = fastFilterFilterKeyValueCollections.createFilterValuesList();
                if (CollectionUtils.isEmpty((Collection)fastFilterValues)) {
                    return;
                }
                QFilter[] qFilters = new QFilter[fastFilterValues.size() + 1];
                qFilters[0] = new QFilter("usrgrpstd", "=", (Object)Long.valueOf(tabKey));
                for (int index = 0; index < fastFilterValues.size(); ++index) {
                    Map fastFilterValue = (Map)fastFilterValues.get(index);
                    List fieldNameList = (List)fastFilterValue.get("FieldName");
                    List valueList = (List)fastFilterValue.get("Value");
                    if (CollectionUtils.isEmpty((Collection)fieldNameList) || CollectionUtils.isEmpty((Collection)valueList)) continue;
                    QFilter qFilter = new QFilter(USER_CONFIG_TYPE, "=", (Object)0);
                    for (Object fieldName : fieldNameList) {
                        for (Object value : valueList) {
                            qFilter.or(String.valueOf(fieldName), "like", (Object)("%" + value + "%"));
                        }
                    }
                    qFilters[index + 1] = qFilter;
                }
                if (qFilters.length == 1) {
                    return;
                }
                this.getModel().beginInit();
                this.getModel().deleteEntryData("treeentryentity");
                TableValueSetter vs = new TableValueSetter(new String[]{"id", "pid", "usrgrp"});
                for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NUM, (String)"id", (QFilter[])qFilters)) {
                    long id = dynamicObject.getLong("id");
                    vs.addRow(new Object[]{id, "0", id});
                }
                ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("treeentryentity", vs);
                this.getModel().endInit();
                this.getView().updateView("treeentryentity");
            }
        } else {
            UserGroupService.tabSelected((String)tabKey, (IFormView)this.getView(), (IDataModel)this.getModel());
        }
        this.getModel().setValue("autocreate", (Object)false);
        if ("1404221671421785088".equals(tabKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TIPS_FLEX_2, SYNC_CONFIG});
            this.getView().setVisible(Boolean.TRUE, new String[]{TIPS_FLEX_1});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TIPS_FLEX_1, SYNC_CONFIG});
            this.getView().setVisible(Boolean.TRUE, new String[]{TIPS_FLEX_2});
        }
        this.getView().updateView("splitpanelap1");
        this.getPageCache().remove("empty_config");
        this.getPageCache().remove("oldOperationKey");
        this.clickRow();
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        evt.getSource();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        DynamicObject[] dataEntitys = treeEntryGrid.getEntryData().getDataEntitys();
        int length = dataEntitys.length;
        if (row == -1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TIPS_FLEX_1, SYNC_CONFIG});
            this.getView().setVisible(Boolean.TRUE, new String[]{TIPS_FLEX_2});
            return;
        }
        if (row > length - 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"UserGroupUserSyncRuleNewPlugin_8", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            this.refresh();
            return;
        }
        DynamicObject dataEntity = dataEntitys[row];
        Long usrGrpId = dataEntity.getLong("id");
        if (!this.checkDataExist(usrGrpId)) {
            return;
        }
        Long userGroupStandard = dataEntity.getDynamicObject("usrgrp").getLong("usrgrpstd.id");
        if (PermHelperConst.NOTCLASSIFY_STDID.equals(userGroupStandard)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TIPS_FLEX_2, SYNC_CONFIG});
            this.getView().setVisible(Boolean.TRUE, new String[]{TIPS_FLEX_1});
            return;
        }
        this.clearSyncConfig();
        this.getPageCache().put("pageCache_clickUsrGrp", usrGrpId + "");
        String usrGrpName = dataEntity.getDynamicObject("usrgrp").getString("name");
        this.getView().setVisible(Boolean.TRUE, new String[]{SYNC_CONFIG});
        this.getView().setVisible(Boolean.FALSE, new String[]{TIPS_FLEX_1, TIPS_FLEX_2});
        this.loadSyncRule(usrGrpId, usrGrpName, userGroupStandard);
        String afterDelete = this.getPageCache().get("afterDelete");
        if (StringUtils.isNotEmpty((String)afterDelete)) {
            this.getView().updateView("treeentryentity");
            this.getPageCache().remove("afterDelete");
        }
    }

    private void loadSyncRule(Long usrGrpId, String usrGrpName, Long userGroupStandard) {
        DynamicObject syncRule = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_usrgrpsync_rule", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)usrGrpId)});
        Label userConfigGroup = (Label)this.getControl("usrcfgrp");
        userConfigGroup.setText(usrGrpName);
        Label customerConfigGroup = (Label)this.getControl("cuscfgrp");
        customerConfigGroup.setText(usrGrpName);
        if (syncRule != null) {
            this.getPageCache().remove("empty_config");
            this.getPageCache().put("oldOperationKey", syncRule.getString("oper"));
            String ruleConfType = syncRule.getString("ruleconftype");
            if (StringUtils.isNotEmpty((String)ruleConfType)) {
                this.getModel().setValue("radiogroupfield", (Object)ruleConfType);
            }
            ArrayList<String> entitySourceNumber = new ArrayList<String>(10);
            String entityNum = syncRule.getString("source_entity.number");
            entitySourceNumber.add(entityNum);
            String grpRefDdType = syncRule.getString("grprefbdtype");
            String grpRefValue = syncRule.getString("grprefvalue");
            String grpRefValueName = null;
            String valueType = grpRefDdType;
            if (StringUtils.isEmpty((String)valueType) || "id".equals(valueType)) {
                valueType = entityNum;
            }
            if (StringUtils.isNotEmpty((String)grpRefValue)) {
                DynamicObjectCollection valueObjects;
                List<String> ids = Arrays.asList(grpRefValue.split(","));
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)valueType);
                int dbType = dataEntityType.getPrimaryKey().getDbType();
                if (dbType == -5) {
                    List params = ids.stream().map(Long::parseLong).collect(Collectors.toList());
                    valueObjects = QueryServiceHelper.query((String)valueType, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", params)});
                } else {
                    valueObjects = QueryServiceHelper.query((String)valueType, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                }
                List valueName = valueObjects.stream().map(x -> x.getString("name")).collect(Collectors.toList());
                grpRefValueName = String.join((CharSequence)",", valueName);
            }
            Map entityFieldMap = PermCommonUtil.getEntityBaseDataField((String)entityNum);
            String grpRefFieldKey = syncRule.getString("grpreffieldkey");
            String grpRefFieldName = (String)entityFieldMap.get(grpRefFieldKey);
            if (USER_CONFIG_TYPE.equals(ruleConfType)) {
                this.setItemClassTypeEdit("usergrprefbdtype", entitySourceNumber);
                this.getModel().setValue("usergrpreffieldkey", (Object)grpRefFieldKey);
                this.getModel().setValue("usergrpreffieldname", (Object)grpRefFieldName);
                this.getModel().setValue("usergrprefvalue", (Object)grpRefValue);
                this.getModel().setValue("usergrprefvaluename", grpRefValueName);
                this.getModel().setValue("usergrprefbdtype", (Object)grpRefDdType);
                this.getView().setVisible(Boolean.TRUE, new String[]{USER_CONFIG, USER_CONFIG_EG});
                this.getView().setVisible(Boolean.FALSE, new String[]{CUSTOMER_CONFIG, CUSTOMER_CONFIG_EG});
            } else if (CUSTOMER_CONFIG_TYPE.equals(ruleConfType)) {
                this.getModel().setValue(SOURCE_ENTITY, (Object)entityNum);
                String userFieldKey = syncRule.getString("userfieldkey");
                String userFieldName = (String)entityFieldMap.get(userFieldKey);
                this.getModel().setValue("cusgrpreffieldkey", (Object)grpRefFieldKey);
                this.getModel().setValue("cusgrpreffieldname", (Object)grpRefFieldName);
                this.getModel().setValue("cusgrprefvalue", (Object)grpRefValue);
                this.getModel().setValue("cusgrprefvaluename", (Object)grpRefValueName);
                this.getModel().setValue("userfieldkey", (Object)userFieldKey);
                this.getModel().setValue("userfieldname", (Object)userFieldName);
                this.getModel().setValue("cusgrprefbdtype", (Object)entityNum);
                String operationKey = syncRule.getString("oper");
                String operationName = EventCenterService.getOperationName((String)entityNum, (String)operationKey);
                if (StringUtils.isNotEmpty((String)operationName)) {
                    this.getModel().setValue("operationkey", (Object)operationKey);
                    this.getModel().setValue("operationname", (Object)operationName);
                }
                this.setItemClassTypeEdit("cusgrprefbdtype", entitySourceNumber);
                this.getView().setVisible(Boolean.TRUE, new String[]{CUSTOMER_CONFIG, CUSTOMER_CONFIG_EG});
                this.getView().setVisible(Boolean.FALSE, new String[]{USER_CONFIG, USER_CONFIG_EG});
            }
        } else {
            this.getPageCache().put("empty_config", "true");
            this.getPageCache().put("oldOperationKey", "");
            String sql = " SELECT TOP 1 a.fusrgrpid, a.fsrcentity, a.fuserfieldkey, a.fgrpreffieldkey, a.fgrprefbdtype, a.fruleconftype, a.foper  FROM t_perm_usrgrprel_ruleent a INNER JOIN t_sec_usergroup b ON (a.fusrgrpid = b.fid AND b.fusrgrpstdid = ?)  ORDER BY a.fmodifytime DESC ";
            Object[] params = new Object[]{userGroupStandard};
            DynamicObject lastModifySyncRule = (DynamicObject)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, rs -> {
                DynamicObject userGroupSyncRule = BusinessDataServiceHelper.newDynamicObject((String)"perm_usrgrpsync_rule");
                if (rs.next()) {
                    userGroupSyncRule.set("usergroup", (Object)rs.getLong(1));
                    userGroupSyncRule.set(SOURCE_ENTITY, (Object)rs.getString(2));
                    userGroupSyncRule.set("userfieldkey", (Object)rs.getString(3));
                    userGroupSyncRule.set("grpreffieldkey", (Object)rs.getString(4));
                    userGroupSyncRule.set("grprefbdtype", (Object)rs.getString(5));
                    userGroupSyncRule.set("ruleconftype", (Object)rs.getString(6));
                    userGroupSyncRule.set("oper", (Object)rs.getString(7));
                    return userGroupSyncRule;
                }
                return null;
            });
            String ruleConfType = (String)this.getModel().getValue("radiogroupfield");
            if (lastModifySyncRule != null) {
                ruleConfType = lastModifySyncRule.getString("ruleconftype");
                this.getModel().setValue("radiogroupfield", (Object)ruleConfType);
            }
            ArrayList<String> entitySourceNumber = new ArrayList<String>(10);
            if (USER_CONFIG_TYPE.equals(ruleConfType)) {
                entitySourceNumber.add("bos_user");
                this.setItemClassTypeEdit("usergrprefbdtype", entitySourceNumber);
                if (lastModifySyncRule != null) {
                    Map entityFieldMap = PermCommonUtil.getEntityBaseDataField((String)"bos_user");
                    String grpRefFieldKey = lastModifySyncRule.getString("grpreffieldkey");
                    String grpRefFieldName = (String)entityFieldMap.get(grpRefFieldKey);
                    this.getModel().setValue("usergrpreffieldkey", (Object)grpRefFieldKey);
                    this.getModel().setValue("usergrpreffieldname", (Object)grpRefFieldName);
                    String grpRefDdType = lastModifySyncRule.getString("grprefbdtype");
                    this.getModel().setValue("usergrprefbdtype", (Object)grpRefDdType);
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{USER_CONFIG, USER_CONFIG_EG});
                this.getView().setVisible(Boolean.FALSE, new String[]{CUSTOMER_CONFIG, CUSTOMER_CONFIG_EG});
            } else if (CUSTOMER_CONFIG_TYPE.equals(ruleConfType)) {
                if (lastModifySyncRule != null) {
                    String sourceEntity = lastModifySyncRule.getString(SOURCE_ENTITY);
                    Map entityFieldMap = PermCommonUtil.getEntityBaseDataField((String)sourceEntity);
                    this.getModel().setValue(SOURCE_ENTITY, (Object)sourceEntity);
                    entitySourceNumber.add(sourceEntity);
                    this.setItemClassTypeEdit("cusgrprefbdtype", entitySourceNumber);
                    String userFieldKey = lastModifySyncRule.getString("userfieldkey");
                    String userFieldName = (String)entityFieldMap.get(userFieldKey);
                    this.getModel().setValue("userfieldkey", (Object)userFieldKey);
                    this.getModel().setValue("userfieldname", (Object)userFieldName);
                    String grpRefFieldKey = lastModifySyncRule.getString("grpreffieldkey");
                    String grpRefFieldName = (String)entityFieldMap.get(grpRefFieldKey);
                    this.getModel().setValue("cusgrpreffieldkey", (Object)grpRefFieldKey);
                    this.getModel().setValue("cusgrpreffieldname", (Object)grpRefFieldName);
                    String grpRefDdType = lastModifySyncRule.getString("grprefbdtype");
                    this.getModel().setValue("cusgrprefbdtype", (Object)sourceEntity);
                    String operationKey = lastModifySyncRule.getString("oper");
                    String operationName = EventCenterService.getOperationName((String)sourceEntity, (String)operationKey);
                    if (StringUtils.isNotEmpty((String)operationName)) {
                        this.getModel().setValue("operationkey", (Object)operationKey);
                        this.getModel().setValue("operationname", (Object)operationName);
                    }
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{CUSTOMER_CONFIG, CUSTOMER_CONFIG_EG});
                this.getView().setVisible(Boolean.FALSE, new String[]{USER_CONFIG, USER_CONFIG_EG});
            }
        }
        this.getView().updateView(SYNC_CONFIG);
    }

    private void setItemClassTypeEdit(String controlKey, List<String> entitySourceNumber) {
        if (!CollectionUtils.isEmpty(entitySourceNumber)) {
            Set entityBaseDataType = PermCommonUtil.getEntityBaseDataType(entitySourceNumber);
            DynamicObject[] entityInfo = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"number, name", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)entityBaseDataType)});
            ItemClassTypeEdit icte = (ItemClassTypeEdit)this.getControl(controlKey);
            ArrayList<ComboItem> cboList = new ArrayList<ComboItem>(10);
            for (DynamicObject entity : entityInfo) {
                ComboItem cbi = new ComboItem(new LocaleString(entity.getLocaleString("name").getLocaleValue()), entity.getString("number"));
                cboList.add(cbi);
            }
            icte.setComboItems(cboList);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("radiogroupfield".equals(propName)) {
            String value = (String)newValue;
            if (USER_CONFIG_TYPE.equals(value)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{USER_CONFIG, USER_CONFIG_EG});
                this.getView().setVisible(Boolean.FALSE, new String[]{CUSTOMER_CONFIG, CUSTOMER_CONFIG_EG});
            } else if (CUSTOMER_CONFIG_TYPE.equals(value)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CUSTOMER_CONFIG, CUSTOMER_CONFIG_EG});
                this.getView().setVisible(Boolean.FALSE, new String[]{USER_CONFIG, USER_CONFIG_EG});
            }
            this.getView().updateView(SYNC_CONFIG);
        } else if (SOURCE_ENTITY.equals(propName)) {
            if (newValue != null) {
                DynamicObject sourceEntity = (DynamicObject)newValue;
                String entityNum = sourceEntity.getString("number");
                String entityName = sourceEntity.getString("name");
                ArrayList<String> entitySourceNumber = new ArrayList<String>(10);
                entitySourceNumber.add(entityNum);
                this.setItemClassTypeEdit("cusgrprefbdtype", entitySourceNumber);
                this.getModel().setValue("cusgrprefbdtype", (Object)entityNum);
                this.getModel().setValue("cusgrpreffieldkey", (Object)"id");
                this.getModel().setValue("cusgrpreffieldname", (Object)entityName);
            }
            this.getModel().setValue("cusgrprefvalue", null);
            this.getModel().setValue("cusgrprefvaluename", null);
            this.getModel().setValue("operationkey", null);
            this.getModel().setValue("operationname", null);
            this.getModel().setValue("userfieldkey", null);
            this.getModel().setValue("userfieldname", null);
        } else if ("usergrpreffieldname".equals(propName)) {
            this.getModel().setValue("usergrprefvalue", null);
            this.getModel().setValue("usergrprefvaluename", null);
        } else if ("cusgrpreffieldname".equals(propName)) {
            this.getModel().setValue("cusgrprefvalue", null);
            this.getModel().setValue("cusgrprefvaluename", null);
        }
    }

    private void showValuePage(String entityNum) {
        block5: {
            String lspPageId = "";
            try {
                ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entityNum, (boolean)true, (int)0, (boolean)true);
                lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chooseValue"));
                lsp.getOpenStyle().setShowType(ShowType.Modal);
                lsp.setHasRight(true);
                if ("bos_org".equals(entityNum)) {
                    lsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
                    String userGrpRefFieldKey = (String)this.getModel().getValue("usergrpreffieldkey");
                    if ("entryentity.dpt".equals(userGrpRefFieldKey)) {
                        lsp.setCustomParam("orgFuncId", (Object)"01");
                    }
                }
                this.getView().showForm((FormShowParameter)lsp);
                lspPageId = lsp.getPageId();
            }
            catch (Exception e) {
                logger.warn("UserGroupUserSyncRuleNewPlugin.showValuePage error", (Throwable)e);
                String message = e.getMessage();
                if (message.contains("not find")) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u52a0\u8f7d\u57fa\u7840\u8d44\u6599\u5217\u8868\u5931\u8d25\uff0c\u5f53\u524d\u73af\u5883\u6ca1\u6709\u5217\u8868\u4f7f\u7528\u7684\u63d2\u4ef6\uff1a%s\u3002", (String)"UserGroupUserSyncRuleNewPlugin_9", (String)"bos-permission-formplugin", (Object[])new Object[0]), message));
                }
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u52a0\u8f7d\u57fa\u7840\u8d44\u6599\u5217\u8868\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"UserGroupUserSyncRuleNewPlugin_10", (String)"bos-permission-formplugin", (Object[])new Object[0]), message));
                if (!StringUtils.isNotEmpty((String)lspPageId)) break block5;
                IFormView viewNoPlugin = this.getView().getViewNoPlugin(lspPageId);
                viewNoPlugin.close();
                this.getView().sendFormAction(viewNoPlugin);
            }
        }
    }

    private void showFieldPage(String entityNum, String type) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"perm_choosecustomfield", (boolean)false, (int)0, (boolean)true);
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setCustomParam("entityNum", (Object)entityNum);
        switch (type) {
            case "user_group_sync_rule": {
                lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chooseGrpRefField"));
                lsp.setCaption(ResManager.loadKDString((String)"\u5206\u7ec4\u5c5e\u6027", (String)"UserGroupUserSyncRuleNewPlugin_11", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                break;
            }
            case "user_group_source_field": {
                lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chooseUserField"));
                lsp.setCaption(ResManager.loadKDString((String)"\u4eba\u5458\u5c5e\u6027", (String)"UserGroupUserSyncRuleNewPlugin_12", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                break;
            }
            case "event_listen": {
                lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chooseOperation"));
                lsp.setCaption(ResManager.loadKDString((String)"\u5f85\u76d1\u542c\u64cd\u4f5c", (String)"UserGroupUserSyncRuleNewPlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
        }
        lsp.setCustomParam("show_page", (Object)type);
        lsp.setShowTitle(true);
        lsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if (callBackId.equals("del_sync_rule") && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            String clickUserGroupId = this.getPageCache().get("pageCache_clickUsrGrp");
            if (StringUtils.isEmpty((String)clickUserGroupId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u7528\u6237\u7ec4\u3002", (String)"UserGroupUserSyncRuleNewPlugin_14", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            Long userGroupId = Long.parseLong(clickUserGroupId);
            EventCenterService.deleteUsrGrpEventData((Long)userGroupId);
            DeleteServiceHelper.delete((String)"perm_usrgrpsync_rule", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)userGroupId)});
            DynamicObject userGroup = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NUM, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userGroupId)});
            userGroup.set("seted_usrsycrule", (Object)false);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{userGroup});
            this.getPageCache().put("afterDelete", "true");
            this.refresh();
            String uGNumber = userGroup.getString("number");
            String appId = AppHelper.getCurAppId((String)"perm_usrgrpsyncrule_new", (String)this.getView().getFormShowParameter().getAppId());
            MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u5220\u9664", "UserGroupUserSyncRuleNewPlugin_19", "bos-permission-formplugin");
            MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u7528\u6237\u7ec4\u4eba\u5458\u540c\u6b65\u89c4\u5219\u5220\u9664\u6210\u529f", "UserGroupUserSyncRuleNewPlugin_20", "bos-permission-formplugin");
            String[] opDescParam = new String[]{};
            String oldOpDescription = ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4eba\u5458\u540c\u6b65\u89c4\u5219\u5220\u9664\u6210\u529f", (String)"UserGroupUserSyncRuleNewPlugin_20", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            String opNameZh_CN = new MultiLangEnumBridge("\u5220\u9664", "UserGroupUserSyncRuleNewPlugin_19", "bos-permission-formplugin").getDescription();
            PermCommonUtil.addLog((String)"", (String)opNameZh_CN, (String)"perm_usrgrpsync_rule", (String)uGNumber, (String)USER_CONFIG_TYPE, (String)"btndel", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)appId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        ListSelectedRowCollection retData = (ListSelectedRowCollection)e.getReturnData();
        if (retData != null) {
            if ("chooseGrpRefField".equals(actionId)) {
                String idStr = (String)retData.get(0).getPrimaryKeyValue();
                String[] info = idStr.split("\\|");
                String ruleConfigType = (String)this.getModel().getValue("radiogroupfield");
                if (USER_CONFIG_TYPE.equals(ruleConfigType)) {
                    this.getModel().setValue("usergrpreffieldkey", (Object)info[0]);
                    this.getModel().setValue("usergrpreffieldname", (Object)info[1]);
                    this.getModel().setValue("usergrprefbdtype", (Object)info[2]);
                    this.getModel().setValue("usergrprefvaluename", (Object)"");
                    this.getModel().setValue("usergrprefvalue", (Object)"");
                } else if (CUSTOMER_CONFIG_TYPE.equals(ruleConfigType)) {
                    this.getModel().setValue("cusgrpreffieldkey", (Object)info[0]);
                    this.getModel().setValue("cusgrpreffieldname", (Object)info[1]);
                    this.getModel().setValue("cusgrprefbdtype", (Object)info[2]);
                    this.getModel().setValue("cusgrprefvaluename", (Object)"");
                    this.getModel().setValue("cusgrprefvalue", (Object)"");
                }
            } else if ("chooseUserField".equals(actionId)) {
                String idStr = (String)retData.get(0).getPrimaryKeyValue();
                String[] info = idStr.split("\\|");
                this.getModel().setValue("userfieldname", (Object)info[1]);
                this.getModel().setValue("userfieldkey", (Object)info[0]);
            } else if ("chooseValue".equals(actionId)) {
                ArrayList<String> realValue = new ArrayList<String>(10);
                ArrayList<String> showName = new ArrayList<String>(10);
                String ruleConfigType = (String)this.getModel().getValue("radiogroupfield");
                if (retData.size() > 10) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u8fd4\u56de\u503c\u6570\u91cf\u5927\u4e8e10\uff0c\u8bf7\u7cbe\u786e\u8303\u56f4\u3002", (String)"UserGroupUserSyncRuleNewPlugin_15", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                for (ListSelectedRow row : retData) {
                    String value = String.valueOf(row.getPrimaryKeyValue());
                    String name = row.getName();
                    if (StringUtils.isEmpty((String)name)) {
                        name = value;
                    }
                    realValue.add(value);
                    showName.add(name);
                }
                if (USER_CONFIG_TYPE.equals(ruleConfigType)) {
                    this.getModel().setValue("usergrprefvalue", (Object)String.join((CharSequence)",", realValue));
                    this.getModel().setValue("usergrprefvaluename", (Object)String.join((CharSequence)"\uff1b", showName));
                } else if (CUSTOMER_CONFIG_TYPE.equals(ruleConfigType)) {
                    this.getModel().setValue("cusgrprefvalue", (Object)String.join((CharSequence)",", realValue));
                    this.getModel().setValue("cusgrprefvaluename", (Object)String.join((CharSequence)"\uff1b", showName));
                }
            } else if ("chooseOperation".equals(actionId)) {
                ArrayList<String> realValue = new ArrayList<String>(10);
                ArrayList<String> showName = new ArrayList<String>(10);
                for (ListSelectedRow row : retData) {
                    String idStr = (String)row.getPrimaryKeyValue();
                    String[] info = idStr.split("\\|");
                    realValue.add(info[0]);
                    showName.add(info[1]);
                }
                this.getModel().setValue("operationkey", (Object)String.join((CharSequence)",", realValue));
                this.getModel().setValue("operationname", (Object)String.join((CharSequence)"\uff1b", showName));
            }
        }
    }

    private void clearSyncConfig() {
        this.getModel().setValue("usergrpreffieldkey", null);
        this.getModel().setValue("usergrpreffieldname", null);
        this.getModel().setValue("usergrprefbdtype", null);
        this.getModel().setValue("usergrprefvalue", null);
        this.getModel().setValue("usergrprefvaluename", null);
        this.getModel().setValue(SOURCE_ENTITY, null);
        this.getModel().setValue("cusgrpreffieldkey", null);
        this.getModel().setValue("cusgrpreffieldname", null);
        this.getModel().setValue("cusgrprefbdtype", null);
        this.getModel().setValue("cusgrprefvalue", null);
        this.getModel().setValue("cusgrprefvaluename", null);
        this.getModel().setValue("operationkey", null);
        this.getModel().setValue("operationname", null);
        this.getModel().setValue("userfieldkey", null);
        this.getModel().setValue("userfieldname", null);
    }

    private boolean checkDataExist(Long userGroupId) {
        boolean exists = QueryServiceHelper.exists((String)ENTITY_NUM, (Object)userGroupId);
        if (!exists) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u7528\u6237\u7ec4\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"UserGroupUserSyncRuleNewPlugin_16", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            this.refresh();
        }
        return exists;
    }
}

