/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.UsrGrpAssignUserPlugin;
import kd.bos.permission.service.UserGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class UserGroupUserSyncRulePlugin
extends AbstractFormPlugin
implements IBillPlugin {
    private static final Log logger = LogFactory.getLog(UsrGrpAssignUserPlugin.class);
    private static final String ID_ROOTNODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String ENTRYENTITY = "entryentity";

    public void preOpenForm(PreOpenFormEventArgs e) {
        Long usrGrpId = (Long)e.getFormShowParameter().getCustomParam("usrgrpid");
        DynamicObject userGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)usrGrpId, (String)"bos_usrgrp", (String)"id,usrgrpstd.id");
        long usrGrpStdId = userGroup.getLong("usrgrpstd.id");
        if (PermHelperConst.NOTCLASSIFY_STDID.equals(usrGrpStdId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u7ec4\u7684\u5206\u7c7b\u201c\u9ed8\u8ba4\u5206\u7c7b\u201d\u4e3a\u7cfb\u7edf\u9884\u7f6e\uff0c\u4e0d\u652f\u6301\u914d\u7f6e\u7528\u6237\u540c\u6b65\u89c4\u5219\u3002", (String)"UserGroupUserSyncRulePlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject userGroupStandard = BusinessDataServiceHelper.loadSingleFromCache((Object)usrGrpStdId, (String)"perm_usergroupstandard");
            DynamicObjectCollection entrySrcEnt = userGroupStandard.getDynamicObjectCollection("entry_srcent");
            if (CollectionUtils.isEmpty((Collection)entrySrcEnt)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u7ec4\u7684\u201c\u5206\u7c7b\u201d\u6ca1\u6709\u914d\u7f6e\u201c\u7528\u6237\u540c\u6b65\u6570\u636e\u6e90\u201d\u3002", (String)"UserGroupUserSyncRulePlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void initialize() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"ruleap"});
        TextEdit grpRefFieldName = (TextEdit)this.getControl("grpreffieldname");
        grpRefFieldName.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                DynamicObject dataEntity;
                String number;
                EntryGrid sourceEntity = (EntryGrid)UserGroupUserSyncRulePlugin.this.getControl(UserGroupUserSyncRulePlugin.ENTRYENTITY);
                int[] selectRows = sourceEntity.getSelectRows();
                DynamicObject[] dataEntitys = sourceEntity.getEntryData().getDataEntitys();
                if (dataEntitys != null && StringUtils.isNotEmpty((String)(number = (dataEntity = dataEntitys[selectRows[0]]).getString("source_entity.number")))) {
                    UserGroupUserSyncRulePlugin.this.showFieldPage(number);
                }
            }
        });
        TextEdit grpRefValueName = (TextEdit)this.getControl("grprefvaluename");
        grpRefValueName.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                EntryGrid sourceEntity = (EntryGrid)UserGroupUserSyncRulePlugin.this.getControl(UserGroupUserSyncRulePlugin.ENTRYENTITY);
                int[] selectRows = sourceEntity.getSelectRows();
                DynamicObject[] dataEntitys = sourceEntity.getEntryData().getDataEntitys();
                if (dataEntitys != null) {
                    DynamicObject dataEntity = dataEntitys[selectRows[0]];
                    String grpRefFieldName = dataEntity.getString("grpreffieldname");
                    String grpRefBdType = dataEntity.getString("grprefbdtype");
                    if (StringUtils.isEmpty((String)grpRefFieldName)) {
                        UserGroupUserSyncRulePlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5206\u7ec4\u5b57\u6bb5\u201d\u3002", (String)"UserGroupUserSyncRulePlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    } else {
                        UserGroupUserSyncRulePlugin.this.showPage(grpRefBdType);
                    }
                }
            }
        });
        EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRYENTITY);
        entryEntity.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                Boolean complexRule = (Boolean)UserGroupUserSyncRulePlugin.this.getModel().getValue("iscomplexrule");
                if (complexRule.booleanValue()) {
                    String lastClickRowStr = UserGroupUserSyncRulePlugin.this.getPageCache().get("last_click_row");
                    if (StringUtils.isNotEmpty((String)lastClickRowStr)) {
                        int lastClickRow = Integer.parseInt(lastClickRowStr);
                        String ruleInfo = UserGroupUserSyncRulePlugin.this.getRuleInfo();
                        if (StringUtils.isNotEmpty((String)ruleInfo)) {
                            UserGroupUserSyncRulePlugin.this.getModel().setValue("rule_detail", (Object)ruleInfo, lastClickRow);
                        }
                    }
                    int row = evt.getRow();
                    UserGroupUserSyncRulePlugin.this.getPageCache().put("last_click_row", row + "");
                    DynamicObject sourceEntity = (DynamicObject)UserGroupUserSyncRulePlugin.this.getModel().getValue("source_entity", row);
                    String ruleDetail = (String)UserGroupUserSyncRulePlugin.this.getModel().getValue("rule_detail", row);
                    UserGroupUserSyncRulePlugin.this.clearFilterGridData();
                    FilterGrid filterGrid = (FilterGrid)UserGroupUserSyncRulePlugin.this.getControl("rule");
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)sourceEntity.getString("number"));
                    EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
                    List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
                    filterGrid.setEntityNumber(entityType.getName());
                    PermCommonUtil.removeExtraColumn((List)filterColumns, (MainEntityType)entityType);
                    filterGrid.setFilterColumns(filterColumns);
                    if (StringUtils.isNotEmpty((String)ruleDetail)) {
                        ruleDetail = PermCommonUtil.replaceBackSlach((String)ruleDetail);
                        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleDetail, FilterCondition.class);
                        filterGrid.SetValue(filterCondition);
                    }
                    UserGroupUserSyncRulePlugin.this.getView().setVisible(Boolean.TRUE, new String[]{"ruleap"});
                    UserGroupUserSyncRulePlugin.this.getView().updateView("ruleap");
                    UserGroupUserSyncRulePlugin.this.getView().updateView("rule");
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Long usrGrpId = (Long)this.getView().getFormShowParameter().getCustomParam("usrgrpid");
        this.getModel().setValue("usergroup", (Object)usrGrpId);
        DynamicObject userGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)usrGrpId, (String)"bos_usrgrp", (String)"id,usrgrpstd.id");
        this.getModel().setValue("usergroup", userGroup.get("id"));
        Long usrGrpStdId = userGroup.getLong("usrgrpstd.id");
        Map userGroupSyncRules = BusinessDataServiceHelper.loadFromCache((String)"perm_usrgrpsync_rule", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", userGroup.get("id"))});
        if (CollectionUtils.isEmpty((Map)userGroupSyncRules)) {
            DynamicObject userGroupStandard = BusinessDataServiceHelper.loadSingleFromCache((Object)usrGrpStdId, (String)"perm_usergroupstandard");
            if (userGroupStandard == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u672a\u8bbe\u7f6e\u201c\u5206\u7c7b\u201d\u3002", (String)"UserGroupUserSyncRulePlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            DynamicObjectCollection entrySrcEnt = userGroupStandard.getDynamicObjectCollection("entry_srcent");
            ArrayList<String> entitySourceNumber = new ArrayList<String>(10);
            TableValueSetter vs = new TableValueSetter(new String[]{"source_entity", "userfieldname", "userfieldkey"});
            for (DynamicObject srcEnt : entrySrcEnt) {
                String entityNum = srcEnt.getString("source_entity.number");
                entitySourceNumber.add(entityNum);
                String userFieldKey = srcEnt.getString("userfieldkey");
                Map entityUserFieldMap = PermCommonUtil.getEntityUserFieldMap((String)entityNum);
                String fieldName = (String)entityUserFieldMap.get(userFieldKey);
                vs.addRow(new Object[]{entityNum, fieldName, userFieldKey});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(ENTRYENTITY, vs);
            this.setItemClassTypeEdit(entitySourceNumber);
        } else {
            DynamicObject syncRule;
            boolean complexRule;
            Iterator userGroupStandard = userGroupSyncRules.values().iterator();
            if (userGroupStandard.hasNext() && (complexRule = (syncRule = (DynamicObject)userGroupStandard.next()).getBoolean("iscomplexrule"))) {
                this.getModel().setValue("iscomplexrule", (Object)complexRule);
                this.getView().setVisible(Boolean.FALSE, new String[]{"grpreffieldname", "grprefbdtype", "grprefvalue"});
            }
            ArrayList<String> entitySourceNumber = new ArrayList<String>(10);
            TableValueSetter vs = new TableValueSetter(new String[]{"source_entity", "userfieldname", "userfieldkey", "grpreffieldname", "grpreffieldkey", "grprefbdtype", "grprefvaluename", "grprefvalue", "rule_detail"});
            for (DynamicObject syncRule2 : userGroupSyncRules.values()) {
                String entityNum = syncRule2.getString("source_entity.number");
                entitySourceNumber.add(entityNum);
                Map entityFieldMap = PermCommonUtil.getEntityBaseDataField((String)entityNum);
                String userFieldKey = syncRule2.getString("userfieldkey");
                String userFieldName = (String)entityFieldMap.get(userFieldKey);
                String grpRefFieldKey = syncRule2.getString("grpreffieldkey");
                String grpRefFieldName = (String)entityFieldMap.get(grpRefFieldKey);
                String grpRefDdType = syncRule2.getString("grprefbdtype.number");
                String grpRefValue = syncRule2.getString("grprefvalue");
                String grpRefValueName = null;
                if (StringUtils.isNotEmpty((String)grpRefValue)) {
                    Object id = grpRefValue;
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)grpRefDdType);
                    int dbType = dataEntityType.getPrimaryKey().getDbType();
                    if (dbType == -5) {
                        id = Long.parseLong(grpRefValue);
                    }
                    DynamicObject value = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)grpRefDdType, (String)"id,name");
                    grpRefValueName = value.getString("name");
                }
                String rule = syncRule2.getString("rule");
                vs.addRow(new Object[]{entityNum, userFieldName, userFieldKey, grpRefFieldName, grpRefFieldKey, grpRefDdType, grpRefValueName, grpRefValue, rule});
                if (!StringUtils.isNotEmpty((String)grpRefDdType)) continue;
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)grpRefDdType);
                ItemClassTypeProp ictp = (ItemClassTypeProp)this.getModel().getProperty("grprefbdtype");
                ictp.setItemType((DynamicObjectType)mainEntityType);
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(ENTRYENTITY, vs);
            this.setItemClassTypeEdit(entitySourceNumber);
            this.getView().updateView();
        }
    }

    private void setItemClassTypeEdit(List<String> entitySourceNumber) {
        if (!CollectionUtils.isEmpty(entitySourceNumber)) {
            Set entityBaseDataType = PermCommonUtil.getEntityBaseDataType(entitySourceNumber);
            DynamicObject[] entityInfo = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"number, name", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)entityBaseDataType)});
            ItemClassTypeEdit icte = (ItemClassTypeEdit)this.getControl("grprefbdtype");
            ArrayList<ComboItem> cboList = new ArrayList<ComboItem>(10);
            for (DynamicObject entity : entityInfo) {
                ComboItem cbi = new ComboItem(new LocaleString(entity.getLocaleString("name").getLocaleValue()), entity.getString("number"));
                cboList.add(cbi);
            }
            icte.setComboItems(cboList);
        }
    }

    public void afterLoadData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean complexRule = (Boolean)this.getModel().getValue("iscomplexrule");
        if (complexRule.booleanValue()) {
            EntryGrid sourceEntity = (EntryGrid)this.getControl(ENTRYENTITY);
            sourceEntity.entryRowClick(Integer.valueOf(0));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String grpRefValueName;
        String propName = e.getProperty().getName();
        if ("iscomplexrule".equals(propName)) {
            boolean complexrule = (Boolean)e.getChangeSet()[0].getNewValue();
            if (complexrule) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"grpreffieldname", "grprefbdtype", "grprefvaluename"});
                EntryGrid sourceEntity = (EntryGrid)this.getControl(ENTRYENTITY);
                int[] selectRows = sourceEntity.getSelectRows();
                if (selectRows.length > 0) {
                    sourceEntity.entryRowClick(Integer.valueOf(selectRows[0]));
                } else {
                    sourceEntity.entryRowClick(Integer.valueOf(0));
                }
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"grpreffieldname", "grprefbdtype", "grprefvaluename"});
                this.clearFilterGridData();
            }
        } else if ("grpreffieldname".equals(propName)) {
            String grpRefFieldName = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isEmpty((String)grpRefFieldName)) {
                EntryGrid sourceEntity = (EntryGrid)this.getControl(ENTRYENTITY);
                int[] selectRows = sourceEntity.getSelectRows();
                this.getModel().setValue("grpreffieldkey", null, selectRows[0]);
                this.getModel().setValue("grprefbdtype", null, selectRows[0]);
                this.getModel().setValue("grprefvalue", null, selectRows[0]);
                this.getModel().setValue("grprefvaluename", null, selectRows[0]);
            }
        } else if ("grprefvaluename".equals(propName) && StringUtils.isEmpty((String)(grpRefValueName = (String)e.getChangeSet()[0].getNewValue()))) {
            EntryGrid sourceEntity = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = sourceEntity.getSelectRows();
            this.getModel().setValue("grprefvalue", null, selectRows[0]);
        }
    }

    private void showFieldPage(String entityNum) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"perm_choosecustomfield", (boolean)false, (int)0, (boolean)true);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chooseCustomField"));
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setCustomParam("entityNum", (Object)entityNum);
        lsp.setCustomParam("show_page", (Object)"user_group_sync_rule");
        lsp.setShowTitle(true);
        lsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void showPage(String entityNum) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entityNum, (boolean)false, (int)0, (boolean)true);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "chooseValue"));
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setHasRight(true);
        if ("bos_org".equals(entityNum)) {
            lsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
        }
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection retData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        EntryGrid sourceEntity = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = sourceEntity.getSelectRows();
        if ("chooseCustomField".equals(actionId)) {
            ListSelectedRowCollection retData2 = (ListSelectedRowCollection)e.getReturnData();
            if (retData2 != null) {
                String idStr = (String)retData2.get(0).getPrimaryKeyValue();
                String[] info = idStr.split("\\|");
                this.getModel().setValue("grpreffieldkey", (Object)info[0], selectRows[0]);
                this.getModel().setValue("grpreffieldname", (Object)info[1], selectRows[0]);
                this.getModel().setValue("grprefbdtype", (Object)info[2], selectRows[0]);
                this.getModel().setValue("grprefvaluename", (Object)"", selectRows[0]);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)info[2]);
                ItemClassTypeProp ictp = (ItemClassTypeProp)this.getModel().getProperty("grprefbdtype");
                ictp.setItemType((DynamicObjectType)mainEntityType);
            }
        } else if ("chooseValue".equals(actionId) && (retData = (ListSelectedRowCollection)e.getReturnData()) != null) {
            String value = String.valueOf(retData.get(0).getPrimaryKeyValue());
            String name = retData.get(0).getName();
            if (StringUtils.isEmpty((String)name)) {
                name = value;
            }
            this.getModel().setValue("grprefvalue", (Object)value, selectRows[0]);
            this.getModel().setValue("grprefvaluename", (Object)name, selectRows[0]);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("donothing_save".equals(operateKey) && e.getOperationResult().isSuccess()) {
            Long usrGrpId = (Long)this.getView().getFormShowParameter().getCustomParam("usrgrpid");
            int lastClickRow = 0;
            String lastClickRowStr = this.getPageCache().get("last_click_row");
            if (StringUtils.isNotEmpty((String)lastClickRowStr)) {
                lastClickRow = Integer.parseInt(lastClickRowStr);
            }
            String ruleInfo = this.getRuleInfo();
            EntryGrid sourceEntity = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = sourceEntity.getSelectRows();
            if (selectRows.length > 0) {
                this.getModel().setValue("rule_detail", (Object)ruleInfo, selectRows[0]);
            } else {
                this.getModel().setValue("rule_detail", (Object)ruleInfo, lastClickRow);
            }
            DynamicObject[] ruleConfigs = sourceEntity.getEntryData().getDataEntitys();
            ArrayList<DynamicObject> rules = new ArrayList<DynamicObject>(ruleConfigs.length);
            for (DynamicObject ruleConfig : ruleConfigs) {
                DynamicObject syncRule = BusinessDataServiceHelper.newDynamicObject((String)"perm_usrgrpsync_rule");
                syncRule.set("usergroup", (Object)usrGrpId);
                String entityNum = ruleConfig.getString("source_entity.number");
                syncRule.set("source_entity", (Object)entityNum);
                syncRule.set("userfieldkey", (Object)ruleConfig.getString("userfieldkey"));
                String grpRefFieldKey = ruleConfig.getString("grpreffieldkey");
                String grpRefFieldName = ruleConfig.getString("grpreffieldname");
                String grpRefDdType = ruleConfig.getString("grprefbdtype");
                String grpRefValue = ruleConfig.getString("grprefvalue");
                String grpRefValueName = ruleConfig.getString("grprefvaluename");
                boolean complexRule = (Boolean)this.getModel().getValue("iscomplexrule");
                String ruleDetail = ruleConfig.getString("rule_detail");
                syncRule.set("iscomplexrule", (Object)complexRule);
                if (complexRule) {
                    if (StringUtils.isEmpty((String)ruleDetail)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u590d\u6742\u89c4\u5219\uff0c\u5fc5\u987b\u8fdb\u884c\u89c4\u5219\u914d\u7f6e\u3002", (String)"UserGroupUserSyncRulePlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                        sourceEntity.entryRowClick(Integer.valueOf(lastClickRow));
                        return;
                    }
                    try {
                        UserGroupService.checkRuleJsonRetFilter(null, (String)entityNum, (String)ruleDetail, null);
                    }
                    catch (Exception ex) {
                        this.getView().showTipNotification(ex.getMessage(), Integer.valueOf(3000));
                        sourceEntity.entryRowClick(Integer.valueOf(lastClickRow));
                        return;
                    }
                } else if (StringUtils.isEmpty((String)grpRefFieldKey) || StringUtils.isEmpty((String)grpRefFieldName) || StringUtils.isEmpty((String)grpRefValue) || StringUtils.isEmpty((String)grpRefValueName)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u7b80\u5355\u89c4\u5219\uff0c\u201c\u5b57\u6bb5\u201d\u4e0e\u201c\u503c\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserGroupUserSyncRulePlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                syncRule.set("rule", (Object)ruleDetail);
                syncRule.set("grpreffieldkey", (Object)grpRefFieldKey);
                syncRule.set("grprefbdtype", (Object)grpRefDdType);
                syncRule.set("grprefvalue", (Object)grpRefValue);
                rules.add(syncRule);
            }
            DeleteServiceHelper.delete((String)"perm_usrgrpsync_rule", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)usrGrpId)});
            SaveServiceHelper.save((DynamicObject[])rules.toArray(new DynamicObject[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserGroupUserSyncRulePlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            if (selectRows.length > 0) {
                sourceEntity.entryRowClick(Integer.valueOf(selectRows[0]));
            } else {
                sourceEntity.entryRowClick(Integer.valueOf(lastClickRow));
            }
        }
    }

    private String getRuleInfo() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("rule");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        List filterRow = filterCondition.getFilterRow();
        if (CollectionUtils.isEmpty((Collection)filterRow)) {
            return null;
        }
        return SerializationUtils.toJsonString((Object)filterCondition);
    }

    private void clearFilterGridData() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("rule");
        if (filterGrid != null) {
            FilterCondition fc = new FilterCondition();
            filterGrid.SetValue(fc);
            fc = null;
            filterGrid.SetValue(fc);
        }
    }
}

