/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.admin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.permission.cache.constant.PermIdConst;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AdminSchemeDataCheckPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_THREEADMIN_UNASSIGN = "entry_threeadmin_unassign";
    private static final String ENTRYFIELD_CLOUD = "cloud";
    private static final String ENTRYFIELD_APP = "app";
    private static final String ENTRYFIELD_MENUPATH = "menupath";
    private static final String ENTRYFIELD_ENTITYNUM = "entitynum";
    private static final String ENTRYFIELD_ENTITYNAME = "entityname";
    private static final String ENTRYFIELD_ENTITYOFAPP = "entityofapp";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_threeadmin_unassigned"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.setEntryData_ThreeAdminUnassigned();
    }

    private void setEntryData_ThreeAdminUnassigned() {
        this.getModel().deleteEntryData(ENTRY_THREEADMIN_UNASSIGN);
        List<Object[]> result = this.findThreeAdminSchemeUnassignedData();
        if (result == null || result.isEmpty()) {
            return;
        }
        int resultCount = result.size();
        if (resultCount == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_THREEADMIN_UNASSIGN, resultCount);
        for (int i = 0; i < resultCount; ++i) {
            Object[] objArr = result.get(i);
            this.getModel().setValue(ENTRYFIELD_CLOUD, objArr[0], i);
            this.getModel().setValue(ENTRYFIELD_APP, objArr[1], i);
            this.getModel().setValue(ENTRYFIELD_MENUPATH, objArr[2], i);
            this.getModel().setValue(ENTRYFIELD_ENTITYNUM, objArr[3], i);
            this.getModel().setValue(ENTRYFIELD_ENTITYNAME, objArr[4], i);
            this.getModel().setValue(ENTRYFIELD_ENTITYOFAPP, objArr[5], i);
        }
    }

    private List<Object[]> findThreeAdminSchemeUnassignedData() {
        final ArrayList<Object[]> result = new ArrayList<Object[]>(8);
        DynamicObject adminScheme = BusinessDataServiceHelper.loadSingle((Object)PermIdConst.ADMIN_STRTGYID_THREEADMIN, (String)"perm_adminscheme");
        final HashMap<String, Set> appEntMap = new HashMap<String, Set>(8);
        DynamicObjectCollection adminTypeEntry = adminScheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : adminTypeEntry) {
            DynamicObjectCollection subEntry = entryRow.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntryRow : subEntry) {
                String appId = subEntryRow.getString("bizapp_id");
                String entityNum = subEntryRow.getString("entity.number");
                appEntMap.computeIfAbsent(appId, k -> new HashSet(8)).add(entityNum);
            }
        }
        List allSysAppId = AdminSchemeHelper.queryAllSysApp((boolean)false, (boolean)false);
        StringBuilder sb = new StringBuilder("select bc.fid cloudid, bc.fnumber cloudnum, bcl.fname cloudname, app.fid appid, appl.fname appname, ").append(" m3l.fname menuname1, m2l.fname menuname2, mrtl.fname menuname3, ").append(" ed.fnumber entnum, meil.fname entname ,ed.fbizappid entofappid, appl2.fname entappname ").append(" from t_meta_menuruntime mrt ").append(" inner join t_meta_menuruntime_l mrtl on(mrtl.fid = mrt.fid and mrtl.flocaleid = 'zh_CN') ").append(" inner join t_meta_formdesign fd  on(mrt.fformid = fd.fnumber) ").append(" inner join t_meta_entitydesign ed  on(fd.fentityid = ed.fid) ").append(" inner join t_meta_mainentityinfo_l meil  on(meil.fid = ed.fnumber and meil.flocaleid = 'zh_CN') ").append(" inner join t_meta_bizapp app on(app.fnumber = mrt.fappid) ").append(" inner join t_meta_bizapp_l appl on(app.fid = appl.fid and appl.flocaleid = 'zh_CN') ").append(" inner join t_meta_bizunitrelform burf on (burf.fformid = ed.fid) ").append(" inner join t_meta_bizapp_l appl2 on(appl2.fid = burf.fbizappid and appl2.flocaleid = 'zh_CN') ").append(" inner join t_meta_bizcloud bc on(app.fbizcloudid = bc.fid) ").append(" inner join t_meta_bizcloud_l bcl on(bc.fid = bcl.fid and bcl.flocaleid = 'zh_CN') ").append(" left join t_meta_menuruntime m2 on mrt.fparentid = m2.fid ").append(" left join t_meta_menuruntime_l m2l on(m2l.fid = m2.fid and m2l.flocaleid = 'zh_CN') ").append(" left join t_meta_menuruntime m3 on m2.fparentid = m3.fid ").append(" left join t_meta_menuruntime_l m3l on(m3l.fid = m3.fid and m3l.flocaleid = 'zh_CN') ").append(" where (mrt.fformid <> ' ' and mrt.fformid <> '' and mrt.fformid is not null) ");
        String appIdSqlStr = String.join((CharSequence)"','", allSysAppId);
        sb.append(" and app.fid in('").append(appIdSqlStr).append("') ");
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String cloudname = rs.getString("cloudname");
                    String appname = rs.getString("appname");
                    String menuname1 = rs.getString("menuname1");
                    menuname1 = menuname1 == null ? "" : menuname1;
                    String menuname2 = rs.getString("menuname2");
                    menuname2 = menuname2 == null ? "" : menuname2;
                    String menuname3 = rs.getString("menuname3");
                    String menuPath = menuname3 = menuname3 == null ? "" : menuname3;
                    if (menuname2.length() > 0) {
                        menuPath = menuname2 + "--" + menuPath;
                    }
                    if (menuname1.length() > 0) {
                        menuPath = menuname1 + "--" + menuPath;
                    }
                    String appId = rs.getString("appid");
                    String entnum = rs.getString("entnum");
                    String entname = rs.getString("entname");
                    String entappname = rs.getString("entappname");
                    Object[] objArr = new Object[]{cloudname, appname, menuPath, entnum, entname, entappname};
                    Set entNums = (Set)appEntMap.get(appId);
                    if (entNums == null) {
                        result.add(objArr);
                        continue;
                    }
                    if (entNums.contains(entnum)) continue;
                    result.add(objArr);
                }
                return null;
            }
        });
        return result;
    }
}

