/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.dataprovider;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.service.UserGroupService;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class UserDataProvider
extends ListDataProvider {
    private static final String ID_ROOTNODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String NEED_CHECK_ADMIN = "need_check_admin";
    private static final String FOCUS_NODE_ID = "focusNodeId";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private IPageCache pageCache;
    private IFormView view;
    private IDataModel dataModel;
    private TreeView userGroupTree;

    public UserDataProvider() {
    }

    public UserDataProvider(IPageCache pageCache, IFormView view, IDataModel dataModel, TreeView userGroupTree) {
        this.pageCache = pageCache;
        this.view = view;
        this.dataModel = dataModel;
        this.userGroupTree = userGroupTree;
    }

    private boolean isUserCountTooMuch(Long allEnableUserIdSetCount) {
        return 100000L < allEnableUserIdSetCount;
    }

    private boolean isRootNode() {
        String curFocusNodeID = this.getCurFocusNodeID(this.pageCache);
        return StringUtils.isNotEmpty((String)curFocusNodeID) && ID_ROOTNODE.equals(curFocusNodeID);
    }

    public DynamicObjectCollection getData(int start, int limit) {
        String needCheckAdmin;
        String USER_ENTITY = "bos_usergroup_user";
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)USER_ENTITY);
        boolean isRootNode = this.isRootNode();
        String isSearchMode = this.pageCache.get("isSearchMode");
        if (isRootNode) {
            Long allEnableUserIdSetCount = UserHelper.getUserCount((String)"1", null);
            if (!Objects.equals("1", isSearchMode) && this.isUserCountTooMuch(allEnableUserIdSetCount)) {
                this.getQueryResult().setDataCount(0);
                this.getQueryResult().setCollection(null);
                this.view.showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u91cf\u8fc7\u5927\uff0c\u8bf7\u70b9\u51fb\u5de6\u4fa7\u7528\u6237\u5206\u7ec4\u67e5\u770b\uff0c\u6216\u53f3\u4e0a\u89d2\u641c\u7d22\u7528\u6237\u3002", (String)"UserDataProvider_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(5000));
                return new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
            }
        }
        Set enableVSet = Sets.newHashSet((Object[])new String[]{"1"});
        QueryBuilder queryBuilder = this.getQueryBuilder();
        QFilter[] oriQFilters = queryBuilder.getFilters();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(oriQFilters.length);
        if (null != oriQFilters && oriQFilters.length > 0) {
            for (QFilter qfilter : oriQFilters) {
                if (null == qfilter) continue;
                String property = qfilter.getProperty();
                Object value = qfilter.getValue();
                if (Objects.equals("enable", property)) {
                    if (value instanceof String) {
                        enableVSet = Sets.newHashSet((Object[])new String[]{String.valueOf(value)});
                    } else if (value instanceof Set) {
                        enableVSet = (Set)value;
                    }
                }
                filterList.add(qfilter);
            }
        }
        String curFocusNodeID = this.getCurFocusNodeID(this.pageCache);
        Set nodeClickUserIdSet = null;
        if (!Objects.equals("1", isSearchMode)) {
            nodeClickUserIdSet = this.getNodeClickUserIdSet(curFocusNodeID, enableVSet);
        }
        Set filterUserIdSet = null;
        if (null != nodeClickUserIdSet) {
            if (nodeClickUserIdSet.isEmpty()) {
                this.getQueryResult().setDataCount(0);
                this.getQueryResult().setCollection(null);
                return new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
            }
            filterUserIdSet = nodeClickUserIdSet;
        }
        if ("1".equals(needCheckAdmin = this.pageCache.get(NEED_CHECK_ADMIN))) {
            Map<String, Object> adminChargeUserMap = this.getAdminChargeUserMap();
            boolean canQueryUser = (Boolean)adminChargeUserMap.get("canQueryUser");
            boolean allUser = (Boolean)adminChargeUserMap.get("allUser");
            Set adminChargeUserIdSet = (Set)adminChargeUserMap.get("adminChargeUserIdSet");
            if (!canQueryUser) {
                this.getQueryResult().setDataCount(0);
                this.getQueryResult().setCollection(null);
                return new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
            }
            if (null == adminChargeUserIdSet || adminChargeUserIdSet.isEmpty()) {
                if (!allUser) {
                    this.getQueryResult().setDataCount(0);
                    this.getQueryResult().setCollection(null);
                    return new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
                }
            } else if (null == filterUserIdSet) {
                filterUserIdSet = adminChargeUserIdSet;
            } else if (null == (filterUserIdSet = Sets.intersection((Set)filterUserIdSet, (Set)adminChargeUserIdSet)) || filterUserIdSet.isEmpty()) {
                this.getQueryResult().setDataCount(0);
                this.getQueryResult().setCollection(null);
                return new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
            }
        }
        if (null != filterUserIdSet && !filterUserIdSet.isEmpty()) {
            if (filterUserIdSet.size() > 300000) {
                this.getQueryResult().setDataCount(0);
                this.getQueryResult().setCollection(null);
                this.view.showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u91cf\u8fc7\u5927\uff0c\u8bf7\u70b9\u51fb\u5de6\u4fa7\u7528\u6237\u5206\u7ec4\u67e5\u770b\uff0c\u6216\u53f3\u4e0a\u89d2\u641c\u7d22\u7528\u6237\u3002", (String)"UserDataProvider_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(5000));
                return new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
            }
            filterList.add(new QFilter("id", "in", filterUserIdSet));
        }
        super.setQFilters(filterList);
        return super.getData(start, limit);
    }

    private String getCurFocusNodeID(IPageCache pageCache) {
        String curFocusNodeID = pageCache.get(FOCUS_NODE_ID);
        if (StringUtils.isEmpty((String)curFocusNodeID) && this.userGroupTree != null) {
            curFocusNodeID = this.userGroupTree.getTreeState().getFocusNodeId();
        }
        return curFocusNodeID;
    }

    private Set<Long> getNodeClickUserIdSet(String focusNodeId, Set<String> enableVSet) {
        if (StringUtils.isNotEmpty((String)focusNodeId) && !ID_ROOTNODE.equals(focusNodeId)) {
            focusNodeId = focusNodeId.split("-")[0];
            Set userIds = null;
            userIds = this.isIncludeNextLevel() ? UserGroupService.getAllUsersIdByUsrGrpId((Long)Long.valueOf(focusNodeId)) : UserGroupService.getUsersIdByUsrGrpId((Long)Long.valueOf(focusNodeId), enableVSet);
            return userIds;
        }
        if (StringUtils.isNotEmpty((String)focusNodeId) && ID_ROOTNODE.equals(focusNodeId)) {
            Long usrGrpStd = Long.valueOf((String)this.dataModel.getValue("usrgrpstd"));
            if (PermHelperConst.NOTCLASSIFY_STDID.equals(usrGrpStd)) {
                return null;
            }
            return UserGroupService.getAllUsersIdByUsrGrpStdId((Long)usrGrpStd);
        }
        return null;
    }

    private Map<String, Object> getAdminChargeUserMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("canQueryUser", true);
        map.put("adminChargeUserIdSet", null);
        map.put("allUser", true);
        Long userId = RequestContext.get().getCurrUserId();
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        if (isSuperAdmin) {
            return map;
        }
        UserScopeResult userScopeResult = PermissionServiceHelper.getAdminChargeUser((Long)userId);
        if (userScopeResult != null) {
            boolean allUser = userScopeResult.isAllUser();
            map.put("allUser", allUser);
            if (!allUser) {
                List adminChargeUsers = userScopeResult.getUserIDs();
                if (adminChargeUsers.size() == 0) {
                    map.put("canQueryUser", false);
                    return map;
                }
                HashSet adminChargeUserSet = new HashSet(adminChargeUsers);
                map.put("adminChargeUserIdSet", adminChargeUserSet);
                return map;
            }
            return map;
        }
        map.put("canQueryUser", false);
        return map;
    }

    private boolean isIncludeNextLevel() {
        boolean isIncludeNextLevel = true;
        Object includeChild = this.dataModel.getValue("chkincludechild");
        if (includeChild != null) {
            isIncludeNextLevel = Boolean.parseBoolean(includeChild.toString());
        }
        return isIncludeNextLevel;
    }
}

