/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.dataprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.CloudHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.model.permbase.Cloud;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.collections.map.HashedMap;

public class UserDisPermListProvider
extends ListDataProvider {
    private static Log logger = LogFactory.getLog(UserDisPermListProvider.class);
    private IPageCache pageCache;
    private IFormView view;

    public UserDisPermListProvider() {
    }

    public UserDisPermListProvider(IPageCache pageCache, IFormView view) {
        this.pageCache = pageCache;
        this.view = view;
    }

    public int getBillDataCount() {
        String maxCount = this.pageCache.get("PERM_MAXCOUNT");
        if (StringUtils.isEmpty((String)maxCount)) {
            return super.getBillDataCount();
        }
        return Integer.parseInt(maxCount);
    }

    public DynamicObjectCollection getData(int start, int limit) {
        ListShowParameter lsp;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"perm_direct_disperm");
        String isSearchMode = this.pageCache.get("isSearchMode");
        boolean isF7 = false;
        FormShowParameter fsp = this.view.getFormShowParameter();
        if (null != fsp && null != (lsp = (ListShowParameter)fsp)) {
            boolean bl = isF7 = lsp.isLookUp();
        }
        if (!Objects.equals("1", isSearchMode) && !isF7) {
            this.pageCache.put("PERM_MAXCOUNT", String.valueOf(0));
            return new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
        }
        DynamicObjectCollection data = super.getData(start, limit);
        if (null == data || data.isEmpty()) {
            return data;
        }
        int billDataCount = this.getQueryResult().getBillDataCount();
        if (!isF7 && Objects.equals(billDataCount, PermHelperConst.CONST_100000)) {
            this.getQueryResult().setDataCount(0);
            this.getQueryResult().setCollection(null);
            this.view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u5148\u9009\u62e9\u5e38\u7528\u6761\u4ef6\u6216\u53f3\u4e0a\u89d2\u5feb\u901f\u641c\u7d22\uff0c\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"PermUserRoleMulTypeListProvider_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
        }
        Set appIdSet = data.stream().map(x -> x.getString("bizapp_id")).collect(Collectors.toSet());
        Map cloudMap = CloudHelper.getCloudMap(appIdSet);
        Map entPermCtrlTypeMap = IsoDimHelper.getEntPermCtrlTypeMap((PermCtrlTypeReq)new PermCtrlTypeReq(null, null, null, null, null));
        DynamicObjectType dynamicObjectType = data.getDynamicObjectType();
        dynamicObjectType.addProperty((DynamicProperty)new DynamicSimpleProperty("dimtypenum", String.class, (Object)""));
        dynamicObjectType.addProperty((DynamicProperty)new DynamicSimpleProperty("cloudnum", String.class, (Object)""));
        dynamicObjectType.addProperty((DynamicProperty)new DynamicSimpleProperty("cloudname", String.class, (Object)""));
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            DynamicObject dyn;
            String dimType = (dyn = (DynamicObject)iterator.next()).getString("dimtype");
            PermCtrlType permCtrlType = (PermCtrlType)entPermCtrlTypeMap.get(dimType);
            dyn.set("dimtypenum", (Object)(null == permCtrlType ? dimType : permCtrlType.getNumber()));
            String bizapp_id = dyn.getString("bizapp_id");
            Cloud cloud = (Cloud)cloudMap.get(bizapp_id);
            if (null == cloud) continue;
            dyn.set("cloudnum", (Object)cloud.getCloudNumber());
            dyn.set("cloudname", (Object)cloud.getCloudName());
        }
        return data;
    }

    private static Map<String, Map<Object, DynamicObject>> getDimDynMap(DynamicObjectCollection data) {
        String dimType;
        HashMap<String, Map<Object, DynamicObject>> dimDynMap = new HashMap<String, Map<Object, DynamicObject>>(8);
        HashedMap dimTypeIdSetMap = new HashedMap(8);
        for (DynamicObject dyn : data) {
            dimType = dyn.getString("dimtype");
            long dimId = dyn.getLong("dimid_id");
            dimTypeIdSetMap.computeIfAbsent(dimType, k -> new HashSet(8)).add(dimId);
        }
        if (null == dimTypeIdSetMap || dimTypeIdSetMap.isEmpty()) {
            return dimDynMap;
        }
        for (Map.Entry dimTypeIdSet : dimTypeIdSetMap.entrySet()) {
            String dimSelectProps;
            dimType = (String)dimTypeIdSet.getKey();
            Set dimIdSet = (Set)dimTypeIdSet.getValue();
            if (StringUtils.isEmpty((String)dimType) || CollectionUtils.isEmpty((Collection)dimIdSet) || StringUtils.isEmpty((String)(dimSelectProps = IsoDimHelper.getDimSelectProps((String)dimType)))) continue;
            dimDynMap.put(dimType, IsoDimHelper.getDimDynMap(new ArrayList(dimIdSet), (String)dimType, (String)dimSelectProps));
        }
        return dimDynMap;
    }
}

