/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.eventcenter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.OperationHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.enums.GrpUsrFromTypeEnum;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.UgSyncUserParam;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.service.UserGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;

public class UgStdEvtListenPlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(UgStdEvtListenPlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        try {
            if (evt instanceof EntityEvent) {
                EntityEvent event = (EntityEvent)evt;
                List businesskeys = event.getBusinesskeys();
                String entityNumber = event.getEntityNumber();
                if (StringUtils.isEmpty((String)entityNumber) || CollectionUtils.isEmpty((Collection)businesskeys)) {
                    logger.debug("UgStdEvtListenPlugin.handleEvent, entityNumber or businesskeys is empty");
                    return null;
                }
                Map userSyncRuleMap = BusinessDataServiceHelper.loadFromCache((String)"perm_usrgrpsync_rule", (String)"usergroup_id", (QFilter[])new QFilter[]{new QFilter("source_entity", "=", (Object)entityNumber)});
                if (CollectionUtils.isEmpty((Map)userSyncRuleMap)) {
                    logger.debug("UgStdEvtListenPlugin.handleEvent, entityNumber:{},  userSyncRuleMap is empty", (Object)entityNumber);
                    return null;
                }
                Set userGroupIdSet = userSyncRuleMap.values().stream().map(x -> x.get("usergroup_id")).collect(Collectors.toSet());
                UgSyncUserParam param = new UgSyncUserParam(userGroupIdSet, GrpUsrFromTypeEnum.EVENT_SYNC, this.getPermLogReq(event));
                UserGroupService.syncUserByUserGroup((UgSyncUserParam)param);
            }
        }
        catch (Exception e) {
            logger.warn("UgStdEvtListenPlugin.handleEvent, exception", (Throwable)e);
        }
        return null;
    }

    private PermLogReq getPermLogReq(EntityEvent event) {
        String operation;
        PermLogReq permLogReq = new PermLogReq();
        boolean enablePermLog = PermCommonUtil.isEnablePermLog();
        if (!enablePermLog) {
            permLogReq.setSignPermLog(Boolean.FALSE);
            return permLogReq;
        }
        String entityNumber = event.getEntityNumber();
        String opbtn = operation = event.getOperation();
        Map operationTypeInfoMap = OperationHelper.getOperationTypeInfoMap((String)entityNumber);
        for (Map.Entry entry : operationTypeInfoMap.entrySet()) {
            if (!operation.equals(entry.getKey())) continue;
            opbtn = (String)entry.getValue();
        }
        permLogReq.setSignPermLog(Boolean.TRUE);
        PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"usergroup_syncbyevent");
        permLogReq.setBusiFrom(null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
        permLogReq.setBusiType(null == permLogBusiType ? "" : permLogBusiType.getBusiType());
        permLogReq.setFormIdentity(entityNumber);
        permLogReq.setAppId(BizAppServiceHelp.getAppIdByFormNum((String)entityNumber));
        permLogReq.setOp(operation);
        permLogReq.setOpbtn(opbtn);
        permLogReq.setInterfaceMethod("kd.bos.permission.formplugin.plugin.eventcenter.UgStdEvtListenPlugin.handleEvent");
        permLogReq.setOperTime(TimeServiceHelper.now());
        RequestContext requestContext = RequestContext.get();
        permLogReq.setClientType(requestContext.getClient());
        permLogReq.setClientIp(StringUtils.isEmpty((String)requestContext.getLoginIP()) ? "[0:0:0:0:0:0:0:1]" : requestContext.getLoginIP());
        return permLogReq;
    }
}

