/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.field;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FieldPermSchemeHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.enums.EnumsFieldPermCtrlMode;
import kd.bos.permission.enums.EnumsFpsFieldFrom;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.FieldPermSchemeLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.util.StringUtils;

public class FieldPermSchemePlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(FieldPermSchemePlugin.class);
    private String PROP_APP = "app";
    private String PROP_ENT = "ent";
    private String PROP_ISSYSTEM = "issystem";
    private String PROP_FIELDFROM = "fieldfrom";
    private String PROP_SENSITIVE = "sensitive";
    private String PROP_CONTROLFIELDTYPE = "controlfieldtype";
    private String PROP_CONTROLMODE = "controlmode";
    private String PROP_FIELDPERM_FIELDNUM = "fieldperm_fieldnum";
    private String PROP_FIELDPERM_FIELDNAME = "fieldperm_fieldname";
    private String PROP_FIELDPERM_ROWCONDITION = "fieldperm_rowcondition";
    private String PROP_FIELDPERM_NOT_ALLOW_QUERY = "fieldperm_not_allow_query";
    private String PROP_DESC = "desc";
    private String PAGECACHEKEY_LASTSETTING = "lastSetting";
    private PermLogBusiType permLogBusiType = null;
    private String preData = "";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit entBdEdit = (BasedataEdit)this.getControl(this.PROP_ENT);
        entBdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        PermFormCommonUtil.entF7ChangeF7Caption(this.PROP_ENT, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"FieldPermSchemePlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), evt);
    }

    public void afterLoadData(EventObject e) {
        IPageCache parentViewPageCache;
        super.afterLoadData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{this.PROP_ISSYSTEM});
        IFormView parentView = this.getView().getParentView();
        if (null != parentView && null != (parentViewPageCache = parentView.getPageCache())) {
            String parentViewEntNum = parentViewPageCache.get("formShowCustomParam_entityNumviewdetail");
            String parentViewAppId = parentViewPageCache.get("formShowCustomParam_appIdviewdetail");
            if (StringUtils.isNotEmpty((String)parentViewEntNum)) {
                this.getModel().setValue(this.PROP_ENT, (Object)parentViewEntNum);
                this.getModel().setValue(this.PROP_APP, (Object)parentViewAppId);
                this.getView().setEnable(Boolean.FALSE, new String[]{this.PROP_ENT});
            }
        }
        this.buildControlFieldTypeComboEditInPlugin();
        this.setEnableControl();
        this.fullEntry();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!status.equals((Object)OperationStatus.VIEW)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{this.PROP_ENT, this.PROP_FIELDFROM, this.PROP_SENSITIVE});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconap"});
        }
        this.getModel().setDataChanged(false);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{this.PROP_ISSYSTEM});
        this.buildControlFieldTypeComboEditInPlugin();
        this.setEnableControl();
        this.fullEntry();
    }

    private void fullEntry() {
        IDataModel dataModel = this.getModel();
        Object entNumObj = dataModel.getValue("ent");
        Object fieldperm_entryObj = dataModel.getValue("fieldperm_entry");
        if (Objects.isNull(entNumObj) || Objects.isNull(fieldperm_entryObj)) {
            return;
        }
        DynamicObject entity = (DynamicObject)entNumObj;
        if (Objects.isNull(entity)) {
            return;
        }
        String entityNumber = entity.getString("number");
        Map fieldNameMap = FormHelper.getAllFieldsMultiEnt((String)entityNumber);
        DynamicObjectCollection fieldperm_entry = (DynamicObjectCollection)fieldperm_entryObj;
        HashMap<String, String> lastSetting = new HashMap<String, String>(fieldperm_entry.size());
        Iterator iterator = fieldperm_entry.iterator();
        while (iterator.hasNext()) {
            DynamicObject dyn;
            String fieldName = (dyn = (DynamicObject)iterator.next()).getString(this.PROP_FIELDPERM_FIELDNUM);
            dyn.set(this.PROP_FIELDPERM_FIELDNAME, (Object)(Objects.isNull(fieldNameMap.get(fieldName)) ? "" : (String)fieldNameMap.get(fieldName)));
            String controlMode = dyn.getString(this.PROP_FIELDPERM_ROWCONDITION);
            if (Objects.equals(EnumsFieldPermCtrlMode.FORBID_VIEW.getType(), controlMode)) {
                dyn.set(this.PROP_FIELDPERM_NOT_ALLOW_QUERY, (Object)"1");
            } else if (Objects.equals(EnumsFieldPermCtrlMode.FORBID_EDIT.getType(), controlMode)) {
                dyn.set(this.PROP_FIELDPERM_NOT_ALLOW_QUERY, (Object)"0");
            }
            lastSetting.put(fieldName, fieldName + "|" + controlMode);
        }
        this.getPageCache().put(this.PAGECACHEKEY_LASTSETTING, SerializationUtils.toJsonString(lastSetting));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setEnableControl();
        String prevFocusEntNum = (String)this.getView().getFormShowParameter().getCustomParam("formShowCustomParam_entityNum");
        String prevFocusEntAppId = (String)this.getView().getFormShowParameter().getCustomParam("formShowCustomParam_appId");
        if (StringUtils.isNotEmpty((String)prevFocusEntNum)) {
            this.getModel().setValue(this.PROP_ENT, (Object)prevFocusEntNum);
            this.getModel().setValue(this.PROP_APP, (Object)prevFocusEntAppId);
            this.getView().setEnable(Boolean.FALSE, new String[]{this.PROP_ENT});
        } else {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String entityNum = String.valueOf(customParams.get("FieldPermScheme_entityNum"));
            String treeSelected = String.valueOf(customParams.get("FieldPermScheme_treeSelected"));
            if (entityNum != null && !entityNum.equals("null")) {
                this.getModel().setValue(this.PROP_ENT, (Object)entityNum);
                this.getView().setEnable(Boolean.FALSE, new String[]{this.PROP_ENT});
            } else if (treeSelected != null && !treeSelected.equals("null")) {
                this.getModel().setValue(this.PROP_ENT, (Object)treeSelected);
                this.getView().setEnable(Boolean.FALSE, new String[]{this.PROP_ENT});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{this.PROP_ENT});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (Objects.equals(this.PROP_FIELDFROM, propName)) {
            this.setEnableControl();
            this.buildControlFieldTypeComboEditInPlugin();
        } else if (Objects.equals("fieldperm_not_allow_query", propName)) {
            EntryGrid eg = (EntryGrid)this.getControl("fieldperm_entry");
            int[] selectRows = eg.getSelectRows();
            String lastSettingStr = this.getPageCache().get(this.PAGECACHEKEY_LASTSETTING);
            if (StringUtils.isEmpty((String)lastSettingStr)) {
                lastSettingStr = "{}";
            }
            Map lastSetting = (Map)SerializationUtils.fromJsonString((String)lastSettingStr, Map.class);
            String fieldName = (String)this.getModel().getValue("fieldperm_fieldnum", selectRows[0]);
            boolean notAllowQuery = (Boolean)newValue;
            String controlMode = notAllowQuery ? EnumsFieldPermCtrlMode.FORBID_VIEW.getType() : EnumsFieldPermCtrlMode.FORBID_EDIT.getType();
            lastSetting.put(fieldName, fieldName + "|" + controlMode);
            if (notAllowQuery) {
                this.getModel().setValue("fieldperm_not_allow_edit", (Object)true, selectRows[0]);
            }
            this.getModel().setValue("fieldperm_rowcondition", (Object)controlMode);
            this.getPageCache().put(this.PAGECACHEKEY_LASTSETTING, SerializationUtils.toJsonString((Object)lastSetting));
        } else if (Objects.equals(this.PROP_ENT, propName)) {
            this.buildControlFieldTypeComboEditInPlugin();
        }
    }

    private void buildControlFieldTypeComboEditInPlugin() {
        Object entNumObj = this.getModel().getValue(this.PROP_ENT);
        if (Objects.isNull(entNumObj) || Objects.isNull((DynamicObject)entNumObj)) {
            return;
        }
        DynamicObject dyn = (DynamicObject)entNumObj;
        String entNum = dyn.getString("number");
        ComboEdit selectControlFieldTypeComboEdit = (ComboEdit)this.getControl("controlfieldtype");
        FieldPermSchemeHelper.buildControlFieldTypeComboEdit((String)entNum, (ComboEdit)selectControlFieldTypeComboEdit);
    }

    private void setEnableControl() {
        IDataModel dataModel = this.getModel();
        String fieldfrom = (String)dataModel.getValue(this.PROP_FIELDFROM);
        IFormView view = this.getView();
        if (Objects.equals(EnumsFpsFieldFrom.FIELD.getType(), fieldfrom)) {
            this.getModel().setValue(this.PROP_CONTROLFIELDTYPE, (Object)"");
            this.getModel().setValue(this.PROP_CONTROLMODE, (Object)"");
            view.setEnable(Boolean.valueOf(false), new String[]{this.PROP_CONTROLFIELDTYPE, this.PROP_CONTROLMODE});
            view.setEnable(Boolean.valueOf(true), new String[]{"advconap"});
        } else if (Objects.equals(EnumsFpsFieldFrom.FIELD_TYPE.getType(), fieldfrom)) {
            this.getModel().deleteEntryData("fieldperm_entry");
            view.setEnable(Boolean.valueOf(false), new String[]{"advconap"});
            view.setEnable(Boolean.valueOf(true), new String[]{this.PROP_CONTROLFIELDTYPE, this.PROP_CONTROLMODE});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (!(source instanceof FormOperate)) {
            e.setCancel(true);
            return;
        }
        FormOperate op = (FormOperate)source;
        String opKey = op.getOperateKey();
        Object prop_fieldfrom = this.getModel().getValue(this.PROP_FIELDFROM);
        switch (opKey) {
            case "donothing_choosefield": {
                if (Objects.equals(EnumsFpsFieldFrom.FIELD_TYPE.getType(), String.valueOf(prop_fieldfrom))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6309\u5b57\u6bb5\u5c5e\u6027\u201d\u7684\u65b9\u6848\u65e0\u9700\u8bbe\u7f6e\u5b57\u6bb5\u3002", (String)"FieldPermSchemePlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    e.setCancel(true);
                    return;
                }
                Object entNum = this.getModel().getValue(this.PROP_ENT);
                if (!Objects.isNull(entNum)) break;
                this.getView().showTipNotification(ConstantsHelper.getDesc_PleaseChooseEntNodeFirst(), Integer.valueOf(2000));
                e.setCancel(true);
                return;
            }
            case "deleteentry_fieldperm": {
                if (Objects.equals(EnumsFpsFieldFrom.FIELD_TYPE.getType(), String.valueOf(prop_fieldfrom))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6309\u5b57\u6bb5\u5c5e\u6027\u201d\u7684\u65b9\u6848\u65e0\u9700\u8bbe\u7f6e\u5b57\u6bb5\u3002", (String)"FieldPermSchemePlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    e.setCancel(true);
                    return;
                }
                List<String> delFieldPerm = this.getDelFieldPerm();
                if (!CollectionUtils.isEmpty(delFieldPerm)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u5220\u9664\u7684\u884c\u3002", (String)"FieldPermSchemePlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "save": {
                if (Objects.equals(EnumsFpsFieldFrom.FIELD_TYPE.getType(), String.valueOf(prop_fieldfrom))) {
                    String controlfieldtype = (String)this.getModel().getValue(this.PROP_CONTROLFIELDTYPE);
                    String controlmode = (String)this.getModel().getValue(this.PROP_CONTROLMODE);
                    if (StringUtils.isEmpty((String)controlfieldtype)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6309\u5b57\u6bb5\u5c5e\u6027\u201d\u7684\u65b9\u6848\uff0c\u5fc5\u987b\u8bbe\u7f6e\u201c\u63a7\u4ef6\u5b57\u6bb5\u7c7b\u578b\u201d\u3002", (String)"FieldPermSchemePlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                    if (StringUtils.isEmpty((String)controlmode)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6309\u5b57\u6bb5\u5c5e\u6027\u201d\u7684\u65b9\u6848\uff0c\u5fc5\u987b\u8bbe\u7f6e\u201c\u63a7\u5236\u6a21\u5f0f\u201d\u3002", (String)"FieldPermSchemePlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                }
                if (Objects.equals(EnumsFpsFieldFrom.FIELD.getType(), String.valueOf(prop_fieldfrom))) {
                    int count = this.getModel().getEntryRowCount("fieldperm_entry");
                    if (Objects.equals(0, count)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6309\u5b57\u6bb5\u201d\u7684\u65b9\u6848\uff0c\u5fc5\u987b\u8bbe\u7f6e\u201c\u5b57\u6bb5\u6743\u9650\u660e\u7ec6\u201d\u3002", (String)"FieldPermSchemePlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                        return;
                    }
                }
                if (!PermCommonUtil.isEnablePermLog()) break;
                Long mainId = (Long)this.getModel().getDataEntity().getPkValue();
                this.permLogBusiType = null == mainId || 0L == mainId ? PermLogService.getPermLogBusiType((String)"fps_add_save") : PermLogService.getPermLogBusiType((String)"fps_modify_save");
                this.preData = FieldPermSchemeLogHelper.snapshot((Long)mainId, (boolean)false);
                break;
            }
            case "disable": 
            case "enable": {
                boolean dataChanged = this.getModel().getDataChanged();
                if (dataChanged) {
                    String please_save_first = ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"FieldPermSchemePlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                    e.setCancel(true);
                    e.setCancelMessage(please_save_first);
                    this.getView().showTipNotification(please_save_first);
                    return;
                }
                if (!PermCommonUtil.isEnablePermLog()) break;
                Long mainId = (Long)this.getModel().getDataEntity().getPkValue();
                this.permLogBusiType = "disable".equals(opKey) ? PermLogService.getPermLogBusiType((String)"fps_disable") : PermLogService.getPermLogBusiType((String)"fps_enable");
                this.preData = FieldPermSchemeLogHelper.snapshot((Long)mainId, (boolean)false);
                break;
            }
        }
    }

    private List<String> getDelFieldPerm() {
        EntryGrid eg = (EntryGrid)this.getControl("fieldperm_entry");
        int[] selectRows = eg.getSelectRows();
        ArrayList<String> data = new ArrayList<String>(selectRows.length);
        for (int selectRow : selectRows) {
            String filedNum = (String)this.getModel().getValue("fieldperm_fieldnum", selectRow);
            data.add(filedNum);
        }
        return data;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Object source = e.getSource();
        if (!(source instanceof FormOperate)) {
            return;
        }
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        boolean success = null == operationResult ? false : operationResult.isSuccess();
        switch (operateKey) {
            case "donothing_choosefield": {
                this.showFieldForm("fieldperm_entry");
                break;
            }
            case "save": {
                if (success) {
                    CacheMrg.clearAllCache();
                }
                if (!success || !PermCommonUtil.isEnablePermLog()) break;
                long successPkId = (Long)operationResult.getSuccessPkIds().get(0);
                String opbtn = ConstantsHelper.getSave();
                this.ready2PermLog(operateKey, successPkId, opbtn);
                break;
            }
            case "disable": 
            case "enable": {
                if (success) {
                    CacheMrg.clearAllCache();
                }
                if (!success || !PermCommonUtil.isEnablePermLog()) break;
                long successPkId = (Long)operationResult.getSuccessPkIds().get(0);
                String opbtn = "disable".equals(operateKey) ? ConstantsHelper.getDisable() : ConstantsHelper.getEnable();
                this.ready2PermLog(operateKey, successPkId, opbtn);
                break;
            }
        }
    }

    private void ready2PermLog(String operateKey, long successPkId, String opbtn) {
        if (PermCommonUtil.isEnablePermLog()) {
            String number = this.getModel().getValue("number").toString();
            String name = ((ILocaleString)this.getModel().getValue("name")).getLocaleValue();
            String afterData = FieldPermSchemeLogHelper.snapshot((Long)successPkId, (boolean)true);
            this.addPermLog(operateKey, opbtn, String.valueOf(successPkId), number, name, this.preData, afterData, this.permLogBusiType);
        }
    }

    private void addPermLog(String op, String opbtn, String opItemId, String opItemNumber, String opItemName, String preData, String afterData, PermLogBusiType permLogBusiType) {
        try {
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.plugin.field.FieldPermSchemePlugin.addPermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("pre_data", preData);
            map.put("after_data", afterData);
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("FieldPermSchemePlugin.addPermLog error, opItemId:{}, opItemName:{}", new Object[]{opItemId, opItemName, e});
        }
    }

    private void showFieldForm(String pageType) {
        Object entNum;
        String entityNum = "";
        String idField = "";
        String nameField = "";
        int listRowCount = 0;
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)"perm_choosefieldpage", (boolean)true, (int)0, (boolean)true);
        if ("fieldperm_entry".equals(pageType)) {
            entNum = this.getModel().getValue(this.PROP_ENT);
            if (Objects.isNull(entNum) || Objects.isNull((DynamicObject)entNum)) {
                this.getView().showTipNotification(ConstantsHelper.getDesc_PleaseChooseEntNodeFirst(), Integer.valueOf(2000));
                return;
            }
        } else {
            return;
        }
        DynamicObject dyn = (DynamicObject)entNum;
        entityNum = dyn.getString("number");
        idField = "fieldperm_fieldnum";
        nameField = "fieldperm_fieldname";
        listRowCount = this.getModel().getEntryRowCount("fieldperm_entry");
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "perm_choosefieldpage"));
        HashSet<String> idSet = new HashSet<String>();
        String id = null;
        String name = null;
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        StringBuilder key = new StringBuilder();
        for (int index = 0; index < listRowCount; ++index) {
            id = (String)this.getModel().getValue(idField, index);
            name = (String)this.getModel().getValue(nameField, index);
            key.append(id).append("||").append(name);
            ListSelectedRow listSelectedRow = new ListSelectedRow((Object)key.toString(), Boolean.FALSE);
            listSelectedRow.setName(name);
            listSelectedRow.setNumber(id);
            listSelectedRowCollection.add((Object)listSelectedRow);
            if (StringUtils.isNotEmpty((String)id)) {
                idSet.add(id);
            }
            key.setLength(0);
        }
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("paramEntityName", (Object)entityNum);
        fsp.setCustomParam("paramAllReadySelectedPropertyNameSet", idSet);
        fsp.setListSelectedRowCollection(listSelectedRowCollection);
        fsp.setShowTitle(true);
        fsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "perm_choosefieldpage": {
                this.handleAddFieldPermCallBack(returnData);
                break;
            }
        }
    }

    private void handleAddFieldPermCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection col = (ListSelectedRowCollection)returnData;
            Object entObj = this.getModel().getValue(this.PROP_ENT);
            if (Objects.isNull(entObj) || Objects.isNull((DynamicObject)entObj)) {
                return;
            }
            DynamicObject dyn = (DynamicObject)entObj;
            String entityNum = dyn.getString("number");
            Map fieldNameMap = FormHelper.getAllFieldsMultiEnt((String)entityNum);
            String lastSettingStr = this.getPageCache().get(this.PAGECACHEKEY_LASTSETTING);
            if (StringUtils.isEmpty((String)lastSettingStr)) {
                lastSettingStr = "{}";
            }
            Map lastSetting = (Map)SerializationUtils.fromJsonString((String)lastSettingStr, Map.class);
            LinkedHashMap<String, String> currentSetting = new LinkedHashMap<String, String>(col.size());
            for (ListSelectedRow row : col) {
                String value;
                String primaryKeyValue = (String)row.getPrimaryKeyValue();
                String[] arr = primaryKeyValue.split("\\|\\|");
                String fieldName = arr[0];
                String fieldComment = arr[1];
                if (!fieldNameMap.containsKey(fieldName)) {
                    fieldNameMap.put(fieldName, fieldComment);
                }
                if (StringUtils.isEmpty((String)(value = (String)lastSetting.get(fieldName)))) {
                    currentSetting.put(fieldName, fieldName + "|" + EnumsFieldPermCtrlMode.FORBID_VIEW.getType());
                    continue;
                }
                currentSetting.put(fieldName, value);
            }
            this.getPageCache().put(this.PAGECACHEKEY_LASTSETTING, SerializationUtils.toJsonString(currentSetting));
            this.fillFieldPermToPage(fieldNameMap, currentSetting);
        }
    }

    private void fillFieldPermToPage(Map<String, Object> fieldNameMap, Map<String, String> fieldPermDetail) {
        this.getModel().deleteEntryData("fieldperm_entry");
        if (CollectionUtils.isEmpty(fieldPermDetail)) {
            return;
        }
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("fieldperm_fieldnum", new Object[0]);
        vs.addField("fieldperm_fieldname", new Object[0]);
        vs.addField("fieldperm_rowcondition", new Object[0]);
        vs.addField("fieldperm_not_allow_query", new Object[0]);
        vs.addField("fieldperm_not_allow_edit", new Object[0]);
        boolean showMessage = false;
        StringBuilder message = new StringBuilder();
        boolean notAllowEdit = true;
        for (String info : fieldPermDetail.values()) {
            String[] arr = info.split("\\|");
            String fieldName = arr[0];
            Object fieldCommentObj = fieldNameMap.get(fieldName);
            if (null == fieldCommentObj) continue;
            String fieldComment = (String)fieldCommentObj;
            String controlMode = arr[1];
            boolean notAllowQuery = Objects.equals(EnumsFieldPermCtrlMode.FORBID_VIEW.getType(), controlMode);
            if ("0".equals(controlMode)) {
                notAllowEdit = false;
                showMessage = true;
                message.append(fieldComment).append(",");
            }
            vs.addRow(new Object[]{fieldName, fieldComment, controlMode, notAllowQuery, notAllowEdit});
        }
        ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("fieldperm_entry", vs);
        dataModel.endInit();
        this.getView().updateView("fieldperm_entry");
        if (showMessage) {
            message.deleteCharAt(message.length() - 1);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u5b58\u5728\u201c\u7981\u6b62\u7f16\u8f91\u201d\u4e3a\u5426\u7684\u914d\u7f6e\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u6216\u79fb\u9664\u5f02\u5e38\u6570\u636e\u3002", (String)"FieldPermSchemePlugin_8", (String)"bos-permission-formplugin", (Object[])new Object[]{message.toString()}), Integer.valueOf(3000));
        }
    }
}

