/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.field;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.FuncPermTreeUtil;
import kd.bos.permission.log.helper.FieldPermSchemeLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.permission.model.perm.FieldPermScheme;
import kd.bos.util.StringUtils;

public class FieldPermSchemeTreeListPlugin
extends AbstractTreeListPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(FieldPermSchemeTreeListPlugin.class);
    private FuncPermTreeUtil funcPermTreeUtil = null;
    private String FOCUSNODEID_FLAG = "focusNodeId";
    PermLogBusiType permLogBusiType = null;
    private Map<Long, String> preDataMap = null;

    public void setFilter(SetFilterEvent e) {
        String orderBy;
        super.setFilter(e);
        HashSet<String> entNumSet = new HashSet<String>(8);
        Map<String, String> allPermNodeInfoMap = this.funcPermTreeUtil.getAllPermNodeInfoMap();
        Collection<String> values = allPermNodeInfoMap.values();
        if (null != values && !values.isEmpty()) {
            for (String value : values) {
                String[] arr = value.split("    ");
                String entityNum = arr[6];
                entNumSet.add(entityNum);
            }
            e.getQFilters().add(new QFilter("ent", "in", entNumSet));
        }
        orderBy = StringUtils.isEmpty((String)(orderBy = e.getOrderBy())) ? "number desc" : orderBy + ", number desc";
        e.setOrderBy(orderBy);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter fsp = e.getFormShowParameter();
        String showFormSpecial = (String)fsp.getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        if (null == this.funcPermTreeUtil) {
            this.funcPermTreeUtil = new FuncPermTreeUtil(this.getPageCache());
        }
    }

    public void initializeTree(EventObject e) {
        TreeNode rootNode = null;
        try {
            HashMap<String, Object> allFunPermTreeParaMap = new HashMap<String, Object>();
            allFunPermTreeParaMap.put("dimType", "bos_org");
            allFunPermTreeParaMap.put("dimDiffHide", "0");
            allFunPermTreeParaMap.put("filterBySysCloudApp", false);
            allFunPermTreeParaMap.put("fieldDrSpecialLeftTreeHide", true);
            List<String> dataBeanInfos = this.funcPermTreeUtil.getAllFuncPermTreeData(allFunPermTreeParaMap);
            HashMap<String, Map<String, List<String>>> dataResource = new HashMap<String, Map<String, List<String>>>(16);
            this.funcPermTreeUtil.processData(true, dataResource, dataBeanInfos);
            this.getPageCache().putBigObject("bos_org", SerializationUtils.toJsonString(dataResource));
            rootNode = ConstantsHelper.getTreeRootNode((boolean)true, (String)ConstantsHelper.getAllDesc());
            rootNode.setIsOpened(true);
            TreeView tv = (TreeView)this.getControl("treeview");
            tv.addNode(rootNode);
            this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, false);
            tv.focusNode(rootNode);
            tv.treeNodeClick(rootNode.getParentid(), rootNode.getId());
            this.getPageCache().putBigObject("treeview", SerializationUtils.toJsonString((Object)rootNode));
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
            return;
        }
        this.getTreeModel().setRoot(rootNode);
        this.getTreeModel().setCurrentNodeId((Object)rootNode.getId());
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardview"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeview = (TreeView)this.getControl("treeview");
        if (treeview != null) {
            treeview.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent e) {
        TreeView tv = (TreeView)e.getSource();
        String nodeId = (String)e.getNodeId();
        switch (tv.getKey()) {
            case "treeview": {
                boolean showNum = (Boolean)this.getModel().getValue("shownum");
                Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject("bos_org"), Map.class);
                this.funcPermTreeUtil.commonAddNode(tv, nodeId, dataResource, showNum);
                break;
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeId = (String)evt.getNodeId();
        TreeView tv = (TreeView)evt.getSource();
        String key = tv.getKey();
        if (Objects.equals("treeview", key)) {
            this.getPageCache().put(this.FOCUSNODEID_FLAG, nodeId);
        }
    }

    protected QFilter nodeClickFilter() {
        String[] permInfoFromNodeId;
        QFilter filter = new QFilter("issystem", "=", (Object)"0");
        String focusNodeId = this.getFocusNodeId();
        QFilter noDataQfilter = new QFilter("id", "=", (Object)0L);
        if (StringUtils.isEmpty((String)focusNodeId)) {
            return noDataQfilter;
        }
        if (Objects.equals("-1", focusNodeId)) {
            return filter;
        }
        if (focusNodeId.startsWith("cloud#")) {
            String[] permInfoFromNodeId2 = PermCommonUtil.getPermInfoFromNodeId((String)"cloud#", (String)focusNodeId);
            if (null != permInfoFromNodeId2 && !Objects.equals(0, permInfoFromNodeId2.length) && !StringUtils.isEmpty((String)permInfoFromNodeId2[0])) {
                Set<String> entNumSet = this.getEntNumSetByNode(permInfoFromNodeId2[0], "cloud#");
                filter = null == filter ? new QFilter("ent", "in", entNumSet) : filter.and(new QFilter("ent", "in", entNumSet));
            }
        } else if (focusNodeId.startsWith("app#")) {
            String[] permInfoFromNodeId3 = PermCommonUtil.getPermInfoFromNodeId((String)"app#", (String)focusNodeId);
            if (null != permInfoFromNodeId3 && !Objects.equals(0, permInfoFromNodeId3.length) && !StringUtils.isEmpty((String)permInfoFromNodeId3[0])) {
                Set<String> entNumSet = this.getEntNumSetByNode(permInfoFromNodeId3[0], "app#");
                filter = null == filter ? new QFilter("ent", "in", entNumSet) : filter.and(new QFilter("ent", "in", entNumSet));
            }
        } else if (focusNodeId.startsWith("entity#") && null != (permInfoFromNodeId = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)focusNodeId)) && !Objects.equals(0, permInfoFromNodeId.length) && !StringUtils.isEmpty((String)permInfoFromNodeId[1])) {
            filter = null == filter ? new QFilter("ent", "=", (Object)permInfoFromNodeId[1]) : filter.and(new QFilter("ent", "=", (Object)permInfoFromNodeId[1]));
        }
        return filter;
    }

    private Set<String> getEntNumSetByNode(String cloudIdOrAppId, String type) {
        HashSet<String> set = new HashSet<String>(8);
        if (StringUtils.isEmpty((String)cloudIdOrAppId)) {
            return set;
        }
        Map<String, String> allPermNodeInfoMap = this.funcPermTreeUtil.getAllPermNodeInfoMap();
        Collection<String> values = allPermNodeInfoMap.values();
        if (null != values && !values.isEmpty()) {
            for (String value : values) {
                String[] arr = value.split("    ");
                String cloudId = arr[2];
                String appId = arr[5];
                String entityNum = arr[6];
                if (Objects.equals("cloud#", type) && Objects.equals(cloudIdOrAppId, cloudId)) {
                    set.add(entityNum);
                    continue;
                }
                if (!Objects.equals("app#", type) || !Objects.equals(cloudIdOrAppId, appId)) continue;
                set.add(entityNum);
            }
        }
        return set;
    }

    private String getFocusNodeId() {
        String focusNodeId = this.getView().getPageCache().get(this.FOCUSNODEID_FLAG);
        if (StringUtils.isEmpty((String)focusNodeId)) {
            TreeView tv = (TreeView)this.getControl("treeview");
            focusNodeId = tv.getTreeState().getFocusNodeId();
        }
        return focusNodeId;
    }

    public void search(SearchEnterEvent evt) {
        super.search(evt);
        Search source = (Search)evt.getSource();
        String key = source.getKey();
        String text = evt.getText();
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        if ("searchap".equals(key)) {
            if (StringUtils.isBlank((String)text)) {
                this.getPageCache().removeBigObject("allFuncPermTreeSearchMode");
                TreeView tv = (TreeView)this.getControl("treeview");
                this.funcPermTreeUtil.initFuncPermLeftTree(tv, "bos_org", showNum);
                TreeNode rootNode = ConstantsHelper.getTreeRootNode((boolean)true, (String)ConstantsHelper.getAllDesc());
                rootNode.setIsOpened(true);
                tv.focusNode(rootNode);
                tv.treeNodeClick(rootNode.getParentid(), rootNode.getId());
            } else {
                Map<String, String> allPermNodeInfoMap = this.funcPermTreeUtil.getAllPermNodeInfoMap();
                Map<String, String> entityAssignablePermItemMap = this.funcPermTreeUtil.getEntityAssignablePermItemMap();
                Map<String, String> permItemIdNumberMap = this.funcPermTreeUtil.getPermItemIdNumberMap();
                Collection<String> values = allPermNodeInfoMap.values();
                ArrayList<String> searchInfos = new ArrayList<String>(100);
                for (String value : values) {
                    String[] permItemIdArr;
                    String permItemStr;
                    String[] arr = value.split("    ");
                    String entityName = arr[7];
                    String entityNum = arr[6];
                    if (!entityName.contains(text) && (!showNum || !entityNum.equals(text)) || !StringUtils.isNotEmpty((String)(permItemStr = entityAssignablePermItemMap.get(entityNum)))) continue;
                    for (String permItemId : permItemIdArr = permItemStr.split(",")) {
                        if (StringUtils.isEmpty((String)permItemId)) continue;
                        String permItemNum = permItemIdNumberMap.get(permItemId);
                        searchInfos.add(String.join((CharSequence)"    ", value, permItemNum, permItemId));
                    }
                }
                this.getPageCache().putBigObject("allFuncPermTreeSearchMode", SerializationUtils.toJsonString(searchInfos));
                this.rebuildTree("treeview", searchInfos, true);
            }
        }
    }

    private void rebuildTree(String treeView, List<String> searchInfos, boolean funcPermTree) {
        TreeNode rootNode = null;
        TreeView tv = null;
        switch (treeView) {
            case "treeview": {
                rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllDesc());
                rootNode.setIsOpened(true);
                tv = (TreeView)this.getControl("treeview");
                break;
            }
            default: {
                return;
            }
        }
        tv.deleteAllNodes();
        tv.addNode(rootNode);
        Map<String, String> cloudNameMap = this.funcPermTreeUtil.getCloudNameMap();
        Map<String, String> appNameMap = this.funcPermTreeUtil.getAppNameMap();
        Map<String, String> entityNumNameMap = this.funcPermTreeUtil.getEntityNumNameMap();
        Map<String, String> permItemIdNameMap = this.funcPermTreeUtil.getPermItemIdNameMap();
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        if (!CollectionUtils.isEmpty(searchInfos)) {
            String lastKey = "";
            String lastEntityNode = "";
            TreeNode cloudNode = null;
            TreeNode appNode = null;
            TreeNode entityNode = null;
            String entityNodeId = "";
            for (String searchInfo : searchInfos) {
                String appNodeId;
                String[] arr = searchInfo.split("    ");
                String cloudId = arr[2];
                if ("2HGKCE94QELW".equals(cloudId)) continue;
                String appId = arr[5];
                String entityNum = arr[6];
                String curKey = cloudId + '_' + appId + '_' + entityNum;
                if (lastKey.equals(curKey)) continue;
                lastKey = curKey;
                String cloudNodeId = "cloud#" + cloudId;
                cloudNode = rootNode.getTreeNode(cloudNodeId);
                if (cloudNode == null) {
                    String cloudName = cloudNameMap.get(cloudId);
                    if (StringUtils.isEmpty((String)cloudName)) {
                        cloudName = cloudId;
                    }
                    if (showNum) {
                        String cloudNumber = StringUtils.isEmpty((String)arr[1]) ? "NotFound" : arr[1];
                        cloudName = cloudName + '(' + cloudNumber + ')';
                    }
                    cloudNode = new TreeNode("-1", cloudNodeId, cloudName);
                    cloudNode.setIsOpened(true);
                    rootNode.addChild(cloudNode);
                }
                if ((appNode = cloudNode.getTreeNode(appNodeId = "app#" + appId)) == null) {
                    String appName = appNameMap.get(appId);
                    if (StringUtils.isEmpty((String)appName)) {
                        appName = appId;
                    }
                    if (showNum) {
                        String appNumber = StringUtils.isEmpty((String)arr[4]) ? "NotFound" : arr[4];
                        appName = appName + '(' + appNumber + ')';
                    }
                    appNode = new TreeNode(cloudNodeId, appNodeId, appName);
                    appNode.setIsOpened(true);
                    cloudNode.addChild(appNode);
                }
                entityNodeId = "entity#" + entityNum + '@' + appId;
                if (!lastEntityNode.equals("") && lastEntityNode.equals(entityNodeId) && funcPermTree) continue;
                lastEntityNode = entityNodeId;
                entityNode = appNode.getTreeNode(entityNodeId);
                if (entityNode != null) continue;
                String entityName = entityNumNameMap.get(entityNum);
                if (StringUtils.isEmpty((String)entityName)) {
                    entityName = entityNum;
                    entityNum = "NotFound";
                }
                if (showNum) {
                    entityName = entityName + '(' + entityNum + ')';
                }
                entityNode = new TreeNode(appNodeId, entityNodeId, entityName);
                appNode.addChild(entityNode);
            }
        }
        tv.focusNode(rootNode);
        tv.treeNodeClick(rootNode.getParentid(), rootNode.getId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (Objects.equals("shownum", propName)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"FieldPermSchemeTreeListPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0])));
            boolean showNum = (Boolean)this.getModel().getValue("shownum");
            Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject("bos_org"), Map.class);
            TreeView tv = (TreeView)this.getControl("treeview");
            tv.deleteAllNodes();
            TreeNode rootNode = ConstantsHelper.getTreeRootNode((boolean)true, (String)ConstantsHelper.getAllDesc());
            rootNode.setIsOpened(true);
            tv.addNode(rootNode);
            this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, showNum);
            tv.focusNode(rootNode);
            tv.treeNodeClick(rootNode.getParentid(), rootNode.getId());
            Search search = (Search)this.getControl("searchap");
            search.setSearchKey("");
            this.getPageCache().putBigObject("treeview", SerializationUtils.toJsonString((Object)rootNode));
            this.getModel().setDataChanged(false);
            this.getView().hideLoading();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter bsp = e.getParameter();
        if (bsp.getStatus() == OperationStatus.ADDNEW) {
            String entNum;
            String appId;
            String focusNodeId = this.getFocusNodeId();
            if (StringUtils.isEmpty((String)focusNodeId) || Objects.equals("-1", focusNodeId)) {
                return;
            }
            if (!focusNodeId.startsWith("entity#")) {
                return;
            }
            String[] permInfoFromNodeId = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)focusNodeId);
            if (null == permInfoFromNodeId || Objects.equals(0, permInfoFromNodeId.length)) {
                return;
            }
            if (bsp.getCustomParams() == null) {
                bsp.setCustomParams(new HashMap());
            }
            if (StringUtils.isNotEmpty((String)(appId = permInfoFromNodeId[0]))) {
                bsp.setCustomParam("formShowCustomParam_appId", (Object)appId);
            }
            if (StringUtils.isNotEmpty((String)(entNum = permInfoFromNodeId[1]))) {
                bsp.setCustomParam("formShowCustomParam_entityNum", (Object)entNum);
            }
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String str = this.getPageCache().getBigObject("treeview");
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)str, TreeNode.class);
        e.setNodeId((Object)rootNode.getId());
        e.setChildNodes(rootNode.getChildren());
        super.refreshNode(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if (!"refresh".equals(operateKey) && ("disable".equals(operateKey) || "enable".equals(operateKey) || "delete".equals(operateKey)) && PermCommonUtil.isEnablePermLog()) {
            String langStr = RequestContext.get().getLang().name();
            this.permLogBusiType = "disable".equals(operateKey) ? PermLogService.getPermLogBusiType((String)"fps_disable") : ("enable".equals(operateKey) ? PermLogService.getPermLogBusiType((String)"fps_enable") : PermLogService.getPermLogBusiType((String)"fps_del"));
            Object[] mainIdArr = e.getListSelectedData().getPrimaryKeyValues();
            if (null == mainIdArr || 0 == mainIdArr.length) {
                e.setCancel(true);
                return;
            }
            int size = mainIdArr.length;
            this.preDataMap = new HashMap<Long, String>(size);
            Set mainIdLongSet = Stream.of(mainIdArr).map(x -> (Long)x).collect(Collectors.toSet());
            for (Long mainId : mainIdLongSet) {
                this.preDataMap.put(mainId, FieldPermSchemeLogHelper.snapshot((Long)mainId, (boolean)false));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        List successPkIds;
        OperationResult operationResult;
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if ("refresh".equals(opKey)) {
            TreeView tv = (TreeView)this.getControl("treeview");
            Map focusNode = tv.getTreeState().getFocusNode();
            String nodeId = (String)focusNode.get("id");
            if (nodeId.startsWith("cloud#")) {
                boolean showNum = (Boolean)this.getModel().getValue("shownum");
                Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject("bos_org"), Map.class);
                this.funcPermTreeUtil.commonAddNode(tv, nodeId, dataResource, showNum);
            }
            String parentId = (String)focusNode.get("parentid");
            tv.treeNodeClick(parentId, nodeId);
        } else if (("disable".equals(opKey) || "enable".equals(opKey) || "delete".equals(opKey)) && null != (operationResult = e.getOperationResult()) && null != (successPkIds = operationResult.getSuccessPkIds()) && !successPkIds.isEmpty()) {
            CacheMrg.clearAllCache();
            if (PermCommonUtil.isEnablePermLog()) {
                int size = successPkIds.size();
                HashMap<Long, String> afterDataMap = new HashMap<Long, String>(size);
                HashMap<Long, String> finalPreDataMap = new HashMap<Long, String>(size);
                Set<Long> successPkIdSet = successPkIds.stream().map(x -> (Long)x).collect(Collectors.toSet());
                for (Long successPkId : successPkIdSet) {
                    afterDataMap.put(successPkId, FieldPermSchemeLogHelper.snapshot((Long)successPkId, (boolean)true));
                    finalPreDataMap.put(successPkId, this.preDataMap.get(successPkId));
                }
                String opbtn = "disable".equals(opKey) ? ConstantsHelper.getDisable() : ("enable".equals(opKey) ? ConstantsHelper.getEnable() : ConstantsHelper.getDel());
                this.addPermLog(opKey, opbtn, finalPreDataMap, afterDataMap, this.permLogBusiType, successPkIdSet);
            }
        }
    }

    private void addPermLog(String op, String opbtn, Map<Long, String> preDataMap, Map<Long, String> afterDataMap, PermLogBusiType permLogBusiType, Set<Long> successPkIdSet) {
        try {
            if (null == successPkIdSet || successPkIdSet.isEmpty()) {
                return;
            }
            String formNum = "perm_fieldscheme";
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            ArrayList list = new ArrayList(successPkIdSet.size());
            for (Long successPkId : successPkIdSet) {
                FieldPermScheme fieldPermScheme;
                String preData = preDataMap.get(successPkId);
                String afterData = afterDataMap.get(successPkId);
                FieldPermScheme fieldPermScheme2 = fieldPermScheme = StringUtils.isEmpty((String)preData) ? (FieldPermScheme)new ObjectMapper().readValue(afterData, FieldPermScheme.class) : (FieldPermScheme)new ObjectMapper().readValue(preData, FieldPermScheme.class);
                if (null == fieldPermScheme) continue;
                String opItemId = String.valueOf(fieldPermScheme.getId());
                String opItemNumber = fieldPermScheme.getNumber();
                String opItemName = fieldPermScheme.getName();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("number", PermLogUtil.getPermLogFnumber());
                map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
                map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
                map.put("cloud_id", cloudId);
                map.put("app_id", appId);
                map.put("form_identity", formNum);
                map.put("op", op);
                map.put("opbtn", opbtn);
                map.put("interface_method", "kd.bos.permission.formplugin.plugin.field.FieldPermSchemeTreeListPlugin.addPermLog");
                map.put("op_item_id", opItemId);
                map.put("op_item_number", opItemNumber);
                map.put("op_item_name", opItemName);
                map.put("pre_data", preData);
                map.put("after_data", afterData);
                list.add(map);
            }
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("FieldPermSchemeTreeListPlugin.addPermLog error, preDataMap:{}, afterDataMap", new Object[]{null == preDataMap || preDataMap.isEmpty() ? "" : JSON.toJSONString(preDataMap), null == afterDataMap || afterDataMap.isEmpty() ? "" : JSON.toJSONString(afterDataMap), e});
        }
    }
}

