/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.gensql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.util.PermDataMigrationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class PermExpToolsPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(PermExpToolsPlugin.class);
    private static final String systemType = "bos-permission-formplugin";
    private static final String ROLENUMBERS = "rolenumbers";
    private static final String INCLUDE_FIELD = "include_field";
    private static final String INCLUDE_DR = "include_dr";
    private static final String INCLUDE_DIMUSER = "include_dimuser";
    private static final String INCLUDE_DIMUG = "include_dimug";
    private static final String CONTROLTYPE = "controltype";
    private static final String BTN_GEN_COMROLE = "gen_comrole";
    private static final String BTN_GEN_PRECOMROLE = "gen_precomrole";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_GEN_COMROLE, BTN_GEN_PRECOMROLE});
    }

    public void afterCreateNewData(EventObject e) {
        this.initControlType();
        IDataModel dataModel = this.getModel();
        dataModel.setValue(INCLUDE_FIELD, (Object)"0");
        dataModel.setValue(INCLUDE_DR, (Object)"0");
        dataModel.setValue(INCLUDE_DIMUSER, (Object)"0");
        dataModel.setValue(INCLUDE_DIMUG, (Object)"0");
        dataModel.setValue(CONTROLTYPE, (Object)"ALL");
    }

    private void initControlType() {
        ORM orm = ORM.create();
        DynamicObjectCollection cols = orm.query("perm_ctrltype", "id,number,name", null, "number desc");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PermExpToolsPlugin_0", (String)systemType, (Object[])new Object[0])), "ALL"));
        if (cols != null && !cols.isEmpty()) {
            for (DynamicObject col : cols) {
                String number = col.getString("number");
                String name = col.getString("name");
                comboItems.add(new ComboItem(new LocaleString(name), number));
            }
        }
        ComboEdit ctrlTypeCombo = (ComboEdit)this.getControl(CONTROLTYPE);
        ctrlTypeCombo.setComboItems(comboItems);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String showFormSpecial = (String)e.getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        String unableShowInfo = (String)e.getFormShowParameter().getCustomParam("formShowParm_show_unableInfo");
        if (StringUtils.isNotEmpty((String)unableShowInfo)) {
            e.setCancel(true);
            e.setCancelMessage(unableShowInfo);
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.isAdminUser((long)userId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u5168\u529f\u80fd\u7528\u6237\uff0c\u4e5f\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd", (String)"PermExpToolsPlugin_1", (String)systemType, (Object[])new Object[0]));
            return;
        }
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        Map<Object, DynamicObject> roleMap = this.check();
        if (null == roleMap) {
            return;
        }
        IDataModel dataModel = this.getModel();
        String include_field = ((String)dataModel.getValue(INCLUDE_FIELD)).trim();
        String include_dr = ((String)dataModel.getValue(INCLUDE_DR)).trim();
        String include_dimuser = ((String)dataModel.getValue(INCLUDE_DIMUSER)).trim();
        String include_dimug = ((String)dataModel.getValue(INCLUDE_DIMUG)).trim();
        String controltype = ((String)dataModel.getValue(CONTROLTYPE)).trim();
        MulBasedataDynamicObjectCollection busiobjects = (MulBasedataDynamicObjectCollection)dataModel.getValue("busiobjects");
        Set formNumSet = busiobjects.stream().map(x -> x.getString("fbasedataid_id")).collect(Collectors.toSet());
        Set roleIds = roleMap.keySet().stream().map(x -> String.valueOf(x)).collect(Collectors.toSet());
        HashMap<String, Object> paraMap = new HashMap<String, Object>(3);
        paraMap.put("roleIds", roleIds);
        paraMap.put("formNumSet", formNumSet);
        paraMap.put(INCLUDE_FIELD, !StringUtils.isEmpty((String)include_field) && !"0".equals(include_field));
        paraMap.put(INCLUDE_DR, !StringUtils.isEmpty((String)include_dr) && !"0".equals(include_dr));
        paraMap.put(INCLUDE_DIMUSER, !StringUtils.isEmpty((String)include_dimuser) && !"0".equals(include_dimuser));
        paraMap.put(INCLUDE_DIMUG, !StringUtils.isEmpty((String)include_dimug) && !"0".equals(include_dimug));
        paraMap.put(CONTROLTYPE, controltype);
        switch (control.getKey()) {
            case "gen_comrole": {
                paraMap.put("isPreset", "0");
                this.genComoleScript(paraMap);
                break;
            }
            case "gen_precomrole": {
                paraMap.put("isPreset", "1");
                this.genPreComoleScript(paraMap);
                break;
            }
        }
    }

    private Map<Object, DynamicObject> check() {
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        String rolenumbers = ((String)dataModel.getValue(ROLENUMBERS)).trim();
        if (StringUtils.isEmpty((String)rolenumbers)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PermExpToolsPlugin_2", (String)systemType, (Object[])new Object[0]));
            return null;
        }
        Map roleMap = BusinessDataServiceHelper.loadFromCache((String)"perm_role", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)rolenumbers.split(","))});
        if (CollectionUtils.isEmpty((Map)roleMap)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u89d2\u8272\u4e0d\u5b58\u5728\u3002", (String)"PermExpToolsPlugin_3", (String)systemType, (Object[])new Object[0]));
            return null;
        }
        return roleMap;
    }

    private void genPreComoleScript(Map<String, Object> paraMap) {
        StringBuilder sql = PermDataMigrationUtils.generateComRolesSql(paraMap);
        String sqlFileName = String.format("%s_%s.sql", ResManager.loadKDString((String)"\u6743\u9650\u5bfc\u51fa-\u9884\u7f6e\u901a\u7528\u89d2\u8272\u811a\u672c", (String)"PermExpToolsPlugin_4", (String)systemType, (Object[])new Object[0]), new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sql.toString().getBytes(StandardCharsets.UTF_8));){
            this.exportFile(ins, sqlFileName);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
    }

    private void genComoleScript(Map<String, Object> paraMap) {
        StringBuilder sql = PermDataMigrationUtils.generateComRolesSql(paraMap);
        String sqlFileName = String.format("%s_%s.sql", ResManager.loadKDString((String)"\u6743\u9650\u5bfc\u51fa-\u901a\u7528\u89d2\u8272\u5e38\u89c4\u811a\u672c", (String)"PermExpToolsPlugin_5", (String)systemType, (Object[])new Object[0]), new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sql.toString().getBytes(StandardCharsets.UTF_8));){
            this.exportFile(ins, sqlFileName);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
    }

    private void exportFile(InputStream ins, String sqlFileName) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, ins, 5000);
        this.getView().openUrl(url);
    }
}

