/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.impexp.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.helper.BusiRoleGroupHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.enums.EnumsDataStatus;
import kd.bos.permission.enums.EnumsEnable;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.EnumsYesNo;
import kd.bos.permission.enums.OperationTypeEnum;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.busirole.BusiRoleBcFuncPerm;
import kd.bos.permission.model.perm.busirole.BusiRoleComRole;
import kd.bos.permission.model.perm.busirole.BusiRoleDimObj;
import kd.bos.permission.model.perm.busirole.BusiRoleDisFuncPerm;
import kd.bos.permission.model.perm.imp.BusiRoleImportBean;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.req.permitem.GetPlainPermItemListReq;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.service.BusiRoleService;
import kd.bos.permission.service.ComRoleService;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class BusiRoleImportPlugin
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(BusiRoleImportPlugin.class);

    protected MainEntityType buildMainEntityType(JSONObject billdata) {
        try {
            MainEntityType entityType = super.buildMainEntityType(billdata);
            entityType = (MainEntityType)entityType.clone();
            BasedataEntityType bdet = (BasedataEntityType)entityType;
            if (null == bdet) {
                return entityType;
            }
            MulComboProp usertype = (MulComboProp)bdet.getProperty("usertype");
            if (null != usertype) {
                List comboItems = usertype.getComboItems();
                Map bosUserTypeMap = PermCommonUtil.getBosUserTypeMap();
                if (null != bosUserTypeMap && !bosUserTypeMap.isEmpty()) {
                    comboItems.clear();
                    for (Map.Entry bosUserType : bosUserTypeMap.entrySet()) {
                        ValueMapItem valueMapItem = new ValueMapItem();
                        String key = String.valueOf(bosUserType.getKey());
                        valueMapItem.setValue(key);
                        valueMapItem.setName(new LocaleString((String)bosUserType.getValue()));
                        comboItems.add(valueMapItem);
                    }
                }
            }
            return entityType;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String billFormId = this.getBillFormId();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)billFormId);
        if (null == met) {
            return items;
        }
        BasedataEntityType bdet = (BasedataEntityType)met;
        if (null == bdet) {
            return items;
        }
        String numberProperty = bdet.getNumberProperty();
        if (StringUtils.isNotEmpty((String)numberProperty)) {
            for (IDataEntityProperty p : met.getProperties()) {
                if (!Objects.equals(numberProperty, p.getName())) continue;
                items.add(new ComboItem(p.getDisplayName(), p.getName()));
            }
        }
        return items;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        if (null == billdatas || billdatas.isEmpty()) {
            super.beforeSave(billdatas, logger);
            return;
        }
        this.commonParam2Ctx();
        HashMap<Integer, List> beforeSaveFailedErrorMap = new HashMap<Integer, List>(8);
        Map yesNoMap = (Map)this.ctx.getOption().get("yesNoMap");
        for (ImportBillData bill : billdatas) {
            JSONArray org_entryArr;
            JSONObject data;
            if (bill.isEmpty() || (data = bill.getData()) == null) continue;
            int startIndex = bill.getStartIndex();
            JSONArray role_entryArr = data.getJSONArray("role_entry");
            if (null != role_entryArr && role_entryArr.size() > 0) {
                for (int i = 0; i < role_entryArr.size(); ++i) {
                    String comRoleNum;
                    String importprop;
                    JSONObject role_entry;
                    JSONObject comroleJSONObject;
                    Object role_entryObj = role_entryArr.get(i);
                    if (null == role_entryObj || null == (comroleJSONObject = (role_entry = (JSONObject)role_entryObj).getJSONObject("role_visible")) || !StringUtils.isNotEmpty((String)(importprop = comroleJSONObject.getString("importprop"))) || !StringUtils.isEmpty((String)(comRoleNum = comroleJSONObject.getString(importprop)))) continue;
                    beforeSaveFailedErrorMap.computeIfAbsent(startIndex + i, k -> new ArrayList(10)).add(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a\u901a\u7528\u89d2\u8272.\u7f16\u7801\u3002", (String)"BusiRoleImportPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                }
            } else {
                beforeSaveFailedErrorMap.computeIfAbsent(startIndex, k -> new ArrayList(10)).add(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a\u901a\u7528\u89d2\u8272.\u7f16\u7801\u3002", (String)"BusiRoleImportPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
            if (null == (org_entryArr = data.getJSONArray("org_entry")) || org_entryArr.size() <= 0) continue;
            for (int i = 0; i < org_entryArr.size(); ++i) {
                JSONObject org_entry;
                Object org_entryObj = org_entryArr.get(i);
                if (null == org_entryObj || !(org_entry = (JSONObject)org_entryObj).containsKey((Object)"isincludesuborg_visible")) continue;
                String includesuborg = org_entry.getString("isincludesuborg_visible");
                if (yesNoMap.values().contains(includesuborg)) continue;
                beforeSaveFailedErrorMap.computeIfAbsent(startIndex + i, k -> new ArrayList(10)).add(String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleImportPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), includesuborg));
            }
        }
        this.ctx.addOption("beforeSaveFailedErrorMap", beforeSaveFailedErrorMap);
        super.beforeSave(billdatas, logger);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        List value;
        Integer row;
        Object currentImportType = this.ctx.getOption().get("importtype");
        EnumsImportType enumsImportType = EnumsImportType.getImportTypeEnum(currentImportType);
        if (null == enumsImportType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u5bfc\u5165\u7c7b\u578b\u3002", (String)"RoleAndFuncImportPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        List<String> keyFieldList = null;
        Object keyFields = this.ctx.getOption().get("KeyFields");
        if (!Objects.isNull(keyFields)) {
            keyFieldList = Arrays.stream(((String)keyFields).split(",")).filter(x -> StringUtils.isNotEmpty((String)x)).collect(Collectors.toList());
        }
        HashMap<Integer, List> paramFailedErrorMap = new HashMap<Integer, List>(8);
        Object beforeSaveFailedErrorMapObj = this.ctx.getOption().get("beforeSaveFailedErrorMap");
        Map beforeSaveFailedErrorMap = null == beforeSaveFailedErrorMapObj ? new HashMap(0) : (Map)beforeSaveFailedErrorMapObj;
        for (Map.Entry failedError : beforeSaveFailedErrorMap.entrySet()) {
            Integer row2 = (Integer)failedError.getKey();
            List value2 = (List)failedError.getValue();
            paramFailedErrorMap.computeIfAbsent(row2, k -> new ArrayList(10)).addAll(value2);
        }
        Map permSmallCtrlTypeMap = (Map)this.ctx.getOption().get("permSmallCtrlTypeMap");
        PermBeforeSaveCheckReq req = this.wrapPermBeforeSaveCheckReq(rowdatas, enumsImportType, keyFieldList, permSmallCtrlTypeMap);
        this.fullReqCheckNeedParamMap(req);
        PermCheckResp resp = BusiRoleImportPlugin.getBusiRoleService().beforeSaveCheck(req);
        Map passedMap = resp.getPassedMap();
        HashMap<Integer, List> failedErrorMap = resp.getFailedErrorMap();
        if (null == failedErrorMap) {
            failedErrorMap = new HashMap<Integer, List>(1);
        }
        for (Map.Entry failedError : paramFailedErrorMap.entrySet()) {
            row = (Integer)failedError.getKey();
            value = (List)failedError.getValue();
            if (null == row || null == value || value.isEmpty()) continue;
            failedErrorMap.computeIfAbsent(row, k -> new ArrayList(10)).addAll(value);
        }
        for (Map.Entry failedError : failedErrorMap.entrySet()) {
            row = (Integer)failedError.getKey();
            value = (List)failedError.getValue();
            if (null == row || null == value || value.isEmpty()) continue;
            value.stream().forEach(x -> logger.log(row, x));
        }
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            JSONObject data;
            ImportBillData bill = it.next();
            if (bill.isEmpty() || null == (data = bill.getData())) continue;
            try {
                int row3 = bill.getStartIndex();
                if (failedErrorMap.containsKey(row3)) {
                    it.remove();
                    logger.fail();
                    logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
                    continue;
                }
                BusiRoleImportPlugin.replaceFieldValue(passedMap, data, row3, permSmallCtrlTypeMap);
            }
            catch (Throwable throwable) {
                log.warn("BusiRoleImportPlugin.save error.", throwable);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    logger.log(Integer.valueOf(rowdatas.get(0).getStartIndex()), throwable);
                } else {
                    logger.log(Integer.valueOf(rowdatas.get(0).getStartIndex()), ResManager.loadKDString((String)"\u6570\u636e\u5305\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"RoleAndFuncImportPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                }
                it.remove();
                logger.fail();
                logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
            }
        }
        return super.save(rowdatas, logger);
    }

    private static BusiRoleService getBusiRoleService() {
        return (BusiRoleService)PermServiceFactory.getService((String)"BusiRoleService");
    }

    private void fullReqCheckNeedParamMap(PermBeforeSaveCheckReq req) {
        req.getCheckNeedParamMap().put("plainPermItemSet", (Set)this.ctx.getOption().get("plainPermItemSet"));
        req.getCheckNeedParamMap().put("appNumEntNumSetMap", (Map)this.ctx.getOption().get("appNumEntNumSetMap"));
        req.getCheckNeedParamMap().put("entNumPermItemNumSetMap", (Map)this.ctx.getOption().get("entNumPermItemNumSetMap"));
        req.getCheckNeedParamMap().put("adminChargeAppSet", (Set)this.ctx.getOption().get("adminChargeAppSet"));
        req.getCheckNeedParamMap().put("allAppInfo", (Map)this.ctx.getOption().get("allAppInfo"));
        req.getCheckNeedParamMap().put("bosUserTypeMap", (Map)this.ctx.getOption().get("bosUserTypeMap"));
        req.getCheckNeedParamMap().put("dataStatusMap", (Map)this.ctx.getOption().get("dataStatusMap"));
        req.getCheckNeedParamMap().put("enableMap", (Map)this.ctx.getOption().get("enableMap"));
        req.getCheckNeedParamMap().put("allPermItemNumberIdMap", (Map)this.ctx.getOption().get("allPermItemNumberIdMap"));
        req.getCheckNeedParamMap().put("permSmallCtrlTypeMap", (Map)this.ctx.getOption().get("permSmallCtrlTypeMap"));
    }

    private void commonParam2Ctx() {
        Object permSmallCtrlTypeMapObj;
        Object allPermItemNumberIdMapObj;
        Object enableMapObj;
        Object dataStatusMapObj;
        Object bosUserTypeMapObj;
        Object allAppInfoObj;
        Object plainPermItemSetObj;
        Object yesNoMapObj = this.ctx.getOption().get("yesNoMap");
        if (null == yesNoMapObj) {
            Map yesNoMap = EnumsYesNo.getMap();
            this.ctx.addOption("yesNoMap", (Object)yesNoMap);
        }
        if (null == (plainPermItemSetObj = this.ctx.getOption().get("plainPermItemSet"))) {
            GetPlainPermItemListReq req = new GetPlainPermItemListReq();
            req.setDimType("DIM_ORG");
            req.setReturnByField(true);
            req.setReturnFieldSet((Set)Sets.newHashSet((Object[])new String[]{"appNumber", "entityNumber", "permItemNumber"}));
            List plainPermItemList = PermItemHelper.getPlainPermItemList((GetPlainPermItemListReq)req);
            HashSet plainPermItemSet = new HashSet(plainPermItemList);
            this.ctx.addOption("plainPermItemSet", plainPermItemSet);
            HashMap<String, Set> appNumEntNumSetMap = new HashMap<String, Set>(8);
            HashMap<String, Set> entNumPermItemNumSetMap = new HashMap<String, Set>(8);
            for (PermItem permItem : plainPermItemSet) {
                appNumEntNumSetMap.computeIfAbsent(permItem.getAppNumber(), k -> new HashSet(8)).add(permItem.getEntityNumber());
                entNumPermItemNumSetMap.computeIfAbsent(permItem.getEntityNumber(), k -> new HashSet(8)).add(permItem.getPermItemNumber());
            }
            this.ctx.addOption("appNumEntNumSetMap", appNumEntNumSetMap);
            this.ctx.addOption("entNumPermItemNumSetMap", entNumPermItemNumSetMap);
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Object adminChargeAppSetObj = this.ctx.getOption().get("adminChargeAppSet");
        if (null == adminChargeAppSetObj) {
            HashSet adminChargeAppSet = new HashSet(AdminPermCache.getAdminChargeApps((Long)currUserId, null));
            this.ctx.addOption("adminChargeAppSet", adminChargeAppSet);
        }
        if (null == (allAppInfoObj = this.ctx.getOption().get("allAppInfo"))) {
            Map allAppInfo = AppMetadataCache.getAllAppInfo();
            this.ctx.addOption("allAppInfo", (Object)allAppInfo);
        }
        if (null == (bosUserTypeMapObj = this.ctx.getOption().get("bosUserTypeMap"))) {
            Map bosUserTypeMap = PermCommonUtil.getBosUserTypeMap();
            this.ctx.addOption("bosUserTypeMap", (Object)bosUserTypeMap);
        }
        if (null == (dataStatusMapObj = this.ctx.getOption().get("dataStatusMap"))) {
            Map dataStatusMap = EnumsDataStatus.getMap();
            this.ctx.addOption("dataStatusMap", (Object)dataStatusMap);
        }
        if (null == (enableMapObj = this.ctx.getOption().get("enableMap"))) {
            Map enableMap = EnumsEnable.getMap();
            this.ctx.addOption("enableMap", (Object)enableMap);
        }
        if (null == (allPermItemNumberIdMapObj = this.ctx.getOption().get("allPermItemNumberIdMap"))) {
            Map allPermItemNumberIdMap = PermItemHelper.getAllPermItemNumberIdMap();
            this.ctx.addOption("allPermItemNumberIdMap", (Object)allPermItemNumberIdMap);
        }
        if (null == (permSmallCtrlTypeMapObj = this.ctx.getOption().get("permSmallCtrlTypeMap"))) {
            Map permSmallCtrlTypeMap = IsoDimHelper.permCtrlTypeMap();
            this.ctx.addOption("permSmallCtrlTypeMap", (Object)permSmallCtrlTypeMap);
        }
    }

    private static void replaceFieldValue(Map<Integer, BusiRoleImportBean> passedMap, JSONObject data, int row, Map<String, String> permSmallCtrlTypeMap) {
        OperationTypeEnum operationTypeEnum;
        BusiRoleImportBean importBean = passedMap.get(row);
        if (null == importBean) {
            return;
        }
        if (data.containsKey((Object)"usertype")) {
            data.put("usertype", (Object)importBean.getUserType());
        }
        if (data.containsKey((Object)"group")) {
            Map group = (Map)data.get((Object)"group");
            group.put("id", importBean.getGroupId());
        }
        if (OperationTypeEnum.ADD == (operationTypeEnum = importBean.getOperationTypeEnum())) {
            BusiRoleImportPlugin.someAddDeal(data);
        }
        String roleNum = StringUtils.isEmpty((String)data.getString("number")) ? "" : data.getString("number");
        JSONArray org_entryArr = data.getJSONArray("org_entry");
        if (null != org_entryArr && org_entryArr.size() > 0) {
            HashSet<String> dimtypedimIdSet = new HashSet<String>(8);
            for (int i = 0; i < org_entryArr.size(); ++i) {
                List dimObjList;
                String importprop;
                Object org_entryObj = org_entryArr.get(i);
                if (null == org_entryObj) continue;
                JSONObject org_entry = (JSONObject)org_entryObj;
                String dimTypeBig = "";
                String dimTypeSmall = "";
                JSONObject import_permctrltypeJSONObject = org_entry.getJSONObject("import_permctrltype");
                if (null != import_permctrltypeJSONObject && StringUtils.isNotEmpty((String)(importprop = import_permctrltypeJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(dimTypeBig = import_permctrltypeJSONObject.getString(importprop)))) {
                    dimTypeSmall = permSmallCtrlTypeMap.get(dimTypeBig);
                }
                if (!CollectionUtils.isNotEmpty((Collection)(dimObjList = importBean.getDimObjList()))) continue;
                String dimNum = org_entry.getString("import_dimnum");
                String finalDimTypeSmall = dimTypeSmall;
                BusiRoleDimObj busiRoleDimObj = dimObjList.stream().filter(x -> Objects.equals(roleNum, x.getBusiRoleNum()) && Objects.equals(finalDimTypeSmall, x.getDimTypeSmall()) && Objects.equals(dimNum, x.getDimNum())).findFirst().orElse(null);
                if (null == busiRoleDimObj) continue;
                String dimTypeSmall_ = busiRoleDimObj.getDimTypeSmall();
                DynamicObject dimDyn_ = busiRoleDimObj.getDimDyn();
                String dimId_ = dimDyn_.getString("id");
                org_entry.put("dimentitynum", (Object)dimTypeSmall_);
                org_entry.put("dim_num", (Object)dimDyn_);
                String key = dimTypeSmall_ + dimId_;
                if (!StringUtils.isNotEmpty((String)key) || dimtypedimIdSet.add(key)) continue;
                org_entryArr.remove(i);
                --i;
            }
        }
    }

    private static void someAddDeal(JSONObject data) {
        JSONArray bizroledispermArr;
        String importprop;
        String importprop2;
        JSONArray bizrolepermArr;
        JSONArray org_entryArr;
        JSONArray role_entryArr = data.getJSONArray("role_entry");
        if (null != role_entryArr && role_entryArr.size() > 0) {
            HashSet<String> comRoleNumSet = new HashSet<String>(8);
            for (int i = 0; i < role_entryArr.size(); ++i) {
                String comRoleNum;
                String importprop3;
                Object role_entryObj = role_entryArr.get(i);
                if (null == role_entryObj) continue;
                JSONObject role_entry = (JSONObject)role_entryObj;
                role_entry.put("id", (Object)"");
                JSONObject comroleJSONObject = role_entry.getJSONObject("role_visible");
                if (null == comroleJSONObject || !StringUtils.isNotEmpty((String)(importprop3 = comroleJSONObject.getString("importprop"))) || !StringUtils.isNotEmpty((String)(comRoleNum = comroleJSONObject.getString(importprop3))) || comRoleNumSet.add(comRoleNum)) continue;
                role_entryArr.remove(i);
                --i;
            }
        }
        if (null != (org_entryArr = data.getJSONArray("org_entry")) && org_entryArr.size() > 0) {
            for (Object org_entryObj : org_entryArr) {
                if (null == org_entryObj) continue;
                JSONObject org_entry = (JSONObject)org_entryObj;
                org_entry.put("id", (Object)"");
            }
        }
        if (null != (bizrolepermArr = data.getJSONArray("bizroleperm")) && bizrolepermArr.size() > 0) {
            HashSet<String> permStr = new HashSet<String>(8);
            for (int i = 0; i < bizrolepermArr.size(); ++i) {
                String key;
                String permItemNum;
                JSONObject import_permitemJSONObject;
                String entNum;
                JSONObject import_entJSONObject;
                String appNum;
                String importprop4;
                Object bizrolepermObj = bizrolepermArr.get(i);
                if (null == bizrolepermObj) continue;
                JSONObject bizroleperm = (JSONObject)bizrolepermObj;
                bizroleperm.put("id", (Object)"");
                StringBuilder sb = new StringBuilder();
                JSONObject import_appJSONObject = bizroleperm.getJSONObject("bizapp");
                if (null != import_appJSONObject && StringUtils.isNotEmpty((String)(importprop4 = import_appJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(appNum = import_appJSONObject.getString(importprop4)))) {
                    sb.append(appNum);
                }
                if (null != (import_entJSONObject = bizroleperm.getJSONObject("entitytype")) && StringUtils.isNotEmpty((String)(importprop2 = import_entJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(entNum = import_entJSONObject.getString(importprop2)))) {
                    sb.append(entNum);
                }
                if (null != (import_permitemJSONObject = bizroleperm.getJSONObject("permitem")) && StringUtils.isNotEmpty((String)(importprop = import_permitemJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(permItemNum = import_permitemJSONObject.getString(importprop)))) {
                    sb.append(permItemNum);
                }
                if (!StringUtils.isNotEmpty((String)(key = sb.toString())) || permStr.add(key)) continue;
                bizrolepermArr.remove(i);
                --i;
            }
        }
        if (null != (bizroledispermArr = data.getJSONArray("bizroledisperm")) && bizroledispermArr.size() > 0) {
            HashSet<String> permStr = new HashSet<String>(8);
            for (int i = 0; i < bizroledispermArr.size(); ++i) {
                String key;
                String permItemNum;
                String importprop5;
                JSONObject import_permitemJSONObject;
                String entNum;
                JSONObject import_entJSONObject;
                String appNum;
                Object bizroledispermObj = bizroledispermArr.get(i);
                if (null == bizroledispermObj) continue;
                JSONObject bizroledisperm = (JSONObject)bizroledispermObj;
                bizroledisperm.put("id", (Object)"");
                StringBuilder sb = new StringBuilder();
                JSONObject import_appJSONObject = bizroledisperm.getJSONObject("bizappforbid");
                if (null != import_appJSONObject && StringUtils.isNotEmpty((String)(importprop2 = import_appJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(appNum = import_appJSONObject.getString(importprop2)))) {
                    sb.append(appNum);
                }
                if (null != (import_entJSONObject = bizroledisperm.getJSONObject("entitytypeforbid")) && StringUtils.isNotEmpty((String)(importprop = import_entJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(entNum = import_entJSONObject.getString(importprop)))) {
                    sb.append(entNum);
                }
                if (null != (import_permitemJSONObject = bizroledisperm.getJSONObject("permitemforbid")) && StringUtils.isNotEmpty((String)(importprop5 = import_permitemJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(permItemNum = import_permitemJSONObject.getString(importprop5)))) {
                    sb.append(permItemNum);
                }
                if (!StringUtils.isNotEmpty((String)(key = sb.toString())) || permStr.add(key)) continue;
                bizroledispermArr.remove(i);
                --i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private PermBeforeSaveCheckReq wrapPermBeforeSaveCheckReq(List<ImportBillData> billdatas, EnumsImportType enumsImportType, List<String> keyFieldList, Map<String, String> permSmallCtrlTypeMap) {
        void var33_43;
        LinkedHashMap<String, BusiRoleImportBean> importBeanMap = new LinkedHashMap<String, BusiRoleImportBean>(8);
        HashMap<String, Object> importCheckParamMap = new HashMap<String, Object>(8);
        HashSet<String> busiRoleNumSet = new HashSet<String>(8);
        HashSet<String> busiRoleNameSet = new HashSet<String>(8);
        HashSet<String> busiRoleGroupNumSet = new HashSet<String>(8);
        HashSet<String> comRoleNumSet = new HashSet<String>(8);
        HashSet<String> dimTypeBigSet = new HashSet<String>(8);
        HashMap<String, Set<String>> dimTypeSmallDimNumSetMap = new HashMap<String, Set<String>>(8);
        HashSet<String> appNumSet = new HashSet<String>(8);
        HashSet<String> entNumSet = new HashSet<String>(8);
        HashSet<String> permItemNumSet = new HashSet<String>(8);
        HashSet<String> permItemIdSet = new HashSet<String>(8);
        BusiRoleImportBean importBean = null;
        for (ImportBillData bill : billdatas) {
            String groupNumber;
            Object group;
            String string;
            String remark;
            Map remarkMap;
            String curLangName;
            Map nameMap;
            JSONObject data;
            if (bill.isEmpty() || (data = bill.getData()) == null) continue;
            String number = StringUtils.isEmpty((String)data.getString("number")) ? "" : data.getString("number");
            String name = "";
            Object nameObj = data.get((Object)"name");
            if (null != nameObj && nameObj instanceof Map && null != (nameMap = (Map)nameObj) && !nameMap.isEmpty() && StringUtils.isNotEmpty((String)(curLangName = (String)nameMap.get(RequestContext.get().getLang().name())))) {
                name = curLangName;
            }
            String busiUniqueStr = "";
            if (EnumsImportType.NEW == enumsImportType) {
                busiUniqueStr = number + name;
            } else if ((EnumsImportType.OVERRIDE == enumsImportType || EnumsImportType.OVERRIDENEW == enumsImportType) && keyFieldList.contains("number")) {
                busiUniqueStr = busiUniqueStr + number;
            }
            int startIndex = bill.getStartIndex();
            int endIndex = bill.getEndIndex();
            if (endIndex >= startIndex && null == (importBean = (BusiRoleImportBean)importBeanMap.get(busiUniqueStr = busiUniqueStr + "|" + startIndex))) {
                importBean = new BusiRoleImportBean();
                importBean.setLineNum(startIndex);
            }
            if (null == importBean) continue;
            importBean.setNumber(number);
            importBean.setName(name);
            if (StringUtils.isNotEmpty((String)number)) {
                busiRoleNumSet.add(number);
            }
            if (StringUtils.isNotEmpty((String)name)) {
                busiRoleNameSet.add(name);
            }
            String usertype = data.getString("usertype");
            importBean.setUserType(usertype);
            Object remarkObj = data.get((Object)"description");
            if (null != remarkObj && remarkObj instanceof Map && null != (remarkMap = (Map)remarkObj) && !remarkMap.isEmpty() && StringUtils.isNotEmpty((String)(remark = (String)remarkMap.get(RequestContext.get().getLang().name())))) {
                importBean.setRemark(remark);
            }
            String status = data.getString("status");
            importBean.setStatus(status);
            String enable = data.getString("enable");
            importBean.setEnable(enable);
            Object groupObj = data.get((Object)"group");
            if (null != groupObj && StringUtils.isNotEmpty((String)(string = (group = (JSONObject)groupObj).getString("importprop"))) && StringUtils.isNotEmpty((String)(groupNumber = group.getString(string)))) {
                importBean.setGroupNum(groupNumber);
                busiRoleGroupNumSet.add(groupNumber);
            }
            BusiRoleImportPlugin.fullComRole(comRoleNumSet, importBean, bill, data, number);
            BusiRoleImportPlugin.fullDimObj(permSmallCtrlTypeMap, dimTypeSmallDimNumSetMap, dimTypeBigSet, importBean, bill, data, number);
            BusiRoleImportPlugin.fullBcFunc(appNumSet, entNumSet, permItemNumSet, permItemIdSet, importBean, bill, data, number);
            BusiRoleImportPlugin.fullDisFunc(appNumSet, entNumSet, permItemNumSet, permItemIdSet, importBean, bill, data, number);
            importBeanMap.putIfAbsent(busiUniqueStr, importBean);
        }
        Map roleNumberBusiRoleMap = null;
        Map comRoleSetMap = null;
        Map dimObjSetMap = null;
        Map bcFuncPermSetMap = null;
        Map disFuncPermSetMap = null;
        if (!CollectionUtils.isEmpty(busiRoleNumSet)) {
            roleNumberBusiRoleMap = PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap(busiRoleNumSet, (String)"number");
            comRoleSetMap = PermBusiRoleHelper.getComRoleSetMap(busiRoleNumSet, (String)"number");
            dimObjSetMap = PermBusiRoleHelper.getDimObjSetMap(busiRoleNumSet, (String)"number");
            bcFuncPermSetMap = PermBusiRoleHelper.getBcFuncPermSetMap(busiRoleNumSet, (String)"number");
            disFuncPermSetMap = PermBusiRoleHelper.getDisFuncPermSetMap(busiRoleNumSet, (String)"number");
        }
        importCheckParamMap.put("roleNumberBusiRoleMap", roleNumberBusiRoleMap);
        importCheckParamMap.put("comRoleSetMap", comRoleSetMap);
        importCheckParamMap.put("dimObjSetMap", dimObjSetMap);
        importCheckParamMap.put("bcFuncPermSetMap", bcFuncPermSetMap);
        importCheckParamMap.put("disFuncPermSetMap", disFuncPermSetMap);
        Map roleNameBusiRoleMap = null;
        if (!CollectionUtils.isEmpty(busiRoleNameSet)) {
            roleNameBusiRoleMap = PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap(busiRoleNameSet, (String)"name");
        }
        importCheckParamMap.put("roleNameBusiRoleMap", roleNameBusiRoleMap);
        Map busiRoleGroupMap = null;
        if (!CollectionUtils.isEmpty(busiRoleGroupNumSet)) {
            busiRoleGroupMap = BusiRoleGroupHelper.getNumberGroupMap(busiRoleGroupNumSet);
        }
        importCheckParamMap.put("busiRoleGroupMap", busiRoleGroupMap);
        Map comRoleNumberComRoleMap = null;
        Map adminGroupRoleRangeMap = null;
        if (!CollectionUtils.isEmpty(comRoleNumSet)) {
            comRoleNumberComRoleMap = PermRoleHelper.getRoleIdOrNumOrNameComRoleMap(comRoleNumSet, (String)"number");
            adminGroupRoleRangeMap = ComRoleService.getAdminGroupRoleRangeMap(comRoleNumSet, (String)"number");
        }
        importCheckParamMap.put("comRoleNumberComRoleMap", comRoleNumberComRoleMap);
        importCheckParamMap.put("adminGroupRoleRangeMap", adminGroupRoleRangeMap);
        HashMap<String, Map> dimTypeDimNumDimDynMap = null;
        HashMap<String, GetHasPermPermCtrlObjResp> dimTypeAdminHasPermPermCtrlObjMap = null;
        HashMap<String, Map> dimTypeDimNumExistMap = null;
        if (null != dimTypeSmallDimNumSetMap && !dimTypeSmallDimNumSetMap.isEmpty()) {
            int size = dimTypeSmallDimNumSetMap.size();
            dimTypeDimNumDimDynMap = new HashMap<String, Map>(size);
            dimTypeAdminHasPermPermCtrlObjMap = new HashMap<String, GetHasPermPermCtrlObjResp>(size);
            dimTypeDimNumExistMap = new HashMap<String, Map>(size);
            for (Map.Entry entry : dimTypeSmallDimNumSetMap.entrySet()) {
                String dimTypeSmall = (String)entry.getKey();
                Set dimNumSet = (Set)entry.getValue();
                if (StringUtils.isEmpty((String)dimTypeSmall) || CollectionUtils.isEmpty((Collection)dimNumSet)) continue;
                Map dimNumDimDynSetMap = IsoDimHelper.getDimDynSetMap((Set)dimNumSet, (String)"number", (String)dimTypeSmall);
                dimTypeDimNumDimDynMap.put(dimTypeSmall, dimNumDimDynSetMap);
                Set oneDimIdSet = dimNumDimDynSetMap.values().stream().flatMap(x -> x.stream()).map(x -> x.getLong("id")).collect(Collectors.toSet());
                GetHasPermPermCtrlObjResp adminHasPermPermCtrlObj = PermCtrlTypeService.getAdminHasPermPermCtrlObj((GetHasPermPermCtrlObjReq)new GetHasPermPermCtrlObjReq(dimTypeSmall, Long.valueOf(RequestContext.get().getCurrUserId()), oneDimIdSet, dimNumSet));
                dimTypeAdminHasPermPermCtrlObjMap.put(dimTypeSmall, adminHasPermPermCtrlObj);
                Map dimNumExistMap = PermVerifyUtil.getExistMapByNum((String)dimTypeSmall, (Set)dimNumSet);
                dimTypeDimNumExistMap.put(dimTypeSmall, dimNumExistMap);
            }
        }
        importCheckParamMap.put("dimTypeDimNumDimDynMap", dimTypeDimNumDimDynMap);
        importCheckParamMap.put("dimTypeAdminHasPermPermCtrlObjMap", dimTypeAdminHasPermPermCtrlObjMap);
        importCheckParamMap.put("dimTypeDimNumExistMap", dimTypeDimNumExistMap);
        Map bigPermCtrlTypeMap = null;
        if (!CollectionUtils.isEmpty(dimTypeBigSet)) {
            PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq(null, null, dimTypeBigSet, null, null);
            bigPermCtrlTypeMap = IsoDimHelper.getBigPermCtrlTypeMap((PermCtrlTypeReq)permCtrlTypeReq);
        }
        importCheckParamMap.put("bigPermCtrlTypeMap", bigPermCtrlTypeMap);
        Map appNumExistMap = null;
        if (CollectionUtils.isNotEmpty(appNumSet)) {
            appNumExistMap = PermVerifyUtil.getExistMapByNum((String)"bos_devportal_bizapp", appNumSet);
        }
        importCheckParamMap.put("appNumExistMap", appNumExistMap);
        Object var33_41 = null;
        if (CollectionUtils.isNotEmpty(entNumSet)) {
            Map map = PermVerifyUtil.getExistMapByNum((String)"bos_entityobject", entNumSet);
        }
        importCheckParamMap.put("entNumExistMap", var33_43);
        Map permItemNumExistMap = null;
        Map permItemExistMap = null;
        if (CollectionUtils.isNotEmpty(permItemNumSet)) {
            permItemNumExistMap = PermVerifyUtil.getExistMapByNum((String)"perm_permitem", permItemNumSet);
        }
        if (CollectionUtils.isNotEmpty(permItemIdSet)) {
            permItemExistMap = PermItemHelper.getPermItemMap(permItemIdSet);
        }
        importCheckParamMap.put("permItemNumExistMap", permItemNumExistMap);
        importCheckParamMap.put("permItemExistMap", permItemExistMap);
        PermBeforeSaveCheckReq req = new PermBeforeSaveCheckReq();
        req.setEnumsImportType(enumsImportType);
        req.setKeyFieldList(keyFieldList);
        req.setNeedCheckBeanMap(importBeanMap);
        req.setCheckNeedParamMap(importCheckParamMap);
        return req;
    }

    private static void fullComRole(Set<String> comRoleNumSet, BusiRoleImportBean importBean, ImportBillData bill, JSONObject data, String number) {
        List<BusiRoleComRole> busiRoleComRoleList = null == importBean.getComRoleList() ? new ArrayList(10) : importBean.getComRoleList();
        BusiRoleComRole busiRoleComRole = null;
        JSONArray role_entryArr = data.getJSONArray("role_entry");
        if (null != role_entryArr && role_entryArr.size() > 0) {
            for (int i = 0; i < role_entryArr.size(); ++i) {
                String comRoleNum;
                String importprop;
                Object role_entryObj = role_entryArr.get(i);
                if (null == role_entryObj) continue;
                busiRoleComRole = new BusiRoleComRole();
                busiRoleComRole.setLineNum(bill.getStartIndex() + i);
                busiRoleComRole.setBusiRoleNum(number);
                JSONObject role_entry = (JSONObject)role_entryObj;
                String comrole_entryid = role_entry.getString("id");
                busiRoleComRole.setEntryId(comrole_entryid);
                JSONObject comroleJSONObject = role_entry.getJSONObject("role_visible");
                if (null != comroleJSONObject && StringUtils.isNotEmpty((String)(importprop = comroleJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(comRoleNum = comroleJSONObject.getString(importprop)))) {
                    busiRoleComRole.setComRoleNumber(comRoleNum);
                    comRoleNumSet.add(comRoleNum);
                }
                if (Sets.intersection(new HashSet(busiRoleComRoleList), (Set)Sets.newHashSet((Object[])new BusiRoleComRole[]{busiRoleComRole})).size() > 0) continue;
                busiRoleComRoleList.add(busiRoleComRole);
            }
            importBean.setComRoleList(busiRoleComRoleList);
        }
    }

    private static void fullDimObj(Map<String, String> permSmallCtrlTypeMap, Map<String, Set<String>> dimTypeSmallDimNumSetMap, Set<String> dimTypeBigSet, BusiRoleImportBean importBean, ImportBillData bill, JSONObject data, String number) {
        List<BusiRoleDimObj> busiRoleDimObjList = null == importBean.getDimObjList() ? new ArrayList(10) : importBean.getDimObjList();
        BusiRoleDimObj busiRoleDimObj = null;
        JSONArray org_entryArr = data.getJSONArray("org_entry");
        if (null != org_entryArr && org_entryArr.size() > 0) {
            for (int i = 0; i < org_entryArr.size(); ++i) {
                String dimNum;
                String importprop;
                Object org_entryObj = org_entryArr.get(i);
                if (null == org_entryObj) continue;
                busiRoleDimObj = new BusiRoleDimObj();
                busiRoleDimObj.setLineNum(bill.getStartIndex() + i);
                busiRoleDimObj.setBusiRoleNum(number);
                JSONObject org_entry = (JSONObject)org_entryObj;
                String dim_entryid = org_entry.getString("id");
                busiRoleDimObj.setEntryId(dim_entryid);
                String dimTypeBig = "";
                String dimTypeSmall = "";
                JSONObject import_permctrltypeJSONObject = org_entry.getJSONObject("import_permctrltype");
                if (null != import_permctrltypeJSONObject && StringUtils.isNotEmpty((String)(importprop = import_permctrltypeJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(dimTypeBig = import_permctrltypeJSONObject.getString(importprop)))) {
                    busiRoleDimObj.setDimTypeBig(dimTypeBig);
                    dimTypeSmall = permSmallCtrlTypeMap.get(dimTypeBig);
                    busiRoleDimObj.setDimTypeSmall(dimTypeSmall);
                }
                if (StringUtils.isNotEmpty((String)(dimNum = org_entry.getString("import_dimnum")))) {
                    busiRoleDimObj.setDimNum(dimNum);
                }
                if (StringUtils.isNotEmpty((String)dimTypeBig)) {
                    dimTypeBigSet.add(dimTypeBig);
                }
                dimTypeSmallDimNumSetMap.computeIfAbsent(dimTypeSmall, k -> new HashSet(8)).add(dimNum);
                Boolean isincludesuborg_visible = org_entry.getBoolean("isincludesuborg_visible");
                busiRoleDimObj.setIncludeSub(isincludesuborg_visible);
                if (Sets.intersection(new HashSet(busiRoleDimObjList), (Set)Sets.newHashSet((Object[])new BusiRoleDimObj[]{busiRoleDimObj})).size() > 0) continue;
                busiRoleDimObjList.add(busiRoleDimObj);
            }
            importBean.setDimObjList(busiRoleDimObjList);
        }
    }

    private static void fullBcFunc(Set<String> appNumSet, Set<String> entNumSet, Set<String> permItemNumSet, Set<String> permItemIdSet, BusiRoleImportBean importBean, ImportBillData bill, JSONObject data, String number) {
        List<BusiRoleBcFuncPerm> busiRoleBcFuncPermList = null == importBean.getBcFuncPermList() ? new ArrayList(10) : importBean.getBcFuncPermList();
        BusiRoleBcFuncPerm busiRoleBcFuncPerm = null;
        JSONArray bizrolepermArr = data.getJSONArray("bizroleperm");
        if (null != bizrolepermArr && bizrolepermArr.size() > 0) {
            for (int i = 0; i < bizrolepermArr.size(); ++i) {
                JSONObject import_permitemJSONObject;
                String entNum;
                String importprop;
                JSONObject import_entJSONObject;
                String appNum;
                String importprop2;
                Object bizrolepermObj = bizrolepermArr.get(i);
                if (null == bizrolepermObj) continue;
                busiRoleBcFuncPerm = new BusiRoleBcFuncPerm();
                busiRoleBcFuncPerm.setLineNum(bill.getStartIndex() + i);
                busiRoleBcFuncPerm.setBusiRoleNum(number);
                JSONObject bizroleperm = (JSONObject)bizrolepermObj;
                String bc_entryid = bizroleperm.getString("id");
                busiRoleBcFuncPerm.setEntryId(bc_entryid);
                JSONObject import_appJSONObject = bizroleperm.getJSONObject("bizapp");
                if (null != import_appJSONObject && StringUtils.isNotEmpty((String)(importprop2 = import_appJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(appNum = import_appJSONObject.getString(importprop2)))) {
                    busiRoleBcFuncPerm.setAppNumber(appNum);
                    appNumSet.add(appNum);
                }
                if (null != (import_entJSONObject = bizroleperm.getJSONObject("entitytype")) && StringUtils.isNotEmpty((String)(importprop = import_entJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(entNum = import_entJSONObject.getString(importprop)))) {
                    busiRoleBcFuncPerm.setEntityNumber(entNum);
                    entNumSet.add(entNum);
                }
                if (null != (import_permitemJSONObject = bizroleperm.getJSONObject("permitem"))) {
                    if (import_permitemJSONObject.containsKey((Object)"id") && StringUtils.isNotEmpty((String)import_permitemJSONObject.getString("id"))) {
                        String permItemId = import_permitemJSONObject.getString("id");
                        busiRoleBcFuncPerm.setPermItemId(permItemId);
                        permItemIdSet.add(permItemId);
                    }
                    if (import_permitemJSONObject.containsKey((Object)"number") && StringUtils.isNotEmpty((String)import_permitemJSONObject.getString("number"))) {
                        String permItemNum = import_permitemJSONObject.getString("number");
                        busiRoleBcFuncPerm.setPermItemNumber(permItemNum);
                        permItemNumSet.add(permItemNum);
                    }
                }
                if (Sets.intersection(new HashSet(busiRoleBcFuncPermList), (Set)Sets.newHashSet((Object[])new BusiRoleBcFuncPerm[]{busiRoleBcFuncPerm})).size() > 0) continue;
                busiRoleBcFuncPermList.add(busiRoleBcFuncPerm);
            }
            importBean.setBcFuncPermList(busiRoleBcFuncPermList);
        }
    }

    private static void fullDisFunc(Set<String> appNumSet, Set<String> entNumSet, Set<String> permItemNumSet, Set<String> permItemIdSet, BusiRoleImportBean importBean, ImportBillData bill, JSONObject data, String number) {
        List<BusiRoleDisFuncPerm> busiRoleDisFuncPermList = null == importBean.getDisFuncPermList() ? new ArrayList(10) : importBean.getDisFuncPermList();
        BusiRoleDisFuncPerm busiRoleDisFuncPerm = null;
        JSONArray bizroledispermArr = data.getJSONArray("bizroledisperm");
        if (null != bizroledispermArr && bizroledispermArr.size() > 0) {
            for (int i = 0; i < bizroledispermArr.size(); ++i) {
                JSONObject import_permitemJSONObject;
                String entNum;
                String importprop;
                JSONObject import_entJSONObject;
                String appNum;
                String importprop2;
                Object bizroledispermObj = bizroledispermArr.get(i);
                if (null == bizroledispermObj) continue;
                busiRoleDisFuncPerm = new BusiRoleDisFuncPerm();
                busiRoleDisFuncPerm.setLineNum(bill.getStartIndex() + i);
                busiRoleDisFuncPerm.setBusiRoleNum(number);
                JSONObject bizroledisperm = (JSONObject)bizroledispermObj;
                String dis_entryid = bizroledisperm.getString("id");
                busiRoleDisFuncPerm.setEntryId(dis_entryid);
                JSONObject import_appJSONObject = bizroledisperm.getJSONObject("bizappforbid");
                if (null != import_appJSONObject && StringUtils.isNotEmpty((String)(importprop2 = import_appJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(appNum = import_appJSONObject.getString(importprop2)))) {
                    busiRoleDisFuncPerm.setAppNumber(appNum);
                    appNumSet.add(appNum);
                }
                if (null != (import_entJSONObject = bizroledisperm.getJSONObject("entitytypeforbid")) && StringUtils.isNotEmpty((String)(importprop = import_entJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(entNum = import_entJSONObject.getString(importprop)))) {
                    busiRoleDisFuncPerm.setEntityNumber(entNum);
                    entNumSet.add(entNum);
                }
                if (null != (import_permitemJSONObject = bizroledisperm.getJSONObject("permitemforbid"))) {
                    if (import_permitemJSONObject.containsKey((Object)"id") && StringUtils.isNotEmpty((String)import_permitemJSONObject.getString("id"))) {
                        String permItemId = import_permitemJSONObject.getString("id");
                        busiRoleDisFuncPerm.setPermItemId(permItemId);
                        permItemIdSet.add(permItemId);
                    }
                    if (import_permitemJSONObject.containsKey((Object)"number") && StringUtils.isNotEmpty((String)import_permitemJSONObject.getString("number"))) {
                        String permItemNum = import_permitemJSONObject.getString("number");
                        busiRoleDisFuncPerm.setPermItemNumber(permItemNum);
                        permItemNumSet.add(permItemNum);
                    }
                }
                if (Sets.intersection(new HashSet(busiRoleDisFuncPermList), (Set)Sets.newHashSet((Object[])new BusiRoleDisFuncPerm[]{busiRoleDisFuncPerm})).size() > 0) continue;
                busiRoleDisFuncPermList.add(busiRoleDisFuncPerm);
            }
            importBean.setDisFuncPermList(busiRoleDisFuncPermList);
        }
    }
}

