/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.impexp.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.ComRoleGroupHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.enums.EnumsEnable;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.EnumsUseScope;
import kd.bos.permission.enums.EnumsYesNo;
import kd.bos.permission.enums.OperationTypeEnum;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.model.perm.ComRoleAdminGrp;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.comrole.ComRoleFuncPerm;
import kd.bos.permission.model.perm.imp.ComRoleImportBean;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.permitem.GetPlainPermItemListReq;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.ComRoleService;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class RoleAndFuncImportPlugin
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(RoleAndFuncImportPlugin.class);

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String billFormId = this.getBillFormId();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)billFormId);
        BasedataEntityType bdet = (BasedataEntityType)met;
        String numberProperty = bdet.getNumberProperty();
        if (StringUtils.isNotEmpty((String)numberProperty)) {
            for (IDataEntityProperty p : met.getProperties()) {
                if (!Objects.equals(numberProperty, p.getName())) continue;
                items.add(new ComboItem(p.getDisplayName(), p.getName()));
            }
        }
        return items;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        if (null == billdatas || billdatas.isEmpty()) {
            super.beforeSave(billdatas, logger);
            return;
        }
        this.commonParam2Ctx();
        HashMap<Integer, List> beforeSaveFailedErrorMap = new HashMap<Integer, List>(8);
        Map rolemodifiableMap = (Map)this.ctx.getOption().get("rolemodifiableMap");
        for (ImportBillData bill : billdatas) {
            JSONArray entry_assign_admingrpArr;
            JSONObject createadmingrp;
            JSONObject data;
            if (bill.isEmpty() || (data = bill.getData()) == null) continue;
            Object createadmingrpObj = data.get((Object)"createadmingrp");
            if (null != createadmingrpObj && !(createadmingrp = (JSONObject)createadmingrpObj).containsKey((Object)"name")) {
                beforeSaveFailedErrorMap.computeIfAbsent(bill.getStartIndex(), k -> new ArrayList(10)).add(String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u540d\u79f0\u672a\u8bbe\u7f6e\u6216\u4e3a\u7a7a\u3002", (String)"RoleAndFuncImportPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (!data.containsKey((Object)"entry_assign_admingrp") || null == (entry_assign_admingrpArr = data.getJSONArray("entry_assign_admingrp")) || entry_assign_admingrpArr.size() <= 0) continue;
            for (int i = 0; i < entry_assign_admingrpArr.size(); ++i) {
                JSONObject entry_assign_admingrp;
                Object entry_assign_admingrpObj = entry_assign_admingrpArr.get(i);
                if (null == entry_assign_admingrpObj || !(entry_assign_admingrp = (JSONObject)entry_assign_admingrpObj).containsKey((Object)"rolemodifiable")) continue;
                String rolemodifiable = entry_assign_admingrp.getString("rolemodifiable");
                if (rolemodifiableMap.values().contains(rolemodifiable)) continue;
                beforeSaveFailedErrorMap.computeIfAbsent(bill.getStartIndex() + i, k -> new ArrayList(10)).add(String.format(ResManager.loadKDString((String)"\u5141\u8bb8\u4fee\u6539\u901a\u7528\u89d2\u8272\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"RoleAndFuncImportPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), rolemodifiable));
            }
        }
        this.ctx.addOption("beforeSaveFailedErrorMap", beforeSaveFailedErrorMap);
        super.beforeSave(billdatas, logger);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        List value;
        Integer row;
        Object currentImportType = this.ctx.getOption().get("importtype");
        EnumsImportType enumsImportType = EnumsImportType.getImportTypeEnum(currentImportType);
        if (null == enumsImportType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u5bfc\u5165\u7c7b\u578b\u3002", (String)"RoleAndFuncImportPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        ArrayList<String> keyFieldList = new ArrayList(0);
        Object keyFields = this.ctx.getOption().get("KeyFields");
        if (!Objects.isNull(keyFields)) {
            keyFieldList = Arrays.stream(((String)keyFields).split(",")).filter(x -> StringUtils.isNotEmpty((String)x)).collect(Collectors.toList());
        }
        HashMap<Integer, List<String>> paramFailedErrorMap = new HashMap<Integer, List<String>>(8);
        Object beforeSaveFailedErrorMapObj = this.ctx.getOption().get("beforeSaveFailedErrorMap");
        Map beforeSaveFailedErrorMap = null == beforeSaveFailedErrorMapObj ? new HashMap(0) : (Map)beforeSaveFailedErrorMapObj;
        for (Map.Entry failedError : beforeSaveFailedErrorMap.entrySet()) {
            Integer row2 = (Integer)failedError.getKey();
            List value2 = (List)failedError.getValue();
            paramFailedErrorMap.computeIfAbsent(row2, k -> new ArrayList(10)).addAll(value2);
        }
        Map rolemodifiableMap = (Map)this.ctx.getOption().get("rolemodifiableMap");
        PermBeforeSaveCheckReq req = this.wrapPermBeforeSaveCheckReq(rowdatas, enumsImportType, keyFieldList, paramFailedErrorMap, rolemodifiableMap);
        this.fullReqCheckNeedParamMap(req);
        PermCheckResp resp = RoleAndFuncImportPlugin.getComRoleService().beforeSaveCheck(req);
        Map passedMap = resp.getPassedMap();
        HashMap<Integer, List> failedErrorMap = resp.getFailedErrorMap();
        if (null == failedErrorMap) {
            failedErrorMap = new HashMap<Integer, List>(1);
        }
        for (Map.Entry failedError : paramFailedErrorMap.entrySet()) {
            row = (Integer)failedError.getKey();
            value = (List)failedError.getValue();
            if (null == row || null == value || value.isEmpty()) continue;
            failedErrorMap.computeIfAbsent(row, k -> new ArrayList(10)).addAll(value);
        }
        for (Map.Entry failedError : failedErrorMap.entrySet()) {
            row = (Integer)failedError.getKey();
            value = (List)failedError.getValue();
            if (null == row || null == value || value.isEmpty()) continue;
            value.stream().forEach(x -> logger.log(row, x));
        }
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            JSONObject data;
            ImportBillData bill = it.next();
            if (bill.isEmpty() || null == (data = bill.getData())) continue;
            try {
                int row3 = bill.getStartIndex();
                if (failedErrorMap.containsKey(row3)) {
                    it.remove();
                    logger.fail();
                    logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
                    continue;
                }
                RoleAndFuncImportPlugin.replaceFieldValue(passedMap, data, row3);
            }
            catch (Throwable throwable) {
                log.warn("RoleAndFuncImportPlugin.save error.", throwable);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    logger.log(Integer.valueOf(rowdatas.get(0).getStartIndex()), throwable);
                } else {
                    logger.log(Integer.valueOf(rowdatas.get(0).getStartIndex()), ResManager.loadKDString((String)"\u6570\u636e\u5305\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"RoleAndFuncImportPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                }
                it.remove();
                logger.fail();
                logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
            }
        }
        return super.save(rowdatas, logger);
    }

    private static ComRoleService getComRoleService() {
        ComRoleService comRoleService = (ComRoleService)PermServiceFactory.getService((String)"ComRoleService");
        return comRoleService;
    }

    private void fullReqCheckNeedParamMap(PermBeforeSaveCheckReq req) {
        req.getCheckNeedParamMap().put("plainPermItemSet", (Set)this.ctx.getOption().get("plainPermItemSet"));
        req.getCheckNeedParamMap().put("appNumEntNumSetMap", (Map)this.ctx.getOption().get("appNumEntNumSetMap"));
        req.getCheckNeedParamMap().put("entNumPermItemNumSetMap", (Map)this.ctx.getOption().get("entNumPermItemNumSetMap"));
        req.getCheckNeedParamMap().put("adminChargeAppSet", (Set)this.ctx.getOption().get("adminChargeAppSet"));
        req.getCheckNeedParamMap().put("allAppInfo", (Map)this.ctx.getOption().get("allAppInfo"));
        req.getCheckNeedParamMap().put("bosUserTypeMap", (Map)this.ctx.getOption().get("bosUserTypeMap"));
        req.getCheckNeedParamMap().put("useScopeMap", (Map)this.ctx.getOption().get("useScopeMap"));
        req.getCheckNeedParamMap().put("enableMap", (Map)this.ctx.getOption().get("enableMap"));
        req.getCheckNeedParamMap().put("rolemodifiableMap", (Map)this.ctx.getOption().get("rolemodifiableMap"));
        req.getCheckNeedParamMap().put("admGrpMapOfUser", (Map)this.ctx.getOption().get("admGrpMapOfUser"));
        req.getCheckNeedParamMap().put("admGrpF7Map", (Map)this.ctx.getOption().get("admGrpF7Map"));
        req.getCheckNeedParamMap().put("allPermItemNumberIdMap", (Map)this.ctx.getOption().get("allPermItemNumberIdMap"));
    }

    private void commonParam2Ctx() {
        Object allPermItemNumberIdMapObj;
        Object admGrpF7MapObj;
        Object admGrpMapOfUserObj;
        Object rolemodifiableMapObj;
        Object enableMapObj;
        Object useScopeMapObj;
        Object bosUserTypeMapObj;
        Object allAppInfoObj;
        Object plainPermItemSetObj = this.ctx.getOption().get("plainPermItemSet");
        if (null == plainPermItemSetObj) {
            GetPlainPermItemListReq req = new GetPlainPermItemListReq();
            req.setDimType("DIM_ORG");
            req.setReturnByField(true);
            req.setReturnFieldSet((Set)Sets.newHashSet((Object[])new String[]{"appNumber", "entityNumber", "permItemNumber"}));
            List plainPermItemList = PermItemHelper.getPlainPermItemList((GetPlainPermItemListReq)req);
            HashSet plainPermItemSet = new HashSet(plainPermItemList);
            this.ctx.addOption("plainPermItemSet", plainPermItemSet);
            HashMap<String, Set> appNumEntNumSetMap = new HashMap<String, Set>(8);
            HashMap<String, Set> entNumPermItemNumSetMap = new HashMap<String, Set>(8);
            for (PermItem permItem : plainPermItemSet) {
                appNumEntNumSetMap.computeIfAbsent(permItem.getAppNumber(), k -> new HashSet(8)).add(permItem.getEntityNumber());
                entNumPermItemNumSetMap.computeIfAbsent(permItem.getEntityNumber(), k -> new HashSet(8)).add(permItem.getPermItemNumber());
            }
            this.ctx.addOption("appNumEntNumSetMap", appNumEntNumSetMap);
            this.ctx.addOption("entNumPermItemNumSetMap", entNumPermItemNumSetMap);
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Object adminChargeAppSetObj = this.ctx.getOption().get("adminChargeAppSet");
        if (null == adminChargeAppSetObj) {
            HashSet adminChargeAppSet = new HashSet(AdminPermCache.getAdminChargeApps((Long)currUserId, null));
            this.ctx.addOption("adminChargeAppSet", adminChargeAppSet);
        }
        if (null == (allAppInfoObj = this.ctx.getOption().get("allAppInfo"))) {
            Map allAppInfo = AppMetadataCache.getAllAppInfo();
            this.ctx.addOption("allAppInfo", (Object)allAppInfo);
        }
        if (null == (bosUserTypeMapObj = this.ctx.getOption().get("bosUserTypeMap"))) {
            Map bosUserTypeMap = PermCommonUtil.getBosUserTypeMap();
            this.ctx.addOption("bosUserTypeMap", (Object)bosUserTypeMap);
        }
        if (null == (useScopeMapObj = this.ctx.getOption().get("useScopeMap"))) {
            Map useScopeMap = EnumsUseScope.getMap();
            this.ctx.addOption("useScopeMap", (Object)useScopeMap);
        }
        if (null == (enableMapObj = this.ctx.getOption().get("enableMap"))) {
            Map enableMap = EnumsEnable.getMap();
            this.ctx.addOption("enableMap", (Object)enableMap);
        }
        if (null == (rolemodifiableMapObj = this.ctx.getOption().get("rolemodifiableMap"))) {
            Map rolemodifiableMap = EnumsYesNo.getMap();
            this.ctx.addOption("rolemodifiableMap", (Object)rolemodifiableMap);
        }
        if (null == (admGrpMapOfUserObj = this.ctx.getOption().get("admGrpMapOfUser"))) {
            Map admGrpMapOfUser = AdminGroupHelper.getAdmGrpMap((Long)currUserId, (String)"name");
            this.ctx.addOption("admGrpMapOfUser", (Object)admGrpMapOfUser);
        }
        if (null == (admGrpF7MapObj = this.ctx.getOption().get("admGrpF7Map"))) {
            Map admGrpF7Map = AdminGroupHelper.getAdmGrpF7Map((String)"number", null);
            this.ctx.addOption("admGrpF7Map", (Object)admGrpF7Map);
        }
        if (null == (allPermItemNumberIdMapObj = this.ctx.getOption().get("allPermItemNumberIdMap"))) {
            Map allPermItemNumberIdMap = PermItemHelper.getAllPermItemNumberIdMap();
            this.ctx.addOption("allPermItemNumberIdMap", (Object)allPermItemNumberIdMap);
        }
    }

    private static void replaceFieldValue(Map<Integer, ComRoleImportBean> passedMap, JSONObject data, int row) {
        JSONArray entry_assign_admingrpArr;
        ComRoleImportBean comRoleImportBean = passedMap.get(row);
        if (null == comRoleImportBean) {
            return;
        }
        if (data.containsKey((Object)"bizdomain")) {
            Map bizdomain = (Map)data.get((Object)"bizdomain");
            bizdomain.put("id", comRoleImportBean.getBizDomainId());
        }
        if (data.containsKey((Object)"roletype")) {
            data.put("roletype", (Object)comRoleImportBean.getUserType());
        }
        if (data.containsKey((Object)"createadmingrp")) {
            Map createadmingrp = (Map)data.get((Object)"createadmingrp");
            createadmingrp.put("id", comRoleImportBean.getCreateAdminGrp());
        }
        if (data.containsKey((Object)"group")) {
            Map group = (Map)data.get((Object)"group");
            group.put("id", comRoleImportBean.getGroupId());
        }
        String usescope = data.getString("usescope");
        OperationTypeEnum operationTypeEnum = comRoleImportBean.getOperationTypeEnum();
        if (OperationTypeEnum.ADD == operationTypeEnum) {
            JSONArray import_entry_funcpermArr;
            if (StringUtils.isNotEmpty((String)usescope) && EnumsUseScope.ASSIGN.getType().equals(usescope) && null != (entry_assign_admingrpArr = data.getJSONArray("entry_assign_admingrp")) && entry_assign_admingrpArr.size() > 0) {
                for (Object entry_assign_admingrpObj : entry_assign_admingrpArr) {
                    if (null == entry_assign_admingrpObj) continue;
                    JSONObject entry_assign_admingrp = (JSONObject)entry_assign_admingrpObj;
                    entry_assign_admingrp.put("admgrp_entryid", (Object)"");
                }
            }
            if (null != (import_entry_funcpermArr = data.getJSONArray("import_entry_funcperm")) && import_entry_funcpermArr.size() > 0) {
                for (Object import_entry_funcpermObj : import_entry_funcpermArr) {
                    if (null == import_entry_funcpermObj) continue;
                    JSONObject import_entry_funcperm = (JSONObject)import_entry_funcpermObj;
                    import_entry_funcperm.put("funcperm_entryid", (Object)"");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)usescope) && !EnumsUseScope.ASSIGN.getType().equals(usescope) && null != (entry_assign_admingrpArr = data.getJSONArray("entry_assign_admingrp"))) {
            entry_assign_admingrpArr.clear();
        }
    }

    private PermBeforeSaveCheckReq wrapPermBeforeSaveCheckReq(List<ImportBillData> billdatas, EnumsImportType enumsImportType, List<String> keyFieldList, Map<Integer, List<String>> paramFailedErrorMap, Map<String, String> rolemodifiableMap) {
        LinkedHashMap<String, ComRoleImportBean> comRoleImportBeanMap = new LinkedHashMap<String, ComRoleImportBean>(8);
        HashMap<String, Map> importCheckParamMap = new HashMap<String, Map>(8);
        HashSet<String> roleNumSet = new HashSet<String>(8);
        HashSet<String> roleNameSet = new HashSet<String>(8);
        HashSet createAdminGrpNameSet = new HashSet(8);
        HashSet<String> roleGroupNumSet = new HashSet<String>(8);
        HashSet<String> dimTypeBigSet = new HashSet<String>(8);
        HashSet<Object> adminGrpNumSet = new HashSet<Object>(8);
        HashSet<String> appNumSet = new HashSet<String>(8);
        HashSet<String> entNumSet = new HashSet<String>(8);
        HashSet<String> permItemNumSet = new HashSet<String>(8);
        HashSet<String> permItemIdSet = new HashSet<String>(8);
        ComRoleImportBean comRoleImportBean = null;
        ArrayList<ComRoleAdminGrp> comRoleAdminGrpList = null;
        ComRoleAdminGrp comRoleAdminGrp = null;
        ArrayList<ComRoleFuncPerm> funcPermList = null;
        ComRoleFuncPerm comRoleFuncPerm = null;
        for (ImportBillData bill : billdatas) {
            JSONArray import_entry_funcpermArr;
            JSONArray entry_assign_admingrpArr;
            String dimtypeBig;
            JSONObject dimtypeid;
            String importprop;
            JSONObject dimtypeidObj;
            String groupNumber;
            JSONObject group;
            String importprop2;
            String remark;
            Map remarkMap;
            String appNum;
            String importprop3;
            JSONObject bizdomain;
            String curLangName;
            Map nameMap;
            JSONObject data;
            if (bill.isEmpty() || (data = bill.getData()) == null) continue;
            String id = StringUtils.isEmpty((String)data.getString("id")) ? "" : data.getString("id");
            String number = StringUtils.isEmpty((String)data.getString("number")) ? "" : data.getString("number");
            String name = "";
            Object nameObj = data.get((Object)"name");
            if (null != nameObj && nameObj instanceof Map && null != (nameMap = (Map)nameObj) && !nameMap.isEmpty() && StringUtils.isNotEmpty((String)(curLangName = (String)nameMap.get(RequestContext.get().getLang().name())))) {
                name = curLangName;
            }
            String busiUniqueStr = "";
            if (EnumsImportType.NEW == enumsImportType) {
                busiUniqueStr = number + name;
            } else if ((EnumsImportType.OVERRIDE == enumsImportType || EnumsImportType.OVERRIDENEW == enumsImportType) && keyFieldList.contains("number")) {
                busiUniqueStr = busiUniqueStr + number;
            }
            int startIndex = bill.getStartIndex();
            int endIndex = bill.getEndIndex();
            if (endIndex >= startIndex && null == (comRoleImportBean = (ComRoleImportBean)comRoleImportBeanMap.get(busiUniqueStr = busiUniqueStr + "|" + startIndex))) {
                comRoleImportBean = new ComRoleImportBean();
                comRoleImportBean.setLineNum(startIndex);
            }
            comRoleImportBean.setId(id);
            comRoleImportBean.setNumber(number);
            comRoleImportBean.setName(name);
            if (StringUtils.isNotEmpty((String)number)) {
                roleNumSet.add(number);
            }
            if (StringUtils.isNotEmpty((String)name)) {
                roleNameSet.add(name);
            }
            if (null != (bizdomain = data.getJSONObject("bizdomain")) && StringUtils.isNotEmpty((String)(importprop3 = bizdomain.getString("importprop"))) && StringUtils.isNotEmpty((String)(appNum = bizdomain.getString(importprop3)))) {
                comRoleImportBean.setBizDomainNumber(appNum);
            }
            String roletype = data.getString("roletype");
            comRoleImportBean.setUserTypeName(roletype);
            Object createadmingrpObj = data.get((Object)"createadmingrp");
            if (null != createadmingrpObj) {
                String[] split;
                String createadmingrpName = "";
                JSONObject createadmingrp = (JSONObject)createadmingrpObj;
                if (createadmingrp.containsKey((Object)"name")) {
                    createadmingrpName = createadmingrp.getString("name");
                } else {
                    String importprop4 = createadmingrp.getString("importprop");
                    if (StringUtils.isNotEmpty((String)importprop4) && Objects.equals("name", importprop4)) {
                        createadmingrpName = createadmingrp.getString(importprop4);
                    }
                }
                if (StringUtils.isNotEmpty((String)createadmingrpName) && null != (split = createadmingrpName.split(",")) && split.length > 0) {
                    comRoleImportBean.setCreateAdminGrpName(createadmingrpName);
                    createAdminGrpNameSet.addAll(Arrays.stream(split).collect(Collectors.toSet()));
                }
            }
            String usescope = data.getString("usescope");
            comRoleImportBean.setUseScope(usescope);
            Object remarkObj = data.get((Object)"remark");
            if (null != remarkObj && remarkObj instanceof Map && null != (remarkMap = (Map)remarkObj) && !remarkMap.isEmpty() && StringUtils.isNotEmpty((String)(remark = (String)remarkMap.get(RequestContext.get().getLang().name())))) {
                comRoleImportBean.setRemark(remark);
            }
            String enable = data.getString("enable");
            comRoleImportBean.setEnable(enable);
            Object groupObj = data.get((Object)"group");
            if (null != groupObj && StringUtils.isNotEmpty((String)(importprop2 = (group = (JSONObject)groupObj).getString("importprop"))) && StringUtils.isNotEmpty((String)(groupNumber = group.getString(importprop2)))) {
                comRoleImportBean.setGroupNum(groupNumber);
                roleGroupNumSet.add(groupNumber);
            }
            if (null != (dimtypeidObj = data.getJSONObject("dimtypeid")) && StringUtils.isNotEmpty((String)(importprop = (dimtypeid = dimtypeidObj).getString("importprop"))) && StringUtils.isNotEmpty((String)(dimtypeBig = dimtypeid.getString(importprop)))) {
                comRoleImportBean.setDimTypeId(dimtypeBig);
                dimTypeBigSet.add(dimtypeBig);
            }
            if (null != (entry_assign_admingrpArr = data.getJSONArray("entry_assign_admingrp")) && entry_assign_admingrpArr.size() > 0) {
                comRoleAdminGrpList = new ArrayList<ComRoleAdminGrp>(entry_assign_admingrpArr.size());
                for (int i = 0; i < entry_assign_admingrpArr.size(); ++i) {
                    Object admingrpNum;
                    String importprop5;
                    Object entry_assign_admingrpObj = entry_assign_admingrpArr.get(i);
                    if (null == entry_assign_admingrpObj) continue;
                    comRoleAdminGrp = new ComRoleAdminGrp();
                    comRoleAdminGrp.setLineNum(startIndex + i);
                    comRoleAdminGrp.setRoleNumber(number);
                    JSONObject entry_assign_admingrp = (JSONObject)entry_assign_admingrpObj;
                    String admgrp_entryid = entry_assign_admingrp.getString("admgrp_entryid");
                    comRoleAdminGrp.setEntryId(admgrp_entryid);
                    JSONObject admingrpJSONObject = entry_assign_admingrp.getJSONObject("admingrp");
                    if (null != admingrpJSONObject && StringUtils.isNotEmpty((String)(importprop5 = admingrpJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(admingrpNum = admingrpJSONObject.getString(importprop5)))) {
                        comRoleAdminGrp.setAdminGroupNumber((String)admingrpNum);
                        adminGrpNumSet.add(admingrpNum);
                    }
                    String rolemodifiable = entry_assign_admingrp.getString("rolemodifiable");
                    admingrpNum = rolemodifiableMap.entrySet().iterator();
                    while (admingrpNum.hasNext()) {
                        Map.Entry rolemodifiableMM = (Map.Entry)admingrpNum.next();
                        if (!Objects.equals(rolemodifiable, rolemodifiableMM.getValue())) continue;
                        comRoleAdminGrp.setModifiable((StringUtils.isNotEmpty((String)((String)rolemodifiableMM.getKey())) && Objects.equals("1", rolemodifiableMM.getKey()) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
                    }
                    comRoleAdminGrpList.add(comRoleAdminGrp);
                }
                comRoleImportBean.setComRoleAdminGrpList(comRoleAdminGrpList);
            }
            if (null != (import_entry_funcpermArr = data.getJSONArray("import_entry_funcperm")) && import_entry_funcpermArr.size() > 0) {
                funcPermList = new ArrayList<ComRoleFuncPerm>(import_entry_funcpermArr.size());
                for (int i = 0; i < import_entry_funcpermArr.size(); ++i) {
                    JSONObject import_permitemJSONObject;
                    String entNum;
                    String importprop6;
                    JSONObject import_entJSONObject;
                    String appNum2;
                    String importprop7;
                    JSONObject import_appJSONObject;
                    String cloudNum;
                    String importprop8;
                    Object import_entry_funcpermObj = import_entry_funcpermArr.get(i);
                    if (null == import_entry_funcpermObj) continue;
                    comRoleFuncPerm = new ComRoleFuncPerm();
                    comRoleFuncPerm.setLineNum(startIndex + i);
                    comRoleFuncPerm.setRoleNumber(number);
                    JSONObject import_entry_funcperm = (JSONObject)import_entry_funcpermObj;
                    String funcperm_entryid = import_entry_funcperm.getString("funcperm_entryid");
                    comRoleFuncPerm.setEntryId(funcperm_entryid);
                    JSONObject import_cloudJSONObject = import_entry_funcperm.getJSONObject("import_cloud");
                    if (null != import_cloudJSONObject && StringUtils.isNotEmpty((String)(importprop8 = import_cloudJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(cloudNum = import_cloudJSONObject.getString(importprop8)))) {
                        comRoleFuncPerm.setCloudNumber(cloudNum);
                    }
                    if (null != (import_appJSONObject = import_entry_funcperm.getJSONObject("import_app")) && StringUtils.isNotEmpty((String)(importprop7 = import_appJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(appNum2 = import_appJSONObject.getString(importprop7)))) {
                        comRoleFuncPerm.setAppNumber(appNum2);
                        appNumSet.add(appNum2);
                    }
                    if (null != (import_entJSONObject = import_entry_funcperm.getJSONObject("import_ent")) && StringUtils.isNotEmpty((String)(importprop6 = import_entJSONObject.getString("importprop"))) && StringUtils.isNotEmpty((String)(entNum = import_entJSONObject.getString(importprop6)))) {
                        comRoleFuncPerm.setEntityNumber(entNum);
                        entNumSet.add(entNum);
                    }
                    if (null != (import_permitemJSONObject = import_entry_funcperm.getJSONObject("import_permitem"))) {
                        if (import_permitemJSONObject.containsKey((Object)"id") && StringUtils.isNotEmpty((String)import_permitemJSONObject.getString("id"))) {
                            String permItemId = import_permitemJSONObject.getString("id");
                            comRoleFuncPerm.setPermItemId(permItemId);
                            permItemIdSet.add(permItemId);
                        }
                        if (import_permitemJSONObject.containsKey((Object)"number") && StringUtils.isNotEmpty((String)import_permitemJSONObject.getString("number"))) {
                            String permItemNum = import_permitemJSONObject.getString("number");
                            comRoleFuncPerm.setPermItemNumber(permItemNum);
                            permItemNumSet.add(permItemNum);
                        }
                    }
                    funcPermList.add(comRoleFuncPerm);
                }
                comRoleImportBean.setFuncPermList(funcPermList);
            }
            comRoleImportBeanMap.putIfAbsent(busiUniqueStr, comRoleImportBean);
        }
        Map roleNumberComRoleMap = null;
        Map roleNumAdmGrpSetMap = null;
        Map roleNumPermSetMap = null;
        Map roleNumCanModifyRoleMap = null;
        if (!CollectionUtils.isEmpty(roleNumSet)) {
            roleNumberComRoleMap = PermRoleHelper.getRoleIdOrNumOrNameComRoleMap(roleNumSet, (String)"number");
            roleNumAdmGrpSetMap = PermRoleHelper.getAdmGrpSetMap(roleNumSet, (String)"number");
            roleNumPermSetMap = PermRoleHelper.getRolePermSetMap(roleNumSet, (String)"number");
            roleNumCanModifyRoleMap = AdminGroupService.canModifyRole((Long)RequestContext.get().getCurrUserId(), roleNumSet);
        }
        importCheckParamMap.put("roleNumberComRoleMap", roleNumberComRoleMap);
        importCheckParamMap.put("roleNumAdmGrpSetMap", roleNumAdmGrpSetMap);
        importCheckParamMap.put("roleNumPermSetMap", roleNumPermSetMap);
        importCheckParamMap.put("roleNumCanModifyRoleMap", roleNumCanModifyRoleMap);
        Map roleNameComRoleMap = null;
        if (!CollectionUtils.isEmpty(roleNameSet)) {
            roleNameComRoleMap = PermRoleHelper.getRoleIdOrNumOrNameComRoleMap(roleNameSet, (String)"name");
        }
        importCheckParamMap.put("roleNameComRoleMap", roleNameComRoleMap);
        Map createAdminGrpMap = null;
        if (!CollectionUtils.isEmpty(createAdminGrpNameSet)) {
            createAdminGrpMap = AdminGroupHelper.getAdminGrpMap(createAdminGrpNameSet, (String)"name");
        }
        importCheckParamMap.put("createAdminGrpMap", createAdminGrpMap);
        Map roleGroupMap = null;
        if (!CollectionUtils.isEmpty(roleGroupNumSet)) {
            roleGroupMap = ComRoleGroupHelper.getNumberGroupMap(roleGroupNumSet);
        }
        importCheckParamMap.put("roleGroupMap", roleGroupMap);
        Map bigPermCtrlTypeMap = null;
        if (!CollectionUtils.isEmpty(dimTypeBigSet)) {
            PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq(null, null, dimTypeBigSet, null, null);
            bigPermCtrlTypeMap = IsoDimHelper.getBigPermCtrlTypeMap((PermCtrlTypeReq)permCtrlTypeReq);
        }
        importCheckParamMap.put("bigPermCtrlTypeMap", bigPermCtrlTypeMap);
        Map numAdmGroupMap = null;
        if (!CollectionUtils.isEmpty(adminGrpNumSet)) {
            numAdmGroupMap = AdminGroupHelper.getAdminGrpMap(adminGrpNumSet, (String)"number");
        }
        importCheckParamMap.put("numAdmGroupMap", numAdmGroupMap);
        Map appNumExistMap = null;
        if (CollectionUtils.isNotEmpty(appNumSet)) {
            appNumExistMap = PermVerifyUtil.getExistMapByNum((String)"bos_devportal_bizapp", appNumSet);
        }
        importCheckParamMap.put("appNumExistMap", appNumExistMap);
        Map entNumExistMap = null;
        if (CollectionUtils.isNotEmpty(entNumSet)) {
            entNumExistMap = PermVerifyUtil.getExistMapByNum((String)"bos_entityobject", entNumSet);
        }
        importCheckParamMap.put("entNumExistMap", entNumExistMap);
        Map permItemNumExistMap = null;
        Map permItemExistMap = null;
        if (CollectionUtils.isNotEmpty(permItemNumSet)) {
            permItemNumExistMap = PermVerifyUtil.getExistMapByNum((String)"perm_permitem", permItemNumSet);
        }
        if (CollectionUtils.isNotEmpty(permItemIdSet)) {
            permItemExistMap = PermItemHelper.getPermItemMap(permItemIdSet);
        }
        importCheckParamMap.put("permItemNumExistMap", permItemNumExistMap);
        importCheckParamMap.put("permItemExistMap", permItemExistMap);
        PermBeforeSaveCheckReq req = new PermBeforeSaveCheckReq();
        req.setEnumsImportType(enumsImportType);
        req.setKeyFieldList(keyFieldList);
        req.setNeedCheckBeanMap(comRoleImportBeanMap);
        req.setCheckNeedParamMap(importCheckParamMap);
        return req;
    }
}

