/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.impexp.imp;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.imp.UserBusiRoleImportBean;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.bat.aftersave.UserBusiRoleAfterSaveReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermUserReq;
import kd.bos.permission.model.perm.req.userbusirole.GetUserBusiRoleReq;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermUserResp;
import kd.bos.permission.service.UserBusiRoleService;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class UserBusiRoleImportPlugin
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(UserBusiRoleImportPlugin.class);

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return super.getBatchImportSize();
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(ctx);
            formView.setVisible(Boolean.FALSE, new String[]{"radiofield1", "radiofield2"});
            IFormView parentView = formView.getParentView();
            if (parentView instanceof ListView) {
                String billFormId = ((ListView)parentView).getBillFormId();
                ctx.addOption("permImportFormNum", (Object)billFormId);
            }
        }
        catch (Exception e) {
            log.warn("UserBusiRoleImportPlugin.setContext error", (Throwable)e);
        }
        return super.setContext(rc, ctx, startArgs);
    }

    public String getDefaultImportType() {
        return "new";
    }

    protected void beforeSave(List<ImportBillData> rowdatas, ImportLogger logger) {
        List value;
        Integer row;
        super.beforeSave(rowdatas, logger);
        Object currentImportType = this.ctx.getOption().get("importtype");
        EnumsImportType enumsImportType = EnumsImportType.getImportTypeEnum(currentImportType);
        if (null == enumsImportType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u5bfc\u5165\u7c7b\u578b\u3002", (String)"RoleAndFuncImportPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        List<String> keyFieldList = null;
        Object keyFields = this.ctx.getOption().get("KeyFields");
        if (!Objects.isNull(keyFields)) {
            keyFieldList = Arrays.stream(((String)keyFields).split(",")).filter(x -> StringUtils.isNotEmpty((String)x)).collect(Collectors.toList());
        }
        this.commonParam2Ctx();
        boolean enableValidateTime = (Boolean)this.ctx.getOption().get("enableValidateTime");
        HashMap<Integer, List<String>> paramFailedErrorMap = new HashMap<Integer, List<String>>(8);
        PermBeforeSaveCheckReq req = this.wrapPermBeforeSaveCheckReq(rowdatas, enumsImportType, keyFieldList, paramFailedErrorMap);
        req.getCheckNeedParamMap().put("enableValidateTime", enableValidateTime);
        PermCheckResp resp = UserBusiRoleImportPlugin.getUserBusiRoleService().beforeSaveCheck(req);
        Map passedMap = resp.getPassedMap();
        HashMap<Integer, List> failedErrorMap = resp.getFailedErrorMap();
        if (null == failedErrorMap) {
            failedErrorMap = new HashMap<Integer, List>(1);
        }
        for (Map.Entry failedError : paramFailedErrorMap.entrySet()) {
            row = (Integer)failedError.getKey();
            value = (List)failedError.getValue();
            if (null == row || null == value || value.isEmpty()) continue;
            failedErrorMap.computeIfAbsent(row, k -> new ArrayList(10)).addAll(value);
        }
        for (Map.Entry failedError : failedErrorMap.entrySet()) {
            row = (Integer)failedError.getKey();
            value = (List)failedError.getValue();
            if (null == row || null == value || value.isEmpty()) continue;
            value.stream().forEach(x -> logger.log(row, x));
        }
        Object permImportFormNumObj = this.ctx.getOption().get("permImportFormNum");
        HashSet<String> roleAssignUserListImportFormSet = null == this.ctx.getOption().get("roleAssignUserListImportFormSet") ? new HashSet<String>(0) : (Set)this.ctx.getOption().get("roleAssignUserListImportFormSet");
        HashSet<String> userAssignRoleListImportFormSet = null == this.ctx.getOption().get("userAssignRoleListImportFormSet") ? new HashSet<String>(0) : (Set)this.ctx.getOption().get("userAssignRoleListImportFormSet");
        String busitype = UserBusiRoleImportPlugin.getBusitype(permImportFormNumObj, roleAssignUserListImportFormSet, userAssignRoleListImportFormSet);
        PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)busitype, (boolean)false);
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            JSONObject data;
            ImportBillData bill = it.next();
            if (bill.isEmpty() || null == (data = bill.getData())) continue;
            try {
                int row2 = bill.getStartIndex();
                if (failedErrorMap.containsKey(row2)) {
                    it.remove();
                    logger.fail();
                    logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
                    continue;
                }
                UserBusiRoleImportPlugin.replaceFieldValue(passedMap, data, row2, enableValidateTime, permLogBusiType);
            }
            catch (Throwable throwable) {
                log.warn("UserBusiRoleImportPlugin.save error.", throwable);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    logger.log(Integer.valueOf(rowdatas.get(0).getStartIndex()), throwable);
                } else {
                    logger.log(Integer.valueOf(rowdatas.get(0).getStartIndex()), ResManager.loadKDString((String)"\u6570\u636e\u5305\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"RoleAndFuncImportPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                }
                it.remove();
                logger.fail();
                logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
            }
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult apiResult = super.save(rowdatas, logger);
        if (null == apiResult) {
            return null;
        }
        Object apiData = apiResult.getData();
        if (null == apiData) {
            return null;
        }
        HashSet<String> mainIdSet = new HashSet<String>(8);
        List saveResult = (List)apiData;
        for (Map map : saveResult) {
            Integer dindex = (Integer)map.get("dindex");
            Boolean success = (Boolean)map.get("success");
            Long userbusiroleId = (Long)map.get("id");
            if (!Boolean.TRUE.equals(success) || null == userbusiroleId || Objects.equals(0L, userbusiroleId)) continue;
            mainIdSet.add(String.valueOf(userbusiroleId));
        }
        PermLogReq permLogReq = this.wrapPermLogReq();
        Object currentImportType = this.ctx.getOption().get("importtype");
        EnumsImportType enumsImportType = EnumsImportType.getImportTypeEnum(currentImportType);
        if (null == enumsImportType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u5bfc\u5165\u7c7b\u578b\u3002", (String)"RoleAndFuncImportPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        UserBusiRoleAfterSaveReq afterSaveReq = (UserBusiRoleAfterSaveReq)PermBuilder.of(UserBusiRoleAfterSaveReq::new).with(PermOperationReq::setMainIdSet, mainIdSet).with(PermOperationReq::setEnumsImportType, (Object)enumsImportType).with(PermOperationReq::setPermLogReq, (Object)permLogReq).build();
        UserBusiRoleImportPlugin.getUserBusiRoleService().afterMainEntitySave((PermOperationReq)afterSaveReq);
        return apiResult;
    }

    private PermLogReq wrapPermLogReq() {
        if (!PermCommonUtil.isEnablePermLog()) {
            return null;
        }
        String appNum = "";
        String formShowParameterAppId = this.ctx.getFormShowParameterAppId();
        if (StringUtils.isNotEmpty((String)formShowParameterAppId)) {
            appNum = formShowParameterAppId;
        }
        String checkRightAppId = this.ctx.getCheckRightAppId();
        if (StringUtils.isEmpty((String)appNum) && StringUtils.isNotEmpty((String)checkRightAppId)) {
            appNum = checkRightAppId;
        }
        if (StringUtils.isEmpty((String)appNum)) {
            appNum = this.ctx.getAppId();
        }
        String appId = AppHelper.getMetaAppInfo((String)appNum).getId();
        String formNum = this.ctx.getBillFormId();
        String appIdByFormNum = StringUtils.isEmpty((String)appId) ? BizAppServiceHelp.getAppIdByFormNum((String)formNum) : appId;
        String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
        PermLogReq permLogReq = new PermLogReq();
        Object permImportFormNumObj = this.ctx.getOption().get("permImportFormNum");
        HashSet<String> roleAssignUserListImportFormSet = null == this.ctx.getOption().get("roleAssignUserListImportFormSet") ? new HashSet<String>(0) : (Set)this.ctx.getOption().get("roleAssignUserListImportFormSet");
        HashSet<String> userAssignRoleListImportFormSet = null == this.ctx.getOption().get("userAssignRoleListImportFormSet") ? new HashSet<String>(0) : (Set)this.ctx.getOption().get("userAssignRoleListImportFormSet");
        String busitype = UserBusiRoleImportPlugin.getBusitype(permImportFormNumObj, roleAssignUserListImportFormSet, userAssignRoleListImportFormSet);
        PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)busitype);
        permLogReq.setBusiFrom(null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
        permLogReq.setBusiType(null == permLogBusiType ? "" : permLogBusiType.getBusiType());
        permLogReq.setFormIdentity(formNum);
        permLogReq.setAppId(appIdByFormNum);
        permLogReq.setCloudId(cloudId);
        permLogReq.setOp("importdata");
        permLogReq.setOpbtn(ConstantsHelper.getImportData());
        permLogReq.setInterfaceMethod("kd.bos.permission.formplugin.plugin.impexp.imp.UserBusiRoleImportPlugin.wrapPermLogReq");
        permLogReq.setOperTime(TimeServiceHelper.now());
        permLogReq.setClientType(RequestContext.get().getClient());
        permLogReq.setClientIp(RequestContext.get().getLoginIP());
        return permLogReq;
    }

    private static UserBusiRoleService getUserBusiRoleService() {
        return (UserBusiRoleService)PermServiceFactory.getService((String)"UserBusiRoleService");
    }

    private void commonParam2Ctx() {
        Object userAssignRoleListImportFormSetObj;
        Object roleAssignUserListImportFormSetObj;
        Object enableValidateTimeObj = this.ctx.getOption().get("enableValidateTime");
        if (null == enableValidateTimeObj) {
            boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
            this.ctx.addOption("enableValidateTime", (Object)enableValidateTime);
        }
        if (null == (roleAssignUserListImportFormSetObj = this.ctx.getOption().get("roleAssignUserListImportFormSet"))) {
            Set roleAssignUserListImportFormSet = FormHelper.getIgnoreRefEntNumSet((String[])new String[]{"perm_busiroleuser_layout"});
            this.ctx.addOption("roleAssignUserListImportFormSet", (Object)roleAssignUserListImportFormSet);
        }
        if (null == (userAssignRoleListImportFormSetObj = this.ctx.getOption().get("userAssignRoleListImportFormSet"))) {
            Set userAssignRoleListImportFormSet = FormHelper.getIgnoreRefEntNumSet((String[])new String[]{"perm_userbusirole_layout"});
            this.ctx.addOption("userAssignRoleListImportFormSet", (Object)userAssignRoleListImportFormSet);
        }
    }

    private static void replaceFieldValue(Map<Integer, UserBusiRoleImportBean> passedMap, JSONObject data, int row, boolean enableValidateTime, PermLogBusiType permLogBusiType) {
        UserBusiRoleImportBean importBean = passedMap.get(row);
        if (null == importBean) {
            return;
        }
        if (!enableValidateTime) {
            data.put("starttime", null);
            data.put("endtime", null);
        }
        data.put("fromtypedesc", (Object)(null == permLogBusiType ? "import" : permLogBusiType.getBusiTypeDesc()));
    }

    private static String getBusitype(Object permImportFormNumObj, Set<String> roleAssignUserListImportFormSet, Set<String> userAssignRoleListImportFormSet) {
        String busitype = "busi_role_assignuserlist_import";
        if (null != permImportFormNumObj) {
            String permImportFormNum = (String)permImportFormNumObj;
            if (roleAssignUserListImportFormSet.contains(permImportFormNum)) {
                busitype = "busi_role_assignuserlist_import";
            } else if (userAssignRoleListImportFormSet.contains(permImportFormNum)) {
                busitype = "userassignbusirolelist_import";
            }
        }
        return busitype;
    }

    private PermBeforeSaveCheckReq wrapPermBeforeSaveCheckReq(List<ImportBillData> billdatas, EnumsImportType enumsImportType, List<String> keyFieldList, Map<Integer, List<String>> paramFailedErrorMap) {
        ArrayList<UserBusiRoleImportBean> importBeanList = new ArrayList<UserBusiRoleImportBean>(billdatas.size());
        HashSet<String> busiRoleNumSet = new HashSet<String>(8);
        HashSet<String> userNumSet = new HashSet<String>(8);
        UserBusiRoleImportBean importBean = null;
        for (ImportBillData bill : billdatas) {
            String importprop;
            String importprop2;
            JSONObject data;
            if (bill.isEmpty() || (data = bill.getData()) == null) continue;
            importBean = new UserBusiRoleImportBean();
            importBean.setLineNum(bill.getStartIndex());
            String busiRoleNumber = "";
            JSONObject role = data.getJSONObject("bizrole");
            if (null != role && StringUtils.isNotEmpty((String)(importprop2 = role.getString("importprop"))) && StringUtils.isNotEmpty((String)(busiRoleNumber = role.getString(importprop2)))) {
                busiRoleNumSet.add(busiRoleNumber);
            }
            importBean.setBusiRoleNum(busiRoleNumber);
            String userNumber = "";
            JSONObject user = data.getJSONObject("user");
            if (null != user && StringUtils.isNotEmpty((String)(importprop = user.getString("importprop"))) && StringUtils.isNotEmpty((String)(userNumber = user.getString(importprop)))) {
                userNumSet.add(userNumber);
            }
            importBean.setUserNumber(userNumber);
            String startTimeStr = StringUtils.isEmpty((String)data.getString("starttime")) ? "" : data.getString("starttime");
            Date startTime = null;
            try {
                startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate((String)startTimeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                paramFailedErrorMap.computeIfAbsent(bill.getStartIndex(), k -> new ArrayList(10)).add(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002", (String)"UserRoleImportPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
            importBean.setStartTime(startTime);
            String endTimeStr = StringUtils.isEmpty((String)data.getString("endtime")) ? "" : data.getString("endtime");
            Date endTime = null;
            try {
                endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate((String)endTimeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                paramFailedErrorMap.computeIfAbsent(bill.getStartIndex(), k -> new ArrayList(10)).add(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002", (String)"UserRoleImportPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
            importBean.setEndTime(endTime);
            importBeanList.add(importBean);
        }
        HashMap<String, Map> importCheckParamMap = new HashMap<String, Map>(8);
        Map busiRoleNumBusiRoleMap = new HashMap(1);
        if (CollectionUtils.isNotEmpty(busiRoleNumSet)) {
            busiRoleNumBusiRoleMap = PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap(busiRoleNumSet, (String)"number");
        }
        importCheckParamMap.put("busiRoleNumBusiRoleMap", busiRoleNumBusiRoleMap);
        Map userNumMap = new HashMap(1);
        Map userNumExistMap = new HashMap(1);
        if (CollectionUtils.isNotEmpty(userNumSet)) {
            userNumMap = UserHelper.getUserMap(userNumSet, (String)"number");
            userNumExistMap = PermVerifyUtil.getExistMapByNum((String)"bos_user", userNumSet);
        }
        importCheckParamMap.put("userNumMap", userNumMap);
        importCheckParamMap.put("userNumExistMap", userNumExistMap);
        HashMap<String, GetHasPermUserResp> dimTypeAdminHasPermUserMap = new HashMap<String, GetHasPermUserResp>(1);
        long currUserId = RequestContext.get().getCurrUserId();
        GetHasPermUserResp adminHasPermUser = PermCtrlTypeService.getAdminHasPermUser((GetHasPermUserReq)new GetHasPermUserReq("bos_org", Long.valueOf(currUserId), null, userNumSet));
        dimTypeAdminHasPermUserMap.put("bos_org", adminHasPermUser);
        importCheckParamMap.put("dimTypeAdminHasPermUserMap", dimTypeAdminHasPermUserMap);
        Map userBusiRoleMap = UserBusiRoleService.getUserBusiRoleMap((GetUserBusiRoleReq)new GetUserBusiRoleReq(Integer.valueOf(1), null, null, userNumSet, null, busiRoleNumSet));
        importCheckParamMap.put("userBusiRoleMap", userBusiRoleMap);
        PermBeforeSaveCheckReq req = new PermBeforeSaveCheckReq();
        req.setEnumsImportType(enumsImportType);
        req.setKeyFieldList(keyFieldList);
        req.setNeedCheckBeanList(importBeanList);
        req.setCheckNeedParamMap(importCheckParamMap);
        return req;
    }
}

