/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.impexp.imp;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermVerifyUtil;
import kd.bos.permission.enums.EnumsImportType;
import kd.bos.permission.enums.EnumsYesNo;
import kd.bos.permission.factory.PermServiceFactory;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.imp.UsrGrpComRoleImportBean;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.bat.PermBeforeSaveCheckReq;
import kd.bos.permission.model.perm.req.bat.aftersave.UsrGrpComRoleAfterSaveReq;
import kd.bos.permission.model.perm.req.permctrltype.GetHasPermPermCtrlObjReq;
import kd.bos.permission.model.perm.req.usrgrprole.GetUsrGrpRoleDimReq;
import kd.bos.permission.model.perm.resp.bat.PermCheckResp;
import kd.bos.permission.model.perm.resp.permctrltype.GetHasPermPermCtrlObjResp;
import kd.bos.permission.model.perm.usrgrp.UsrGrp;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.UsrGrpRoleService;
import kd.bos.permission.service.permctrltype.PermCtrlTypeService;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class UsrGrpRoleImportPlugin
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(UsrGrpRoleImportPlugin.class);

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return super.getBatchImportSize();
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(ctx);
            formView.setVisible(Boolean.FALSE, new String[]{"radiofield1", "radiofield2"});
            IFormView parentView = formView.getParentView();
            if (parentView instanceof ListView) {
                String billFormId = ((ListView)parentView).getBillFormId();
                ctx.addOption("permImportFormNum", (Object)billFormId);
            }
        }
        catch (Exception e) {
            log.warn("UsrGrpRoleImportPlugin.setContext error", (Throwable)e);
        }
        return super.setContext(rc, ctx, startArgs);
    }

    protected MainEntityType buildMainEntityType(JSONObject billdata) {
        try {
            MainEntityType entityType = super.buildMainEntityType(billdata);
            entityType = (MainEntityType)entityType.clone();
            String controlFlag = "dimtype";
            IsoDimHelper.rewriteMainEntityType((String)controlFlag, null, (MainEntityType)entityType);
            BasedataEntityType bdet = (BasedataEntityType)entityType;
            if (null == bdet) {
                return entityType;
            }
            ItemClassTypeProp dimentitynum = (ItemClassTypeProp)bdet.getProperty(controlFlag);
            if (null != dimentitynum) {
                dimentitynum.setEditable(true);
            }
            this.mainEntityType = entityType;
            return entityType;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String billFormId = this.getBillFormId();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)billFormId);
        if (null == met) {
            return items;
        }
        BasedataEntityType bdet = (BasedataEntityType)met;
        if (null == bdet) {
            return items;
        }
        String numberProperty = bdet.getNumberProperty();
        if (StringUtils.isNotEmpty((String)numberProperty)) {
            for (IDataEntityProperty p : met.getProperties()) {
                if (!Objects.equals(numberProperty, p.getName())) continue;
                items.add(new ComboItem(p.getDisplayName(), p.getName()));
            }
        }
        return items;
    }

    public String getDefaultImportType() {
        return "new";
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        if (null == billdatas || billdatas.isEmpty()) {
            super.beforeSave(billdatas, logger);
            return;
        }
        this.commonParam2Ctx();
        HashMap<Integer, List> beforeSaveFailedErrorMap = new HashMap<Integer, List>(8);
        Map yesNoMap = (Map)this.ctx.getOption().get("yesNoMap");
        for (ImportBillData bill : billdatas) {
            JSONObject data;
            if (bill.isEmpty() || (data = bill.getData()) == null || !data.containsKey((Object)"includesub")) continue;
            String includesuborg = data.getString("includesub");
            if (yesNoMap.values().contains(includesuborg)) continue;
            beforeSaveFailedErrorMap.computeIfAbsent(bill.getStartIndex(), k -> new ArrayList(10)).add(String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleImportPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), includesuborg));
        }
        this.ctx.addOption("beforeSaveFailedErrorMap", beforeSaveFailedErrorMap);
        super.beforeSave(billdatas, logger);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        List value;
        Integer row;
        Object currentImportType = this.ctx.getOption().get("importtype");
        EnumsImportType enumsImportType = EnumsImportType.getImportTypeEnum(currentImportType);
        if (null == enumsImportType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u5bfc\u5165\u7c7b\u578b\u3002", (String)"RoleAndFuncImportPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        List<String> keyFieldList = null;
        Object keyFields = this.ctx.getOption().get("KeyFields");
        if (!Objects.isNull(keyFields)) {
            keyFieldList = Arrays.stream(((String)keyFields).split(",")).filter(x -> StringUtils.isNotEmpty((String)x)).collect(Collectors.toList());
        }
        Map bigPermCtrlTypeMap = (Map)this.ctx.getOption().get("bigPermCtrlTypeMap");
        boolean enableValidateTime = (Boolean)this.ctx.getOption().get("enableValidateTime");
        HashMap<Integer, List<String>> paramFailedErrorMap = new HashMap<Integer, List<String>>(8);
        Object beforeSaveFailedErrorMapObj = this.ctx.getOption().get("beforeSaveFailedErrorMap");
        Map beforeSaveFailedErrorMap = null == beforeSaveFailedErrorMapObj ? new HashMap(0) : (Map)beforeSaveFailedErrorMapObj;
        for (Map.Entry failedError : beforeSaveFailedErrorMap.entrySet()) {
            Integer row2 = (Integer)failedError.getKey();
            List value2 = (List)failedError.getValue();
            paramFailedErrorMap.computeIfAbsent(row2, k -> new ArrayList(10)).addAll(value2);
        }
        PermBeforeSaveCheckReq req = this.wrapPermBeforeSaveCheckReq(rowdatas, enumsImportType, keyFieldList, bigPermCtrlTypeMap, paramFailedErrorMap);
        req.getCheckNeedParamMap().put("yesNoMap", (Map)this.ctx.getOption().get("yesNoMap"));
        req.getCheckNeedParamMap().put("bigPermCtrlTypeMap", bigPermCtrlTypeMap);
        req.getCheckNeedParamMap().put("enableValidateTime", enableValidateTime);
        PermCheckResp resp = UsrGrpRoleImportPlugin.getUsrGrpRoleService().beforeSaveCheck(req);
        Map passedMap = resp.getPassedMap();
        HashMap<Integer, List> failedErrorMap = resp.getFailedErrorMap();
        if (null == failedErrorMap) {
            failedErrorMap = new HashMap<Integer, List>(1);
        }
        for (Map.Entry failedError : paramFailedErrorMap.entrySet()) {
            row = (Integer)failedError.getKey();
            value = (List)failedError.getValue();
            if (null == row || null == value || value.isEmpty()) continue;
            failedErrorMap.computeIfAbsent(row, k -> new ArrayList(10)).addAll(value);
        }
        for (Map.Entry failedError : failedErrorMap.entrySet()) {
            row = (Integer)failedError.getKey();
            value = (List)failedError.getValue();
            if (null == row || null == value || value.isEmpty()) continue;
            value.stream().forEach(x -> logger.log(row, x));
        }
        Object permImportFormNumObj = this.ctx.getOption().get("permImportFormNum");
        HashSet<String> roleAssignusrGrpListImportFormSet = null == this.ctx.getOption().get("roleAssignusrGrpListImportFormSet") ? new HashSet<String>(0) : (Set)this.ctx.getOption().get("roleAssignusrGrpListImportFormSet");
        HashSet<String> usrGrpAssignRoleListImportFormSet = null == this.ctx.getOption().get("usrGrpAssignRoleListImportFormSet") ? new HashSet<String>(0) : (Set)this.ctx.getOption().get("usrGrpAssignRoleListImportFormSet");
        String busitype = UsrGrpRoleImportPlugin.getBusitype(permImportFormNumObj, roleAssignusrGrpListImportFormSet, usrGrpAssignRoleListImportFormSet);
        PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)busitype, (boolean)false);
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            JSONObject data;
            ImportBillData bill = it.next();
            if (bill.isEmpty() || null == (data = bill.getData())) continue;
            try {
                int row3 = bill.getStartIndex();
                if (failedErrorMap.containsKey(row3)) {
                    it.remove();
                    logger.fail();
                    logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
                    continue;
                }
                UsrGrpRoleImportPlugin.replaceFieldValue(passedMap, data, row3, enableValidateTime, permLogBusiType);
            }
            catch (Throwable throwable) {
                log.warn("UsrGrpRoleImportPlugin.save error.", throwable);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    logger.log(Integer.valueOf(rowdatas.get(0).getStartIndex()), throwable);
                } else {
                    logger.log(Integer.valueOf(rowdatas.get(0).getStartIndex()), ResManager.loadKDString((String)"\u6570\u636e\u5305\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"RoleAndFuncImportPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                }
                it.remove();
                logger.fail();
                logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
            }
        }
        ApiResult apiResult = super.save(rowdatas, logger);
        if (null == apiResult) {
            return null;
        }
        Object apiData = apiResult.getData();
        if (null == apiData) {
            return null;
        }
        HashSet<String> mainIdSet = new HashSet<String>(8);
        List saveResult = (List)apiData;
        for (Map map : saveResult) {
            Integer dindex = (Integer)map.get("dindex");
            Boolean success = (Boolean)map.get("success");
            String userroleId = (String)map.get("id");
            if (!Boolean.TRUE.equals(success) || StringUtils.isEmpty((String)userroleId)) continue;
            mainIdSet.add(userroleId);
        }
        PermLogReq permLogReq = this.wrapPermLogReq();
        UsrGrpComRoleAfterSaveReq afterSaveReq = (UsrGrpComRoleAfterSaveReq)PermBuilder.of(UsrGrpComRoleAfterSaveReq::new).with(PermOperationReq::setEnumsImportType, (Object)enumsImportType).with(PermOperationReq::setPermLogReq, (Object)permLogReq).with(PermOperationReq::setMainIdSet, mainIdSet).build();
        UsrGrpRoleImportPlugin.getUsrGrpRoleService().afterMainEntitySave((PermOperationReq)afterSaveReq);
        return apiResult;
    }

    private PermLogReq wrapPermLogReq() {
        if (!PermCommonUtil.isEnablePermLog()) {
            return null;
        }
        String appNum = "";
        String formShowParameterAppId = this.ctx.getFormShowParameterAppId();
        if (StringUtils.isNotEmpty((String)formShowParameterAppId)) {
            appNum = formShowParameterAppId;
        }
        String checkRightAppId = this.ctx.getCheckRightAppId();
        if (StringUtils.isEmpty((String)appNum) && StringUtils.isNotEmpty((String)checkRightAppId)) {
            appNum = checkRightAppId;
        }
        if (StringUtils.isEmpty((String)appNum)) {
            appNum = this.ctx.getAppId();
        }
        String appId = AppHelper.getMetaAppInfo((String)appNum).getId();
        String formNum = this.ctx.getBillFormId();
        String appIdByFormNum = StringUtils.isEmpty((String)appId) ? BizAppServiceHelp.getAppIdByFormNum((String)formNum) : appId;
        String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
        PermLogReq permLogReq = new PermLogReq();
        Object permImportFormNumObj = this.ctx.getOption().get("permImportFormNum");
        HashSet<String> roleAssignusrGrpListImportFormSet = null == this.ctx.getOption().get("roleAssignusrGrpListImportFormSet") ? new HashSet<String>(0) : (Set)this.ctx.getOption().get("roleAssignusrGrpListImportFormSet");
        HashSet<String> usrGrpAssignRoleListImportFormSet = null == this.ctx.getOption().get("usrGrpAssignRoleListImportFormSet") ? new HashSet<String>(0) : (Set)this.ctx.getOption().get("usrGrpAssignRoleListImportFormSet");
        String busitype = UsrGrpRoleImportPlugin.getBusitype(permImportFormNumObj, roleAssignusrGrpListImportFormSet, usrGrpAssignRoleListImportFormSet);
        PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)busitype);
        permLogReq.setBusiFrom(null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
        permLogReq.setBusiType(null == permLogBusiType ? "" : permLogBusiType.getBusiType());
        permLogReq.setFormIdentity(formNum);
        permLogReq.setAppId(appIdByFormNum);
        permLogReq.setCloudId(cloudId);
        permLogReq.setOp("importdata");
        permLogReq.setOpbtn(ConstantsHelper.getImportData());
        permLogReq.setInterfaceMethod("kd.bos.permission.formplugin.plugin.impexp.imp.UsrGrpRoleImportPlugin.wrapPermLogReq");
        permLogReq.setOperTime(TimeServiceHelper.now());
        permLogReq.setClientType(RequestContext.get().getClient());
        permLogReq.setClientIp(RequestContext.get().getLoginIP());
        return permLogReq;
    }

    private static String getBusitype(Object permImportFormNumObj, Set<String> roleAssignusrGrpListImportFormSet, Set<String> usrGrpAssignRoleListImportFormSet) {
        String busitype = "common_role_assignusrgrplist_import";
        if (null != permImportFormNumObj) {
            String permImportFormNum = (String)permImportFormNumObj;
            if (roleAssignusrGrpListImportFormSet.contains(permImportFormNum)) {
                busitype = "common_role_assignusrgrplist_import";
            } else if (usrGrpAssignRoleListImportFormSet.contains(permImportFormNum)) {
                busitype = "usrgrpassignrolelist_import";
            }
        }
        return busitype;
    }

    private static UsrGrpRoleService getUsrGrpRoleService() {
        return (UsrGrpRoleService)PermServiceFactory.getService((String)"UsrGrpRoleService");
    }

    private void commonParam2Ctx() {
        Object usrGrpAssignRoleListImportFormSetObj;
        Object roleAssignusrGrpListImportFormSetObj;
        Object enableValidateTimeObj;
        Object bigPermCtrlTypeMapObj;
        Object yesNoMapObj = this.ctx.getOption().get("yesNoMap");
        if (null == yesNoMapObj) {
            Map yesNoMap = EnumsYesNo.getMap();
            this.ctx.addOption("yesNoMap", (Object)yesNoMap);
        }
        if (null == (bigPermCtrlTypeMapObj = this.ctx.getOption().get("bigPermCtrlTypeMap"))) {
            PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq(null, null, null, null, null);
            Map bigPermCtrlTypeMap = IsoDimHelper.getBigPermCtrlTypeMap((PermCtrlTypeReq)permCtrlTypeReq);
            this.ctx.addOption("bigPermCtrlTypeMap", (Object)bigPermCtrlTypeMap);
        }
        if (null == (enableValidateTimeObj = this.ctx.getOption().get("enableValidateTime"))) {
            boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
            this.ctx.addOption("enableValidateTime", (Object)enableValidateTime);
        }
        if (null == (roleAssignusrGrpListImportFormSetObj = this.ctx.getOption().get("roleAssignusrGrpListImportFormSet"))) {
            Set roleAssignusrGrpListImportFormSet = FormHelper.getIgnoreRefEntNumSet((String[])new String[]{"perm_roleusrgrp_layout"});
            this.ctx.addOption("roleAssignusrGrpListImportFormSet", (Object)roleAssignusrGrpListImportFormSet);
        }
        if (null == (usrGrpAssignRoleListImportFormSetObj = this.ctx.getOption().get("usrGrpAssignRoleListImportFormSet"))) {
            Set usrGrpAssignRoleListImportFormSet = FormHelper.getIgnoreRefEntNumSet((String[])new String[]{"perm_usrgrprole_layout"});
            this.ctx.addOption("usrGrpAssignRoleListImportFormSet", (Object)usrGrpAssignRoleListImportFormSet);
        }
    }

    private static void replaceFieldValue(Map<Integer, UsrGrpComRoleImportBean> passedMap, JSONObject data, int row, boolean enableValidateTime, PermLogBusiType permLogBusiType) {
        UsrGrpComRoleImportBean importBean = passedMap.get(row);
        if (null == importBean) {
            return;
        }
        data.put("dimtype", (Object)importBean.getDimType());
        if (!enableValidateTime) {
            data.put("starttime", null);
            data.put("endtime", null);
        }
        data.put("fromtypedesc", (Object)(null == permLogBusiType ? "import" : permLogBusiType.getBusiTypeDesc()));
    }

    private PermBeforeSaveCheckReq wrapPermBeforeSaveCheckReq(List<ImportBillData> billdatas, EnumsImportType enumsImportType, List<String> keyFieldList, Map<String, PermCtrlType> bigPermCtrlTypeMap, Map<Integer, List<String>> paramFailedErrorMap) {
        ArrayList<UsrGrpComRoleImportBean> importBeanList = new ArrayList<UsrGrpComRoleImportBean>(billdatas.size());
        HashSet<String> roleNumSet = new HashSet<String>(8);
        HashSet<String> usrGrpNumSet = new HashSet<String>(8);
        HashMap<String, Set> dimTypeSmallDimNumSetMap = new HashMap<String, Set>(8);
        UsrGrpComRoleImportBean importBean = null;
        for (ImportBillData bill : billdatas) {
            String string;
            String importprop2;
            JSONObject import_dimtype;
            String importprop3;
            String importprop4;
            JSONObject data;
            if (bill.isEmpty() || (data = bill.getData()) == null) continue;
            importBean = new UsrGrpComRoleImportBean();
            int startIndex = bill.getStartIndex();
            importBean.setLineNum(startIndex);
            String roleNumber = "";
            JSONObject role = data.getJSONObject("role");
            if (null != role && StringUtils.isNotEmpty((String)(importprop4 = role.getString("importprop"))) && StringUtils.isNotEmpty((String)(roleNumber = role.getString(importprop4)))) {
                roleNumSet.add(roleNumber);
            }
            importBean.setRoleNum(roleNumber);
            String usrGrpNumber = "";
            JSONObject usrgrp = data.getJSONObject("usrgrpid");
            if (null != usrgrp && StringUtils.isNotEmpty((String)(importprop3 = usrgrp.getString("importprop"))) && StringUtils.isNotEmpty((String)(usrGrpNumber = usrgrp.getString(importprop3)))) {
                usrGrpNumSet.add(usrGrpNumber);
            }
            importBean.setUsrGrpNumber(usrGrpNumber);
            String dimTypeBig = "";
            if (data.containsKey((Object)"import_dimtype") && null != (import_dimtype = data.getJSONObject("import_dimtype")) && StringUtils.isNotEmpty((String)(importprop2 = import_dimtype.getString("importprop")))) {
                dimTypeBig = import_dimtype.getString(importprop2);
            }
            String dimType = "";
            PermCtrlType permCtrlType = bigPermCtrlTypeMap.get(dimTypeBig);
            if (null != permCtrlType) {
                dimType = permCtrlType.getBizobjectid();
            }
            importBean.setDimType(dimType);
            importBean.setDimTypeBig(dimTypeBig);
            String dimNum = "";
            JSONObject itemclass = data.getJSONObject("dimtype");
            if (null != itemclass && StringUtils.isNotEmpty((String)(string = itemclass.getString("importprop")))) {
                dimNum = itemclass.getString(string);
            }
            importBean.setDimNum(dimNum);
            dimTypeSmallDimNumSetMap.computeIfAbsent(dimType, k -> new HashSet(8)).add(dimNum);
            String string2 = StringUtils.isEmpty((String)data.getString("starttime")) ? "" : data.getString("starttime");
            Date startTime = null;
            try {
                startTime = StringUtils.isEmpty((String)string2) ? null : DateUtil.toDate((String)string2.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                paramFailedErrorMap.computeIfAbsent(startIndex, k -> new ArrayList(10)).add(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002", (String)"UserRoleImportPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
            importBean.setStartTime(startTime);
            String endTimeStr = StringUtils.isEmpty((String)data.getString("endtime")) ? "" : data.getString("endtime");
            Date endTime = null;
            try {
                endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate((String)endTimeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                paramFailedErrorMap.computeIfAbsent(startIndex, k -> new ArrayList(10)).add(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002", (String)"UserRoleImportPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
            importBean.setEndTime(endTime);
            Boolean includesuborg = data.getBooleanValue("includesub");
            importBean.setIncludeSub(includesuborg);
            importBeanList.add(importBean);
        }
        HashMap<String, Map> importCheckParamMap = new HashMap<String, Map>(8);
        Map roleNumberComRoleMap = new HashMap(1);
        Map roleNumCanModifyRoleMap = new HashMap(1);
        long currUserId = RequestContext.get().getCurrUserId();
        if (CollectionUtils.isNotEmpty(roleNumSet)) {
            roleNumberComRoleMap = PermRoleHelper.getRoleIdOrNumOrNameComRoleMap(roleNumSet, (String)"number");
            roleNumCanModifyRoleMap = AdminGroupService.canModifyRole((Long)currUserId, roleNumSet);
        }
        importCheckParamMap.put("roleNumberComRoleMap", roleNumberComRoleMap);
        importCheckParamMap.put("roleNumCanModifyRoleMap", roleNumCanModifyRoleMap);
        Map usrGrpNumMap = new HashMap(1);
        if (CollectionUtils.isNotEmpty(usrGrpNumSet)) {
            usrGrpNumMap = UserGroupHelper.getUsrGrpMap(usrGrpNumSet, (String)"number");
        }
        importCheckParamMap.put("usrGrpNumMap", usrGrpNumMap);
        HashMap<String, Map> dimTypeDimNumDimMap = new HashMap<String, Map>(1);
        HashMap<String, GetHasPermPermCtrlObjResp> dimTypeAdminHasPermPermCtrlObjMap = new HashMap<String, GetHasPermPermCtrlObjResp>(1);
        HashMap<String, Map> dimTypeDimNumExistMap = new HashMap<String, Map>(1);
        HashSet dimIdSet = null;
        if (null != dimTypeSmallDimNumSetMap && !dimTypeSmallDimNumSetMap.isEmpty()) {
            int size = dimTypeSmallDimNumSetMap.size();
            dimTypeDimNumDimMap = new HashMap(size);
            dimTypeAdminHasPermPermCtrlObjMap = new HashMap(size);
            dimTypeDimNumExistMap = new HashMap(size);
            dimIdSet = new HashSet(8);
            for (Map.Entry entry : dimTypeSmallDimNumSetMap.entrySet()) {
                String dimTypeSmall = (String)entry.getKey();
                Set dimNumSet = (Set)entry.getValue();
                if (StringUtils.isEmpty((String)dimTypeSmall) || CollectionUtils.isEmpty((Collection)dimNumSet)) continue;
                Map dimNumDimSetMap = IsoDimHelper.getDimSetMap((Set)dimNumSet, (String)"number", (String)dimTypeSmall);
                dimTypeDimNumDimMap.put(dimTypeSmall, dimNumDimSetMap);
                Set oneDimIdSet = dimNumDimSetMap.values().stream().flatMap(x -> x.stream()).map(Dim::getDimId).collect(Collectors.toSet());
                GetHasPermPermCtrlObjResp adminHasPermPermCtrlObj = PermCtrlTypeService.getAdminHasPermPermCtrlObj((GetHasPermPermCtrlObjReq)new GetHasPermPermCtrlObjReq(dimTypeSmall, Long.valueOf(currUserId), oneDimIdSet, dimNumSet));
                dimTypeAdminHasPermPermCtrlObjMap.put(dimTypeSmall, adminHasPermPermCtrlObj);
                Map dimNumExistMap = PermVerifyUtil.getExistMapByNum((String)dimTypeSmall, (Set)dimNumSet);
                dimTypeDimNumExistMap.put(dimTypeSmall, dimNumExistMap);
                dimIdSet.addAll(oneDimIdSet);
            }
        }
        importCheckParamMap.put("dimTypeDimNumDimMap", dimTypeDimNumDimMap);
        importCheckParamMap.put("dimTypeAdminHasPermPermCtrlObjMap", dimTypeAdminHasPermPermCtrlObjMap);
        importCheckParamMap.put("dimTypeDimNumExistMap", dimTypeDimNumExistMap);
        Set roleIdSet = roleNumberComRoleMap.values().stream().flatMap(x -> x.stream()).map(ComRole::getId).collect(Collectors.toSet());
        Set usrGrpIdSet = usrGrpNumMap.values().stream().flatMap(x -> x.stream()).map(UsrGrp::getUserGroupId).collect(Collectors.toSet());
        Map map = UsrGrpRoleService.getUsrGrpRoleDimMap((GetUsrGrpRoleDimReq)new GetUsrGrpRoleDimReq(Integer.valueOf(1), null, usrGrpIdSet, null, roleIdSet, null, dimTypeDimNumDimMap.keySet(), dimIdSet, null));
        importCheckParamMap.put("usrGrpRoleDimMap", map);
        PermBeforeSaveCheckReq req = new PermBeforeSaveCheckReq();
        req.setEnumsImportType(enumsImportType);
        req.setKeyFieldList(keyFieldList);
        req.setNeedCheckBeanList(importBeanList);
        req.setCheckNeedParamMap(importCheckParamMap);
        return req;
    }
}

