/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.role;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.OrgUserHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.model.PermUserRole;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.plugin.MultiDimAssignPermPlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.model.perm.DimUserEdit;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class RoleAssignUserMultiPlugin
extends MultiDimAssignPermPlugin
implements TabSelectListener,
RowClickEventListener,
ItemClickListener {
    protected static final String CLOSECALLBACK_ADDUSER = "closeCallBack_addUser";

    public void initialize() {
        this.initVariable("user");
        this.addListener();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String roleId = (String)formShowParameter.getCustomParam("roleId");
        if (!StringUtils.isEmpty((String)roleId)) {
            this.getModel().setValue("role", (Object)roleId);
            this.getView().updateView("role");
            this.getView().updateView("rolename");
            this.init();
        }
    }

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String curDimType;
        if ("true".equals(this.getPageCache().get("pgcache_skip"))) {
            this.getPageCache().remove("pgcache_skip");
            return;
        }
        Tab tab = (Tab)this.getCurControl("dimtab");
        String curCtrlType = tab.getCurrentTab();
        if (curCtrlType.equals(curDimType = (String)this.getModel().getValue("dimtype")) && !this.getLoadedAndModifiedDataMap().isEmpty()) {
            return;
        }
        super.tabSelected(tabSelectEvent);
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        if (isLeftDim) {
            this.loadLeftEntryData();
        } else {
            this.getModel().deleteEntryData("right_dim_entry");
            EntryGrid eg = (EntryGrid)this.getControl(this.LEFT_PROP_ENTRY);
            int[] selectRows = eg.getSelectRows();
            if (selectRows.length == 1) {
                int row = selectRows[0];
                DynamicObject userObj = (DynamicObject)this.getModel().getValue(this.LEFT_PROP, row);
                long userId = userObj.getLong("id");
                this.loadRightEntryData(userId);
                this.getView().setVisible(Boolean.valueOf("bos_org".equals(curCtrlType)), new String[]{this.PROP_INCLUDESUBORG, "dim_includesuborg", this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude"});
            }
        }
    }

    private void loadLeftEntryData() {
        Tab tab = (Tab)this.getCurControl("dimtab");
        String curCtrlType = tab.getCurrentTab();
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        IDataModel dataModel = this.getModel();
        if (isLeftDim) {
            dataModel.deleteEntryData("left_dim_entry");
            dataModel.deleteEntryData(this.RIGHT_PROP_ENTRY);
            List<String> roleAssignDims = this.getLeftEntryDataIds("user", curCtrlType);
            boolean singleOrg = PermFormCommonUtil.isSingleOrg(curCtrlType);
            if (singleOrg && CollectionUtils.isEmpty(roleAssignDims)) {
                this.handleIfIsSingleOrg(dataModel, curCtrlType);
                return;
            }
            List<Long> dimIdList = roleAssignDims.stream().map(Long::valueOf).collect(Collectors.toList());
            this.removeUnChargeOrg(curCtrlType, dimIdList);
            Map dimMap = IsoDimHelper.getDimDynMapByDs(dimIdList, (String)curCtrlType);
            dataModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("left_dimtype", new Object[0]);
            vs.addField("left_dimnum", new Object[0]);
            vs.addField("left_dimname", new Object[0]);
            LinkedHashSet<Long> dimIdSet = new LinkedHashSet<Long>(dimIdList);
            for (Long dimId : dimIdSet) {
                DynamicObject dimObj = (DynamicObject)dimMap.get(dimId);
                if (null == dimObj) continue;
                vs.addRow(new Object[]{curCtrlType, dimId, dimObj.getString("name")});
            }
            ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("left_dim_entry", vs);
            dataModel.endInit();
            this.getView().updateView("left_dim_entry");
            this.selFirstRowInLeftEg();
        } else {
            List<Long> chargeUserList;
            dataModel.deleteEntryData(this.LEFT_PROP_ENTRY);
            dataModel.deleteEntryData("right_dim_entry");
            List<String> roleAssignUsers = this.getLeftEntryDataIds("user", null);
            Set roleAssignUsersSet = roleAssignUsers.stream().map(Long::valueOf).collect(Collectors.toSet());
            if (PermCommonUtil.isEnableJustShowAdminCharged() && (chargeUserList = this.getAdminChargeUser()) != null) {
                roleAssignUsersSet.removeIf(k -> !chargeUserList.contains(k));
            }
            Map userMap = UserHelper.getUserDynMap(roleAssignUsersSet);
            dataModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(this.LEFT_PROP, new Object[0]);
            for (Long userId : roleAssignUsersSet) {
                DynamicObject user = (DynamicObject)userMap.get(userId);
                if (null == user) continue;
                vs.addRow(new Object[]{userId});
            }
            ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow(this.LEFT_PROP_ENTRY, vs);
            dataModel.endInit();
            this.getView().updateView(this.LEFT_PROP_ENTRY);
            EntryGrid leftEg = (EntryGrid)this.getCurControl("left_entrygrid");
            int entryCount = this.getModel().getEntryRowCount((String)this.getCurControl("left_entrygridkey"));
            if (entryCount > 0) {
                leftEg.selectRows(0);
                leftEg.entryRowClick(Integer.valueOf(0));
            } else {
                DynamicObject role = (DynamicObject)this.getModel().getValue("role");
                if (role == null) {
                    return;
                }
                String roleId = role.getString("id");
                this.getPageCache().put("pgcache_skip", "true");
                this.initDimTab(roleId, null);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        DynamicObject role = (DynamicObject)this.getModel().getValue("role");
        if (role == null) {
            return;
        }
        String roleId = role.getString("id");
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        if (isLeftDim) {
            this.initDimTab(roleId, null);
        } else {
            this.loadLeftEntryData();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initDimTab(String roleId, Long userId) {
        Tab tab = (Tab)this.getCurControl("dimtab");
        this.getModel().setValue("dimtype", null);
        this.delAllDimTabKeys();
        List<String> dimTypes = new ArrayList(10);
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        String userHasDimTabKeys = this.getPageCache().get(this.PGCACHE_PROPHASDIMTABKEYS + "_" + userId);
        if (!isLeftDim && StringUtils.isNotEmpty((String)userHasDimTabKeys)) {
            dimTypes = (List)SerializationUtils.fromJsonString((String)userHasDimTabKeys, List.class);
        } else {
            void var10_13;
            Set dimtypeSetByAssined;
            HashSet<String> roleIdSet = new HashSet<String>(1);
            roleIdSet.add(roleId);
            HashSet<Long> userIdSet = new HashSet<Long>(1);
            if (userId != null) {
                userIdSet.add(userId);
            }
            Object sql = "select distinct ur.fdimtype from t_perm_userrole ur join t_perm_ctrltype ct on (ur.fdimtype = ct.fbizobjectid and ct.fsystreefilter = '1') where ur.froleid = ?";
            Object[] objectArray = new Object[]{roleId};
            if (userId != null) {
                sql = (String)sql + " and ur.fuserid = ?";
                Object[] objectArray2 = new Object[]{roleId, userId};
            }
            if ((dimtypeSetByAssined = (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])var10_13, resultSet -> {
                HashSet<String> result = new HashSet<String>(10);
                while (resultSet.next()) {
                    result.add(resultSet.getString("fdimtype"));
                }
                return result;
            })) != null && !dimtypeSetByAssined.isEmpty()) {
                dimTypes.addAll(dimtypeSetByAssined);
            } else {
                Map roleDimTypeSetMap = PermRoleHelper.getRoleDimTypeSetMap(roleIdSet, (boolean)false, (boolean)true);
                Set dimTypeSet = (Set)roleDimTypeSetMap.get(roleId);
                if (dimTypeSet != null && !dimTypeSet.isEmpty()) {
                    Map curValidEntPermCtrlTypeMap = IsoDimHelper.getEntPermCtrlTypeMap((PermCtrlTypeReq)new PermCtrlTypeReq((Set)Sets.newHashSet((Object[])new String[]{"1"}), null, null, null, null));
                    Set sysTreeFilterDimTypes = curValidEntPermCtrlTypeMap.keySet();
                    Iterator iterator = dimTypeSet.iterator();
                    while (iterator.hasNext()) {
                        String dimType = (String)iterator.next();
                        if ("bos_objecttype".equals(dimType) || !sysTreeFilterDimTypes.contains(dimType)) continue;
                        dimTypes.add(dimType);
                    }
                } else {
                    dimTypes.add("bos_org");
                }
            }
        }
        if (!isLeftDim) {
            String jsonMap = this.getPageCache().get("pgcache_batchAddDataMap");
            if (!StringUtils.isEmpty((String)jsonMap)) {
                Map batchAddDataMap = (Map)SerializationUtils.fromJsonString((String)jsonMap, Map.class);
                for (Map.Entry entry : batchAddDataMap.entrySet()) {
                    String key = (String)entry.getKey();
                    List userBatchAddData = (List)entry.getValue();
                    if (!key.contains("user") || !key.contains(userId + "") || userBatchAddData == null) continue;
                    for (String batchAddData : userBatchAddData) {
                        String batchAddDimType = batchAddData.split("\\$")[0];
                        if (dimTypes.contains(batchAddDimType)) continue;
                        dimTypes.add(batchAddDimType);
                    }
                }
            }
            String pgCacheKey = this.PGCACHE_PROPHASDIMTABKEYS + "_" + userId;
            this.getPageCache().put(pgCacheKey, SerializationUtils.toJsonString(dimTypes));
            this.recordKeysWillBeDeleted(pgCacheKey);
        }
        ArrayList<String> allTabKeys = new ArrayList<String>(10);
        ArrayList<Map> items = new ArrayList<Map>(10);
        if (dimTypes.isEmpty()) {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey("bos_org");
            tabPageAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"RoleAssignUserMultiPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0])));
            items.add(tabPageAp.createControl());
            allTabKeys.add("bos_org");
        } else {
            DynamicObjectCollection dimObjCol = QueryServiceHelper.query((String)"perm_ctrltype", (String)"bizobjectid,name", (QFilter[])new QFilter[]{new QFilter("bizobjectid", "in", dimTypes)});
            for (DynamicObject dimObj : dimObjCol) {
                String number = dimObj.getString("bizobjectid");
                String name = dimObj.getString("name");
                TabPageAp tabPageAp = new TabPageAp();
                tabPageAp.setKey(number);
                tabPageAp.setName(new LocaleString(name));
                items.add(tabPageAp.createControl());
                allTabKeys.add(number);
            }
        }
        tab.addControls(items);
        this.getPageCache().put("pgcache_dimtabkeys", JSON.toJSONString(allTabKeys));
        int size = allTabKeys.size();
        if (size > 0) {
            String string = (String)allTabKeys.get(0);
            tab.selectTab(string);
            tab.activeTab(string);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("role".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (newValue != null) {
                String newRoleId = ((DynamicObject)newValue).getString("id");
                FormShowParameter fsp = this.getView().getFormShowParameter();
                String pageId = this.getView().getPageId();
                CharSequence[] pageIdSplit = pageId.split("-");
                String oldRoleId = pageIdSplit[0];
                pageIdSplit[0] = newRoleId;
                String newPageId = String.join((CharSequence)"-", pageIdSplit);
                IFormView newFv = this.getView().getViewNoPlugin(newPageId);
                if (newFv != null) {
                    this.getPageCache().remove("pgcache_dataChanged");
                    this.getView().close();
                    newFv.activate();
                    this.getView().sendFormAction(newFv);
                } else {
                    fsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
                    fsp.setPageId(newPageId);
                    StringBuilder sbErrorInfo = new StringBuilder();
                    if (fsp.getStatus().equals((Object)OperationStatus.EDIT)) {
                        MutexHelper.release((String)"perm_role", (String)"donothing_roleassignorguser", (String)oldRoleId);
                    }
                    if (MutexHelper.require((IFormView)this.getView(), (String)"perm_role", (Object)newRoleId, (String)"donothing_roleassignorguser", (boolean)true, (StringBuilder)sbErrorInfo)) {
                        this.getView().setStatus(OperationStatus.EDIT);
                    } else {
                        this.getView().setStatus(OperationStatus.VIEW);
                        this.getView().showMessage(sbErrorInfo.toString());
                    }
                    this.init();
                }
            } else if (oldValue != null) {
                this.getModel().setValue("role", oldValue);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof EntryGrid) {
            EntryGrid eg = (EntryGrid)source;
            String key = eg.getKey();
            if (key.contains("right")) {
                return;
            }
            this.getModel().deleteEntryData((String)this.getCurControl("right_entrygridkey"));
            int[] rows = eg.getSelectRows();
            int length = rows.length;
            if (PermCommonUtil.isEnableValidateTime()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{this.PROP_STARTTIME, "dim_starttime", this.PROP_ENDTIME, "dim_endtime"});
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritem_right_dim_delete", this.BARITEM_RIGHT_PROP_DELETE});
            Tab tab = (Tab)this.getCurControl("dimtab");
            boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
            if (0 == length) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude"});
            } else if (1 == length) {
                int row = rows[0];
                DynamicObject selLeftObj = (DynamicObject)this.getModel().getValue((String)this.getCurControl("left_entrydatakey"), row);
                if (selLeftObj == null) {
                    return;
                }
                if (!isLeftDim) {
                    DynamicObject role = (DynamicObject)this.getModel().getValue("role");
                    if (role == null) {
                        return;
                    }
                    String roleId = role.getString("id");
                    this.initDimTab(roleId, selLeftObj.getLong("id"));
                } else {
                    this.loadRightEntryData(selLeftObj.getLong("id"));
                    String curCtrlType = tab.getCurrentTab();
                    boolean isOrgDim = "bos_org".equals(curCtrlType);
                    this.getView().setVisible(Boolean.valueOf(isOrgDim), new String[]{this.PROP_INCLUDESUBORG, "dim_includesuborg", this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude"});
                }
            } else if (length > 1) {
                if (!isLeftDim) {
                    DynamicObject role = (DynamicObject)this.getModel().getValue("role");
                    if (role == null) {
                        return;
                    }
                    String roleId = role.getString("id");
                    this.initDimTab(roleId, null);
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.PROP_INCLUDESUBORG, "dim_includesuborg", this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude", "baritem_right_dim_delete", this.BARITEM_RIGHT_PROP_DELETE, this.PROP_STARTTIME, "dim_starttime", this.PROP_ENDTIME, "dim_endtime"});
            }
            boolean isSingleOrg = PermFormCommonUtil.isSingleOrg("bos_org");
            if (isSingleOrg) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.PROP_INCLUDESUBORG, this.PROP_ALL_INCLUDE, this.PROP_ALL_NOTINCLUDE});
            }
        }
    }

    private void loadRightEntryData(Long leftEntryDataId) {
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        String curDimType = (String)this.getModel().getValue("dimtype");
        DynamicObject role = (DynamicObject)this.getModel().getValue("role");
        if (role == null) {
            return;
        }
        String roleId = role.getString("id");
        Date defaultEndTime = DateUtil.toDate((String)"2999-12-31 23:59:59", (String)"yyyy-MM-dd HH:mm:ss");
        Set<String> batchAddDataSet = this.getAndRemoveBatchAddDataByLeftEntryId(Collections.singletonList(leftEntryDataId), true);
        List<DimUserEdit> dimUserEdits = this.getLoadedAndModifiedDataByLeftId(leftEntryDataId);
        if (dimUserEdits.isEmpty()) {
            this.addDimUserEdit(roleId, isLeftDim, curDimType, dimUserEdits, batchAddDataSet, leftEntryDataId);
        } else {
            this.setUpdateDataStatus(isLeftDim, dimUserEdits, batchAddDataSet, defaultEndTime);
        }
        this.setInsertDataStatus(isLeftDim, curDimType, dimUserEdits, batchAddDataSet, leftEntryDataId, defaultEndTime);
        this.recordLoadedAndModifiedDataToCache(leftEntryDataId, dimUserEdits);
        if (dimUserEdits.isEmpty()) {
            return;
        }
        this.getModel().beginInit();
        if (isLeftDim) {
            this.loadRightEntryDataLeftDim(curDimType, dimUserEdits);
        } else {
            this.loadRightEntryDataRightDim(curDimType, dimUserEdits);
        }
    }

    private void addDimUserEdit(String roleId, boolean isLeftDim, String curDimType, List<DimUserEdit> dimUserEdits, Set<String> batchAddDataSet, Long leftEntryDataId) {
        String delDimIds = this.getPageCache().get("pgcache_notLoadedButDel_LeftIds");
        boolean needToSearchDb = true;
        if (StringUtils.isNotEmpty((String)delDimIds)) {
            String key;
            List delLeftIdsList = (List)SerializationUtils.fromJsonString((String)delDimIds, List.class);
            String string = key = isLeftDim ? curDimType + "$" + leftEntryDataId : "user$" + leftEntryDataId;
            if (delLeftIdsList.contains(key)) {
                needToSearchDb = false;
                this.recordLoadedAndModifiedDataToCache(leftEntryDataId, dimUserEdits);
            }
        }
        List permUserRoleList = null;
        if (needToSearchDb) {
            if (isLeftDim) {
                ArrayList<Long> entryDataIdList = new ArrayList<Long>(1);
                entryDataIdList.add(leftEntryDataId);
                Map dimUserMapByRoleAndDim = OrgUserHelper.getOrgUserMapByRoleAndDim((String)roleId, entryDataIdList, (String)curDimType);
                permUserRoleList = (List)dimUserMapByRoleAndDim.get(leftEntryDataId);
            } else {
                StringBuilder sql = new StringBuilder("select a.fdimtype, a.fisincludesuborg, a.forgid, a.fstarttime, a.fendtime ");
                sql.append(" from t_perm_userrole a");
                sql.append(" where a.froleid = ? and a.fuserid = ? ");
                sql.append(" order by a.forgid asc ");
                Object[] params = new Object[]{roleId, leftEntryDataId};
                permUserRoleList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, rs -> {
                    ArrayList<PermUserRole> result = new ArrayList<PermUserRole>(10);
                    while (rs.next()) {
                        PermUserRole permUserRole = new PermUserRole();
                        permUserRole.setFroleid(roleId);
                        permUserRole.setFdimtype(rs.getString("fdimtype"));
                        permUserRole.setFisincludesuborg(rs.getString("fisincludesuborg"));
                        permUserRole.setFuserid(leftEntryDataId);
                        permUserRole.setForgid(Long.valueOf(rs.getLong("forgid")));
                        permUserRole.setFstarttime((Date)rs.getDate("fstarttime"));
                        permUserRole.setFendtime((Date)rs.getDate("fendtime"));
                        result.add(permUserRole);
                    }
                    return result;
                });
            }
        }
        if ((permUserRoleList == null || permUserRoleList.isEmpty()) && batchAddDataSet.isEmpty()) {
            this.recordLoadedAndModifiedDataToCache(leftEntryDataId, dimUserEdits);
            return;
        }
        this.addDimUserEdit(permUserRoleList, isLeftDim, curDimType, dimUserEdits, batchAddDataSet);
    }

    private void addDimUserEdit(List<PermUserRole> permUserRoleList, boolean isLeftDim, String curDimType, List<DimUserEdit> dimUserEdits, Set<String> batchAddDataSet) {
        if (permUserRoleList == null) {
            return;
        }
        for (PermUserRole permUserRole : permUserRoleList) {
            DimUserEdit dimUserEdit = new DimUserEdit();
            Long dimId = permUserRole.getForgid();
            dimUserEdit.setDimId(dimId);
            Long userId = permUserRole.getFuserid();
            dimUserEdit.setUserId(userId);
            dimUserEdit.setIncludeSub(Boolean.valueOf("1".equals(permUserRole.getFisincludesuborg())));
            dimUserEdit.setStartTime(permUserRole.getFstarttime());
            dimUserEdit.setEndTime(permUserRole.getFendtime());
            dimUserEdit.setDataStatus(DimUserEdit.DataStatus.NONE);
            dimUserEdit.setDimType(permUserRole.getFdimtype());
            dimUserEdits.add(dimUserEdit);
            if (isLeftDim) {
                batchAddDataSet.remove("user$" + userId);
                continue;
            }
            batchAddDataSet.remove(curDimType + "$" + dimId);
        }
    }

    private void setUpdateDataStatus(boolean isLeftDim, List<DimUserEdit> dimUserEdits, Set<String> batchAddDataSet, Date defaultEndTime) {
        if (batchAddDataSet.isEmpty()) {
            return;
        }
        for (DimUserEdit dimUserEdit : dimUserEdits) {
            String loadedData;
            DimUserEdit.DataStatus dataStatus = dimUserEdit.getDataStatus();
            if (isLeftDim) {
                Long userId = dimUserEdit.getUserId();
                loadedData = "user$" + userId;
            } else {
                String dimType = dimUserEdit.getDimType();
                Long dimId = dimUserEdit.getDimId();
                loadedData = dimType + "$" + dimId;
            }
            if (!batchAddDataSet.remove(loadedData) || !DimUserEdit.DataStatus.DELETE.equals((Object)dataStatus)) continue;
            dimUserEdit.setDataStatus(DimUserEdit.DataStatus.UPDATE);
            dimUserEdit.setIncludeSub(Boolean.valueOf(false));
            dimUserEdit.setStartTime(null);
            dimUserEdit.setEndTime(defaultEndTime);
        }
    }

    private void setInsertDataStatus(boolean isLeftDim, String curDimType, List<DimUserEdit> dimUserEdits, Set<String> batchAddDataSet, Long leftEntryDataId, Date defaultEndTime) {
        for (String addData : batchAddDataSet) {
            DimUserEdit dimUserEdit = new DimUserEdit();
            String[] split = addData.split("\\$");
            if (isLeftDim) {
                dimUserEdit.setDimId(leftEntryDataId);
                dimUserEdit.setUserId(Long.valueOf(split[1]));
                dimUserEdit.setDimType(curDimType);
            } else {
                dimUserEdit.setDimId(Long.valueOf(split[1]));
                dimUserEdit.setUserId(leftEntryDataId);
                dimUserEdit.setDimType(split[0]);
            }
            dimUserEdit.setDataStatus(DimUserEdit.DataStatus.INSERT);
            dimUserEdit.setEndTime(defaultEndTime);
            dimUserEdits.add(dimUserEdit);
        }
    }

    private void loadRightEntryDataLeftDim(String curDimType, List<DimUserEdit> dimUserEdits) {
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        HashSet<Long> tempSet = new HashSet<Long>(dimUserEdits.size());
        vs.addField(this.RIGHT_PROP, new Object[0]);
        vs.addField(this.PROP_INCLUDESUBORG, new Object[0]);
        if (enableValidateTime) {
            vs.addField(this.PROP_STARTTIME, new Object[0]);
            vs.addField(this.PROP_ENDTIME, new Object[0]);
        }
        List<Long> chargeList = this.getAdminChargeUser();
        boolean enableJustShowAdminCharged = PermCommonUtil.isEnableJustShowAdminCharged();
        for (DimUserEdit dimUserEdit : dimUserEdits) {
            Long userId;
            DimUserEdit.DataStatus dataStatus = dimUserEdit.getDataStatus();
            String dimType = dimUserEdit.getDimType();
            if (dataStatus.equals((Object)DimUserEdit.DataStatus.DELETE) || !dimType.equals(curDimType) || !tempSet.add(userId = dimUserEdit.getUserId()) || enableJustShowAdminCharged && chargeList != null && !chargeList.contains(userId)) continue;
            Boolean includeSub = dimUserEdit.getIncludeSub();
            if (enableValidateTime) {
                Date startTime = dimUserEdit.getStartTime();
                Date endTime = dimUserEdit.getEndTime();
                vs.addRow(new Object[]{userId, includeSub, startTime, endTime});
                continue;
            }
            vs.addRow(new Object[]{userId, includeSub});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(this.RIGHT_PROP_ENTRY, vs);
        this.getModel().endInit();
        this.getView().updateView(this.RIGHT_PROP_ENTRY);
    }

    private void loadRightEntryDataRightDim(String curDimType, List<DimUserEdit> dimUserEdits) {
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        HashSet<Long> tempSet = new HashSet<Long>(dimUserEdits.size());
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("right_dimtype", new Object[0]);
        vs.addField("right_dimnum", new Object[0]);
        vs.addField("right_dimname", new Object[0]);
        vs.addField("dim_includesuborg", new Object[0]);
        if (enableValidateTime) {
            vs.addField("dim_starttime", new Object[0]);
            vs.addField("dim_endtime", new Object[0]);
        }
        List<Long> chargeList = this.getAdminChargeOrgAndBizUnit(curDimType);
        for (DimUserEdit dimUserEdit : dimUserEdits) {
            Long dimId;
            DimUserEdit.DataStatus dataStatus = dimUserEdit.getDataStatus();
            String dimType = dimUserEdit.getDimType();
            if (dataStatus.equals((Object)DimUserEdit.DataStatus.DELETE) || !dimType.equals(curDimType) || !tempSet.add(dimId = dimUserEdit.getDimId()) || chargeList != null && !chargeList.contains(dimId)) continue;
            ArrayList<Long> dimIdList = new ArrayList<Long>(1);
            dimIdList.add(dimId);
            Map dimMap = IsoDimHelper.getDimMap(dimIdList, (String)curDimType);
            Dim dim = (Dim)dimMap.get(dimId);
            if (dim == null) continue;
            Boolean includeSub = dimUserEdit.getIncludeSub();
            if (enableValidateTime) {
                Date startTime = dimUserEdit.getStartTime();
                Date endTime = dimUserEdit.getEndTime();
                vs.addRow(new Object[]{curDimType, dimId, dim.getDimName(), includeSub, startTime, endTime});
                continue;
            }
            vs.addRow(new Object[]{curDimType, dimId, dim.getDimName(), includeSub});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("right_dim_entry", vs);
        this.getModel().endInit();
        this.getView().updateView("right_dim_entry");
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        Set<String> curData;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ((this.BARITEM_LEFT_PROP_ADD.equals(itemKey) || this.BARITEM_RIGHT_PROP_ADD.equals(itemKey)) && (curData = this.validateOrGetCurData()) != null) {
            HashSet<Long> rowLongIdSet = new HashSet<Long>(curData.size());
            for (String rowId : curData) {
                rowLongIdSet.add(Long.parseLong(rowId));
            }
            ListShowParameter lsp = PermFormCommonUtil.getUserF7ListShowParameter(this.getPageCache(), rowLongIdSet);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_ADDUSER));
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("baritem_left_dim_delete".equals(itemKey) || this.BARITEM_RIGHT_PROP_ADD.equals(itemKey) || "baritem_right_dim_delete".equals(itemKey) || this.BARITEM_RIGHT_PROP_DELETE.equals(itemKey) || itemKey.contains("all_include") || itemKey.contains("all_notinclude")) {
            super.beforeItemClick(evt);
            if (evt.isCancel()) {
                return;
            }
        }
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        String opName = null;
        if (this.BARITEM_RIGHT_PROP_DELETE.equals(itemKey) || "baritem_left_user_delete".equals(itemKey)) {
            opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"RoleAssignUserMultiPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        } else if ("baritem_right_dim_add".equals(itemKey) || "baritem_right_dim_delete".equals(itemKey)) {
            String curDimType = (String)this.getModel().getValue("dimtype");
            String ctrlTypeName = IsoDimHelper.getCtrlTypeName((String)curDimType);
            opName = "baritem_right_dim_add".equals(itemKey) ? ResManager.loadKDString((String)"\u6dfb\u52a0%s", (String)"RoleAssignUserMultiPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[]{ctrlTypeName}) : ResManager.loadKDString((String)"\u5220\u9664%s", (String)"RoleAssignUserMultiPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[]{ctrlTypeName});
        } else if (!isLeftDim) {
            if (itemKey.contains("all_include")) {
                opName = ResManager.loadKDString((String)"\u8bbe\u7f6e\u5168\u5206\u914d", (String)"RoleAssignUserMultiPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[]{this.propName});
            } else if (itemKey.contains("all_notinclude")) {
                opName = ResManager.loadKDString((String)"\u8bbe\u7f6e\u5168\u4e0d\u5206\u914d", (String)"RoleAssignUserMultiPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[]{this.propName});
            }
        }
        if (opName == null) {
            return;
        }
        evt.setCancel(this.checkAdminChargeAndHint(opName, false));
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (CLOSECALLBACK_ADDUSER.equals(actionId) || "closeCallBack_addDim".equals(actionId)) {
            if (!(returnData instanceof ListSelectedRowCollection)) {
                return;
            }
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)returnData;
            int size = lsrc.size();
            LinkedHashSet<String> selIdSet = new LinkedHashSet<String>(size);
            for (ListSelectedRow listSelectedRow : lsrc) {
                Object pkValue = listSelectedRow.getPrimaryKeyValue();
                selIdSet.add(pkValue + "");
            }
            this.getPageCache().put("pgcache_dataChanged", "true");
            if (CLOSECALLBACK_ADDUSER.equals(actionId)) {
                this.addPropsToView(selIdSet);
            } else {
                this.addDimsToView(selIdSet);
            }
        } else if (Objects.equals(actionId, "taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    @Override
    protected String getJobName() {
        return ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u5206\u914d\u7528\u6237", (String)"RoleAssignUserMultiPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected LocaleString getJobNameLocaleString() {
        return ResManager.getLocaleString((String)"\u901a\u7528\u89d2\u8272\u5206\u914d\u7528\u6237", (String)"RoleAssignUserMultiPlugin_7", (String)"bos-permission-formplugin");
    }

    @Override
    protected Map<String, Object> getTaskParameters() {
        DynamicObject role = (DynamicObject)this.getModel().getValue("role");
        if (role == null) {
            return null;
        }
        Map<String, Object> params = super.getTaskParameters();
        String roleId = (String)role.getPkValue();
        String roleNumber = role.getString("number");
        String roleName = role.getString("name");
        params.put("roleId", roleId);
        params.put("roleNumber", roleNumber);
        params.put("roleName", roleName);
        return params;
    }

    @Override
    protected String getTaskClassName() {
        return "kd.bos.permission.formplugin.task.RoleAssignUserMultiTask";
    }

    @Override
    protected void addSavePermLog() {
        String opName = this.getJobName();
        IDataModel dataModel = this.getModel();
        DynamicObject role = (DynamicObject)dataModel.getValue("role");
        String roleId = (String)role.getPkValue();
        String roleName = role.getString("name");
        String roleNum = role.getString("number");
        String formNum = dataModel.getDataEntityType().getName();
        String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u901a\u7528\u89d2\u8272\u5206\u914d\u7528\u6237", "RoleAssignUserMultiPlugin_7", "bos-permission-formplugin");
        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5bf9\u901a\u7528\u89d2\u8272\uff1a%1$s (id = %2$s) %3$s\uff0c\u64cd\u4f5c\u6210\u529f\u3002", "RoleAssignUserMultiPlugin_10", "bos-permission-formplugin");
        String[] opDescParam = new String[]{roleName, roleId, opName};
        String oldOpDescription = String.format(ResManager.loadKDString((String)"\u5bf9\u901a\u7528\u89d2\u8272\uff1a%1$s (id = %2$s) %3$s\uff0c\u64cd\u4f5c\u6210\u529f\u3002", (String)"RoleAssignUserMultiPlugin_10", (String)"bos-permission-formplugin", (Object[])new Object[0]), roleName, roleId, opName);
        PermCommonUtil.addLog(null, null, (String)formNum, (String)roleNum, (String)"1", (String)"save", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)appId);
    }
}

