/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.role;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.model.UgRoleDim;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.plugin.MultiDimAssignPermPlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.model.perm.DimUserEdit;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class RoleAssignUsrGrpMultiPlugin
extends MultiDimAssignPermPlugin
implements TabSelectListener,
RowClickEventListener,
ItemClickListener {
    protected static final String CLOSECALLBACK_ADDUSRGRP = "closeCallBack_addUsrGrp";

    public void initialize() {
        this.initVariable("usrgrp");
        this.addListener();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String roleId = (String)formShowParameter.getCustomParam("roleId");
        if (!StringUtils.isEmpty((String)roleId)) {
            this.getModel().setValue("role", (Object)roleId);
            this.getView().updateView("role");
            this.getView().updateView("rolename");
            this.init();
        }
    }

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String curDimType;
        if ("true".equals(this.getPageCache().get("pgcache_skip"))) {
            this.getPageCache().remove("pgcache_skip");
            return;
        }
        Tab tab = (Tab)this.getCurControl("dimtab");
        String curCtrlType = tab.getCurrentTab();
        if (curCtrlType.equals(curDimType = (String)this.getModel().getValue("dimtype"))) {
            return;
        }
        super.tabSelected(tabSelectEvent);
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        if (isLeftDim) {
            this.loadLeftEntryData();
        } else {
            this.getModel().deleteEntryData("right_dim_entry");
            EntryGrid eg = (EntryGrid)this.getControl(this.LEFT_PROP_ENTRY);
            int[] selectRows = eg.getSelectRows();
            if (selectRows.length == 1) {
                int row = selectRows[0];
                DynamicObject usrGrpObj = (DynamicObject)this.getModel().getValue(this.LEFT_PROP, row);
                long usrGrpId = usrGrpObj.getLong("id");
                this.loadRightEntryData(usrGrpId);
                this.getView().setVisible(Boolean.valueOf("bos_org".equals(curCtrlType)), new String[]{this.PROP_INCLUDESUBORG, "dim_includesuborg", this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude"});
            }
        }
    }

    private void loadLeftEntryData() {
        Tab tab = (Tab)this.getCurControl("dimtab");
        String curCtrlType = tab.getCurrentTab();
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        IDataModel dataModel = this.getModel();
        if (isLeftDim) {
            dataModel.deleteEntryData("left_dim_entry");
            dataModel.deleteEntryData(this.RIGHT_PROP_ENTRY);
            List<String> roleAssignDims = this.getLeftEntryDataIds("usrgrp", curCtrlType);
            boolean singleOrg = PermFormCommonUtil.isSingleOrg(curCtrlType);
            if (singleOrg && CollectionUtils.isEmpty(roleAssignDims)) {
                this.handleIfIsSingleOrg(dataModel, curCtrlType);
                return;
            }
            List<Long> dimIdList = roleAssignDims.stream().map(Long::valueOf).collect(Collectors.toList());
            this.removeUnChargeOrg(curCtrlType, dimIdList);
            Map dimMap = IsoDimHelper.getDimDynMapByDs(dimIdList, (String)curCtrlType);
            dataModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("left_dimtype", new Object[0]);
            vs.addField("left_dimnum", new Object[0]);
            vs.addField("left_dimname", new Object[0]);
            LinkedHashSet<Long> dimIdSet = new LinkedHashSet<Long>(dimIdList);
            for (Long dimId : dimIdSet) {
                DynamicObject dimObj = (DynamicObject)dimMap.get(dimId);
                if (null == dimObj) continue;
                vs.addRow(new Object[]{curCtrlType, dimId, dimObj.getString("name")});
            }
            ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("left_dim_entry", vs);
            dataModel.endInit();
            this.getView().updateView("left_dim_entry");
            this.selFirstRowInLeftEg();
        } else {
            dataModel.deleteEntryData(this.LEFT_PROP_ENTRY);
            dataModel.deleteEntryData("right_dim_entry");
            List<String> roleAssignUsrGrps = this.getLeftEntryDataIds("usrgrp", null);
            Set roleAssignUsrGrpsSet = roleAssignUsrGrps.stream().map(Long::valueOf).collect(Collectors.toSet());
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bos_usrgrp", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", roleAssignUsrGrpsSet)});
            dataModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(this.LEFT_PROP, new Object[0]);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                long usrGrpId = dynamicObject.getLong("id");
                vs.addRow(new Object[]{usrGrpId});
            }
            ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow(this.LEFT_PROP_ENTRY, vs);
            dataModel.endInit();
            this.getView().updateView(this.LEFT_PROP_ENTRY);
            EntryGrid leftEg = (EntryGrid)this.getCurControl("left_entrygrid");
            int entryCount = this.getModel().getEntryRowCount((String)this.getCurControl("left_entrygridkey"));
            if (entryCount > 0) {
                leftEg.selectRows(0);
                leftEg.entryRowClick(Integer.valueOf(0));
            } else {
                DynamicObject role = (DynamicObject)this.getModel().getValue("role");
                if (role == null) {
                    return;
                }
                String roleId = role.getString("id");
                this.getPageCache().put("pgcache_skip", "true");
                this.initDimTab(roleId, null);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        DynamicObject role = (DynamicObject)this.getModel().getValue("role");
        if (role == null) {
            return;
        }
        String roleId = role.getString("id");
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        if (isLeftDim) {
            this.initDimTab(roleId, null);
        } else {
            this.loadLeftEntryData();
        }
    }

    private void initDimTab(String roleId, Long usrGrpId) {
        List dimTypes;
        Tab tab = (Tab)this.getCurControl("dimtab");
        this.getModel().setValue("dimtype", null);
        this.delAllDimTabKeys();
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        String usrGrpHasDimTabKeys = this.getPageCache().get(this.PGCACHE_PROPHASDIMTABKEYS + "_" + usrGrpId);
        if (!isLeftDim && StringUtils.isNotEmpty((String)usrGrpHasDimTabKeys)) {
            dimTypes = (List)SerializationUtils.fromJsonString((String)usrGrpHasDimTabKeys, List.class);
        } else {
            StringBuilder sql = new StringBuilder("select distinct ugr.fdimtype from t_perm_usrgrprole ugr join t_perm_ctrltype ct on (ugr.fdimtype = ct.fbizobjectid and ct.fsystreefilter = '1') ");
            sql.append(" where ugr.froleid = ? ");
            Object[] params = new Object[]{roleId};
            if (usrGrpId != null) {
                sql.append(" and ugr.fusrgrpid = ? ");
                params = new Object[]{roleId, usrGrpId};
            }
            if ((dimTypes = (List)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params, rs -> {
                ArrayList<String> result = new ArrayList<String>(10);
                while (rs.next()) {
                    result.add(rs.getString("fdimtype"));
                }
                return result;
            })).isEmpty()) {
                HashSet roleIdSet = new HashSet(1);
                roleIdSet.add(roleId);
                Map map = PermRoleHelper.getRoleDimTypeSetMap((Set)roleIdSet, (boolean)false, (boolean)true);
                Set dimTypeSet = (Set)map.get(roleId);
                if (dimTypeSet != null && !dimTypeSet.isEmpty()) {
                    Map curValidEntPermCtrlTypeMap = IsoDimHelper.getEntPermCtrlTypeMap((PermCtrlTypeReq)new PermCtrlTypeReq((Set)Sets.newHashSet((Object[])new String[]{"1"}), null, null, null, null));
                    Set sysTreeFilterDimTypes = curValidEntPermCtrlTypeMap.keySet();
                    for (String dimType : dimTypeSet) {
                        if ("bos_objecttype".equals(dimType) || !sysTreeFilterDimTypes.contains(dimType)) continue;
                        dimTypes.add(dimType);
                    }
                } else {
                    dimTypes.add("bos_org");
                }
            }
        }
        if (!isLeftDim) {
            String jsonMap = this.getPageCache().get("pgcache_batchAddDataMap");
            if (!StringUtils.isEmpty((String)jsonMap)) {
                Map batchAddDataMap = (Map)SerializationUtils.fromJsonString((String)jsonMap, Map.class);
                for (Map.Entry entry : batchAddDataMap.entrySet()) {
                    String key = (String)entry.getKey();
                    List usrGrpBatchAddData = (List)entry.getValue();
                    if (!key.contains("usrgrp") || !key.contains(usrGrpId + "") || usrGrpBatchAddData == null) continue;
                    for (String batchAddData : usrGrpBatchAddData) {
                        String batchAddDimType = batchAddData.split("\\$")[0];
                        if (dimTypes.contains(batchAddDimType)) continue;
                        dimTypes.add(batchAddDimType);
                    }
                }
            }
            String pgCacheKey = this.PGCACHE_PROPHASDIMTABKEYS + "_" + usrGrpId;
            this.getPageCache().put(pgCacheKey, SerializationUtils.toJsonString((Object)dimTypes));
            this.recordKeysWillBeDeleted(pgCacheKey);
        }
        ArrayList<String> allTabKeys = new ArrayList<String>(10);
        ArrayList<Map> items = new ArrayList<Map>(10);
        if (dimTypes.isEmpty()) {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey("bos_org");
            tabPageAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"RoleAssignUsrGrpMultiPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0])));
            items.add(tabPageAp.createControl());
            allTabKeys.add("bos_org");
        } else {
            DynamicObjectCollection dimObjCol = QueryServiceHelper.query((String)"perm_ctrltype", (String)"bizobjectid,name", (QFilter[])new QFilter[]{new QFilter("bizobjectid", "in", (Object)dimTypes)});
            for (DynamicObject dimObj : dimObjCol) {
                String number = dimObj.getString("bizobjectid");
                String name = dimObj.getString("name");
                TabPageAp tabPageAp = new TabPageAp();
                tabPageAp.setKey(number);
                tabPageAp.setName(new LocaleString(name));
                items.add(tabPageAp.createControl());
                allTabKeys.add(number);
            }
        }
        tab.addControls(items);
        this.getPageCache().put("pgcache_dimtabkeys", JSON.toJSONString(allTabKeys));
        int size = allTabKeys.size();
        if (size > 0) {
            String string = (String)allTabKeys.get(0);
            tab.selectTab(string);
            tab.activeTab(string);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("role".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (newValue != null) {
                String newRoleId = ((DynamicObject)newValue).getString("id");
                FormShowParameter fsp = this.getView().getFormShowParameter();
                String pageId = this.getView().getPageId();
                CharSequence[] pageIdSplit = pageId.split("-");
                String oldRoleId = pageIdSplit[0];
                pageIdSplit[0] = newRoleId;
                String newPageId = String.join((CharSequence)"-", pageIdSplit);
                IFormView newFv = this.getView().getViewNoPlugin(newPageId);
                if (newFv != null) {
                    this.getPageCache().remove("pgcache_dataChanged");
                    this.getView().close();
                    newFv.activate();
                    this.getView().sendFormAction(newFv);
                } else {
                    fsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
                    fsp.setPageId(newPageId);
                    StringBuilder sbErrorInfo = new StringBuilder();
                    if (fsp.getStatus().equals((Object)OperationStatus.EDIT)) {
                        MutexHelper.release((String)"perm_role", (String)"donothing_roleassignorgusrgrp", (String)oldRoleId);
                    }
                    if (MutexHelper.require((IFormView)this.getView(), (String)"perm_role", (Object)newRoleId, (String)"donothing_roleassignorgusrgrp", (boolean)true, (StringBuilder)sbErrorInfo)) {
                        this.getView().setStatus(OperationStatus.EDIT);
                    } else {
                        this.getView().setStatus(OperationStatus.VIEW);
                        this.getView().showMessage(sbErrorInfo.toString());
                    }
                    this.init();
                }
            } else if (oldValue != null) {
                this.getModel().setValue("role", oldValue);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof EntryGrid) {
            EntryGrid eg = (EntryGrid)source;
            String key = eg.getKey();
            if (key.contains("right")) {
                return;
            }
            this.getModel().deleteEntryData((String)this.getCurControl("right_entrygridkey"));
            int[] rows = eg.getSelectRows();
            int length = rows.length;
            if (PermCommonUtil.isEnableValidateTime()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{this.PROP_STARTTIME, "dim_starttime", this.PROP_ENDTIME, "dim_endtime"});
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritem_right_dim_delete", this.BARITEM_RIGHT_PROP_DELETE});
            Tab tab = (Tab)this.getCurControl("dimtab");
            boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
            if (0 == length) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude"});
            } else if (1 == length) {
                int row = rows[0];
                DynamicObject selLeftObj = (DynamicObject)this.getModel().getValue((String)this.getCurControl("left_entrydatakey"), row);
                if (selLeftObj == null) {
                    return;
                }
                if (!isLeftDim) {
                    DynamicObject role = (DynamicObject)this.getModel().getValue("role");
                    if (role == null) {
                        return;
                    }
                    String roleId = role.getString("id");
                    this.initDimTab(roleId, selLeftObj.getLong("id"));
                } else {
                    this.loadRightEntryData(selLeftObj.getLong("id"));
                    String curCtrlType = tab.getCurrentTab();
                    boolean isOrgDim = "bos_org".equals(curCtrlType);
                    this.getView().setVisible(Boolean.valueOf(isOrgDim), new String[]{this.PROP_INCLUDESUBORG, "dim_includesuborg", this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude"});
                }
            } else if (length > 1) {
                if (!isLeftDim) {
                    DynamicObject role = (DynamicObject)this.getModel().getValue("role");
                    if (role == null) {
                        return;
                    }
                    String roleId = role.getString("id");
                    this.initDimTab(roleId, null);
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.PROP_INCLUDESUBORG, "dim_includesuborg", this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude", "baritem_right_dim_delete", this.BARITEM_RIGHT_PROP_DELETE, this.PROP_STARTTIME, "dim_starttime", this.PROP_ENDTIME, "dim_endtime"});
            }
            boolean isSingleOrg = PermFormCommonUtil.isSingleOrg("bos_org");
            if (isSingleOrg) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.PROP_INCLUDESUBORG, this.PROP_ALL_INCLUDE, this.PROP_ALL_NOTINCLUDE});
            }
        }
    }

    private void loadRightEntryData(Long leftEntryDataId) {
        Long dimId;
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        String curDimType = (String)this.getModel().getValue("dimtype");
        DynamicObject role = (DynamicObject)this.getModel().getValue("role");
        if (role == null) {
            return;
        }
        String roleId = role.getString("id");
        Date defalueEndTime = DateUtil.toDate((String)"2999-12-31 23:59:59", (String)"yyyy-MM-dd HH:mm:ss");
        Set<String> batchAddDataSet = this.getAndRemoveBatchAddDataByLeftEntryId(Collections.singletonList(leftEntryDataId), true);
        List<DimUserEdit> dimUserEdits = this.getLoadedAndModifiedDataByLeftId(leftEntryDataId);
        boolean needToSearchDb = true;
        if (dimUserEdits.isEmpty()) {
            String delDimIds = this.getPageCache().get("pgcache_notLoadedButDel_LeftIds");
            if (StringUtils.isNotEmpty((String)delDimIds)) {
                String key;
                List delLeftIdsList = (List)SerializationUtils.fromJsonString(delDimIds, List.class);
                String string = key = isLeftDim ? curDimType + "$" + leftEntryDataId : "usrgrp$" + leftEntryDataId;
                if (delLeftIdsList.contains(key)) {
                    needToSearchDb = false;
                    this.recordLoadedAndModifiedDataToCache(leftEntryDataId, dimUserEdits);
                }
            }
            List permUsrGrpRoleList = null;
            if (needToSearchDb) {
                if (isLeftDim) {
                    permUsrGrpRoleList = UserGroupHelper.getUsrGrpRoleList(Collections.singleton(roleId), null, null, Collections.singleton(leftEntryDataId), (String)curDimType);
                } else {
                    StringBuilder sql = new StringBuilder("select fdimtype, fincludesub, fdimid, fstarttime, fendtime ");
                    sql.append(" from t_perm_usrgrprole ");
                    sql.append(" where froleid = ? and fusrgrpid = ? ");
                    sql.append(" order by fdimid asc ");
                    Object[] params = new Object[]{roleId, leftEntryDataId};
                    permUsrGrpRoleList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params, rs -> {
                        ArrayList<UgRoleDim> result = new ArrayList<UgRoleDim>(10);
                        while (rs.next()) {
                            UgRoleDim ugRoleDim = new UgRoleDim();
                            ugRoleDim.setRoleId(roleId);
                            ugRoleDim.setDimType(rs.getString("fdimtype"));
                            ugRoleDim.setIncludeSub(rs.getString("fincludesub"));
                            ugRoleDim.setUsrGrpId(leftEntryDataId);
                            ugRoleDim.setDimId(Long.valueOf(rs.getLong("fdimid")));
                            ugRoleDim.setStarttime((Date)rs.getDate("fstarttime"));
                            ugRoleDim.setEndtime((Date)rs.getDate("fendtime"));
                            result.add(ugRoleDim);
                        }
                        return result;
                    });
                }
            }
            if ((permUsrGrpRoleList == null || permUsrGrpRoleList.isEmpty()) && batchAddDataSet.isEmpty()) {
                this.recordLoadedAndModifiedDataToCache(leftEntryDataId, dimUserEdits);
                return;
            }
            if (permUsrGrpRoleList != null) {
                for (UgRoleDim ugRoleDim : permUsrGrpRoleList) {
                    DimUserEdit dimUserEdit = new DimUserEdit();
                    dimId = ugRoleDim.getDimId();
                    dimUserEdit.setDimId(dimId);
                    Long usrGrpId = ugRoleDim.getUsrGrpId();
                    dimUserEdit.setUsrGrpId(usrGrpId);
                    dimUserEdit.setIncludeSub(Boolean.valueOf("1".equals(ugRoleDim.getIncludeSub())));
                    dimUserEdit.setStartTime(ugRoleDim.getStarttime());
                    dimUserEdit.setEndTime(ugRoleDim.getEndtime());
                    dimUserEdit.setDataStatus(DimUserEdit.DataStatus.NONE);
                    dimUserEdit.setDimType(ugRoleDim.getDimType());
                    dimUserEdits.add(dimUserEdit);
                    if (isLeftDim) {
                        batchAddDataSet.remove("usrgrp$" + usrGrpId);
                        continue;
                    }
                    batchAddDataSet.remove(curDimType + "$" + dimId);
                }
            }
        } else if (!batchAddDataSet.isEmpty()) {
            for (DimUserEdit dimUserEdit : dimUserEdits) {
                String loadedData;
                DimUserEdit.DataStatus dataStatus = dimUserEdit.getDataStatus();
                if (isLeftDim) {
                    Long usrGrpId = dimUserEdit.getUsrGrpId();
                    loadedData = "usrgrp$" + usrGrpId;
                } else {
                    String dimType = dimUserEdit.getDimType();
                    dimId = dimUserEdit.getDimId();
                    loadedData = dimType + "$" + dimId;
                }
                if (!batchAddDataSet.remove(loadedData) || !DimUserEdit.DataStatus.DELETE.equals((Object)dataStatus)) continue;
                dimUserEdit.setDataStatus(DimUserEdit.DataStatus.UPDATE);
                dimUserEdit.setIncludeSub(Boolean.valueOf(false));
                dimUserEdit.setStartTime(null);
                dimUserEdit.setEndTime(defalueEndTime);
            }
        }
        for (String addData : batchAddDataSet) {
            DimUserEdit dimUserEdit = new DimUserEdit();
            String[] split = addData.split("\\$");
            if (isLeftDim) {
                dimUserEdit.setDimId(leftEntryDataId);
                dimUserEdit.setUsrGrpId(Long.valueOf(split[1]));
                dimUserEdit.setDimType(curDimType);
            } else {
                dimUserEdit.setDimId(Long.valueOf(split[1]));
                dimUserEdit.setUsrGrpId(leftEntryDataId);
                dimUserEdit.setDimType(split[0]);
            }
            dimUserEdit.setDataStatus(DimUserEdit.DataStatus.INSERT);
            dimUserEdit.setEndTime(defalueEndTime);
            dimUserEdits.add(dimUserEdit);
        }
        this.recordLoadedAndModifiedDataToCache(leftEntryDataId, dimUserEdits);
        if (dimUserEdits.isEmpty()) {
            return;
        }
        this.getModel().beginInit();
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        LinkedHashSet<Long> tempSet = new LinkedHashSet<Long>(dimUserEdits.size());
        if (isLeftDim) {
            vs.addField(this.RIGHT_PROP, new Object[0]);
            vs.addField(this.PROP_INCLUDESUBORG, new Object[0]);
            if (enableValidateTime) {
                vs.addField(this.PROP_STARTTIME, new Object[0]);
                vs.addField(this.PROP_ENDTIME, new Object[0]);
            }
            for (DimUserEdit dimUserEdit : dimUserEdits) {
                Long usrGrpId;
                DimUserEdit.DataStatus dataStatus = dimUserEdit.getDataStatus();
                String dimType = dimUserEdit.getDimType();
                if (dataStatus.equals((Object)DimUserEdit.DataStatus.DELETE) || !dimType.equals(curDimType) || !tempSet.add(usrGrpId = dimUserEdit.getUsrGrpId())) continue;
                Boolean includeSub = dimUserEdit.getIncludeSub();
                if (enableValidateTime) {
                    Date startTime = dimUserEdit.getStartTime();
                    Date endTime = dimUserEdit.getEndTime();
                    vs.addRow(new Object[]{usrGrpId, includeSub, startTime, endTime});
                    continue;
                }
                vs.addRow(new Object[]{usrGrpId, includeSub});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(this.RIGHT_PROP_ENTRY, vs);
            this.getModel().endInit();
            this.getView().updateView(this.RIGHT_PROP_ENTRY);
        } else {
            vs.addField("right_dimtype", new Object[0]);
            vs.addField("right_dimnum", new Object[0]);
            vs.addField("right_dimname", new Object[0]);
            vs.addField("dim_includesuborg", new Object[0]);
            if (enableValidateTime) {
                vs.addField("dim_starttime", new Object[0]);
                vs.addField("dim_endtime", new Object[0]);
            }
            List<Long> hasPermOrgs = this.getAdminChargeOrgAndBizUnit(curDimType);
            for (DimUserEdit dimUserEdit : dimUserEdits) {
                Long dimId2;
                DimUserEdit.DataStatus dataStatus = dimUserEdit.getDataStatus();
                String dimType = dimUserEdit.getDimType();
                if (dataStatus.equals((Object)DimUserEdit.DataStatus.DELETE) || !dimType.equals(curDimType) || !tempSet.add(dimId2 = dimUserEdit.getDimId()) || hasPermOrgs != null && !hasPermOrgs.contains(dimId2)) continue;
                ArrayList<Long> dimIdList = new ArrayList<Long>(1);
                dimIdList.add(dimId2);
                Map dimMap = IsoDimHelper.getDimMap(dimIdList, (String)curDimType);
                Dim dim = (Dim)dimMap.get(dimId2);
                if (dim == null) continue;
                Boolean includeSub = dimUserEdit.getIncludeSub();
                if (enableValidateTime) {
                    Date startTime = dimUserEdit.getStartTime();
                    Date endTime = dimUserEdit.getEndTime();
                    vs.addRow(new Object[]{curDimType, dimId2, dim.getDimName(), includeSub, startTime, endTime});
                    continue;
                }
                vs.addRow(new Object[]{curDimType, dimId2, dim.getDimName(), includeSub});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("right_dim_entry", vs);
            this.getModel().endInit();
            this.getView().updateView("right_dim_entry");
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        Set<String> curData;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ((this.BARITEM_LEFT_PROP_ADD.equals(itemKey) || this.BARITEM_RIGHT_PROP_ADD.equals(itemKey)) && (curData = this.validateOrGetCurData()) != null) {
            HashSet<Long> rowLongIdSet = new HashSet<Long>(curData.size());
            for (String rowId : curData) {
                rowLongIdSet.add(Long.parseLong(rowId));
            }
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_usrgrp", (boolean)true, (int)0);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_ADDUSRGRP));
            lsp.setFormId("bos_usrgrptreelistf7");
            lsp.setCaption(ResManager.loadKDString((String)"\u7528\u6237\u7ec4", (String)"RoleAssignUsrGrpMultiPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            List qFilters = lsp.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "not in", rowLongIdSet));
            lsp.setListFilterParameter(new ListFilterParameter(qFilters, null));
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (CLOSECALLBACK_ADDUSRGRP.equals(actionId) || "closeCallBack_addDim".equals(actionId)) {
            if (!(returnData instanceof ListSelectedRowCollection)) {
                return;
            }
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)returnData;
            int size = lsrc.size();
            LinkedHashSet<String> selIdSet = new LinkedHashSet<String>(size);
            for (ListSelectedRow listSelectedRow : lsrc) {
                Object pkValue = listSelectedRow.getPrimaryKeyValue();
                selIdSet.add(pkValue + "");
            }
            this.getPageCache().put("pgcache_dataChanged", "true");
            if (CLOSECALLBACK_ADDUSRGRP.equals(actionId)) {
                this.addPropsToView(selIdSet);
            } else {
                this.addDimsToView(selIdSet);
            }
        } else if (Objects.equals(actionId, "taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    @Override
    protected String getJobName() {
        return ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u5206\u914d\u7528\u6237\u7ec4", (String)"RoleAssignUsrGrpMultiPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected LocaleString getJobNameLocaleString() {
        return ResManager.getLocaleString((String)"\u901a\u7528\u89d2\u8272\u5206\u914d\u7528\u6237\u7ec4", (String)"RoleAssignUsrGrpMultiPlugin_3", (String)"bos-permission-formplugin");
    }

    @Override
    protected Map<String, Object> getTaskParameters() {
        DynamicObject role = (DynamicObject)this.getModel().getValue("role");
        if (role == null) {
            return null;
        }
        Map<String, Object> params = super.getTaskParameters();
        String roleId = (String)role.getPkValue();
        String roleNumber = role.getString("number");
        String roleName = role.getString("name");
        params.put("roleId", roleId);
        params.put("roleNumber", roleNumber);
        params.put("roleName", roleName);
        return params;
    }

    @Override
    protected String getTaskClassName() {
        return "kd.bos.permission.formplugin.task.RoleAssignUsrGrpMultiTask";
    }

    @Override
    protected void addSavePermLog() {
        String opName = this.getJobName();
        IDataModel dataModel = this.getModel();
        DynamicObject role = (DynamicObject)dataModel.getValue("role");
        String roleId = (String)role.getPkValue();
        String roleName = role.getString("name");
        String roleNum = role.getString("number");
        String formNum = dataModel.getDataEntityType().getName();
        String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u901a\u7528\u89d2\u8272\u5206\u914d\u7528\u6237\u7ec4", "RoleAssignUsrGrpMultiPlugin_3", "bos-permission-formplugin");
        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5bf9\u901a\u7528\u89d2\u8272\uff1a%1$s (id = %2$s) %3$s\uff0c\u64cd\u4f5c\u6210\u529f\u3002", "RoleAssignUserMultiPlugin_10", "bos-permission-formplugin");
        String[] opDescParam = new String[]{roleName, roleId, opName};
        String oldOpDescription = String.format(ResManager.loadKDString((String)"\u5bf9\u901a\u7528\u89d2\u8272\uff1a%1$s (id = %2$s) %3$s\uff0c\u64cd\u4f5c\u6210\u529f\u3002", (String)"RoleAssignUserMultiPlugin_10", (String)"bos-permission-formplugin", (Object[])new Object[0]), roleName, roleId, opName);
        PermCommonUtil.addLog(null, null, (String)formNum, (String)roleNum, (String)"1", (String)"save", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)appId);
    }
}

