/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.user;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.AdminUserCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.DirectDisFunHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.AssignPermCacheUtil;
import kd.bos.permission.formplugin.util.FuncPermTreeUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.formplugin.validator.CommonValidator;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.service.PermissionServiceImpl;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserAssignDisFunMultiPlugin
extends AbstractFormPlugin
implements CommonValidator,
IBillPlugin,
TreeNodeQueryListener,
TabSelectListener,
RowClickEventListener,
BeforeF7SelectListener,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(UserAssignDisFunMultiPlugin.class);
    private FuncPermTreeUtil funcPermTreeUtil;
    private AssignPermCacheUtil assignPermCacheUtil;
    private static final String VALUE_TRUE = "true";
    private static final String DIMNUM_ID = "dimnum_id";
    private static final String BATCH_ASSIGN = "batchAssign";
    private static final String PGCACHE_LASTENTRYROWCLICK = "lastEntryRowClick";
    private static final String PGCACHE_LASTCLICK_DIMTAB = "lastClickDimTab";
    private static final String PGCACHE_BATCH_ASSIGN = "batchAssignFlag";
    private static final String PGCACHE_DIMTABKEYS = "pgcache_dimtabkeys";
    private static final String PGCACHE_USER_ASSIGN_DISPERM_INFO = "pgcache_user_assign_dimperm_info";

    public void preOpenForm(PreOpenFormEventArgs e) {
        String showFormSpecial = (String)e.getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if (VALUE_TRUE.equals(showFormSpecial)) {
            return;
        }
        String unableShowInfo = (String)e.getFormShowParameter().getCustomParam("formShowParm_show_unableInfo");
        if (StringUtils.isNotEmpty((String)unableShowInfo)) {
            e.setCancel(true);
            e.setCancelMessage(unableShowInfo);
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        if (!PermissionServiceHelper.isAdminUser((long)userId) && !PermFormCommonUtil.isAdminPartnerUser(userId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u4e0d\u662f\u7ba1\u7406\u5458,\u65e0\u6743\u9650\u8fdb\u884c\u6b64\u64cd\u4f5c", (String)"UserAssignDisFunMultiPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
    }

    public void initialize() {
        super.initialize();
        this.funcPermTreeUtil = new FuncPermTreeUtil(this.getPageCache());
        this.assignPermCacheUtil = new AssignPermCacheUtil(this.getPageCache());
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType originalEntityType = e.getOriginalEntityType();
        HashMap<String, String> entryFieldMap = new HashMap<String, String>(8);
        entryFieldMap.put("dim_entry", "entitydimtype");
        MainEntityType newEntityType = PermCommonUtil.getNewEntityType((MainEntityType)originalEntityType, entryFieldMap);
        e.setNewEntityType(newEntityType);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab dimTab = (Tab)this.getControl("dimtab");
        dimTab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"btn_addnode", "btn_delnode", "adddimtab", "deldimtab"});
        this.addItemClickListeners(new String[]{"tbmain", "toolbar_dim"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("dim_entry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        TreeView allFuncPermTv = (TreeView)this.getControl("tree_allfunctionperm");
        allFuncPermTv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        TreeView disFuncPermTv = (TreeView)this.getControl("tree_disfunperm");
        disFuncPermTv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search funcPermSearch = (Search)this.getControl("searchap");
        funcPermSearch.addEnterListener((SearchEnterListener)this);
        Search disFuncPermSearch = (Search)this.getControl("disfunpermsearchap");
        disFuncPermSearch.addEnterListener((SearchEnterListener)this);
        BasedataEdit userEdit = (BasedataEdit)this.getControl("user");
        userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = this.loadUserInfo();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        OperationStatus status = fsp.getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            UserHelper.addEditingPermUserId((List)Lists.newArrayList((Object[])new String[]{userId + ""}));
        }
        this.loadAdminInfo();
        ItemClassTypeEdit selectDimTypeFields = (ItemClassTypeEdit)this.getControl("dimtype");
        PermCommonUtil.buildDimTypeItemClassType((ItemClassTypeEdit)selectDimTypeFields);
        this.initDimTab();
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addnode", "btn_delnode"});
    }

    private void initDimTab() {
        Tab tab = (Tab)this.getControl("dimtab");
        ArrayList<String> allTabKeys = new ArrayList<String>(10);
        Long userId = (Long)this.getModel().getValue("user_id");
        Map userDirectAssignDisDimMap = DirectDisFunHelper.getUserDirectAssignDisPermDim((Long)userId);
        Map curValidEntPermCtrlTypeMap = IsoDimHelper.getEntPermCtrlTypeMap((PermCtrlTypeReq)new PermCtrlTypeReq((Set)Sets.newHashSet((Object[])new String[]{"1"}), null, null, null, null));
        HashMap<String, Map> userDirectAssignDisDim = new HashMap<String, Map>(8);
        for (Map.Entry ori : userDirectAssignDisDimMap.entrySet()) {
            String key = (String)ori.getKey();
            Map value = (Map)ori.getValue();
            if (!curValidEntPermCtrlTypeMap.containsKey(key)) continue;
            userDirectAssignDisDim.put(key, value);
        }
        boolean isSingleOrg = PermCommonUtil.isSingleOrg();
        if (isSingleOrg) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2", "flexpanelap"});
        }
        HashMap<String, String> newDataMap = new HashMap<String, String>(16);
        ArrayList<Map> items = new ArrayList<Map>(10);
        if (userDirectAssignDisDim.isEmpty()) {
            long rootOrgId;
            DynamicObject rootOrg;
            TabPageAp tabPageAp = new TabPageAp();
            DynamicObject orgDimType = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_ctrltype", (String)"id,name,bizobjectid", (QFilter[])new QFilter[]{new QFilter("bizobjectid", "=", (Object)"bos_org")});
            String number = orgDimType.getString("bizobjectid.number");
            String name = orgDimType.getString("name");
            tabPageAp.setKey(number + "|" + name);
            tabPageAp.setName(new LocaleString(name));
            items.add(tabPageAp.createControl());
            allTabKeys.add(number + "|" + name);
            LinkedHashMap<String, String> dimInfo = new LinkedHashMap<String, String>(16);
            if (isSingleOrg && (rootOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)(rootOrgId = OrgUnitServiceHelper.getRootOrgId()), (String)"bos_org", (String)"id,number,name")) != null) {
                String dimNumber = rootOrg.getString("number");
                String dimName = rootOrg.getString("name");
                String dimPermInfo = String.join((CharSequence)",", String.valueOf(rootOrgId), "0", "0");
                dimInfo.put(String.valueOf(rootOrgId), dimPermInfo);
                Set<String> addDimSet = this.assignPermCacheUtil.getAddDimSet();
                Map<String, String> emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap();
                Map<String, String> dimInfoMap = this.assignPermCacheUtil.getDimInfoMap();
                String sourceKey = number + "|" + rootOrgId;
                addDimSet.add(sourceKey);
                emptyDimMap.put(sourceKey, name + "," + dimName);
                dimInfoMap.put(sourceKey, dimNumber + "," + dimName);
                newDataMap.put("addDimSet", SerializationUtils.toJsonString(addDimSet));
                newDataMap.put("emptyDimMap", SerializationUtils.toJsonString(emptyDimMap));
                newDataMap.put("dimInfoMap", SerializationUtils.toJsonString(dimInfoMap));
            }
            userDirectAssignDisDim.put(number, dimInfo);
        } else {
            Set dimKeys = userDirectAssignDisDim.keySet();
            PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq(null, null, null, null, dimKeys);
            List ctrlTypeList = IsoDimHelper.getPermCtrlTypeList((PermCtrlTypeReq)permCtrlTypeReq);
            for (PermCtrlType permCtrlType : ctrlTypeList) {
                String number = permCtrlType.getBizobjectid();
                String name = permCtrlType.getName();
                TabPageAp tabPageAp = new TabPageAp();
                tabPageAp.setKey(number + "|" + name);
                tabPageAp.setName(new LocaleString(name));
                items.add(tabPageAp.createControl());
                allTabKeys.add(number + "|" + name);
            }
        }
        tab.addControls(items);
        newDataMap.put(PGCACHE_DIMTABKEYS, SerializationUtils.toJsonString(allTabKeys));
        newDataMap.put(PGCACHE_USER_ASSIGN_DISPERM_INFO, SerializationUtils.toJsonString(userDirectAssignDisDim));
        this.getPageCache().put(newDataMap);
        int size = allTabKeys.size();
        if (size > 0) {
            String lastClickTab = this.getPageCache().get(PGCACHE_LASTCLICK_DIMTAB);
            if (StringUtils.isEmpty((String)lastClickTab)) {
                lastClickTab = (String)allTabKeys.get(0);
            }
            tab.selectTab(lastClickTab);
            tab.activeTab(lastClickTab);
        }
    }

    private void loadAdminInfo() {
        String showFormSpecial = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if (!VALUE_TRUE.equals(showFormSpecial)) {
            Map adminSysPerm;
            boolean enableSysAuthority;
            Long adminUserId = RequestContext.get().getCurrUserId();
            List adminChargeApps = PermissionServiceHelper.getAdminChargeApps((Long)adminUserId);
            if (adminChargeApps != null && !adminChargeApps.isEmpty()) {
                this.getPageCache().put("pageCache_adminChargeApp", SerializationUtils.toJsonString((Object)adminChargeApps));
            }
            if ((enableSysAuthority = PermCommonUtil.isEnableSysAuthority()) && !CollectionUtils.isEmpty((Map)(adminSysPerm = AdminPermCache.getAdminSysPerm((Long)adminUserId)))) {
                this.getPageCache().putBigObject("pageCache_adminSysPerm", SerializationUtils.toJsonString((Object)adminSysPerm));
            }
        }
    }

    private long loadUserInfo() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        long userId = 0L;
        String strUserId = (String)fsp.getCustomParam("paramUserId");
        if (StringUtils.isEmpty((String)strUserId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6388\u6743\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u9009\u62e9\u9700\u8981\u6388\u6743\u7684\u7528\u6237\u3002", (String)"UserAssignDisFunMultiPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put("paramUserId", strUserId);
            userId = Long.parseLong(strUserId);
        }
        this.getModel().setValue("user", (Object)userId);
        String showForSpecialUser = (String)fsp.getCustomParam("FormShowParam_ShowForSpecialUser");
        if (VALUE_TRUE.equals(showForSpecialUser)) {
            this.getPageCache().put("FormShowParam_ShowForSpecialUser", VALUE_TRUE);
        }
        return userId;
    }

    public void tabSelected(TabSelectEvent e) {
        String tabKey = e.getTabKey();
        this.dimTabSelected(tabKey);
    }

    private void dimTabSelected(String tabKey) {
        this.getPageCache().put(PGCACHE_LASTCLICK_DIMTAB, tabKey);
        String[] tabInfo = tabKey.split("\\|");
        String curDimType = tabInfo[0];
        String oldDimType = (String)this.getModel().getValue("dimtype");
        this.getModel().setValue("dimtype", (Object)curDimType);
        if (!"bos_org".equals(curDimType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"includesuborg"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"includesuborg"});
        }
        this.loadDimEntryData(oldDimType, curDimType);
        this.clickFirstRow();
    }

    private void clickFirstRow() {
        EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
        int entryCount = this.getModel().getEntryRowCount("dim_entry");
        if (entryCount > 0) {
            eg.selectRows(0);
            eg.getEntryState().selectRow(0);
            eg.getEntryState().setFocusRow(0);
            eg.entryRowClick(Integer.valueOf(0));
        }
    }

    private void loadDimEntryData(String oldDimType, String curDimType) {
        this.clearCacheAfterChangeDimTab(oldDimType);
        this.clearTreeView();
        this.clearAllSearchMode();
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("dim_entry");
        Map dimAssignInfo = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_DISPERM_INFO), Map.class);
        Map curDimInfo = (Map)dimAssignInfo.get(curDimType);
        if (!CollectionUtils.isEmpty((Map)curDimInfo)) {
            HasPermOrgResult adminChargeOrgAndBizUnit;
            long currUserId;
            Set dimIdStr = curDimInfo.keySet();
            List assignDims = dimIdStr.stream().map(Long::valueOf).collect(Collectors.toList());
            if (curDimType.contains("bos_org") && PermCommonUtil.isEnableJustShowAdminCharged() && AdminUserCache.isAdminUser((String)((currUserId = RequestContext.get().getCurrUserId()) + "")) && !(adminChargeOrgAndBizUnit = new PermissionServiceImpl().getAdminChargeOrgAndBizUnit(Long.valueOf(currUserId))).hasAllOrgPerm()) {
                List hasPermOrgs = adminChargeOrgAndBizUnit.getHasPermOrgs();
                assignDims.removeIf(k -> !hasPermOrgs.contains(k));
            }
            Map dimMap = IsoDimHelper.getDimMap(assignDims, (String)curDimType);
            Map<String, String> dimInfoMap = this.assignPermCacheUtil.getDimInfoMap();
            dataModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("dimnum", new Object[0]);
            vs.addField("dimname", new Object[0]);
            vs.addField("entitydimtype", new Object[0]);
            vs.addField("includesuborg", new Object[0]);
            for (Map.Entry entry : curDimInfo.entrySet()) {
                Long dimId = Long.valueOf((String)entry.getKey());
                String[] dimInfo = ((String)entry.getValue()).split(",");
                Dim dim = (Dim)dimMap.get(dimId);
                if (null == dim) continue;
                String dimName = dim.getDimName();
                String dimNumber = dim.getDimNumber();
                dimInfoMap.put(curDimType + "|" + dimId, dimNumber + "," + dimName);
                String includeSubStr = dimInfo[1];
                boolean includeSub = "1".equals(includeSubStr);
                vs.addRow(new Object[]{dimId, dimId, curDimType, includeSub});
            }
            ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("dim_entry", vs);
            dataModel.endInit();
            this.getPageCache().put("dimInfoMap", SerializationUtils.toJsonString(dimInfoMap));
            this.getView().updateView("dim_entry");
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addnode", "btn_delnode"});
        }
    }

    public void entryRowClick(RowClickEvent e) {
        Object source = e.getSource();
        if (source instanceof EntryGrid) {
            EntryGrid eg = (EntryGrid)source;
            String dimType = (String)this.getModel().getValue("dimtype");
            this.clearAllSearchMode();
            int[] rows = eg.getSelectRows();
            if (rows == null) {
                return;
            }
            boolean showNum = (Boolean)this.getModel().getValue("shownum");
            TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
            if (rows.length == 0) {
                this.getPageCache().remove(PGCACHE_LASTENTRYROWCLICK);
                this.getPageCache().remove(PGCACHE_BATCH_ASSIGN);
                this.clearTreeView();
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addnode", "btn_delnode"});
            } else if (rows.length == 1) {
                this.getPageCache().remove(PGCACHE_BATCH_ASSIGN);
                int curRowIndex = e.getRow();
                Long dimId = (Long)this.getModel().getValue(DIMNUM_ID, curRowIndex);
                this.getPageCache().put(PGCACHE_LASTENTRYROWCLICK, dimType + "|" + dimId);
                this.funcPermTreeUtil.initFuncPermLeftTree(tv, dimType, showNum);
                this.initFuncPermRightTree(dimType, dimId);
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_addnode", "btn_delnode"});
            } else if (rows.length > 1) {
                this.getPageCache().put(PGCACHE_BATCH_ASSIGN, VALUE_TRUE);
                this.getPageCache().removeBigObject(BATCH_ASSIGN);
                this.clearTreeView();
                StringBuilder sourceKey = new StringBuilder();
                for (int row : rows) {
                    Long dimId = (Long)this.getModel().getValue(DIMNUM_ID, row);
                    sourceKey.append(dimType).append("|").append(dimId).append(",");
                }
                sourceKey.deleteCharAt(sourceKey.length() - 1);
                this.getPageCache().put(PGCACHE_LASTENTRYROWCLICK, sourceKey.toString());
                this.funcPermTreeUtil.initFuncPermLeftTree(tv, dimType, showNum);
                this.buildFuncPermRightTree(BATCH_ASSIGN, null);
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_addnode"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_delnode"});
            }
        }
    }

    private void initFuncPermRightTree(String dimType, Long dimId) {
        List<String> userPermDetailInfos;
        String sourceKey = dimType + "|" + dimId;
        Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        Map<String, String> oriPermMap = assignPermOriInfoMap.get("tree_funcperm");
        Map<String, String> curPermMap = assignPermCurInfoMap.get("tree_funcperm");
        String data = curPermMap.get(sourceKey);
        if (StringUtils.isNotEmpty((String)data)) {
            userPermDetailInfos = SerializationUtils.fromJsonStringToList((String)data, String.class);
        } else {
            Map<String, List<String>> queryData = this.queryUserDimDisFuncPerm(dimType, Lists.newArrayList((Object[])new Long[]{dimId}));
            userPermDetailInfos = queryData.get(sourceKey);
            if (userPermDetailInfos == null) {
                userPermDetailInfos = new ArrayList<String>(10);
            }
            String serialInfo = SerializationUtils.toJsonString(userPermDetailInfos);
            oriPermMap.put(sourceKey, serialInfo);
            curPermMap.put(sourceKey, serialInfo);
            this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMap);
            this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
        }
        this.buildFuncPermRightTree(sourceKey, userPermDetailInfos);
    }

    private void buildFuncPermRightTree(String sourceKey, List<String> userPermDetailInfos) {
        TreeNode rootNode;
        TreeView tv = (TreeView)this.getControl("tree_disfunperm");
        tv.deleteAllNodes();
        HashMap<String, Map<String, List<String>>> dataResource = new HashMap<String, Map<String, List<String>>>(16);
        if (!CollectionUtils.isEmpty(userPermDetailInfos)) {
            this.funcPermTreeUtil.processData(false, dataResource, userPermDetailInfos);
            rootNode = ConstantsHelper.getTreeRootNode((boolean)true, (String)ConstantsHelper.getAllreadyAssignDesc());
            rootNode.setIsOpened(true);
        } else {
            rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllreadyAssignDesc());
        }
        tv.addNode(rootNode);
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, showNum);
        this.getPageCache().putBigObject(sourceKey, SerializationUtils.toJsonString(dataResource));
    }

    private Map<String, List<String>> queryUserDimDisFuncPerm(String dimType, List<Long> dimIds) {
        String[] suitableDimType = PermCommonUtil.getSuitableDimType((String)dimType);
        dimType = suitableDimType[1];
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(100);
        Long userId = (Long)this.getModel().getValue("user_id");
        try {
            StringBuilder dimIdStr = new StringBuilder();
            if (CollectionUtils.isEmpty(dimIds)) {
                return result;
            }
            for (Long dimId : dimIds) {
                dimIdStr.append(dimId).append(",");
            }
            dimIdStr.deleteCharAt(dimIdStr.length() - 1);
            StringBuilder assignPermInfoSb = new StringBuilder();
            assignPermInfoSb.append("select a.forgid, a.fbizappid, a.fentitytypeid entitynum, pt.fnumber permitemnum, a.fpermitemid from t_perm_disfunperm a ").append("left join t_perm_permitem pt on pt.fid = a.fpermitemid ").append("WHERE a.fuserid = ").append(userId).append(" AND a.fdimtype = '").append(dimType).append("' ").append(" AND a.forgid IN ( ").append((CharSequence)dimIdStr).append(") ");
            StringBuilder appInfoSb = new StringBuilder();
            appInfoSb.append("SELECT fid, fnumber appnum, fseq aseq, fbizcloudid FROM t_meta_bizapp WHERE ftype <> '2' ");
            StringBuilder cloudInfoSb = new StringBuilder();
            cloudInfoSb.append("SELECT fid, fnumber cloudnum, fseq cseq FROM t_meta_bizcloud ");
            try (DataSet assignPermInfo = DB.queryDataSet((String)"queryDimDisFuncPermInfo", (DBRoute)DBRoute.permission, (String)assignPermInfoSb.toString());
                 DataSet appInfo = DB.queryDataSet((String)"queryAppInfo", (DBRoute)DBRoute.meta, (String)appInfoSb.toString());
                 DataSet assignPermInfo2 = assignPermInfo.leftJoin(appInfo).on("fbizappid", "fid").select(new String[]{"forgid", "fbizappid", "entitynum", "fpermitemid", "permitemnum"}, new String[]{"appnum", "aseq", "fbizcloudid"}).finish();
                 DataSet cloudInfo = DB.queryDataSet((String)"queryCoudInfo", (DBRoute)DBRoute.meta, (String)cloudInfoSb.toString());
                 DataSet finalDs = assignPermInfo2.leftJoin(cloudInfo).on("fbizcloudid", "fid").select(new String[]{"forgid", "fbizcloudid", "fbizappid", "entitynum", "fpermitemid", "permitemnum", "appnum", "aseq"}, new String[]{"cloudnum", "cseq"}).finish().orderBy(new String[]{"forgid"});){
                List permItems;
                HashSet<String> assignPermDetail = new HashSet<String>(100);
                long lastDimId = 0L;
                Map<String, String> entityNumNameMap = this.funcPermTreeUtil.getEntityNumNameMap();
                Map<String, String> allEntityInfoMap = this.funcPermTreeUtil.getAllEntityInfoMap();
                Map allAppInfo = AppMetadataCache.getAllAppInfo();
                while (finalDs.hasNext()) {
                    Row row = finalDs.next();
                    Long dimId = row.getLong("forgid");
                    if (lastDimId != dimId && !CollectionUtils.isEmpty(assignPermDetail)) {
                        permItems = assignPermDetail.stream().sorted().collect(Collectors.toList());
                        result.put(dimType + "|" + lastDimId, permItems);
                        assignPermDetail = new HashSet(100);
                    }
                    String cloudId = row.getString("fbizcloudid");
                    String cloudSeq = row.getString("cseq");
                    String cloudNum = row.getString("cloudnum");
                    String bizAppId = row.getString("fbizappid");
                    String bizAppNum = row.getString("appnum");
                    String appSeq = AppHelper.getAppSeqStr((Map)allAppInfo, (String)row.getString("aseq"), (String)bizAppNum);
                    String entityNum = row.getString("entitynum");
                    String entityName = entityNumNameMap.get(entityNum);
                    String permItemId = row.getString("fpermitemid");
                    String permItemNum = row.getString("permitemnum");
                    String permInfo = String.join((CharSequence)"    ", cloudSeq, cloudNum, cloudId, appSeq, bizAppNum, bizAppId, entityNum, entityName);
                    allEntityInfoMap.putIfAbsent(bizAppId + "|" + entityNum, permInfo);
                    String data = String.join((CharSequence)"    ", cloudSeq, cloudNum, cloudId, appSeq, bizAppNum, bizAppId, entityNum, entityName, permItemNum, permItemId);
                    lastDimId = dimId;
                    assignPermDetail.add(data);
                }
                if (!CollectionUtils.isEmpty(assignPermDetail)) {
                    permItems = assignPermDetail.stream().sorted().collect(Collectors.toList());
                    result.put(dimType + "|" + lastDimId, permItems);
                }
                this.funcPermTreeUtil.putAllEntityInfoMap(allEntityInfoMap);
            }
        }
        catch (Exception e) {
            logger.warn("queryUserDimDisFuncPerm error", (Throwable)e);
        }
        return result;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("baritem_save".equals(itemKey)) {
            DynamicObject user = (DynamicObject)this.getModel().getValue("user");
            if (null != user && !Objects.equals(0L, user.getLong("id"))) {
                PermCommonUtil.checkUserEnable((Long)user.getLong("id"), (String)ResManager.loadKDString((String)"\u8be5\u7528\u6237\u4f7f\u7528\u72b6\u6001\u5df2\u88ab\u7981\u7528\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"UserGroupTreeListPlugin_47", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
            this.save();
        } else if ("baritem_dim_add".equals(itemKey)) {
            this.showDimF7();
        }
    }

    private void save() {
        Collection<String> values;
        Iterator<String> iterator;
        boolean singleOrg;
        Long adminId = RequestContext.get().getCurrUserId();
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        if (user == null || (Long)user.getPkValue() == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"UserAssignDisFunMultiPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        Long userId = user.getLong("id");
        if (adminId.equals(userId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserAssignDisFunMultiPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, String> emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap();
        if (!emptyDimMap.isEmpty() && !(singleOrg = PermCommonUtil.isSingleOrg()) && (iterator = (values = emptyDimMap.values()).iterator()).hasNext()) {
            String dimInfo = iterator.next();
            String[] arr = dimInfo.split(",");
            String dimTypeName = arr[0];
            String dimName = arr[1];
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u672a\u5206\u914d\u7981\u7528\u6743\u9650\u3002", (String)"UserAssignDisFunMultiPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), dimTypeName, dimName), Integer.valueOf(3000));
            return;
        }
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        boolean dataChange = (Boolean)this.getModel().getValue("datachangeflag");
        if (dataChange || !dimDataChangeSet.isEmpty()) {
            this.dispatch();
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserAssignDisFunMultiPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void dispatch() {
        try {
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(Lang.get());
            jobInfo.setAppId("bos");
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
            jobInfo.setNumber("perm-UserAssignDisFunMultiTaskjob" + System.currentTimeMillis());
            LocaleString captionLocalString = ResManager.getLocaleString((String)"\u7528\u6237\u76f4\u63a5\u7981\u6743\u5f02\u6b65\u4efb\u52a1\u7684\u6267\u884c", (String)"UserAssignDisFunMultiPlugin_6", (String)"bos-permission-formplugin");
            jobInfo.setlName(captionLocalString);
            String jobId = UUID.randomUUID().toString();
            jobInfo.setId(jobId);
            logger.info("UserAssignDisFunMultiPlugin.dispatch JobId:{}", (Object)jobId);
            jobInfo.setTaskClassname("kd.bos.permission.formplugin.task.UserAssignDisFunMultiTask");
            HashMap<String, Object> params = new HashMap<String, Object>();
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            params.put("appId", appId);
            params.put("formNum", formNum);
            params.put("oper_id", RequestContext.get().getCurrUserId());
            params.put("oper_org_id", RequestContext.get().getOrgId());
            params.put("client_type", RequestContext.get().getClient());
            params.put("client_ip", RequestContext.get().getLoginIP());
            params.put("client_name", RequestContext.get().getClient());
            params.put("pageId", this.getPageCache().getPageId());
            jobInfo.setParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "task_closeCallback");
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setCaption(captionLocalString.getLocaleValue());
            jobFormInfo.setCloseCallBack(closeCallBack);
            jobFormInfo.setCanBackground(true);
            jobFormInfo.setCanStop(true);
            jobFormInfo.setClickClassName("kd.bos.permission.formplugin.task.PermTaskClick");
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
        }
        catch (Exception e) {
            logger.warn("UserAssignDisFunMultiPlugin.dispatch error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private void showDimF7() {
        String dimType = (String)this.getModel().getValue("dimtype");
        if (StringUtils.isEmpty((String)dimType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u201c\u6743\u9650\u63a7\u5236\u7c7b\u578b\u201d\u9875\u7b7e\u3002", (String)"UserAssignDisFunMultiPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
        DynamicObject[] col = eg.getEntryData().getDataEntitys();
        ArrayList<Long> existDimIds = new ArrayList<Long>(col.length);
        for (DynamicObject o : col) {
            existDimIds.add(o.getLong(DIMNUM_ID));
        }
        ListShowParameter listForm = ShowFormHelper.createShowListForm((String)dimType, (boolean)true);
        ListFilterParameter listFilter = new ListFilterParameter();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (!CollectionUtils.isEmpty(existDimIds)) {
            filters.add(new QFilter("id", "not in", existDimIds));
        }
        String noAdminChargeOrgFilterParam = this.getPageCache().get("NoAdminChargeOrgFilter");
        if ("bos_org".equals(dimType)) {
            listForm.setF7ClickByFilter(true);
            List<QFilter> customerFilter = this.getCustomerFilter();
            filters.addAll(customerFilter);
            if (StringUtils.isEmpty((String)noAdminChargeOrgFilterParam)) {
                listForm.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
                listForm.setCustomParam("showAdminOrgViewType", (Object)Boolean.TRUE);
            }
        }
        listFilter.setQFilters(filters);
        listForm.setListFilterParameter(listFilter);
        listForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeCallBack_addDim"));
        this.getView().showForm((FormShowParameter)listForm);
    }

    private List<QFilter> getCustomerFilter() {
        String dimObjQFilterCache = this.getPageCache().get("CustomQFilter_DimObjIds");
        if (StringUtils.isNotEmpty((String)dimObjQFilterCache)) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            QFilter dimObjQFilter = QFilter.fromSerializedString((String)dimObjQFilterCache);
            filterList.add(dimObjQFilter);
            return filterList;
        }
        String customDimObjIds = this.getPageCache().get("CustomFilter_OrgIds");
        if (StringUtils.isEmpty((String)customDimObjIds)) {
            customDimObjIds = this.getPageCache().get("CustomFilter_DimObjIds");
        }
        if (StringUtils.isNotEmpty((String)customDimObjIds)) {
            List strDimObjIdList = (List)SerializationUtils.fromJsonString((String)customDimObjIds, List.class);
            ArrayList<Long> dimObjIdList = new ArrayList<Long>(strDimObjIdList.size());
            for (Object strDimObjId : strDimObjIdList) {
                dimObjIdList.add(Long.parseLong(strDimObjId.toString()));
            }
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            if (dimObjIdList.size() > 0) {
                filterList.add(new QFilter("id", "in", dimObjIdList));
                return filterList;
            }
        }
        List<String> filterDimObjStrIds = this.getDimObjIdsFromFsp();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (!CollectionUtils.isEmpty(filterDimObjStrIds)) {
            List filterDimObjIds = filterDimObjStrIds.stream().map(Long::valueOf).collect(Collectors.toList());
            filterList.add(new QFilter("id", "in", filterDimObjIds));
            return filterList;
        }
        return filterList;
    }

    public List<String> getDimObjIdsFromFsp() {
        ArrayList<String> resultList = new ArrayList<String>();
        String dimObjIds = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimensionObjIds");
        if (StringUtils.isNotEmpty((String)dimObjIds)) {
            String[] arrDimObjId;
            for (String dimObjId : arrDimObjId = dimObjIds.split(",")) {
                if (StringUtils.isEmpty((String)dimObjId)) continue;
                dimObjId = dimObjId.trim();
                resultList.add(dimObjId);
            }
        }
        return resultList;
    }

    public void beforeClick(BeforeClickEvent e) {
        Button button;
        String key;
        super.beforeClick(e);
        Object source = e.getSource();
        if (source instanceof Button && ("btn_addnode".equals(key = (button = (Button)source).getKey()) || "btn_delnode".equals(key))) {
            String opName = "btn_addnode".equals(key) ? ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"UserAssignDisFunMultiPlugin_8", (String)"bos-permission-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u79fb\u9664", (String)"UserAssignDisFunMultiPlugin_9", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            boolean setCancel = this.checkAdminChargeOrg(this.getView(), opName);
            long currUserId = RequestContext.get().getCurrUserId();
            boolean adminUser = PermissionServiceHelper.isAdminUser((long)currUserId);
            boolean isOrgDimType = "bos_org".equals(this.getModel().getValue("dimtype"));
            if (setCancel) {
                e.setCancel(true);
            } else if ("btn_addnode".equals(key) && adminUser && isOrgDimType) {
                EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
                int[] selectRows = eg.getSelectRows();
                StringBuilder sourceKey = new StringBuilder();
                String dimType = (String)this.getModel().getValue("dimtype");
                for (int row : selectRows) {
                    Long dimId = (Long)this.getModel().getValue(DIMNUM_ID, row);
                    sourceKey.append(dimType).append("|").append(dimId).append(",");
                }
                sourceKey.deleteCharAt(sourceKey.length() - 1);
                this.getPageCache().put(PGCACHE_LASTENTRYROWCLICK, sourceKey.toString());
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Vector) {
            Vector vector = (Vector)evt.getSource();
            String key = vector.getKey();
            String pageCache_tabKeys = this.getPageCache().get(PGCACHE_DIMTABKEYS);
            if ("adddimtab".equals(key)) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("perm_add_auth_scope");
                List tabKeys = new ArrayList(1);
                if (StringUtils.isNotEmpty((String)pageCache_tabKeys)) {
                    tabKeys = (List)SerializationUtils.fromJsonString((String)pageCache_tabKeys, List.class);
                }
                fsp.setCustomParam("showFormCustomParam_existCtrlTypes", tabKeys);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setHasRight(true);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeCallBack_addAuthScope"));
                this.getView().showForm(fsp);
            } else if ("deldimtab".equals(key)) {
                List dimTabKeys = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_DIMTABKEYS), List.class);
                Tab tab = (Tab)this.getControl("dimtab");
                String currentTab = tab.getCurrentTab();
                if (StringUtils.isEmpty((String)currentTab) || CollectionUtils.isEmpty((Collection)dimTabKeys)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6743\u9650\u63a7\u5236\u7c7b\u578b\u201d\u9875\u7b7e\u53ef\u5220\u9664\u3002", (String)"UserAssignDisFunMultiPlugin_10", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    return;
                }
                EntryGrid entryGrid = (EntryGrid)this.getControl("dim_entry");
                EntryData entryData = entryGrid.getEntryData();
                if (entryData != null) {
                    DynamicObject[] dataEntity = entryData.getDataEntitys();
                    if (dataEntity.length != 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u7b7e\u4e0b\u5b58\u5728\u5206\u914d\u7684\u6743\u9650\u6570\u636e\uff0c\u8bf7\u5148\u6e05\u9664\u6743\u9650\u6570\u636e\u3002", (String)"UserAssignDisFunMultiPlugin_11", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                        return;
                    }
                    this.delDimTab(tab, currentTab);
                }
            }
        } else if (source instanceof Button) {
            Button button = (Button)source;
            String key = button.getKey();
            if ("btn_addnode".equals(key)) {
                TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
                List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
                if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u529f\u80fd\u6743\u9650\u6811\u3002", (String)"UserAssignDisFunMultiPlugin_12", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.addNodeData(tv, checkedNodeIds);
            } else if ("btn_delnode".equals(key)) {
                TreeView tv = (TreeView)this.getControl("tree_disfunperm");
                List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
                if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5df2\u5206\u914d\u6743\u9650\u6811\u3002", (String)"UserAssignDisFunMultiPlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.removeNodeData(checkedNodeIds);
            }
        }
    }

    private void removeNodeData(List<String> checkedNodeIds) {
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        Map<String, String> emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap();
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        dimDataChangeSet.add(sourceKey);
        this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        Map<String, String> curPermMap = assignPermCurInfoMap.get("tree_funcperm");
        List<String> curPermDetail = SerializationUtils.fromJsonStringToList((String)curPermMap.get(sourceKey), String.class);
        ArrayList<String> searChPermDetail = new ArrayList(10);
        boolean isSearchMode = false;
        String searchModeStr = this.getPageCache().getBigObject("userFuncPermTreeSearchMode");
        if (StringUtils.isNotEmpty((String)searchModeStr)) {
            isSearchMode = true;
        }
        String showFormSpecial = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        boolean dontCheckAppChargeRange = VALUE_TRUE.equals(showFormSpecial);
        if (checkedNodeIds.contains("-1")) {
            List<String> permDetailInAdminCharge;
            if (isSearchMode) {
                searChPermDetail = SerializationUtils.fromJsonStringToList((String)searchModeStr, String.class);
                permDetailInAdminCharge = dontCheckAppChargeRange ? searChPermDetail : PermFormCommonUtil.getPermDetailInAdminCharge(this.getView(), searChPermDetail);
            } else {
                permDetailInAdminCharge = dontCheckAppChargeRange ? curPermDetail : PermFormCommonUtil.getPermDetailInAdminCharge(this.getView(), curPermDetail);
            }
            curPermDetail = new ArrayList<String>((Collection<String>)Sets.difference(new HashSet<String>(curPermDetail), new HashSet<String>(permDetailInAdminCharge)));
        } else {
            Map<String, String> allEntityInfoMap = this.funcPermTreeUtil.getAllEntityInfoMap();
            Map<String, Map<String, List<String>>> dataResource = new HashMap<String, Map<String, List<String>>>(16);
            if (isSearchMode) {
                searChPermDetail = SerializationUtils.fromJsonStringToList((String)searchModeStr, String.class);
                this.funcPermTreeUtil.processData(false, dataResource, searChPermDetail);
            } else {
                dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(sourceKey), Map.class);
            }
            Set<String> selectedPermNode = this.funcPermTreeUtil.getRealSelectedNode(false, dataResource, checkedNodeIds, allEntityInfoMap);
            ArrayList<String> selectedPermNodeList = new ArrayList<String>(selectedPermNode);
            List<String> permDetailInAdminCharge = dontCheckAppChargeRange ? selectedPermNodeList : PermFormCommonUtil.getPermDetailInAdminCharge(this.getView(), selectedPermNodeList);
            curPermDetail = new ArrayList<String>((Collection<String>)Sets.difference(new HashSet<String>(curPermDetail), new HashSet<String>(permDetailInAdminCharge)));
            curPermDetail = curPermDetail.stream().sorted().collect(Collectors.toList());
        }
        curPermMap.put(sourceKey, SerializationUtils.toJsonString(curPermDetail));
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
        this.getPageCache().removeBigObject("userFuncPermTreeSearchMode");
        if (curPermDetail.size() == 0) {
            String[] selectedDimInfo = this.getSelectedDimInfo();
            emptyDimMap.put(sourceKey, selectedDimInfo[1] + "," + selectedDimInfo[0]);
            this.getPageCache().put("emptyDimMap", SerializationUtils.toJsonString(emptyDimMap));
        }
        this.getModel().setValue("datachangeflag", (Object)true);
        this.buildFuncPermRightTree(sourceKey, curPermDetail);
    }

    private void addNodeData(TreeView tv, List<String> checkedNodeIds) {
        HashSet sourceKeySet = null;
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        Map<String, String> emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap();
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        String[] clickRows = sourceKey.split(",");
        List<String> sourceKeyList = Arrays.stream(clickRows).collect(Collectors.toList());
        Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        Map<String, String> oriPermMap = assignPermOriInfoMap.get("tree_funcperm");
        Map<String, String> curPermMap = assignPermCurInfoMap.get("tree_funcperm");
        HashMap<String, Map<String, String>> assignPermOriInfoMapReplace = new HashMap<String, Map<String, String>>(8);
        assignPermOriInfoMapReplace.putAll(assignPermOriInfoMap);
        HashMap<String, String> oriPermMapReplace = new HashMap<String, String>(8);
        oriPermMapReplace.putAll(oriPermMap);
        HashMap<String, String> curPermMapReplace = new HashMap<String, String>(8);
        curPermMapReplace.putAll(curPermMap);
        if (this.addTooMuch(curPermMapReplace)) {
            return;
        }
        String dimType = (String)this.getModel().getValue("dimtype");
        if (clickRows.length > 1) {
            ArrayList<Long> dimIds = new ArrayList<Long>(clickRows.length);
            sourceKeySet = new HashSet(sourceKeyList);
            Set hasLoadedPermDims = oriPermMapReplace.keySet();
            sourceKeySet.removeAll(hasLoadedPermDims);
            if (!sourceKeySet.isEmpty()) {
                for (String key : sourceKeySet) {
                    dimIds.add(Long.valueOf(key.split("\\|")[1]));
                }
            }
            if (!dimIds.isEmpty()) {
                Map<String, List<String>> queryData = this.queryUserDimDisFuncPerm(dimType, dimIds);
                for (String key : sourceKeySet) {
                    List<String> userPermDetailInfos = queryData.get(key);
                    if (userPermDetailInfos == null) {
                        userPermDetailInfos = new ArrayList<String>(10);
                    }
                    oriPermMapReplace.put(key, SerializationUtils.toJsonString(userPermDetailInfos));
                    curPermMapReplace.put(key, SerializationUtils.toJsonString(userPermDetailInfos));
                    if (!this.addTooMuch(curPermMapReplace)) continue;
                    return;
                }
                assignPermOriInfoMapReplace.put("tree_funcperm", oriPermMapReplace);
            }
            sourceKeyList.add(BATCH_ASSIGN);
            sourceKey = BATCH_ASSIGN;
            curPermMapReplace.putIfAbsent(sourceKey, SerializationUtils.toJsonString(new ArrayList(10)));
            if (this.addTooMuch(curPermMapReplace)) {
                return;
            }
        }
        List<Object> assignPermNodeList = new ArrayList(10);
        Map<String, String> allEntityInfoMap = this.funcPermTreeUtil.getAllEntityInfoMap();
        Map<String, String> allPermNodeInfoMap = this.funcPermTreeUtil.getAllPermNodeInfoMap();
        String searchMode = this.getPageCache().getBigObject("allFuncPermTreeSearchMode");
        if (checkedNodeIds.contains("-1")) {
            if (StringUtils.isNotEmpty((String)searchMode)) {
                List searChPermDetail = SerializationUtils.fromJsonStringToList((String)searchMode, String.class);
                for (String dimTypeDimId : sourceKeyList) {
                    List curDimPermList = SerializationUtils.fromJsonStringToList((String)((String)curPermMapReplace.get(dimTypeDimId)), String.class);
                    HashSet curDimPermSet = new HashSet(curDimPermList);
                    curDimPermSet.addAll(searChPermDetail);
                    assignPermNodeList = curDimPermSet.stream().sorted().collect(Collectors.toList());
                    curPermMapReplace.put(dimTypeDimId, SerializationUtils.toJsonString(assignPermNodeList));
                    if (!this.addTooMuch(curPermMapReplace)) continue;
                    return;
                }
            } else {
                Map<String, String> entityAssignablePermItemMap = this.funcPermTreeUtil.getEntityAssignablePermItemMap();
                Map<String, String> permItemIdNumberMap = this.funcPermTreeUtil.getPermItemIdNumberMap();
                Collection<String> values = allPermNodeInfoMap.values();
                assignPermNodeList = new ArrayList(values.size() * 10);
                for (String value : values) {
                    String[] permItemIdArr;
                    String[] arr = value.split("    ");
                    String entityNum = arr[6];
                    String permItemStr = entityAssignablePermItemMap.get(entityNum);
                    if (!StringUtils.isNotEmpty((String)permItemStr)) continue;
                    for (String permItemId : permItemIdArr = permItemStr.split(",")) {
                        if (StringUtils.isEmpty((String)permItemId)) continue;
                        String permItemNum = permItemIdNumberMap.get(permItemId);
                        assignPermNodeList.add(String.join((CharSequence)"    ", value, permItemNum, permItemId));
                    }
                }
                for (String dimTypeDimId : sourceKeyList) {
                    String serialStr = (String)curPermMapReplace.get(dimTypeDimId);
                    if (StringUtils.isNotEmpty((String)serialStr)) {
                        HashSet<String> curPermSet = new HashSet<String>(SerializationUtils.fromJsonStringToList((String)serialStr, String.class));
                        curPermSet.addAll(assignPermNodeList);
                        assignPermNodeList = curPermSet.stream().sorted().collect(Collectors.toList());
                    } else {
                        assignPermNodeList = assignPermNodeList.stream().sorted().collect(Collectors.toList());
                    }
                    curPermMapReplace.put(dimTypeDimId, SerializationUtils.toJsonString(assignPermNodeList));
                    if (!this.addTooMuch(curPermMapReplace)) continue;
                    return;
                }
            }
        } else {
            Map<String, Map<String, List<String>>> dataResource = new HashMap<String, Map<String, List<String>>>(16);
            if (StringUtils.isNotEmpty((String)searchMode)) {
                List searChPermDetail = SerializationUtils.fromJsonStringToList((String)searchMode, String.class);
                this.funcPermTreeUtil.processData(false, dataResource, searChPermDetail);
            } else {
                dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(dimType), Map.class);
            }
            Set<String> selectedPermNode = this.funcPermTreeUtil.getRealSelectedNode(true, dataResource, checkedNodeIds, allEntityInfoMap);
            for (String dimTypeDimId : sourceKeyList) {
                HashSet<String> dataSourceBeans;
                String data = (String)curPermMapReplace.get(dimTypeDimId);
                if (StringUtils.isEmpty((String)data)) {
                    dataSourceBeans = new HashSet<String>(16);
                } else {
                    List dataSource = SerializationUtils.fromJsonStringToList((String)data, String.class);
                    dataSourceBeans = new HashSet(dataSource);
                }
                dataSourceBeans.addAll(selectedPermNode);
                assignPermNodeList = dataSourceBeans.stream().sorted().collect(Collectors.toList());
                curPermMapReplace.put(dimTypeDimId, SerializationUtils.toJsonString(assignPermNodeList));
                if (!this.addTooMuch(curPermMapReplace)) continue;
                return;
            }
        }
        this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMapReplace);
        sourceKeyList.removeIf(x -> x.equals(BATCH_ASSIGN));
        dimDataChangeSet.addAll(sourceKeyList);
        this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
        assignPermCurInfoMap.put("tree_funcperm", curPermMapReplace);
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
        sourceKeyList.forEach(emptyDimMap::remove);
        this.getPageCache().put("emptyDimMap", SerializationUtils.toJsonString(emptyDimMap));
        this.buildFuncPermRightTree(sourceKey, assignPermNodeList);
        Search disFuncPermSearch = (Search)this.getControl("disfunpermsearchap");
        disFuncPermSearch.setSearchKey("");
        this.getPageCache().removeBigObject("disFuncPermTreeSearchMode");
        tv.uncheckNodes(checkedNodeIds);
        this.getModel().setValue("datachangeflag", (Object)true);
    }

    private boolean addTooMuch(Map<String, String> dimTypeDimIdAssignPermNodeStrMap) {
        int count = 0;
        for (Map.Entry<String, String> dimTypeDimIdAssignPermNodeStr : dimTypeDimIdAssignPermNodeStrMap.entrySet()) {
            List nowAssignPermNodeList;
            String nowAssignPermNode = dimTypeDimIdAssignPermNodeStr.getValue();
            if (StringUtils.isEmpty((String)nowAssignPermNode) || null == (nowAssignPermNodeList = (List)SerializationUtils.fromJsonString((String)nowAssignPermNode, List.class)) || nowAssignPermNodeList.isEmpty()) continue;
            count += nowAssignPermNodeList.size();
        }
        if (400000 < count) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u7981\u7528\u7684\u6743\u9650\u8fc7\u591a(\u8d85\u8fc7\u9884\u8bbe\u4e0a\u9650%s\u884c)\uff0c\u8003\u8651\u6027\u80fd\u95ee\u9898\uff0c\u4e0d\u5141\u8bb8\u7ee7\u7eed\u6dfb\u52a0\u3002\u5efa\u8bae\u5728\u76f4\u63a5\u6388\u6743\u4e2d\u51cf\u5c11\u6388\u6743\u6216\u5c06\u8be5\u7528\u6237\u6743\u9650\u6e05\u9664\u3002", (String)"UserAssignDisFunMultiPlugin_14", (String)"bos-permission-formplugin", (Object[])new Object[]{400000}), Integer.valueOf(5000));
            return true;
        }
        return false;
    }

    private void delDimTab(Tab tab, String delTabKey) {
        String[] tabKeyInfoArr = delTabKey.split("\\|");
        HashMap<String, String> updateCacheMap = new HashMap<String, String>(16);
        String dimType = tabKeyInfoArr[0];
        Map userDirectAssignDim = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_DISPERM_INFO), Map.class);
        EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
        DynamicObject[] col = eg.getEntryData().getDataEntitys();
        ArrayList<String> delDims = new ArrayList<String>(col.length);
        for (DynamicObject o : col) {
            long dimId = o.getLong(DIMNUM_ID);
            delDims.add(String.valueOf(dimId));
        }
        this.clearCacheAfterDelDim(delDims);
        userDirectAssignDim.remove(dimType);
        updateCacheMap.put(PGCACHE_USER_ASSIGN_DISPERM_INFO, SerializationUtils.toJsonString((Object)userDirectAssignDim));
        String pageCache_tabKeys = this.getPageCache().get(PGCACHE_DIMTABKEYS);
        List tabKeyList = (List)SerializationUtils.fromJsonString((String)pageCache_tabKeys, List.class);
        tabKeyList.remove(delTabKey);
        updateCacheMap.put(PGCACHE_DIMTABKEYS, SerializationUtils.toJsonString((Object)tabKeyList));
        this.getPageCache().put(updateCacheMap);
        this.getPageCache().remove(PGCACHE_LASTCLICK_DIMTAB);
        tab.deleteControls(new String[]{delTabKey});
        if (!tabKeyList.isEmpty()) {
            String firstTabKey = (String)tabKeyList.get(0);
            tab.selectTab(firstTabKey);
            tab.activeTab(firstTabKey);
        } else {
            this.getModel().deleteEntryData("dim_entry");
            this.getModel().setValue("dimtype", null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("task_closeCallback".equals(actionId)) {
            this.handleTaskCallBack(e.getReturnData());
        } else if ("closeCallBack_addAuthScope".equals(actionId)) {
            this.handleAddAuthScopeCallBack(returnData);
        } else if ("closeCallBack_addDim".equals(actionId)) {
            this.handleAddDimCallBack(returnData);
        }
    }

    private void handleAddDimCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            Set<String> addDimSet = this.assignPermCacheUtil.getAddDimSet();
            Map<String, String> emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap();
            Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
            Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            Map<String, String> oriFuncPermMap = assignPermOriInfoMap.get("tree_funcperm");
            Map<String, String> curFuncPermMap = assignPermCurInfoMap.get("tree_funcperm");
            Tab tab = (Tab)this.getControl("dimtab");
            String currentTab = tab.getCurrentTab();
            String[] tabInfoArr = currentTab.split("\\|");
            String dimType = tabInfoArr[0];
            String dimTypeName = tabInfoArr[1];
            Map userDirectAssignDisDim = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_DISPERM_INFO), Map.class);
            Map curDimTypeAssignInfo = (Map)userDirectAssignDisDim.get(dimType);
            ListSelectedRowCollection col = (ListSelectedRowCollection)returnData;
            HashSet<Long> dimIds = new HashSet<Long>(col.size());
            for (ListSelectedRow row : col) {
                Long dimId = (Long)row.getPrimaryKeyValue();
                dimIds.add(dimId);
            }
            Map dimMap = IsoDimHelper.getDimMap(new ArrayList(dimIds), (String)dimType);
            Map<String, String> dimInfoMap = this.assignPermCacheUtil.getDimInfoMap();
            this.getModel().beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("dimnum", new Object[0]);
            vs.addField("dimname", new Object[0]);
            vs.addField("entitydimtype", new Object[0]);
            vs.addField("includesuborg", new Object[0]);
            for (Long dimId : dimIds) {
                Dim dim = (Dim)dimMap.get(dimId);
                if (null == dim) continue;
                String dimName = dim.getDimName();
                vs.addRow(new Object[]{dimId, dimId, dimType, false});
                curDimTypeAssignInfo.put(String.valueOf(dimId), String.join((CharSequence)",", String.valueOf(dimId), "0", "0"));
                String sourceKey = dimType + "|" + dimId;
                addDimSet.add(sourceKey);
                emptyDimMap.put(sourceKey, dimTypeName + "," + dimName);
                dimDataChangeSet.add(sourceKey);
                String dimNumber = dim.getDimNumber();
                dimInfoMap.put(sourceKey, dimNumber + "," + dimName);
                String oriFuncPermStr = SerializationUtils.toJsonString(new ArrayList(10));
                oriFuncPermMap.put(sourceKey, oriFuncPermStr);
                curFuncPermMap.put(sourceKey, oriFuncPermStr);
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("dim_entry", vs);
            this.getModel().endInit();
            this.getView().updateView("dim_entry");
            HashMap<String, String> newDataMap = new HashMap<String, String>(16);
            newDataMap.put(PGCACHE_USER_ASSIGN_DISPERM_INFO, SerializationUtils.toJsonString((Object)userDirectAssignDisDim));
            newDataMap.put("addDimSet", SerializationUtils.toJsonString(addDimSet));
            newDataMap.put("emptyDimMap", SerializationUtils.toJsonString(emptyDimMap));
            newDataMap.put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
            newDataMap.put("dimInfoMap", SerializationUtils.toJsonString(dimInfoMap));
            this.getPageCache().put(newDataMap);
            this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMap);
            this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
            this.clearTreeView();
            this.clearAllSearchMode();
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addnode", "btn_delnode"});
            this.getModel().setValue("datachangeflag", (Object)true);
            EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
            eg.addRowClickListener((RowClickEventListener)this);
            int entryCount = this.getModel().getEntryRowCount("dim_entry");
            if (entryCount > 0) {
                int selRow = entryCount - dimMap.size();
                eg.selectRows(selRow);
                eg.getEntryState().selectRow(selRow);
                eg.getEntryState().setFocusRow(selRow);
                eg.entryRowClick(Integer.valueOf(selRow));
            }
        }
    }

    private void handleAddAuthScopeCallBack(Object returnData) {
        if (returnData instanceof String) {
            String key = (String)returnData;
            String[] returnDataArr = key.split("\\|");
            String tabName = returnDataArr[1];
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(key);
            tabPageAp.setName(new LocaleString(tabName));
            Tab tab = (Tab)this.getControl("dimtab");
            tab.addTabSelectListener((TabSelectListener)this);
            ArrayList<Map> items = new ArrayList<Map>(10);
            items.add(tabPageAp.createControl());
            tab.addControls(items);
            String pageCache_tabKeys = this.getPageCache().get(PGCACHE_DIMTABKEYS);
            List tabKeyList = (List)SerializationUtils.fromJsonString((String)pageCache_tabKeys, List.class);
            tabKeyList.add(tabPageAp.getKey());
            HashMap<String, String> newDataCache = new HashMap<String, String>(16);
            newDataCache.put(PGCACHE_DIMTABKEYS, SerializationUtils.toJsonString((Object)tabKeyList));
            Map userDirectAssignDisDim = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_DISPERM_INFO), Map.class);
            userDirectAssignDisDim.put(returnDataArr[0], new LinkedHashMap(16));
            newDataCache.put(PGCACHE_USER_ASSIGN_DISPERM_INFO, SerializationUtils.toJsonString((Object)userDirectAssignDisDim));
            this.getPageCache().put(newDataCache);
            tab.selectTab(key);
            tab.activeTab(key);
        }
    }

    private void handleTaskCallBack(Object returnData) {
        try {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result;
            if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && !StringUtils.isBlank((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String msgType;
                String data = taskInfo.getData();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                IFormView view = this.getView();
                String msg = String.valueOf(dataMap.get("msg"));
                switch (msgType = String.valueOf(dataMap.get("msgType"))) {
                    case "errorNotice": {
                        view.showErrorNotification(msg);
                        break;
                    }
                    case "showMess": {
                        view.showMessage(msg);
                        break;
                    }
                    case "successNotice": {
                        this.updateUserDimInfo();
                        this.clearCacheAfterSave();
                        Integer showTime = (Integer)dataMap.get("showTime");
                        view.showSuccessNotification(msg, showTime);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn("UserAssignDisFunMultiPlugin.handleTaskCallBack error", (Throwable)e);
        }
    }

    private void updateUserDimInfo() {
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        Map userDirectAssignDim = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_DISPERM_INFO), Map.class);
        for (String sourceKey : dimDataChangeSet) {
            String[] dimInfo = sourceKey.split("\\|");
            String dimType = dimInfo[0];
            String dimId = dimInfo[1];
            Map curDimTypeAssignInfo = (Map)userDirectAssignDim.get(dimType);
            CharSequence[] permInfoArr = ((String)curDimTypeAssignInfo.get(dimId)).split(",");
            permInfoArr[2] = "0";
            curDimTypeAssignInfo.put(dimId, String.join((CharSequence)",", permInfoArr));
        }
        this.getModel().setValue("datachangeflag", (Object)false);
        this.getPageCache().put(PGCACHE_USER_ASSIGN_DISPERM_INFO, SerializationUtils.toJsonString((Object)userDirectAssignDim));
    }

    public void queryTreeNodeChildren(TreeNodeEvent e) {
        TreeView tv = (TreeView)e.getSource();
        String nodeId = (String)e.getNodeId();
        String dimType = (String)this.getModel().getValue("dimtype");
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        switch (tv.getKey()) {
            case "tree_allfunctionperm": {
                String sourceKey = dimType;
                Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(sourceKey), Map.class);
                this.funcPermTreeUtil.commonAddNode(tv, nodeId, dataResource, showNum);
                break;
            }
            case "tree_disfunperm": {
                String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
                String batchAssignFlag = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
                if (StringUtils.isNotEmpty((String)batchAssignFlag)) {
                    sourceKey = BATCH_ASSIGN;
                }
                Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(sourceKey), Map.class);
                this.funcPermTreeUtil.commonAddNode(tv, nodeId, dataResource, showNum);
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        Search source = (Search)evt.getSource();
        String key = source.getKey();
        String text = evt.getText();
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        if (sourceKey == null) {
            return;
        }
        String dimType = (String)this.getModel().getValue("dimtype");
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        if ("searchap".equals(key)) {
            TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
            if (StringUtils.isBlank((String)text)) {
                this.getPageCache().removeBigObject("allFuncPermTreeSearchMode");
                this.funcPermTreeUtil.initFuncPermLeftTree(tv, dimType, showNum);
            } else {
                Map<String, String> allPermNodeInfoMap = this.funcPermTreeUtil.getAllPermNodeInfoMap();
                Map<String, String> entityAssignablePermItemMap = this.funcPermTreeUtil.getEntityAssignablePermItemMap();
                Map<String, String> permItemIdNumberMap = this.funcPermTreeUtil.getPermItemIdNumberMap();
                Collection<String> values = allPermNodeInfoMap.values();
                ArrayList<String> searchInfos = new ArrayList<String>(100);
                for (String value : values) {
                    String[] permItemIdArr;
                    String permItemStr;
                    String[] arr = value.split("    ");
                    String entityName = arr[7];
                    String entityNum = arr[6];
                    if (!entityName.contains(text) && (!showNum || !entityNum.equals(text)) || !StringUtils.isNotEmpty((String)(permItemStr = entityAssignablePermItemMap.get(entityNum)))) continue;
                    for (String permItemId : permItemIdArr = permItemStr.split(",")) {
                        if (StringUtils.isEmpty((String)permItemId)) continue;
                        String permItemNum = permItemIdNumberMap.get(permItemId);
                        searchInfos.add(String.join((CharSequence)"    ", value, permItemNum, permItemId));
                    }
                }
                this.getPageCache().putBigObject("allFuncPermTreeSearchMode", SerializationUtils.toJsonString(searchInfos));
                this.funcPermTreeUtil.rebuildTree("tree_allfunctionperm", tv, searchInfos, true, showNum);
            }
        } else if ("disfunpermsearchap".equals(key)) {
            String flagBatchAssign = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
            if (StringUtils.isNotEmpty((String)flagBatchAssign)) {
                sourceKey = BATCH_ASSIGN;
            }
            TreeView tv = (TreeView)this.getControl("tree_disfunperm");
            if (StringUtils.isBlank((String)text)) {
                this.getPageCache().removeBigObject("disFuncPermTreeSearchMode");
                tv.deleteAllNodes();
                Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(sourceKey), Map.class);
                TreeNode rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllreadyAssignDesc());
                rootNode.setIsOpened(true);
                tv.addNode(rootNode);
                this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, showNum);
            } else {
                Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
                String curPermDetailStr = assignPermCurInfoMap.get("tree_funcperm").get(sourceKey);
                ArrayList curPermDetail = StringUtils.isNotEmpty((String)curPermDetailStr) ? SerializationUtils.fromJsonStringToList((String)curPermDetailStr, String.class) : new ArrayList(10);
                ArrayList<String> searchInfos = new ArrayList<String>(100);
                for (String value : curPermDetail) {
                    String[] arr = value.split("    ");
                    String entityName = arr[7];
                    String entityNum = arr[6];
                    if (!entityName.contains(text) && (!showNum || !entityNum.equals(text))) continue;
                    searchInfos.add(value);
                }
                this.getPageCache().putBigObject("disFuncPermTreeSearchMode", SerializationUtils.toJsonString(searchInfos));
                this.funcPermTreeUtil.rebuildTree("tree_disfunperm", tv, searchInfos, true, showNum);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.equals("continue_close") && e.getResult() == MessageBoxResult.Yes) {
            this.release();
        }
    }

    private void release() {
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        if (user != null) {
            Long userId = user.getLong("id");
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
                MutexHelper.release((String)"bos_usergroup_user", (String)"directdisfunmulti", (String)String.valueOf(userId));
                UserHelper.delEditingPermUserId((List)Lists.newArrayList((Object[])new String[]{userId + ""}));
            }
        }
        PermFormCommonUtil.closeClientForm(this.getView());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        boolean dataChange = (Boolean)this.getModel().getValue("datachangeflag");
        if (dataChange || !dimDataChangeSet.isEmpty()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"UserAssignDisFunMultiPlugin_15", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            e.setCancel(true);
        } else {
            this.release();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getPageCache().get("skip") != null) {
            this.getPageCache().remove("skip");
            return;
        }
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        if ("includesuborg".equals(propName)) {
            boolean setCancel = this.checkAdminChargeOrg(this.getView(), ResManager.loadKDString((String)"\u8bbe\u7f6e\u5305\u542b\u4e0b\u7ea7", (String)"UserAssignDisFunMultiPlugin_16", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            if (setCancel) {
                this.getPageCache().put("skip", VALUE_TRUE);
                this.getModel().setValue("includesuborg", oldValue, rowIndex);
                return;
            }
            Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
            boolean includeSub = (Boolean)newValue;
            Map dimAssignInfo = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_DISPERM_INFO), Map.class);
            String[] dimInfo = sourceKey.split("\\|");
            Map curDimTypeAssignInfo = (Map)dimAssignInfo.get(dimInfo[0]);
            String dimId = dimInfo[1];
            CharSequence[] permInfoArr = ((String)curDimTypeAssignInfo.get(dimId)).split(",");
            permInfoArr[1] = includeSub ? "1" : "0";
            String includeSubChange = permInfoArr[2];
            permInfoArr[2] = "0".equals(includeSubChange) ? "1" : "0";
            curDimTypeAssignInfo.put(dimId, String.join((CharSequence)",", permInfoArr));
            this.getPageCache().put(PGCACHE_USER_ASSIGN_DISPERM_INFO, SerializationUtils.toJsonString((Object)dimAssignInfo));
            dimDataChangeSet.add(sourceKey);
            this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
            this.getModel().setValue("datachangeflag", (Object)true);
        } else if ("shownum".equals(propName)) {
            if (StringUtils.isEmpty((String)sourceKey)) {
                return;
            }
            String dimType = (String)this.getModel().getValue("dimtype");
            Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(dimType), Map.class);
            TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
            tv.deleteAllNodes();
            TreeNode rootNode = ConstantsHelper.getTreeRootNode((boolean)true, (String)ConstantsHelper.getFuncPerm());
            rootNode.setIsOpened(true);
            tv.addNode(rootNode);
            this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, (Boolean)newValue);
            this.getPageCache().putBigObject("tree_allfunctionperm", SerializationUtils.toJsonString((Object)rootNode));
            String batchAssignFlag = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            Map<String, String> curFuncPerm = assignPermCurInfoMap.get("tree_funcperm");
            if (StringUtils.isNotEmpty((String)batchAssignFlag)) {
                String beanStr = curFuncPerm.get(BATCH_ASSIGN);
                List infos = null;
                if (StringUtils.isNotEmpty((String)beanStr)) {
                    infos = SerializationUtils.fromJsonStringToList((String)beanStr, String.class);
                }
                this.buildFuncPermRightTree(BATCH_ASSIGN, infos);
            } else {
                String[] arr = sourceKey.split("\\|");
                this.initFuncPermRightTree(arr[0], Long.valueOf(arr[1]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (!(source instanceof FormOperate)) {
            return;
        }
        FormOperate op = (FormOperate)source;
        String opKey = op.getOperateKey();
        if ("deleteentry_dim".equals(opKey)) {
            String opName = ResManager.loadKDString((String)"\u5220\u884c", (String)"UserAssignDisFunMultiPlugin_17", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            boolean setCancel = this.checkAdminChargeOrg(this.getView(), opName);
            if (setCancel) {
                e.setCancel(true);
                return;
            }
            List<String> delDimIds = this.getSelectedDimEntry();
            if (CollectionUtils.isEmpty(delDimIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u5220\u9664\u7684\u884c\u3002", (String)"UserAssignDisFunMultiPlugin_18", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            op.getOption().setVariableValue("delDimIds", SerializationUtils.toJsonString(delDimIds));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Object source = e.getSource();
        String operateKey = e.getOperateKey();
        if (source instanceof FormOperate) {
            FormOperate op = (FormOperate)source;
            OperateOption option = op.getOption();
            if ("deleteentry_dim".equals(operateKey) && option.containsVariable("delDimIds")) {
                String delDimIds = option.getVariableValue("delDimIds");
                if (StringUtils.isNotEmpty((String)delDimIds)) {
                    List delDims = (List)SerializationUtils.fromJsonString((String)delDimIds, List.class);
                    this.clearCacheAfterDelDim(delDims);
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addnode", "btn_delnode"});
                EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
                int endIndex = eg.getEntryData().getDataEntitys().length;
                if (endIndex > 0) {
                    eg.addRowClickListener((RowClickEventListener)this);
                    this.clickFirstRow();
                }
            }
        }
    }

    private List<String> getSelectedDimEntry() {
        EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
        int[] selectRows = eg.getSelectRows();
        ArrayList<String> data = new ArrayList<String>(selectRows.length);
        for (int selectRow : selectRows) {
            Long dimId = (Long)this.getModel().getValue(DIMNUM_ID, selectRow);
            data.add(String.valueOf(dimId));
        }
        return data;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        BasedataEdit bd;
        String fieldKey;
        Object source = evt.getSource();
        if (source instanceof BasedataEdit && "user".equals(fieldKey = (bd = (BasedataEdit)source).getFieldKey())) {
            ArrayList<QFilter> qList = new ArrayList<QFilter>(10);
            QFilter qFilter = new QFilter("id", "!=", (Object)1L);
            qList.add(qFilter);
            List robotIds = PermCommonUtil.getRobotIds();
            robotIds.add(RequestContext.get().getCurrUserId());
            qList.add(new QFilter("id", "not in", (Object)robotIds));
            ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
            evt.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
            if (evt.getFormShowParameter() instanceof ListShowParameter) {
                String userQFilterCache = this.getPageCache().get("CustomQFilter_UserIds");
                if (StringUtils.isNotEmpty((String)userQFilterCache)) {
                    QFilter userQFilter = QFilter.fromSerializedString((String)userQFilterCache);
                    qList.add(userQFilter);
                    ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
                    return;
                }
                String customUserIds = this.getPageCache().get("CustomFilter_UserIds");
                if (StringUtils.isNotEmpty((String)customUserIds)) {
                    List strUserIdList = (List)SerializationUtils.fromJsonString((String)customUserIds, List.class);
                    ArrayList<Long> userIdList = new ArrayList<Long>(strUserIdList.size());
                    for (Object strUserId : strUserIdList) {
                        userIdList.add(Long.parseLong(strUserId.toString()));
                    }
                    qList.add(new QFilter("id", "in", userIdList));
                    ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
                }
            }
        }
    }

    private void clearCacheAfterChangeDimTab(String oldDimType) {
        IPageCache pageCache = this.getPageCache();
        pageCache.remove(PGCACHE_LASTENTRYROWCLICK);
        pageCache.removeBigObject("tree_allfunctionperm");
        if (oldDimType != null) {
            pageCache.removeBigObject(oldDimType);
        }
        pageCache.removeBigObject("allPermNodeInfoMap");
    }

    private void clearTreeView() {
        TreeView allFuncPermTree = (TreeView)this.getControl("tree_allfunctionperm");
        allFuncPermTree.deleteAllNodes();
        TreeView funcPermTree = (TreeView)this.getControl("tree_disfunperm");
        funcPermTree.deleteAllNodes();
    }

    private void clearAllSearchMode() {
        Search funcPermSearch = (Search)this.getControl("searchap");
        funcPermSearch.setSearchKey("");
        this.getPageCache().removeBigObject("allFuncPermTreeSearchMode");
        Search disFuncPermSearch = (Search)this.getControl("disfunpermsearchap");
        disFuncPermSearch.setSearchKey("");
        this.getPageCache().removeBigObject("userFuncPermTreeSearchMode");
    }

    private void clearCacheAfterSave() {
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        Set<String> addDimSet = this.assignPermCacheUtil.getAddDimSet();
        Set<String> removeDimSet = this.assignPermCacheUtil.getRemoveDimSet();
        HashMap<String, String> newDataCache = new HashMap<String, String>(16);
        Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        dimDataChangeSet.clear();
        newDataCache.put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
        addDimSet.clear();
        newDataCache.put("addDimSet", SerializationUtils.toJsonString(addDimSet));
        removeDimSet.clear();
        newDataCache.put("removeDimSet", SerializationUtils.toJsonString(removeDimSet));
        HashMap<String, String> temp = new HashMap<String, String>(16);
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        if (!StringUtils.isEmpty((String)sourceKey)) {
            Map<String, String> curPermMap = assignPermCurInfoMap.get("tree_funcperm");
            String[] sourceKeyArr = sourceKey.split(",");
            temp = new HashMap(sourceKeyArr.length);
            for (String rowInfo : sourceKeyArr) {
                temp.put(rowInfo, curPermMap.get(rowInfo));
            }
        }
        Map<String, String> oriPerm = assignPermOriInfoMap.get("tree_funcperm");
        oriPerm.clear();
        Map<String, String> curPerm = assignPermCurInfoMap.get("tree_funcperm");
        curPerm.clear();
        oriPerm.putAll(temp);
        curPerm.putAll(temp);
        this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMap);
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
        this.getPageCache().put(newDataCache);
        this.getModel().setValue("datachangeflag", (Object)false);
        CacheMrg.clearAllCache();
    }

    private void clearCacheAfterDelDim(List<String> delDims) {
        if (CollectionUtils.isEmpty(delDims)) {
            return;
        }
        this.getModel().setValue("datachangeflag", (Object)true);
        String dimType = (String)this.getModel().getValue("dimtype");
        Map userDirectAssignDim = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_DISPERM_INFO), Map.class);
        Map curDimTypeAssignInfo = (Map)userDirectAssignDim.get(dimType);
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        Set<String> addDimSet = this.assignPermCacheUtil.getAddDimSet();
        Map<String, String> emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap();
        Set<String> removeDimSet = this.assignPermCacheUtil.getRemoveDimSet();
        Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        for (String dimId : delDims) {
            String sourceKey = dimType + "|" + dimId;
            emptyDimMap.remove(sourceKey);
            addDimSet.remove(sourceKey);
            dimDataChangeSet.remove(sourceKey);
            removeDimSet.add(sourceKey);
            assignPermOriInfoMap.values().forEach(x -> {
                String cfr_ignored_0 = (String)x.remove(dimType + "|" + dimId);
            });
            assignPermCurInfoMap.values().forEach(x -> {
                String cfr_ignored_0 = (String)x.remove(dimType + "|" + dimId);
            });
            this.getPageCache().removeBigObject(dimType + "|" + dimId);
            curDimTypeAssignInfo.remove(dimId);
        }
        HashMap<String, String> newDataCache = new HashMap<String, String>(16);
        newDataCache.put(PGCACHE_USER_ASSIGN_DISPERM_INFO, SerializationUtils.toJsonString((Object)userDirectAssignDim));
        newDataCache.put("emptyDimMap", SerializationUtils.toJsonString(emptyDimMap));
        newDataCache.put("addDimSet", SerializationUtils.toJsonString(addDimSet));
        newDataCache.put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
        newDataCache.put("removeDimSet", SerializationUtils.toJsonString(removeDimSet));
        this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMap);
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
        this.getPageCache().put(newDataCache);
        this.getPageCache().remove(PGCACHE_LASTENTRYROWCLICK);
        this.clearTreeView();
        this.clearAllSearchMode();
    }

    private String[] getSelectedDimInfo() {
        EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
        int[] selectRows = eg.getSelectRows();
        String dimName = ((DynamicObject)this.getModel().getValue("dimname", selectRows[0])).getString("name");
        String dimTypeName = ((Tab)this.getControl("dimtab")).getCurrentTab().split("\\|")[1];
        return new String[]{dimName, dimTypeName};
    }
}

