/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.user;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.AdminUserCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.DirectAuthorizeHelper;
import kd.bos.permission.cache.helper.FieldPermSchemeHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.query.ChoiceFieldPageCustomQuery;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.AssignPermCacheUtil;
import kd.bos.permission.formplugin.util.FuncPermTreeUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.permission.service.PermissionServiceImpl;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserDirectAssignPermMultiPlugin
extends AbstractFormPlugin
implements IBillPlugin,
TreeNodeQueryListener,
TreeNodeClickListener,
TabSelectListener,
RowClickEventListener,
BeforeF7SelectListener,
BeforeQuickAddNewListener,
SearchEnterListener {
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Perm_UserDirectAssignPermMultiPlugin_Pool", (int)1);
    private static final Log logger = LogFactory.getLog(UserDirectAssignPermMultiPlugin.class);
    private FuncPermTreeUtil funcPermTreeUtil;
    private AssignPermCacheUtil assignPermCacheUtil;
    private static final String VALUE_TRUE = "true";
    private static final String BATCH_ASSIGN = "batchAssign";
    private static final String CLOSECALLBACK_ADDDIM = "closeCallBack_addDim";
    private static final String DIMNUM_ID = "dimnum_id";
    private static final String PGCACHE_LASTENTRYROWCLICK = "lastEntryRowClick";
    private static final String PGCACHE_LASTCLICK_DIMTAB = "lastClickDimTab";
    private static final String PGCACHE_LASTCLICK_PERMTAB = "lastClickPermTab";
    private static final String PGCACHE_LASTCLICK_DATARULETAB = "lastClickDataRuleTab";
    private static final String PGCACHE_LASTCLICK_FIELDTAB = "lastClickFieldTab";
    private static final String PGCACHE_LASTCLICK_DATAPERM_NODE = "lastClickDataPermNode";
    private static final String PGCACHE_LASTCLICK_DATARULE_NODE = "lastClickDataRuleNode";
    private static final String PGCACHE_DIMTABKEYS = "pgcache_dimtabkeys";
    private static final String PGCACHE_USER_ASSIGN_INFO = "pgcache_user_assign_dim_info";
    private static final String PGCACHE_DATARULE = "pgcache_datarule";
    private static final String PGCACHE_BDDATARULE = "pgcache_bddatarule";
    private static final String PGCACHE_BATCH_ASSIGN = "batchAssignFlag";
    private boolean hasEnableOldDataRule;

    public void preOpenForm(PreOpenFormEventArgs e) {
        String showFormSpecial = (String)e.getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if (VALUE_TRUE.equals(showFormSpecial)) {
            return;
        }
        String unableShowInfo = (String)e.getFormShowParameter().getCustomParam("formShowParm_show_unableInfo");
        if (StringUtils.isNotEmpty((String)unableShowInfo)) {
            e.setCancel(true);
            e.setCancelMessage(unableShowInfo);
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        if (!PermissionServiceHelper.isAdminUser((long)userId) && !PermFormCommonUtil.isAdminPartnerUser(userId)) {
            e.setCancel(true);
            e.setCancelMessage(ConstantsHelper.getAdminCannotUseDesc());
        }
    }

    public void initialize() {
        super.initialize();
        this.funcPermTreeUtil = new FuncPermTreeUtil(this.getPageCache());
        this.assignPermCacheUtil = new AssignPermCacheUtil(this.getPageCache());
        this.hasEnableOldDataRule = PermCommonUtil.hasEnableOldDataRule();
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType originalEntityType = e.getOriginalEntityType();
        HashMap<String, String> entryFieldMap = new HashMap<String, String>(8);
        entryFieldMap.put("dim_entry", "entitydimtype");
        MainEntityType newEntityType = PermCommonUtil.getNewEntityType((MainEntityType)originalEntityType, entryFieldMap);
        e.setNewEntityType(newEntityType);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab dimTab = (Tab)this.getControl("dimtab");
        dimTab.addTabSelectListener((TabSelectListener)this);
        Tab permTab = (Tab)this.getControl("tabap");
        permTab.addTabSelectListener((TabSelectListener)this);
        Tab dataRuleTab = (Tab)this.getControl("tab_datarule");
        dataRuleTab.addTabSelectListener((TabSelectListener)this);
        Tab fieldTab = (Tab)this.getControl("tab_fieldperm");
        fieldTab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"btn_addnode", "btn_delnode", "adddimtab", "deldimtab"});
        this.addItemClickListeners(new String[]{"tbmain", "toolbar_dim"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("dim_entry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGridSensitiveFps = (EntryGrid)this.getControl("entryentity_fps_sensitive");
        entryGridSensitiveFps.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGridFps = (EntryGrid)this.getControl("entryentity_fps");
        entryGridFps.addRowClickListener((RowClickEventListener)this);
        TreeView allFuncPermTv = (TreeView)this.getControl("tree_allfunctionperm");
        allFuncPermTv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        TreeView funcPermTv = (TreeView)this.getControl("tree_funcperm");
        funcPermTv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        TreeView fieldPermTv = (TreeView)this.getControl("tree_fieldperm");
        fieldPermTv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        fieldPermTv.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView dataPermTv = (TreeView)this.getControl("tree_dataperm");
        dataPermTv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        dataPermTv.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView dataRuleTv = (TreeView)this.getControl("tree_datarule");
        dataRuleTv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        dataRuleTv.addTreeNodeClickListener((TreeNodeClickListener)this);
        BasedataEdit userEdit = (BasedataEdit)this.getControl("user");
        userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit permItemBdEdit = (BasedataEdit)this.getControl("permitem");
        permItemBdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataRuleBdEdit = (BasedataEdit)this.getControl("datarule");
        dataRuleBdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        dataRuleBdEdit.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        BasedataEdit bdDataRuleBdEdit = (BasedataEdit)this.getControl("bddatarule");
        bdDataRuleBdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        bdDataRuleBdEdit.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        Search funcPermSearch = (Search)this.getControl("searchap");
        funcPermSearch.addEnterListener((SearchEnterListener)this);
        Search userFuncPermSearch = (Search)this.getControl("userfuncpermsearchap");
        userFuncPermSearch.addEnterListener((SearchEnterListener)this);
        Search fieldPermSearch = (Search)this.getControl("fieldpermsearchap");
        fieldPermSearch.addEnterListener((SearchEnterListener)this);
        Search dataPermSearch = (Search)this.getControl("datapermsearchap");
        dataPermSearch.addEnterListener((SearchEnterListener)this);
        Search dataRuleSearch = (Search)this.getControl("datarulesearchap");
        dataRuleSearch.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        OperationStatus status;
        Long userId = this.loadUserInfo();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String filterAppNumCache = (String)fsp.getCustomParam("FormShowParam_appNum");
        if (!StringUtils.isEmpty((String)filterAppNumCache)) {
            this.getPageCache().put("FormShowParam_appNum", filterAppNumCache);
        }
        if (OperationStatus.EDIT.equals((Object)(status = fsp.getStatus()))) {
            UserHelper.addEditingPermUserId((List)Lists.newArrayList((Object[])new String[]{userId + ""}));
        }
        this.loadAdminInfo();
        this.notifyTooMuchAssignPerm(userId);
        if (!this.hasEnableOldDataRule) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tab_perm_dataperm"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tab_perm_datarule"});
        }
        ItemClassTypeEdit selectDimTypeFields = (ItemClassTypeEdit)this.getControl("dimtype");
        PermCommonUtil.buildDimTypeItemClassType((ItemClassTypeEdit)selectDimTypeFields);
        this.initDimTab();
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addnode", "btn_delnode"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"filtergrid_dataperm", "tab_datarule", "tab_fieldperm"});
    }

    private void loadAdminInfo() {
        String showFormSpecial = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if (!VALUE_TRUE.equals(showFormSpecial)) {
            Map adminSysPerm;
            boolean enableSysAuthority;
            Long adminUserId = RequestContext.get().getCurrUserId();
            List adminChargeApps = PermissionServiceHelper.getAdminChargeApps((Long)adminUserId);
            if (adminChargeApps != null && !adminChargeApps.isEmpty()) {
                this.getPageCache().put("pageCache_adminChargeApp", SerializationUtils.toJsonString((Object)adminChargeApps));
            }
            if ((enableSysAuthority = PermCommonUtil.isEnableSysAuthority()) && !CollectionUtils.isEmpty((Map)(adminSysPerm = AdminPermCache.getAdminSysPerm((Long)adminUserId)))) {
                this.getPageCache().putBigObject("pageCache_adminSysPerm", SerializationUtils.toJsonString((Object)adminSysPerm));
            }
        }
    }

    private long loadUserInfo() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        long userId = 0L;
        String strUserId = (String)fsp.getCustomParam("paramUserId");
        if (StringUtils.isEmpty((String)strUserId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6388\u6743\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u9009\u62e9\u9700\u8981\u6388\u6743\u7684\u7528\u6237\u3002", (String)"UserDirectAssignPermMultiPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put("paramUserId", strUserId);
            userId = Long.parseLong(strUserId);
        }
        this.getModel().setValue("user", (Object)userId);
        String showForSpecialUser = (String)fsp.getCustomParam("FormShowParam_ShowForSpecialUser");
        if (VALUE_TRUE.equals(showForSpecialUser)) {
            this.getPageCache().put("FormShowParam_ShowForSpecialUser", VALUE_TRUE);
        }
        return userId;
    }

    private void notifyTooMuchAssignPerm(Long userId) {
        int assignPermCount = DirectAuthorizeHelper.queryDirectAssignPermSize((Long)userId);
        if (assignPermCount > 400000) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u88ab\u6388\u6743\u7528\u6237\u5206\u914d\u4e86\u592a\u591a\u6743\u9650\u6570\u636e\uff0c\u4f1a\u6709\u8f83\u5dee\u6027\u80fd\u4f53\u9a8c\uff0c\u5efa\u8bae\u5220\u53bb\u6b64\u5904\u5206\u914d\uff0c\u6362\u7528\u89d2\u8272\u6388\u6743\u6216\u5168\u529f\u80fd\u7528\u6237\u3002", (String)"UserDirectAssignPermMultiPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
    }

    private void initDimTab() {
        Tab tab = (Tab)this.getControl("dimtab");
        ArrayList<String> allTabKeys = new ArrayList<String>(10);
        Long userId = (Long)this.getModel().getValue("user_id");
        Map userDirectAssignDimOriMap = DirectAuthorizeHelper.getUserDirectAssignPermDim((Long)userId);
        Map curValidEntPermCtrlTypeMap = IsoDimHelper.getEntPermCtrlTypeMap((PermCtrlTypeReq)new PermCtrlTypeReq((Set)Sets.newHashSet((Object[])new String[]{"1"}), null, null, null, null));
        HashMap<String, Map> userDirectAssignDim = new HashMap<String, Map>(8);
        for (Map.Entry userDirectAssignDimOri : userDirectAssignDimOriMap.entrySet()) {
            String key = (String)userDirectAssignDimOri.getKey();
            Map value = (Map)userDirectAssignDimOri.getValue();
            if (!curValidEntPermCtrlTypeMap.containsKey(key)) continue;
            userDirectAssignDim.put(key, value);
        }
        boolean isSingleOrg = PermCommonUtil.isSingleOrg();
        if (isSingleOrg) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        }
        HashMap<String, String> newDataMap = new HashMap<String, String>(16);
        ArrayList<Map> items = new ArrayList<Map>(10);
        if (userDirectAssignDim.isEmpty()) {
            long rootOrgId;
            DynamicObject rootOrg;
            TabPageAp tabPageAp = new TabPageAp();
            DynamicObject orgDimType = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_ctrltype", (String)"id,name,bizobjectid", (QFilter[])new QFilter[]{new QFilter("bizobjectid", "=", (Object)"bos_org")});
            String number = orgDimType.getString("bizobjectid.number");
            String name = orgDimType.getString("name");
            tabPageAp.setKey(number + "|" + name);
            tabPageAp.setName(new LocaleString(name));
            items.add(tabPageAp.createControl());
            allTabKeys.add(number + "|" + name);
            LinkedHashMap<String, String> dimInfo = new LinkedHashMap<String, String>(16);
            if (isSingleOrg && (rootOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)(rootOrgId = OrgUnitServiceHelper.getRootOrgId()), (String)"bos_org", (String)"id,number,name")) != null) {
                String dimNumber = rootOrg.getString("number");
                String dimName = rootOrg.getString("name");
                String dimPermInfo = String.join((CharSequence)",", String.valueOf(rootOrgId), "0", "0", " ", " ", " ");
                dimInfo.put(String.valueOf(rootOrgId), dimPermInfo);
                Set<String> addDimSet = this.assignPermCacheUtil.getAddDimSet();
                Map<String, String> emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap();
                Map<String, String> dimInfoMap = this.assignPermCacheUtil.getDimInfoMap();
                String sourceKey = number + "|" + rootOrgId;
                addDimSet.add(sourceKey);
                emptyDimMap.put(sourceKey, name + "," + dimName);
                dimInfoMap.put(sourceKey, dimNumber + "," + dimName);
                newDataMap.put("addDimSet", SerializationUtils.toJsonString(addDimSet));
                newDataMap.put("emptyDimMap", SerializationUtils.toJsonString(emptyDimMap));
                newDataMap.put("dimInfoMap", SerializationUtils.toJsonString(dimInfoMap));
            }
            userDirectAssignDim.put(number, dimInfo);
        } else {
            Set dimKeys = userDirectAssignDim.keySet();
            PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq(null, null, null, null, dimKeys);
            List ctrlTypeList = IsoDimHelper.getPermCtrlTypeList((PermCtrlTypeReq)permCtrlTypeReq);
            for (PermCtrlType permCtrlType : ctrlTypeList) {
                String number = permCtrlType.getBizobjectid();
                String name = permCtrlType.getName();
                TabPageAp tabPageAp = new TabPageAp();
                tabPageAp.setKey(number + "|" + name);
                tabPageAp.setName(new LocaleString(name));
                items.add(tabPageAp.createControl());
                allTabKeys.add(number + "|" + name);
            }
        }
        tab.addControls(items);
        newDataMap.put(PGCACHE_DIMTABKEYS, SerializationUtils.toJsonString(allTabKeys));
        newDataMap.put(PGCACHE_USER_ASSIGN_INFO, SerializationUtils.toJsonString(userDirectAssignDim));
        this.getPageCache().put(newDataMap);
        int size = allTabKeys.size();
        if (size > 0) {
            String lastClickTab = this.getPageCache().get(PGCACHE_LASTCLICK_DIMTAB);
            if (StringUtils.isEmpty((String)lastClickTab)) {
                lastClickTab = (String)allTabKeys.get(0);
            }
            tab.selectTab(lastClickTab);
            tab.activeTab(lastClickTab);
        }
    }

    public void tabSelected(TabSelectEvent e) {
        String tabKey = e.getTabKey();
        if (tabKey.startsWith("tab_perm_")) {
            this.permTabSelected(tabKey);
        } else if (tabKey.startsWith("tabpage_")) {
            this.dataRuleTabSelected(tabKey);
        } else if (tabKey.startsWith("tab_fp_")) {
            this.fieldTabSelected(tabKey);
        } else {
            String lastTabKey = this.getPageCache().get(PGCACHE_LASTCLICK_DIMTAB);
            if (tabKey.equals(lastTabKey)) {
                return;
            }
            this.dimTabSelected(tabKey);
        }
    }

    private void dataRuleTabSelected(String tabKey) {
        this.getPageCache().put(PGCACHE_LASTCLICK_DATARULETAB, tabKey);
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        String nodeId = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        Map<String, String> curDataRule = assignPermCurInfoMap.get("tree_datarule");
        String dimCurDataRuleStr = curDataRule.get(sourceKey);
        if (StringUtils.isEmpty((String)dimCurDataRuleStr)) {
            return;
        }
        Map dimCurDataRuleMap = (Map)SerializationUtils.fromJsonString((String)dimCurDataRuleStr, Map.class);
        Map curNodeSetting = (Map)dimCurDataRuleMap.get(nodeId);
        if (CollectionUtils.isEmpty((Map)curNodeSetting)) {
            return;
        }
        String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
        String entityNum = nodeInfoArr[1];
        if ("tabpage_datarule".equals(tabKey)) {
            this.getModel().deleteEntryData("datarule_entry");
            Map dataRuleSetting = (Map)curNodeSetting.get(PGCACHE_DATARULE);
            if (!CollectionUtils.isEmpty((Map)dataRuleSetting)) {
                IDataModel dataModel = this.getModel();
                dataModel.beginInit();
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("permitem", new Object[0]);
                vs.addField("datarule", new Object[0]);
                for (Map.Entry entry : dataRuleSetting.entrySet()) {
                    String value = (String)entry.getValue();
                    if (StringUtils.isEmpty((String)value)) {
                        vs.addRow(new Object[]{entry.getKey(), null});
                        continue;
                    }
                    vs.addRow(new Object[]{entry.getKey(), Long.valueOf((String)entry.getValue())});
                }
                ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("datarule_entry", vs);
                dataModel.endInit();
                this.getView().updateView("datarule_entry");
            }
            this.getModel().deleteEntryData("bddatarule_entry");
            this.getView().updateView("bddatarule_entry");
        } else if ("tabpage_bddatarule".equals(tabKey)) {
            Map<String, Map<String, String>> entityFieldNameMap = this.funcPermTreeUtil.getEntityFieldNameMap();
            Map<String, String> fieldNameMap = entityFieldNameMap.get(entityNum);
            if (fieldNameMap == null) {
                fieldNameMap = this.getEntityFieldNameInfo(entityNum);
                entityFieldNameMap.put(entityNum, fieldNameMap);
                this.getPageCache().putBigObject("entityFieldNameMap", SerializationUtils.toJsonString(entityFieldNameMap));
            }
            this.getModel().deleteEntryData("bddatarule_entry");
            Map bdDataRuleSetting = (Map)curNodeSetting.get(PGCACHE_BDDATARULE);
            if (!CollectionUtils.isEmpty((Map)bdDataRuleSetting)) {
                IDataModel dataModel = this.getModel();
                dataModel.beginInit();
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("bdpropkey", new Object[0]);
                vs.addField("bdpropname", new Object[0]);
                vs.addField("bdentity", new Object[0]);
                vs.addField("bddatarule", new Object[0]);
                for (Map.Entry entry : bdDataRuleSetting.entrySet()) {
                    String value = (String)entry.getValue();
                    String[] arr = value.split("\\|");
                    String propKey = arr[0];
                    String propEntity = arr[1];
                    Long dataRuleId = null;
                    String dataRuleIdStr = arr[2];
                    if (StringUtils.isNotEmpty((String)dataRuleIdStr)) {
                        dataRuleId = Long.valueOf(dataRuleIdStr);
                    }
                    String bdPropName = fieldNameMap.get(propKey);
                    vs.addRow(new Object[]{propKey, bdPropName, propEntity, dataRuleId});
                }
                ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("bddatarule_entry", vs);
                dataModel.endInit();
                this.getView().updateView("bddatarule_entry");
            }
            this.getModel().deleteEntryData("datarule_entry");
            this.getView().updateView("datarule_entry");
        }
    }

    private void fieldTabSelected(String tabKey) {
        this.getPageCache().put(PGCACHE_LASTCLICK_FIELDTAB, tabKey);
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        String nodeId = this.getPageCache().get("lastClickFieldPermNode");
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        Map<String, String> curFP = assignPermCurInfoMap.get("tree_fieldperm");
        String dimCurFpsStr = curFP.get(sourceKey);
        if (StringUtils.isEmpty((String)dimCurFpsStr)) {
            return;
        }
        Map dimCurFpsMap = (Map)SerializationUtils.fromJsonString((String)dimCurFpsStr, Map.class);
        Map nodeFieldPerm = (Map)dimCurFpsMap.get(nodeId);
        if (CollectionUtils.isEmpty((Map)nodeFieldPerm)) {
            return;
        }
        if ("tab_fp_scheme".equals(tabKey)) {
            this.fieldTabSelectLoadFps("entryentity_fps", nodeFieldPerm, "pgcache_fps", "fps");
        } else if ("tab_fp_sensitive".equals(tabKey)) {
            this.fieldTabSelectLoadFps("entryentity_fps_sensitive", nodeFieldPerm, "pgcache_fpssensitive", "fps_sensitive");
        } else if ("tab_fp_detail".equals(tabKey)) {
            Map fpTypeFieldPerm = nodeFieldPerm.computeIfAbsent("pgcache_fieldpermdetail", k -> new LinkedHashMap(16));
            if (CollectionUtils.isEmpty((Map)fpTypeFieldPerm)) {
                return;
            }
            String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
            String entityNum = nodeInfoArr[1];
            Map<String, Map<String, String>> entityFieldNameMap = this.funcPermTreeUtil.getEntityFieldNameMap();
            Map<String, String> fieldNameMap = entityFieldNameMap.get(entityNum);
            this.fillFP_fieldpermdetailToPage(fpTypeFieldPerm, fieldNameMap);
        }
    }

    private void fieldTabSelectLoadFps(String entryentityFps, Map<String, Map<String, String>> nodeFieldPerm, String pgcacheFps, String entrypropFps) {
        this.getModel().deleteEntryData(entryentityFps);
        Map<String, String> fpsSetting = nodeFieldPerm.get(pgcacheFps);
        if (!CollectionUtils.isEmpty(fpsSetting)) {
            IDataModel dataModel = this.getModel();
            dataModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(entrypropFps, new Object[0]);
            for (Map.Entry<String, String> entry : fpsSetting.entrySet()) {
                String value = entry.getValue();
                if (StringUtils.isEmpty((String)value)) continue;
                vs.addRow(new Object[]{Long.valueOf(value)});
            }
            ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow(entryentityFps, vs);
            dataModel.endInit();
            this.getView().updateView(entryentityFps);
        }
    }

    private void permTabSelected(String tabKey) {
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        this.needUpdateDataPermPageCache(null, assignPermCurInfoMap);
        String lastPermTabKey = this.getPageCache().get(PGCACHE_LASTCLICK_PERMTAB);
        if (tabKey.equals(lastPermTabKey)) {
            return;
        }
        this.getPageCache().put(PGCACHE_LASTCLICK_PERMTAB, tabKey);
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        if (sourceKey == null) {
            return;
        }
        String batchAssignFlag = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
        switch (tabKey) {
            case "tab_perm_funcperm": {
                this.clearAllSearchMode();
                this.getPageCache().remove(PGCACHE_LASTCLICK_DATAPERM_NODE);
                TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
                String dimType = (String)this.getModel().getValue("dimtype");
                boolean showNum = (Boolean)this.getModel().getValue("shownum");
                this.funcPermTreeUtil.initFuncPermLeftTree(tv, dimType, showNum);
                if (StringUtils.isEmpty((String)batchAssignFlag)) {
                    String[] arr = sourceKey.split("\\|");
                    this.initFuncPermRightTree(null, null, arr[0], Long.valueOf(arr[1]));
                    this.getView().setEnable(Boolean.TRUE, new String[]{"btn_addnode", "btn_delnode"});
                    break;
                }
                this.buildFuncPermRightTree(BATCH_ASSIGN, null);
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_addnode"});
                break;
            }
            case "tab_perm_fieldperm": {
                this.getPageCache().remove(PGCACHE_LASTCLICK_DATAPERM_NODE);
                if (StringUtils.isEmpty((String)batchAssignFlag)) {
                    boolean setup = (Boolean)this.getModel().getValue("fieldpermsetup");
                    if (setup) {
                        this.getModel().setValue("fieldpermsetup", (Object)false);
                        break;
                    }
                    String[] sourceKeyInfo = sourceKey.split("\\|");
                    String dimTypeStr = sourceKeyInfo[0];
                    String dimIdStr = sourceKeyInfo[1];
                    String hasLoadFieldPermTreeFlagKey = "hasLoadFieldPermTree_" + dimTypeStr + "_" + dimIdStr;
                    String hasLoadDataRuleTree = this.getPageCache().get(hasLoadFieldPermTreeFlagKey);
                    if (!StringUtils.isEmpty((String)hasLoadDataRuleTree) && Objects.equals("1", hasLoadDataRuleTree)) break;
                    this.initFieldPermTree(dimTypeStr, Long.valueOf(dimIdStr));
                    this.getPageCache().put(hasLoadFieldPermTreeFlagKey, "1");
                    break;
                }
                EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
                if (null == eg || 0 == eg.getSelectRows().length) {
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5b57\u6bb5\u6743\u9650\u201d\u9875\u7b7e\u6682\u4e0d\u652f\u6301\u6279\u91cf\u6388\u6743\u3002", (String)"UserDirectAssignPermMultiPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                break;
            }
            case "tab_perm_dataperm": {
                this.getPageCache().remove("lastClickFieldPermNode");
                this.getPageCache().remove(PGCACHE_LASTCLICK_DATARULE_NODE);
                if (StringUtils.isEmpty((String)batchAssignFlag)) {
                    boolean setup = (Boolean)this.getModel().getValue("datapermsetup");
                    if (setup) {
                        this.getModel().setValue("datapermsetup", (Object)false);
                        break;
                    }
                    String[] sourceKeyInfo = sourceKey.split("\\|");
                    this.initDataPermTree(sourceKeyInfo[0], Long.valueOf(sourceKeyInfo[1]));
                    break;
                }
                EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
                if (null == eg || 0 == eg.getSelectRows().length) {
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6570\u636e\u89c4\u5219\u201d\u9875\u7b7e\u6682\u4e0d\u652f\u6301\u6279\u91cf\u6388\u6743\u3002", (String)"UserDirectAssignPermMultiPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                break;
            }
            case "tab_perm_datarule": {
                this.getPageCache().remove(PGCACHE_LASTCLICK_DATAPERM_NODE);
                if (StringUtils.isEmpty((String)batchAssignFlag)) {
                    boolean setup = (Boolean)this.getModel().getValue("datarulesetup");
                    if (setup) {
                        this.getModel().setValue("datarulesetup", (Object)false);
                        break;
                    }
                    String[] sourceKeyInfo = sourceKey.split("\\|");
                    String dimTypeStr = sourceKeyInfo[0];
                    String dimIdStr = sourceKeyInfo[1];
                    String hasLoadDataRuleTreeFlagKey = "hasLoadDataRuleTree_" + dimTypeStr + "_" + dimIdStr;
                    String hasLoadDataRuleTree = this.getPageCache().get(hasLoadDataRuleTreeFlagKey);
                    if (!StringUtils.isEmpty((String)hasLoadDataRuleTree) && Objects.equals("1", hasLoadDataRuleTree)) break;
                    this.initDataRuleTree(dimTypeStr, Long.valueOf(dimIdStr));
                    this.getPageCache().put(hasLoadDataRuleTreeFlagKey, "1");
                    break;
                }
                EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
                if (null == eg || 0 == eg.getSelectRows().length) {
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6570\u636e\u89c4\u5219\u201d\u9875\u7b7e\u6682\u4e0d\u652f\u6301\u6279\u91cf\u6388\u6743\u3002", (String)"UserDirectAssignPermMultiPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
    }

    private void clearCacheAfterChangeDimTab(String oldDimType) {
        IPageCache pageCache = this.getPageCache();
        pageCache.remove(PGCACHE_LASTENTRYROWCLICK);
        pageCache.remove("lastClickFieldPermNode");
        pageCache.remove(PGCACHE_LASTCLICK_DATAPERM_NODE);
        pageCache.remove(PGCACHE_LASTCLICK_DATARULE_NODE);
        pageCache.removeBigObject("tree_allfunctionperm");
        if (oldDimType != null) {
            pageCache.removeBigObject(oldDimType);
        }
        pageCache.removeBigObject("allPermNodeInfoMap");
    }

    private void clearAllSearchMode() {
        Search funcPermSearch = (Search)this.getControl("searchap");
        funcPermSearch.setSearchKey("");
        this.getPageCache().removeBigObject("allFuncPermTreeSearchMode");
        Search userFuncPermSearch = (Search)this.getControl("userfuncpermsearchap");
        userFuncPermSearch.setSearchKey("");
        this.getPageCache().removeBigObject("userFuncPermTreeSearchMode");
        Search fieldPermSearch = (Search)this.getControl("fieldpermsearchap");
        fieldPermSearch.setSearchKey("");
        this.getPageCache().removeBigObject("fieldPermTreeSearchMode");
        Search dataPermSearch = (Search)this.getControl("datapermsearchap");
        dataPermSearch.setSearchKey("");
        this.getPageCache().removeBigObject("dataPermTreeSearchMode");
        Search dataRuleSearch = (Search)this.getControl("datarulesearchap");
        dataRuleSearch.setSearchKey("");
        this.getPageCache().removeBigObject("dataRuleTreeSearchMode");
    }

    private void dimTabSelected(String tabKey) {
        this.getPageCache().put(PGCACHE_LASTCLICK_DIMTAB, tabKey);
        String[] tabInfo = tabKey.split("\\|");
        String curDimType = tabInfo[0];
        String oldDimType = (String)this.getModel().getValue("dimtype");
        this.getModel().setValue("dimtype", (Object)curDimType);
        if (!"bos_org".equals(curDimType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"includesuborg"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"includesuborg"});
        }
        this.loadDimEntryData(oldDimType, curDimType);
        this.clickFirstRow();
    }

    private void clickFirstRow() {
        EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
        int entryCount = this.getModel().getEntryRowCount("dim_entry");
        if (entryCount > 0) {
            eg.selectRows(0);
            eg.getEntryState().selectRow(0);
            eg.getEntryState().setFocusRow(0);
            eg.entryRowClick(Integer.valueOf(0));
        }
    }

    private void loadDimEntryData(String oldDimType, String dimType) {
        this.clearTreeViewAndEntry();
        this.clearAllSearchMode();
        this.clearCacheAfterChangeDimTab(oldDimType);
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("dim_entry");
        Map dimAssignInfo = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_INFO), Map.class);
        Map curDimInfo = (Map)dimAssignInfo.get(dimType);
        if (!CollectionUtils.isEmpty((Map)curDimInfo)) {
            HasPermOrgResult adminChargeOrgAndBizUnit;
            long currUserId;
            Set dimIdStr = curDimInfo.keySet();
            List assignDims = dimIdStr.stream().map(Long::valueOf).collect(Collectors.toList());
            if (dimType.contains("bos_org") && PermCommonUtil.isEnableJustShowAdminCharged() && AdminUserCache.isAdminUser((String)((currUserId = RequestContext.get().getCurrUserId()) + "")) && !(adminChargeOrgAndBizUnit = new PermissionServiceImpl().getAdminChargeOrgAndBizUnit(Long.valueOf(currUserId))).hasAllOrgPerm()) {
                List hasPermOrgs = adminChargeOrgAndBizUnit.getHasPermOrgs();
                assignDims.removeIf(k -> !hasPermOrgs.contains(k));
            }
            Map dimMap = IsoDimHelper.getDimMap(assignDims, (String)dimType);
            Map<String, String> dimInfoMap = this.assignPermCacheUtil.getDimInfoMap();
            dataModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("dimnum", new Object[0]);
            vs.addField("dimname", new Object[0]);
            vs.addField("entitydimtype", new Object[0]);
            vs.addField("includesuborg", new Object[0]);
            for (Map.Entry entry : curDimInfo.entrySet()) {
                Long dimId = Long.valueOf((String)entry.getKey());
                String[] dimInfo = ((String)entry.getValue()).split(",");
                Dim dim = (Dim)dimMap.get(dimId);
                if (null == dim) continue;
                String dimName = dim.getDimName();
                String dimNumber = dim.getDimNumber();
                dimInfoMap.put(dimType + "|" + dimId, dimNumber + "," + dimName);
                String includeSubStr = dimInfo[1];
                boolean includeSub = "1".equals(includeSubStr);
                vs.addRow(new Object[]{dimId, dimId, dimType, includeSub});
            }
            ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("dim_entry", vs);
            dataModel.endInit();
            this.getPageCache().put("dimInfoMap", SerializationUtils.toJsonString(dimInfoMap));
            this.getView().updateView("dim_entry");
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addnode", "btn_delnode"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("baritem_save".equals(itemKey)) {
            DynamicObject user = (DynamicObject)this.getModel().getValue("user");
            if (null != user && !Objects.equals(0L, user.getLong("id"))) {
                PermCommonUtil.checkUserEnable((Long)user.getLong("id"), (String)ResManager.loadKDString((String)"\u8be5\u7528\u6237\u4f7f\u7528\u72b6\u6001\u5df2\u88ab\u7981\u7528\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"UserGroupTreeListPlugin_47", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
            this.needUpdateDataPermPageCache(null, null);
            this.save();
        } else if ("baritem_dim_add".equals(itemKey)) {
            this.showDimF7();
        }
    }

    private void showDimF7() {
        String dimType = (String)this.getModel().getValue("dimtype");
        if (StringUtils.isEmpty((String)dimType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u201c\u6743\u9650\u63a7\u5236\u7c7b\u578b\u201d\u9875\u7b7e\u3002", (String)"UserDirectAssignPermMultiPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
        DynamicObject[] col = eg.getEntryData().getDataEntitys();
        ArrayList<Long> existDimIds = new ArrayList<Long>(col.length);
        for (DynamicObject o : col) {
            existDimIds.add(o.getLong(DIMNUM_ID));
        }
        ListShowParameter listForm = ShowFormHelper.createShowListForm((String)dimType, (boolean)true);
        ListFilterParameter listFilter = new ListFilterParameter();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (!CollectionUtils.isEmpty(existDimIds)) {
            filters.add(new QFilter("id", "not in", existDimIds));
        }
        String noAdminChargeOrgFilterParam = this.getPageCache().get("NoAdminChargeOrgFilter");
        if ("bos_org".equals(dimType)) {
            listForm.setF7ClickByFilter(true);
            List<QFilter> customerFilter = this.getCustomerFilter();
            filters.addAll(customerFilter);
            if (StringUtils.isEmpty((String)noAdminChargeOrgFilterParam)) {
                listForm.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
                listForm.setCustomParam("showAdminOrgViewType", (Object)Boolean.TRUE);
            }
        }
        listFilter.setQFilters(filters);
        listForm.setListFilterParameter(listFilter);
        listForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_ADDDIM));
        this.getView().showForm((FormShowParameter)listForm);
    }

    private List<QFilter> getCustomerFilter() {
        String dimObjQFilterCache = this.getPageCache().get("CustomQFilter_DimObjIds");
        if (StringUtils.isNotEmpty((String)dimObjQFilterCache)) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            QFilter dimObjQFilter = QFilter.fromSerializedString((String)dimObjQFilterCache);
            filterList.add(dimObjQFilter);
            return filterList;
        }
        String customDimObjIds = this.getPageCache().get("CustomFilter_OrgIds");
        if (StringUtils.isEmpty((String)customDimObjIds)) {
            customDimObjIds = this.getPageCache().get("CustomFilter_DimObjIds");
        }
        if (StringUtils.isNotEmpty((String)customDimObjIds)) {
            List strDimObjIdList = (List)SerializationUtils.fromJsonString((String)customDimObjIds, List.class);
            ArrayList<Long> dimObjIdList = new ArrayList<Long>(strDimObjIdList.size());
            for (Object strDimObjId : strDimObjIdList) {
                dimObjIdList.add(Long.parseLong(strDimObjId.toString()));
            }
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            if (dimObjIdList.size() > 0) {
                filterList.add(new QFilter("id", "in", dimObjIdList));
                return filterList;
            }
        }
        List<String> filterDimObjStrIds = this.getDimObjIdsFromFsp();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (!CollectionUtils.isEmpty(filterDimObjStrIds)) {
            List filterDimObjIds = filterDimObjStrIds.stream().map(Long::valueOf).collect(Collectors.toList());
            filterList.add(new QFilter("id", "in", filterDimObjIds));
            return filterList;
        }
        return filterList;
    }

    public List<String> getDimObjIdsFromFsp() {
        ArrayList<String> resultList = new ArrayList<String>();
        String dimObjIds = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimensionObjIds");
        if (StringUtils.isNotEmpty((String)dimObjIds)) {
            String[] arrDimObjId;
            for (String dimObjId : arrDimObjId = dimObjIds.split(",")) {
                if (StringUtils.isEmpty((String)dimObjId)) continue;
                dimObjId = dimObjId.trim();
                resultList.add(dimObjId);
            }
        }
        return resultList;
    }

    protected void save() {
        Map<String, Map<String, Map<String, String>>> dataRuleSettingErrorMap;
        Object values;
        Iterator<String> iterator;
        Map<String, String> emptyDimMap;
        boolean singleOrg = PermCommonUtil.isSingleOrg();
        if (!singleOrg && !(emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap()).isEmpty() && (iterator = (values = emptyDimMap.values()).iterator()).hasNext()) {
            String dimInfo = iterator.next();
            String[] arr = dimInfo.split(",");
            String dimTypeName = arr[0];
            String dimName = arr[1];
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u672a\u5206\u914d\u529f\u80fd\u6743\u9650\u3002", (String)"UserDirectAssignPermMultiPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]), dimTypeName, dimName), Integer.valueOf(3000));
            return;
        }
        Map<String, Map<String, String>> dataPermSettingErrorMap = this.assignPermCacheUtil.getDataPermSettingErrorMap();
        if (!dataPermSettingErrorMap.isEmpty()) {
            for (Map.Entry entry : dataPermSettingErrorMap.entrySet()) {
                Map errorSetting = (Map)entry.getValue();
                Collection values2 = errorSetting.values();
                Iterator iterator2 = values2.iterator();
                if (!iterator2.hasNext()) continue;
                String errorInfo = (String)iterator2.next();
                String[] arr = errorInfo.split("\\|");
                String dimTypeName = arr[0];
                String dimName = arr[1];
                String entityName = arr[2];
                String message = arr[3];
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\uff0c\u6388\u6743\u5bf9\u8c61\uff1a\u201d%3$s\u201c\uff0c\u201c\u6570\u636e\u89c4\u5219\u201d\u914d\u7f6e\u5b58\u5728\u5f02\u5e38\uff1a%4$s", (String)"UserDirectAssignPermMultiPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]), dimTypeName, dimName, entityName, message), Integer.valueOf(4000));
                return;
            }
        }
        if (!(dataRuleSettingErrorMap = this.assignPermCacheUtil.getDataRuleSettingErrorMap()).isEmpty()) {
            Map<String, String> map = this.funcPermTreeUtil.getEntityNumNameMap();
            Map<String, String> permItemIdNameMap = this.funcPermTreeUtil.getPermItemIdNameMap();
            for (Map.Entry<String, Map<String, Map<String, String>>> entry : dataRuleSettingErrorMap.entrySet()) {
                Collection<String> values3;
                Iterator<String> iterator3;
                Collection<String> values4;
                Iterator<String> iterator4;
                Map<String, Map<String, String>> dimErrorSetting = entry.getValue();
                Map<String, String> dataRuleError = dimErrorSetting.get(PGCACHE_DATARULE);
                if (!CollectionUtils.isEmpty(dataRuleError) && (iterator4 = (values4 = dataRuleError.values()).iterator()).hasNext()) {
                    String errorInfo = iterator4.next();
                    String[] arr = errorInfo.split("\\|");
                    String dimTypeName = arr[0];
                    String dimName = arr[1];
                    String entityName = map.get(arr[2]);
                    String permItemName = permItemIdNameMap.get(arr[3]);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\uff0c\u6388\u6743\u5bf9\u8c61\uff1a\u201d%3$s\u201c\uff0c\u6570\u636e\u89c4\u5219\u7684\u201c%4$s\u201d\u6743\u9650\u9879\u672a\u914d\u7f6e\u6570\u636e\u89c4\u5219\u65b9\u6848\u3002", (String)"UserDirectAssignPermMultiPlugin_8", (String)"bos-permission-formplugin", (Object[])new Object[0]), dimTypeName, dimName, entityName, permItemName), Integer.valueOf(4000));
                    return;
                }
                Map<String, String> bdDataRuleError = dimErrorSetting.get(PGCACHE_BDDATARULE);
                if (CollectionUtils.isEmpty(bdDataRuleError) || !(iterator3 = (values3 = bdDataRuleError.values()).iterator()).hasNext()) continue;
                String errorInfo = iterator3.next();
                String[] arr = errorInfo.split("\\|");
                String dimTypeName = arr[0];
                String dimName = arr[1];
                String entityName = map.get(arr[2]);
                String propName = arr[3];
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\uff0c\u6388\u6743\u5bf9\u8c61\uff1a\u201d%3$s\u201c\uff0c\u57fa\u7840\u8d44\u6599\u6570\u636e\u8303\u56f4\u7684\u201c%4$s\u201d\u5c5e\u6027\u672a\u914d\u7f6e\u6570\u636e\u89c4\u5219\u65b9\u6848\u3002", (String)"UserDirectAssignPermMultiPlugin_9", (String)"bos-permission-formplugin", (Object[])new Object[0]), dimTypeName, dimName, entityName, propName), Integer.valueOf(4000));
                return;
            }
        }
        if (this.dataRuleEntryHasNull()) {
            return;
        }
        Set<String> set = this.assignPermCacheUtil.getDimDataChangeSet();
        boolean dataChange = (Boolean)this.getModel().getValue("datachangeflag");
        if (dataChange || !set.isEmpty()) {
            this.dispatch();
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserDirectAssignPermMultiPlugin_10", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private boolean dataRuleEntryHasNull() {
        String nodeId = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
        if (StringUtils.isEmpty((String)nodeId)) {
            return false;
        }
        EntryGrid eg = (EntryGrid)this.getControl("datarule_entry");
        DynamicObject[] col = eg.getEntryData().getDataEntitys();
        if (null == col || Objects.equals(0, col.length)) {
            return false;
        }
        for (DynamicObject o : col) {
            String permItem = o.getString("permitem");
            String dataRuleId = o.getString("datarule");
            if (!StringUtils.isEmpty((String)permItem) || !StringUtils.isEmpty((String)dataRuleId)) continue;
            String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
            String entityNum = nodeInfoArr[1];
            String[] selectedDimInfo = this.getSelectedDimInfo();
            String dimTypeName = selectedDimInfo[1];
            String dimName = selectedDimInfo[0];
            Map<String, String> entityNumNameMap = this.funcPermTreeUtil.getEntityNumNameMap();
            String entityName = entityNumNameMap.get(entityNum);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\uff0c\u6388\u6743\u5bf9\u8c61\uff1a\u201d%3$s\u201c\uff0c\u6570\u636e\u89c4\u5219\u7684\u201c\u6743\u9650\u9879\u201d\u548c\u201c\u65b9\u6848\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectAssignPermMultiPlugin_11", (String)"bos-permission-formplugin", (Object[])new Object[0]), dimTypeName, dimName, entityName), Integer.valueOf(4000));
            return true;
        }
        return false;
    }

    private void dispatch() {
        try {
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(Lang.get());
            jobInfo.setAppId("bos");
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
            jobInfo.setNumber("perm-userDirectAssignPermMultiTaskjob" + System.currentTimeMillis());
            LocaleString captionLocalString = ResManager.getLocaleString((String)"\u7528\u6237\u76f4\u63a5\u6388\u6743\u5f02\u6b65\u4efb\u52a1\u7684\u6267\u884c", (String)"UserDirectAssignPermMultiPlugin_12", (String)"bos-permission-formplugin");
            jobInfo.setlName(captionLocalString);
            String jobId = UUID.randomUUID().toString();
            jobInfo.setId(jobId);
            logger.info("userDirectAssignPermMultiTask.dispatch JobId:{}", (Object)jobId);
            jobInfo.setTaskClassname("kd.bos.permission.formplugin.task.UserDirectAssignPermMultiTask");
            HashMap<String, Object> params = new HashMap<String, Object>();
            String formNum = this.getModel().getDataEntityType().getName();
            String appIdByFormNum = BizAppServiceHelp.getAppIdByFormNum((String)formNum);
            String appId = StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId()) ? appIdByFormNum : this.getView().getFormShowParameter().getAppId();
            params.put("appId", appId);
            params.put("formNum", formNum);
            params.put("oper_id", RequestContext.get().getCurrUserId());
            params.put("oper_org_id", RequestContext.get().getOrgId());
            params.put("client_type", RequestContext.get().getClient());
            params.put("client_ip", RequestContext.get().getLoginIP());
            params.put("client_name", RequestContext.get().getClient());
            params.put("pageId", this.getPageCache().getPageId());
            params.put("hasEnableOldDataRule", this.hasEnableOldDataRule);
            jobInfo.setParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "task_closeCallback");
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setCaption(captionLocalString.getLocaleValue());
            jobFormInfo.setCloseCallBack(closeCallBack);
            jobFormInfo.setCanBackground(true);
            jobFormInfo.setCanStop(true);
            jobFormInfo.setClickClassName("kd.bos.permission.formplugin.task.PermTaskClick");
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
        }
        catch (Exception e) {
            logger.warn("userDirectAssignPermMultiTask.dispatch error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Vector) {
            Vector vector = (Vector)evt.getSource();
            String key = vector.getKey();
            String pageCache_tabKeys = this.getPageCache().get(PGCACHE_DIMTABKEYS);
            if ("adddimtab".equals(key)) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("perm_add_auth_scope");
                List tabKeys = new ArrayList(1);
                if (StringUtils.isNotEmpty((String)pageCache_tabKeys)) {
                    tabKeys = (List)SerializationUtils.fromJsonString((String)pageCache_tabKeys, List.class);
                }
                fsp.setCustomParam("showFormCustomParam_existCtrlTypes", tabKeys);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setHasRight(true);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeCallBack_addAuthScope"));
                this.getView().showForm(fsp);
            } else if ("deldimtab".equals(key)) {
                List dimTabKeys = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_DIMTABKEYS), List.class);
                Tab tab = (Tab)this.getControl("dimtab");
                String currentTab = tab.getCurrentTab();
                if (StringUtils.isEmpty((String)currentTab) || CollectionUtils.isEmpty((Collection)dimTabKeys)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6743\u9650\u63a7\u5236\u7c7b\u578b\u201d\u9875\u7b7e\u53ef\u5220\u9664\u3002", (String)"UserDirectAssignPermMultiPlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    return;
                }
                EntryGrid entryGrid = (EntryGrid)this.getControl("dim_entry");
                EntryData entryData = entryGrid.getEntryData();
                if (entryData != null) {
                    DynamicObject[] dataEntity = entryData.getDataEntitys();
                    if (dataEntity.length != 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u7b7e\u4e0b\u5b58\u5728\u5206\u914d\u7684\u6743\u9650\u6570\u636e\uff0c\u8bf7\u5148\u6e05\u9664\u6743\u9650\u6570\u636e\u3002", (String)"UserDirectAssignPermMultiPlugin_14", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                        return;
                    }
                    this.delDimTab(tab, currentTab);
                }
            }
        } else if (source instanceof Button) {
            Button button = (Button)source;
            String key = button.getKey();
            if ("btn_addnode".equals(key)) {
                TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
                List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
                if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u529f\u80fd\u6743\u9650\u6811\u3002", (String)"UserDirectAssignPermMultiPlugin_15", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.addNodeData(tv, checkedNodeIds);
            } else if ("btn_delnode".equals(key)) {
                TreeView tv = (TreeView)this.getControl("tree_funcperm");
                List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
                if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5df2\u5206\u914d\u6743\u9650\u6811\u3002", (String)"UserDirectAssignPermMultiPlugin_16", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.removeNodeData(checkedNodeIds);
            }
        }
    }

    private void removeNodeData(List<String> checkedNodeIds) {
        List<String> permDetailInAdminCharge;
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        Map<String, String> emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap();
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        dimDataChangeSet.add(sourceKey);
        this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        Map<String, String> curPermMap = assignPermCurInfoMap.get("tree_funcperm");
        List<String> curPermDetail = SerializationUtils.fromJsonStringToList((String)curPermMap.get(sourceKey), String.class);
        ArrayList<String> searChPermDetail = new ArrayList(10);
        boolean isSearchMode = false;
        String searchModeStr = this.getPageCache().getBigObject("userFuncPermTreeSearchMode");
        if (StringUtils.isNotEmpty((String)searchModeStr)) {
            isSearchMode = true;
        }
        String showFormSpecial = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        boolean dontCheckAppChargeRange = VALUE_TRUE.equals(showFormSpecial);
        if (checkedNodeIds.contains("-1")) {
            if (isSearchMode) {
                searChPermDetail = SerializationUtils.fromJsonStringToList((String)searchModeStr, String.class);
                permDetailInAdminCharge = dontCheckAppChargeRange ? searChPermDetail : PermFormCommonUtil.getPermDetailInAdminCharge(this.getView(), searChPermDetail);
            } else {
                permDetailInAdminCharge = dontCheckAppChargeRange ? curPermDetail : PermFormCommonUtil.getPermDetailInAdminCharge(this.getView(), curPermDetail);
            }
            curPermDetail = new ArrayList<String>((Collection<String>)Sets.difference(new HashSet<String>(curPermDetail), new HashSet<String>(permDetailInAdminCharge)));
        } else {
            Map<String, String> allEntityInfoMap = this.funcPermTreeUtil.getAllEntityInfoMap();
            Map<String, Map<String, List<String>>> dataResource = new HashMap<String, Map<String, List<String>>>(16);
            if (isSearchMode) {
                searChPermDetail = SerializationUtils.fromJsonStringToList((String)searchModeStr, String.class);
                this.funcPermTreeUtil.processData(false, dataResource, searChPermDetail);
            } else {
                dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(sourceKey), Map.class);
            }
            Set<String> selectedPermNode = this.funcPermTreeUtil.getRealSelectedNode(false, dataResource, checkedNodeIds, allEntityInfoMap);
            ArrayList<String> selectedPermNodeList = new ArrayList<String>(selectedPermNode);
            permDetailInAdminCharge = dontCheckAppChargeRange ? selectedPermNodeList : PermFormCommonUtil.getPermDetailInAdminCharge(this.getView(), selectedPermNodeList);
            curPermDetail = new ArrayList<String>((Collection<String>)Sets.difference(new HashSet<String>(curPermDetail), new HashSet<String>(permDetailInAdminCharge)));
            curPermDetail = curPermDetail.stream().sorted().collect(Collectors.toList());
        }
        curPermMap.put(sourceKey, SerializationUtils.toJsonString(curPermDetail));
        this.getPageCache().removeBigObject("userFuncPermTreeSearchMode");
        if (curPermDetail.size() == 0) {
            String[] selectedDimInfo = this.getSelectedDimInfo();
            emptyDimMap.put(sourceKey, selectedDimInfo[1] + "," + selectedDimInfo[0]);
            this.getPageCache().put("emptyDimMap", SerializationUtils.toJsonString(emptyDimMap));
        }
        this.getModel().setValue("datachangeflag", (Object)true);
        this.deleteRelateFieldPermAndDataPerm(assignPermCurInfoMap, sourceKey, curPermDetail, permDetailInAdminCharge);
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
        this.buildFuncPermRightTree(sourceKey, curPermDetail);
        if (StringUtils.isNotEmpty((String)sourceKey)) {
            String[] sourceKeyInfo = sourceKey.split("\\|");
            String dimTypeStr = sourceKeyInfo[0];
            String dimIdStr = sourceKeyInfo[1];
            String hasLoadFieldPermTreeFlagKey = "hasLoadFieldPermTree_" + dimTypeStr + "_" + dimIdStr;
            this.getPageCache().remove(hasLoadFieldPermTreeFlagKey);
        }
    }

    private void deleteRelateFieldPermAndDataPerm(Map<String, Map<String, String>> assignPermCurInfoMap, String sourceKey, List<String> curPermDetail, List<String> hasDelPermDetail) {
        Map dimCurFieldPerm;
        HashSet<String> existEntry = new HashSet<String>(curPermDetail.size());
        for (String string : curPermDetail) {
            String[] arr = string.split("    ");
            String appId = arr[5];
            String entityNum = arr[6];
            String entityNode = "entity#" + entityNum + '@' + appId;
            existEntry.add(entityNode);
        }
        HashMap<String, Set> removeFunPermItemMap = new HashMap<String, Set>();
        for (String funpermStrInfo : hasDelPermDetail) {
            String[] arr = funpermStrInfo.split("    ");
            String appId = arr[5];
            String entityNum = arr[6];
            String permItemId = arr[9];
            String entityNode = "entity#" + entityNum + '@' + appId;
            removeFunPermItemMap.computeIfAbsent(entityNode, k -> new HashSet(8)).add(permItemId);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        String[] dimInfoArr = sourceKey.split("\\|");
        String dimType = dimInfoArr[0];
        String dimId = dimInfoArr[1];
        Map<String, String> curFieldPermMap = assignPermCurInfoMap.get("tree_fieldperm");
        String dimFieldPermStr = curFieldPermMap.get(sourceKey);
        if (StringUtils.isEmpty((String)dimFieldPermStr)) {
            this.loadFieldPerm(null, assignPermCurInfoMap, dimType, Lists.newArrayList((Object[])new Long[]{Long.valueOf(dimId)}));
            dimCurFieldPerm = (Map)SerializationUtils.fromJsonString((String)curFieldPermMap.get(sourceKey), Map.class);
        } else {
            dimCurFieldPerm = (Map)SerializationUtils.fromJsonString((String)dimFieldPermStr, Map.class);
        }
        if (!CollectionUtils.isEmpty((Map)dimCurFieldPerm)) {
            boolean permChange = false;
            HashSet dimCurEntry = Sets.newHashSet(dimCurFieldPerm.keySet());
            for (String entityNode : dimCurEntry) {
                if (existEntry.contains(entityNode)) continue;
                dimCurFieldPerm.remove(entityNode);
                permChange = true;
            }
            if (permChange) {
                Set<String> changeFieldPermDimSet = this.assignPermCacheUtil.getChangeFieldPermDimSet();
                changeFieldPermDimSet.add(sourceKey);
                hashMap.put("changeFieldPermDimSet", SerializationUtils.toJsonString(changeFieldPermDimSet));
                Set<String> changeFpsDimSet = this.assignPermCacheUtil.getChangeFpsDimSet();
                changeFpsDimSet.add(sourceKey);
                hashMap.put("changeFpsDimSet", SerializationUtils.toJsonString(changeFpsDimSet));
            }
            curFieldPermMap.put(sourceKey, SerializationUtils.toJsonString((Object)dimCurFieldPerm));
        }
        if (this.hasEnableOldDataRule) {
            Map dimCurDataPerm;
            Map<String, String> curDataPermMap = assignPermCurInfoMap.get("tree_dataperm");
            String dimDataPermStr = curDataPermMap.get(sourceKey);
            if (StringUtils.isEmpty((String)dimDataPermStr)) {
                this.loadDataPerm(null, assignPermCurInfoMap, dimType, Lists.newArrayList((Object[])new Long[]{Long.valueOf(dimId)}));
                dimCurDataPerm = (Map)SerializationUtils.fromJsonString((String)curDataPermMap.get(sourceKey), Map.class);
            } else {
                dimCurDataPerm = (Map)SerializationUtils.fromJsonString((String)dimDataPermStr, Map.class);
            }
            if (!CollectionUtils.isEmpty((Map)dimCurDataPerm)) {
                HashSet<String> removeEntityNode = new HashSet<String>(16);
                boolean permChange = false;
                HashSet dimCurEntry = Sets.newHashSet(dimCurDataPerm.keySet());
                for (String entityNode : dimCurEntry) {
                    if (existEntry.contains(entityNode)) continue;
                    dimCurDataPerm.remove(entityNode);
                    removeEntityNode.add(entityNode);
                    permChange = true;
                }
                if (permChange) {
                    Set<String> changeDataPermDimSet = this.assignPermCacheUtil.getChangeDataPermDimSet();
                    changeDataPermDimSet.add(sourceKey);
                    hashMap.put("changeDataPermDimSet", SerializationUtils.toJsonString(changeDataPermDimSet));
                }
                curDataPermMap.put(sourceKey, SerializationUtils.toJsonString((Object)dimCurDataPerm));
                Map<String, Map<String, String>> dataPermSettingErrorMap = this.assignPermCacheUtil.getDataPermSettingErrorMap();
                Map<String, String> entityDataPermSettingError = dataPermSettingErrorMap.get(sourceKey);
                if (permChange && !CollectionUtils.isEmpty(entityDataPermSettingError)) {
                    for (String entityNode : removeEntityNode) {
                        entityDataPermSettingError.remove(entityNode);
                    }
                    if (CollectionUtils.isEmpty(entityDataPermSettingError)) {
                        dataPermSettingErrorMap.remove(sourceKey);
                    }
                    hashMap.put("dataPermSettingErrorMap", SerializationUtils.toJsonString(dataPermSettingErrorMap));
                }
            }
        } else {
            Map dimCurDataRule;
            Map<String, String> curDataRuleMap = assignPermCurInfoMap.get("tree_datarule");
            String dimDataRuleStr = curDataRuleMap.get(sourceKey);
            if (StringUtils.isEmpty((String)dimDataRuleStr)) {
                this.loadDataRule(null, assignPermCurInfoMap, dimType, Lists.newArrayList((Object[])new Long[]{Long.valueOf(dimId)}));
                dimCurDataRule = (Map)SerializationUtils.fromJsonString((String)curDataRuleMap.get(sourceKey), Map.class);
            } else {
                dimCurDataRule = (Map)SerializationUtils.fromJsonString((String)dimDataRuleStr, Map.class);
            }
            if (!CollectionUtils.isEmpty((Map)dimCurDataRule)) {
                HashSet<String> entityKeyHasRemoveAllDrInfoFromDr = new HashSet<String>(16);
                boolean permChange = false;
                HashSet dimCurEntry = Sets.newHashSet(dimCurDataRule.keySet());
                HashSet<String> entKeysHasRemovedPartOfPermItemFromDrCache = new HashSet<String>(8);
                HashSet<String> needRemoveKeyFromDataRuleError = new HashSet<String>(8);
                for (Map.Entry entry : removeFunPermItemMap.entrySet()) {
                    Map bdDrMap;
                    Map permItemDrMap;
                    Map curTwoDrInfo;
                    String hasRemovedEntityKey = (String)entry.getKey();
                    Set hasRemovedPermItemIds = (Set)entry.getValue();
                    if (StringUtils.isEmpty((String)hasRemovedEntityKey) || hasRemovedPermItemIds == null || hasRemovedPermItemIds.isEmpty() || (curTwoDrInfo = (Map)dimCurDataRule.get(hasRemovedEntityKey)) == null || (permItemDrMap = (Map)curTwoDrInfo.get(PGCACHE_DATARULE)) == null) continue;
                    for (String hasRemovedPermItemId : hasRemovedPermItemIds) {
                        if (permItemDrMap.remove(hasRemovedPermItemId) == null) continue;
                        entKeysHasRemovedPartOfPermItemFromDrCache.add(hasRemovedEntityKey);
                        needRemoveKeyFromDataRuleError.add(hasRemovedEntityKey + "|" + hasRemovedPermItemId);
                        permChange = true;
                    }
                    if (!permItemDrMap.isEmpty() || (bdDrMap = (Map)curTwoDrInfo.get(PGCACHE_BDDATARULE)) != null && !bdDrMap.isEmpty()) continue;
                    entityKeyHasRemoveAllDrInfoFromDr.add(hasRemovedEntityKey);
                }
                for (String entityKey : dimCurEntry) {
                    if (existEntry.contains(entityKey) || !entityKeyHasRemoveAllDrInfoFromDr.contains(entityKey)) continue;
                    dimCurDataRule.remove(entityKey);
                }
                if (permChange) {
                    Set<String> changeDataRuleDimSet = this.assignPermCacheUtil.getChangeDataRuleDimSet();
                    changeDataRuleDimSet.add(sourceKey);
                    hashMap.put("changeDataRuleDimSet", SerializationUtils.toJsonString(changeDataRuleDimSet));
                    curDataRuleMap.put(sourceKey, SerializationUtils.toJsonString((Object)dimCurDataRule));
                    this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
                    String nodeId = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
                    if (StringUtils.isNotEmpty((String)nodeId) && entKeysHasRemovedPartOfPermItemFromDrCache.contains(nodeId)) {
                        TreeView dataRuleTree = (TreeView)this.getControl("tree_datarule");
                        dataRuleTree.treeNodeClick("reload", nodeId);
                    }
                }
                Map<String, Map<String, Map<String, String>>> dataRuleSettingErrorMap = this.assignPermCacheUtil.getDataRuleSettingErrorMap();
                Map<String, Map<String, String>> entityDataRuleSettingError = dataRuleSettingErrorMap.get(sourceKey);
                if (permChange && !CollectionUtils.isEmpty(entityDataRuleSettingError)) {
                    Map.Entry<String, String> entry;
                    Iterator<Map.Entry<String, String>> iterator;
                    for (String needRemoveEntPermItemKey : needRemoveKeyFromDataRuleError) {
                        Map<String, String> dataRuleError = entityDataRuleSettingError.get(PGCACHE_DATARULE);
                        if (CollectionUtils.isEmpty(dataRuleError)) continue;
                        iterator = dataRuleError.entrySet().iterator();
                        while (iterator.hasNext()) {
                            entry = iterator.next();
                            String drErrorKey = entry.getKey();
                            if (StringUtils.isEmpty((String)drErrorKey) || !Objects.equals(needRemoveEntPermItemKey, drErrorKey)) continue;
                            iterator.remove();
                        }
                    }
                    Map<String, String> bddataRuleError = entityDataRuleSettingError.get(PGCACHE_BDDATARULE);
                    if (!CollectionUtils.isEmpty(bddataRuleError)) {
                        for (String entityKey : entityKeyHasRemoveAllDrInfoFromDr) {
                            iterator = bddataRuleError.entrySet().iterator();
                            while (iterator.hasNext()) {
                                String[] split;
                                entry = iterator.next();
                                String bddrErrorKey = entry.getKey();
                                if (StringUtils.isEmpty((String)bddrErrorKey) || null == (split = bddrErrorKey.split("\\|", 2)) || !Objects.equals(2, split.length) || !Objects.equals(entityKey, split[0])) continue;
                                iterator.remove();
                            }
                        }
                    }
                    if (CollectionUtils.isEmpty(entityDataRuleSettingError)) {
                        dataRuleSettingErrorMap.remove(sourceKey);
                    }
                    hashMap.put("dataRuleSettingErrorMap", SerializationUtils.toJsonString(dataRuleSettingErrorMap));
                }
            }
        }
        this.getPageCache().put(hashMap);
    }

    private void addNodeData(TreeView tv, List<String> checkedNodeIds) {
        HashSet sourceKeySet = null;
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        Map<String, String> emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap();
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        String[] clickRows = sourceKey.split(",");
        List<String> sourceKeyList = Arrays.stream(clickRows).collect(Collectors.toList());
        Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        Map<String, String> oriPermMap = assignPermOriInfoMap.get("tree_funcperm");
        Map<String, String> curPermMap = assignPermCurInfoMap.get("tree_funcperm");
        HashMap<String, Map<String, String>> assignPermOriInfoMapReplace = new HashMap<String, Map<String, String>>(8);
        assignPermOriInfoMapReplace.putAll(assignPermOriInfoMap);
        HashMap<String, String> oriPermMapReplace = new HashMap<String, String>(8);
        oriPermMapReplace.putAll(oriPermMap);
        HashMap<String, String> curPermMapReplace = new HashMap<String, String>(8);
        curPermMapReplace.putAll(curPermMap);
        if (this.addTooMuch(curPermMapReplace)) {
            return;
        }
        String dimType = (String)this.getModel().getValue("dimtype");
        if (clickRows.length > 1) {
            ArrayList<Long> dimIds = new ArrayList<Long>(clickRows.length);
            sourceKeySet = new HashSet(sourceKeyList);
            Set hasLoadedPermDims = oriPermMapReplace.keySet();
            sourceKeySet.removeAll(hasLoadedPermDims);
            if (!sourceKeySet.isEmpty()) {
                for (String key : sourceKeySet) {
                    dimIds.add(Long.valueOf(key.split("\\|")[1]));
                }
            }
            if (!dimIds.isEmpty()) {
                Map<String, List<String>> queryData = this.queryUserAssignDimPerm(dimType, dimIds);
                for (String key : sourceKeySet) {
                    List<String> userPermDetailInfos = queryData.get(key);
                    if (userPermDetailInfos == null) {
                        userPermDetailInfos = new ArrayList<String>(10);
                    }
                    oriPermMapReplace.put(key, SerializationUtils.toJsonString(userPermDetailInfos));
                    curPermMapReplace.put(key, SerializationUtils.toJsonString(userPermDetailInfos));
                    if (!this.addTooMuch(curPermMapReplace)) continue;
                    return;
                }
                assignPermOriInfoMapReplace.put("tree_funcperm", oriPermMapReplace);
            }
            sourceKeyList.add(BATCH_ASSIGN);
            sourceKey = BATCH_ASSIGN;
            curPermMapReplace.putIfAbsent(sourceKey, SerializationUtils.toJsonString(new ArrayList(10)));
            if (this.addTooMuch(curPermMapReplace)) {
                return;
            }
        }
        List<Object> assignPermNodeList = new ArrayList(10);
        Map<String, String> allEntityInfoMap = this.funcPermTreeUtil.getAllEntityInfoMap();
        Map<String, String> allPermNodeInfoMap = this.funcPermTreeUtil.getAllPermNodeInfoMap();
        String searchMode = this.getPageCache().getBigObject("allFuncPermTreeSearchMode");
        if (checkedNodeIds.contains("-1")) {
            if (StringUtils.isNotEmpty((String)searchMode)) {
                List searChPermDetail = SerializationUtils.fromJsonStringToList((String)searchMode, String.class);
                for (String dimTypeDimId : sourceKeyList) {
                    Iterator curDimPermList = SerializationUtils.fromJsonStringToList((String)((String)curPermMapReplace.get(dimTypeDimId)), String.class);
                    HashSet curDimPermSet = new HashSet(curDimPermList);
                    curDimPermSet.addAll(searChPermDetail);
                    assignPermNodeList = curDimPermSet.stream().sorted().collect(Collectors.toList());
                    curPermMapReplace.put(dimTypeDimId, SerializationUtils.toJsonString(assignPermNodeList));
                    if (!this.addTooMuch(curPermMapReplace)) continue;
                    return;
                }
            } else {
                Map<String, String> entityAssignablePermItemMap = this.funcPermTreeUtil.getEntityAssignablePermItemMap();
                Map<String, String> permItemIdNumberMap = this.funcPermTreeUtil.getPermItemIdNumberMap();
                Collection<String> values = allPermNodeInfoMap.values();
                assignPermNodeList = new ArrayList(values.size() * 10);
                for (String value : values) {
                    String[] permItemIdArr;
                    String[] arr = value.split("    ");
                    String entityNum = arr[6];
                    String permItemStr = entityAssignablePermItemMap.get(entityNum);
                    if (!StringUtils.isNotEmpty((String)permItemStr)) continue;
                    for (String permItemId : permItemIdArr = permItemStr.split(",")) {
                        if (StringUtils.isEmpty((String)permItemId)) continue;
                        String permItemNum = permItemIdNumberMap.get(permItemId);
                        assignPermNodeList.add(String.join((CharSequence)"    ", value, permItemNum, permItemId));
                    }
                }
                for (String dimTypeDimId : sourceKeyList) {
                    String serialStr = (String)curPermMapReplace.get(dimTypeDimId);
                    if (StringUtils.isNotEmpty((String)serialStr)) {
                        HashSet<String> curPermSet = new HashSet<String>(SerializationUtils.fromJsonStringToList((String)serialStr, String.class));
                        curPermSet.addAll(assignPermNodeList);
                        assignPermNodeList = curPermSet.stream().sorted().collect(Collectors.toList());
                    } else {
                        assignPermNodeList = assignPermNodeList.stream().sorted().collect(Collectors.toList());
                    }
                    curPermMapReplace.put(dimTypeDimId, SerializationUtils.toJsonString(assignPermNodeList));
                    if (!this.addTooMuch(curPermMapReplace)) continue;
                    return;
                }
            }
        } else {
            Map<String, Map<String, List<String>>> dataResource = new HashMap<String, Map<String, List<String>>>(16);
            if (StringUtils.isNotEmpty((String)searchMode)) {
                List searChPermDetail = SerializationUtils.fromJsonStringToList((String)searchMode, String.class);
                this.funcPermTreeUtil.processData(false, dataResource, searChPermDetail);
            } else {
                dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(dimType), Map.class);
            }
            Set<String> selectedPermNode = this.funcPermTreeUtil.getRealSelectedNode(true, dataResource, checkedNodeIds, allEntityInfoMap);
            for (String dimTypeDimId : sourceKeyList) {
                HashSet<String> dataSourceBeans;
                String data = (String)curPermMapReplace.get(dimTypeDimId);
                if (StringUtils.isEmpty((String)data)) {
                    dataSourceBeans = new HashSet<String>(16);
                } else {
                    List dataSource = SerializationUtils.fromJsonStringToList((String)data, String.class);
                    dataSourceBeans = new HashSet(dataSource);
                }
                dataSourceBeans.addAll(selectedPermNode);
                assignPermNodeList = dataSourceBeans.stream().sorted().collect(Collectors.toList());
                curPermMapReplace.put(dimTypeDimId, SerializationUtils.toJsonString(assignPermNodeList));
                if (!this.addTooMuch(curPermMapReplace)) continue;
                return;
            }
        }
        this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMapReplace);
        sourceKeyList.removeIf(x -> x.equals(BATCH_ASSIGN));
        dimDataChangeSet.addAll(sourceKeyList);
        this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
        assignPermCurInfoMap.put("tree_funcperm", curPermMapReplace);
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
        sourceKeyList.forEach(emptyDimMap::remove);
        this.getPageCache().put("emptyDimMap", SerializationUtils.toJsonString(emptyDimMap));
        this.buildFuncPermRightTree(sourceKey, assignPermNodeList);
        Search userFuncPermSearch = (Search)this.getControl("userfuncpermsearchap");
        userFuncPermSearch.setSearchKey("");
        this.getPageCache().removeBigObject("userFuncPermTreeSearchMode");
        tv.uncheckNodes(checkedNodeIds);
        this.getModel().setValue("datachangeflag", (Object)true);
        if (!CollectionUtils.isEmpty(sourceKeyList)) {
            HashSet<String> clearHasLoadFieldPermTreeFlagKeySet = new HashSet<String>(sourceKeyList.size());
            for (String sourceK : sourceKeyList) {
                String[] sourceKeyInfo = sourceK.split("\\|");
                String dimTypeStr = sourceKeyInfo[0];
                String dimIdStr = sourceKeyInfo[1];
                String hasLoadFieldPermTreeFlagKey = "hasLoadFieldPermTree_" + dimTypeStr + "_" + dimIdStr;
                clearHasLoadFieldPermTreeFlagKeySet.add(hasLoadFieldPermTreeFlagKey);
            }
            this.getPageCache().batchRemove(new ArrayList(clearHasLoadFieldPermTreeFlagKeySet));
        }
    }

    private boolean addTooMuch(Map<String, String> dimTypeDimIdAssignPermNodeStrMap) {
        int count = 0;
        for (Map.Entry<String, String> dimTypeDimIdAssignPermNodeStr : dimTypeDimIdAssignPermNodeStrMap.entrySet()) {
            List nowAssignPermNodeList;
            String nowAssignPermNode = dimTypeDimIdAssignPermNodeStr.getValue();
            if (StringUtils.isEmpty((String)nowAssignPermNode) || null == (nowAssignPermNodeList = (List)SerializationUtils.fromJsonString((String)nowAssignPermNode, List.class)) || nowAssignPermNodeList.isEmpty()) continue;
            count += nowAssignPermNodeList.size();
        }
        if (400000 < count) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u88ab\u6388\u6743\u7528\u6237\u5206\u914d\u4e86\u592a\u591a\u6743\u9650\u6570\u636e\uff0c\u4f1a\u6709\u8f83\u5dee\u6027\u80fd\u4f53\u9a8c\uff0c\u5efa\u8bae\u5220\u53bb\u6b64\u5904\u5206\u914d\uff0c\u6362\u7528\u89d2\u8272\u6388\u6743\u6216\u5168\u529f\u80fd\u7528\u6237\u3002", (String)"UserDirectAssignPermMultiPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void delDimTab(Tab tab, String delTabKey) {
        String[] tabKeyInfoArr = delTabKey.split("\\|");
        HashMap<String, String> updateCacheMap = new HashMap<String, String>(16);
        String dimType = tabKeyInfoArr[0];
        Map userDirectAssignDim = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_INFO), Map.class);
        EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
        DynamicObject[] col = eg.getEntryData().getDataEntitys();
        ArrayList<String> delDims = new ArrayList<String>(col.length);
        for (DynamicObject o : col) {
            long dimId = o.getLong(DIMNUM_ID);
            delDims.add(String.valueOf(dimId));
        }
        this.clearCacheAfterDelDim(delDims);
        userDirectAssignDim.remove(dimType);
        updateCacheMap.put(PGCACHE_USER_ASSIGN_INFO, SerializationUtils.toJsonString((Object)userDirectAssignDim));
        String pageCache_tabKeys = this.getPageCache().get(PGCACHE_DIMTABKEYS);
        List tabKeyList = (List)SerializationUtils.fromJsonString((String)pageCache_tabKeys, List.class);
        tabKeyList.remove(delTabKey);
        updateCacheMap.put(PGCACHE_DIMTABKEYS, SerializationUtils.toJsonString((Object)tabKeyList));
        this.getPageCache().put(updateCacheMap);
        this.getPageCache().remove(PGCACHE_LASTCLICK_DIMTAB);
        tab.deleteControls(new String[]{delTabKey});
        if (!tabKeyList.isEmpty()) {
            String firstTabKey = (String)tabKeyList.get(0);
            tab.selectTab(firstTabKey);
            tab.activeTab(firstTabKey);
        } else {
            this.getModel().deleteEntryData("dim_entry");
            this.getModel().setValue("dimtype", null);
        }
    }

    public void entryRowClick(RowClickEvent e) {
        Object source = e.getSource();
        if (source instanceof EntryGrid) {
            EntryGrid eg = (EntryGrid)source;
            String key = eg.getKey();
            if ("dim_entry".equals(key)) {
                int[] rows;
                String dimType = (String)this.getModel().getValue("dimtype");
                Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
                this.needUpdateDataPermPageCache(null, assignPermCurInfoMap);
                this.resetEntryInfo();
                this.clearAllSearchMode();
                String lastPermTabKey = this.getPageCache().get(PGCACHE_LASTCLICK_PERMTAB);
                if (lastPermTabKey == null) {
                    lastPermTabKey = "tab_perm_funcperm";
                }
                if ((rows = eg.getSelectRows()) == null) {
                    return;
                }
                if (rows.length == 0) {
                    this.getPageCache().remove(PGCACHE_LASTENTRYROWCLICK);
                    this.getPageCache().remove(PGCACHE_BATCH_ASSIGN);
                    this.clearTreeViewAndEntry();
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addnode", "btn_delnode"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"tab_perm_fieldperm", "tab_perm_dataperm", "tab_perm_datarule"});
                } else if (rows.length == 1) {
                    this.getPageCache().remove(PGCACHE_BATCH_ASSIGN);
                    int curRowIndex = e.getRow();
                    Long dimId = (Long)this.getModel().getValue(DIMNUM_ID, curRowIndex);
                    this.getPageCache().put(PGCACHE_LASTENTRYROWCLICK, dimType + "|" + dimId);
                    switch (lastPermTabKey) {
                        case "tab_perm_funcperm": {
                            TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
                            boolean showNum = (Boolean)this.getModel().getValue("shownum");
                            this.funcPermTreeUtil.initFuncPermLeftTree(tv, dimType, showNum);
                            this.initFuncPermRightTree(null, null, dimType, dimId);
                            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_addnode", "btn_delnode"});
                            break;
                        }
                        case "tab_perm_fieldperm": {
                            boolean setup = (Boolean)this.getModel().getValue("fieldpermsetup");
                            if (setup) {
                                this.getModel().setValue("fieldpermsetup", (Object)false);
                                break;
                            }
                            this.initFieldPermTree(dimType, dimId);
                            break;
                        }
                        case "tab_perm_dataperm": {
                            boolean setup = (Boolean)this.getModel().getValue("datapermsetup");
                            if (setup) {
                                this.getModel().setValue("datapermsetup", (Object)false);
                                break;
                            }
                            this.initDataPermTree(dimType, dimId);
                            break;
                        }
                        case "tab_perm_datarule": {
                            boolean setup = (Boolean)this.getModel().getValue("datarulesetup");
                            if (setup) {
                                this.getModel().setValue("datarulesetup", (Object)false);
                                break;
                            }
                            this.initDataRuleTree(dimType, dimId);
                        }
                    }
                } else if (rows.length > 1) {
                    this.getPageCache().put(PGCACHE_BATCH_ASSIGN, VALUE_TRUE);
                    this.getPageCache().removeBigObject(BATCH_ASSIGN);
                    assignPermCurInfoMap.get("tree_funcperm").remove(BATCH_ASSIGN);
                    this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
                    this.clearTreeViewAndEntry();
                    StringBuilder sourceKey = new StringBuilder();
                    for (int row : rows) {
                        Long dimId = (Long)this.getModel().getValue(DIMNUM_ID, row);
                        sourceKey.append(dimType).append("|").append(dimId).append(",");
                    }
                    sourceKey.deleteCharAt(sourceKey.length() - 1);
                    this.getPageCache().put(PGCACHE_LASTENTRYROWCLICK, sourceKey.toString());
                    switch (lastPermTabKey) {
                        case "tab_perm_funcperm": {
                            TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
                            boolean showNum = (Boolean)this.getModel().getValue("shownum");
                            this.funcPermTreeUtil.initFuncPermLeftTree(tv, dimType, showNum);
                            this.buildFuncPermRightTree(BATCH_ASSIGN, null);
                            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_addnode"});
                            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_delnode"});
                            break;
                        }
                    }
                }
            } else if (Objects.equals("entryentity_fps_sensitive", key)) {
                String nodeId = this.getPageCache().get("lastClickFieldPermNode");
                if (StringUtils.isEmpty((String)nodeId)) {
                    return;
                }
                String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
                if (null == nodeInfoArr || !Objects.equals(2, nodeInfoArr.length)) {
                    return;
                }
                String appId = nodeInfoArr[0];
                String entityNum = nodeInfoArr[1];
                this.getPageCache().put("formShowCustomParam_entityNumviewdetail", entityNum);
                this.getPageCache().put("formShowCustomParam_appIdviewdetail", appId);
            } else if (Objects.equals("entryentity_fps", key)) {
                this.getPageCache().put("formShowCustomParam_entityNumviewdetail", "");
                this.getPageCache().put("formShowCustomParam_appIdviewdetail", "");
            }
        }
    }

    private void initDataRuleTree(String dimType, Long dimId) {
        String sourceKey = dimType + "|" + dimId;
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        String dataSource = this.getPageCache().getBigObject(dimType);
        if (dataSource == null) {
            TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
            this.funcPermTreeUtil.initFuncPermLeftTree(tv, dimType, showNum);
        }
        Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(dimType), Map.class);
        TreeView tv = (TreeView)this.getControl("tree_datarule");
        tv.deleteAllNodes();
        TreeNode rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAssignObj());
        rootNode.setIsOpened(true);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            logger.warn("UserDirectAssignPermMultiPlugin.initDataRuleTree sleep err.", (Throwable)e);
        }
        tv.addNode(rootNode);
        this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, showNum);
        this.getModel().deleteEntryData("datarule_entry");
        this.getModel().deleteEntryData("bddatarule_entry");
        this.getView().setVisible(Boolean.FALSE, new String[]{"tab_datarule"});
        Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        Map<String, String> oriDataRuleMap = assignPermOriInfoMap.get("tree_datarule");
        Set<String> hasLoadedDataRuleDim = oriDataRuleMap.keySet();
        if (hasLoadedDataRuleDim.contains(sourceKey)) {
            return;
        }
        ArrayList<Long> dimIds = new ArrayList<Long>(10);
        dimIds.add(dimId);
        this.loadDataRule(assignPermOriInfoMap, null, dimType, dimIds);
    }

    private void loadDataRule(Map<String, Map<String, String>> assignPermOriInfoMap, Map<String, Map<String, String>> assignPermCurInfoMap, String dimType, List<Long> dimIds) {
        if (assignPermOriInfoMap == null) {
            assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        }
        if (assignPermCurInfoMap == null) {
            assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        }
        Map<String, String> oriDataRule = assignPermOriInfoMap.get("tree_datarule");
        Map<String, String> curDataRule = assignPermCurInfoMap.get("tree_datarule");
        Map<String, Map<String, Map<String, Map<String, String>>>> dataPemData = this.queryUserAssignDimDataRule(dimType, dimIds);
        for (Map.Entry<String, Map<String, Map<String, Map<String, String>>>> entry : dataPemData.entrySet()) {
            String sourceKey = entry.getKey();
            String[] arr = sourceKey.split("\\|");
            Long dimId = Long.valueOf(arr[1]);
            Map<String, Map<String, Map<String, String>>> dimCurDataRule = entry.getValue();
            String serialStr = SerializationUtils.toJsonString(dimCurDataRule);
            oriDataRule.put(sourceKey, serialStr);
            curDataRule.put(sourceKey, serialStr);
            dimIds.remove(dimId);
        }
        for (Long dimId : dimIds) {
            oriDataRule.put(dimType + "|" + dimId, SerializationUtils.toJsonString(new HashMap(16)));
            curDataRule.put(dimType + "|" + dimId, SerializationUtils.toJsonString(new HashMap(16)));
        }
        this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMap);
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
    }

    private Map<String, Map<String, Map<String, Map<String, String>>>> queryUserAssignDimDataRule(String dimType, List<Long> dimIds) {
        Long userId = (Long)this.getModel().getValue("user_id");
        StringBuilder dimIdStr = new StringBuilder();
        for (Long dimId : dimIds) {
            dimIdStr.append(dimId).append(",");
        }
        dimIdStr.deleteCharAt(dimIdStr.length() - 1);
        StringBuilder dataRuleSql = new StringBuilder().append("SELECT a.fid, a.fdimid, a.fappid, a.fentitynum, b.fnumber, a.fpermitemid, a.fdataruleid FROM t_perm_userdatarule a ").append("LEFT JOIN t_perm_permitem b ON a.fpermitemid = b.fid ").append("WHERE a.fuserid = ").append(userId).append(" AND a.fdimtype = '").append(dimType).append("' ").append("AND a.fdimid IN (").append((CharSequence)dimIdStr).append(") ").append("ORDER BY a.fdimid, a.fappid, a.fentitynum, b.fnumber ");
        StringBuilder bdDataRuleSql = new StringBuilder().append("SELECT fid, fdimid, fappid, fentitynum, fpropkey, fpropentnum, fdataruleid FROM t_perm_userdatarule_prop ").append("WHERE fuserid = ").append(userId).append(" AND fdimtype = '").append(dimType).append("' ").append("AND fdimid IN (").append((CharSequence)dimIdStr).append(") ").append("ORDER BY fdimid, fappid, fentitynum, fpropkey ");
        HashMap<String, Map<String, Map<String, Map<String, String>>>> result = new HashMap<String, Map<String, Map<String, Map<String, String>>>>(dimIds.size());
        try {
            String sourceKey = "";
            try (DataSet dataRuleDs = DB.queryDataSet((String)"queryUserAssignDimDataRule", (DBRoute)DBRoute.permission, (String)dataRuleSql.toString());){
                while (dataRuleDs.hasNext()) {
                    Row row = dataRuleDs.next();
                    long id = row.getLong(0);
                    long dimId = row.getLong(1);
                    String appId = row.getString(2);
                    String entityNum = row.getString(3);
                    String permItermId = row.getString(5);
                    Long dataRuleId = row.getLong(6);
                    sourceKey = dimType + "|" + dimId;
                    String nodeId = "entity#" + entityNum + '@' + appId;
                    Map entitySettingMap = result.computeIfAbsent(sourceKey, j -> new HashMap(16));
                    Map dataRuleSetting = entitySettingMap.computeIfAbsent(nodeId, k -> new HashMap(16));
                    Map dataRuleSettingMap = dataRuleSetting.computeIfAbsent(PGCACHE_DATARULE, l -> new HashMap(16));
                    dataRuleSettingMap.put(permItermId, String.valueOf(dataRuleId));
                }
            }
            Map<String, String> bdDataRuleSettingMap = new HashMap(16);
            try (DataSet bdDataRuleDs = DB.queryDataSet((String)"queryUserAssignDimBdDataRule", (DBRoute)DBRoute.permission, (String)bdDataRuleSql.toString());){
                while (bdDataRuleDs.hasNext()) {
                    Row row = bdDataRuleDs.next();
                    long id = row.getLong(0);
                    long dimId = row.getLong(1);
                    String appId = row.getString(2);
                    String entityNum = row.getString(3);
                    String propKey = row.getString(4);
                    String propEntity = row.getString(5);
                    long dataRuleId = row.getLong(6);
                    sourceKey = dimType + "|" + dimId;
                    String nodeId = "entity#" + entityNum + '@' + appId;
                    Map entitySettingMap = result.computeIfAbsent(sourceKey, j -> new HashMap(16));
                    Map dataRuleSetting = entitySettingMap.computeIfAbsent(nodeId, k -> new HashMap(16));
                    bdDataRuleSettingMap = dataRuleSetting.computeIfAbsent(PGCACHE_BDDATARULE, l -> new HashMap(16));
                    bdDataRuleSettingMap.put(propKey, propKey + "|" + propEntity + "|" + dataRuleId);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private void initDataPermTree(String dimType, Long dimId) {
        String sourceKey = dimType + "|" + dimId;
        String dataSource = this.getPageCache().getBigObject(sourceKey);
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        if (dataSource == null) {
            TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
            this.funcPermTreeUtil.initFuncPermLeftTree(tv, dimType, showNum);
            this.initFuncPermRightTree(assignPermOriInfoMap, assignPermCurInfoMap, dimType, dimId);
        }
        Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(sourceKey), Map.class);
        TreeView tv = (TreeView)this.getControl("tree_dataperm");
        tv.deleteAllNodes();
        TreeNode rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllreadyAssignDesc());
        rootNode.setIsOpened(true);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            logger.warn("UserDirectAssignPermMultiPlugin.initDataPermTree sleep err.", (Throwable)e);
        }
        tv.addNode(rootNode);
        this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, showNum);
        this.clearDataPermFilterGrid();
        this.getView().setVisible(Boolean.FALSE, new String[]{"filtergrid_dataperm"});
        Map<String, String> oriDataPermMap = assignPermOriInfoMap.get("tree_dataperm");
        Set<String> hasLoadedFieldPermDim = oriDataPermMap.keySet();
        if (hasLoadedFieldPermDim.contains(sourceKey)) {
            return;
        }
        ArrayList<Long> dimIds = new ArrayList<Long>(10);
        dimIds.add(dimId);
        this.loadDataPerm(assignPermOriInfoMap, null, dimType, dimIds);
    }

    private void loadDataPerm(Map<String, Map<String, String>> assignPermOriInfoMap, Map<String, Map<String, String>> assignPermCurInfoMap, String dimType, List<Long> dimIds) {
        if (assignPermOriInfoMap == null) {
            assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        }
        if (assignPermCurInfoMap == null) {
            assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        }
        Map<String, String> oriDataPerm = assignPermOriInfoMap.get("tree_dataperm");
        Map<String, String> curDataPerm = assignPermCurInfoMap.get("tree_dataperm");
        Map<String, Map<String, String>> dataPemData = this.queryUserAssignDimDataPerm(dimType, dimIds);
        for (Map.Entry<String, Map<String, String>> entry : dataPemData.entrySet()) {
            String key = entry.getKey();
            String[] info = key.split("\\|");
            Long dimId = Long.valueOf(info[0]);
            HashSet<String> oriDataPermDetail = new HashSet<String>(50);
            Map<String, String> value = entry.getValue();
            for (Map.Entry<String, String> detailEntry : value.entrySet()) {
                String nodeId = detailEntry.getKey();
                String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
                String appId = nodeInfoArr[0];
                String entityNum = nodeInfoArr[1];
                String rule = detailEntry.getValue();
                oriDataPermDetail.add(appId + "|" + entityNum + "|" + rule);
            }
            oriDataPerm.put(dimType + "|" + dimId, SerializationUtils.toJsonString(oriDataPermDetail));
            curDataPerm.put(dimType + "|" + dimId, SerializationUtils.toJsonString(value));
            dimIds.remove(dimId);
        }
        for (Long dimId : dimIds) {
            oriDataPerm.put(dimType + "|" + dimId, SerializationUtils.toJsonString(new HashSet(16)));
            curDataPerm.put(dimType + "|" + dimId, SerializationUtils.toJsonString(new HashMap(16)));
        }
        this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMap);
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
    }

    private Map<String, Map<String, String>> queryUserAssignDimDataPerm(String dimType, List<Long> dimIds) {
        String[] suitableDimType = PermCommonUtil.getSuitableDimType((String)dimType);
        dimType = suitableDimType[0];
        Long userId = (Long)this.getModel().getValue("user_id");
        StringBuilder dimIdStr = new StringBuilder();
        for (Long dimId : dimIds) {
            dimIdStr.append(dimId).append(",");
        }
        dimIdStr.deleteCharAt(dimIdStr.length() - 1);
        StringBuilder sql = new StringBuilder().append("SELECT a.fdatapermid, a.forgid, b.fbizappid, b.fentitytypeid, b.frule FROM t_perm_userdataperm a ").append("LEFT JOIN t_perm_datapermentry b ON a.fdatapermid = b.fid ").append("WHERE a.fuserid = ").append(userId).append(" AND a.fdimtype = '").append(dimType).append("' ").append("AND a.forgid IN (").append((CharSequence)dimIdStr).append(") ").append("ORDER BY a.forgid, b.fbizappid, b.fentitytypeid ");
        long curDimId = -1L;
        String curDataPermId = "";
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(dimIds.size());
        HashMap<String, String> curDimDataPerm = new HashMap<String, String>(16);
        try {
            try (DataSet finalDs = DB.queryDataSet((String)"queryUserAssignDimDataPerm", (DBRoute)DBRoute.permission, (String)sql.toString());){
                while (finalDs.hasNext()) {
                    Row row = finalDs.next();
                    String dataPermId = row.getString(0);
                    long dimId = row.getLong(1);
                    String appId = row.getString(2);
                    String entityNum = row.getString(3);
                    String rule = row.getString(4);
                    if (curDimId != dimId) {
                        if (!CollectionUtils.isEmpty(curDimDataPerm)) {
                            result.put(curDimId + "|" + curDataPermId, curDimDataPerm);
                        }
                        curDimDataPerm = new HashMap(16);
                        curDataPermId = dataPermId;
                        curDimId = dimId;
                    }
                    String nodeId = "entity#" + entityNum + '@' + appId;
                    curDimDataPerm.put(nodeId, rule);
                }
            }
            if (curDimId != -1L && !CollectionUtils.isEmpty(curDimDataPerm)) {
                result.put(curDimId + "|" + curDataPermId, curDimDataPerm);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private void initFuncPermRightTree(Map<String, Map<String, String>> assignPermOriInfoMap, Map<String, Map<String, String>> assignPermCurInfoMap, String dimType, Long dimId) {
        List<String> userPermDetailInfos;
        String sourceKey;
        if (assignPermOriInfoMap == null) {
            assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        }
        if (assignPermCurInfoMap == null) {
            assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        }
        Map<String, String> oriPermMap = assignPermOriInfoMap.get("tree_funcperm");
        Map<String, String> curPermMap = assignPermCurInfoMap.get("tree_funcperm");
        String data = curPermMap.get(sourceKey = dimType + "|" + dimId);
        if (StringUtils.isNotEmpty((String)data)) {
            userPermDetailInfos = SerializationUtils.fromJsonStringToList((String)data, String.class);
        } else {
            Map<String, List<String>> queryData = this.queryUserAssignDimPerm(dimType, Lists.newArrayList((Object[])new Long[]{dimId}));
            userPermDetailInfos = queryData.get(sourceKey);
            if (userPermDetailInfos == null) {
                userPermDetailInfos = new ArrayList<String>(10);
            }
            String serialInfo = SerializationUtils.toJsonString(userPermDetailInfos);
            oriPermMap.put(sourceKey, serialInfo);
            curPermMap.put(sourceKey, serialInfo);
            this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMap);
            this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
        }
        this.buildFuncPermRightTree(sourceKey, userPermDetailInfos);
    }

    private void buildFuncPermRightTree(String sourceKey, List<String> userPermDetailInfos) {
        TreeNode rootNode;
        TreeView tv = (TreeView)this.getControl("tree_funcperm");
        tv.deleteAllNodes();
        HashMap<String, Map<String, List<String>>> dataResource = new HashMap<String, Map<String, List<String>>>(16);
        if (!CollectionUtils.isEmpty(userPermDetailInfos)) {
            this.funcPermTreeUtil.processData(false, dataResource, userPermDetailInfos);
            rootNode = ConstantsHelper.getTreeRootNode((boolean)true, (String)ConstantsHelper.getAllreadyAssignDesc());
            rootNode.setIsOpened(true);
        } else {
            rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllreadyAssignDesc());
        }
        tv.addNode(rootNode);
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, showNum);
        this.getPageCache().putBigObject(sourceKey, SerializationUtils.toJsonString(dataResource));
    }

    private void initFieldPermTree(String dimType, Long dimId) {
        String sourceKey = dimType + "|" + dimId;
        String dataSource = this.getPageCache().getBigObject(sourceKey);
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        if (dataSource == null) {
            TreeView allFuncTv = (TreeView)this.getControl("tree_allfunctionperm");
            this.funcPermTreeUtil.initFuncPermLeftTree(allFuncTv, dimType, showNum);
        }
        this.initFuncPermRightTree(assignPermOriInfoMap, assignPermCurInfoMap, dimType, dimId);
        Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(sourceKey), Map.class);
        TreeView tv = (TreeView)this.getControl("tree_fieldperm");
        tv.deleteAllNodes();
        TreeNode rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllreadyAssignDesc());
        rootNode.setIsOpened(true);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            logger.warn("UserDirectAssignPermMultiPlugin.initFieldPermTree sleep err.", (Throwable)e);
        }
        tv.addNode(rootNode);
        this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, showNum);
        this.getModel().deleteEntryData("entryentity_fps_sensitive");
        this.getModel().deleteEntryData("entryentity_fps");
        this.getModel().deleteEntryData("fieldperm_entry");
        this.getView().setVisible(Boolean.FALSE, new String[]{"tab_fieldperm"});
        Map<String, String> oriFieldPermMap = assignPermOriInfoMap.get("tree_fieldperm");
        Set<String> hasLoadedFieldPermDim = oriFieldPermMap.keySet();
        if (hasLoadedFieldPermDim.contains(sourceKey)) {
            return;
        }
        ArrayList<Long> dimIds = new ArrayList<Long>(10);
        dimIds.add(dimId);
        this.loadFieldPerm(assignPermOriInfoMap, assignPermCurInfoMap, dimType, dimIds);
    }

    private void loadFieldPerm(Map<String, Map<String, String>> assignPermOriInfoMap, Map<String, Map<String, String>> assignPermCurInfoMap, String dimType, List<Long> dimIds) {
        if (assignPermOriInfoMap == null) {
            assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        }
        if (assignPermCurInfoMap == null) {
            assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        }
        Map<String, String> oriFieldPerm = assignPermOriInfoMap.get("tree_fieldperm");
        Map<String, String> curFieldPerm = assignPermCurInfoMap.get("tree_fieldperm");
        Map<String, Map<String, Map<String, Map<String, String>>>> fieldPemData = this.queryUserAssignDimFieldPerm(dimType, dimIds);
        for (Map.Entry<String, Map<String, Map<String, Map<String, String>>>> entry : fieldPemData.entrySet()) {
            String sourceKey = entry.getKey();
            String[] arr = sourceKey.split("\\|");
            Long dimId = Long.valueOf(arr[1]);
            Map<String, Map<String, Map<String, String>>> dimCurfp = entry.getValue();
            String serialStr = SerializationUtils.toJsonString(dimCurfp);
            oriFieldPerm.put(sourceKey, serialStr);
            curFieldPerm.put(sourceKey, serialStr);
            dimIds.remove(dimId);
        }
        for (Long dimId : dimIds) {
            oriFieldPerm.put(dimType + "|" + dimId, SerializationUtils.toJsonString(new HashSet(16)));
            curFieldPerm.put(dimType + "|" + dimId, SerializationUtils.toJsonString(new HashMap(16)));
        }
        this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMap);
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
    }

    private Map<String, Map<String, Map<String, Map<String, String>>>> queryUserAssignDimFieldPerm(String dimType, List<Long> dimIds) {
        Long userId = (Long)this.getModel().getValue("user_id");
        StringBuilder dimIdStr = new StringBuilder();
        for (Long dimId : dimIds) {
            dimIdStr.append(dimId).append(",");
        }
        dimIdStr.deleteCharAt(dimIdStr.length() - 1);
        HashMap<String, Map<String, Map<String, Map<String, String>>>> result = new HashMap<String, Map<String, Map<String, Map<String, String>>>>(dimIds.size());
        try {
            Object row;
            String sourceKey = "";
            StringBuilder fpsSensitiveSql = new StringBuilder().append("SELECT a.fid, a.fdimid, a.fappid, a.fentnum, a.ffieldpermschemeid ").append(" FROM t_perm_userfieldscheme a").append(" INNER JOIN t_perm_fieldscheme b on b.fid = a.ffieldpermschemeid and b.fsensitive = '1' ").append("WHERE a.fuserid = ").append(userId).append(" AND a.fdimtype = '").append(dimType).append("' ").append("AND a.fdimid IN (").append((CharSequence)dimIdStr).append(") ").append("ORDER BY a.fdimid, a.fappid, a.fentnum");
            try (DataSet fpsSensitiveDs = DB.queryDataSet((String)"queryUserAssignDimFpsSensitive", (DBRoute)DBRoute.permission, (String)fpsSensitiveSql.toString());){
                while (fpsSensitiveDs.hasNext()) {
                    row = fpsSensitiveDs.next();
                    long dimId = row.getLong("fdimid");
                    String appId = row.getString("fappid");
                    String entityNum = row.getString("fentnum");
                    String ffieldpermschemeid = row.getString("ffieldpermschemeid");
                    sourceKey = dimType + "|" + dimId;
                    String nodeId = "entity#" + entityNum + '@' + appId;
                    Map entitySettingMap = result.computeIfAbsent(sourceKey, j -> new LinkedHashMap(16));
                    Map fpsSensSetting = entitySettingMap.computeIfAbsent(nodeId, k -> new LinkedHashMap(16));
                    Map fpsSensitiveSettingMap = fpsSensSetting.computeIfAbsent("pgcache_fpssensitive", l -> new LinkedHashMap(16));
                    fpsSensitiveSettingMap.put(ffieldpermschemeid, ffieldpermschemeid);
                }
            }
            StringBuilder fpsSql = new StringBuilder().append("SELECT a.fid, a.fdimid, a.fappid, a.fentnum, a.ffieldpermschemeid ").append(" FROM t_perm_userfieldscheme a").append(" INNER JOIN t_perm_fieldscheme b on b.fid = a.ffieldpermschemeid and b.fsensitive = '0' ").append("WHERE a.fuserid = ").append(userId).append(" AND a.fdimtype = '").append(dimType).append("' ").append("AND a.fdimid IN (").append((CharSequence)dimIdStr).append(") ").append("ORDER BY a.fdimid, a.fappid, a.fentnum");
            DataSet fpsDs = DB.queryDataSet((String)"queryUserAssignDimFps", (DBRoute)DBRoute.permission, (String)fpsSql.toString());
            row = null;
            try {
                while (fpsDs.hasNext()) {
                    Row row2 = fpsDs.next();
                    long dimId = row2.getLong("fdimid");
                    String appId = row2.getString("fappid");
                    String entityNum = row2.getString("fentnum");
                    String ffieldpermschemeid = row2.getString("ffieldpermschemeid");
                    sourceKey = dimType + "|" + dimId;
                    String nodeId = "entity#" + entityNum + '@' + appId;
                    Map entitySettingMap = result.computeIfAbsent(sourceKey, j -> new LinkedHashMap(16));
                    Map fpsSetting = entitySettingMap.computeIfAbsent(nodeId, k -> new LinkedHashMap(16));
                    Map fpsSettingMap = fpsSetting.computeIfAbsent("pgcache_fps", l -> new LinkedHashMap(16));
                    fpsSettingMap.put(ffieldpermschemeid, ffieldpermschemeid);
                }
            }
            catch (Throwable row2) {
                row = row2;
                throw row2;
            }
            finally {
                if (fpsDs != null) {
                    if (row != null) {
                        try {
                            fpsDs.close();
                        }
                        catch (Throwable row2) {
                            ((Throwable)row).addSuppressed(row2);
                        }
                    } else {
                        fpsDs.close();
                    }
                }
            }
            Map<String, Map<String, String>> entityFieldNameMap = this.funcPermTreeUtil.getEntityFieldNameMap();
            StringBuilder sql = new StringBuilder().append("SELECT a.ffieldpermid, a.forgid, b.fbizappid, b.fentitytypeid, b.ffieldname, b.fcontrolmode").append(" FROM t_perm_userfieldperm a ").append(" inner join t_perm_fieldpermdetail b on a.ffieldpermid = b.fid ").append(" where a.fuserid = ").append(userId).append(" and a.fdimtype = '").append(PermCommonUtil.getSuitableDimType((String)dimType)[0]).append("' ").append(" AND a.forgid IN (").append((CharSequence)dimIdStr).append(") ").append(" ORDER BY a.forgid, b.fbizappid, b.fentitytypeid ");
            String curEntityNum = "";
            Map<String, String> fieldInfoMap = null;
            try (DataSet detailDs = DB.queryDataSet((String)"queryUserAssignDimFieldPerm", (DBRoute)DBRoute.permission, (String)sql.toString());){
                while (detailDs.hasNext()) {
                    Row row3 = detailDs.next();
                    String fieldPermId = row3.getString("ffieldpermid");
                    long dimId = row3.getLong("forgid");
                    String appId = row3.getString("fbizappid");
                    String entityNum = row3.getString("fentitytypeid");
                    String fieldName = row3.getString("ffieldname");
                    String controlMode = row3.getString("fcontrolmode");
                    sourceKey = dimType + "|" + dimId;
                    String nodeId = "entity#" + entityNum + '@' + appId;
                    Map entitySettingMap = result.computeIfAbsent(sourceKey, j -> new LinkedHashMap(16));
                    Map detailSetting = entitySettingMap.computeIfAbsent(nodeId, k -> new LinkedHashMap(16));
                    Map detailSettingMap = detailSetting.computeIfAbsent("pgcache_fieldpermdetail", l -> new LinkedHashMap(16));
                    detailSettingMap.put(fieldName, fieldName + "|" + controlMode + "|" + fieldPermId);
                    if (curEntityNum.equals(entityNum)) continue;
                    fieldInfoMap = entityFieldNameMap.get(entityNum);
                    if (fieldInfoMap == null) {
                        fieldInfoMap = this.getEntityFieldNameInfo(entityNum);
                        entityFieldNameMap.put(entityNum, fieldInfoMap);
                    }
                    curEntityNum = entityNum;
                }
            }
            this.getPageCache().putBigObject("entityFieldNameMap", SerializationUtils.toJsonString(entityFieldNameMap));
        }
        catch (Exception e) {
            logger.warn("UserDirectAssignPermMultiPlugin.queryUserAssignDimFieldPerm error.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return result;
    }

    private Map<String, List<String>> queryUserAssignDimPerm(String dimType, List<Long> dimIds) {
        String[] suitableDimType = PermCommonUtil.getSuitableDimType((String)dimType);
        String dimTypeNum = suitableDimType[0];
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(100);
        Long userId = (Long)this.getModel().getValue("user_id");
        try {
            StringBuilder dimIdStr = new StringBuilder();
            if (CollectionUtils.isEmpty(dimIds)) {
                return result;
            }
            for (Long dimId : dimIds) {
                dimIdStr.append(dimId).append(",");
            }
            dimIdStr.deleteCharAt(dimIdStr.length() - 1);
            StringBuilder assignPermInfoSb = new StringBuilder();
            assignPermInfoSb.append("SELECT up.fid, up.forgid, up.fisincludesuborg, upd.fbizappid, upd.fentitytypeid, upd.fpermitemid, pit.fnumber permitemnum FROM t_perm_userperm up ").append(" JOIN t_perm_userpermdetail upd ON up.fid = upd.fid ").append("LEFT JOIN t_perm_permitem pit ON pit.fid = upd.fpermitemid ").append("WHERE up.fuserid = ").append(userId).append(" AND up.fdimtype = '").append(dimTypeNum).append("' ").append(" AND up.forgid IN ( ").append((CharSequence)dimIdStr).append(") ");
            StringBuilder appInfoSb = new StringBuilder();
            appInfoSb.append("SELECT fid, fnumber appnum, fseq aseq, fbizcloudid FROM t_meta_bizapp WHERE ftype <> '2' ");
            StringBuilder cloudInfoSb = new StringBuilder();
            cloudInfoSb.append("SELECT fid, fnumber cloudnum, fseq cseq FROM t_meta_bizcloud ");
            try (DataSet assignPermInfo = DB.queryDataSet((String)"queryAssignPermInfo", (DBRoute)DBRoute.permission, (String)assignPermInfoSb.toString());
                 DataSet appInfo = DB.queryDataSet((String)"queryAppInfo", (DBRoute)DBRoute.meta, (String)appInfoSb.toString());
                 DataSet assignPermInfo2 = assignPermInfo.leftJoin(appInfo).on("fbizappid", "fid").select(new String[]{"fid", "forgid", "fisincludesuborg", "fbizappid", "fentitytypeid", "fpermitemid", "permitemnum"}, new String[]{"appnum", "aseq", "fbizcloudid"}).finish();
                 DataSet cloudInfo = DB.queryDataSet((String)"queryCoudInfo", (DBRoute)DBRoute.meta, (String)cloudInfoSb.toString());
                 DataSet finalDs = assignPermInfo2.leftJoin(cloudInfo).on("fbizcloudid", "fid").select(new String[]{"fid", "forgid", "fisincludesuborg", "fbizcloudid", "fbizappid", "fentitytypeid", "fpermitemid", "permitemnum", "appnum", "aseq"}, new String[]{"cloudnum", "cseq"}).finish().orderBy(new String[]{"forgid"});){
                List permItems;
                HashSet<String> assignPermDetail = new HashSet<String>(100);
                long lastDimId = 0L;
                Map<String, String> entityNumNameMap = this.funcPermTreeUtil.getEntityNumNameMap();
                Map<String, String> allEntityInfoMap = this.funcPermTreeUtil.getAllEntityInfoMap();
                Map allAppInfo = AppMetadataCache.getAllAppInfo();
                while (finalDs.hasNext()) {
                    Row row = finalDs.next();
                    String fid = row.getString("fid");
                    Long dimId = row.getLong("forgid");
                    if (lastDimId != dimId && !CollectionUtils.isEmpty(assignPermDetail)) {
                        permItems = assignPermDetail.stream().sorted().collect(Collectors.toList());
                        result.put(dimType + "|" + lastDimId, permItems);
                        assignPermDetail = new HashSet(100);
                    }
                    String cloudId = row.getString("fbizcloudid");
                    String cloudSeq = row.getString("cseq");
                    String cloudNum = row.getString("cloudnum");
                    String bizAppId = row.getString("fbizappid");
                    String bizAppNum = row.getString("appnum");
                    String appSeq = AppHelper.getAppSeqStr((Map)allAppInfo, (String)row.getString("aseq"), (String)bizAppNum);
                    String entityNum = row.getString("fentitytypeid");
                    String entityName = entityNumNameMap.get(entityNum);
                    String permItemId = row.getString("fpermitemid");
                    String permItemNum = row.getString("permitemnum");
                    String permInfo = String.join((CharSequence)"    ", cloudSeq, cloudNum, cloudId, appSeq, bizAppNum, bizAppId, entityNum, entityName);
                    allEntityInfoMap.putIfAbsent(bizAppId + "|" + entityNum, permInfo);
                    String data = String.join((CharSequence)"    ", cloudSeq, cloudNum, cloudId, appSeq, bizAppNum, bizAppId, entityNum, entityName, permItemNum, permItemId);
                    lastDimId = dimId;
                    assignPermDetail.add(data);
                }
                if (!CollectionUtils.isEmpty(assignPermDetail)) {
                    permItems = assignPermDetail.stream().sorted().collect(Collectors.toList());
                    result.put(dimType + "|" + lastDimId, permItems);
                }
                this.funcPermTreeUtil.putAllEntityInfoMap(allEntityInfoMap);
            }
        }
        catch (Exception e) {
            logger.warn("queryUserAssignDimPerm error", (Throwable)e);
        }
        return result;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if ("deldimtab_callback".equals(callBackId) && result.equals((Object)MessageBoxResult.Yes)) {
            Tab tab = (Tab)this.getControl("dimtab");
            String currentTab = tab.getCurrentTab();
            this.delDimTab(tab, currentTab);
        } else if (callBackId.equals("continue_close") && e.getResult() == MessageBoxResult.Yes) {
            this.release();
        }
    }

    private void release() {
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        if (user != null) {
            Long userId = user.getLong("id");
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
                MutexHelper.release((String)"bos_usergroup_user", (String)"directassignmulti", (String)String.valueOf(userId));
                UserHelper.delEditingPermUserId((List)Lists.newArrayList((Object[])new String[]{userId + ""}));
            }
        }
        PermFormCommonUtil.closeClientForm(this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("task_closeCallback".equals(actionId)) {
            this.handleTaskCallBack(e.getReturnData());
        } else if ("closeCallBack_addAuthScope".equals(actionId)) {
            this.handleAddAuthScopeCallBack(returnData);
        } else if (CLOSECALLBACK_ADDDIM.equals(actionId)) {
            this.handleAddDimCallBack(returnData);
        } else if ("perm_choosefieldpage".equals(actionId)) {
            this.handleAddFPCallBack(returnData, null);
        } else if ("CallBackId_bdPropKey".equals(actionId)) {
            this.handleAddBdDataRuleCallBack(returnData);
        } else if (Objects.equals("CLOSECALLBACK_ADDFPS_SENSITIVE", actionId)) {
            this.handleAddFPCallBack(returnData, Boolean.TRUE);
        } else if (Objects.equals("CLOSECALLBACK_ADDFPS", actionId)) {
            this.handleAddFPCallBack(returnData, Boolean.FALSE);
        }
    }

    private void handleAddFPCallBack(Object returnData, Boolean sensitive) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection col = (ListSelectedRowCollection)returnData;
            if (null == col || col.isEmpty()) {
                return;
            }
            String fpTypeKey = "pgcache_fpssensitive";
            if (null == sensitive) {
                fpTypeKey = "pgcache_fieldpermdetail";
            } else if (!sensitive.booleanValue()) {
                fpTypeKey = "pgcache_fps";
            }
            String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
            String nodeId = this.getPageCache().get("lastClickFieldPermNode");
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
            Set<String> changeFPDimSet = this.assignPermCacheUtil.getChangeFpsDimSet();
            if (null == sensitive) {
                changeFPDimSet = this.assignPermCacheUtil.getChangeFieldPermDimSet();
            }
            Map<String, String> curFieldPerm = assignPermCurInfoMap.get("tree_fieldperm");
            Map dimCurFieldPerm = (Map)SerializationUtils.fromJsonString((String)curFieldPerm.get(sourceKey), Map.class);
            Map nodeFieldPerm = dimCurFieldPerm.computeIfAbsent(nodeId, k -> new LinkedHashMap(16));
            Map fpTypeFieldPerm = nodeFieldPerm.computeIfAbsent(fpTypeKey, k -> new LinkedHashMap(16));
            LinkedHashMap<String, String> curFPSetting = new LinkedHashMap<String, String>(8);
            if (!Objects.equals("pgcache_fieldpermdetail", fpTypeKey)) {
                for (Map.Entry fpTypeFieldPermOne : fpTypeFieldPerm.entrySet()) {
                    curFPSetting.put((String)fpTypeFieldPermOne.getKey(), (String)fpTypeFieldPermOne.getValue());
                }
            }
            boolean dataChange = false;
            boolean updateFieldInfo = false;
            String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
            String entityNum = nodeInfoArr[1];
            Map<String, Map<String, String>> entityFieldNameMap = this.funcPermTreeUtil.getEntityFieldNameMap();
            Map<String, String> fieldNameMap = entityFieldNameMap.get(entityNum);
            if (fieldNameMap == null) {
                fieldNameMap = this.getEntityFieldNameInfo(entityNum);
                entityFieldNameMap.put(entityNum, fieldNameMap);
                updateFieldInfo = true;
            }
            for (ListSelectedRow row : col) {
                Object primaryKeyObj = row.getPrimaryKeyValue();
                if (null == primaryKeyObj) continue;
                if (Objects.equals("pgcache_fieldpermdetail", fpTypeKey)) {
                    String value;
                    String[] arr;
                    String primaryKeyValue = (String)primaryKeyObj;
                    if (StringUtils.isEmpty((String)primaryKeyValue) || null == (arr = primaryKeyValue.split("\\|\\|")) || !Objects.equals(2, arr.length)) continue;
                    String fieldName = arr[0];
                    String fieldComment = arr[1];
                    if (!fieldNameMap.containsKey(fieldName)) {
                        fieldNameMap.put(fieldName, fieldComment);
                        updateFieldInfo = true;
                    }
                    if (StringUtils.isEmpty((String)(value = (String)fpTypeFieldPerm.get(fieldName)))) {
                        curFPSetting.put(fieldName, fieldName + "|10|");
                        dataChange = true;
                        continue;
                    }
                    curFPSetting.put(fieldName, value);
                    continue;
                }
                Long primaryKey = (Long)primaryKeyObj;
                String fpsID = String.valueOf(primaryKey);
                curFPSetting.put(fpsID, fpsID);
                String value = (String)fpTypeFieldPerm.get(fpsID);
                if (!StringUtils.isEmpty((String)value)) continue;
                dataChange = true;
            }
            if (updateFieldInfo) {
                this.getPageCache().putBigObject("entityFieldNameMap", SerializationUtils.toJsonString(entityFieldNameMap));
            }
            if (dataChange) {
                changeFPDimSet.add(sourceKey);
                if (null == sensitive) {
                    this.getPageCache().put("changeFieldPermDimSet", SerializationUtils.toJsonString(changeFPDimSet));
                } else {
                    this.getPageCache().put("changeFpsDimSet", SerializationUtils.toJsonString(changeFPDimSet));
                }
                dimDataChangeSet.add(sourceKey);
                this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
                nodeFieldPerm.put(fpTypeKey, curFPSetting);
                curFieldPerm.put(sourceKey, SerializationUtils.toJsonString((Object)dimCurFieldPerm));
                this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
            }
            this.fillFPToPage(curFPSetting, fieldNameMap, sensitive);
            this.getModel().setValue("datachangeflag", (Object)true);
        }
    }

    private void fillFPToPage(Map<String, String> curFPSetting, Map<String, String> fieldNameMap, Boolean sensitive) {
        if (null == sensitive) {
            this.fillFP_fieldpermdetailToPage(curFPSetting, fieldNameMap);
            return;
        }
        this.fillFP_FPSToPage(curFPSetting, sensitive);
    }

    private void fillFP_fieldpermdetailToPage(Map<String, String> curFPSetting, Map<String, String> fieldNameMap) {
        this.getModel().deleteEntryData("fieldperm_entry");
        if (CollectionUtils.isEmpty(curFPSetting)) {
            return;
        }
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("fieldperm_fieldnum", new Object[0]);
        vs.addField("fieldperm_fieldname", new Object[0]);
        vs.addField("fieldperm_rowcondition", new Object[0]);
        vs.addField("fieldperm_not_allow_query", new Object[0]);
        vs.addField("fieldperm_not_allow_edit", new Object[0]);
        StringBuilder message = new StringBuilder();
        boolean showMessage = false;
        boolean notAllowEdit = true;
        for (Map.Entry<String, String> curFP : curFPSetting.entrySet()) {
            String[] arr;
            String value = curFP.getValue();
            if (StringUtils.isEmpty((String)value) || null == (arr = value.split("\\|", 3)) || !Objects.equals(3, arr.length)) continue;
            String fieldName = arr[0];
            String fieldComment = fieldNameMap.get(fieldName);
            String controlMode = arr[1];
            boolean notAllowQuery = "10".equals(controlMode);
            if ("0".equals(controlMode)) {
                notAllowEdit = false;
                showMessage = true;
                message.append(fieldComment).append(",");
            }
            vs.addRow(new Object[]{fieldName, fieldComment, controlMode, notAllowQuery, notAllowEdit});
        }
        ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("fieldperm_entry", vs);
        dataModel.endInit();
        this.getView().updateView("fieldperm_entry");
        if (showMessage) {
            message.deleteCharAt(message.length() - 1);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u5b58\u5728\u201c\u7981\u6b62\u7f16\u8f91\u201d\u4e3a\u5426\u7684\u914d\u7f6e\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u6216\u79fb\u9664\u5f02\u5e38\u6570\u636e\u3002", (String)"UserDirectAssignPermMultiPlugin_17", (String)"bos-permission-formplugin", (Object[])new Object[]{message.toString()}), Integer.valueOf(3000));
        }
    }

    private void fillFP_FPSToPage(Map<String, String> curFPSetting, Boolean sensitive) {
        String entryProp = "fps_sensitive";
        String entryEntity = "entryentity_fps_sensitive";
        if (!sensitive.booleanValue()) {
            entryProp = "fps";
            entryEntity = "entryentity_fps";
        }
        this.getModel().deleteEntryData(entryEntity);
        if (CollectionUtils.isEmpty(curFPSetting)) {
            return;
        }
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(entryProp, new Object[0]);
        for (Map.Entry<String, String> curFP : curFPSetting.entrySet()) {
            String fpsIdStr = curFP.getValue();
            if (StringUtils.isEmpty((String)fpsIdStr) || StringUtils.isEmpty((String)fpsIdStr)) continue;
            vs.addRow(new Object[]{Long.parseLong(fpsIdStr)});
        }
        ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow(entryEntity, vs);
        dataModel.endInit();
        this.getView().updateView(entryEntity);
    }

    private void handleAddBdDataRuleCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection col = (ListSelectedRowCollection)returnData;
            String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
            String nodeId = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
            Set<String> changeDataRuleDimSet = this.assignPermCacheUtil.getChangeDataRuleDimSet();
            Map<String, Map<String, Map<String, String>>> dataRuleSettingErrorMap = this.assignPermCacheUtil.getDataRuleSettingErrorMap();
            Map<String, String> curDataRule = assignPermCurInfoMap.get("tree_datarule");
            Map dimCurDataRule = (Map)SerializationUtils.fromJsonString((String)curDataRule.get(sourceKey), Map.class);
            Map curBdDataRuleSetting = dimCurDataRule.computeIfAbsent(nodeId, k -> new HashMap(16)).computeIfAbsent(PGCACHE_BDDATARULE, k -> new HashMap(col.size()));
            boolean dataChange = false;
            boolean updateFieldInfo = false;
            String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
            String entityNum = nodeInfoArr[1];
            Map<String, Map<String, String>> entityFieldNameMap = this.funcPermTreeUtil.getEntityFieldNameMap();
            Map<String, String> fieldNameMap = entityFieldNameMap.get(entityNum);
            if (fieldNameMap == null) {
                fieldNameMap = this.getEntityFieldNameInfo(entityNum);
                entityFieldNameMap.put(entityNum, fieldNameMap);
                updateFieldInfo = true;
            }
            String[] selectedDimInfo = this.getSelectedDimInfo();
            for (ListSelectedRow row : col) {
                String primaryKeyValue = (String)row.getPrimaryKeyValue();
                String[] arr = primaryKeyValue.split("\\|\\|");
                if (arr == null || arr.length <= 2) continue;
                String propKey = arr[0];
                String propName = arr[1];
                String propEntity = arr[2];
                String value = (String)curBdDataRuleSetting.get(propKey);
                if (StringUtils.isEmpty((String)value)) {
                    curBdDataRuleSetting.put(propKey, propKey + "|" + propEntity + "| ");
                    String info = selectedDimInfo[1] + "|" + selectedDimInfo[0] + "|" + entityNum + "|" + propName;
                    dataRuleSettingErrorMap.computeIfAbsent(sourceKey, k -> new HashMap(16)).computeIfAbsent(PGCACHE_BDDATARULE, l -> new HashMap(16)).put(nodeId + "|" + propKey, info);
                    this.getPageCache().put("dataRuleSettingErrorMap", SerializationUtils.toJsonString(dataRuleSettingErrorMap));
                    dataChange = true;
                    continue;
                }
                curBdDataRuleSetting.put(propKey, value);
            }
            if (updateFieldInfo) {
                this.getPageCache().putBigObject("entityFieldNameMap", SerializationUtils.toJsonString(entityFieldNameMap));
            }
            if (dataChange) {
                changeDataRuleDimSet.add(sourceKey);
                this.getPageCache().put("changeDataRuleDimSet", SerializationUtils.toJsonString(changeDataRuleDimSet));
                dimDataChangeSet.add(sourceKey);
                this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
                curDataRule.put(sourceKey, SerializationUtils.toJsonString((Object)dimCurDataRule));
                this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
            }
            this.fillBdDataRuleToPage(curBdDataRuleSetting, fieldNameMap);
            this.getModel().setValue("datachangeflag", (Object)true);
        }
    }

    private void fillBdDataRuleToPage(Map<String, String> curBdDataRuleSetting, Map<String, String> fieldNameMap) {
        this.getModel().deleteEntryData("bddatarule_entry");
        if (CollectionUtils.isEmpty(curBdDataRuleSetting)) {
            return;
        }
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("bdpropkey", new Object[0]);
        vs.addField("bdpropname", new Object[0]);
        vs.addField("bdentity", new Object[0]);
        vs.addField("bddatarule", new Object[0]);
        for (String info : curBdDataRuleSetting.values()) {
            String[] arr = info.split("\\|");
            String propKey = arr[0];
            String propName = fieldNameMap.get(propKey);
            String propEntity = arr[1];
            Long dataRuleId = null;
            String dataRuleIdStr = arr[2];
            if (StringUtils.isNotEmpty((String)dataRuleIdStr)) {
                dataRuleId = Long.parseLong(dataRuleIdStr);
            }
            vs.addRow(new Object[]{propKey, propName, propEntity, dataRuleId});
        }
        ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("bddatarule_entry", vs);
        dataModel.endInit();
        this.getView().updateView("bddatarule_entry");
    }

    private void handleAddDimCallBack(Object returnData) {
        if (returnData instanceof ListSelectedRowCollection) {
            Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            Map<String, String> oriFuncPermMap = assignPermOriInfoMap.get("tree_funcperm");
            Map<String, String> curFuncPermMap = assignPermCurInfoMap.get("tree_funcperm");
            Map<String, String> oriFieldPermMap = assignPermOriInfoMap.get("tree_fieldperm");
            Map<String, String> curFieldPermMap = assignPermCurInfoMap.get("tree_fieldperm");
            Map<String, String> oriDataPermMap = assignPermOriInfoMap.get("tree_dataperm");
            Map<String, String> curDataPermMap = assignPermCurInfoMap.get("tree_dataperm");
            Map<String, String> oriDataRuleMap = assignPermOriInfoMap.get("tree_datarule");
            Map<String, String> curDataRuleMap = assignPermCurInfoMap.get("tree_datarule");
            Tab tab = (Tab)this.getControl("dimtab");
            String currentTab = tab.getCurrentTab();
            String[] tabInfoArr = currentTab.split("\\|");
            String dimType = tabInfoArr[0];
            String dimTypeName = tabInfoArr[1];
            Map userDirectAssignDim = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_INFO), Map.class);
            Map curDimTypeAssignInfo = (Map)userDirectAssignDim.get(dimType);
            ListSelectedRowCollection col = (ListSelectedRowCollection)returnData;
            LinkedHashSet<Long> dimIds = new LinkedHashSet<Long>(col.size());
            for (ListSelectedRow row : col) {
                Long dimId = (Long)row.getPrimaryKeyValue();
                dimIds.add(dimId);
            }
            Map dimMap = IsoDimHelper.getDimMap(new ArrayList(dimIds), (String)dimType);
            Map<String, String> dimInfoMap = this.assignPermCacheUtil.getDimInfoMap();
            Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
            Set<String> addDimSet = this.assignPermCacheUtil.getAddDimSet();
            Map<String, String> emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap();
            this.getModel().beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("dimnum", new Object[0]);
            vs.addField("dimname", new Object[0]);
            vs.addField("entitydimtype", new Object[0]);
            vs.addField("includesuborg", new Object[0]);
            for (Long dimId : dimIds) {
                Dim dim = (Dim)dimMap.get(dimId);
                if (null == dim) continue;
                String dimName = dim.getDimName();
                vs.addRow(new Object[]{dimId, dimId, dimType, false});
                curDimTypeAssignInfo.put(String.valueOf(dimId), String.join((CharSequence)",", String.valueOf(dimId), "0", "0", " ", " ", " "));
                String sourceKey = dimType + "|" + dimId;
                addDimSet.add(sourceKey);
                emptyDimMap.put(sourceKey, dimTypeName + "," + dimName);
                dimDataChangeSet.add(sourceKey);
                String dimNumber = dim.getDimNumber();
                dimInfoMap.put(sourceKey, dimNumber + "," + dimName);
                String oriFuncPermStr = SerializationUtils.toJsonString(new ArrayList(10));
                oriFuncPermMap.put(sourceKey, oriFuncPermStr);
                curFuncPermMap.put(sourceKey, oriFuncPermStr);
                String oriStr = SerializationUtils.toJsonString(new HashMap(16));
                oriFieldPermMap.put(sourceKey, oriStr);
                curFieldPermMap.put(sourceKey, oriStr);
                oriDataPermMap.put(sourceKey, oriStr);
                curDataPermMap.put(sourceKey, oriStr);
                oriDataRuleMap.put(sourceKey, oriStr);
                curDataRuleMap.put(sourceKey, oriStr);
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("dim_entry", vs);
            this.getModel().endInit();
            this.getView().updateView("dim_entry");
            HashMap<String, String> newDataMap = new HashMap<String, String>(16);
            newDataMap.put(PGCACHE_USER_ASSIGN_INFO, SerializationUtils.toJsonString((Object)userDirectAssignDim));
            newDataMap.put("addDimSet", SerializationUtils.toJsonString(addDimSet));
            newDataMap.put("emptyDimMap", SerializationUtils.toJsonString(emptyDimMap));
            newDataMap.put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
            newDataMap.put("dimInfoMap", SerializationUtils.toJsonString(dimInfoMap));
            this.getPageCache().put(newDataMap);
            this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMap);
            this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
            this.clearTreeViewAndEntry();
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addnode", "btn_delnode"});
            this.getModel().setValue("datachangeflag", (Object)true);
            EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
            eg.addRowClickListener((RowClickEventListener)this);
            int entryCount = this.getModel().getEntryRowCount("dim_entry");
            if (entryCount > 0) {
                int selRow = entryCount - dimMap.size();
                eg.selectRows(selRow);
                eg.getEntryState().selectRow(selRow);
                eg.getEntryState().setFocusRow(selRow);
                eg.entryRowClick(Integer.valueOf(selRow));
            }
        }
    }

    private void handleAddAuthScopeCallBack(Object returnData) {
        if (returnData instanceof String) {
            String key = (String)returnData;
            String[] returnDataArr = key.split("\\|");
            String tabName = returnDataArr[1];
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(key);
            tabPageAp.setName(new LocaleString(tabName));
            Tab tab = (Tab)this.getControl("dimtab");
            tab.addTabSelectListener((TabSelectListener)this);
            ArrayList<Map> items = new ArrayList<Map>(10);
            items.add(tabPageAp.createControl());
            tab.addControls(items);
            String pageCache_tabKeys = this.getPageCache().get(PGCACHE_DIMTABKEYS);
            List tabKeyList = (List)SerializationUtils.fromJsonString((String)pageCache_tabKeys, List.class);
            tabKeyList.add(tabPageAp.getKey());
            HashMap<String, String> newDataCache = new HashMap<String, String>(16);
            newDataCache.put(PGCACHE_DIMTABKEYS, SerializationUtils.toJsonString((Object)tabKeyList));
            Map userDirectAssignDim = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_INFO), Map.class);
            userDirectAssignDim.put(returnDataArr[0], new LinkedHashMap(16));
            newDataCache.put(PGCACHE_USER_ASSIGN_INFO, SerializationUtils.toJsonString((Object)userDirectAssignDim));
            this.getPageCache().put(newDataCache);
            tab.selectTab(key);
            tab.activeTab(key);
        }
    }

    private void handleTaskCallBack(Object returnData) {
        try {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result;
            if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && !StringUtils.isBlank((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String msgType;
                String data = taskInfo.getData();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                IFormView view = this.getView();
                String msg = String.valueOf(dataMap.get("msg"));
                switch (msgType = String.valueOf(dataMap.get("msgType"))) {
                    case "errorNotice": {
                        view.showErrorNotification(msg);
                        break;
                    }
                    case "showMess": {
                        view.showMessage(msg);
                        break;
                    }
                    case "successNotice": {
                        Map updateDimUserPermMap = (Map)dataMap.get("updateDimInfo");
                        this.fillDimUserPermInfo(updateDimUserPermMap);
                        this.clearCacheAfterSave();
                        Integer showTime = (Integer)dataMap.get("showTime");
                        view.showSuccessNotification(msg, showTime);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn("UserDirectAssignPermMultiPlugin.handleTaskCallBack error", (Throwable)e);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent e) {
        TreeView tv = (TreeView)e.getSource();
        String nodeId = (String)e.getNodeId();
        String dimType = (String)this.getModel().getValue("dimtype");
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        switch (tv.getKey()) {
            case "tree_allfunctionperm": 
            case "tree_datarule": {
                String sourceKey = dimType;
                Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(sourceKey), Map.class);
                this.funcPermTreeUtil.commonAddNode(tv, nodeId, dataResource, showNum);
                break;
            }
            case "tree_funcperm": 
            case "tree_fieldperm": 
            case "tree_dataperm": {
                String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
                String batchAssignFlag = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
                if (StringUtils.isNotEmpty((String)batchAssignFlag)) {
                    sourceKey = BATCH_ASSIGN;
                }
                Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(sourceKey), Map.class);
                this.funcPermTreeUtil.commonAddNode(tv, nodeId, dataResource, showNum);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        String parentNodeId = (String)evt.getParentNodeId();
        TreeView tv = (TreeView)evt.getSource();
        String key = tv.getKey();
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        if (nodeId.startsWith("entity#")) {
            if ("tree_fieldperm".equals(key)) {
                String lastFieldPermCheckNode = this.getPageCache().get("lastClickFieldPermNode");
                if (nodeId.equals(lastFieldPermCheckNode)) {
                    return;
                }
                this.getPageCache().put("lastClickFieldPermNode", nodeId);
                this.getView().setVisible(Boolean.TRUE, new String[]{"tab_fieldperm"});
                this.getModel().deleteEntryData("entryentity_fps_sensitive");
                this.getModel().deleteEntryData("entryentity_fps");
                this.getModel().deleteEntryData("fieldperm_entry");
                Tab fieldTab = (Tab)this.getControl("tab_fieldperm");
                String lastClickFieldTab = this.getPageCache().get(PGCACHE_LASTCLICK_FIELDTAB);
                if (StringUtils.isEmpty((String)lastClickFieldTab)) {
                    lastClickFieldTab = "tab_fp_sensitive";
                }
                fieldTab.selectTab(lastClickFieldTab);
                fieldTab.activeTab(lastClickFieldTab);
            } else if ("tree_dataperm".equals(key)) {
                String opName;
                boolean chargeOrg;
                Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
                assert (assignPermCurInfoMap != null);
                this.needUpdateDataPermPageCache(sourceKey, assignPermCurInfoMap);
                String lastDataPermCheckNode = this.getPageCache().get(PGCACHE_LASTCLICK_DATAPERM_NODE);
                if (nodeId.equals(lastDataPermCheckNode)) {
                    return;
                }
                this.getPageCache().put(PGCACHE_LASTCLICK_DATAPERM_NODE, nodeId);
                Map<String, String> curDataPerm = assignPermCurInfoMap.get("tree_dataperm");
                Map dimCurDataPerm = (Map)SerializationUtils.fromJsonString((String)curDataPerm.get(sourceKey), Map.class);
                String rule = (String)dimCurDataPerm.get(nodeId);
                String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
                String entityNum = nodeInfoArr[1];
                this.clearDataPermFilterGrid();
                FilterGrid filterGrid = (FilterGrid)this.getControl("filtergrid_dataperm");
                filterGrid.setEntityNumber(entityNum);
                EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
                List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
                PermCommonUtil.removeExtraColumn((List)filterColumns, (MainEntityType)entityType);
                filterGrid.setFilterColumns(filterColumns);
                if (StringUtils.isNotEmpty((String)rule)) {
                    FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rule, FilterCondition.class);
                    filterGrid.SetValue(filterCondition);
                }
                if (chargeOrg = this.checkAdminChargeOrg(opName = ResManager.loadKDString((String)"\u4fee\u6539\u65e7\u6570\u636e\u89c4\u5219", (String)"UserDirectAssignPermMultiPlugin_18", (String)"bos-permission-formplugin", (Object[])new Object[0]))) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap121"});
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"flexpanelap121"});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"filtergrid_dataperm"});
                this.getView().updateView("filtergrid_dataperm");
            } else if ("tree_datarule".equals(key)) {
                String lastDataRuleCheckNode = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
                if (nodeId.equals(lastDataRuleCheckNode) && !"reload".equals(parentNodeId)) {
                    return;
                }
                this.getPageCache().put(PGCACHE_LASTCLICK_DATARULE_NODE, nodeId);
                String lastClickDataRuleTab = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULETAB);
                this.getView().setVisible(Boolean.TRUE, new String[]{"tab_datarule"});
                this.getModel().deleteEntryData("datarule_entry");
                this.getModel().deleteEntryData("bddatarule_entry");
                Tab dataRuleTab = (Tab)this.getControl("tab_datarule");
                String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
                String entityNum = nodeInfoArr[1];
                boolean isReportForm = this.recordIsReportFormOrNot(entityNum);
                if (isReportForm) {
                    dataRuleTab.selectTab("tabpage_bddatarule");
                    dataRuleTab.activeTab("tabpage_bddatarule");
                } else {
                    if (StringUtils.isEmpty((String)lastClickDataRuleTab)) {
                        lastClickDataRuleTab = "tabpage_datarule";
                    }
                    dataRuleTab.selectTab(lastClickDataRuleTab);
                    dataRuleTab.activeTab(lastClickDataRuleTab);
                }
            }
        } else {
            this.getView().showTipNotification(ConstantsHelper.getDesc_PleaseChooseEntNodeFirst());
            this.resetEntryInfo();
        }
    }

    public boolean recordIsReportFormOrNot(String entityNum) {
        Boolean isReportFormModel = false;
        String sql = "select fmodeltype from t_meta_mainentityinfo where fid = ? ";
        isReportFormModel = (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{entityNum}, rs -> {
            if (rs.next()) {
                return "ReportFormModel".equals(rs.getString("fmodeltype"));
            }
            return false;
        });
        this.getPageCache().put("treeNodeIsReportForm", isReportFormModel.toString());
        return isReportFormModel;
    }

    private void resetEntryInfo() {
        try {
            this.clearDataPermFilterGrid();
            Future submit = pool.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    UserDirectAssignPermMultiPlugin.this.getModel().deleteEntryData("entryentity_fps_sensitive");
                    UserDirectAssignPermMultiPlugin.this.getModel().deleteEntryData("entryentity_fps");
                    UserDirectAssignPermMultiPlugin.this.getModel().deleteEntryData("fieldperm_entry");
                    UserDirectAssignPermMultiPlugin.this.getModel().deleteEntryData("datarule_entry");
                    UserDirectAssignPermMultiPlugin.this.getModel().deleteEntryData("bddatarule_entry");
                    return null;
                }
            });
            submit.get();
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtergrid_dataperm", "tab_datarule", "tab_fieldperm"});
            this.getPageCache().remove("lastClickFieldPermNode");
            this.getPageCache().remove(PGCACHE_LASTCLICK_DATAPERM_NODE);
            this.getPageCache().remove(PGCACHE_LASTCLICK_DATARULE_NODE);
        }
        catch (Exception e) {
            logger.warn("UserDirectAssignPermMultiPlugin.resetEntryInfo error", (Throwable)e);
        }
    }

    public void beforeClick(BeforeClickEvent e) {
        Button button;
        String key;
        super.beforeClick(e);
        Object source = e.getSource();
        if (source instanceof Button && ("btn_addnode".equals(key = (button = (Button)source).getKey()) || "btn_delnode".equals(key))) {
            String opName = "btn_addnode".equals(key) ? ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"UserDirectAssignPermMultiPlugin_20", (String)"bos-permission-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u79fb\u9664", (String)"UserDirectAssignPermMultiPlugin_21", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            boolean setCancel = this.checkAdminChargeOrg(opName);
            long currUserId = RequestContext.get().getCurrUserId();
            boolean adminUser = PermissionServiceHelper.isAdminUser((long)currUserId);
            boolean isOrgDimType = "bos_org".equals(this.getModel().getValue("dimtype"));
            if (setCancel) {
                e.setCancel(true);
            } else if ("btn_addnode".equals(key) && adminUser && isOrgDimType) {
                EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
                int[] selectRows = eg.getSelectRows();
                StringBuilder sourceKey = new StringBuilder();
                String dimType = (String)this.getModel().getValue("dimtype");
                for (int row : selectRows) {
                    Long dimId = (Long)this.getModel().getValue(DIMNUM_ID, row);
                    sourceKey.append(dimType).append("|").append(dimId).append(",");
                }
                sourceKey.deleteCharAt(sourceKey.length() - 1);
                this.getPageCache().put(PGCACHE_LASTENTRYROWCLICK, sourceKey.toString());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        List adminChargeApps;
        String opName;
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (!(source instanceof FormOperate)) {
            return;
        }
        FormOperate op = (FormOperate)source;
        String opKey = op.getOperateKey();
        if ("deleteentry_dim".equals(opKey)) {
            this.someBeforeDoOper(ResManager.loadKDString((String)"\u5220\u884c", (String)"UserDirectAssignPermMultiPlugin_22", (String)"bos-permission-formplugin", (Object[])new Object[0]), e, this.getSelectedDimEntry(), op, "delDimIds");
        } else if ("deleteentry_fieldperm".equals(opKey)) {
            this.someBeforeDoOper(ResManager.loadKDString((String)"\u5220\u884c", (String)"UserDirectAssignPermMultiPlugin_22", (String)"bos-permission-formplugin", (Object[])new Object[0]), e, this.getDelFieldPerm(), op, "delFieldPerm");
        } else if (Objects.equals("deleteentry_fps", opKey)) {
            this.someBeforeDoOper(ResManager.loadKDString((String)"\u5220\u9664\u5b57\u6bb5\u65b9\u6848", (String)"UserDirectAssignPermMultiPlugin_23", (String)"bos-permission-formplugin", (Object[])new Object[0]), e, this.getDelFps("entryentity_fps", "fps"), op, "delFps");
        } else if (Objects.equals("deleteentry_fps_sensitive", opKey)) {
            this.someBeforeDoOper(ResManager.loadKDString((String)"\u5220\u9664\u654f\u611f\u5b57\u6bb5\u65b9\u6848", (String)"UserDirectAssignPermMultiPlugin_24", (String)"bos-permission-formplugin", (Object[])new Object[0]), e, this.getDelFps("entryentity_fps_sensitive", "fps_sensitive"), op, "delFpsSensitive");
        } else if ("donothing_choosefield".equals(opKey)) {
            opName = ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"UserDirectAssignPermMultiPlugin_25", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            boolean setCancel = this.checkAdminChargeOrg(opName);
            if (setCancel) {
                e.setCancel(true);
            }
        } else if ("deleteentry_datarule".equals(opKey)) {
            this.someBeforeDoOper(ResManager.loadKDString((String)"\u5220\u884c", (String)"UserDirectAssignPermMultiPlugin_22", (String)"bos-permission-formplugin", (Object[])new Object[0]), e, this.getDelDataRule(), op, "delDataRule");
        } else if ("deleteentry_bddatarule".equals(opKey)) {
            this.someBeforeDoOper(ResManager.loadKDString((String)"\u5220\u884c", (String)"UserDirectAssignPermMultiPlugin_22", (String)"bos-permission-formplugin", (Object[])new Object[0]), e, this.getDelBdDataRule(), op, "delBdDataRule");
        } else if ("newentry_fps_sensitive".equals(opKey) || "newentry_fps".equals(opKey) || "newentry_bddatarule".equals(opKey)) {
            opName = ResManager.loadKDString((String)"\u65b0\u589e", (String)"UserDirectAssignPermMultiPlugin_26", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            boolean setCancel = this.checkAdminChargeOrg(opName);
            if (setCancel) {
                e.setCancel(true);
            }
        } else if ("newentry_datarule".equals(opKey)) {
            String treeNodeIsReportForm = this.getPageCache().get("treeNodeIsReportForm");
            if (VALUE_TRUE.equals(treeNodeIsReportForm)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u4e8e\u201c\u62a5\u8868\u201d\u7c7b\u578b\uff0c\u4e0d\u652f\u6301\u914d\u7f6e\u201c\u6570\u636e\u89c4\u5219\u201d\u3002", (String)"UserDirectAssignPermMultiPlugin_27", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String opName2 = ResManager.loadKDString((String)"\u65b0\u589e", (String)"UserDirectAssignPermMultiPlugin_26", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            boolean setCancel = this.checkAdminChargeOrg(opName2);
            if (setCancel) {
                e.setCancel(true);
            }
        }
        String showFormSpecial = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if (!VALUE_TRUE.equals(showFormSpecial) && (opKey.contains("fps") || opKey.contains("field")) && !(adminChargeApps = AdminPermCache.getAdminChargeApps((Long)RequestContext.get().getCurrUserId(), null)).isEmpty()) {
            String notInChargeAppMes;
            String nodeId = this.getPageCache().get("lastClickFieldPermNode");
            if (StringUtils.isEmpty((String)nodeId) || !nodeId.startsWith("entity#")) {
                this.getView().showTipNotification(ConstantsHelper.getDesc_PleaseChooseEntNodeFirst(), Integer.valueOf(2000));
                return;
            }
            String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
            String appId = nodeInfoArr[0];
            HashSet<String> appNotInCharge = new HashSet<String>(1);
            if (!adminChargeApps.contains(appId)) {
                appNotInCharge.add(appId);
            }
            String operationName = null;
            if ("newentry_fps_sensitive".equals(opKey) || "newentry_fps".equals(opKey) || "donothing_choosefield".equals(opKey)) {
                operationName = ResManager.loadKDString((String)"\u65b0\u589e\u5b57\u6bb5\u6743\u9650", (String)"RoleEditNewPlugin_32", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            } else if ("deleteentry_fps_sensitive".equals(opKey) || "deleteentry_fps".equals(opKey) || "deleteentry_fieldperm".equals(opKey)) {
                operationName = ResManager.loadKDString((String)"\u79fb\u9664\u5b57\u6bb5\u6743\u9650", (String)"RoleEditNewPlugin_33", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            }
            if (operationName != null && StringUtils.isNotEmpty((String)(notInChargeAppMes = PermFormCommonUtil.getNotInChargeAppMes(false, appNotInCharge, operationName)))) {
                this.getView().showErrorNotification(notInChargeAppMes);
                e.setCancel(true);
                return;
            }
        }
    }

    private void someBeforeDoOper(String opName, BeforeDoOperationEventArgs e, List<String> delList, FormOperate op, String delVariableKey) {
        boolean setCancel = this.checkAdminChargeOrg(opName);
        if (setCancel) {
            e.setCancel(true);
            return;
        }
        if (CollectionUtils.isEmpty(delList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u5220\u9664\u7684\u884c\u3002", (String)"UserDirectAssignPermMultiPlugin_28", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("delDimIds".equals(delVariableKey)) {
            int[] selectRows;
            delList.clear();
            EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
            for (int row : selectRows = eg.getSelectRows()) {
                DynamicObject value = (DynamicObject)this.getModel().getValue("dimnum", row);
                if (value == null) continue;
                delList.add(value.getPkValue() + "");
            }
        }
        op.getOption().setVariableValue(delVariableKey, SerializationUtils.toJsonString(delList));
    }

    private boolean checkAdminChargeOrg(String opName) {
        boolean setCancel = false;
        long currUserId = RequestContext.get().getCurrUserId();
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)currUserId);
        boolean isOrgDimType = "bos_org".equals(this.getModel().getValue("dimtype"));
        if (isOrgDimType && adminUser) {
            EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
            int[] selectRows = eg.getSelectRows();
            int[][] rows = new PermissionServiceImpl().checkAdminChargeOrgsAndHint(this.getModel(), this.getView(), null, "dimnum", selectRows, currUserId, opName);
            if (rows[1] != null) {
                if (selectRows.length != 1) {
                    eg.clearEntryState();
                    if (rows[0] != null) {
                        eg.selectRows(rows[0], rows[0][0]);
                    } else {
                        setCancel = true;
                    }
                } else {
                    setCancel = true;
                }
            }
        }
        return setCancel;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Object source = e.getSource();
        String operateKey = e.getOperateKey();
        if (source instanceof FormOperate) {
            FormOperate op = (FormOperate)source;
            OperateOption option = op.getOption();
            if ("deleteentry_dim".equals(operateKey)) {
                if (option.containsVariable("delDimIds")) {
                    String delDimIds = option.getVariableValue("delDimIds");
                    if (StringUtils.isNotEmpty((String)delDimIds)) {
                        List delDims = (List)SerializationUtils.fromJsonString((String)delDimIds, List.class);
                        this.clearCacheAfterDelDim(delDims);
                    }
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addnode", "btn_delnode"});
                    EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
                    int endIndex = eg.getEntryData().getDataEntitys().length;
                    if (endIndex > 0) {
                        eg.addRowClickListener((RowClickEventListener)this);
                        this.clickFirstRow();
                    }
                    if (Objects.equals(0, endIndex)) {
                        IPageCache pageCache = this.getPageCache();
                        pageCache.remove(PGCACHE_LASTENTRYROWCLICK);
                    }
                }
            } else if ("deleteentry_fieldperm".equals(operateKey)) {
                if (option.containsVariable("delFieldPerm")) {
                    String delFieldPerm = option.getVariableValue("delFieldPerm");
                    if (StringUtils.isEmpty((String)delFieldPerm)) {
                        return;
                    }
                    List delFieldPermList = (List)SerializationUtils.fromJsonString((String)delFieldPerm, List.class);
                    if (null == delFieldPermList || delFieldPermList.isEmpty()) {
                        return;
                    }
                    String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
                    String fieldPermClickNode = this.getPageCache().get("lastClickFieldPermNode");
                    Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
                    Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
                    Set<String> changeFieldPermDimSet = this.assignPermCacheUtil.getChangeFieldPermDimSet();
                    Map<String, String> curFieldPerm = assignPermCurInfoMap.get("tree_fieldperm");
                    Map curDimFieldPerm = (Map)SerializationUtils.fromJsonString((String)curFieldPerm.get(sourceKey), Map.class);
                    Map nodeFieldPerm = (Map)curDimFieldPerm.get(fieldPermClickNode);
                    if (null == nodeFieldPerm || nodeFieldPerm.isEmpty()) {
                        return;
                    }
                    Map fpTypeFieldPerm = (Map)nodeFieldPerm.get("pgcache_fieldpermdetail");
                    if (null == fpTypeFieldPerm || fpTypeFieldPerm.isEmpty()) {
                        return;
                    }
                    for (String fieldName : delFieldPermList) {
                        fpTypeFieldPerm.remove(fieldName);
                    }
                    if (CollectionUtils.isEmpty((Map)fpTypeFieldPerm)) {
                        nodeFieldPerm.remove("pgcache_fieldpermdetail");
                    }
                    if (CollectionUtils.isEmpty((Map)nodeFieldPerm)) {
                        curDimFieldPerm.remove(fieldPermClickNode);
                    }
                    changeFieldPermDimSet.add(sourceKey);
                    dimDataChangeSet.add(sourceKey);
                    this.getPageCache().put("changeFieldPermDimSet", SerializationUtils.toJsonString(changeFieldPermDimSet));
                    this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
                    curFieldPerm.put(sourceKey, SerializationUtils.toJsonString((Object)curDimFieldPerm));
                    this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
                    this.getModel().setValue("datachangeflag", (Object)true);
                }
            } else if ("deleteentry_fps".equals(operateKey)) {
                this.fpsDelEntryAfterDoOper("delFps", "pgcache_fps", option);
            } else if ("deleteentry_fps_sensitive".equals(operateKey)) {
                this.fpsDelEntryAfterDoOper("delFpsSensitive", "pgcache_fpssensitive", option);
            } else if ("deleteentry_datarule".equals(operateKey)) {
                this.drDelEntryAfterDoOper("delDataRule", PGCACHE_DATARULE, option);
            } else if ("deleteentry_bddatarule".equals(operateKey)) {
                this.drDelEntryAfterDoOper("delBdDataRule", PGCACHE_BDDATARULE, option);
            } else if ("donothing_choosefield".equals(operateKey)) {
                this.showFieldForm("fieldperm_entry");
            } else if ("newentry_bddatarule".equals(operateKey)) {
                this.showFieldForm("bddatarule_entry");
            } else if ("newentry_datarule".equals(operateKey)) {
                EntryGrid eg = (EntryGrid)this.getControl("datarule_entry");
                int[] selectRows = eg.getSelectRows();
                this.getView().setEnable(Boolean.FALSE, selectRows[0], new String[]{"datarule"});
            } else if ("newentry_fps_sensitive".equals(operateKey)) {
                this.showFieldForm("entryentity_fps_sensitive");
            } else if ("newentry_fps".equals(operateKey)) {
                this.showFieldForm("entryentity_fps");
            }
        }
    }

    private void drDelEntryAfterDoOper(String delDrPgCacheKey, String pgcacheDrKey, OperateOption option) {
        if (!option.containsVariable(delDrPgCacheKey)) {
            return;
        }
        String delBdDataRule = option.getVariableValue(delDrPgCacheKey);
        if (StringUtils.isNotEmpty((String)delBdDataRule)) {
            List delBdPropKeyList = (List)SerializationUtils.fromJsonString((String)delBdDataRule, List.class);
            String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
            String dataRuleClickNode = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
            Set<String> changeDataRuleDimSet = this.assignPermCacheUtil.getChangeDataRuleDimSet();
            Map<String, Map<String, Map<String, String>>> dataRuleSettingErrorMap = this.assignPermCacheUtil.getDataRuleSettingErrorMap();
            Map<String, String> curDataRule = assignPermCurInfoMap.get("tree_datarule");
            Map dimCurDataRule = (Map)SerializationUtils.fromJsonString((String)curDataRule.get(sourceKey), Map.class);
            Map nodeDataRule = dimCurDataRule.computeIfAbsent(dataRuleClickNode, k -> new HashMap(16));
            Map dataRuleSetting = nodeDataRule.computeIfAbsent(pgcacheDrKey, k -> new HashMap(16));
            boolean hasDataRuleError = false;
            Map<String, Map<String, String>> curDimDataRuleError = dataRuleSettingErrorMap.get(sourceKey);
            Map<String, String> curNodeError = null;
            if (!CollectionUtils.isEmpty(curDimDataRuleError) && !CollectionUtils.isEmpty(curNodeError = curDimDataRuleError.get(pgcacheDrKey))) {
                hasDataRuleError = true;
            }
            for (String propKey : delBdPropKeyList) {
                dataRuleSetting.remove(propKey);
                if (!hasDataRuleError) continue;
                curNodeError.remove(dataRuleClickNode + "|" + propKey);
            }
            changeDataRuleDimSet.add(sourceKey);
            dimDataChangeSet.add(sourceKey);
            HashMap<String, String> newCacheData = new HashMap<String, String>(16);
            newCacheData.put("dataRuleSettingErrorMap", SerializationUtils.toJsonString(dataRuleSettingErrorMap));
            newCacheData.put("changeDataRuleDimSet", SerializationUtils.toJsonString(changeDataRuleDimSet));
            newCacheData.put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
            this.getPageCache().put(newCacheData);
            curDataRule.put(sourceKey, SerializationUtils.toJsonString((Object)dimCurDataRule));
            this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
            this.getModel().setValue("datachangeflag", (Object)true);
        }
    }

    private void fpsDelEntryAfterDoOper(String delFpsPgCacheKey, String pgcacheFpsKey, OperateOption option) {
        if (!option.containsVariable(delFpsPgCacheKey)) {
            return;
        }
        String delFps = option.getVariableValue(delFpsPgCacheKey);
        if (StringUtils.isNotEmpty((String)delFps)) {
            List delFpsList = (List)SerializationUtils.fromJsonString((String)delFps, List.class);
            String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
            String fpsClickNode = this.getPageCache().get("lastClickFieldPermNode");
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
            Set<String> changeFpsDimSet = this.assignPermCacheUtil.getChangeFpsDimSet();
            Map<String, Map<String, Map<String, String>>> fpSettingErrorMap = this.assignPermCacheUtil.getFPSettingErrorMap();
            Map<String, String> curFP = assignPermCurInfoMap.get("tree_fieldperm");
            Map dimCurFP = (Map)SerializationUtils.fromJsonString((String)curFP.get(sourceKey), Map.class);
            Map nodeFP = dimCurFP.computeIfAbsent(fpsClickNode, k -> new HashMap(16));
            Map fpsSetting = nodeFP.computeIfAbsent(pgcacheFpsKey, k -> new HashMap(16));
            boolean hasError = false;
            Map<String, Map<String, String>> curDimFpsError = fpSettingErrorMap.get(sourceKey);
            Map<String, String> curNodeError = null;
            if (!CollectionUtils.isEmpty(curDimFpsError) && !CollectionUtils.isEmpty(curNodeError = curDimFpsError.get(pgcacheFpsKey))) {
                hasError = true;
            }
            for (String delFpsId : delFpsList) {
                fpsSetting.remove(delFpsId);
                if (!hasError) continue;
                curNodeError.remove(fpsClickNode);
            }
            changeFpsDimSet.add(sourceKey);
            dimDataChangeSet.add(sourceKey);
            HashMap<String, String> newCacheData = new HashMap<String, String>(16);
            newCacheData.put("fpSettingErrorMap", SerializationUtils.toJsonString(fpSettingErrorMap));
            newCacheData.put("changeFpsDimSet", SerializationUtils.toJsonString(changeFpsDimSet));
            newCacheData.put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
            this.getPageCache().put(newCacheData);
            curFP.put(sourceKey, SerializationUtils.toJsonString((Object)dimCurFP));
            this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
            this.getModel().setValue("datachangeflag", (Object)true);
        }
    }

    private void clearCacheAfterDelDim(List<String> delDims) {
        if (CollectionUtils.isEmpty(delDims)) {
            return;
        }
        this.getModel().setValue("datachangeflag", (Object)true);
        String dimType = (String)this.getModel().getValue("dimtype");
        Map userDirectAssignDim = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_INFO), Map.class);
        Map curDimTypeAssignInfo = (Map)userDirectAssignDim.get(dimType);
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        Set<String> addDimSet = this.assignPermCacheUtil.getAddDimSet();
        Map<String, String> emptyDimMap = this.assignPermCacheUtil.getEmptyDimMap();
        Set<String> removeDimSet = this.assignPermCacheUtil.getRemoveDimSet();
        Set<String> changeFieldPermDimSet = this.assignPermCacheUtil.getChangeFieldPermDimSet();
        Set<String> removeFieldPermDimSet = this.assignPermCacheUtil.getRemoveFieldPermDimSet();
        Set<String> changeDataPermDimSet = this.assignPermCacheUtil.getChangeDataPermDimSet();
        Set<String> removeDataPermDimSet = this.assignPermCacheUtil.getRemoveDataPermDimSet();
        Set<String> changeDataRuleDimSet = this.assignPermCacheUtil.getChangeDataRuleDimSet();
        Set<String> removeDataRuleDimSet = this.assignPermCacheUtil.getRemoveDataRuleDimSet();
        Set<String> changeFpsDimSet = this.assignPermCacheUtil.getChangeFpsDimSet();
        Set<String> removeFpsDimSet = this.assignPermCacheUtil.getRemoveFpsDimSet();
        Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        Map<String, Map<String, String>> dataPermSettingErrorMap = this.assignPermCacheUtil.getDataPermSettingErrorMap();
        Map<String, Map<String, Map<String, String>>> dataRuleSettingErrorMap = this.assignPermCacheUtil.getDataRuleSettingErrorMap();
        Map<String, Map<String, Map<String, String>>> fpSettingErrorMap = this.assignPermCacheUtil.getFPSettingErrorMap();
        HashSet<String> removeDimTypeDimIdSet = new HashSet<String>(8);
        for (String dimId : delDims) {
            String userFieldPermId;
            String sourceKey = dimType + "|" + dimId;
            String[] dimAssignInfoArr = ((String)curDimTypeAssignInfo.get(dimId)).split(",");
            emptyDimMap.remove(sourceKey);
            addDimSet.remove(sourceKey);
            dimDataChangeSet.remove(sourceKey);
            String userPermId = dimAssignInfoArr[3];
            if (StringUtils.isNotEmpty((String)userPermId)) {
                removeDimSet.add(sourceKey + "|" + userPermId);
            }
            if (StringUtils.isNotEmpty((String)(userFieldPermId = dimAssignInfoArr[4]))) {
                removeFieldPermDimSet.add(userFieldPermId);
            } else {
                changeFieldPermDimSet.remove(sourceKey);
            }
            String userDataPermId = dimAssignInfoArr[5];
            if (StringUtils.isNotEmpty((String)userDataPermId)) {
                removeDataPermDimSet.add(userDataPermId);
            } else {
                changeDataPermDimSet.remove(sourceKey);
            }
            removeDataRuleDimSet.add(sourceKey);
            changeDataRuleDimSet.remove(sourceKey);
            removeFpsDimSet.add(sourceKey);
            changeFpsDimSet.remove(sourceKey);
            assignPermOriInfoMap.values().forEach(x -> {
                String cfr_ignored_0 = (String)x.remove(dimType + "|" + dimId);
            });
            assignPermCurInfoMap.values().forEach(x -> {
                String cfr_ignored_0 = (String)x.remove(dimType + "|" + dimId);
            });
            removeDimTypeDimIdSet.add(dimType + "|" + dimId);
            curDimTypeAssignInfo.remove(dimId);
            dataPermSettingErrorMap.remove(sourceKey);
            dataRuleSettingErrorMap.remove(sourceKey);
            fpSettingErrorMap.remove(sourceKey);
        }
        this.getPageCache().batchRemove(new ArrayList(removeDimTypeDimIdSet));
        HashMap<String, String> newDataCache = new HashMap<String, String>(16);
        newDataCache.put(PGCACHE_USER_ASSIGN_INFO, SerializationUtils.toJsonString((Object)userDirectAssignDim));
        newDataCache.put("emptyDimMap", SerializationUtils.toJsonString(emptyDimMap));
        newDataCache.put("addDimSet", SerializationUtils.toJsonString(addDimSet));
        newDataCache.put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
        newDataCache.put("removeDimSet", SerializationUtils.toJsonString(removeDimSet));
        newDataCache.put("changeFieldPermDimSet", SerializationUtils.toJsonString(changeFieldPermDimSet));
        newDataCache.put("removeFieldPermDimSet", SerializationUtils.toJsonString(removeFieldPermDimSet));
        newDataCache.put("changeDataPermDimSet", SerializationUtils.toJsonString(changeDataPermDimSet));
        newDataCache.put("removeDataPermDimSet", SerializationUtils.toJsonString(removeDataPermDimSet));
        newDataCache.put("changeDataRuleDimSet", SerializationUtils.toJsonString(changeDataRuleDimSet));
        newDataCache.put("removeDataRuleDimSet", SerializationUtils.toJsonString(removeDataRuleDimSet));
        newDataCache.put("changeFpsDimSet", SerializationUtils.toJsonString(changeFpsDimSet));
        newDataCache.put("removeFpsDimSet", SerializationUtils.toJsonString(removeFpsDimSet));
        newDataCache.put("dataPermSettingErrorMap", SerializationUtils.toJsonString(dataPermSettingErrorMap));
        newDataCache.put("dataRuleSettingErrorMap", SerializationUtils.toJsonString(dataRuleSettingErrorMap));
        newDataCache.put("fpSettingErrorMap", SerializationUtils.toJsonString(fpSettingErrorMap));
        this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMap);
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
        this.getPageCache().put(newDataCache);
        this.getPageCache().remove("lastClickFieldPermNode");
        this.getPageCache().remove(PGCACHE_LASTCLICK_DATAPERM_NODE);
        this.getPageCache().remove(PGCACHE_LASTCLICK_DATARULE_NODE);
        this.clearTreeViewAndEntry();
        this.clearAllSearchMode();
    }

    private void showFieldForm(String pageType) {
        List qList;
        Set<String> excludeFpsIdSet;
        String currEntNum;
        String[] nodeInfoArr;
        String nodeId = "";
        String idField = "";
        String nameField = "";
        int listRowCount = 0;
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)"perm_choosefieldpage", (boolean)true, (int)0, (boolean)true);
        if ("fieldperm_entry".equals(pageType)) {
            nodeId = this.getPageCache().get("lastClickFieldPermNode");
            if (StringUtils.isEmpty((String)nodeId) || !nodeId.startsWith("entity#")) {
                this.getView().showTipNotification(ConstantsHelper.getDesc_PleaseChooseEntNodeFirst(), Integer.valueOf(2000));
                return;
            }
            idField = "fieldperm_fieldnum";
            nameField = "fieldperm_fieldname";
            listRowCount = this.getModel().getEntryRowCount("fieldperm_entry");
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "perm_choosefieldpage"));
        } else if ("entryentity_fps_sensitive".equals(pageType)) {
            nodeId = this.getPageCache().get("lastClickFieldPermNode");
            if (StringUtils.isEmpty((String)nodeId) || !nodeId.startsWith("entity#")) {
                this.getView().showTipNotification(ConstantsHelper.getDesc_PleaseChooseEntNodeFirst(), Integer.valueOf(2000));
                return;
            }
            idField = "fps_sensitive";
            nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
            currEntNum = nodeInfoArr[1];
            excludeFpsIdSet = this.getExcludeFpsIdSet("entryentity_fps_sensitive", "fps_sensitive");
            qList = FieldPermSchemeHelper.getFpsQfilter((String)currEntNum, (boolean)true, excludeFpsIdSet);
            fsp = PermFormCommonUtil.getFpsF7ListShowParameter(this.getPageCache(), qList);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSECALLBACK_ADDFPS_SENSITIVE"));
        } else if ("entryentity_fps".equals(pageType)) {
            nodeId = this.getPageCache().get("lastClickFieldPermNode");
            if (StringUtils.isEmpty((String)nodeId) || !nodeId.startsWith("entity#")) {
                this.getView().showTipNotification(ConstantsHelper.getDesc_PleaseChooseEntNodeFirst(), Integer.valueOf(2000));
                return;
            }
            idField = "fps";
            nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
            currEntNum = nodeInfoArr[1];
            excludeFpsIdSet = this.getExcludeFpsIdSet("entryentity_fps", "fps");
            qList = FieldPermSchemeHelper.getFpsQfilter((String)currEntNum, (boolean)false, excludeFpsIdSet);
            fsp = PermFormCommonUtil.getFpsF7ListShowParameter(this.getPageCache(), qList);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSECALLBACK_ADDFPS"));
        } else if ("bddatarule_entry".equals(pageType)) {
            nodeId = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
            if (StringUtils.isEmpty((String)nodeId) || !nodeId.startsWith("entity#")) {
                this.getView().showTipNotification(ConstantsHelper.getDesc_PleaseChooseEntNodeFirst(), Integer.valueOf(2000));
                return;
            }
            idField = "bdpropkey";
            nameField = "bdpropname";
            listRowCount = this.getModel().getEntryRowCount("bddatarule_entry");
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CallBackId_bdPropKey"));
            fsp.setCustomParam("param_ifShowBaseDataProp", (Object)VALUE_TRUE);
            fsp.setCustomParam("BillTypePropShow", (Object)"1");
        } else {
            return;
        }
        if ("entryentity_fps_sensitive".equals(pageType) || "entryentity_fps".equals(pageType)) {
            this.getView().showForm((FormShowParameter)fsp);
        } else {
            nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
            String entityNum = nodeInfoArr[1];
            HashSet<String> idSet = new HashSet<String>();
            String id = null;
            String name = null;
            ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
            StringBuilder key = new StringBuilder();
            for (int index = 0; index < listRowCount; ++index) {
                Object obj = this.getModel().getValue(idField, index);
                if (null == obj) continue;
                id = (String)obj;
                name = (String)this.getModel().getValue(nameField, index);
                key.append(id).append("||").append(name);
                if ("bddatarule_entry".equals(pageType)) {
                    DynamicObject value = (DynamicObject)this.getModel().getValue("bdentity", index);
                    String propEntity = value.getString("number");
                    key.append("||").append(propEntity);
                    id = key.toString();
                } else if ("fieldperm_entry".equals(pageType)) {
                    id = key.toString();
                }
                ListSelectedRow listSelectedRow = new ListSelectedRow((Object)key.toString(), Boolean.FALSE);
                listSelectedRow.setName(name);
                listSelectedRow.setNumber(id);
                listSelectedRowCollection.add((Object)listSelectedRow);
                if (StringUtils.isNotEmpty((String)id)) {
                    idSet.add(id);
                }
                key.setLength(0);
            }
            fsp.setCustomParam("paramEntityName", (Object)entityNum);
            fsp.setCustomParam("paramAllReadySelectedPropertyNameSet", idSet);
            fsp.setListSelectedRowCollection(listSelectedRowCollection);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            if (!CollectionUtils.isEmpty(idSet)) {
                fsp.getListFilterParameter().getQFilters().add(new QFilter("fieldid", "not in", idSet));
            }
            fsp.setShowTitle(true);
            fsp.setHasRight(true);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    private Set<String> getExcludeFpsIdSet(String entryentity_fps, String entryprop_fps) {
        int listRowCount = this.getModel().getEntryRowCount(entryentity_fps);
        if (0 == listRowCount) {
            return new HashSet<String>(1);
        }
        HashSet<String> idSet = new HashSet<String>(listRowCount);
        String id = null;
        for (int index = 0; index < listRowCount; ++index) {
            DynamicObject dyn;
            Object obj = this.getModel().getValue(entryprop_fps, index);
            if (null == obj || null == (dyn = (DynamicObject)obj) || !StringUtils.isNotEmpty((String)(id = dyn.getString("id")))) continue;
            idSet.add(id);
        }
        return idSet;
    }

    private void clearTreeViewAndEntry() {
        try {
            TreeView allFuncPermTree = (TreeView)this.getControl("tree_allfunctionperm");
            allFuncPermTree.deleteAllNodes();
            TreeView funcPermTree = (TreeView)this.getControl("tree_funcperm");
            funcPermTree.deleteAllNodes();
            TreeView fieldPermTree = (TreeView)this.getControl("tree_fieldperm");
            fieldPermTree.deleteAllNodes();
            TreeView dataPermTree = (TreeView)this.getControl("tree_dataperm");
            dataPermTree.deleteAllNodes();
            TreeView dataRuleTree = (TreeView)this.getControl("tree_datarule");
            dataRuleTree.deleteAllNodes();
            Future submit = pool.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    UserDirectAssignPermMultiPlugin.this.getModel().deleteEntryData("fieldperm_entry");
                    UserDirectAssignPermMultiPlugin.this.getModel().deleteEntryData("datarule_entry");
                    UserDirectAssignPermMultiPlugin.this.getModel().deleteEntryData("bddatarule_entry");
                    UserDirectAssignPermMultiPlugin.this.getModel().deleteEntryData("entryentity_fps_sensitive");
                    UserDirectAssignPermMultiPlugin.this.getModel().deleteEntryData("entryentity_fps");
                    return null;
                }
            });
            submit.get();
            this.clearDataPermFilterGrid();
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtergrid_dataperm", "tab_datarule", "tab_fieldperm"});
        }
        catch (Exception e) {
            logger.warn("UserDirectAssignPermMultiPlugin.clearTreeViewAndEntry error", (Throwable)e);
        }
    }

    private List<String> getDelBdDataRule() {
        EntryGrid eg = (EntryGrid)this.getControl("bddatarule_entry");
        int[] selectRows = eg.getSelectRows();
        ArrayList<String> data = new ArrayList<String>(selectRows.length);
        for (int selectRow : selectRows) {
            String bdPropKey = (String)this.getModel().getValue("bdpropkey", selectRow);
            data.add(bdPropKey);
        }
        return data;
    }

    private List<String> getDelDataRule() {
        EntryGrid eg = (EntryGrid)this.getControl("datarule_entry");
        int[] selectRows = eg.getSelectRows();
        ArrayList<String> data = new ArrayList<String>(selectRows.length);
        for (int selectRow : selectRows) {
            DynamicObject permItem = (DynamicObject)this.getModel().getValue("permitem", selectRow);
            if (permItem != null) {
                String permItemId = permItem.getString("id");
                data.add(permItemId);
                continue;
            }
            data.add("emptyRow");
        }
        return data;
    }

    private List<String> getDelFps(String fpsEntity, String fpsField) {
        EntryGrid eg = (EntryGrid)this.getControl(fpsEntity);
        int[] selectRows = eg.getSelectRows();
        ArrayList<String> data = new ArrayList<String>(selectRows.length);
        for (int selectRow : selectRows) {
            DynamicObject dyn = (DynamicObject)this.getModel().getValue(fpsField, selectRow);
            if (dyn != null) {
                String id = dyn.getString("id");
                data.add(id);
                continue;
            }
            data.add("emptyRow");
        }
        return data;
    }

    private List<String> getDelFieldPerm() {
        EntryGrid eg = (EntryGrid)this.getControl("fieldperm_entry");
        int[] selectRows = eg.getSelectRows();
        ArrayList<String> data = new ArrayList<String>(selectRows.length);
        for (int selectRow : selectRows) {
            String filedNum = (String)this.getModel().getValue("fieldperm_fieldnum", selectRow);
            data.add(filedNum);
        }
        return data;
    }

    private List<String> getSelectedDimEntry() {
        EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
        int[] selectRows = eg.getSelectRows();
        ArrayList<String> data = new ArrayList<String>(selectRows.length);
        for (int selectRow : selectRows) {
            Long dimId = (Long)this.getModel().getValue(DIMNUM_ID, selectRow);
            data.add(String.valueOf(dimId));
        }
        return data;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getPageCache().get("skip") != null) {
            this.getPageCache().remove("skip");
            return;
        }
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        if ("includesuborg".equals(propName)) {
            boolean setCancel = this.checkAdminChargeOrg(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5305\u542b\u4e0b\u7ea7", (String)"UserDirectAssignPermMultiPlugin_29", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            if (setCancel) {
                this.getPageCache().put("skip", VALUE_TRUE);
                this.getModel().setValue("includesuborg", oldValue, rowIndex);
                return;
            }
            Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
            boolean includeSub = (Boolean)newValue;
            Map dimAssignInfo = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_INFO), Map.class);
            String[] dimInfo = sourceKey.split("\\|");
            Map curDimTypeAssignInfo = (Map)dimAssignInfo.get(dimInfo[0]);
            String dimId = dimInfo[1];
            CharSequence[] permInfoArr = ((String)curDimTypeAssignInfo.get(dimId)).split(",");
            permInfoArr[1] = includeSub ? "1" : "0";
            String includeSubChange = permInfoArr[2];
            permInfoArr[2] = "0".equals(includeSubChange) ? "1" : "0";
            curDimTypeAssignInfo.put(dimId, String.join((CharSequence)",", permInfoArr));
            this.getPageCache().put(PGCACHE_USER_ASSIGN_INFO, SerializationUtils.toJsonString((Object)dimAssignInfo));
            dimDataChangeSet.add(sourceKey);
            this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
            this.getModel().setValue("datachangeflag", (Object)true);
        } else if ("fieldperm_not_allow_query".equals(propName)) {
            List adminChargeApps;
            EntryGrid eg = (EntryGrid)this.getControl("fieldperm_entry");
            int[] selectRows = eg.getSelectRows();
            boolean setCancel = this.checkAdminChargeOrg(ResManager.loadKDString((String)"\u4fee\u6539", (String)"UserDirectAssignPermMultiPlugin_30", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            if (setCancel) {
                this.getPageCache().put("skip", VALUE_TRUE);
                this.getModel().setValue("fieldperm_not_allow_query", oldValue, selectRows[0]);
                return;
            }
            String showFormSpecial = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
            if (!VALUE_TRUE.equals(showFormSpecial) && !(adminChargeApps = AdminPermCache.getAdminChargeApps((Long)RequestContext.get().getCurrUserId(), null)).isEmpty()) {
                String notInChargeAppMes;
                String nodeId = this.getPageCache().get("lastClickFieldPermNode");
                String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
                String appId = nodeInfoArr[0];
                HashSet<String> appNotInCharge = new HashSet<String>(1);
                if (!adminChargeApps.contains(appId)) {
                    appNotInCharge.add(appId);
                }
                if (StringUtils.isNotEmpty((String)(notInChargeAppMes = PermFormCommonUtil.getNotInChargeAppMes(false, appNotInCharge, ResManager.loadKDString((String)"\u4fee\u6539", (String)"AssignPermPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]))))) {
                    this.getView().showErrorNotification(notInChargeAppMes);
                    this.getPageCache().put("skip", VALUE_TRUE);
                    this.getModel().setValue("fieldperm_not_allow_query", oldValue, selectRows[0]);
                    return;
                }
            }
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
            Set<String> changeFieldPermDimSet = this.assignPermCacheUtil.getChangeFieldPermDimSet();
            Map<String, String> curFieldPerm = assignPermCurInfoMap.get("tree_fieldperm");
            Map dimCurFieldPerm = (Map)SerializationUtils.fromJsonString((String)curFieldPerm.get(sourceKey), Map.class);
            String nodeId = this.getPageCache().get("lastClickFieldPermNode");
            Map nodeFieldPerm = dimCurFieldPerm.computeIfAbsent(nodeId, k -> new LinkedHashMap(16));
            Map fpTypeFieldPerm = nodeFieldPerm.computeIfAbsent("pgcache_fieldpermdetail", k -> new LinkedHashMap(16));
            String string = (String)this.getModel().getValue("fieldperm_fieldnum", selectRows[0]);
            boolean notAllowQuery = (Boolean)newValue;
            String controlMode = notAllowQuery ? "10" : "20";
            String old = (String)fpTypeFieldPerm.get(string);
            if (StringUtils.isEmpty((String)old)) {
                String fieldpermid = UserDirectAssignPermMultiPlugin.getFieldpermid(fpTypeFieldPerm);
                fpTypeFieldPerm.put(string, string + "|" + controlMode + "|" + fieldpermid);
            } else {
                String[] split = old.split("\\|", 3);
                if (null == split || !Objects.equals(3, split.length)) {
                    return;
                }
                split[1] = controlMode;
                fpTypeFieldPerm.put(string, Strings.join((String[])split, (String)"|"));
            }
            this.getModel().setValue("fieldperm_not_allow_edit", (Object)true, selectRows[0]);
            changeFieldPermDimSet.add(sourceKey);
            this.getPageCache().put("changeFieldPermDimSet", SerializationUtils.toJsonString(changeFieldPermDimSet));
            dimDataChangeSet.add(sourceKey);
            this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
            curFieldPerm.put(sourceKey, SerializationUtils.toJsonString((Object)dimCurFieldPerm));
            this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
            this.getModel().setValue("datachangeflag", (Object)true);
        } else if ("fps".equals(propName)) {
            this.propertyChangeFP(newValue, oldValue, sourceKey, "pgcache_fps", "fps", rowIndex);
        } else if ("fps_sensitive".equals(propName)) {
            this.propertyChangeFP(newValue, oldValue, sourceKey, "pgcache_fpssensitive", "fps_sensitive", rowIndex);
        } else if ("permitem".equals(propName)) {
            DynamicObject newPermItem = (DynamicObject)newValue;
            DynamicObject oldPermItem = (DynamicObject)oldValue;
            EntryGrid eg = (EntryGrid)this.getControl("datarule_entry");
            int[] selectRows = eg.getSelectRows();
            boolean setCancel = this.checkAdminChargeOrg(ResManager.loadKDString((String)"\u4fee\u6539", (String)"UserDirectAssignPermMultiPlugin_30", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            if (setCancel) {
                this.getPageCache().put("skip", VALUE_TRUE);
                this.getModel().setValue("permitem", oldValue, selectRows[0]);
                return;
            }
            if (newPermItem != null) {
                DynamicObject dataRule;
                String nodeId = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
                String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
                String entityNum = nodeInfoArr[1];
                Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
                Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
                Set<String> changeDataRuleDimSet = this.assignPermCacheUtil.getChangeDataRuleDimSet();
                Map<String, Map<String, Map<String, String>>> dataRuleSettingErrorMap = this.assignPermCacheUtil.getDataRuleSettingErrorMap();
                Map<String, String> map = assignPermCurInfoMap.get("tree_datarule");
                String dimSetting = map.get(sourceKey);
                HashMap<String, Map> dimCurDataRule = StringUtils.isNotEmpty((String)dimSetting) ? (HashMap<String, Map>)SerializationUtils.fromJsonString((String)dimSetting, Map.class) : new HashMap<String, Map>(16);
                Map nodeDataRule = dimCurDataRule.computeIfAbsent(nodeId, k -> new HashMap(16));
                Map dataRuleDetail = nodeDataRule.computeIfAbsent(PGCACHE_DATARULE, k -> new HashMap(16));
                boolean changeData = false;
                String newPermItemId = newPermItem.getString("id");
                String oldPermItemId = null;
                if (oldPermItem != null) {
                    oldPermItemId = oldPermItem.getString("id");
                    dataRuleDetail.remove(oldPermItemId);
                    changeData = true;
                }
                if ((dataRule = (DynamicObject)this.getModel().getValue("datarule", rowIndex)) != null) {
                    Long dataRuleId = dataRule.getLong("id");
                    dataRuleDetail.put(newPermItemId, String.valueOf(dataRuleId));
                    changeData = true;
                } else {
                    Map<String, String> oldDataMap;
                    dataRuleDetail.put(newPermItemId, "    ");
                    String[] selectedDimInfo = this.getSelectedDimInfo();
                    Map<String, Map<String, String>> oldSourceMap = dataRuleSettingErrorMap.get(sourceKey);
                    if (!CollectionUtils.isEmpty(oldSourceMap) && oldPermItemId != null && !CollectionUtils.isEmpty(oldDataMap = oldSourceMap.get(PGCACHE_DATARULE))) {
                        oldDataMap.remove(nodeId + "|" + oldPermItemId);
                    }
                    String info = selectedDimInfo[1] + "|" + selectedDimInfo[0] + "|" + entityNum + "|" + newPermItemId;
                    dataRuleSettingErrorMap.computeIfAbsent(sourceKey, k -> new HashMap(16)).computeIfAbsent(PGCACHE_DATARULE, l -> new HashMap(16)).put(nodeId + "|" + newPermItemId, info);
                    this.getPageCache().put("dataRuleSettingErrorMap", SerializationUtils.toJsonString(dataRuleSettingErrorMap));
                }
                if (changeData) {
                    changeDataRuleDimSet.add(sourceKey);
                    this.getPageCache().put("changeDataRuleDimSet", SerializationUtils.toJsonString(changeDataRuleDimSet));
                    dimDataChangeSet.add(sourceKey);
                    this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
                    this.getModel().setValue("datachangeflag", (Object)true);
                }
                map.put(sourceKey, SerializationUtils.toJsonString(dimCurDataRule));
                this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
                this.getView().setEnable(Boolean.TRUE, selectRows[0], new String[]{"datarule"});
            } else if (oldPermItem != null) {
                String oldPermItemId = oldPermItem.getString("id");
                this.getModel().setValue("permitem", (Object)oldPermItemId, rowIndex);
            }
        } else if ("datarule".equals(propName)) {
            DynamicObject newDataRule = (DynamicObject)newValue;
            DynamicObject oldDataRule = (DynamicObject)oldValue;
            boolean setCancel = this.checkAdminChargeOrg(ResManager.loadKDString((String)"\u4fee\u6539", (String)"UserDirectAssignPermMultiPlugin_30", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            if (setCancel) {
                this.getPageCache().put("skip", VALUE_TRUE);
                this.getModel().setValue("datarule", oldValue, rowIndex);
                return;
            }
            DynamicObject permItem = (DynamicObject)this.getModel().getValue("permitem", rowIndex);
            if (newDataRule != null && permItem != null) {
                Map<String, String> curNodeError;
                String nodeId = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
                Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
                Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
                Set<String> changeDataRuleDimSet = this.assignPermCacheUtil.getChangeDataRuleDimSet();
                Map<String, Map<String, Map<String, String>>> dataRuleSettingErrorMap = this.assignPermCacheUtil.getDataRuleSettingErrorMap();
                Map<String, String> curDataRule = assignPermCurInfoMap.get("tree_datarule");
                String dimSetting = curDataRule.get(sourceKey);
                HashMap<String, Map> dimCurDataRule = StringUtils.isNotEmpty((String)dimSetting) ? (HashMap<String, Map>)SerializationUtils.fromJsonString((String)dimSetting, Map.class) : new HashMap<String, Map>(16);
                Map nodeDataRule = dimCurDataRule.computeIfAbsent(nodeId, k -> new HashMap(16));
                Map map = nodeDataRule.computeIfAbsent(PGCACHE_DATARULE, k -> new HashMap(16));
                Long dataRuleId = newDataRule.getLong("id");
                String permItemId = permItem.getString("id");
                map.put(permItemId, String.valueOf(dataRuleId));
                Map<String, Map<String, String>> curDimDataRuleError = dataRuleSettingErrorMap.get(sourceKey);
                if (!CollectionUtils.isEmpty(curDimDataRuleError) && !CollectionUtils.isEmpty(curNodeError = curDimDataRuleError.get(PGCACHE_DATARULE))) {
                    curNodeError.remove(nodeId + "|" + permItemId);
                    this.getPageCache().put("dataRuleSettingErrorMap", SerializationUtils.toJsonString(dataRuleSettingErrorMap));
                }
                changeDataRuleDimSet.add(sourceKey);
                this.getPageCache().put("changeDataRuleDimSet", SerializationUtils.toJsonString(changeDataRuleDimSet));
                dimDataChangeSet.add(sourceKey);
                this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
                curDataRule.put(sourceKey, SerializationUtils.toJsonString(dimCurDataRule));
                this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
                this.getModel().setValue("datachangeflag", (Object)true);
            } else if (permItem != null && oldDataRule != null) {
                Long dataRuleId = oldDataRule.getLong("id");
                this.getModel().setValue("datarule", (Object)dataRuleId, rowIndex);
            }
        } else if ("bddatarule".equals(propName)) {
            DynamicObject newBdDataRule = (DynamicObject)newValue;
            DynamicObject oldBdDataRule = (DynamicObject)oldValue;
            boolean setCancel = this.checkAdminChargeOrg(ResManager.loadKDString((String)"\u4fee\u6539", (String)"UserDirectAssignPermMultiPlugin_30", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            if (setCancel) {
                this.getPageCache().put("skip", VALUE_TRUE);
                this.getModel().setValue("bddatarule", oldValue, rowIndex);
                return;
            }
            if (newBdDataRule != null) {
                String nodeId = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
                Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
                Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
                Set<String> changeDataRuleDimSet = this.assignPermCacheUtil.getChangeDataRuleDimSet();
                Map<String, Map<String, Map<String, String>>> dataRuleSettingErrorMap = this.assignPermCacheUtil.getDataRuleSettingErrorMap();
                Map<String, String> curDataRule = assignPermCurInfoMap.get("tree_datarule");
                String string = curDataRule.get(sourceKey);
                HashMap<String, Map> dimCurDataRule = StringUtils.isNotEmpty((String)string) ? (HashMap<String, Map>)SerializationUtils.fromJsonString((String)string, Map.class) : new HashMap<String, Map>(16);
                Map nodeDataRule = dimCurDataRule.computeIfAbsent(nodeId, k -> new HashMap(16));
                Map bdDataRuleDetail = nodeDataRule.computeIfAbsent(PGCACHE_BDDATARULE, k -> new HashMap(16));
                Long bdDataRuleId = newBdDataRule.getLong("id");
                String propKey = (String)this.getModel().getValue("bdpropkey", rowIndex);
                String entityNum = ((DynamicObject)this.getModel().getValue("bdentity", rowIndex)).getString("number");
                if (propKey != null && bdDataRuleId != 0L) {
                    Map<String, String> curNodeError;
                    bdDataRuleDetail.put(propKey, propKey + "|" + entityNum + "|" + bdDataRuleId);
                    Map<String, Map<String, String>> curDimDataRuleError = dataRuleSettingErrorMap.get(sourceKey);
                    if (!CollectionUtils.isEmpty(curDimDataRuleError) && !CollectionUtils.isEmpty(curNodeError = curDimDataRuleError.get(PGCACHE_BDDATARULE))) {
                        curNodeError.remove(nodeId + "|" + propKey);
                        this.getPageCache().put("dataRuleSettingErrorMap", SerializationUtils.toJsonString(dataRuleSettingErrorMap));
                    }
                    changeDataRuleDimSet.add(sourceKey);
                    this.getPageCache().put("changeDataRuleDimSet", SerializationUtils.toJsonString(changeDataRuleDimSet));
                    dimDataChangeSet.add(sourceKey);
                    this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
                    curDataRule.put(sourceKey, SerializationUtils.toJsonString(dimCurDataRule));
                    this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
                    this.getModel().setValue("datachangeflag", (Object)true);
                }
            } else if (oldBdDataRule != null) {
                String oldBdDataRuleId = oldBdDataRule.getString("id");
                this.getModel().setValue("bddatarule", (Object)oldBdDataRuleId, rowIndex);
            }
        } else if ("shownum".equals(propName)) {
            if (StringUtils.isEmpty((String)sourceKey)) {
                return;
            }
            String dimType = (String)this.getModel().getValue("dimtype");
            boolean showNum = (Boolean)this.getModel().getValue("shownum");
            Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(dimType), Map.class);
            TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
            tv.deleteAllNodes();
            TreeNode rootNode = ConstantsHelper.getTreeRootNode((boolean)true, (String)ConstantsHelper.getFuncPerm());
            rootNode.setIsOpened(true);
            tv.addNode(rootNode);
            this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, showNum);
            this.getPageCache().putBigObject("tree_allfunctionperm", SerializationUtils.toJsonString((Object)rootNode));
            String batchAssignFlag = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            Map<String, String> curFuncPerm = assignPermCurInfoMap.get("tree_funcperm");
            if (StringUtils.isNotEmpty((String)batchAssignFlag)) {
                String beanStr = curFuncPerm.get(BATCH_ASSIGN);
                List infos = null;
                if (StringUtils.isNotEmpty((String)beanStr)) {
                    infos = SerializationUtils.fromJsonStringToList((String)beanStr, String.class);
                }
                this.buildFuncPermRightTree(BATCH_ASSIGN, infos);
            } else {
                String[] arr = sourceKey.split("\\|");
                this.initFuncPermRightTree(null, assignPermCurInfoMap, arr[0], Long.valueOf(arr[1]));
            }
        } else if ("fieldpermsetup".equals(propName)) {
            String flagBatchAssign = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
            if (StringUtils.isNotEmpty((String)flagBatchAssign)) {
                return;
            }
            this.getPageCache().remove("lastClickFieldPermNode");
            String lastClickPermTab = this.getPageCache().get(PGCACHE_LASTCLICK_PERMTAB);
            if (!"tab_perm_fieldperm".equals(lastClickPermTab)) {
                return;
            }
            if (StringUtils.isEmpty((String)sourceKey)) {
                return;
            }
            boolean showSetup = (Boolean)newValue;
            if (showSetup) {
                this.getModel().deleteEntryData("entryentity_fps_sensitive");
                this.getModel().deleteEntryData("entryentity_fps");
                this.getModel().deleteEntryData("fieldperm_entry");
                this.getView().setVisible(Boolean.FALSE, new String[]{"tab_fieldperm"});
                ArrayList<String> nodes = new ArrayList<String>(50);
                Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
                Map<String, String> curFuncPerm = assignPermCurInfoMap.get("tree_funcperm");
                String dimCurFuncPermStr = curFuncPerm.get(sourceKey);
                if (StringUtils.isEmpty((String)dimCurFuncPermStr)) {
                    this.rebuildTree("tree_fieldperm", nodes, false);
                    return;
                }
                List permDetailInfos = SerializationUtils.fromJsonStringToList((String)dimCurFuncPermStr, String.class);
                if (CollectionUtils.isEmpty((Collection)permDetailInfos)) {
                    this.rebuildTree("tree_fieldperm", nodes, false);
                    return;
                }
                Map<String, String> curFieldPerm = assignPermCurInfoMap.get("tree_fieldperm");
                String curDimFieldPermStr = curFieldPerm.get(sourceKey);
                if (StringUtils.isNotEmpty((String)curDimFieldPermStr)) {
                    HashSet setupNodes = new HashSet(8);
                    Map curDimFieldPerm = (Map)SerializationUtils.fromJsonString((String)curDimFieldPermStr, Map.class);
                    for (Map.Entry fielPermDetail : curDimFieldPerm.entrySet()) {
                        Map value = (Map)fielPermDetail.getValue();
                        if (CollectionUtils.isEmpty((Map)value)) continue;
                        Map pgcache_fpssensitive_map = (Map)value.get("pgcache_fpssensitive");
                        Map pgcache_fps_map = (Map)value.get("pgcache_fps");
                        Map pgcache_detail_map = (Map)value.get("pgcache_fieldpermdetail");
                        if (CollectionUtils.isEmpty((Map)pgcache_fpssensitive_map) && CollectionUtils.isEmpty((Map)pgcache_fps_map) && CollectionUtils.isEmpty((Map)pgcache_detail_map)) continue;
                        setupNodes.add(fielPermDetail.getKey());
                    }
                    if (!CollectionUtils.isEmpty(setupNodes)) {
                        block1: for (String setupNode : setupNodes) {
                            for (String permDetailInfo : permDetailInfos) {
                                String[] arr = permDetailInfo.split("    ");
                                String appId = arr[5];
                                String entityNum = arr[6];
                                String entityKey = "entity#" + entityNum + "@" + appId;
                                if (!entityKey.equals(setupNode)) continue;
                                nodes.add(permDetailInfo);
                                continue block1;
                            }
                        }
                    }
                }
                this.rebuildTree("tree_fieldperm", nodes, false);
                Search fieldPermSearch = (Search)this.getControl("fieldpermsearchap");
                fieldPermSearch.setSearchKey("");
                this.getPageCache().removeBigObject("fieldPermTreeSearchMode");
            } else {
                String fieldPermSearchMode = this.getPageCache().getBigObject("fieldPermTreeSearchMode");
                if (StringUtils.isNotEmpty((String)fieldPermSearchMode)) {
                    return;
                }
                String[] arr = sourceKey.split("\\|");
                this.initFieldPermTree(arr[0], Long.valueOf(arr[1]));
            }
        } else if ("datapermsetup".equals(propName)) {
            String flagBatchAssign = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
            if (StringUtils.isNotEmpty((String)flagBatchAssign)) {
                return;
            }
            String lastClickPermTab = this.getPageCache().get(PGCACHE_LASTCLICK_PERMTAB);
            if (!"tab_perm_dataperm".equals(lastClickPermTab)) {
                return;
            }
            if (StringUtils.isEmpty((String)sourceKey)) {
                return;
            }
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            assert (assignPermCurInfoMap != null);
            this.needUpdateDataPermPageCache(sourceKey, assignPermCurInfoMap);
            this.getPageCache().remove(PGCACHE_LASTCLICK_DATAPERM_NODE);
            boolean showSetup = (Boolean)newValue;
            if (showSetup) {
                Map dataPermDetail;
                Set setupNodes;
                this.clearDataPermFilterGrid();
                this.getView().setVisible(Boolean.FALSE, new String[]{"filtergrid_dataperm"});
                Map<String, String> curFuncPerm = assignPermCurInfoMap.get("tree_funcperm");
                String dimCurFuncPermStr = curFuncPerm.get(sourceKey);
                ArrayList<String> nodes = new ArrayList<String>(50);
                if (StringUtils.isEmpty((String)dimCurFuncPermStr)) {
                    this.rebuildTree("tree_dataperm", nodes, false);
                    return;
                }
                List permDetailInfos = SerializationUtils.fromJsonStringToList((String)dimCurFuncPermStr, String.class);
                if (CollectionUtils.isEmpty((Collection)permDetailInfos)) {
                    this.rebuildTree("tree_dataperm", nodes, false);
                    return;
                }
                Map<String, String> curDataPerm = assignPermCurInfoMap.get("tree_dataperm");
                String curDimDataPermStr = curDataPerm.get(sourceKey);
                if (StringUtils.isNotEmpty((String)curDimDataPermStr) && !CollectionUtils.isEmpty(setupNodes = (dataPermDetail = (Map)SerializationUtils.fromJsonString((String)curDimDataPermStr, Map.class)).keySet())) {
                    block3: for (String setupNode : setupNodes) {
                        for (String permDetailInfo : permDetailInfos) {
                            String[] arr = permDetailInfo.split("    ");
                            String appId = arr[5];
                            String entityNum = arr[6];
                            String entityKey = "entity#" + entityNum + "@" + appId;
                            if (!entityKey.equals(setupNode)) continue;
                            nodes.add(permDetailInfo);
                            continue block3;
                        }
                    }
                }
                this.rebuildTree("tree_dataperm", nodes, false);
                Search dataPermSearch = (Search)this.getControl("datapermsearchap");
                dataPermSearch.setSearchKey("");
                this.getPageCache().removeBigObject("dataPermTreeSearchMode");
            } else {
                String fieldPermSearchMode = this.getPageCache().getBigObject("dataPermTreeSearchMode");
                if (StringUtils.isNotEmpty((String)fieldPermSearchMode)) {
                    return;
                }
                String[] arr = sourceKey.split("\\|");
                this.initDataPermTree(arr[0], Long.valueOf(arr[1]));
            }
        } else if ("datarulesetup".equals(propName)) {
            String flagBatchAssign = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
            if (StringUtils.isNotEmpty((String)flagBatchAssign)) {
                return;
            }
            this.getPageCache().remove(PGCACHE_LASTCLICK_DATARULE_NODE);
            String lastClickPermTab = this.getPageCache().get(PGCACHE_LASTCLICK_PERMTAB);
            if (!"tab_perm_datarule".equals(lastClickPermTab)) {
                return;
            }
            if (StringUtils.isEmpty((String)sourceKey)) {
                return;
            }
            boolean showSetup = (Boolean)newValue;
            if (showSetup) {
                this.getModel().deleteEntryData("datarule_entry");
                this.getModel().deleteEntryData("bddatarule_entry");
                this.getView().setVisible(Boolean.FALSE, new String[]{"tab_datarule"});
                Map<String, String> allPermNodeInfoMap = this.funcPermTreeUtil.getAllPermNodeInfoMap();
                ArrayList<String> nodes = new ArrayList<String>(50);
                Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
                Map<String, String> curDataRule = assignPermCurInfoMap.get("tree_datarule");
                String curDimDataPermStr = curDataRule.get(sourceKey);
                if (StringUtils.isNotEmpty((String)curDimDataPermStr)) {
                    HashSet setupNodes = new HashSet(8);
                    Map dataPermDetailMap = (Map)SerializationUtils.fromJsonString((String)curDimDataPermStr, Map.class);
                    for (Map.Entry dataPermDetail : dataPermDetailMap.entrySet()) {
                        Map map = (Map)dataPermDetail.getValue();
                        if (CollectionUtils.isEmpty((Map)map)) continue;
                        Map pgcache_datarule_map = (Map)map.get(PGCACHE_DATARULE);
                        Map pgcache_bddatarule_map = (Map)map.get(PGCACHE_BDDATARULE);
                        if (CollectionUtils.isEmpty((Map)pgcache_datarule_map) && CollectionUtils.isEmpty((Map)pgcache_bddatarule_map)) continue;
                        setupNodes.add(dataPermDetail.getKey());
                    }
                    if (!CollectionUtils.isEmpty(setupNodes)) {
                        Collection<String> values = allPermNodeInfoMap.values();
                        for (String string : values) {
                            String[] arr = string.split("    ");
                            String appId = arr[5];
                            String entityNum = arr[6];
                            String entityKey = "entity#" + entityNum + "@" + appId;
                            if (!setupNodes.remove(entityKey)) continue;
                            nodes.add(string);
                            if (!setupNodes.isEmpty()) continue;
                            break;
                        }
                    }
                }
                this.rebuildTree("tree_datarule", nodes, false);
                Search dataRuleSearch = (Search)this.getControl("datarulesearchap");
                dataRuleSearch.setSearchKey("");
                this.getPageCache().removeBigObject("dataRuleTreeSearchMode");
            } else {
                String fieldPermSearchMode = this.getPageCache().getBigObject("dataRuleTreeSearchMode");
                if (StringUtils.isNotEmpty((String)fieldPermSearchMode)) {
                    return;
                }
                String[] arr = sourceKey.split("\\|");
                this.initDataRuleTree(arr[0], Long.valueOf(arr[1]));
            }
        } else if ("user".equals(propName)) {
            if (oldValue == null) {
                return;
            }
            if (newValue == null) {
                this.getModel().setValue(propName, oldValue);
                this.getModel().setDataChanged(false);
            } else {
                Long newUserId = ((DynamicObject)newValue).getLong("id");
                FormShowParameter param = this.getView().getFormShowParameter();
                String pageId = this.getView().getPageId();
                CharSequence[] pageIdSplit = pageId.split("\\|");
                String oldUserId = pageIdSplit[2];
                pageIdSplit[2] = String.valueOf(newUserId);
                String newPageId = String.join((CharSequence)"|", pageIdSplit);
                IFormView newFv = this.getView().getViewNoPlugin(newPageId);
                if (newFv != null) {
                    this.getModel().setDataChanged(false);
                    this.getView().close();
                    newFv.activate();
                    this.getView().sendFormAction(newFv);
                } else {
                    param.getOpenStyle().setShowType(ShowType.InCurrentForm);
                    param.setPageId(newPageId);
                    StringBuilder sbErrorInfo = new StringBuilder();
                    if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
                        MutexHelper.release((String)"bos_usergroup_user", (String)"directassignmulti", (String)oldUserId);
                    }
                    if (MutexHelper.require((String)"bos_usergroup_user", (Object)newUserId, (String)"directassignmulti", (boolean)true, (StringBuilder)sbErrorInfo)) {
                        this.getView().setStatus(OperationStatus.EDIT);
                    } else {
                        this.getView().setStatus(OperationStatus.VIEW);
                        this.getView().showMessage(sbErrorInfo.toString());
                    }
                    param.setCustomParam("paramUserId", (Object)String.valueOf(newUserId));
                    this.getView().showForm(param);
                }
            }
        }
    }

    private static String getFieldpermid(Map<String, String> fpTypeFieldPerm) {
        String fieldpermid = "";
        for (Map.Entry<String, String> fpTypeFP : fpTypeFieldPerm.entrySet()) {
            String[] split;
            String value = fpTypeFP.getValue();
            if (StringUtils.isEmpty((String)value) || null == (split = value.split("\\|")) || !Objects.equals(3, split.length) || !StringUtils.isNotEmpty((String)split[2])) continue;
            fieldpermid = split[2];
            break;
        }
        return fieldpermid;
    }

    private void propertyChangeFP(Object newValue, Object oldValue, String sourceKey, String pgcacheFpsKey, String entrypropFpsKey, int rowIndex) {
        DynamicObject newFps = (DynamicObject)newValue;
        DynamicObject oldFps = (DynamicObject)oldValue;
        if (null != newFps) {
            Map<String, String> curNodeError;
            String nodeId = this.getPageCache().get("lastClickFieldPermNode");
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
            Set<String> changeFpsDimSet = this.assignPermCacheUtil.getChangeFpsDimSet();
            Map<String, Map<String, Map<String, String>>> fpSettingErrorMap = this.assignPermCacheUtil.getFPSettingErrorMap();
            Map<String, String> curFP = assignPermCurInfoMap.get("tree_fieldperm");
            String dimSetting = curFP.get(sourceKey);
            HashMap<String, Map> dimCurFP = StringUtils.isNotEmpty((String)dimSetting) ? (HashMap<String, Map>)SerializationUtils.fromJsonString((String)dimSetting, Map.class) : new HashMap<String, Map>(16);
            Map nodeFP = dimCurFP.computeIfAbsent(nodeId, k -> new HashMap(16));
            Map fpDetail = nodeFP.computeIfAbsent(pgcacheFpsKey, k -> new HashMap(16));
            String fpsIdStr = newFps.getString("id");
            fpDetail.put(fpsIdStr, fpsIdStr);
            Map<String, Map<String, String>> curDimFpsError = fpSettingErrorMap.get(sourceKey);
            if (!CollectionUtils.isEmpty(curDimFpsError) && !CollectionUtils.isEmpty(curNodeError = curDimFpsError.get(pgcacheFpsKey))) {
                curNodeError.remove(nodeId);
                this.getPageCache().put("fpSettingErrorMap", SerializationUtils.toJsonString(fpSettingErrorMap));
            }
            changeFpsDimSet.add(sourceKey);
            this.getPageCache().put("changeFpsDimSet", SerializationUtils.toJsonString(changeFpsDimSet));
            dimDataChangeSet.add(sourceKey);
            this.getPageCache().put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
            curFP.put(sourceKey, SerializationUtils.toJsonString(dimCurFP));
            this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
            this.getModel().setValue("datachangeflag", (Object)true);
            return;
        }
        if (null != oldFps) {
            Long fpdId = oldFps.getLong("id");
            this.getModel().setValue(entrypropFpsKey, (Object)fpdId, rowIndex);
            return;
        }
    }

    public void search(SearchEnterEvent evt) {
        Search source = (Search)evt.getSource();
        String key = source.getKey();
        String text = evt.getText();
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        if (sourceKey == null) {
            return;
        }
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        if ("searchap".equals(key)) {
            if (StringUtils.isBlank((String)text)) {
                this.getPageCache().removeBigObject("allFuncPermTreeSearchMode");
                TreeView tv = (TreeView)this.getControl("tree_allfunctionperm");
                String dimType = (String)this.getModel().getValue("dimtype");
                this.funcPermTreeUtil.initFuncPermLeftTree(tv, dimType, showNum);
            } else {
                Map<String, String> allPermNodeInfoMap = this.funcPermTreeUtil.getAllPermNodeInfoMap();
                Map<String, String> entityAssignablePermItemMap = this.funcPermTreeUtil.getEntityAssignablePermItemMap();
                Map<String, String> permItemIdNumberMap = this.funcPermTreeUtil.getPermItemIdNumberMap();
                Collection<String> values = allPermNodeInfoMap.values();
                ArrayList<String> searchInfos = new ArrayList<String>(100);
                for (String value : values) {
                    String[] permItemIdArr;
                    String permItemStr;
                    String[] arr = value.split("    ");
                    String entityName = arr[7];
                    String entityNum = arr[6];
                    if (!entityName.contains(text) && (!showNum || !entityNum.equals(text)) || !StringUtils.isNotEmpty((String)(permItemStr = entityAssignablePermItemMap.get(entityNum)))) continue;
                    for (String permItemId : permItemIdArr = permItemStr.split(",")) {
                        if (StringUtils.isEmpty((String)permItemId)) continue;
                        String permItemNum = permItemIdNumberMap.get(permItemId);
                        searchInfos.add(String.join((CharSequence)"    ", value, permItemNum, permItemId));
                    }
                }
                this.getPageCache().putBigObject("allFuncPermTreeSearchMode", SerializationUtils.toJsonString(searchInfos));
                this.rebuildTree("tree_allfunctionperm", searchInfos, true);
            }
        } else if ("userfuncpermsearchap".equals(key)) {
            String flagBatchAssign = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
            if (StringUtils.isNotEmpty((String)flagBatchAssign)) {
                sourceKey = BATCH_ASSIGN;
            }
            if (StringUtils.isBlank((String)text)) {
                this.getPageCache().removeBigObject("userFuncPermTreeSearchMode");
                TreeView tv = (TreeView)this.getControl("tree_funcperm");
                tv.deleteAllNodes();
                Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(sourceKey), Map.class);
                TreeNode rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllreadyAssignDesc());
                rootNode.setIsOpened(true);
                tv.addNode(rootNode);
                this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, showNum);
            } else {
                Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
                String curPermDetailStr = assignPermCurInfoMap.get("tree_funcperm").get(sourceKey);
                ArrayList curPermDetail = StringUtils.isNotEmpty((String)curPermDetailStr) ? SerializationUtils.fromJsonStringToList((String)curPermDetailStr, String.class) : new ArrayList(10);
                ArrayList<String> searchInfos = new ArrayList<String>(100);
                for (String value : curPermDetail) {
                    String[] arr = value.split("    ");
                    String entityName = arr[7];
                    String entityNum = arr[6];
                    if (!entityName.contains(text) && (!showNum || !entityNum.equals(text))) continue;
                    searchInfos.add(value);
                }
                this.getPageCache().putBigObject("userFuncPermTreeSearchMode", SerializationUtils.toJsonString(searchInfos));
                this.rebuildTree("tree_funcperm", searchInfos, true);
            }
        } else if ("fieldpermsearchap".equals(key)) {
            String flagBatchAssign = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
            if (StringUtils.isNotEmpty((String)flagBatchAssign)) {
                return;
            }
            this.getPageCache().remove("lastClickFieldPermNode");
            if (StringUtils.isBlank((String)text)) {
                this.getPageCache().removeBigObject("fieldPermTreeSearchMode");
                String[] arr = sourceKey.split("\\|");
                this.initFieldPermTree(arr[0], Long.valueOf(arr[1]));
                this.getModel().setValue("fieldpermsetup", (Object)false);
            } else {
                Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
                String curPermDetailStr = assignPermCurInfoMap.get("tree_funcperm").get(sourceKey);
                ArrayList curPermDetail = StringUtils.isNotEmpty((String)curPermDetailStr) ? SerializationUtils.fromJsonStringToList((String)curPermDetailStr, String.class) : new ArrayList(10);
                ArrayList<String> searchInfos = new ArrayList<String>(100);
                for (String value : curPermDetail) {
                    String[] arr = value.split("    ");
                    String entityName = arr[7];
                    String entityNum = arr[6];
                    if (!entityName.contains(text) && (!showNum || !entityNum.equals(text))) continue;
                    searchInfos.add(value);
                }
                this.getPageCache().putBigObject("fieldPermTreeSearchMode", SerializationUtils.toJsonString(searchInfos));
                this.rebuildTree("tree_fieldperm", searchInfos, false);
                this.getModel().setValue("fieldpermsetup", (Object)false);
            }
            this.getModel().deleteEntryData("fieldperm_entry");
            this.getModel().deleteEntryData("entryentity_fps");
            this.getModel().deleteEntryData("entryentity_fps_sensitive");
            this.getView().setVisible(Boolean.FALSE, new String[]{"tab_fieldperm"});
        } else if ("datapermsearchap".equals(key)) {
            String flagBatchAssign = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
            if (StringUtils.isNotEmpty((String)flagBatchAssign)) {
                return;
            }
            Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
            this.needUpdateDataPermPageCache(null, assignPermCurInfoMap);
            this.getPageCache().remove(PGCACHE_LASTCLICK_DATAPERM_NODE);
            if (StringUtils.isBlank((String)text)) {
                this.getPageCache().removeBigObject("dataPermTreeSearchMode");
                boolean setup = (Boolean)this.getModel().getValue("datapermsetup");
                if (setup) {
                    this.getModel().setValue("datapermsetup", (Object)false);
                } else {
                    TreeView tv = (TreeView)this.getControl("tree_dataperm");
                    tv.deleteAllNodes();
                    Map dataResource = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject(sourceKey), Map.class);
                    TreeNode rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllreadyAssignDesc());
                    rootNode.setIsOpened(true);
                    tv.addNode(rootNode);
                    this.funcPermTreeUtil.createCloudNodes(rootNode, dataResource, showNum);
                }
            } else {
                String curPermDetailStr = assignPermCurInfoMap.get("tree_funcperm").get(sourceKey);
                ArrayList curPermDetail = StringUtils.isNotEmpty((String)curPermDetailStr) ? SerializationUtils.fromJsonStringToList((String)curPermDetailStr, String.class) : new ArrayList(10);
                ArrayList<String> searchInfos = new ArrayList<String>(100);
                for (String value : curPermDetail) {
                    String[] arr = value.split("    ");
                    String entityName = arr[7];
                    String entityNum = arr[6];
                    if (!entityName.contains(text) && (!showNum || !entityNum.equals(text))) continue;
                    searchInfos.add(value);
                }
                this.getPageCache().putBigObject("dataPermTreeSearchMode", SerializationUtils.toJsonString(searchInfos));
                this.rebuildTree("tree_dataperm", searchInfos, false);
                this.getModel().setValue("datapermsetup", (Object)false);
            }
            this.clearDataPermFilterGrid();
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtergrid_dataperm"});
        } else if ("datarulesearchap".equals(key)) {
            String flagBatchAssign = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
            if (StringUtils.isNotEmpty((String)flagBatchAssign)) {
                return;
            }
            this.getPageCache().remove(PGCACHE_LASTCLICK_DATARULE_NODE);
            if (StringUtils.isBlank((String)text)) {
                this.getPageCache().removeBigObject("allFuncPermTreeSearchMode");
                String[] arr = sourceKey.split("\\|");
                this.initDataRuleTree(arr[0], Long.valueOf(arr[1]));
                this.getModel().setValue("datarulesetup", (Object)false);
            } else {
                Map<String, String> allPermNodeInfoMap = this.funcPermTreeUtil.getAllPermNodeInfoMap();
                Collection<String> values = allPermNodeInfoMap.values();
                ArrayList<String> searchInfos = new ArrayList<String>(100);
                for (String value : values) {
                    String[] arr = value.split("    ");
                    String entityName = arr[7];
                    String entityNum = arr[6];
                    if (!entityName.contains(text) && (!showNum || !entityNum.equals(text))) continue;
                    searchInfos.add(value);
                }
                this.getPageCache().putBigObject("dataRuleTreeSearchMode", SerializationUtils.toJsonString(searchInfos));
                this.rebuildTree("tree_datarule", searchInfos, false);
                this.getModel().setValue("datarulesetup", (Object)false);
            }
            this.getModel().deleteEntryData("datarule_entry");
            this.getModel().deleteEntryData("bddatarule_entry");
            this.getView().setVisible(Boolean.FALSE, new String[]{"tab_datarule"});
        }
    }

    private void rebuildTree(String treeView, List<String> searchInfos, boolean funcPermTree) {
        TreeNode rootNode = null;
        TreeView tv = null;
        switch (treeView) {
            case "tree_allfunctionperm": {
                rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getFuncPerm());
                rootNode.setIsOpened(true);
                tv = (TreeView)this.getControl("tree_allfunctionperm");
                break;
            }
            case "tree_funcperm": {
                rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllreadyAssignDesc());
                rootNode.setIsOpened(true);
                tv = (TreeView)this.getControl("tree_funcperm");
                break;
            }
            case "tree_fieldperm": {
                rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllreadyAssignDesc());
                rootNode.setIsOpened(true);
                tv = (TreeView)this.getControl("tree_fieldperm");
                break;
            }
            case "tree_dataperm": {
                rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllreadyAssignDesc());
                rootNode.setIsOpened(true);
                tv = (TreeView)this.getControl("tree_dataperm");
                break;
            }
            case "tree_datarule": {
                rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAssignObj());
                rootNode.setIsOpened(true);
                tv = (TreeView)this.getControl("tree_datarule");
                break;
            }
            default: {
                return;
            }
        }
        tv.deleteAllNodes();
        tv.addNode(rootNode);
        Map<String, String> cloudNameMap = this.funcPermTreeUtil.getCloudNameMap();
        Map<String, String> appNameMap = this.funcPermTreeUtil.getAppNameMap();
        Map<String, String> entityNumNameMap = this.funcPermTreeUtil.getEntityNumNameMap();
        Map<String, String> permItemIdNameMap = this.funcPermTreeUtil.getPermItemIdNameMap();
        boolean showNum = (Boolean)this.getModel().getValue("shownum");
        if (!CollectionUtils.isEmpty(searchInfos)) {
            String lastKey = "";
            String lastEntityNode = "";
            TreeNode cloudNode = null;
            TreeNode appNode = null;
            TreeNode entityNode = null;
            String entityNodeId = "";
            for (String searchInfo : searchInfos) {
                Object[] arr = searchInfo.split("    ");
                String cloudId = arr[2];
                if ("2HGKCE94QELW".equals(cloudId)) continue;
                String appId = arr[5];
                String entityNum = arr[6];
                String curKey = cloudId + '_' + appId + '_' + entityNum;
                if (!lastKey.equals(curKey)) {
                    String appNodeId;
                    lastKey = curKey;
                    String cloudNodeId = "cloud#" + cloudId;
                    cloudNode = rootNode.getTreeNode(cloudNodeId);
                    if (cloudNode == null) {
                        String cloudName = cloudNameMap.get(cloudId);
                        if (StringUtils.isEmpty((String)cloudName)) {
                            cloudName = cloudId;
                        }
                        if (showNum) {
                            String cloudNumber = StringUtils.isEmpty((String)arr[1]) ? "NotFound" : arr[1];
                            cloudName = cloudName + '(' + cloudNumber + ')';
                        }
                        cloudNode = new TreeNode("-1", cloudNodeId, cloudName);
                        cloudNode.setIsOpened(true);
                        rootNode.addChild(cloudNode);
                    }
                    if ((appNode = cloudNode.getTreeNode(appNodeId = "app#" + appId)) == null) {
                        String appName = appNameMap.get(appId);
                        if (StringUtils.isEmpty((String)appName)) {
                            appName = appId;
                        }
                        if (showNum) {
                            String appNumber = StringUtils.isEmpty((String)arr[4]) ? "NotFound" : arr[4];
                            appName = appName + '(' + appNumber + ')';
                        }
                        appNode = new TreeNode(cloudNodeId, appNodeId, appName);
                        appNode.setIsOpened(true);
                        cloudNode.addChild(appNode);
                    }
                    entityNodeId = "entity#" + entityNum + '@' + appId;
                    if (!lastEntityNode.equals("") && lastEntityNode.equals(entityNodeId) && funcPermTree) continue;
                    lastEntityNode = entityNodeId;
                    entityNode = appNode.getTreeNode(entityNodeId);
                    if (entityNode == null) {
                        String entityName = entityNumNameMap.get(entityNum);
                        if (StringUtils.isEmpty((String)entityName)) {
                            entityName = entityNum;
                            entityNum = "NotFound";
                        }
                        if (showNum) {
                            entityName = entityName + '(' + entityNum + ')';
                        }
                        entityNode = new TreeNode(appNodeId, entityNodeId, entityName);
                        if (null != appNode) {
                            appNode.addChild(entityNode);
                        }
                    }
                }
                if (!funcPermTree) continue;
                if (arr.length < 10) {
                    logger.debug("arr[]:" + Arrays.toString(arr));
                    continue;
                }
                String permItemId = arr[9];
                String permItemNodeId = "permitem#" + permItemId + '@' + (String)arr[6] + '|' + appId;
                Object permItemName = permItemIdNameMap.get(permItemId);
                Object permItemNumber = arr[8];
                if (StringUtils.isEmpty((String)permItemName)) {
                    permItemName = permItemNumber;
                    permItemNumber = "NotFound";
                }
                if (showNum) {
                    permItemName = (String)permItemName + '(' + (String)permItemNumber + ')';
                }
                TreeNode permItemNode = new TreeNode(entityNodeId, permItemNodeId, (String)permItemName);
                if (null == entityNode) continue;
                entityNode.addChild(permItemNode);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object source = evt.getSource();
        if (source instanceof BasedataEdit) {
            ArrayList<QFilter> qList;
            BasedataEdit bd = (BasedataEdit)source;
            String fieldKey = bd.getFieldKey();
            String nodeId = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
            String entityNum = "";
            if (StringUtils.isNotEmpty((String)nodeId)) {
                String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
                entityNum = nodeInfoArr[1];
            }
            if ("user".equals(fieldKey)) {
                qList = new ArrayList<QFilter>(10);
                QFilter qFilter = new QFilter("id", "!=", (Object)1L);
                qList.add(qFilter);
                List robotIds = PermCommonUtil.getRobotIds();
                robotIds.add(RequestContext.get().getCurrUserId());
                qList.add(new QFilter("id", "not in", (Object)robotIds));
                ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
                evt.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
                if (evt.getFormShowParameter() instanceof ListShowParameter) {
                    String userQFilterCache = this.getPageCache().get("CustomQFilter_UserIds");
                    if (StringUtils.isNotEmpty((String)userQFilterCache)) {
                        QFilter userQFilter = QFilter.fromSerializedString((String)userQFilterCache);
                        qList.add(userQFilter);
                        ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
                        return;
                    }
                    String customUserIds = this.getPageCache().get("CustomFilter_UserIds");
                    if (StringUtils.isNotEmpty((String)customUserIds)) {
                        List strUserIdList = (List)SerializationUtils.fromJsonString((String)customUserIds, List.class);
                        ArrayList<Long> userIdList = new ArrayList<Long>(strUserIdList.size());
                        for (Object strUserId : strUserIdList) {
                            userIdList.add(Long.parseLong(strUserId.toString()));
                        }
                        qList.add(new QFilter("id", "in", userIdList));
                        ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
                        return;
                    }
                }
            } else if ("permitem".equals(fieldKey)) {
                DynamicObject[] col;
                HashSet permItems = new HashSet(EntityMetadataCache.getPermissionItems((String)entityNum));
                permItems.remove("4730fc9f000003ae");
                permItems.remove("4730fc9f000004ae");
                EntryGrid eg = (EntryGrid)this.getControl("datarule_entry");
                for (DynamicObject o : col = eg.getEntryData().getDataEntitys()) {
                    if (o == null) continue;
                    permItems.remove(o.getString("permitem_id"));
                }
                ArrayList<QFilter> qList2 = new ArrayList<QFilter>();
                QFilter q = new QFilter("id", "in", permItems);
                qList2.add(q);
                ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
                ListSelectedRowCollection lsrc = new ListSelectedRowCollection();
                lsp.setListSelectedRowCollection(lsrc);
                lsp.setListFilterParameter(new ListFilterParameter(qList2, null));
            } else if ("datarule".equals(fieldKey)) {
                qList = new ArrayList();
                QFilter q1 = new QFilter("isdetail", "=", (Object)"1");
                qList.add(q1);
                QFilter q3 = new QFilter("entity", "=", (Object)entityNum);
                qList.add(q3);
                ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
            } else if ("bddatarule".equals(fieldKey)) {
                qList = new ArrayList();
                QFilter q1 = new QFilter("isdetail", "=", (Object)"1");
                qList.add(q1);
                int index = this.getModel().getEntryCurrentRowIndex("bddatarule_entry");
                DynamicObject bdObj = (DynamicObject)this.getModel().getValue("bdentity", index);
                if (bdObj == null) {
                    return;
                }
                String bdPropEntNum = bdObj.getPkValue().toString();
                QFilter q3 = new QFilter("entity", "=", (Object)bdPropEntNum);
                qList.add(q3);
                ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
            }
        }
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent evt) {
        Object source = evt.getSource();
        if (source instanceof BasedataEdit) {
            BasedataEdit bd = (BasedataEdit)source;
            String fieldKey = bd.getFieldKey();
            String nodeId = this.getPageCache().get(PGCACHE_LASTCLICK_DATARULE_NODE);
            String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
            String entityNum = nodeInfoArr[1];
            if ("datarule".equals(fieldKey)) {
                evt.getShowParameter().getCustomParams().put("DataRule_treeSelected", entityNum);
            } else if ("bddatarule".equals(fieldKey)) {
                int index = this.getModel().getEntryCurrentRowIndex("bddatarule_entry");
                DynamicObject bdObj = (DynamicObject)this.getModel().getValue("bdentity", index);
                if (bdObj == null) {
                    return;
                }
                String bdPropEntNum = bdObj.getPkValue().toString();
                evt.getShowParameter().getCustomParams().put("DataRule_treeSelected", bdPropEntNum);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        boolean dataChange = (Boolean)this.getModel().getValue("datachangeflag");
        if (dataChange || !dimDataChangeSet.isEmpty()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"UserDirectAssignPermMultiPlugin_31", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            e.setCancel(true);
        } else {
            this.release();
        }
    }

    private void needUpdateDataPermPageCache(String sourceKey, Map<String, Map<String, String>> assignPermCurInfoMap) {
        if (!this.hasEnableOldDataRule) {
            return;
        }
        String lastClickDataPermNode = this.getPageCache().get(PGCACHE_LASTCLICK_DATAPERM_NODE);
        if (StringUtils.isEmpty((String)lastClickDataPermNode)) {
            return;
        }
        if (StringUtils.isEmpty((String)sourceKey)) {
            sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        }
        if (sourceKey == null || sourceKey.contains(",")) {
            return;
        }
        if (assignPermCurInfoMap == null) {
            assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        }
        Map<String, String> curDataPerm = assignPermCurInfoMap.get("tree_dataperm");
        Map dimCurDataPerm = (Map)SerializationUtils.fromJsonString((String)curDataPerm.get(sourceKey), Map.class);
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        Set<String> changeDataPermDimSet = this.assignPermCacheUtil.getChangeDataPermDimSet();
        Map<String, Map<String, String>> dataPermSettingErrorMap = this.assignPermCacheUtil.getDataPermSettingErrorMap();
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergrid_dataperm");
        FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
        String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)lastClickDataPermNode);
        String entityNumber = nodeInfoArr[1];
        boolean errorSettingChange = false;
        Map entityDataPermSettingError = dataPermSettingErrorMap.computeIfAbsent(sourceKey, k -> new HashMap(16));
        Map<String, String> entityNumNameMap = this.funcPermTreeUtil.getEntityNumNameMap();
        try {
            PermCommonUtil.validateFilterCondition((String)entityNumber, (FilterCondition)fc);
            if (entityDataPermSettingError.containsKey(lastClickDataPermNode)) {
                entityDataPermSettingError.remove(lastClickDataPermNode);
                if (CollectionUtils.isEmpty((Map)entityDataPermSettingError)) {
                    dataPermSettingErrorMap.remove(sourceKey);
                }
                errorSettingChange = true;
            }
        }
        catch (Exception e) {
            Map<String, String> dimInfoMap = this.assignPermCacheUtil.getDimInfoMap();
            String message = e.getMessage();
            String dimName = dimInfoMap.get(sourceKey).split(",")[1];
            String dimTypeName = ((Tab)this.getControl("dimtab")).getCurrentTab().split("\\|")[1];
            String entityName = entityNumNameMap.get(entityNumber);
            entityDataPermSettingError.put(lastClickDataPermNode, String.join((CharSequence)"|", dimTypeName, dimName, entityName, message));
            errorSettingChange = true;
        }
        List filterRowList = fc.getFilterRow();
        String newValue = " ";
        if (!CollectionUtils.isEmpty((Collection)filterRowList)) {
            newValue = SerializationUtils.toJsonString((Object)fc);
        }
        dimCurDataPerm.put(lastClickDataPermNode, newValue);
        curDataPerm.put(sourceKey, SerializationUtils.toJsonString((Object)dimCurDataPerm));
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
        HashMap<String, String> newCacheData = new HashMap<String, String>(16);
        changeDataPermDimSet.add(sourceKey);
        newCacheData.put("changeDataPermDimSet", SerializationUtils.toJsonString(changeDataPermDimSet));
        dimDataChangeSet.add(sourceKey);
        newCacheData.put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
        if (errorSettingChange) {
            newCacheData.put("dataPermSettingErrorMap", SerializationUtils.toJsonString(dataPermSettingErrorMap));
        }
        this.getPageCache().put(newCacheData);
    }

    private void clearDataPermFilterGrid() {
        if (!this.hasEnableOldDataRule) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergrid_dataperm");
        FilterCondition filterCondition = new FilterCondition();
        filterGrid.SetValue(filterCondition);
        filterCondition = null;
        filterGrid.SetValue(filterCondition);
    }

    private void fillDimUserPermInfo(Map<String, Map<String, String>> updateDimUserPermMap) {
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        Map<String, String> funcPermUpdateInfo = updateDimUserPermMap.get("tree_funcperm");
        Map<String, String> fieldPermUpdateInfo = updateDimUserPermMap.get("tree_fieldperm");
        Map<String, String> dataPermUpdateInfo = updateDimUserPermMap.get("tree_dataperm");
        Map userDirectAssignDim = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_USER_ASSIGN_INFO), Map.class);
        for (String sourceKey : dimDataChangeSet) {
            String userDataPermId;
            String userFieldPermId;
            String[] dimInfo = sourceKey.split("\\|");
            String dimType = dimInfo[0];
            String dimId = dimInfo[1];
            Map curDimTypeAssignInfo = (Map)userDirectAssignDim.get(dimType);
            CharSequence[] permInfoArr = ((String)curDimTypeAssignInfo.get(dimId)).split(",");
            permInfoArr[2] = "0";
            String userPermId = permInfoArr[3];
            if (StringUtils.isEmpty((String)userPermId)) {
                permInfoArr[3] = userPermId = funcPermUpdateInfo.get(sourceKey);
            }
            if (StringUtils.isNotNull((String)(userFieldPermId = fieldPermUpdateInfo.get(sourceKey)))) {
                permInfoArr[4] = userFieldPermId;
            }
            if (StringUtils.isNotNull((String)(userDataPermId = dataPermUpdateInfo.get(sourceKey)))) {
                permInfoArr[5] = userDataPermId;
            }
            curDimTypeAssignInfo.put(dimId, String.join((CharSequence)",", permInfoArr));
        }
        this.getModel().setValue("datachangeflag", (Object)false);
        this.getPageCache().put(PGCACHE_USER_ASSIGN_INFO, SerializationUtils.toJsonString((Object)userDirectAssignDim));
    }

    private void clearCacheAfterSave() {
        Set<String> dimDataChangeSet = this.assignPermCacheUtil.getDimDataChangeSet();
        Set<String> addDimSet = this.assignPermCacheUtil.getAddDimSet();
        Set<String> removeDimSet = this.assignPermCacheUtil.getRemoveDimSet();
        Set<String> changeFieldPermDimSet = this.assignPermCacheUtil.getChangeFieldPermDimSet();
        Set<String> removeFieldPermDimSet = this.assignPermCacheUtil.getRemoveFieldPermDimSet();
        Set<String> changeFpsDimSet = this.assignPermCacheUtil.getChangeFpsDimSet();
        Set<String> removeFpsDimSet = this.assignPermCacheUtil.getRemoveFpsDimSet();
        Set<String> changeDataPermDimSet = this.assignPermCacheUtil.getChangeDataPermDimSet();
        Set<String> removeDataPermDimSet = this.assignPermCacheUtil.getRemoveDataPermDimSet();
        Set<String> changeDataRuleDimSet = this.assignPermCacheUtil.getChangeDataRuleDimSet();
        Set<String> removeDataRuleDimSet = this.assignPermCacheUtil.getRemoveDataRuleDimSet();
        HashMap<String, String> newDataCache = new HashMap<String, String>(16);
        Map<String, Map<String, String>> assignPermOriInfoMap = this.assignPermCacheUtil.getAssignPermOriInfoMap();
        Map<String, Map<String, String>> assignPermCurInfoMap = this.assignPermCacheUtil.getAssignPermCurInfoMap();
        dimDataChangeSet.clear();
        newDataCache.put("dimDataChangeSet", SerializationUtils.toJsonString(dimDataChangeSet));
        addDimSet.clear();
        newDataCache.put("addDimSet", SerializationUtils.toJsonString(addDimSet));
        removeDimSet.clear();
        newDataCache.put("removeDimSet", SerializationUtils.toJsonString(removeDimSet));
        HashMap<String, String> temp = new HashMap<String, String>(16);
        String sourceKey = this.getPageCache().get(PGCACHE_LASTENTRYROWCLICK);
        if (!StringUtils.isEmpty((String)sourceKey)) {
            Map<String, String> curPermMap = assignPermCurInfoMap.get("tree_funcperm");
            String[] sourceKeyArr = sourceKey.split(",");
            temp = new HashMap(sourceKeyArr.length);
            for (String rowInfo : sourceKeyArr) {
                temp.put(rowInfo, curPermMap.get(rowInfo));
            }
        }
        Map<String, String> oriPerm = assignPermOriInfoMap.get("tree_funcperm");
        oriPerm.clear();
        Map<String, String> curPerm = assignPermCurInfoMap.get("tree_funcperm");
        curPerm.clear();
        oriPerm.putAll(temp);
        curPerm.putAll(temp);
        changeFieldPermDimSet.clear();
        newDataCache.put("changeFieldPermDimSet", SerializationUtils.toJsonString(changeFieldPermDimSet));
        removeFieldPermDimSet.clear();
        newDataCache.put("removeFieldPermDimSet", SerializationUtils.toJsonString(removeFieldPermDimSet));
        changeFpsDimSet.clear();
        newDataCache.put("changeFpsDimSet", SerializationUtils.toJsonString(changeFpsDimSet));
        removeFpsDimSet.clear();
        newDataCache.put("removeFpsDimSet", SerializationUtils.toJsonString(removeFpsDimSet));
        String flagBatchAssign = this.getPageCache().get(PGCACHE_BATCH_ASSIGN);
        Map<String, String> oriFieldPerm = assignPermOriInfoMap.get("tree_fieldperm");
        oriFieldPerm.clear();
        Map<String, String> curFieldPerm = assignPermCurInfoMap.get("tree_fieldperm");
        if (StringUtils.isEmpty((String)flagBatchAssign)) {
            String curDimCurFieldPermStr = curFieldPerm.get(sourceKey);
            curFieldPerm.clear();
            if (StringUtils.isNotEmpty((String)curDimCurFieldPermStr)) {
                curFieldPerm.put(sourceKey, curDimCurFieldPermStr);
                oriFieldPerm.put(sourceKey, curDimCurFieldPermStr);
            }
        } else {
            curFieldPerm.clear();
        }
        changeDataPermDimSet.clear();
        newDataCache.put("changeDataPermDimSet", SerializationUtils.toJsonString(changeDataPermDimSet));
        removeDataPermDimSet.clear();
        newDataCache.put("removeDataPermDimSet", SerializationUtils.toJsonString(removeDataPermDimSet));
        Map<String, String> oriDataPerm = assignPermOriInfoMap.get("tree_dataperm");
        oriDataPerm.clear();
        Map<String, String> curDataPerm = assignPermCurInfoMap.get("tree_dataperm");
        if (StringUtils.isEmpty((String)flagBatchAssign)) {
            String curDimDataPermStr = curDataPerm.get(sourceKey);
            if (StringUtils.isNotEmpty((String)curDimDataPermStr)) {
                Map nodeDataPermMap = (Map)SerializationUtils.fromJsonString((String)curDimDataPermStr, Map.class);
                curDataPerm.clear();
                curDataPerm.put(sourceKey, SerializationUtils.toJsonString((Object)nodeDataPermMap));
                HashSet<String> curDataPermDetail = new HashSet<String>(16);
                for (Map.Entry dataPerm : nodeDataPermMap.entrySet()) {
                    String nodeId = (String)dataPerm.getKey();
                    String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)nodeId);
                    String appId = nodeInfoArr[0];
                    String entityNum = nodeInfoArr[1];
                    String rule = (String)dataPerm.getValue();
                    curDataPermDetail.add(appId + "|" + entityNum + "|" + rule);
                }
                oriDataPerm.put(sourceKey, SerializationUtils.toJsonString(curDataPermDetail));
            }
        } else {
            curDataPerm.clear();
        }
        changeDataRuleDimSet.clear();
        newDataCache.put("changeDataRuleDimSet", SerializationUtils.toJsonString(changeDataRuleDimSet));
        removeDataRuleDimSet.clear();
        newDataCache.put("removeDataRuleDimSet", SerializationUtils.toJsonString(removeDataRuleDimSet));
        Map<String, String> oriDataRule = assignPermOriInfoMap.get("tree_datarule");
        oriDataRule.clear();
        Map<String, String> curDataRule = assignPermCurInfoMap.get("tree_datarule");
        if (StringUtils.isEmpty((String)flagBatchAssign)) {
            String curDimDataRuleStr = curDataRule.get(sourceKey);
            curDataRule.clear();
            if (StringUtils.isNotEmpty((String)curDimDataRuleStr)) {
                curDataRule.put(sourceKey, curDimDataRuleStr);
                oriDataRule.put(sourceKey, curDimDataRuleStr);
            }
        } else {
            curDataRule.clear();
        }
        this.assignPermCacheUtil.putAssignPermOriInfoMap(assignPermOriInfoMap);
        this.assignPermCacheUtil.putAssignPermCurInfoMap(assignPermCurInfoMap);
        this.getPageCache().put(newDataCache);
        this.getModel().setValue("datachangeflag", (Object)false);
        CacheMrg.clearAllCache();
    }

    private Map<String, String> getEntityFieldNameInfo(String entityNum) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNum);
        List fieldInfoList = new ChoiceFieldPageCustomQuery().parseProperty((IDataEntityType)met);
        HashMap<String, String> fieldInfoMap = new HashMap<String, String>(fieldInfoList.size());
        for (Map fieldMap : fieldInfoList) {
            String field_id = (String)fieldMap.get("field_id");
            String field_name = (String)fieldMap.get("field_name");
            fieldInfoMap.put(field_id, field_name);
        }
        return fieldInfoMap;
    }

    private String[] getSelectedDimInfo() {
        EntryGrid eg = (EntryGrid)this.getControl("dim_entry");
        int[] selectRows = eg.getSelectRows();
        String dimName = ((DynamicObject)this.getModel().getValue("dimname", selectRows[0])).getString("name");
        String dimTypeName = ((Tab)this.getControl("dimtab")).getCurrentTab().split("\\|")[1];
        return new String[]{dimName, dimTypeName};
    }

    private void clearAllEntryRow(String entryKey) {
        int entryRowCount = this.getModel().getEntryRowCount(entryKey);
        if (0 == entryRowCount) {
            return;
        }
        this.getModel().deleteEntryData(entryKey);
    }
}

