/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.userbusirole;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.Delete;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.BillList;
import kd.bos.list.events.ChatEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.formplugin.plugin.dataprovider.UserBusiRoleListProvider;
import kd.bos.permission.service.AbstractPermissionServiceImpl;
import kd.bos.permission.util.PermFilterUtil;
import kd.bos.permission.util.PermissionServiceImplFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class UserBusiRoleListPlugin
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static Log logger = LogFactory.getLog(UserBusiRoleListPlugin.class);

    public void chat(ChatEvent e) {
        e.setCancel(true);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        String fieldName;
        switch (fieldName = event.getFieldName()) {
            case "user.id": {
                boolean enableJustShowAdminCharged_u = PermCommonUtil.isEnableJustShowAdminCharged();
                HashMap<String, Object> userParamMap = new HashMap<String, Object>(8);
                userParamMap.put("userField", "id");
                userParamMap.put("enableJustShowAdminCharged", enableJustShowAdminCharged_u);
                QFilter userFilter = PermFilterUtil.getAdminChargeUserQfilter(userParamMap);
                if (null == userFilter) break;
                event.getQfilters().add(userFilter);
                break;
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List valueList;
        List qFilters;
        super.filterContainerSearchClick(args);
        QFilter bizRoleIdFilter = args.getQFilter("bizrole.id");
        QFilter userIdFilter = args.getQFilter("user.id");
        List fastQFilters = args.getFastQFilters();
        List list = qFilters = null == args.getFilterParameter() ? new ArrayList(0) : args.getFilterParameter().getQFilters();
        if (null == bizRoleIdFilter && null == userIdFilter && CollectionUtils.isEmpty((Collection)fastQFilters)) {
            this.getPageCache().remove("isSearchMode");
        }
        if (null == bizRoleIdFilter && null == userIdFilter && CollectionUtils.isEmpty((Collection)fastQFilters) && CollectionUtils.isEmpty(qFilters)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u3001\u7528\u6237\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u9879\u3002", (String)"UserBusiRoleListPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        if (null != bizRoleIdFilter && null != bizRoleIdFilter.getValue() && bizRoleIdFilter.getValue() instanceof List && CollectionUtils.isNotEmpty((Collection)(valueList = (List)bizRoleIdFilter.getValue())) && valueList.size() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u3002", (String)"UserBusiRoleListPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        if (null != userIdFilter && null != userIdFilter.getValue() && userIdFilter.getValue() instanceof List && CollectionUtils.isNotEmpty((Collection)(valueList = (List)userIdFilter.getValue())) && valueList.size() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7528\u6237\u201d\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u3002", (String)"PermUserRoleMulTypeListPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        if (CollectionUtils.isNotEmpty((Collection)qFilters)) {
            ArrayList<QFilter> fastQfilter2Qfilter = new ArrayList<QFilter>(10);
            Iterator<QFilter> iterator = qFilters.iterator();
            while (iterator.hasNext()) {
                UserBusiRoleListPlugin.fast2Normal(fastQfilter2Qfilter, iterator);
            }
            if (CollectionUtils.isNotEmpty(fastQfilter2Qfilter)) {
                e.getQFilters().addAll(fastQfilter2Qfilter);
            }
            this.getPageCache().put("isSearchMode", "1");
        }
        StringBuilder appendOrderStr = new StringBuilder();
        ListView view = (ListView)this.getView();
        String billFormId = view.getBillFormId();
        boolean busiRoleAssignUser = this.busiRoleAssignUser(billFormId);
        if (busiRoleAssignUser) {
            appendOrderStr.append("bizrole.number, user.number");
        } else {
            appendOrderStr.append("user.number, bizrole.number");
        }
        String orderBy = e.getOrderBy();
        if (StringUtils.isEmpty((String)orderBy)) {
            e.setOrderBy(appendOrderStr.toString());
        } else {
            e.setOrderBy(orderBy + ',' + appendOrderStr);
        }
    }

    private static void fast2Normal(List<QFilter> fastQfilter2Qfilter, Iterator<QFilter> iterator) {
        QFilter filter = iterator.next();
        if (null == filter) {
            return;
        }
        String cp = filter.getCP();
        String property = filter.getProperty();
        if (!Objects.equals("ftlike", cp) || !Objects.equals("1", property)) {
            return;
        }
        Object valueObj = filter.getValue();
        if (null == valueObj) {
            return;
        }
        String value = (String)valueObj;
        String[] split = value.split("#", 2);
        if (null == split || !Objects.equals(2, split.length)) {
            return;
        }
        if (StringUtils.isEmpty((String)split[1])) {
            return;
        }
        String searchContent = String.format("%s%s%s", "%", split[1], "%");
        if (value.startsWith("bizrole.number#")) {
            Set idSet = SqlUtil.getIdSet((String)"perm_busirole", (List)Lists.newArrayList((Object[])new QFilter[]{new QFilter("number", "like", (Object)searchContent)}));
            fastQfilter2Qfilter.add(new QFilter("bizrole", "in", (Object)idSet));
            iterator.remove();
            return;
        }
        if (value.startsWith("bizrole.name#")) {
            Set idSet = SqlUtil.getIdSet((String)"perm_busirole", (List)Lists.newArrayList((Object[])new QFilter[]{new QFilter("name", "like", (Object)searchContent)}));
            fastQfilter2Qfilter.add(new QFilter("bizrole", "in", (Object)idSet));
            iterator.remove();
            return;
        }
        if (value.startsWith("user.number#")) {
            Set idSet = SqlUtil.getIdSet((String)"bos_user", (List)Lists.newArrayList((Object[])new QFilter[]{new QFilter("number", "like", (Object)searchContent)}));
            fastQfilter2Qfilter.add(new QFilter("user", "in", (Object)idSet));
            iterator.remove();
            return;
        }
        if (value.startsWith("user.name#")) {
            Set idSet = SqlUtil.getIdSet((String)"bos_user", (List)Lists.newArrayList((Object[])new QFilter[]{new QFilter("name", "like", (Object)searchContent)}));
            fastQfilter2Qfilter.add(new QFilter("user", "in", (Object)idSet));
            iterator.remove();
            return;
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new UserBusiRoleListProvider(this.getPageCache(), this.getView()));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "tbldel": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection listSelectedData = billList.getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PermUserRoleMulTypeListPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
                String confirmTips = ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u5206\u914d\u7528\u6237\u8bb0\u5f55\u5220\u9664\u540e\uff0c\u6240\u9009\u7528\u6237\u7684\u5bf9\u5e94\u6743\u9650\u4e5f\u540c\u6b65\u5220\u9664\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"UserBusiRoleListPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                AbstractListView abstractListView = (AbstractListView)this.getView();
                String billFormId = abstractListView.getBillFormId();
                if (Objects.equals("perm_userbusirole_layout", billFormId)) {
                    confirmTips = ResManager.loadKDString((String)"\u7528\u6237\u5206\u914d\u4e1a\u52a1\u89d2\u8272\u8bb0\u5f55\u5220\u9664\u540e\uff0c\u6240\u9009\u7528\u6237\u7684\u5bf9\u5e94\u6743\u9650\u4e5f\u540c\u6b65\u5220\u9664\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"UserBusiRoleListPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                }
                abstractListView.setConfirmDeleteMsg(confirmTips);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Delete) {
            OperateOption option = ((FormOperate)e.getSource()).getOption();
            if (PermCommonUtil.isEnablePermLog()) {
                option.setVariableValue("ENTSAVE_PERMLOG", "1");
                option.setVariableValue("permlog_op", "delete");
                option.setVariableValue("permlog_opbtn", ConstantsHelper.getDel());
                option.setVariableValue("permlog_interfacemethod", "kd.bos.permission.formplugin.plugin.userbusirole.UserBusiRoleListPlugin.beforeDoOperation");
                ListView view = (ListView)this.getView();
                String billFormId = view.getBillFormId();
                boolean busiRoleAssignUser = this.busiRoleAssignUser(billFormId);
                String permlog_busitype = busiRoleAssignUser ? "busi_role_assignuserlist_del" : "user_assignbusirolelist_del";
                option.setVariableValue("permlog_busitype", permlog_busitype);
                option.setVariableValue("permlog_formnum", billFormId);
            }
            HashMap<String, Integer> permPkRowNumMap = new HashMap<String, Integer>(8);
            BillList billlistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            for (ListSelectedRow selectedRow : selectedRows) {
                permPkRowNumMap.put(String.valueOf(selectedRow.getPrimaryKeyValue()), selectedRow.getRowKey());
            }
            option.setVariableValue("permPkRowNumMap", SerializationUtils.toJsonString(permPkRowNumMap));
            long currUserId = RequestContext.get().getCurrUserId();
            UserScopeResult adminChargeUser = UserBusiRoleListPlugin.getPermissionService().getAdminChargeUser(Long.valueOf(currUserId), false);
            boolean allUser = adminChargeUser.isAllUser();
            List userIDs = adminChargeUser.getUserIDs();
            option.setVariableValue("adminChargeUser_allUser", allUser ? "1" : "0");
            option.setVariableValue("adminChargeUser_userIDs", JSON.toJSONString((Object)userIDs));
        }
    }

    private static AbstractPermissionServiceImpl getPermissionService() {
        return (AbstractPermissionServiceImpl)PermissionServiceImplFactory.getImpl(null);
    }

    private boolean busiRoleAssignUser(String billFormId) {
        return !Objects.equals("perm_userbusirole_layout", billFormId);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        try {
            args.setCancel(true);
            ListView listView = (ListView)this.getView();
            if (null == listView) {
                return;
            }
            String billFormId = listView.getBillFormId();
            if (StringUtils.isEmpty((String)billFormId)) {
                return;
            }
            HyperLinkClickEvent hyperLinkClickEvent = args.getHyperLinkClickEvent();
            if (null == hyperLinkClickEvent) {
                return;
            }
            BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)hyperLinkClickEvent;
            String fieldName = billListHyperLinkClickEvent.getFieldName();
            if (StringUtils.isEmpty((String)fieldName)) {
                return;
            }
            ListSelectedRow currentRow = billListHyperLinkClickEvent.getCurrentRow();
            if (null == currentRow) {
                return;
            }
            Object primaryKeyValue = currentRow.getPrimaryKeyValue();
            if (null == primaryKeyValue) {
                return;
            }
            DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)primaryKeyValue, (String)"perm_userbizrole", (String)"bizrole_id, bizrole.number, user_id");
            if (null == dyn) {
                return;
            }
            switch (billFormId) {
                case "perm_busiroleuser_layout": {
                    if (!Objects.equals("bizrole_number", fieldName)) break;
                    String bizRoleId = dyn.getString("bizrole_id");
                    String bizRoleNumber = dyn.getString("bizrole.number");
                    this.showBusiRoleAssignUserOrUsrGrpPage(args, bizRoleId, bizRoleNumber, billFormId);
                    break;
                }
                case "perm_userbusirole_layout": {
                    String userId = dyn.getString("user_id");
                    this.showUserAssignBusiRolePage(args, userId);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warn("UserBusiRoleListPlugin.billListHyperLinkClick error. ", (Throwable)e);
        }
    }

    private void showUserAssignBusiRolePage(HyperLinkClickArgs args, String userId) {
        String assignPermFormName;
        HashMap<String, String> params = new HashMap<String, String>();
        Map customParamsFromFsp = this.getView().getFormShowParameter().getCustomParams();
        if (customParamsFromFsp.get("FormShowParam_dimension") == null) {
            params.put("FormShowParam_dimension", "DIM_ORG");
        }
        params.put("paramUserId", userId);
        Long userIdl = Long.valueOf(userId);
        PermCommonUtil.checkUserEnable((Long)userIdl, (String)ResManager.loadKDString((String)"\u8be5\u7528\u6237\u4f7f\u7528\u72b6\u6001\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u53ef\u64cd\u4f5c\u3002", (String)"UserGroupTreeListPlugin_46", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        PermCommonUtil.checkRobots((Long)userIdl, (String)ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u901a\u8fc7\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u8fdb\u884c\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        Long adminId = RequestContext.get().getCurrUserId();
        if (adminId.toString().equals(params.get("paramUserId"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserGroupTreeListPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = "perm_user_assignbizrole";
        FormShowParameter fsp = new FormShowParameter();
        String pageId = this.getView().getParentView().getPageId();
        String newPageId = pageId + "|" + formId + "|" + userId;
        fsp.setPageId(newPageId);
        IFormView iformView = this.getView().getViewNoPlugin(newPageId);
        if (iformView != null) {
            PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
            args.setCancel(true);
            return;
        }
        IFormView fv = this.getView().getView(newPageId);
        if (fv == null) {
            String opKey = "assignbizrole";
            StringBuilder sbErrorInfo = new StringBuilder();
            boolean require = MutexHelper.require((String)"bos_usergroup_user", (Object)userId, (String)opKey, (StringBuilder)sbErrorInfo);
            if (require) {
                IPageCache pageCache = this.getPageCache();
                pageCache.put("MUTEX_ENTITY_KEY", "bos_usergroup_user");
                pageCache.put("MUTEX_OPER_KEY", opKey);
                pageCache.put("MUTEX_OBJ_ID", userId);
            }
            if (!require) {
                this.getView().showMessage(sbErrorInfo.toString());
                fsp.setStatus(OperationStatus.VIEW);
            } else {
                fsp.setStatus(OperationStatus.EDIT);
            }
        }
        Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
        if (params != null) {
            params.putAll(originalCustParams);
            fsp.setCustomParams(params);
        }
        if (StringUtils.isNotEmpty((String)(assignPermFormName = (String)originalCustParams.get("formShowParam_formName_assignBizRole")))) {
            formId = assignPermFormName;
        }
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(fsp);
    }

    private void showBusiRoleAssignUserOrUsrGrpPage(HyperLinkClickArgs args, String bizRoleId, String roleNumber, String billFormId) {
        String formId = Objects.equals("perm_busiroleuser_layout", billFormId) ? "perm_bizroleassignuser" : "perm_bizroleassignusrgrp";
        String newPageId = bizRoleId + "-" + formId + "-" + this.getView().getParentView().getPageId();
        IFormView iformView = this.getView().getViewNoPlugin(newPageId);
        if (iformView != null) {
            PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
            args.setCancel(true);
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setPageId(newPageId);
        IFormView fv = this.getView().getView(newPageId);
        if (fv == null) {
            StringBuilder sbErrorInfo = new StringBuilder();
            String opkey = formId.equals("perm_bizroleassignuser") ? "donothing_bizroleassignuser" : "donothing_bizroleassignusrgrp";
            boolean require = MutexHelper.require((String)"perm_busirole", (Object)bizRoleId, (String)opkey, (StringBuilder)sbErrorInfo);
            IPageCache pageCache = this.getPageCache();
            String type = "BUSIROLE_MUTEXT_TYPE|" + pageCache.getPageId();
            HashMap<String, String> busiRoleMutexTypeMap = CacheMrg.getCache((String)type);
            if (kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Map)busiRoleMutexTypeMap)) {
                busiRoleMutexTypeMap = new HashMap<String, String>(8);
            }
            busiRoleMutexTypeMap.put(opkey, "perm_busirole|" + bizRoleId);
            CacheMrg.putCache((String)type, busiRoleMutexTypeMap);
            if (!require) {
                this.getView().showMessage(sbErrorInfo.toString());
                fsp.setStatus(OperationStatus.VIEW);
            } else {
                fsp.setStatus(OperationStatus.EDIT);
            }
        }
        fsp.setFormId(formId);
        if ("perm_bizroleassignusrgrp".equals(formId)) {
            fsp.setCaption(ResManager.loadKDString((String)"\u5206\u914d\u7528\u6237\u7ec4", (String)"BusiRoleListPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        fsp.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        fsp.getCustomParams().put("id", Long.valueOf(bizRoleId));
        fsp.getCustomParams().put("FromList", "true");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(fsp);
    }
}

