/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin.usergroup;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.model.UgRoleDim;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.plugin.MultiDimAssignPermPlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.model.perm.DimUserEdit;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class UsrGrpAssignRoleMultiPlugin
extends MultiDimAssignPermPlugin
implements TabSelectListener,
RowClickEventListener,
ItemClickListener {
    public static final String CLOSECALLBACK_ADDROLE = "closeCallBack_addRole";
    private static final String PARAM_USRGRP_ID = "usrgrpid";

    public void initialize() {
        this.initVariable("role");
        this.addListener();
        this.getPageCache().put("curFormIsUsrGrp", "true");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit usrGrpF7 = (BasedataEdit)this.getControl("usrgrp");
        usrGrpF7.addBeforeF7SelectListener(evt -> {
            if (this.ifDataChanged("callbckid_usrgrp")) {
                evt.setCancel(true);
            }
        });
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long usrGrpId = (Long)fsp.getCustomParam(PARAM_USRGRP_ID);
        if (usrGrpId != null && !usrGrpId.equals(0L)) {
            this.getModel().setValue("usrgrp", (Object)usrGrpId);
            this.getView().updateView("usrgrp");
            this.getView().updateView("usrgrpnum");
            this.getView().updateView("usrgrpstd");
            this.init();
        }
    }

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String curDimType;
        if ("true".equals(this.getPageCache().get("pgcache_skip"))) {
            this.getPageCache().remove("pgcache_skip");
            return;
        }
        Tab tab = (Tab)this.getCurControl("dimtab");
        String curCtrlType = tab.getCurrentTab();
        if (curCtrlType.equals(curDimType = (String)this.getModel().getValue("dimtype"))) {
            return;
        }
        super.tabSelected(tabSelectEvent);
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        if (isLeftDim) {
            this.loadLeftEntryData();
        } else {
            this.getModel().deleteEntryData("right_dim_entry");
            EntryGrid eg = (EntryGrid)this.getControl(this.LEFT_PROP_ENTRY);
            int[] selectRows = eg.getSelectRows();
            if (selectRows.length == 1) {
                int row = selectRows[0];
                DynamicObject roleObj = (DynamicObject)this.getModel().getValue(this.LEFT_PROP, row);
                String roleId = roleObj.getString("id");
                this.loadRightEntryData(roleId);
                this.getView().setVisible(Boolean.valueOf("bos_org".equals(curCtrlType)), new String[]{this.PROP_INCLUDESUBORG, "dim_includesuborg", this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude"});
            }
        }
    }

    private void loadLeftEntryData() {
        Tab tab = (Tab)this.getCurControl("dimtab");
        String curCtrlType = tab.getCurrentTab();
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        IDataModel dataModel = this.getModel();
        if (isLeftDim) {
            dataModel.deleteEntryData("left_dim_entry");
            dataModel.deleteEntryData(this.RIGHT_PROP_ENTRY);
            List<String> usrGrpAssignDims = this.getLeftEntryDataIds("role", curCtrlType);
            boolean singleOrg = PermFormCommonUtil.isSingleOrg(curCtrlType);
            if (singleOrg && CollectionUtils.isEmpty(usrGrpAssignDims)) {
                this.handleIfIsSingleOrg(dataModel, curCtrlType);
                return;
            }
            List<Long> dimList = usrGrpAssignDims.stream().map(Long::valueOf).collect(Collectors.toList());
            this.removeUnChargeOrg(curCtrlType, dimList);
            Map dimMap = IsoDimHelper.getDimDynMapByDs(dimList, (String)curCtrlType);
            dataModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("left_dimtype", new Object[0]);
            vs.addField("left_dimnum", new Object[0]);
            vs.addField("left_dimname", new Object[0]);
            HashSet<Long> dimSet = new HashSet<Long>(dimList);
            for (Long dimId : dimSet) {
                DynamicObject dimObj = (DynamicObject)dimMap.get(dimId);
                if (null == dimObj) continue;
                vs.addRow(new Object[]{curCtrlType, dimId, dimObj.getString("name")});
            }
            ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("left_dim_entry", vs);
            dataModel.endInit();
            this.getView().updateView("left_dim_entry");
            this.selFirstRowInLeftEg();
        } else {
            dataModel.deleteEntryData(this.LEFT_PROP_ENTRY);
            dataModel.deleteEntryData("right_dim_entry");
            List<String> usrGrpAssignRoles = this.getLeftEntryDataIds("role", null);
            dataModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(this.LEFT_PROP, new Object[0]);
            HashSet<String> usrGrpAssignRolesSet = new HashSet<String>(usrGrpAssignRoles);
            for (String roleId : usrGrpAssignRolesSet) {
                vs.addRow(new Object[]{roleId});
            }
            ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow(this.LEFT_PROP_ENTRY, vs);
            dataModel.endInit();
            this.getView().updateView(this.LEFT_PROP_ENTRY);
            EntryGrid leftEg = (EntryGrid)this.getCurControl("left_entrygrid");
            int entryCount = this.getModel().getEntryRowCount((String)this.getCurControl("left_entrygridkey"));
            if (entryCount > 0) {
                leftEg.selectRows(0);
                leftEg.entryRowClick(Integer.valueOf(0));
            } else {
                DynamicObject usrGrp = (DynamicObject)this.getModel().getValue("usrgrp");
                if (usrGrp == null) {
                    return;
                }
                Long usrGrpId = usrGrp.getLong("id");
                this.getPageCache().put("pgcache_skip", "true");
                this.initDimTab(usrGrpId, null);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        DynamicObject usrGrp = (DynamicObject)this.getModel().getValue("usrgrp");
        if (usrGrp == null) {
            return;
        }
        Long usrGrpId = usrGrp.getLong("id");
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        if (isLeftDim) {
            this.initDimTab(usrGrpId, null);
        } else {
            this.loadLeftEntryData();
        }
    }

    private void initDimTab(Long usrGrpId, String roleId) {
        List dimTypes;
        Tab tab = (Tab)this.getCurControl("dimtab");
        this.getModel().setValue("dimtype", null);
        this.delAllDimTabKeys();
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        String roleHasDimTabKeys = this.getPageCache().get(this.PGCACHE_PROPHASDIMTABKEYS + "_" + roleId);
        if (!isLeftDim && StringUtils.isNotEmpty((String)roleHasDimTabKeys)) {
            dimTypes = (List)SerializationUtils.fromJsonString((String)roleHasDimTabKeys, List.class);
        } else {
            String sql = "select distinct ugr.fdimtype from t_perm_usrgrprole ugr join t_perm_ctrltype ct on (ugr.fdimtype = ct.fbizobjectid and ct.fsystreefilter = '1')  where ugr.fusrgrpid = ?";
            Object[] params = new Object[]{usrGrpId};
            if (roleId != null) {
                sql = sql + " and ugr.froleid = ?";
                params = new Object[]{usrGrpId, roleId};
            }
            if ((dimTypes = (List)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, resultSet -> {
                ArrayList<String> result = new ArrayList<String>(10);
                while (resultSet.next()) {
                    result.add(resultSet.getString("fdimtype"));
                }
                return result;
            })).isEmpty() && roleId != null) {
                HashSet<String> roleIdSet = new HashSet<String>(1);
                roleIdSet.add(roleId);
                Map map = PermRoleHelper.getRoleDimTypeSetMap((Set)roleIdSet, (boolean)false, (boolean)true);
                Set dimTypeSet = (Set)map.get(roleId);
                if (dimTypeSet != null && !dimTypeSet.isEmpty()) {
                    dimTypeSet.remove("bos_objecttype");
                    dimTypes.addAll(dimTypeSet);
                } else {
                    dimTypes.add("bos_org");
                }
            }
        }
        if (!isLeftDim) {
            String jsonMap = this.getPageCache().get("pgcache_batchAddDataMap");
            if (!StringUtils.isEmpty((String)jsonMap)) {
                Map batchAddDataMap = (Map)SerializationUtils.fromJsonString((String)jsonMap, Map.class);
                assert (roleId != null);
                for (Map.Entry entry : batchAddDataMap.entrySet()) {
                    String key = (String)entry.getKey();
                    List roleBatchAddData = (List)entry.getValue();
                    if (!key.contains("role") || !key.contains(roleId) || roleBatchAddData == null) continue;
                    for (String batchAddData : roleBatchAddData) {
                        String batchAddDimType = batchAddData.split("\\$")[0];
                        if (dimTypes.contains(batchAddDimType)) continue;
                        dimTypes.add(batchAddDimType);
                    }
                }
            }
            this.getPageCache().put(this.PGCACHE_PROPHASDIMTABKEYS + "_" + roleId, SerializationUtils.toJsonString((Object)dimTypes));
            this.recordKeysWillBeDeleted(this.PGCACHE_PROPHASDIMTABKEYS + "_" + roleId);
        }
        ArrayList<String> allTabKeys = new ArrayList<String>(10);
        ArrayList<Map> items = new ArrayList<Map>(10);
        if (dimTypes.isEmpty()) {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey("bos_org");
            tabPageAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"UsrGrpAssignRoleMultiPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0])));
            items.add(tabPageAp.createControl());
            allTabKeys.add("bos_org");
        } else {
            DynamicObjectCollection dimObjCol = QueryServiceHelper.query((String)"perm_ctrltype", (String)"bizobjectid,name", (QFilter[])new QFilter[]{new QFilter("bizobjectid", "in", (Object)dimTypes)});
            for (DynamicObject dimObj : dimObjCol) {
                String number = dimObj.getString("bizobjectid");
                String name = dimObj.getString("name");
                TabPageAp tabPageAp = new TabPageAp();
                tabPageAp.setKey(number);
                tabPageAp.setName(new LocaleString(name));
                items.add(tabPageAp.createControl());
                allTabKeys.add(number);
            }
        }
        tab.addControls(items);
        this.getPageCache().put("pgcache_dimtabkeys", JSON.toJSONString(allTabKeys));
        int size = allTabKeys.size();
        if (size > 0) {
            String string = (String)allTabKeys.get(0);
            tab.selectTab(string);
            tab.activeTab(string);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("usrgrp".equals(name)) {
            this.init();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof EntryGrid) {
            EntryGrid eg = (EntryGrid)source;
            String key = eg.getKey();
            if (key.contains("right")) {
                return;
            }
            this.getModel().deleteEntryData((String)this.getCurControl("right_entrygridkey"));
            int[] rows = eg.getSelectRows();
            int length = rows.length;
            if (PermCommonUtil.isEnableValidateTime()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{this.PROP_STARTTIME, "dim_starttime", this.PROP_ENDTIME, "dim_endtime"});
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritem_right_dim_delete", this.BARITEM_RIGHT_PROP_DELETE});
            Tab tab = (Tab)this.getCurControl("dimtab");
            boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
            if (0 == length) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude"});
            } else if (1 == length) {
                int row = rows[0];
                DynamicObject selLeftObj = (DynamicObject)this.getModel().getValue((String)this.getCurControl("left_entrydatakey"), row);
                if (selLeftObj == null) {
                    return;
                }
                if (!isLeftDim) {
                    DynamicObject usrGrp = (DynamicObject)this.getModel().getValue("usrgrp");
                    if (usrGrp == null) {
                        return;
                    }
                    Long usrGrpId = usrGrp.getLong("id");
                    this.initDimTab(usrGrpId, selLeftObj.getString("id"));
                } else {
                    this.loadRightEntryData(selLeftObj.getLong("id") + "");
                    String curCtrlType = tab.getCurrentTab();
                    boolean isOrgDim = "bos_org".equals(curCtrlType);
                    this.getView().setVisible(Boolean.valueOf(isOrgDim), new String[]{this.PROP_INCLUDESUBORG, "dim_includesuborg", this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude"});
                }
            } else if (length > 1) {
                if (!isLeftDim) {
                    this.getModel().setValue("dimtype", null);
                    this.delAllDimTabKeys();
                    ArrayList<Map> items = new ArrayList<Map>(10);
                    TabPageAp tabPageAp = new TabPageAp();
                    tabPageAp.setKey("bos_org");
                    tabPageAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"UsrGrpAssignRoleMultiPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0])));
                    items.add(tabPageAp.createControl());
                    ArrayList<String> allTabKeys = new ArrayList<String>(1);
                    allTabKeys.add("bos_org");
                    this.getPageCache().put("pgcache_dimtabkeys", JSON.toJSONString(allTabKeys));
                    tab.addControls(items);
                    tab.selectTab("bos_org");
                    tab.activeTab("bos_org");
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.PROP_INCLUDESUBORG, "dim_includesuborg", this.PROP_ALL_INCLUDE, "dim_all_include", this.PROP_ALL_NOTINCLUDE, "dim_all_notinclude", "baritem_right_dim_delete", this.BARITEM_RIGHT_PROP_DELETE, this.PROP_STARTTIME, "dim_starttime", this.PROP_ENDTIME, "dim_endtime"});
            }
            boolean isSingleOrg = PermFormCommonUtil.isSingleOrg("bos_org");
            if (isSingleOrg) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.PROP_INCLUDESUBORG, this.PROP_ALL_INCLUDE, this.PROP_ALL_NOTINCLUDE});
            }
        }
    }

    private void loadRightEntryData(String leftEntryDataId) {
        Long dimId;
        boolean isLeftDim = Boolean.parseBoolean(this.getView().getPageCache().get("pgcache_isleftdim"));
        String curDimType = (String)this.getModel().getValue("dimtype");
        DynamicObject usrGrp = (DynamicObject)this.getModel().getValue("usrgrp");
        if (usrGrp == null) {
            return;
        }
        Long usrGrpId = usrGrp.getLong("id");
        Date defalueEndTime = DateUtil.toDate((String)"2999-12-31 23:59:59", (String)"yyyy-MM-dd HH:mm:ss");
        Set<String> batchAddDataSet = this.getAndRemoveBatchAddDataByLeftEntryId(Collections.singletonList(leftEntryDataId), true);
        List<DimUserEdit> dimUserEdits = this.getLoadedAndModifiedDataByLeftId(leftEntryDataId);
        boolean needToSearchDb = true;
        if (dimUserEdits.isEmpty()) {
            String delDimIds = this.getPageCache().get("pgcache_notLoadedButDel_LeftIds");
            if (StringUtils.isNotEmpty((String)delDimIds)) {
                String key;
                List delLeftIdsList = (List)SerializationUtils.fromJsonString(delDimIds, List.class);
                String string = key = isLeftDim ? curDimType + "$" + leftEntryDataId : "role$" + leftEntryDataId;
                if (delLeftIdsList.contains(key)) {
                    needToSearchDb = false;
                    this.recordLoadedAndModifiedDataToCache(leftEntryDataId, dimUserEdits);
                }
            }
            List permUsrGrpRoleList = null;
            if (needToSearchDb) {
                if (isLeftDim) {
                    HashSet<Long> dimIdList = new HashSet<Long>(1);
                    dimIdList.add(Long.valueOf(leftEntryDataId));
                    permUsrGrpRoleList = UserGroupHelper.getUsrGrpRoleList(null, null, Collections.singleton(usrGrpId), dimIdList, (String)curDimType);
                } else {
                    StringBuilder sql = new StringBuilder("select a.fdimtype, a.fincludesub, a.fdimid, a.fstarttime, a.fendtime,a.froleid,a.fusrgrpid ");
                    sql.append(" from t_perm_usrgrprole a");
                    sql.append(" inner join t_perm_role b on a.froleid = b.fid ");
                    sql.append(" where a.fusrgrpid = ?  and a.froleid = ? ");
                    Object[] params = new Object[]{usrGrpId, leftEntryDataId};
                    permUsrGrpRoleList = (List)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params, rs -> {
                        ArrayList<UgRoleDim> result = new ArrayList<UgRoleDim>(10);
                        while (rs.next()) {
                            UgRoleDim ugRoleDim = new UgRoleDim();
                            ugRoleDim.setRoleId(rs.getString("froleid"));
                            ugRoleDim.setDimType(rs.getString("fdimtype"));
                            ugRoleDim.setIncludeSub(rs.getString("fincludesub"));
                            ugRoleDim.setUsrGrpId(Long.valueOf(rs.getLong("fusrgrpid")));
                            ugRoleDim.setDimId(Long.valueOf(rs.getLong("fdimid")));
                            ugRoleDim.setStarttime((Date)rs.getDate("fstarttime"));
                            ugRoleDim.setEndtime((Date)rs.getDate("fendtime"));
                            result.add(ugRoleDim);
                        }
                        return result;
                    });
                }
            }
            if ((permUsrGrpRoleList == null || permUsrGrpRoleList.isEmpty()) && batchAddDataSet.isEmpty()) {
                this.recordLoadedAndModifiedDataToCache(leftEntryDataId, dimUserEdits);
                return;
            }
            if (permUsrGrpRoleList != null) {
                for (UgRoleDim ugRoleDim : permUsrGrpRoleList) {
                    DimUserEdit dimUserEdit = new DimUserEdit();
                    dimId = ugRoleDim.getDimId();
                    dimUserEdit.setDimId(dimId);
                    String roleId = ugRoleDim.getRoleId();
                    dimUserEdit.setRoleId(roleId);
                    dimUserEdit.setIncludeSub(Boolean.valueOf("1".equals(ugRoleDim.getIncludeSub())));
                    dimUserEdit.setStartTime(ugRoleDim.getStarttime());
                    dimUserEdit.setEndTime(ugRoleDim.getEndtime());
                    dimUserEdit.setDataStatus(DimUserEdit.DataStatus.NONE);
                    dimUserEdit.setDimType(ugRoleDim.getDimType());
                    dimUserEdit.setUsrGrpId(usrGrpId);
                    dimUserEdits.add(dimUserEdit);
                    if (isLeftDim) {
                        batchAddDataSet.remove("role$" + roleId);
                        continue;
                    }
                    batchAddDataSet.remove(curDimType + "$" + dimId);
                }
            }
        } else if (!batchAddDataSet.isEmpty()) {
            for (DimUserEdit dimUserEdit : dimUserEdits) {
                String loadedData;
                DimUserEdit.DataStatus dataStatus = dimUserEdit.getDataStatus();
                if (isLeftDim) {
                    String roleId = dimUserEdit.getRoleId();
                    loadedData = "role$" + roleId;
                } else {
                    String dimType = dimUserEdit.getDimType();
                    dimId = dimUserEdit.getDimId();
                    loadedData = dimType + "$" + dimId;
                }
                if (!batchAddDataSet.remove(loadedData) || !DimUserEdit.DataStatus.DELETE.equals((Object)dataStatus)) continue;
                dimUserEdit.setDataStatus(DimUserEdit.DataStatus.UPDATE);
                dimUserEdit.setIncludeSub(Boolean.valueOf(false));
                dimUserEdit.setStartTime(null);
                dimUserEdit.setEndTime(defalueEndTime);
            }
        }
        for (String addData : batchAddDataSet) {
            DimUserEdit dimUserEdit = new DimUserEdit();
            String[] split = addData.split("\\$");
            if (isLeftDim) {
                dimUserEdit.setDimId(Long.valueOf(leftEntryDataId));
                dimUserEdit.setRoleId(split[1]);
                dimUserEdit.setDimType(curDimType);
            } else {
                dimUserEdit.setDimId(Long.valueOf(split[1]));
                dimUserEdit.setRoleId(leftEntryDataId);
                dimUserEdit.setDimType(split[0]);
            }
            dimUserEdit.setDataStatus(DimUserEdit.DataStatus.INSERT);
            dimUserEdit.setEndTime(defalueEndTime);
            dimUserEdits.add(dimUserEdit);
        }
        this.recordLoadedAndModifiedDataToCache(leftEntryDataId, dimUserEdits);
        if (dimUserEdits.isEmpty()) {
            return;
        }
        this.getModel().beginInit();
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        HashSet<Object> tempSet = new HashSet<Object>(dimUserEdits.size());
        if (isLeftDim) {
            vs.addField(this.RIGHT_PROP, new Object[0]);
            vs.addField(this.PROP_INCLUDESUBORG, new Object[0]);
            if (enableValidateTime) {
                vs.addField(this.PROP_STARTTIME, new Object[0]);
                vs.addField(this.PROP_ENDTIME, new Object[0]);
            }
            for (DimUserEdit dimUserEdit : dimUserEdits) {
                String roleId;
                DimUserEdit.DataStatus dataStatus = dimUserEdit.getDataStatus();
                String dimType = dimUserEdit.getDimType();
                if (dataStatus.equals((Object)DimUserEdit.DataStatus.DELETE) || !dimType.equals(curDimType) || !tempSet.add(roleId = dimUserEdit.getRoleId())) continue;
                Boolean includeSub = dimUserEdit.getIncludeSub();
                if (enableValidateTime) {
                    Date startTime = dimUserEdit.getStartTime();
                    Date endTime = dimUserEdit.getEndTime();
                    vs.addRow(new Object[]{roleId, includeSub, startTime, endTime});
                    continue;
                }
                vs.addRow(new Object[]{roleId, includeSub});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(this.RIGHT_PROP_ENTRY, vs);
            this.getModel().endInit();
            this.getView().updateView(this.RIGHT_PROP_ENTRY);
        } else {
            vs.addField("right_dimtype", new Object[0]);
            vs.addField("right_dimnum", new Object[0]);
            vs.addField("right_dimname", new Object[0]);
            vs.addField("dim_includesuborg", new Object[0]);
            if (enableValidateTime) {
                vs.addField("dim_starttime", new Object[0]);
                vs.addField("dim_endtime", new Object[0]);
            }
            List<Long> hasPermOrgs = this.getAdminChargeOrgAndBizUnit(curDimType);
            for (DimUserEdit dimUserEdit : dimUserEdits) {
                Long dimId2;
                DimUserEdit.DataStatus dataStatus = dimUserEdit.getDataStatus();
                String dimType = dimUserEdit.getDimType();
                if (dataStatus.equals((Object)DimUserEdit.DataStatus.DELETE) || !dimType.equals(curDimType) || !tempSet.add(dimId2 = dimUserEdit.getDimId()) || hasPermOrgs != null && !hasPermOrgs.contains(dimId2)) continue;
                ArrayList<Long> dimIdList = new ArrayList<Long>(1);
                dimIdList.add(dimId2);
                Map dimMap = IsoDimHelper.getDimMap(dimIdList, (String)curDimType);
                Dim dim = (Dim)dimMap.get(dimId2);
                if (dim == null) continue;
                Boolean includeSub = dimUserEdit.getIncludeSub();
                if (enableValidateTime) {
                    Date startTime = dimUserEdit.getStartTime();
                    Date endTime = dimUserEdit.getEndTime();
                    vs.addRow(new Object[]{curDimType, dimId2, dim.getDimName(), includeSub, startTime, endTime});
                    continue;
                }
                vs.addRow(new Object[]{curDimType, dimId2, dim.getDimName(), includeSub});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("right_dim_entry", vs);
            this.getModel().endInit();
            this.getView().updateView("right_dim_entry");
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        Set<String> curData;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ((this.BARITEM_LEFT_PROP_ADD.equals(itemKey) || this.BARITEM_RIGHT_PROP_ADD.equals(itemKey)) && (curData = this.validateOrGetCurData()) != null) {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"perm_role", (boolean)true, (int)0);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_ADDROLE));
            List qFilters = lsp.getListFilterParameter().getQFilters();
            QFilter qFilter = new QFilter("id", "not in", curData).and("enable", "=", (Object)Boolean.TRUE);
            qFilters.add(qFilter);
            String roleQFilterCache = this.getPageCache().get("CustomQFilter_RoleIds");
            if (StringUtils.isNotEmpty((String)roleQFilterCache)) {
                QFilter roleQFilter = QFilter.fromSerializedString((String)roleQFilterCache);
                qFilters.add(roleQFilter);
            } else {
                List strRoleIdList;
                String customRoleIds = this.getPageCache().get("CustomFilter_RoleIds");
                if (StringUtils.isNotEmpty((String)customRoleIds) && !CollectionUtils.isEmpty((Collection)(strRoleIdList = (List)SerializationUtils.fromJsonString((String)customRoleIds, List.class)))) {
                    qFilters.add(new QFilter("id", "in", (Object)strRoleIdList));
                }
            }
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (CLOSECALLBACK_ADDROLE.equals(actionId) || "closeCallBack_addDim".equals(actionId)) {
            if (!(returnData instanceof ListSelectedRowCollection)) {
                return;
            }
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)returnData;
            int size = lsrc.size();
            LinkedHashSet<String> selIdSet = new LinkedHashSet<String>(size);
            for (ListSelectedRow listSelectedRow : lsrc) {
                Object pkValue = listSelectedRow.getPrimaryKeyValue();
                selIdSet.add(pkValue + "");
            }
            this.getPageCache().put("pgcache_dataChanged", "true");
            if (CLOSECALLBACK_ADDROLE.equals(actionId)) {
                this.addPropsToView(selIdSet);
            } else {
                this.addDimsToView(selIdSet);
            }
        } else if (Objects.equals(actionId, "taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    @Override
    protected String getJobName() {
        return ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u5206\u914d\u901a\u7528\u89d2\u8272", (String)"UsrGrpAssignRoleMultiPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected LocaleString getJobNameLocaleString() {
        return ResManager.getLocaleString((String)"\u7528\u6237\u7ec4\u5206\u914d\u901a\u7528\u89d2\u8272", (String)"UsrGrpAssignRoleMultiPlugin_2", (String)"bos-permission-formplugin");
    }

    @Override
    protected Map<String, Object> getTaskParameters() {
        DynamicObject usrGrp = (DynamicObject)this.getModel().getValue("usrgrp");
        if (usrGrp == null) {
            return null;
        }
        Map<String, Object> params = super.getTaskParameters();
        String usrGrpId = usrGrp.getPkValue() + "";
        String usrGrpNumber = usrGrp.getString("number");
        String usrGrpName = usrGrp.getString("name");
        params.put("usrGrpId", usrGrpId);
        params.put("usrGrpNumber", usrGrpNumber);
        params.put("usrGrpName", usrGrpName);
        return params;
    }

    @Override
    protected String getTaskClassName() {
        return "kd.bos.permission.formplugin.task.UsrGrpAssignRoleMultiTask";
    }

    @Override
    protected void addSavePermLog() {
        String opName = this.getJobName();
        IDataModel dataModel = this.getModel();
        DynamicObject usrGrp = (DynamicObject)dataModel.getValue("usrgrp");
        String usrGrpId = usrGrp.getPkValue() + "";
        String usrGrpName = usrGrp.getString("name");
        String usrGrpNum = usrGrp.getString("number");
        String formNum = dataModel.getDataEntityType().getName();
        String appId = AppHelper.getCurAppId((String)"bos_usrgrp", (String)this.getView().getFormShowParameter().getAppId());
        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u7528\u6237\u7ec4\u5206\u914d\u901a\u7528\u89d2\u8272", "UsrGrpAssignRoleMultiPlugin_2", "bos-permission-formplugin");
        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5bf9\u7528\u6237\u7ec4\uff1a%1$s (id = %2$s) %3$s\uff0c\u64cd\u4f5c\u6210\u529f\u3002", "UsrGrpAssignRoleMultiPlugin_5", "bos-permission-formplugin");
        String[] opDescParam = new String[]{usrGrpName, usrGrpId, opName};
        String oldOpDescription = String.format(ResManager.loadKDString((String)"\u5bf9\u7528\u6237\u7ec4\uff1a%1$s (id = %2$s) %3$s\uff0c\u64cd\u4f5c\u6210\u529f\u3002", (String)"UsrGrpAssignRoleMultiPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]), usrGrpName, usrGrpId, opName);
        PermCommonUtil.addLog(null, null, (String)formNum, (String)usrGrpNum, (String)"1", (String)"save", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)appId);
    }
}

