/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.exception.AlgoExceedAllowMaxRows4SortException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.PermQueryReportUtil;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class BizRolePermissionListDataRpt
extends AbstractReportListDataPlugin {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final String[] QUERY_FIELDS = new String[]{"number", "name", "dimtypenum", "dimtypename", "includesubdim", "cloud", "app", "entity", "funcpermitem", "permstatus", "ctrlfield", "ctrlfieldtype", "fieldscheme", "ctrlmode", "propkey", "datarulepermitem", "datarulename", "datarule", "permtype"};
    private static final String PERMTYPE_FROMCOMROLE = "1";
    private static final String PERMTYPE_FROMBIZROLE = "2";
    private static final String PERMTYPE_FROMBAN = "3";
    private static final String HASRIGHT_HAS = "1";
    private static final String HASRIGHT_BAN = "2";
    private static final int MAX_ROWS_4SORT = 1000000;
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"BizRolePermissionListDataRpt", (int)1);

    private String hasRight() {
        return ResManager.loadKDString((String)"\u6709\u6743", (String)"BizRolePermissionListDataRpt_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String banRight() {
        return ResManager.loadKDString((String)"\u7981\u7528", (String)"BizRolePermissionListDataRpt_1", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String fromComRole() {
        return ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272", (String)"BizRolePermissionListDataRpt_2", (String)"bos-permission-formplugin", (Object[])new Object[0]) + "\u2014\u2014";
    }

    private String fromBizRole() {
        return ResManager.loadKDString((String)"\u8865\u5145\u6743\u9650", (String)"BizRolePermissionListDataRpt_3", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String fromBan() {
        return ResManager.loadKDString((String)"\u7981\u7528\u6743\u9650", (String)"BizRolePermissionListDataRpt_4", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String yes() {
        return ResManager.loadKDString((String)"\u662f", (String)"BizRolePermissionListDataRpt_5", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String no() {
        return ResManager.loadKDString((String)"\u5426", (String)"BizRolePermissionListDataRpt_6", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        HashMap<String, String> fieldNumMap = new HashMap<String, String>(10);
        PermQueryReportUtil.loadFieldNumMap(fieldNumMap, "bizrole_perm_report");
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DynamicObjectCollection bizRoles = filterInfo.getDynamicObjectCollection("selectbizrole");
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection((String)fieldNumMap.get("orgfilter"));
        Long dim = filterInfo.getLong((String)fieldNumMap.get("dimfilter"));
        DynamicObjectCollection objectTypes = filterInfo.getDynamicObjectCollection((String)fieldNumMap.get("entityfilter"));
        DynamicObjectCollection apps = filterInfo.getDynamicObjectCollection((String)fieldNumMap.get("appfilter"));
        DynamicObjectCollection perms = filterInfo.getDynamicObjectCollection((String)fieldNumMap.get("permitemfilter"));
        DynamicObjectCollection clouds = filterInfo.getDynamicObjectCollection((String)fieldNumMap.get("cloudfilter"));
        String selectDimType = filterInfo.getString((String)fieldNumMap.get("selectdimtype"));
        if (StringUtils.isEmpty((String)selectDimType)) {
            selectDimType = "bos_org";
        }
        String bizRoleFilter = PermQueryReportUtil.idListToStr(bizRoles);
        String orgFilter = PermQueryReportUtil.idListToStr(orgs);
        String entityFilter = PermQueryReportUtil.getFilterEntityNumsStr(objectTypes);
        String appFilter = PermQueryReportUtil.getFilterAppIdsStr(apps);
        String permFilter = PermQueryReportUtil.idListToStr(perms);
        String cloudFilter = PermQueryReportUtil.idListToStr(clouds);
        appFilter = PermQueryReportUtil.updateAppFilterIfOnlyCloud(cloudFilter, appFilter);
        String localeName = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        Object[] params = new Object[]{localeName};
        sql.setLength(0);
        sql.append("select r.fid as roleid,").append("'").append("1").append("'").append(" as permtype, ").append("case when rl.fname is null or rl.fname = '' or rl.fname = ' ' ").append("then r.fname else rl.fname end as permtype1, ").append("bc.fid as bizroleid ").append("from t_perm_role r ").append("left join t_perm_role_l rl on (r.fid=rl.fid and rl.flocaleid = ?) ").append("join t_perm_bizrolecomrole bc on bc.froleid = r.fid ").append("where r.fenable = '1' ");
        PermQueryReportUtil.appendFilters(sql, bizRoleFilter, "bc", "fid");
        DataSet bizroleComroleDs = DB.queryDataSet((String)(this.algoKey + "_bizroleComroleDs"), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params);
        bizroleComroleDs = this.procText(bizroleComroleDs);
        HashSet<String> allComRoleIdSet = new HashSet<String>(10);
        HashSet<String> allBizRoleIdSet = new HashSet<String>(10);
        try (DataSet bizroleComroleDsCopy = bizroleComroleDs.copy();){
            for (Row row : bizroleComroleDsCopy) {
                allComRoleIdSet.add(row.getString("roleid"));
                allBizRoleIdSet.add(row.getString("bizroleid"));
            }
        }
        DataSet bizRoleComRolePermDs = null;
        Future future = null;
        if (!allComRoleIdSet.isEmpty()) {
            DataSet rolePermDs = PermQueryReportUtil.getRolePermDS(BizRolePermissionListDataRpt.idSetToStr(allComRoleIdSet), appFilter, entityFilter, permFilter);
            rolePermDs = rolePermDs.addField("'1'", "permstatus");
            bizRoleComRolePermDs = rolePermDs.join(bizroleComroleDs).on("roleid", "roleid").select(new String[]{"bizroleid", "appid", "entity", "funcpermitem", "permstatus", "ctrlfield", "ctrlfieldtype", "fieldscheme", "ctrlmode", "propkey", "datarulepermitem", "datarulename", "datarule", "permtype"}).finish();
            DataSet finalBizRoleComRolePermDs = bizRoleComRolePermDs.copy();
            future = pool.submit(() -> {
                int count = 0;
                for (Row row : finalBizRoleComRolePermDs) {
                    if (++count <= 1000000) continue;
                    return true;
                }
                return false;
            });
        }
        if ("('')".equals(bizRoleFilter)) {
            bizRoleFilter = BizRolePermissionListDataRpt.idSetToStr(allBizRoleIdSet);
        }
        sql.setLength(0);
        sql.append("select bo.fid as bizroleid,bo.forgid as dimid, bo.fisincludesuborg as includesubdim ").append("from t_perm_bizroleorg bo ").append("where bo.fdimtype = ? ");
        PermQueryReportUtil.appendFilters(sql, bizRoleFilter, "bo", "fid");
        PermQueryReportUtil.appendFilters(sql, selectDimType, orgFilter, dim, "bo", "forgid");
        params = new Object[]{selectDimType};
        DataSet bizRoleOrgDs = DB.queryDataSet((String)this.algoKey, (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params);
        if (bizRoleOrgDs.isEmpty()) {
            return DB.queryDataSet((String)"ljsj", (DBRoute)DBRoute.meta, (String)"select fid from t_meta_bizcloud where 1!=1");
        }
        if ("('')".equals(orgFilter)) {
            HashSet<String> allDimIdSet = new HashSet<String>(10);
            for (Row row : bizRoleOrgDs.copy()) {
                allDimIdSet.add(row.getString("dimid"));
            }
            orgFilter = BizRolePermissionListDataRpt.idSetToStr(allDimIdSet);
        }
        sql.setLength(0);
        sql.append("select bp.fid as bizroleid,bp.fbizappid as appid,bp.fentitytypeid as entity,bp.fpermitemid as funcpermitem, ").append("'1' as permstatus, '' as ctrlfield,'' as ctrlfieldtype,'' as fieldscheme,'' as ctrlmode,'' as propkey,'' as datarulepermitem,'' as datarulename,'' as datarule, ").append("'").append("2").append("'").append(" as permtype ").append("from t_perm_bizroleperm bp ").append("where 1=1 ");
        PermQueryReportUtil.appendFilters(sql, bizRoleFilter, "bp", "fid");
        PermQueryReportUtil.appendFilters(sql, entityFilter, "bp", "fentitytypeid");
        PermQueryReportUtil.appendFilters(sql, appFilter, "bp", "fbizappid");
        PermQueryReportUtil.appendFilters(sql, permFilter, "bp", "fpermitemid");
        DataSet bizRolePermDs = DB.queryDataSet((String)this.algoKey, (DBRoute)DBRoute.permission, (String)sql.toString());
        sql.setLength(0);
        sql.append("select bdp.fid as bizroleid, bdp.fbizappid as appid, bdp.fentitytypeid as entity, bdp.fpermitemid as funcpermitem, ").append("'2' as permstatus, '' as ctrlfield, '' as ctrlfieldtype, '' as fieldscheme, '' as ctrlmode, '' as propkey, '' as datarulepermitem, '' as datarulename, '' as datarule, ").append("'").append(PERMTYPE_FROMBAN).append("'").append(" as permtype ").append("from t_perm_bizroledisperm bdp ").append("where 1=1 ");
        PermQueryReportUtil.appendFilters(sql, bizRoleFilter, "bdp", "fid");
        PermQueryReportUtil.appendFilters(sql, entityFilter, "bdp", "fentitytypeid");
        PermQueryReportUtil.appendFilters(sql, appFilter, "bdp", "fbizappid");
        PermQueryReportUtil.appendFilters(sql, permFilter, "bdp", "fpermitemid");
        DataSet bizRoleDisPermDs = DB.queryDataSet((String)this.algoKey, (DBRoute)DBRoute.permission, (String)sql.toString());
        DataSet result = bizRoleComRolePermDs != null ? bizRoleComRolePermDs.union(new DataSet[]{bizRolePermDs, bizRoleDisPermDs}) : bizRolePermDs.union(bizRoleDisPermDs);
        bizRolePermDs.close();
        sql.setLength(0);
        sql.append("select b.fid as bizroleid, b.fnumber as number, ").append("case when bl.fname is null or bl.fname = '' or bl.fname = ' ' ").append(" then b.fname else bl.fname end as name ").append("from t_perm_bizrole b ").append("left join t_perm_bizrole_l bl on (b.fid=bl.fid and bl.flocaleid = ?) ").append("where 1=1 ");
        PermQueryReportUtil.appendFilters(sql, bizRoleFilter, "b", "fid");
        params = new Object[]{localeName};
        DataSet bizroleDs = DB.queryDataSet((String)(this.algoKey + "_bizroleFDS"), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params);
        result = result.join(bizroleDs).on("bizroleid", "bizroleid").select(new String[]{"bizroleid", "number", "name", "appid", "entity", "funcpermitem", "permstatus", "ctrlfield", "ctrlfieldtype", "fieldscheme", "ctrlmode", "propkey", "datarulepermitem", "datarulename", "datarule", "permtype"}).finish();
        DataSet cloudAppRelationDs = PermQueryReportUtil.getCloudAndAppDs(appFilter, cloudFilter, this.algoKey);
        if (cloudAppRelationDs.isEmpty()) {
            return DB.queryDataSet((String)"ljsj", (DBRoute)DBRoute.meta, (String)"select fid from t_meta_bizcloud where 1!=1");
        }
        result = result.join(cloudAppRelationDs).on("appid", "appid").select(new String[]{"bizroleid", "number", "name", "cloud", "app", "entity", "funcpermitem", "permstatus", "ctrlfield", "ctrlfieldtype", "fieldscheme", "ctrlmode", "propkey", "datarulepermitem", "datarulename", "datarule", "permtype"}).finish();
        cloudAppRelationDs.close();
        DataSet dimInfoDs = PermQueryReportUtil.getDimInfoDs(selectDimType, orgFilter, dim, this.algoKey);
        if (future != null && ((Boolean)future.get()).booleanValue()) {
            throw new AlgoExceedAllowMaxRows4SortException();
        }
        result = result.join(bizRoleOrgDs).on("bizroleid", "bizroleid").select(new String[]{"number", "name", "dimid", "includesubdim", "cloud", "app", "entity", "funcpermitem", "permstatus", "ctrlfield", "ctrlfieldtype", "fieldscheme", "ctrlmode", "propkey", "datarulepermitem", "datarulename", "datarule", "permtype"}).finish();
        result = result.join(dimInfoDs).on("dimid", "dimid").select(QUERY_FIELDS).finish();
        dimInfoDs.close();
        DataSet selDimTypeEntity = PermQueryReportUtil.getSelDimTypeEntity(selectDimType, entityFilter);
        result = result.join(selDimTypeEntity).on("entity", "entity").select(QUERY_FIELDS).finish();
        selDimTypeEntity.close();
        result = result.addField("'" + PermCommonUtil.getDimTypeName((String)selectDimType) + "'", "dimtype");
        bizRoleOrgDs.close();
        DataSet finalDS = PermQueryReportUtil.orderByAndFilterResult(reportQueryParam, result, new String[]{"number", "dimtypenum", "entity"});
        finalDS = this.procText2(finalDS);
        return finalDS;
    }

    public static String idSetToStr(Set<String> set) {
        if (set == null || set.isEmpty()) {
            return "('')";
        }
        StringBuilder sb = new StringBuilder("(");
        for (String id : set) {
            sb.append('\'').append(id).append('\'').append(',');
        }
        sb.deleteCharAt(sb.length() - 1).append(')');
        return sb.toString();
    }

    private DataSet procText(DataSet ds) {
        if (ds == null) {
            return null;
        }
        DataSet finalDS = null;
        Algo algo = Algo.create((String)"BizRolePermissionListDataRpt.procText");
        RowMeta rowMeta = ds.getRowMeta();
        RowMeta newRowMeta = new RowMeta(new Field[]{rowMeta.getField("roleid"), rowMeta.getField("permtype"), rowMeta.getField("bizroleid")});
        DataSetBuilder builder = algo.createDataSetBuilder(newRowMeta);
        String fromComRoleStr = this.fromComRole();
        while (ds.hasNext()) {
            Row row = ds.next();
            String permtypeStr = row.getString("permtype");
            String permtype1Str = row.getString("permtype1");
            if ("1".equals(permtypeStr)) {
                String roleName = permtype1Str;
                permtypeStr = fromComRoleStr + "\u201c" + roleName + "\u201d";
            }
            builder.append(new Object[]{row.get("roleid"), permtypeStr, row.get("bizroleid")});
        }
        ds.close();
        finalDS = builder.build();
        return finalDS;
    }

    private DataSet procText2(DataSet ds) {
        if (ds == null) {
            return null;
        }
        DataSet finalDS = null;
        Algo algo = Algo.create((String)"BizRolePermissionListDataRpt.procText2");
        RowMeta rowMeta = ds.getRowMeta();
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        String hasRightStr = this.hasRight();
        String banRightStr = this.banRight();
        String fromBizRoleStr = this.fromBizRole();
        String fromBanStr = this.fromBan();
        String yesStr = this.yes();
        String noStr = this.no();
        while (ds.hasNext()) {
            Row row = ds.next();
            String includeSubDimStr = row.getString("includesubdim");
            includeSubDimStr = "1".equals(includeSubDimStr) ? yesStr : noStr;
            String permtypeStr = row.getString("permtype");
            if ("2".equals(permtypeStr)) {
                permtypeStr = fromBizRoleStr;
            } else if (PERMTYPE_FROMBAN.equals(permtypeStr)) {
                permtypeStr = fromBanStr;
            }
            String permstatusStr = row.getString("permstatus");
            if ("1".equals(permstatusStr)) {
                permstatusStr = hasRightStr;
            } else if ("2".equals(permstatusStr)) {
                permstatusStr = banRightStr;
            }
            builder.append(new Object[]{row.get("number"), row.get("name"), row.get("dimtypenum"), row.get("dimtypename"), includeSubDimStr, row.get("cloud"), row.get("app"), row.get("entity"), row.get("funcpermitem"), permstatusStr, row.get("ctrlfield"), row.get("ctrlfieldtype"), row.get("fieldscheme"), row.get("ctrlmode"), row.get("propkey"), row.get("datarulepermitem"), row.get("datarulename"), row.get("datarule"), permtypeStr, row.get("dimtype")});
        }
        ds.close();
        finalDS = builder.build();
        return finalDS;
    }
}

