/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.OperationHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.PermQueryReportUtil;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class OperationRuleListDataRpt
extends AbstractReportListDataPlugin {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"OperationRuleListDataRpt", (int)2);
    private static Log logger = LogFactory.getLog(OperationRuleListDataRpt.class);

    private String yes() {
        return ResManager.loadKDString((String)"\u662f", (String)"OperationRuleListDataRpt_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String no() {
        return ResManager.loadKDString((String)"\u5426", (String)"OperationRuleListDataRpt_1", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    public DataSet query(ReportQueryParam quertParam, Object obj) throws Throwable {
        FilterInfo filterInfo = quertParam.getFilter();
        String cloudFilter = PermQueryReportUtil.idListToStr(filterInfo.getDynamicObjectCollection("cloudfilter"));
        String appFilter = PermQueryReportUtil.getFilterAppIdsStr(filterInfo.getDynamicObjectCollection("appfilter"));
        String entityFilter = PermQueryReportUtil.getFilterEntityNumsStr(filterInfo.getDynamicObjectCollection("entityfilter"));
        String enableStatus = filterInfo.getString("enablestatus");
        DataSet cloudAppEntityRelationDS = PermQueryReportUtil.getCloudAndAppDs(appFilter = PermQueryReportUtil.updateAppFilterIfOnlyCloud(cloudFilter, appFilter), cloudFilter, this.algoKey);
        if (cloudAppEntityRelationDS.isEmpty()) {
            return DB.queryDataSet((String)"ljsj", (DBRoute)DBRoute.meta, (String)"select fid from t_meta_bizcloud where 1!=1");
        }
        DataSet appEntityDs = this.getAppEntityDs(appFilter, entityFilter);
        HashSet<String> entitySet = new HashSet<String>(10);
        for (Row row : appEntityDs.copy()) {
            entitySet.add(row.getString("entity"));
        }
        if (entitySet.isEmpty()) {
            return DB.queryDataSet((String)"ljsj", (DBRoute)DBRoute.meta, (String)"select fid from t_meta_bizcloud where 1!=1");
        }
        Future entityOpInfoMapFuture = pool.submit(() -> OperationRuleListDataRpt.getEntityOpInfoMap(entitySet));
        Future entityFieldKeysMapFuture = pool.submit(() -> OperationRuleListDataRpt.getEntityFieldKeysMap(entitySet));
        String localeName = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select opo.fbizappid appid, opo.fentitytypeid entity, opo.fid opobjid, ").append("case when opl.fname is null or opl.fname = '' or opl.fname = ' ' ").append("then op.fname else opl.fname end as oprulename, ").append("op.foperationkey operationkey, ").append("opo.fobjenabled as enable, ").append("op.frule oprule, op.fispreset as ispreset, ").append("op.fispublic as ispublic ").append("from t_perm_operationruleobj opo ").append("join t_perm_operationrule op on (opo.foperationruleid = op.fid) ").append("left join t_perm_operationrule_l opl on (op.fid = opl.fid and opl.flocaleid = ?) ").append("where 1=1 ");
        if ("1".equals(enableStatus)) {
            sql.append(" and opo.fobjenabled = '1' ");
        } else if ("2".equals(enableStatus)) {
            sql.append(" and opo.fobjenabled = '0' ");
        }
        PermQueryReportUtil.appendFilters(sql, appFilter, "opo", "fbizappid");
        PermQueryReportUtil.appendFilters(sql, entityFilter, "opo", "fentitytypeid");
        DataSet opRuleDs = DB.queryDataSet((String)(this.algoKey + "_opRuleDs"), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{localeName});
        if (!"1".equals(enableStatus)) {
            sql.setLength(0);
            sql.append("select op.fbizappid appid,op.fentitytypeid entity,' ' as opobjid, ").append("case when opl.fname is null or opl.fname = '' or opl.fname = ' ' ").append("then op.fname else opl.fname end as oprulename, ").append("op.foperationkey operationkey, '0' as enable,").append("op.frule oprule, op.fispreset as ispreset, ").append("op.fispublic as ispublic ").append("from t_perm_operationrule op ").append("left join t_perm_operationrule_l opl on (op.fid = opl.fid and opl.flocaleid = ?) ");
            StringBuilder tempSql = new StringBuilder(sql).append("where op.fid not in (select foperationruleid from t_perm_operationruleobj) ");
            PermQueryReportUtil.appendFilters(tempSql, appFilter, "op", "fbizappid");
            PermQueryReportUtil.appendFilters(tempSql, entityFilter, "op", "fentitytypeid");
            DataSet neverEnabledOpRuleDs = DB.queryDataSet((String)(this.algoKey + "_neverEnabledOpRuleDs"), (DBRoute)DBRoute.permission, (String)tempSql.toString(), (Object[])new Object[]{localeName});
            opRuleDs = opRuleDs.union(neverEnabledOpRuleDs);
            sql.append("where op.fispublic = '1' and op.fid not in (select opo.foperationruleid from t_perm_operationruleobj opo where 1=1 ");
            PermQueryReportUtil.appendFilters(sql, appFilter, "opo", "fbizappid");
            PermQueryReportUtil.appendFilters(sql, entityFilter, "opo", "fentitytypeid");
            sql.append(")");
            DataSet publicOpRuleDs = DB.queryDataSet((String)(this.algoKey + "_publicOpRuleDs"), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{localeName});
            publicOpRuleDs = appEntityDs.join(publicOpRuleDs, JoinType.CROSS).on("entity", "entity").select(new String[]{"appid", "entity"}, new String[]{"opobjid", "oprulename", "operationkey", "enable", "oprule", "ispreset", "ispublic"}).finish();
            opRuleDs = opRuleDs.union(publicOpRuleDs);
        }
        if (opRuleDs.isEmpty()) {
            return DB.queryDataSet((String)"ljsj", (DBRoute)DBRoute.meta, (String)"select fid from t_meta_bizcloud where 1!=1");
        }
        opRuleDs = opRuleDs.distinct();
        Algo algo = Algo.create((String)"OperationRuleListDataRpt.opRuleDs");
        ArrayList<Field> fields = new ArrayList<Field>(10);
        fields.add(new Field("appid", (DataType)DataType.StringType));
        fields.add(new Field("entity", (DataType)DataType.StringType));
        fields.add(new Field("opobjid", (DataType)DataType.StringType));
        fields.add(new Field("oprulename", (DataType)DataType.StringType));
        fields.add(new Field("operation", (DataType)DataType.StringType));
        fields.add(new Field("operationkey", (DataType)DataType.StringType));
        fields.add(new Field("enable", (DataType)DataType.StringType));
        fields.add(new Field("oprule", (DataType)DataType.StringType));
        fields.add(new Field("ispreset", (DataType)DataType.StringType));
        fields.add(new Field("ispublic", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(fields.toArray(new Field[0]));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        Map entityOpInfoMap = (Map)entityOpInfoMapFuture.get();
        Map entityFieldKeysMap = (Map)entityFieldKeysMapFuture.get();
        String yesStr = this.yes();
        String noStr = this.no();
        block3: for (Row row : opRuleDs) {
            String entityNum = row.getString("entity");
            try {
                Set fieldKeys;
                String operationkey;
                String operationName;
                Map opInfoMap = (Map)entityOpInfoMap.get(entityNum);
                if (opInfoMap == null || opInfoMap.isEmpty() || StringUtils.isEmpty((String)(operationName = (String)opInfoMap.get(operationkey = row.getString("operationkey")))) || CollectionUtils.isEmpty((Collection)(fieldKeys = (Set)entityFieldKeysMap.get(entityNum)))) continue;
                String oprule = row.getString("oprule");
                oprule = PermCommonUtil.replaceBackSlach((String)oprule);
                JSONObject jsonObj = JSONObject.parseObject((String)oprule);
                JSONArray jsonArray = jsonObj.getJSONArray("filterRow");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject filterRow = (JSONObject)jsonArray.getObject(i, JSONObject.class);
                    String fieldName = filterRow.getString("fieldName");
                    if (fieldName.contains(".")) {
                        fieldName = fieldName.substring(0, fieldName.indexOf(46));
                    }
                    if (!fieldKeys.contains(fieldName)) continue block3;
                }
                String enableStr = row.getString("enable");
                enableStr = "1".equals(enableStr) ? yesStr : noStr;
                String ispresetStr = row.getString("ispreset");
                ispresetStr = "1".equals(ispresetStr) ? yesStr : noStr;
                String ispublicStr = row.getString("ispublic");
                ispublicStr = "1".equals(ispublicStr) ? yesStr : noStr;
                builder.append(new Object[]{row.getString("appid"), entityNum, row.getString("opobjid"), row.getString("oprulename"), operationName, operationkey, enableStr, oprule, ispresetStr, ispublicStr});
            }
            catch (Exception e) {
                logger.debug("OperationRuleListDataRpt.appendOpRuleDs:entityNum=" + entityNum, (Object)e.getMessage());
            }
        }
        opRuleDs = builder.build();
        opRuleDs = this.joinDirectorAndExceptInfo(opRuleDs);
        opRuleDs = opRuleDs.leftJoin(cloudAppEntityRelationDS).on("appid", "appid").select(new String[]{"cloud", "app", "entity", "oprulename", "operation", "operationkey", "enable", "oprule", "ispreset", "ispublic", "director", "exceptuser", "exceptusrgrp", "exceptrole"}).finish();
        return PermQueryReportUtil.orderByAndFilterResult(quertParam, opRuleDs, new String[]{"cloud", "app", "entity"});
    }

    private DataSet joinDirectorAndExceptInfo(DataSet opRuleDs) {
        String localeName = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder("select d.foperationruleobjid opobjid, ").append("case when ul.ftruename is null or ul.ftruename = '' or ul.ftruename = ' ' ").append("then u.ftruename else ul.ftruename end as directorname, ").append("case when ol.fname is null or ol.fname = '' or ol.fname = ' ' ").append("then o.fname else ol.fname end as org ").append("from t_perm_director d ").append("join t_sec_user u on (d.fdirectorid = u.fid) ").append("left join t_sec_user_l ul on (ul.fid = u.fid and ul.flocaleid = ?) ").append("join t_org_org o on (d.forgid = o.fid) ").append("left join t_org_org_l ol on (ol.fid = o.fid and ol.flocaleid = ?) ");
        DataSet directorDs = DB.queryDataSet((String)(this.algoKey + "_directorDs"), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{localeName, localeName});
        directorDs = directorDs.groupBy(new String[]{"opobjid", "directorname"}).groupConcat("org", "org", "\u3001").finish().executeSql("select opobjid,directorname||'\uff08'||org||'\uff09' userorg");
        directorDs = directorDs.groupBy(new String[]{"opobjid"}).groupConcat("userorg", "director", "\uff0c").finish();
        sql.setLength(0);
        sql.append("select eu.foperationruleobjid opobjid, ").append("case when ul.ftruename is null or ul.ftruename = '' or ul.ftruename = ' ' ").append("then u.ftruename else ul.ftruename end ").append("||'\uff08'||u.fnumber||'\uff09' exceptuser ").append("from t_perm_exceptuser eu ").append("join t_sec_user u on u.fid = eu.fuserid ").append("left join t_sec_user_l ul on (ul.fid = u.fid  and ul.flocaleid = ?) ").append("where eu.foperationruleobjid <> ' ' ");
        DataSet exceptUserDs = DB.queryDataSet((String)(this.algoKey + "_exceptUserDs"), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{localeName});
        exceptUserDs = exceptUserDs.groupBy(new String[]{"opobjid"}).groupConcat("exceptuser", "exceptuser", "\uff0c").finish();
        sql.setLength(0);
        sql.append("select eug.foperationruleobjid opobjid, ").append("case when ugl.fname is null or ugl.fname = '' or ugl.fname = ' ' ").append("then ug.fname else ugl.fname end ").append(" ").append("||'\uff08'||ug.fnumber||'\uff09' exceptusrgrp ").append("from t_perm_oprexusrgrp eug ").append("join t_sec_usergroup ug on eug.fusergroupid=ug.fid ").append("left join t_sec_usergroup_l ugl on (ug.fid = ugl.fid and ugl.flocaleid = ?) ");
        DataSet exceptUsrGrpDs = DB.queryDataSet((String)(this.algoKey + "_exceptUsrGrpDs"), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{localeName});
        exceptUsrGrpDs = exceptUsrGrpDs.groupBy(new String[]{"opobjid"}).groupConcat("exceptusrgrp", "exceptusrgrp", "\uff0c").finish();
        sql.setLength(0);
        sql.append("select opr.foperationruleobjid opobjid, ").append("case when rl.fname is null or rl.fname = '' or rl.fname = ' ' ").append("then r.fname else rl.fname end ").append("||'\uff08'||r.fnumber||'\uff09' exceptrole ").append("from t_perm_oprexrole opr ").append("join t_perm_role r on opr.froleid = r.fid ").append("left join t_perm_role_l rl on (r.fid = rl.fid and rl.flocaleid = ?) ");
        DataSet exceptRoleDs = DB.queryDataSet((String)(this.algoKey + "_exceptRoleDs"), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{localeName});
        exceptRoleDs = exceptRoleDs.groupBy(new String[]{"opobjid"}).groupConcat("exceptrole", "exceptrole", "\uff0c").finish();
        opRuleDs = opRuleDs.leftJoin(directorDs).on("opobjid", "opobjid").select(new String[]{"appid", "entity", "oprulename", "operation", "operationkey", "enable", "oprule", "ispreset", "ispublic", "opobjid", "director"}).finish();
        opRuleDs = opRuleDs.leftJoin(exceptUserDs).on("opobjid", "opobjid").select(new String[]{"appid", "entity", "oprulename", "operation", "operationkey", "enable", "oprule", "ispreset", "ispublic", "opobjid", "director", "exceptuser"}).finish();
        opRuleDs = opRuleDs.leftJoin(exceptUsrGrpDs).on("opobjid", "opobjid").select(new String[]{"appid", "entity", "oprulename", "operation", "operationkey", "enable", "oprule", "ispreset", "ispublic", "opobjid", "director", "exceptuser", "exceptusrgrp"}).finish();
        opRuleDs = opRuleDs.leftJoin(exceptRoleDs).on("opobjid", "opobjid").select(new String[]{"appid", "entity", "oprulename", "operation", "operationkey", "enable", "oprule", "ispreset", "ispublic", "opobjid", "director", "exceptuser", "exceptusrgrp", "exceptrole"}).finish();
        return opRuleDs;
    }

    private DataSet getAppEntityDs(String appFilter, String entityFilter) {
        StringBuilder sql = new StringBuilder("select app.fid appid,ed.fnumber entity ").append("from t_meta_bizapp app ").append("join t_meta_entitydesign ed on (app.fid = ed.fbizappid) ").append("where ed.fistemplate = '0' ").append(" and ed.fmodeltype in ('BillFormModel', 'BaseFormModel','LogBillFormModel') ").append(" and ed.ftype = '0' ");
        PermQueryReportUtil.appendFilters(sql, appFilter, "app", "fid");
        PermQueryReportUtil.appendFilters(sql, entityFilter, "ed", "fnumber");
        DataSet appEntityDs = DB.queryDataSet((String)(this.algoKey + "_appEntityDs"), (DBRoute)DBRoute.meta, (String)sql.toString());
        sql.setLength(0);
        sql.append("select boa.fbizappid appid,boa.fbizobjid entity ").append("from t_perm_bizobjapp boa ").append("where 1=1 ");
        PermQueryReportUtil.appendFilters(sql, appFilter, "boa", "fbizappid");
        PermQueryReportUtil.appendFilters(sql, entityFilter, "boa", "fbizobjid");
        DataSet bizObjAppDs = DB.queryDataSet((String)(this.algoKey + "_bizObjAppDs"), (DBRoute)DBRoute.permission, (String)sql.toString());
        sql.setLength(0);
        sql.append("select ed.fnumber entity ").append("from t_meta_entitydesign ed ").append("where ed.fistemplate = '0' ").append(" and ed.fmodeltype in ('BillFormModel', 'BaseFormModel','LogBillFormModel') ").append(" and ed.ftype = '0' ");
        PermQueryReportUtil.appendFilters(sql, entityFilter, "ed", "fnumber");
        DataSet entityDs = DB.queryDataSet((String)(this.algoKey + "_entityDs"), (DBRoute)DBRoute.meta, (String)sql.toString());
        bizObjAppDs = bizObjAppDs.join(entityDs).on("entity", "entity").select(new String[]{"appid", "entity"}).finish();
        return appEntityDs.union(bizObjAppDs);
    }

    private static Map<String, Map<String, String>> getEntityOpInfoMap(Set<String> entityNumSet) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(10);
        for (String entityNum : entityNumSet) {
            try {
                result.put(entityNum, OperationHelper.getOperationInfoMap((String)entityNum));
            }
            catch (Exception e) {
                logger.debug("OperationRuleListDataRpt.getEntityOpInfoMap:" + entityNum, (Object)e.getMessage());
            }
        }
        return result;
    }

    private static Map<String, Set<String>> getEntityFieldKeysMap(Set<String> entityNumSet) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(10);
        for (String entityNum : entityNumSet) {
            try {
                MainEntityType entityTypeInfo = EntityMetadataCache.getDataEntityType((String)entityNum);
                Set fieldKeys = entityTypeInfo.getAllFields().keySet();
                result.put(entityNum, fieldKeys);
            }
            catch (Exception e) {
                logger.debug("OperationRuleListDataRpt.getEntityFieldKeysMap:" + entityNum, (Object)e.getMessage());
            }
        }
        return result;
    }
}

