/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.query;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.DateTimeReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.PermQueryReportUtil;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;

public class PermReportFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(PermReportFormPlugin.class);
    private static final String USERPERM_OVERVIEW_REPORT = "userperm_overview_report";
    private static final String USER_PERM_REPORT = "userspermreport";
    private static final String PERM_FIELDPERM_REPORT = "perm_fieldperm_report";
    private static final String PERM_DATARULE_REPORT = "perm_datarule_report";
    private static final String ROLE_PERM_REPORT = "role_perm_report";
    private static final String BIZROLE_PERM_REPORT = "bizrole_perm_report";
    private static final String OPERATIONRULE_PERM_REPORT = "operationrule_perm_report";
    private static final String FUNC_PERMITEM = "funcpermitem";
    private static final String DATARULE_PERMITEM = "datarulepermitem";
    private static final String PERMSTATUS = "permstatus";
    private static final String ENTITY = "entity";
    private static final String USERID = "userid";
    private static final String WORKNUMBER = "worknumber";
    private Map<String, String> fieldNumMap = new HashMap<String, String>(10);

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        try {
            super.setSortAndFilter(list);
            for (SortAndFilterEvent event : list) {
                String columnName = event.getColumnName();
                if (ENTITY.equals(columnName) || FUNC_PERMITEM.equals(columnName) || DATARULE_PERMITEM.equals(columnName) || USERID.equals(columnName) || WORKNUMBER.equals(columnName) || "isforbidden".equals(columnName) || "islocked".equals(columnName)) continue;
                event.setSort(true);
                event.setFilter(true);
            }
        }
        catch (Exception e) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Throwable)e);
            throw e;
        }
    }

    public void initialize() {
        try {
            ItemClassTypeProp ictp;
            String hyperlinkDimtype;
            String selDimType;
            super.initialize();
            String entityId = this.getView().getEntityId();
            PermQueryReportUtil.loadFieldNumMap(this.fieldNumMap, entityId);
            if (ROLE_PERM_REPORT.equals(entityId) || OPERATIONRULE_PERM_REPORT.equals(entityId)) {
                return;
            }
            String dimTypeField = this.fieldNumMap.get("selectdimtype");
            try {
                selDimType = (String)this.getModel().getValue(dimTypeField);
                if (selDimType == null) {
                    selDimType = "bos_org";
                    this.getPageCache().put("pgcache_skip", "true");
                    this.getModel().setValue(dimTypeField, (Object)"bos_org");
                }
            }
            catch (Exception e) {
                selDimType = "bos_org";
            }
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && StringUtils.isNotEmpty((String)(hyperlinkDimtype = parentView.getPageCache().get("pgcache_hyperlink_dimtype")))) {
                selDimType = hyperlinkDimtype;
            }
            if ((ictp = (ItemClassTypeProp)this.getModel().getProperty(dimTypeField)) != null) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)selDimType);
                if (mainEntityType != null) {
                    ictp.setItemType((DynamicObjectType)mainEntityType);
                } else {
                    logger.debug("PermReportFormPlugin: dimtype=" + selDimType + " MainEntityType is null");
                }
            }
        }
        catch (Exception e) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Throwable)e);
            throw e;
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            super.afterCreateNewData(e);
            String entityId = this.getView().getEntityId();
            if (ROLE_PERM_REPORT.equals(entityId) || OPERATIONRULE_PERM_REPORT.equals(entityId)) {
                return;
            }
            String dimTypeField = this.fieldNumMap.get("selectdimtype");
            ItemClassTypeEdit selectDimTypeFields = (ItemClassTypeEdit)this.getControl(dimTypeField);
            PermCommonUtil.buildDimTypeItemClassType((ItemClassTypeEdit)selectDimTypeFields);
            this.getView().setVisible(Boolean.valueOf(!PermCommonUtil.isSingleOrg()), new String[]{this.fieldNumMap.get("orgfilter")});
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                IPageCache parentViewPageCache = parentView.getPageCache();
                String dimType = parentViewPageCache.get("pgcache_hyperlink_dimtype");
                parentViewPageCache.remove("pgcache_hyperlink_dimtype");
                if (dimType != null && !"bos_org".equals(dimType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{this.fieldNumMap.get("dimfilter")});
                    this.getView().setVisible(Boolean.FALSE, new String[]{this.fieldNumMap.get("orgfilter")});
                    String dimTypeName = PermCommonUtil.getDimTypeName((String)dimType);
                    HashMap<String, LocaleString> captionInfo = new HashMap<String, LocaleString>(1);
                    captionInfo.put("caption", new LocaleString(dimTypeName));
                    this.getView().updateControlMetadata(this.fieldNumMap.get("dimfilter"), captionInfo);
                    return;
                }
            }
            this.getModel().setValue(dimTypeField, (Object)"bos_org");
            this.getView().setVisible(Boolean.FALSE, new String[]{this.fieldNumMap.get("dimfilter")});
        }
        catch (Exception ex) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Object)e);
            throw ex;
        }
    }

    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            BasedataEdit cloudF7 = (BasedataEdit)this.getControl(this.fieldNumMap.get("cloudfilter"));
            BasedataEdit appF7 = (BasedataEdit)this.getControl(this.fieldNumMap.get("appfilter"));
            BasedataEdit entityF7 = (BasedataEdit)this.getControl(this.fieldNumMap.get("entityfilter"));
            BasedataEdit permItemF7 = (BasedataEdit)this.getControl(this.fieldNumMap.get("permitemfilter"));
            BasedataEdit userF7 = (BasedataEdit)this.getControl(this.fieldNumMap.get("userfilter"));
            PermQueryReportUtil.addF7Filter(cloudF7, appF7, entityF7, permItemF7, userF7, this.getModel(), this.fieldNumMap);
            if (USERPERM_OVERVIEW_REPORT.equals(this.getView().getEntityId())) {
                ReportList list = (ReportList)this.getControl("reportlistap");
                list.addHyperClickListener((HyperLinkClickListener)this);
            }
        }
        catch (Exception ex) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Object)e);
            throw ex;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            if ("true".equals(this.getPageCache().get("pgcache_skip"))) {
                this.getPageCache().remove("pgcache_skip");
                return;
            }
            String propName = e.getProperty().getName();
            if (propName.equals(this.fieldNumMap.get("selectdimtype"))) {
                Object newValue = e.getChangeSet()[0].getNewValue();
                String selDimType = newValue + "";
                this.change2ChoosedDimType(selDimType);
            }
        }
        catch (Exception ex) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Object)e);
            throw ex;
        }
    }

    public void afterSetModelValue(DynamicObject scheme) {
        try {
            super.afterSetModelValue(scheme);
            IDataModel dataModel = this.getModel();
            String selectdimtype = this.fieldNumMap.get("selectdimtype");
            if (null != dataModel.getDataEntity() && dataModel.getDataEntity().containsProperty(selectdimtype)) {
                String selDimType = (String)dataModel.getValue(selectdimtype);
                this.change2ChoosedDimType(selDimType);
            }
        }
        catch (Exception e) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Throwable)e);
            throw e;
        }
    }

    private void change2ChoosedDimType(String selDimType) {
        MainEntityType mainEntityType;
        if (StringUtils.isEmpty((String)selDimType)) {
            return;
        }
        boolean isSelOrg = "bos_org".equals(selDimType);
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"PermReportFormPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0])));
        String dimTypeField = this.fieldNumMap.get("selectdimtype");
        ItemClassTypeProp ictp = (ItemClassTypeProp)this.getModel().getProperty(dimTypeField);
        if (ictp != null && (mainEntityType = EntityMetadataCache.getDataEntityType((String)selDimType)) != null) {
            ictp.setItemType((DynamicObjectType)mainEntityType);
        }
        if (isSelOrg) {
            Object[] org = new Object[]{0L};
            this.getModel().setValue(this.fieldNumMap.get("dimfilter"), (Object)0L);
            this.getModel().setValue(this.fieldNumMap.get("orgfilter"), (Object)org);
        } else {
            String dimTypeName = PermCommonUtil.getDimTypeName((String)selDimType);
            HashMap<String, LocaleString> captionInfo = new HashMap<String, LocaleString>(1);
            captionInfo.put("caption", new LocaleString(dimTypeName));
            this.getView().updateControlMetadata(this.fieldNumMap.get("dimfilter"), captionInfo);
            this.getModel().setValue(this.fieldNumMap.get("orgfilter"), null);
        }
        this.getView().setVisible(Boolean.valueOf(!isSelOrg), new String[]{this.fieldNumMap.get("dimfilter")});
        this.getView().setVisible(Boolean.valueOf(isSelOrg), new String[]{this.fieldNumMap.get("orgfilter")});
        this.getView().hideLoading();
    }

    private int getFilterCount(String filterNum, ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        if (this.fieldNumMap.get("dimfilter").equals(filterNum) || this.fieldNumMap.get("orgfilter").equals(filterNum)) {
            String dimType = (String)this.getModel().getValue(this.fieldNumMap.get("selectdimtype"));
            if ("bos_org".equals(dimType)) {
                DynamicObjectCollection orgCol = filter.getDynamicObjectCollection(this.fieldNumMap.get("orgfilter"));
                return orgCol == null ? 0 : orgCol.size();
            }
            return filter.getDynamicObject(this.fieldNumMap.get("dimfilter")) == null ? 0 : 1;
        }
        DynamicObjectCollection dynamicObjectCollection = filter.getDynamicObjectCollection(filterNum);
        return dynamicObjectCollection == null ? 0 : dynamicObjectCollection.size();
    }

    private boolean verifyParam(boolean containDim, ReportQueryParam queryParam, String ... params) {
        int dimMaxCount = 10;
        int otherMaxCount = 100;
        ArrayList<String> nullParamNameList = new ArrayList<String>(params.length + 1);
        StringBuilder isOverMaxMes = new StringBuilder();
        if (containDim) {
            String string = (String)this.getModel().getValue(this.fieldNumMap.get("selectdimtype"));
            String dimTypeName = PermCommonUtil.getDimTypeName((String)string);
            int dimCount = this.getFilterCount(this.fieldNumMap.get("dimfilter"), queryParam);
            if (dimCount == 0) {
                nullParamNameList.add(dimTypeName);
            } else {
                if (0 < dimCount && dimCount <= dimMaxCount) {
                    return true;
                }
                isOverMaxMes.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%2$s", (String)"PermReportFormPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), dimTypeName, dimMaxCount)).append("\uff0c");
            }
        }
        for (String param : params) {
            int paramCount = this.getFilterCount(param, queryParam);
            String paramName = "";
            if (this.fieldNumMap.get("userfilter").equals(param)) {
                paramName = ResManager.loadKDString((String)"\u7528\u6237", (String)"PermReportFormPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            } else if ("selectrole".equals(param)) {
                paramName = ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272", (String)"PermReportFormPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            } else if ("selectbizrole".equals(param)) {
                paramName = ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272", (String)"PermReportFormPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            } else if (this.fieldNumMap.get("entityfilter").equals(param)) {
                paramName = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"PermReportFormPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            } else if (this.fieldNumMap.get("cloudfilter").equals(param)) {
                paramName = ResManager.loadKDString((String)"\u4e91", (String)"PermReportFormPlugin_12", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            } else if (this.fieldNumMap.get("appfilter").equals(param)) {
                paramName = ResManager.loadKDString((String)"\u5e94\u7528", (String)"PermReportFormPlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            }
            if (paramCount == 0) {
                nullParamNameList.add(paramName);
                continue;
            }
            if (0 < paramCount && paramCount <= otherMaxCount) {
                return true;
            }
            isOverMaxMes.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%2$s", (String)"PermReportFormPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), paramName, otherMaxCount)).append("\uff0c");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!nullParamNameList.isEmpty()) {
            boolean isAllNull;
            for (String nullParamName : nullParamNameList) {
                stringBuilder.append("\u201c").append(nullParamName).append("\u201d\u3001");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            boolean bl = containDim ? nullParamNameList.size() == params.length + 1 : (isAllNull = nullParamNameList.size() == params.length);
            if (isAllNull) {
                stringBuilder.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u9879\u3002", (String)"PermReportFormPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                this.getView().showErrorNotification(stringBuilder.toString());
                return false;
            }
            stringBuilder.append(ResManager.loadKDString((String)"\u4e3a\u7a7a\u65f6", (String)"PermReportFormPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0])).append("\uff0c");
        }
        isOverMaxMes.deleteCharAt(isOverMaxMes.length() - 1).append("\u3002");
        stringBuilder.append((CharSequence)isOverMaxMes);
        this.getView().showErrorNotification(stringBuilder.toString());
        return false;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        try {
            String entityId = this.getView().getEntityId();
            if (USERPERM_OVERVIEW_REPORT.equals(entityId)) {
                return this.verifyParam(true, queryParam, this.fieldNumMap.get("userfilter"));
            }
            if (USER_PERM_REPORT.equals(entityId) || PERM_FIELDPERM_REPORT.equals(entityId) || PERM_DATARULE_REPORT.equals(entityId)) {
                return this.verifyParam(true, queryParam, this.fieldNumMap.get("userfilter"), this.fieldNumMap.get("entityfilter"));
            }
            if (ROLE_PERM_REPORT.equals(entityId)) {
                return this.verifyParam(false, queryParam, "selectrole", this.fieldNumMap.get("entityfilter"));
            }
            if (BIZROLE_PERM_REPORT.equals(entityId)) {
                return this.verifyParam(true, queryParam, "selectbizrole", this.fieldNumMap.get("entityfilter"));
            }
            if (OPERATIONRULE_PERM_REPORT.equals(entityId)) {
                return this.verifyParam(false, queryParam, "cloudfilter", "appfilter", "entityfilter");
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Throwable)e);
            throw e;
        }
    }

    private void handleDataAfterQuery(DynamicObject rowData) {
        String funcPermItem;
        String entityId = this.getView().getEntityId();
        if (OPERATIONRULE_PERM_REPORT.equals(entityId)) {
            PermQueryReportUtil.dataRuleHandle(rowData, rowData.getDynamicObject(ENTITY));
            return;
        }
        if (!PERM_DATARULE_REPORT.equals(entityId)) {
            PermQueryReportUtil.fieldPermDataHandle(rowData, rowData.getDynamicObject(ENTITY));
        }
        if (!PERM_FIELDPERM_REPORT.equals(entityId)) {
            PermQueryReportUtil.dataRuleHandle(rowData, rowData.getDynamicObject(ENTITY));
        }
        if (BIZROLE_PERM_REPORT.equals(entityId) && StringUtils.isEmpty((String)(funcPermItem = rowData.getString(FUNC_PERMITEM)))) {
            rowData.set(PERMSTATUS, (Object)"");
        }
    }

    public void packageData(PackageDataEvent e) {
        try {
            super.packageData(e);
            String entityId = this.getView().getEntityId();
            if (USERPERM_OVERVIEW_REPORT.equals(entityId) || USER_PERM_REPORT.equals(entityId)) {
                return;
            }
            this.handleDataAfterQuery(e.getRowData());
        }
        catch (Exception ex) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Object)e);
            throw ex;
        }
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        try {
            super.preProcessExportData(exportColumns, data, numberFormatProvider);
            String entityId = this.getView().getEntityId();
            if (USERPERM_OVERVIEW_REPORT.equals(entityId) || USER_PERM_REPORT.equals(entityId)) {
                return;
            }
            for (DynamicObject rowData : data) {
                this.handleDataAfterQuery(rowData);
            }
        }
        catch (Exception e) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Throwable)e);
            throw e;
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = null;
        DynamicObject rowData = null;
        try {
            fieldName = hyperLinkClickEvent.getFieldName();
            rowData = hyperLinkClickEvent.getRowData();
            Object fieldData = rowData.get(fieldName);
            if (fieldData == null) {
                return;
            }
        }
        catch (Exception e) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Throwable)e);
            throw e;
        }
        String permtype = rowData.getString("permtype");
        String selDimType = this.getModel().getValue(this.fieldNumMap.get("selectdimtype")) + "";
        if ("funcperm".equals(fieldName) && (ResManager.loadKDString((String)"\u76f4\u63a5\u7981\u6743", (String)"PermReportFormPlugin_8", (String)"bos-permission-formplugin", (Object[])new Object[0]).equals(permtype) || ResManager.loadKDString((String)"\u76f4\u63a5\u6388\u6743", (String)"PermReportFormPlugin_9", (String)"bos-permission-formplugin", (Object[])new Object[0]).equals(permtype))) {
            if (!"bos_org".equals(selDimType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u201c\u7ec4\u7ec7\u201d\u6743\u9650\u63a7\u5236\u7c7b\u578b\u94fe\u63a5\u4e32\u8054\u67e5\u8be2\u6743\u9650\u3002", (String)"PermReportFormPlugin_10", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter fsp = new FormShowParameter();
            String formId = ResManager.loadKDString((String)"\u76f4\u63a5\u6388\u6743", (String)"PermReportFormPlugin_9", (String)"bos-permission-formplugin", (Object[])new Object[0]).equals(permtype) ? "perm_direct_perm_multi" : "perm_direct_disperm_multi";
            String pageId = this.getView().getPageId();
            DynamicObject user = rowData.getDynamicObject(USERID);
            if (user == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u67e5\u8be2\u3002", (String)"PermReportFormPlugin_11", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return;
            }
            Long userId = (Long)user.getPkValue();
            String newPageId = pageId + "|" + formId + "|" + userId;
            fsp.setPageId(newPageId);
            IFormView iformView = this.getView().getViewNoPlugin(newPageId);
            if (iformView != null) {
                PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("paramUserId", userId + "");
            fsp.setCustomParams(params);
            fsp.setStatus(OperationStatus.VIEW);
            fsp.setFormId(formId);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(fsp);
            return;
        }
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setLinkQuery(true);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam reportQueryParam = new ReportQueryParam();
        FilterInfo filterInfo = new FilterInfo();
        String formId = null;
        if ("funcperm".equals(fieldName)) {
            String id4hyperlink = rowData.getString("id4hyperlink");
            if (id4hyperlink.contains("bizrole_")) {
                formId = BIZROLE_PERM_REPORT;
                filterInfo.addFilterItem(this.fieldNumMap.get("selectdimtype"), (Object)selDimType);
                this.getPageCache().put("pgcache_hyperlink_dimtype", selDimType);
                filterInfo.addFilterItem("selectbizrole", (Object)id4hyperlink.split("_")[1]);
            } else if (id4hyperlink.contains("role_")) {
                formId = ROLE_PERM_REPORT;
                filterInfo.addFilterItem("selectrole", (Object)id4hyperlink.split("_")[1]);
            }
        } else {
            Object userid = rowData.get(USERID);
            if (userid == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u67e5\u8be2\u3002", (String)"PermReportFormPlugin_11", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return;
            }
            this.fieldNumMap.clear();
            if (USERID.equals(fieldName)) {
                formId = USER_PERM_REPORT;
                PermQueryReportUtil.loadFieldNumMap(this.fieldNumMap, formId);
                filterInfo.addFilterItem(this.fieldNumMap.get("userfilter"), userid);
                filterInfo.addFilterItem("selectpermstatus", (Object)0);
                filterInfo.addFilterItem(this.fieldNumMap.get("selectdimtype"), (Object)selDimType);
                this.getPageCache().put("pgcache_hyperlink_dimtype", selDimType);
            } else if ("fieldperm".equals(fieldName)) {
                formId = PERM_FIELDPERM_REPORT;
                PermQueryReportUtil.loadFieldNumMap(this.fieldNumMap, formId);
                filterInfo.addFilterItem(this.fieldNumMap.get("userfilter"), userid);
                filterInfo.addFilterItem("controlmode", (Object)1);
                filterInfo.addFilterItem(this.fieldNumMap.get("selectdimtype"), (Object)selDimType);
                this.getPageCache().put("pgcache_hyperlink_dimtype", selDimType);
            } else if ("datarule".equals(fieldName)) {
                formId = PERM_DATARULE_REPORT;
                PermQueryReportUtil.loadFieldNumMap(this.fieldNumMap, formId);
                filterInfo.addFilterItem(this.fieldNumMap.get("userfilter"), userid);
                filterInfo.addFilterItem(this.fieldNumMap.get("selectdimtype"), (Object)selDimType);
                this.getPageCache().put("pgcache_hyperlink_dimtype", selDimType);
            }
        }
        if (StringUtils.isEmpty((String)formId)) {
            return;
        }
        reportShowParameter.setFormId(formId);
        reportQueryParam.setFilter(filterInfo);
        reportShowParameter.setQueryParam(reportQueryParam);
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        try {
            super.afterCreateColumn(event);
            List columns = event.getColumns();
            boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
            for (AbstractReportColumn column : columns) {
                String dimType;
                if (!enableValidateTime && column instanceof DateTimeReportColumn) {
                    ((DateTimeReportColumn)column).setHide(true);
                    continue;
                }
                if (column instanceof ComboReportColumn) {
                    PermReportFormPlugin.buildComboReportColumn((ComboReportColumn)column);
                    return;
                }
                if (!(column instanceof ReportColumn)) continue;
                ReportColumn reportColumn = (ReportColumn)column;
                String fieldKey = reportColumn.getFieldKey();
                String dimTypeField = this.fieldNumMap.get("selectdimtype");
                if ("includesubdim".equals(fieldKey)) {
                    dimType = (String)this.getModel().getValue(dimTypeField);
                    if ("bos_org".equals(dimType)) continue;
                    reportColumn.setHide(true);
                    continue;
                }
                if ("dimtypenum".equals(fieldKey) || "dimtypename".equals(fieldKey)) {
                    dimType = (String)this.getModel().getValue(dimTypeField);
                    String[] suitableDimType = PermCommonUtil.getSuitableDimType((String)dimType);
                    String dimTypeName = suitableDimType[3];
                    if (StringUtils.isEmpty((String)dimTypeName)) {
                        dimTypeName = ResManager.loadKDString((String)"\u6743\u9650\u63a7\u5236\u5bf9\u8c61", (String)"PermReportFormPlugin_16", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                    }
                    String caption = "dimtypenum".equals(fieldKey) ? String.format(ResManager.loadKDString((String)"%1$s\u7f16\u7801", (String)"PermReportFormPlugin_14", (String)"bos-permission-formplugin", (Object[])new Object[0]), dimTypeName) : String.format(ResManager.loadKDString((String)"%1$s\u540d\u79f0", (String)"PermReportFormPlugin_15", (String)"bos-permission-formplugin", (Object[])new Object[0]), dimTypeName);
                    reportColumn.setCaption(new LocaleString(caption));
                    continue;
                }
                if (!"dimtype".equals(fieldKey)) continue;
                reportColumn.setHide(true);
            }
        }
        catch (Exception e) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Throwable)e);
            throw e;
        }
    }

    private static void buildComboReportColumn(ComboReportColumn ctrlFieldType) {
        if (null == ctrlFieldType) {
            return;
        }
        Set modelTypes = FormHelper.getDistinctModelTypeSet();
        HashSet classNameSet = new HashSet(10);
        ArrayList<ValueMapItem> valueMapItems = new ArrayList<ValueMapItem>(10);
        for (String modelType : modelTypes) {
            if (StringUtils.isEmpty((String)modelType)) continue;
            try {
                DomainModelType domainModelType = DomainModelType.getDomainModelType((String)modelType);
                Map elementTypes = domainModelType.getElementTypes();
                elementTypes.values().parallelStream().forEach(k -> {
                    String name;
                    LocaleString localeString;
                    String className = k.getClassName();
                    if (!StringUtils.isEmpty((String)className) && className.startsWith("kd.bos.metadata.entity") && null != (localeString = k.getName()) && !StringUtils.isEmpty((String)(name = localeString.getLocaleValue())) && classNameSet.add(className)) {
                        ValueMapItem valueMapItem = new ValueMapItem();
                        valueMapItem.setValue(className);
                        valueMapItem.setName(new LocaleString(name));
                        valueMapItems.add(valueMapItem);
                    }
                });
            }
            catch (Exception e) {
                logger.warn("PermReportFormPlugin.buildComboReportColumn_\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Throwable)e);
            }
        }
        for (ValueMapItem valueMapItem : valueMapItems) {
            if (null != valueMapItem) continue;
            logger.warn("PermReportFormPlugin.buildComboReportColumn_valueMapItemIsNull");
        }
        valueMapItems.removeIf(x -> null == x);
        ctrlFieldType.setComboItems(valueMapItems);
    }
}

