/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.query;

import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.formplugin.util.PermQueryReportUtil;

public class RolePermissionListDataRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(RolePermissionListDataRpt.class);
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final String[] QUERY_FIELDS = new String[]{"number", "name", "entity", "funcpermitem", "app", "cloud", "ctrlfield", "ctrlfieldtype", "fieldscheme", "ctrlmode", "propkey", "datarulepermitem", "datarulename", "datarule"};

    public DataSet query(ReportQueryParam quertParam, Object obj) throws Throwable {
        try {
            HashMap<String, String> fieldNumMap = new HashMap<String, String>(10);
            PermQueryReportUtil.loadFieldNumMap(fieldNumMap, "role_perm_report");
            FilterInfo filterInfo = quertParam.getFilter();
            DynamicObjectCollection roles = filterInfo.getDynamicObjectCollection("selectrole");
            DynamicObjectCollection apps = filterInfo.getDynamicObjectCollection((String)fieldNumMap.get("appfilter"));
            DynamicObjectCollection entitys = filterInfo.getDynamicObjectCollection((String)fieldNumMap.get("entityfilter"));
            DynamicObjectCollection perms = filterInfo.getDynamicObjectCollection((String)fieldNumMap.get("permitemfilter"));
            DynamicObjectCollection clouds = filterInfo.getDynamicObjectCollection((String)fieldNumMap.get("cloudfilter"));
            String roleFilter = PermQueryReportUtil.idListToStr(roles);
            String entityFilter = PermQueryReportUtil.getFilterEntityNumsStr(entitys);
            String appFilter = PermQueryReportUtil.getFilterAppIdsStr(apps);
            String permFilter = PermQueryReportUtil.idListToStr(perms);
            String cloudFilter = PermQueryReportUtil.idListToStr(clouds);
            appFilter = PermQueryReportUtil.updateAppFilterIfOnlyCloud(cloudFilter, appFilter);
            StringBuilder sql = new StringBuilder();
            DataSet allPermDS = PermQueryReportUtil.getRolePermDS(roleFilter, appFilter, entityFilter, permFilter);
            if (allPermDS.isEmpty()) {
                return DB.queryDataSet((String)"ljsj", (DBRoute)DBRoute.meta, (String)"select fid from t_meta_bizcloud where 1!=1");
            }
            sql.setLength(0);
            sql.append("select r.fid as roleid,r.fnumber as number,rl.fname as name ").append("from t_perm_role r ").append("left join t_perm_role_l rl on (r.fid=rl.fid and rl.flocaleid = ?) ").append("where 1=1 ");
            PermQueryReportUtil.appendFilters(sql, roleFilter, "r", "fid");
            Object[] params = new Object[]{RequestContext.get().getLang().name()};
            DataSet roleDS = DB.queryDataSet((String)(this.algoKey + "_roleFDS"), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params);
            allPermDS = allPermDS.join(roleDS).on("roleid", "roleid").select(new String[]{"number", "name", "entity", "funcpermitem", "appid", "ctrlfield", "ctrlfieldtype", "fieldscheme", "ctrlmode", "propkey", "datarulepermitem", "datarulename", "datarule"}).finish();
            if (allPermDS.isEmpty()) {
                return DB.queryDataSet((String)"ljsj", (DBRoute)DBRoute.meta, (String)"select fid from t_meta_bizcloud where 1!=1");
            }
            DataSet cloudAppRunTimeDataSet = PermQueryReportUtil.getCloudAndAppDs(appFilter, cloudFilter, this.algoKey);
            allPermDS = allPermDS.join(cloudAppRunTimeDataSet).on("appid", "appid").select(QUERY_FIELDS).finish();
            return PermQueryReportUtil.orderByAndFilterResult(quertParam, allPermDS, new String[]{"number", "entity"});
        }
        catch (Exception e) {
            logger.warn("\u6743\u9650\u62a5\u8868\u8df3\u8f6c\u9519\u8bef\u4e34\u65f6\u6392\u67e5\u65e5\u5fd7", (Throwable)e);
            throw e;
        }
    }
}

