/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.OrgUserHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.model.PermUserRole;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.formplugin.RoleAssignUserPlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class RoleAssignUserTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(RoleAssignUserTask.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"RoleAssignUserTask", (int)1);

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"RoleAssignUserTask_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        try {
            String pageId = (String)params.get("pageId");
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            IDataModel dataModel = view.getModel();
            DynamicObject role = (DynamicObject)dataModel.getValue("role_number");
            if (null == role) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89d2\u8272", (String)"RoleAssignUserTask_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), null);
                return;
            }
            String roleId = (String)role.getPkValue();
            Long urCount = PermRoleHelper.getCountByRoleId((String)roleId);
            List robotIds = PermCommonUtil.getRobotIds();
            desc = ResManager.loadKDString((String)"\u6d89\u53ca\u6570\u636e\u51c6\u5907\u5b8c\u6bd5\uff0c\u5f00\u59cb\u83b7\u53d6\u754c\u9762\u6570\u636e\u3002", (String)"RoleAssignUserTask_2", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 5;
            this.feedbackProgress(progress, desc, null);
            boolean dimObjInLeft = (Boolean)params.get("dimObjInLeft");
            if (dimObjInLeft) {
                this.saveDimUser(robotIds, urCount, dataModel, params);
            } else {
                this.saveUserDim(robotIds, urCount, dataModel, params);
            }
            desc = ResManager.loadKDString((String)"\u64cd\u4f5c\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u3002", (String)"RoleAssignUserTask_3", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 98;
            this.feedbackProgress(progress, desc, null);
        }
        catch (Exception e) {
            log.warn("RoleAssignUserTask.execute error", (Throwable)e);
            this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:%1$s", (String)"RoleAssignUserTask_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), e.getMessage()), null);
        }
    }

    private void saveUserDim(List<Long> robotIds, Long urCount, IDataModel dataModel, final Map<String, Object> params) {
        String systemTypeFormplugin = "bos-permission-formplugin";
        try {
            DynamicObjectCollection userCollection = dataModel.getEntryEntity("userlist");
            int userColSize = userCollection.size();
            if (0 == userColSize && 0L == urCount) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u201c\u7528\u6237\u201d\u3002", (String)"RoleAssignUserTask_5", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return;
            }
            String desc = ResManager.loadKDString((String)"\u754c\u9762\u6570\u636e\u83b7\u53d6\u5b8c\u6bd5\uff0c\u51c6\u5907\u8fdb\u884c\u89e3\u6790\u3002", (String)"RoleAssignUserTask_6", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 10;
            this.feedbackProgress(progress, desc, null);
            DynamicObject role = (DynamicObject)dataModel.getValue("role_number");
            final String roleId = (String)role.getPkValue();
            String ctrlTypeName = (String)params.get("ctrlTypeName");
            final HashSet<Long> lisenceUserIds = new HashSet<Long>(userColSize);
            String pageId = (String)params.get("pageId");
            final Set<String> mayChangedUserIdSet = RoleAssignUserPlugin.getMayChangedUserId(pageId);
            if (CollectionUtils.isEmpty(mayChangedUserIdSet)) {
                this.busiAfterSave(roleId, lisenceUserIds, null, params);
                return;
            }
            mayChangedUserIdSet.remove("null");
            final List mayChangedUserIdList = mayChangedUserIdSet.stream().map(Long::valueOf).collect(Collectors.toList());
            HashSet<String> checkDuplicRoleDimUser = new HashSet<String>(userColSize);
            final String curCtrlTypeEntNum = (String)params.get("curCtrlTypeEntNum");
            String dimFieldKey = (String)params.get("dimFieldKey");
            boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
            final ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(userColSize);
            DynamicObject dimObj = null;
            DynamicObject userObj = null;
            DynamicObject user = null;
            Long dimObjId = null;
            String dimObjName = null;
            Long userId = null;
            String userName = null;
            Date startTime = null;
            Date endTime = null;
            Boolean includeSubOrg = Boolean.FALSE;
            for (int i = 0; i < userColSize; ++i) {
                userObj = (DynamicObject)userCollection.get(i);
                user = userObj.getDynamicObject("user");
                if (user == null || !mayChangedUserIdList.contains(userId = Long.valueOf(user.getLong("id")))) continue;
                userName = user.getString("name");
                if (robotIds.contains(userId)) {
                    this.wrapFeedBack(false, "confirmRobotUser", null, null);
                    return;
                }
                DynamicObjectCollection dimObjs = userObj.getDynamicObjectCollection("orglist");
                int dimObjsSize = dimObjs.size();
                if (0 == dimObjsSize) {
                    this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d \u672a\u9009\u62e9%2$s\u3002", (String)"RoleAssignUserTask_7", (String)systemTypeFormplugin, (Object[])new Object[0]), userName, ctrlTypeName), null);
                    return;
                }
                for (int j = 0; j < dimObjsSize; ++j) {
                    dimObj = (DynamicObject)dimObjs.get(j);
                    dimObjId = dimObj.getLong(dimFieldKey + "_id");
                    if (null == dimObjId || 0L == dimObjId) continue;
                    includeSubOrg = dimObj.getBoolean("org_includesuborg");
                    if (enableValidateTime) {
                        startTime = (Date)dimObj.get("starttime");
                        endTime = (Date)dimObj.get("endtime");
                        if (startTime != null && endTime != null && startTime.after(endTime)) {
                            this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u6743\u9650\u5206\u914d\u6709\u6548\u671f\u914d\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"RoleAssignUserTask_8", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                            return;
                        }
                    }
                    if (!checkDuplicRoleDimUser.add(roleId + curCtrlTypeEntNum + dimObjId + userId)) {
                        dimObjName = dimObj.getString(dimFieldKey + ".name");
                        String roleName = role.getString("name");
                        this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u89d2\u8272-\u7528\u6237-%1$s\uff0c\u89d2\u8272\uff1a%2$s\uff0c\u7528\u6237\uff1a%3$s\uff0c%4$s\uff1a%5$s\u3002", (String)"RoleAssignUserTask_9", (String)systemTypeFormplugin, (Object[])new Object[0]), ctrlTypeName, roleName, userName, ctrlTypeName, dimObjName), null);
                        return;
                    }
                    String fisincludesuborg = null == includeSubOrg || includeSubOrg == false ? "0" : "1";
                    DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userrole_multype");
                    saveObj.set("itemclasstypefield", (Object)curCtrlTypeEntNum);
                    saveObj.set("itemclass", (Object)dimObjId);
                    saveObj.set("includesuborg", (Object)fisincludesuborg);
                    saveObj.set("user", (Object)userId);
                    saveObj.set("role", (Object)roleId);
                    saveObj.set("source", (Object)"2");
                    saveObj.set("starttime", (Object)startTime);
                    saveObj.set("endtime", (Object)endTime);
                    saveList.add(saveObj);
                    if (user.getBoolean("enable")) {
                        lisenceUserIds.add(userId);
                    }
                    desc = ResManager.loadKDString((String)"\u754c\u9762\u4fe1\u606f\u89e3\u6790\u4e2d\u3002", (String)"RoleAssignUserTask_10", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                    progress = 10 + 10 / userColSize * i;
                    this.feedbackProgress(progress, desc, null);
                }
            }
            desc = ResManager.loadKDString((String)"\u754c\u9762\u4fe1\u606f\u89e3\u6790\u5b8c\u6bd5\uff0c\u8fdb\u884c\u6570\u636e\u5b58\u50a8\u3002", (String)"RoleAssignUserTask_11", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 20;
            this.feedbackProgress(progress, desc, null);
            if (this.isStop()) {
                this.stop();
            }
            Future future = pool.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    List preList = OrgUserHelper.getByRoleAndDim((String)roleId, null, (List)mayChangedUserIdList, null, (String)curCtrlTypeEntNum);
                    RoleAssignUserTask.this.saveUserDim2DB(roleId, mayChangedUserIdSet, saveList, curCtrlTypeEntNum);
                    List afterList = OrgUserHelper.getByRoleAndDim((String)roleId, null, (List)mayChangedUserIdList, null, (String)curCtrlTypeEntNum);
                    Map diffMap = PermUserRole.logCompareMutiThread((List)preList, (List)afterList);
                    RoleAssignUserTask.this.busiAfterSave(roleId, lisenceUserIds, diffMap, params);
                    return 1;
                }
            });
            Object o = null;
            int target = 98;
            while (progress < target) {
                try {
                    o = future.get(500L, TimeUnit.MILLISECONDS);
                    if (1 != (Integer)o) continue;
                    progress = target;
                }
                catch (InterruptedException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
                catch (TimeoutException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
            }
        }
        catch (Exception e) {
            log.warn("RoleAssignUserTask.saveUserDim error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private void saveDimUser(List<Long> robotIds, Long urCount, IDataModel dataModel, final Map<String, Object> params) {
        String systemTypeFormplugin = "bos-permission-formplugin";
        try {
            String ctrlTypeName = (String)params.get("ctrlTypeName");
            DynamicObjectCollection dimObjs = dataModel.getEntryEntity("orglist");
            int dimObjsSize = dimObjs.size();
            if (0 == dimObjsSize && 0L == urCount) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"RoleAssignUserTask_12", (String)"bos-permission-formplugin", (Object[])new Object[]{ctrlTypeName}), null);
                return;
            }
            String desc = ResManager.loadKDString((String)"\u754c\u9762\u6570\u636e\u83b7\u53d6\u5b8c\u6bd5\uff0c\u51c6\u5907\u8fdb\u884c\u89e3\u6790\u3002", (String)"RoleAssignUserTask_6", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 10;
            this.feedbackProgress(progress, desc, null);
            DynamicObject role = (DynamicObject)dataModel.getValue("role_number");
            final String roleId = (String)role.getPkValue();
            final HashSet<Long> lisenceUserIds = new HashSet<Long>(dimObjsSize);
            String pageId = (String)params.get("pageId");
            final Set<String> mayChangedDimIdSet = RoleAssignUserPlugin.getMayChangedDimId(pageId);
            if (CollectionUtils.isEmpty(mayChangedDimIdSet)) {
                this.busiAfterSave(roleId, lisenceUserIds, null, params);
                return;
            }
            mayChangedDimIdSet.remove("null");
            final List mayChangedDimIdList = mayChangedDimIdSet.stream().map(Long::valueOf).collect(Collectors.toList());
            HashSet<String> checkDuplicRoleDimUser = new HashSet<String>(dimObjsSize);
            final String curCtrlTypeEntNum = (String)params.get("curCtrlTypeEntNum");
            String curCtrlType = (String)params.get("curCtrlType");
            String dimFieldKey = (String)params.get("dimFieldKey");
            boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
            boolean isSingleOrg = PermFormCommonUtil.isSingleOrg(curCtrlType);
            boolean checkOrgDim = IsoDimHelper.checkOrgDim((String)curCtrlType);
            final ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(dimObjsSize);
            DynamicObject dimObj = null;
            DynamicObject user = null;
            Long userId = null;
            String userName = null;
            Date starttime = null;
            Date endtime = null;
            Object dimObjId = null;
            String dimObjName = null;
            Boolean includeSubOrg = Boolean.FALSE;
            for (int i = 0; i < dimObjsSize; ++i) {
                dimObj = (DynamicObject)dimObjs.get(i);
                dimObjId = dimObj.get(dimFieldKey + "_id");
                if (!mayChangedDimIdList.contains(dimObjId)) continue;
                dimObjName = checkOrgDim ? dimObj.getString(dimFieldKey + ".name") : dimObj.getString("dim_name");
                DynamicObjectCollection userCollection = dimObj.getDynamicObjectCollection("userlist");
                int userColSize = userCollection.size();
                if (0 == userColSize && !isSingleOrg) {
                    this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u6dfb\u52a0\u7528\u6237\u3002", (String)"RoleAssignUserTask_13", (String)systemTypeFormplugin, (Object[])new Object[0]), dimObjName), null);
                    return;
                }
                for (int j = 0; j < userColSize; ++j) {
                    DynamicObject row = (DynamicObject)userCollection.get(j);
                    user = (DynamicObject)row.get("user");
                    if (null == user) continue;
                    userId = user.getLong("id");
                    userName = user.getString("name");
                    if (robotIds.contains(userId)) {
                        this.wrapFeedBack(false, "confirmRobotUser", null, null);
                        return;
                    }
                    if (enableValidateTime) {
                        starttime = (Date)row.get("starttime");
                        endtime = (Date)row.get("endtime");
                        if (starttime != null && endtime != null && starttime.after(endtime)) {
                            this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u6743\u9650\u5206\u914d\u6709\u6548\u671f\u914d\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"RoleAssignUserTask_8", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                            return;
                        }
                    }
                    includeSubOrg = row.getBoolean("includesub");
                    if (!checkDuplicRoleDimUser.add(roleId + curCtrlTypeEntNum + dimObjId + userId)) {
                        String roleName = role.getString("name");
                        this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u89d2\u8272-%1$s-\u7528\u6237\uff0c\u89d2\u8272\uff1a%2$s\uff0c%3$s\uff1a%4$s\uff0c\u7528\u6237\uff1a%5$s\u3002", (String)"RoleAssignUserTask_14", (String)systemTypeFormplugin, (Object[])new Object[0]), ctrlTypeName, roleName, ctrlTypeName, dimObjName, userName), null);
                        return;
                    }
                    String fisincludesuborg = null == includeSubOrg || includeSubOrg == false ? "0" : "1";
                    DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userrole_multype");
                    saveObj.set("itemclasstypefield", (Object)curCtrlTypeEntNum);
                    saveObj.set("itemclass", dimObjId);
                    saveObj.set("includesuborg", (Object)fisincludesuborg);
                    saveObj.set("user", (Object)userId);
                    saveObj.set("role", (Object)roleId);
                    saveObj.set("source", (Object)"2");
                    saveObj.set("starttime", (Object)starttime);
                    saveObj.set("endtime", (Object)endtime);
                    saveList.add(saveObj);
                    if (user.getBoolean("enable")) {
                        lisenceUserIds.add(userId);
                    }
                    desc = ResManager.loadKDString((String)"\u754c\u9762\u4fe1\u606f\u89e3\u6790\u4e2d\u3002", (String)"RoleAssignUserTask_10", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                    progress = 10 + 10 / dimObjsSize * i;
                    this.feedbackProgress(progress, desc, null);
                }
            }
            desc = ResManager.loadKDString((String)"\u754c\u9762\u4fe1\u606f\u89e3\u6790\u5b8c\u6bd5\uff0c\u8fdb\u884c\u6570\u636e\u5b58\u50a8\u3002", (String)"RoleAssignUserTask_11", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 20;
            this.feedbackProgress(progress, desc, null);
            if (this.isStop()) {
                this.stop();
            }
            Future future = pool.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    List preList = OrgUserHelper.getByRoleAndDim((String)roleId, null, null, (List)mayChangedDimIdList, (String)curCtrlTypeEntNum);
                    RoleAssignUserTask.this.saveDimUser2DB(roleId, mayChangedDimIdSet, saveList, curCtrlTypeEntNum);
                    List afterList = OrgUserHelper.getByRoleAndDim((String)roleId, null, null, (List)mayChangedDimIdList, (String)curCtrlTypeEntNum);
                    Map diffMap = PermUserRole.logCompareMutiThread((List)preList, (List)afterList);
                    RoleAssignUserTask.this.busiAfterSave(roleId, lisenceUserIds, diffMap, params);
                    return 1;
                }
            });
            Object o = null;
            int target = 98;
            while (progress < target) {
                try {
                    o = future.get(500L, TimeUnit.MILLISECONDS);
                    if (1 != (Integer)o) continue;
                    progress = target;
                }
                catch (InterruptedException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
                catch (TimeoutException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
            }
        }
        catch (Exception e) {
            log.warn("RoleAssignUserTask.saveDimUser error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private int dataSavingProgress(int progress, int target) {
        String desc = ResManager.loadKDString((String)"\u6570\u636e\u5b58\u50a8\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"RoleAssignUserTask_15", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        if (progress < target - 1) {
            ++progress;
        }
        this.feedbackProgress(progress, desc, null);
        return progress;
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }

    private void busiAfterSave(String roleId, Set<Long> lisenceUserIds, Map<String, Object> diffMap, Map<String, Object> params) throws Exception {
        HashSet changedUserIdSet = new HashSet(1);
        List delList = new LinkedList();
        List addList = new LinkedList();
        if (!CollectionUtils.isEmpty(diffMap)) {
            delList = (List)diffMap.get("del");
            addList = (List)diffMap.get("add");
            Set delUserIdSet = delList.stream().map(PermUserRole::getFuserid).collect(Collectors.toSet());
            changedUserIdSet.addAll(delUserIdSet);
            Set addUserIdSet = addList.stream().map(PermUserRole::getFuserid).collect(Collectors.toSet());
            changedUserIdSet.addAll(addUserIdSet);
        }
        if (!CollectionUtils.isEmpty(changedUserIdSet)) {
            UserHasPermOrgCache.clearUserLoginOrgs(changedUserIdSet);
            LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)roleId, (String)RequestContext.get().getLang().toString());
            List newDRAppEntityList = newDataRule.getNewDRAppEntityList();
            PermCommonUtil.cancelShowForm(new ArrayList(changedUserIdSet), (List)newDRAppEntityList, (boolean)false);
        }
        PermissionServiceHelper.clearAllCache();
        HashSet<String> roleIds = new HashSet<String>();
        roleIds.add(roleId);
        Map appEntity = PermissionServiceHelper.getAppEntityByRoleSet(roleIds);
        LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList<Long>(lisenceUserIds), (Map)appEntity);
        String pageId = (String)params.get("pageId");
        boolean dimObjInLeft = (Boolean)params.get("dimObjInLeft");
        RoleAssignUserPlugin.clearMayChangedDimOrUserIdSetPageCache(pageId, dimObjInLeft);
        if (!(!PermCommonUtil.isEnablePermLog() || CollectionUtils.isEmpty(diffMap) || CollectionUtils.isEmpty(delList) && CollectionUtils.isEmpty(addList))) {
            String opbtn = ConstantsHelper.getSave();
            diffMap.put("langStr", RequestContext.get().getLang().name());
            RoleAssignUserTask.commRoleAssignOrgUser2PermLog("bar_save", opbtn, StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffMap)), params);
        }
        this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RoleAssignUserTask_16", (String)"bos-permission-formplugin", (Object[])new Object[0]), 3000);
    }

    private void saveDimUser2DB(String roleId, Set<String> mayChangedDimIdSet, List<DynamicObject> saveList, String curCtrlTypeEntNum) {
        if (CollectionUtils.isEmpty(saveList) && CollectionUtils.isEmpty(mayChangedDimIdSet)) {
            return;
        }
        try (TXHandle txHandle = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(mayChangedDimIdSet)) {
                    StringBuilder delSb = new StringBuilder();
                    delSb.append("delete from t_perm_userrole where froleid = '").append(roleId).append('\'');
                    delSb.append(" and fdimtype ='").append(curCtrlTypeEntNum).append("' and fisincludesuborg in ('0','1')");
                    delSb.append(" and fuserid > 0");
                    String mayChangedDimIdStr = String.join((CharSequence)",", mayChangedDimIdSet);
                    delSb.append(" and forgid in (").append(mayChangedDimIdStr).append(")");
                    DB.execute((DBRoute)DBRoute.base, (String)delSb.toString());
                }
                if (!CollectionUtils.isEmpty(saveList)) {
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.warn("RoleAssignUserTask.saveDimUser2DB error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    private void saveUserDim2DB(String roleId, Set<String> mayChangedUserIdSet, List<DynamicObject> saveList, String curCtrlTypeEntNum) {
        if (CollectionUtils.isEmpty(saveList) && CollectionUtils.isEmpty(mayChangedUserIdSet)) {
            return;
        }
        String mayChangedUserIdStr = String.join((CharSequence)",", mayChangedUserIdSet);
        try (TXHandle txHandle = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(mayChangedUserIdSet)) {
                    StringBuilder delSb = new StringBuilder();
                    delSb.append("delete from t_perm_userrole where froleid = '").append(roleId).append('\'');
                    delSb.append(" and fdimtype ='").append(curCtrlTypeEntNum).append("' and fisincludesuborg in ('0','1')");
                    delSb.append(" and fuserid in (").append(mayChangedUserIdStr).append(")");
                    DB.execute((DBRoute)DBRoute.base, (String)delSb.toString());
                }
                if (!CollectionUtils.isEmpty(saveList)) {
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.warn("RoleAssignUserTask.saveUserDim2DB error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    private static void commRoleAssignOrgUser2PermLog(String op, String opbtn, String diffContent, Map<String, Object> params) {
        String opItemNumber = (String)params.get("roleNumber");
        try {
            String opItemId = (String)params.get("roleId");
            String opItemName = (String)params.get("roleName");
            String appId = (String)params.get("appId");
            String formNum = (String)params.get("formNum");
            String cloudId = AppMetadataCache.getAppInfo((String)appId).getCloudId();
            boolean dimObjInLeft = (Boolean)params.get("dimObjInLeft");
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", PermLogUtil.getPermLogFnumber());
            map.put("busi_from", kd.bos.permission.log.helper.ConstantsHelper.getCommonRoleAssignorguserBusifrom((String)formNum));
            PermLogBusiType permLogBusiType = dimObjInLeft ? PermLogService.getPermLogBusiType((String)"common_role_assignorguser") : PermLogService.getPermLogBusiType((String)"common_role_assignuserorg");
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", BizAppServiceHelp.getAppIdByFormNum((String)formNum));
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.task.RoleAssignUserTask.commRoleAssignOrgUser2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", diffContent);
            map.put("oper_id", Long.parseLong(params.get("oper_id").toString()));
            map.put("oper_org_id", Long.parseLong(params.get("oper_org_id").toString()));
            map.put("oper_time", TimeServiceHelper.now());
            map.put("client_type", params.get("client_type"));
            map.put("client_ip", params.get("client_ip"));
            map.put("client_name", params.get("client_name"));
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("RoleAssignUserTask.commRoleAssignOrgUser2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }
}

