/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.task;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.enums.GrpUsrFromTypeEnum;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.UgstdSyncUserParam;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.service.UserGroupService;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;

public class UgStdSyncUserTimeTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(UgStdSyncUserTimeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.debug("\u7528\u6237\u7ec4\u540c\u6b65\u7528\u6237-\u5b9a\u65f6\u4efb\u52a1, \u542f\u52a8");
        try {
            long startTime = System.currentTimeMillis();
            this.start();
            long spendTime = System.currentTimeMillis() - startTime;
            log.debug("\u7528\u6237\u7ec4\u540c\u6b65\u7528\u6237-\u5b9a\u65f6\u4efb\u52a1, \u5b8c\u6210\u82b1\u8d39\u603b\u65f6\u957f\uff1a{}", (Object)spendTime);
        }
        catch (Exception e) {
            log.warn("\u7528\u6237\u7ec4\u540c\u6b65\u7528\u6237-\u5b9a\u65f6\u4efb\u52a1, \u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
    }

    private void start() throws Exception {
        Map ugstdDBMaps = BusinessDataServiceHelper.loadFromCache((String)"perm_usergroupstandard", (String)"id", null);
        if (CollectionUtils.isEmpty((Map)ugstdDBMaps)) {
            log.debug("UgStdSyncUserTimeTask.start, ugstdDBMaps is empty");
            return;
        }
        Set ugstdIdSet = ugstdDBMaps.keySet().stream().map(x -> (Long)x).collect(Collectors.toSet());
        PermResult permResult = UserGroupService.syncUserByUgstd((UgstdSyncUserParam)new UgstdSyncUserParam(ugstdIdSet, GrpUsrFromTypeEnum.TIME_SYNC, this.getPermLogReq()));
        if (0 == permResult.getCode()) {
            log.debug("\u7528\u6237\u7ec4\u540c\u6b65\u7528\u6237-\u5b9a\u65f6\u4efb\u52a1, \u540c\u6b65\u6210\u529f");
        } else {
            log.debug("\u7528\u6237\u7ec4\u540c\u6b65\u7528\u6237-\u5b9a\u65f6\u4efb\u52a1, \u540c\u6b65\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)permResult.getMsg());
        }
    }

    private PermLogReq getPermLogReq() {
        PermLogReq permLogReq = new PermLogReq();
        boolean enablePermLog = PermCommonUtil.isEnablePermLog();
        if (!enablePermLog) {
            permLogReq.setSignPermLog(Boolean.FALSE);
            return permLogReq;
        }
        permLogReq.setSignPermLog(Boolean.TRUE);
        PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"usergroup_syncbytime");
        permLogReq.setBusiFrom(null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
        permLogReq.setBusiType(null == permLogBusiType ? "" : permLogBusiType.getBusiType());
        permLogReq.setFormIdentity("sch_schedule");
        permLogReq.setOp("btnexecute");
        permLogReq.setOpbtn(ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c", (String)"UgStdSyncUserTimeTask_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        permLogReq.setInterfaceMethod("kd.bos.permission.formplugin.task.UgStdSyncUserTimeTask.execute");
        permLogReq.setOperTime(TimeServiceHelper.now());
        RequestContext requestContext = RequestContext.get();
        permLogReq.setClientType(requestContext.getClient());
        permLogReq.setClientIp(StringUtils.isEmpty((String)requestContext.getLoginIP()) ? "[0:0:0:0:0:0:0:1]" : requestContext.getLoginIP());
        return permLogReq;
    }
}

