/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.DataPermissionCache;
import kd.bos.permission.cache.DataRuleCache;
import kd.bos.permission.cache.FieldPermissionCache;
import kd.bos.permission.cache.OperationRuleObjCache;
import kd.bos.permission.cache.UserAppCache;
import kd.bos.permission.cache.UserHasPermDimObjCache;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.UserMenuCache;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.OrgUserHelper;
import kd.bos.permission.cache.model.PermUserRole;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.formplugin.plugin.UserAssignRolePlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.log.model.LogOldDataRule;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class UserAssignRoleTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(UserAssignRoleTask.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"UserAssignRoleTask", (int)2);
    private static final String MAY_CHANGED_DIMID = "mayChangedDimId";
    public static final String PGCACHE_HASLOAD_ORGIDS = "pageCache_HasLoadOrgIds";

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"UserAssignRoleTask_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        try {
            String pageId = (String)params.get("pageId");
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            IDataModel dataModel = view.getModel();
            this.checkSaveUserRoleDim(dataModel, params);
            desc = ResManager.loadKDString((String)"\u64cd\u4f5c\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u3002", (String)"UserAssignRoleTask_1", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 98;
            this.feedbackProgress(progress, desc, null);
        }
        catch (Exception e) {
            log.warn("UserAssignRoleTask.execute error", (Throwable)e);
            this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:%1$s", (String)"UserAssignRoleTask_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), e.getMessage()), null);
        }
    }

    private void userAssignRoleSave2PermLog(String op, String opbtn, String opItemId, String opItemNumber, String opItemName, String diffContent, Map<String, Object> params) {
        try {
            String appId = (String)params.get("appId");
            String cloudId = AppMetadataCache.getAppInfo((String)appId).getCloudId();
            String formNum = (String)params.get("formNum");
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"userassignrole_save");
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", BizAppServiceHelp.getAppIdByFormNum((String)formNum));
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.task.UserAssignRoleTask.userAssignRoleSave2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", diffContent);
            map.put("oper_id", Long.parseLong(params.get("oper_id").toString()));
            map.put("oper_org_id", Long.parseLong(params.get("oper_org_id").toString()));
            map.put("oper_time", TimeServiceHelper.now());
            map.put("client_type", params.get("client_type"));
            map.put("client_ip", params.get("client_ip"));
            map.put("client_name", params.get("client_name"));
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("UserAssignRoleTask.userAssignRoleSave2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private void clearDomainCache(Long userId, Map<String, Object> diffPURMap) {
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        userIds.add(userId);
        List<Object> appEntityAllList = new ArrayList(16);
        if (CollectionUtils.isEmpty(diffPURMap)) {
            return;
        }
        List delList = (List)diffPURMap.get("del");
        List addList = (List)diffPURMap.get("add");
        Set roleIds = delList.stream().map(PermUserRole::getFroleid).collect(Collectors.toSet());
        Set addRoleIdSet = addList.stream().map(PermUserRole::getFroleid).collect(Collectors.toSet());
        roleIds.addAll(addRoleIdSet);
        String langStr = RequestContext.get().getLang().name();
        if (!CollectionUtils.isEmpty(roleIds)) {
            HashSet<String> appEntityAllSet = new HashSet<String>(16);
            if (PermCommonUtil.hasEnableOldDataRule()) {
                for (String roleId : roleIds) {
                    List oldDataRuleList = PermRoleLogHelper.getOldDataRuleList((String)roleId, (String)langStr);
                    for (LogOldDataRule oldDataRule : oldDataRuleList) {
                        appEntityAllSet.add(oldDataRule.getAppId() + "|" + oldDataRule.getEntityId());
                    }
                }
            } else {
                for (String roleId : roleIds) {
                    LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)roleId, (String)langStr);
                    appEntityAllSet.addAll(newDataRule.getNewDRAppEntitySet());
                }
            }
            if (!CollectionUtils.isEmpty(appEntityAllSet)) {
                appEntityAllList = appEntityAllSet.stream().map(x -> {
                    String[] split = x.split("\\|", 2);
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    map.put(split[0], split[1]);
                    return map;
                }).collect(Collectors.toList());
            }
        }
        PermCommonUtil.cancelShowForm(userIds, appEntityAllList, (boolean)false);
    }

    protected void reloadCache(Long userId) {
        UserAppCache.removeCache((Long)userId);
        UserMenuCache.removeCache((Long)userId);
        UserHasPermOrgCache.clearUserLoginOrgs((Long)userId);
        UserHasPermDimObjCache.removeCache((Long)userId);
        FieldPermissionCache.removeAllCache();
        DataPermissionCache.removeAllCache();
        DataRuleCache.removeAllCache();
        OperationRuleObjCache.removeAllCache();
        CacheMrg.clearCache((String)CacheMrg.getType4UserDirectFunPermService());
        CacheMrg.clearCache((String)CacheMrg.getType4CommRoleFunPermService());
        CacheMrg.clearCache((String)CacheMrg.getType4UserHasPermItems());
    }

    private void checkSaveUserRoleDim(IDataModel dataModel, final Map<String, Object> params) {
        String systemTypeFormplugin = "bos-permission-formplugin";
        try {
            final DynamicObject u = (DynamicObject)dataModel.getValue("user");
            final Long uId = (Long)u.getPkValue();
            String userName = u.getString("name");
            Long adminId = RequestContext.get().getCurrUserId();
            if (adminId.equals(uId)) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743\u3002", (String)"UserAssignRoleTask_3", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return;
            }
            List robotIds = PermCommonUtil.getRobotIds();
            DynamicObjectCollection dimObjs = dataModel.getEntryEntity("list_org");
            int dimObjsSize = dimObjs.size();
            if (robotIds.contains(uId) && dimObjsSize > 0) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u901a\u8fc7\u201c\u901a\u7528\u89d2\u8272\u201d\u8fdb\u884c\u6388\u6743\u3002", (String)"UserAssignRoleTask_4", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return;
            }
            final String curCtrlTypeEntityNum = (String)params.get("curCtrlTypeEntityNum");
            String curCtrlTypeName = (String)params.get("curCtrlTypeName");
            Long urCount = OrgUserHelper.getCountByUserId((Long)uId, (String)curCtrlTypeEntityNum);
            if (0 == dimObjsSize && 0L == urCount) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"UserAssignRoleTask_5", (String)"bos-permission-formplugin", (Object[])new Object[]{curCtrlTypeName}), null);
                return;
            }
            String desc = ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u754c\u9762\u6570\u636e\u83b7\u53d6\u5b8c\u6bd5\uff0c\u51c6\u5907\u8fdb\u884c\u89e3\u6790\u3002", (String)"UserAssignRoleTask_6", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 10;
            this.feedbackProgress(progress, desc, null);
            final HashSet<String> roleIdSet = new HashSet<String>(8);
            final String pageId = (String)params.get("pageId");
            final Set<String> mayChangedDimIdSet = UserAssignRolePlugin.getMayChangedDimId(1, pageId);
            if (CollectionUtils.isEmpty(mayChangedDimIdSet)) {
                this.busiAfterSaveDimRole(uId, roleIdSet, pageId);
                return;
            }
            mayChangedDimIdSet.remove("null");
            final List mayChangedDimIdList = mayChangedDimIdSet.stream().map(Long::valueOf).collect(Collectors.toList());
            HashSet<String> checkDuplicRoleDimUser = new HashSet<String>(dimObjsSize);
            DynamicObject dimObj = null;
            String roleId = null;
            String roleName = null;
            Date starttime = null;
            Date endtime = null;
            Long dimObjId = null;
            String dimObjName = "";
            Boolean includeSubOrg = Boolean.FALSE;
            boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
            String curCtrlType = (String)params.get("curCtrlType");
            boolean isSingleOrg = PermFormCommonUtil.isSingleOrg(curCtrlType);
            boolean checkOrgDim = IsoDimHelper.checkOrgDim((String)curCtrlType);
            String dimObjFieldKey = "";
            boolean isOrgDimType = (Boolean)params.get("isOrgDimType");
            dimObjFieldKey = isOrgDimType ? "org_number" : "dim_num";
            final ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(dimObjsSize);
            for (int i = 0; i < dimObjsSize; ++i) {
                dataModel.setEntryCurrentRowIndex("list_org", i);
                dimObj = (DynamicObject)dimObjs.get(i);
                dimObjId = dimObj.getLong(dimObjFieldKey + "_id");
                if (!mayChangedDimIdList.contains(dimObjId)) continue;
                dimObjName = checkOrgDim ? dimObj.getString(dimObjFieldKey + ".name") : dimObj.getString("dim_name");
                DynamicObjectCollection roleCollection = dimObj.getDynamicObjectCollection("list_role");
                int roleColSize = roleCollection.size();
                if (0 == roleColSize && !isSingleOrg) {
                    String info = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u201c%2$s\u201d\u672a\u9009\u62e9\u901a\u7528\u89d2\u8272\u3002", (String)"UserAssignRoleTask_7", (String)"bos-permission-formplugin", (Object[])new Object[0]), String.valueOf(i + 1), dimObjName);
                    this.wrapFeedBack(false, "errorNotice", info, null);
                    return;
                }
                for (int j = 0; j < roleColSize; ++j) {
                    DynamicObject role;
                    DynamicObject role_ = (DynamicObject)roleCollection.get(j);
                    if (null == role_ || null == (role = role_.getDynamicObject("role_number"))) continue;
                    roleId = role.getString("id");
                    roleName = role.getString("name");
                    if (enableValidateTime) {
                        starttime = (Date)role_.get("starttime");
                        endtime = (Date)role_.get("endtime");
                        if (starttime != null && endtime != null && starttime.after(endtime)) {
                            this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u6743\u9650\u5206\u914d\u6709\u6548\u671f\u914d\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"UserAssignRoleTask_8", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                            return;
                        }
                    }
                    if (!checkDuplicRoleDimUser.add(roleId + curCtrlTypeEntityNum + dimObjId + uId)) {
                        this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u7528\u6237-%1$s-\u89d2\u8272\uff0c\u7528\u6237\uff1a%2$s\uff0c%3$s\uff1a%4$s\uff0c\u89d2\u8272\uff1a%5$s\u3002", (String)"UserAssignRoleTask_9", (String)systemTypeFormplugin, (Object[])new Object[0]), curCtrlTypeName, userName, curCtrlTypeName, dimObjName, roleName), null);
                        return;
                    }
                    includeSubOrg = role_.getBoolean("includesub");
                    String fisincludesuborg = null == includeSubOrg || includeSubOrg == false ? "0" : "1";
                    DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userrole_multype");
                    saveObj.set("itemclasstypefield", (Object)curCtrlTypeEntityNum);
                    saveObj.set("itemclass", (Object)dimObjId);
                    saveObj.set("includesuborg", (Object)fisincludesuborg);
                    saveObj.set("user", (Object)uId);
                    saveObj.set("role", (Object)roleId);
                    saveObj.set("source", (Object)"2");
                    saveObj.set("starttime", (Object)starttime);
                    saveObj.set("endtime", (Object)endtime);
                    saveList.add(saveObj);
                    roleIdSet.add(roleId);
                    desc = ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u754c\u9762\u4fe1\u606f\u89e3\u6790\u4e2d\u3002", (String)"UserAssignRoleTask_10", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                    progress = 10 + 10 / dimObjsSize * i;
                    this.feedbackProgress(progress, desc, null);
                }
            }
            desc = ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u754c\u9762\u4fe1\u606f\u89e3\u6790\u5b8c\u6bd5\uff0c\u8fdb\u884c\u6570\u636e\u5b58\u50a8\u3002", (String)"UserAssignRoleTask_11", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 20;
            this.feedbackProgress(progress, desc, null);
            if (this.isStop()) {
                this.stop();
            }
            Future future = pool.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ArrayList<Long> userIdList = new ArrayList<Long>();
                    userIdList.add(uId);
                    List preList = OrgUserHelper.getByDimAndOther(null, null, userIdList, (List)mayChangedDimIdList, (String)curCtrlTypeEntityNum);
                    UserAssignRoleTask.this.saveDimRole2DB(uId, mayChangedDimIdSet, saveList, params);
                    List afterList = OrgUserHelper.getByDimAndOther(null, null, userIdList, (List)mayChangedDimIdList, (String)curCtrlTypeEntityNum);
                    UserAssignRoleTask.this.busiAfterSaveDimRole(uId, roleIdSet, pageId);
                    Map diffPURMap = PermUserRole.logCompareMutiThread((List)preList, (List)afterList);
                    CacheMrg.clearAllCache();
                    UserAssignRoleTask.this.clearDomainCache(uId, diffPURMap);
                    if (PermCommonUtil.isEnablePermLog() && !CollectionUtils.isEmpty((Map)diffPURMap)) {
                        HashMap<String, Object> logMap = new HashMap<String, Object>(2);
                        logMap.put("langStr", RequestContext.get().getLang().name());
                        logMap.put("diffPURMap", CollectionUtils.isEmpty((Map)diffPURMap) ? new HashMap(1) : diffPURMap);
                        String userName = u.getString("name");
                        String userNumber = u.getString("number");
                        String opbtn = ConstantsHelper.getSave();
                        UserAssignRoleTask.this.userAssignRoleSave2PermLog("baritem_save", opbtn, String.valueOf(uId), userNumber, userName, StrUtil.compress((String)new ObjectMapper().writeValueAsString(logMap)), params);
                    }
                    return 1;
                }
            });
            Object o = null;
            int target = 98;
            while (progress < target) {
                try {
                    o = future.get(500L, TimeUnit.MILLISECONDS);
                    if (1 != (Integer)o) continue;
                    progress = target;
                }
                catch (InterruptedException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
                catch (TimeoutException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
            }
        }
        catch (Exception e) {
            log.warn("UserAssignRoleTask.saveDimUser error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private int dataSavingProgress(int progress, int target) {
        String desc = ResManager.loadKDString((String)"\u6570\u636e\u5b58\u50a8\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"UserAssignRoleTask_12", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        if (progress < target - 1) {
            ++progress;
        }
        this.feedbackProgress(progress, desc, null);
        return progress;
    }

    private void saveDimRole2DB(Long uId, Set<String> mayChangedDimIdSet, List<DynamicObject> saveList, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(saveList) && CollectionUtils.isEmpty(mayChangedDimIdSet)) {
            return;
        }
        String mayChangedDimIdStr = String.join((CharSequence)",", mayChangedDimIdSet);
        try (TXHandle txHandle = TX.required();){
            try {
                String curCtrlTypeEntityNum = (String)params.get("curCtrlTypeEntityNum");
                StringBuilder delSb = new StringBuilder();
                delSb.append("delete from t_perm_userrole where froleid > ' ' ");
                delSb.append(" and fdimtype ='").append(curCtrlTypeEntityNum).append("' and fisincludesuborg in ('0','1')");
                delSb.append(" and fuserid = ").append(uId);
                delSb.append(" and forgid in (").append(mayChangedDimIdStr).append(")");
                DB.execute((DBRoute)DBRoute.base, (String)delSb.toString());
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.warn("UserAssignRoleTask.saveDimRole2DB error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    private void busiAfterSaveDimRole(Long uId, Set<String> roleIdSet, String pageId) {
        Map appEntityMap = PermissionServiceHelper.getAppEntityByRoleSet(roleIdSet);
        LicenseServiceHelper.addUserLicGroupByBizAppAndBizObj((Long)uId, (Map)appEntityMap);
        String type = CacheMrg.getType4UserRoleDim();
        String key = "mayChangedDimId_" + pageId;
        CacheMrg.clearCache((String)type, (String)key);
        this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserAssignRoleTask_13", (String)"bos-permission-formplugin", (Object[])new Object[0]), 3000);
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }
}

