/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.DataPermissionCache;
import kd.bos.permission.cache.DataRuleCache;
import kd.bos.permission.cache.FieldPermissionCache;
import kd.bos.permission.cache.UserAppCache;
import kd.bos.permission.cache.UserHasPermDimObjCache;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.UserMenuCache;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.log.helper.PermDirectLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class UserCopyPermTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(UserCopyPermTask.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"UserCopyPermTask", (int)1);

    public void execute(RequestContext rc, final Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"UserCopyPermTask_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        try {
            desc = ResManager.loadKDString((String)"\u6d89\u53ca\u6570\u636e\u51c6\u5907\u5b8c\u6bd5\uff0c\u5f00\u59cb\u83b7\u53d6\u754c\u9762\u6570\u636e\u3002", (String)"UserCopyPermTask_1", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 5;
            this.feedbackProgress(progress, desc, null);
            desc = ResManager.loadKDString((String)"\u754c\u9762\u6570\u636e\u83b7\u53d6\u5b8c\u6bd5\uff0c\u51c6\u5907\u8fdb\u884c\u89e3\u6790\u3002", (String)"UserCopyPermTask_2", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 10;
            this.feedbackProgress(progress, desc, null);
            desc = ResManager.loadKDString((String)"\u754c\u9762\u4fe1\u606f\u89e3\u6790\u5b8c\u6bd5\uff0c\u8fdb\u884c\u6570\u636e\u5b58\u50a8\u3002", (String)"UserCopyPermTask_3", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 20;
            this.feedbackProgress(progress, desc, null);
            if (this.isStop()) {
                this.stop();
            }
            Future future = pool.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    boolean isCopyUserperm = (Boolean)params.get("isCopyUserperm");
                    boolean isCopyRole = (Boolean)params.get("isCopyRole");
                    boolean isCopyBizRole = (Boolean)params.get("isCopyBizRole");
                    boolean isCopyDisfunperm = (Boolean)params.get("isCopyDisfunperm");
                    String sourceUserId = (String)params.get("sourceUserId");
                    List targetUserIdList = (List)params.get("targetUserIdSet");
                    PermissionServiceHelper.copyUserPermission((long)Long.parseLong(sourceUserId), targetUserIdList.stream().map(Long::parseLong).collect(Collectors.toList()), (boolean)isCopyUserperm, (boolean)isCopyRole, (boolean)isCopyBizRole, (boolean)isCopyDisfunperm, (StringBuilder)new StringBuilder());
                    UserCopyPermTask.this.busiAfterSave(params);
                    return 1;
                }
            });
            Object o = null;
            int target = 98;
            while (progress < target) {
                try {
                    o = future.get(500L, TimeUnit.MILLISECONDS);
                    if (1 != (Integer)o) continue;
                    progress = target;
                }
                catch (InterruptedException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
                catch (TimeoutException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
            }
            desc = ResManager.loadKDString((String)"\u64cd\u4f5c\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u3002", (String)"UserCopyPermTask_4", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 98;
            this.feedbackProgress(progress, desc, null);
        }
        catch (Exception e) {
            log.warn("UserCopyPermTask.execute error", (Throwable)e);
            this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:%1$s", (String)"UserCopyPermTask_5", (String)"bos-permission-formplugin", (Object[])new Object[0]), e.getMessage()), null);
        }
    }

    private int dataSavingProgress(int progress, int target) {
        String desc = ResManager.loadKDString((String)"\u6570\u636e\u5b58\u50a8\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"UserCopyPermTask_6", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        if (progress < target - 1) {
            ++progress;
        }
        this.feedbackProgress(progress, desc, null);
        return progress;
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }

    private void busiAfterSave(Map<String, Object> params) throws Exception {
        String sourceUserId = (String)params.get("sourceUserId");
        String userName = (String)params.get("userName");
        String userNumber = (String)params.get("userNumber");
        List targetUserIdList = (List)params.get("targetUserIdSet");
        boolean isCopyUserperm = (Boolean)params.get("isCopyUserperm");
        boolean isCopyRole = (Boolean)params.get("isCopyRole");
        boolean isCopyBizRole = (Boolean)params.get("isCopyBizRole");
        boolean isCopyDisfunperm = (Boolean)params.get("isCopyDisfunperm");
        List<Long> targetUserIds = targetUserIdList.stream().map(Long::valueOf).collect(Collectors.toList());
        this.reloadCache(targetUserIds);
        if (PermCommonUtil.isEnablePermLog()) {
            String langStr = RequestContext.get().getLang().name();
            String afterData = PermDirectLogHelper.copyPermSaveImage((Long)Long.valueOf(sourceUserId), (String)langStr, (boolean)true, targetUserIds, (boolean)isCopyRole, (boolean)isCopyBizRole, (boolean)isCopyDisfunperm, (boolean)isCopyUserperm);
            String opbtn = ConstantsHelper.getSave();
            this.copyPermSave2PermLog("btnsave", opbtn, String.valueOf(sourceUserId), userNumber, userName, "", afterData, params);
        }
        this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserCopyPermTask_7", (String)"bos-permission-formplugin", (Object[])new Object[0]), 3000);
    }

    private void copyPermSave2PermLog(String op, String opbtn, String opItemId, String opItemNumber, String opItemName, String preData, String afterData, Map<String, Object> params) {
        try {
            String formNum = (String)params.get("formNum");
            String appIdByFormNum = (String)params.get("appIdByFormNum");
            String cloudId = (String)params.get("cloudId");
            HashMap<String, Object> map = new HashMap<String, Object>(32);
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"usercopyperm_save");
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appIdByFormNum);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.task.UserCopyPermTask.copyPermSave2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("pre_data", preData);
            map.put("after_data", afterData);
            map.put("oper_id", Long.parseLong(params.get("oper_id").toString()));
            map.put("oper_org_id", Long.parseLong(params.get("oper_org_id").toString()));
            map.put("oper_time", TimeServiceHelper.now());
            map.put("client_type", params.get("client_type"));
            map.put("client_ip", params.get("client_ip"));
            map.put("client_name", params.get("client_name"));
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("UserCopyPermTask.copyPermSave2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private void reloadCache(List<Long> targetUserIds) {
        if (targetUserIds.size() <= 5) {
            for (Long userId : targetUserIds) {
                UserMenuCache.removeCache((Long)userId);
            }
            UserAppCache.removeCache(targetUserIds);
            UserHasPermDimObjCache.removeCache(targetUserIds);
        } else {
            UserAppCache.removeUserAppCache();
            UserMenuCache.removeUserMenuAllCache();
            UserHasPermDimObjCache.removeAllCache();
        }
        FieldPermissionCache.removeAllCache();
        DataPermissionCache.removeAllCache();
        DataRuleCache.removeAllCache();
        UserHasPermOrgCache.clearUserLoginOrgs(targetUserIds);
        PermCommonUtil.cancelShowForm(targetUserIds, null, (boolean)true);
    }
}

