/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.task;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.DataPermissionCache;
import kd.bos.permission.cache.DataRuleCache;
import kd.bos.permission.cache.FieldPermissionCache;
import kd.bos.permission.cache.UserAppCache;
import kd.bos.permission.cache.UserHasPermDimObjCache;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.UserMenuCache;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.DimNewDrWrapperHelper;
import kd.bos.permission.cache.helper.DirectAuthorizeHelper;
import kd.bos.permission.cache.helper.DrHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.formplugin.bean.UserBdPropRuleBean;
import kd.bos.permission.formplugin.bean.UserDataRuleBean;
import kd.bos.permission.formplugin.bean.UserDataRuleDimBean;
import kd.bos.permission.formplugin.bean.UserPermItemRuleBean;
import kd.bos.permission.formplugin.enumeration.DataStatus;
import kd.bos.permission.formplugin.util.AllFuncPermTreeUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.formplugin.util.PermPageCacheUtil;
import kd.bos.permission.formplugin.util.UserFuncPermTreeUtil;
import kd.bos.permission.log.helper.PermDirectLogHelper;
import kd.bos.permission.log.model.LogDimField;
import kd.bos.permission.log.model.LogDimFunc;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.permission.model.perm.DimNewDrWrapper;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class UserDirectAssignPermTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(UserDirectAssignPermTask.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"UserDirectAssignPermTask", (int)1);
    private static String systemTypeFormplugin = "bos-permission-formplugin";
    private static final String DIRECT_MAY_CHANGED_DIMID = "directMayChangedDimId";

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"UserDirectAssignPermTask_0", (String)systemTypeFormplugin, (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        try {
            this.dealMainBusi(params);
            desc = ResManager.loadKDString((String)"\u64cd\u4f5c\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u3002", (String)"UserDirectAssignPermTask_1", (String)systemTypeFormplugin, (Object[])new Object[0]);
            int progress = 98;
            this.feedbackProgress(progress, desc, null);
        }
        catch (Exception e) {
            log.warn("UserCopyPermTask.execute error", (Throwable)e);
            this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"UserDirectAssignPermTask_2", (String)systemTypeFormplugin, (Object[])new Object[0]), e.getMessage()), null);
        }
    }

    private void dealMainBusi(Map<String, Object> params) throws Exception {
        String pageId = (String)params.get("pageId");
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
        IDataModel dataModel = view.getModel();
        DynamicObject user = (DynamicObject)dataModel.getValue("user");
        Long uId = user.getLong("id");
        try {
            String desc = ResManager.loadKDString((String)"\u542f\u52a8\u4e1a\u52a1\u64cd\u4f5c\u57fa\u672c\u6821\u9a8c\u3002", (String)"UserDirectAssignPermTask_3", (String)systemTypeFormplugin, (Object[])new Object[0]);
            int progress = 2;
            this.feedbackProgress(progress, desc, null);
            if (null == uId || 0L == uId) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25:\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728", (String)"UserDirectAssignPermTask_4", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return;
            }
            Long adminId = RequestContext.get().getCurrUserId();
            if (adminId.equals(uId)) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u6388\u6743", (String)"UserDirectAssignPermTask_5", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return;
            }
            String curCtrlTypeEntNum = (String)params.get("curCtrlTypeEntNum");
            String curCtrlTypeName = (String)params.get("curCtrlTypeName");
            DynamicObjectCollection dimObjs = dataModel.getEntryEntity("orglist");
            int dimObjsSize = dimObjs.size();
            Long urCount = DirectAuthorizeHelper.getCountByUserId((Long)uId, (String)curCtrlTypeEntNum);
            if (0 == dimObjsSize && 0L == urCount) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"UserDirectAssignPermTask_6", (String)"bos-permission-formplugin", (Object[])new Object[]{curCtrlTypeName}), null);
                return;
            }
            if (!this.checkDataRuleCanSave(params, view)) {
                return;
            }
            Set<String> finalMayChangedDimId = this.getFinalMayChangedDimIds(params, view);
            finalMayChangedDimId.remove("null");
            if (kd.bos.util.CollectionUtils.isEmpty(finalMayChangedDimId)) {
                this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserDirectAssignPermTask_7", (String)systemTypeFormplugin, (Object[])new Object[0]), 3000);
                return;
            }
            desc = ResManager.loadKDString((String)"\u4e1a\u52a1\u64cd\u4f5c\u57fa\u672c\u6821\u9a8c\u5b8c\u6bd5\uff0c\u51c6\u5907\u83b7\u53d6\u3010\u529f\u80fd\u6743\u9650\u3011\u6570\u636e\u5e76\u89e3\u6790\u3002", (String)"UserDirectAssignPermTask_8", (String)systemTypeFormplugin, (Object[])new Object[0]);
            progress = 5;
            this.feedbackProgress(progress, desc, null);
            PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
            String appNum = permPageCacheUtil.get("FormShowParam_appNum");
            TreeView funcPermTreeView = (TreeView)view.getControl("tree_funcperm");
            TreeView fieldPermTreeView = (TreeView)view.getControl("tree_fieldperm");
            TreeView dataPermTreeView = (TreeView)view.getControl("tree_dataperm");
            String curCtrlType = (String)params.get("curCtrlType");
            String detailDimType = PermCommonUtil.getSuitableDimType((String)curCtrlType)[1];
            long[] mainFIds = DB.genLongIds((String)"t_perm_userperm", (int)dimObjsSize);
            boolean checkOrgDim = IsoDimHelper.checkOrgDim((String)curCtrlType);
            boolean isSingleOrg = PermFormCommonUtil.isSingleOrg(curCtrlType);
            DynamicObject dimObj = null;
            String dimObjName = "";
            ArrayList<Future> busiFutureList = new ArrayList<Future>(dimObjsSize);
            ArrayList<Object[]> mParamList = new ArrayList<Object[]>(5);
            Object[] mParamObj = null;
            for (int i = 0; i < dimObjsSize; ++i) {
                dimObj = (DynamicObject)dimObjs.get(i);
                if (null == dimObj) {
                    this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684%2$s\u4e3a\u7a7a\u3002", (String)"UserDirectAssignPermTask_9", (String)systemTypeFormplugin, (Object[])new Object[0]), i, curCtrlTypeName), null);
                    return;
                }
                String curDimObjIdStr = this.getCurDimObjIdStr(checkOrgDim, dimObj, curCtrlType);
                Long curDimObjId = Long.parseLong(curDimObjIdStr);
                if (!finalMayChangedDimId.contains(curDimObjIdStr)) continue;
                dimObjName = checkOrgDim ? dimObj.getDynamicObject("org_number").getString("name") : dimObj.getString("dim_name");
                String cacheKey = "nodeMap" + '$' + curDimObjId;
                Map<String, List<String>> nodeMap = UserFuncPermTreeUtil.getTreeCacheNodeMap(permPageCacheUtil, cacheKey, null);
                if (null == nodeMap || nodeMap.isEmpty()) {
                    if (isSingleOrg) continue;
                    this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"%1$s\u5217\u8868\u7b2c%2$s\u884c\u7684\u201c%3$s\u201d\u672a\u5206\u914d\u529f\u80fd\u6743\u9650\u3002", (String)"UserDirectAssignPermTask_10", (String)systemTypeFormplugin, (Object[])new Object[0]), PermCommonUtil.getDimTypeName((String)curCtrlType), String.valueOf(i + 1), dimObjName), null);
                    return;
                }
                boolean includeSubOrg = dimObj.getBoolean("org_include_sub_org");
                String mainFId = String.valueOf(mainFIds[i]);
                HashMap<String, Object> paraMap = new HashMap<String, Object>(16);
                paraMap.put("uId", uId);
                paraMap.put("appNum", appNum);
                paraMap.put("curDimObjId", curDimObjId);
                paraMap.put("includeSubOrg", includeSubOrg);
                paraMap.put("detailDimType", detailDimType);
                paraMap.put("funcPermTreeView", funcPermTreeView);
                paraMap.put("fieldPermTreeView", fieldPermTreeView);
                paraMap.put("dataPermTreeView", dataPermTreeView);
                paraMap.put("finalMayChangedDimId", finalMayChangedDimId);
                paraMap.put("dimObjName", dimObjName);
                paraMap.put("index", i);
                paraMap.put("mainFId", mainFId);
                TreeView allFuncPermTreeView = (TreeView)view.getControl("tree_allfunctionperm");
                paraMap.put("allFuncPermTreeView", allFuncPermTreeView);
                paraMap.put("curCtrlType", curCtrlType);
                busiFutureList.add(pool.submit(this.wrapDetailParamCallable(paraMap)));
                mParamObj = new Object[]{mainFId, uId, curDimObjId, includeSubOrg, curCtrlType};
                mParamList.add(mParamObj);
                desc = ResManager.loadKDString((String)"\u3010\u529f\u80fd\u6743\u9650\u3011\u6570\u636e\u89e3\u6790\u4e2d\u3002", (String)"UserDirectAssignPermTask_11", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                progress = 5 + 20 / dimObjsSize * i;
                this.feedbackProgress(progress, desc, null);
            }
            LinkedList<Object[]> dParamList = new LinkedList<Object[]>();
            HashMap appEntityTempMap = new HashMap(dimObjsSize);
            for (Future busiFuture : busiFutureList) {
                Map futureMap = (Map)busiFuture.get();
                String busiCheckMsg = (String)futureMap.get("busiCheckMsg");
                if (StringUtils.isNotEmpty((String)busiCheckMsg)) {
                    view.showErrorNotification(busiCheckMsg);
                    return;
                }
                List dParamList_future = (List)futureMap.get("dParamList");
                dParamList.addAll(dParamList_future);
                Map appEntityMap_future = (Map)futureMap.get("appEntityMap");
                appEntityTempMap.putAll(appEntityMap_future);
            }
            Map allCloudMap = AppHelper.getAllCloudMap();
            Map allAppIdNameMap = AppHelper.getAllAppIdNameMap();
            String langStr = RequestContext.get().getLang().name();
            Map entityNameMap = FormHelper.getAllEntityNameMap((String)langStr);
            Map allPermitemMap = PermItemHelper.getAllPermItemIdNameMap();
            List<Long> collect = finalMayChangedDimId.parallelStream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
            Map dimMap = IsoDimHelper.getDimMap(collect, (String)detailDimType);
            Map permCtrlTypeMap = IsoDimHelper.getPermCtrlTypeMap((String)langStr);
            Map dimTypeMap = (Map)permCtrlTypeMap.get(detailDimType);
            String dimTypeName = (String)dimTypeMap.get("fname");
            desc = ResManager.loadKDString((String)"\u3010\u529f\u80fd\u6743\u9650\u3011\u6570\u636e\u89e3\u6790\u5b8c\u6bd5\uff0c\u51c6\u5907\u8fdb\u884c\u6570\u636e\u5b58\u50a8\u3002", (String)"UserDirectAssignPermTask_12", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 25;
            this.feedbackProgress(progress, desc, null);
            if (this.isStop()) {
                this.stop();
            }
            List preFuncPermList = PermDirectLogHelper.getFuncPermList((Long)uId, finalMayChangedDimId, (String)detailDimType, (Map)allCloudMap, (Map)allAppIdNameMap, (Map)entityNameMap, (Map)allPermitemMap, (Map)dimMap, (String)dimTypeName);
            this.saveFuncPerm2DB(uId, detailDimType, finalMayChangedDimId, mParamList, dParamList, params);
            List afterFuncPermList = PermDirectLogHelper.getFuncPermList((Long)uId, finalMayChangedDimId, (String)detailDimType, (Map)allCloudMap, (Map)allAppIdNameMap, (Map)entityNameMap, (Map)allPermitemMap, (Map)dimMap, (String)dimTypeName);
            Map diffDimFuncMap = LogDimFunc.logCompareMutiThread((List)preFuncPermList, (List)afterFuncPermList);
            HashMap<String, Object> permLogMap = new HashMap<String, Object>(3);
            permLogMap.put("diffDimFuncMap", diffDimFuncMap);
            this.notifyTooMuchAssignPerm(view);
            this.clearDimObjPageCache(collect, view);
            if (null != appEntityTempMap && !appEntityTempMap.isEmpty()) {
                HashMap appEntityMap = new HashMap(appEntityTempMap.size());
                for (Map.Entry entry : appEntityTempMap.entrySet()) {
                    appEntityMap.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
                }
                LicenseServiceHelper.addUserLicGroupByBizAppAndBizObj((Long)uId, appEntityMap);
            }
            desc = ResManager.loadKDString((String)"\u3010\u529f\u80fd\u6743\u9650\u3011\u5904\u7406\u5b8c\u6bd5\uff0c\u5f00\u59cb\u5904\u7406\u3010\u5b57\u6bb5\u6743\u9650\u3011\u3002", (String)"UserDirectAssignPermTask_13", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 33;
            this.feedbackProgress(progress, desc, null);
            List<Long> forDelDimObjIds = finalMayChangedDimId.stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
            List preFieldPermList = PermDirectLogHelper.getFieldPermList((Long)uId, finalMayChangedDimId, (String)curCtrlType, (Map)allCloudMap, (Map)allAppIdNameMap, (Map)entityNameMap, (Map)dimMap, (String)dimTypeName);
            this.saveFieldPerm(uId, forDelDimObjIds, view, params);
            List afterFieldPermList = PermDirectLogHelper.getFieldPermList((Long)uId, finalMayChangedDimId, (String)curCtrlType, (Map)allCloudMap, (Map)allAppIdNameMap, (Map)entityNameMap, (Map)dimMap, (String)dimTypeName);
            Map diffDimFieldMap = LogDimField.logCompareMutiThread((List)preFieldPermList, (List)afterFieldPermList);
            permLogMap.put("diffDimFieldMap", diffDimFieldMap);
            desc = ResManager.loadKDString((String)"\u3010\u5b57\u6bb5\u6743\u9650\u3011\u5904\u7406\u5b8c\u6bd5\uff0c\u5f00\u59cb\u5904\u7406\u3010\u6570\u636e\u89c4\u5219\u3011\u3002", (String)"UserDirectAssignPermTask_14", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 60;
            this.feedbackProgress(progress, desc, null);
            boolean hasEnableOldDataRule = (Boolean)params.get("hasEnableOldDataRule");
            if (hasEnableOldDataRule) {
                Set preDimId = preFuncPermList.stream().map(x -> x.getDimId()).collect(Collectors.toSet());
                Set afterDimId = afterFuncPermList.stream().map(x -> x.getDimId()).collect(Collectors.toSet());
                List realDelDimIds = ListUtil.removeAll(new LinkedList(preDimId), new LinkedList(afterDimId));
                this.saveDataPerm(realDelDimIds, view, params);
            } else {
                Map allDrDetailMap = DrHelper.getAllDrDetailMap();
                HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
                String uIdStr = String.valueOf(uId);
                paraMap.put("userIdSet", Sets.newHashSet((Object[])new String[]{uIdStr}));
                paraMap.put("allDrDetailMap", allDrDetailMap);
                Map preDimNewDrWrapperMap = DimNewDrWrapperHelper.getUserIdDimNewDrWrapperMapByUser(paraMap);
                this.saveDataRule(uId, view, params);
                Map afterDimNewDrWrapperMap = DimNewDrWrapperHelper.getUserIdDimNewDrWrapperMapByUser(paraMap);
                Map diffDrAndPrMap = DimNewDrWrapperHelper.compare((DimNewDrWrapper)((DimNewDrWrapper)preDimNewDrWrapperMap.get(uIdStr)), (DimNewDrWrapper)((DimNewDrWrapper)afterDimNewDrWrapperMap.get(uIdStr)));
                permLogMap.put("diffDrAndPrMap", diffDrAndPrMap);
            }
            desc = ResManager.loadKDString((String)"\u3010\u6570\u636e\u89c4\u5219\u3011\u5904\u7406\u5b8c\u6bd5\uff0c\u5f00\u59cb\u6267\u884c\u540e\u7eed\u4e1a\u52a1\u903b\u8f91\u3002", (String)"UserDirectAssignPermTask_15", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 80;
            this.feedbackProgress(progress, desc, null);
            this.signPermLog(permLogMap, "baritem_save", user, view);
            this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserDirectAssignPermTask_7", (String)systemTypeFormplugin, (Object[])new Object[0]), 3000);
        }
        catch (Exception e) {
            log.warn("UserDirectAssignPermTask.dealMainBusi error", (Throwable)e);
            String name = user.getString("name");
            String number = user.getString("number");
            String formNum = dataModel.getDataEntityType().getName();
            String curLogAppId = AppHelper.getCurAppId((String)formNum, (String)view.getFormShowParameter().getAppId());
            MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u76f4\u63a5\u6388\u6743", "UserDirectAssignPermTask_16", "bos-permission-formplugin");
            MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5bf9\u7528\u6237\uff1a%1$s\uff0c\u76f4\u63a5\u6388\u6743\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", "UserDirectAssignPermMultiTask_15", "bos-permission-formplugin");
            String[] opDescParam = new String[]{name};
            String oldOpDescription = String.format(ResManager.loadKDString((String)"\u5bf9\u7528\u6237\uff1a%1$s\uff0c\u76f4\u63a5\u6388\u6743\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"UserDirectAssignPermMultiTask_15", (String)"bos-permission-formplugin", (Object[])new Object[0]), name);
            PermCommonUtil.addLog(null, null, (String)formNum, (String)number, (String)"0", (String)"save", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
            this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"UserDirectAssignPermTask_2", (String)systemTypeFormplugin, (Object[])new Object[0]), e.getMessage()), null);
            throw e;
        }
    }

    private void signPermLog(Map<String, Object> permLogMap, String itemKey, DynamicObject user, IFormView view) {
        try {
            Map diffDimFuncMap = (Map)permLogMap.get("diffDimFuncMap");
            Map diffDimFieldMap = (Map)permLogMap.get("diffDimFieldMap");
            Map diffDrAndPrMap = (Map)permLogMap.get("diffDrAndPrMap");
            if (!(!PermCommonUtil.isEnablePermLog() || CollectionUtils.isEmpty((Map)diffDimFuncMap) && CollectionUtils.isEmpty((Map)diffDimFieldMap) && CollectionUtils.isEmpty((Map)diffDrAndPrMap))) {
                Long userId = user.getLong("id");
                permLogMap.put("langStr", RequestContext.get().getLang().name());
                permLogMap.put("influenceUsers", Collections.singletonList(String.valueOf(userId)));
                String userName = user.getString("name");
                String userNumber = user.getString("number");
                String opbtn = ConstantsHelper.getSave();
                this.userDirectSave2PermLog(itemKey, opbtn, String.valueOf(userId), userNumber, userName, StrUtil.compress((String)new ObjectMapper().writeValueAsString(permLogMap)), view);
            }
        }
        catch (Exception e) {
            log.warn("UserDirectAssignPermTask.signPermLog error", (Throwable)e);
        }
    }

    private void userDirectSave2PermLog(String op, String opbtn, String opItemId, String opItemNumber, String opItemName, String diffContent, IFormView view) {
        try {
            IDataModel iDataModel = view.getModel();
            String formNum = iDataModel.getDataEntityType().getName();
            String appIdByFormNum = BizAppServiceHelp.getAppIdByFormNum((String)formNum);
            String appId = StringUtils.isEmpty((String)view.getFormShowParameter().getAppId()) ? appIdByFormNum : view.getFormShowParameter().getAppId();
            String cloudId = AppMetadataCache.getAppInfo((String)appId).getCloudId();
            HashMap<String, Object> map = new HashMap<String, Object>(32);
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"userdirect_save");
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appIdByFormNum);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.plugin.UserDirectAssignPermTask.userDirectSave2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", diffContent);
            map.put("oper_id", RequestContext.get().getCurrUserId());
            map.put("oper_org_id", RequestContext.get().getOrgId());
            map.put("client_type", RequestContext.get().getClient());
            map.put("client_ip", RequestContext.get().getLoginIP());
            map.put("client_name", RequestContext.get().getClient());
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("UserDirectAssignPermTask.userDirectSave2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private void clearUsrDireFunMayChangedDimId(String pageId) {
        String type = CacheMrg.getType4UserDirectFunPerm();
        String key = "directMayChangedDimId_" + pageId;
        CacheMrg.clearCache((String)type, (String)key);
    }

    private void setDataChanged(boolean changed, IFormView view) {
        IDataModel iDataModel = view.getModel();
        iDataModel.setDataChanged(changed);
        iDataModel.getDataEntity().getDataEntityState().setRemovedItems(Boolean.valueOf(changed));
    }

    private List<String> getDimObjIdsFromFsp(IFormView view) {
        ArrayList<String> resultList = new ArrayList<String>();
        String dimObjIds = (String)view.getFormShowParameter().getCustomParam("FormShowParam_dimensionObjIds");
        if (StringUtils.isNotEmpty((String)dimObjIds)) {
            String[] arrDimObjId;
            for (String dimObjId : arrDimObjId = dimObjIds.split(",")) {
                if (StringUtils.isEmpty((String)dimObjId)) continue;
                dimObjId = dimObjId.trim();
                resultList.add(dimObjId);
            }
        }
        return resultList;
    }

    private DynamicObject[] loadFuncPermDimObjInfo(Long userId, IFormView view, Map<String, Object> inParams) {
        String curCtrlType = (String)inParams.get("curCtrlType");
        StringBuilder sbSeletedField = new StringBuilder().append("id").append(", ").append("org").append(", ").append("includesuborg");
        List<String> dimObjStrIds = this.getDimObjIdsFromFsp(view);
        List dimObjIds = dimObjStrIds.stream().map(Long::valueOf).collect(Collectors.toList());
        QFilter[] arrQFilter = null;
        arrQFilter = dimObjIds != null && dimObjIds.size() > 0 ? new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("dimtype", "=", (Object)curCtrlType), new QFilter("org", "in", dimObjIds)} : new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("dimtype", "=", (Object)curCtrlType)};
        DynamicObject[] arrUserPermObj = BusinessDataServiceHelper.load((String)"perm_userperm", (String)sbSeletedField.toString(), (QFilter[])arrQFilter);
        arrUserPermObj = this.filterDimObjId(arrUserPermObj, inParams);
        return arrUserPermObj;
    }

    private DynamicObject[] filterDimObjId(DynamicObject[] arrUserPermObj, Map<String, Object> inParams) {
        if (arrUserPermObj == null || arrUserPermObj.length == 0) {
            return new DynamicObject[0];
        }
        int arrUserPermObjLength = arrUserPermObj.length;
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(arrUserPermObjLength);
        ArrayList<Long> tempIdList = new ArrayList<Long>(arrUserPermObjLength);
        for (int i = 0; i < arrUserPermObjLength; ++i) {
            DynamicObject tempDObj = arrUserPermObj[i];
            newList.add(tempDObj);
            String dimObjId = tempDObj.getString("org_id");
            tempIdList.add(Long.parseLong(dimObjId));
        }
        String curCtrlTypeEntNum = (String)inParams.get("curCtrlTypeEntNum");
        DynamicObject[] existArray = BusinessDataServiceHelper.load((String)curCtrlTypeEntNum, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", tempIdList)});
        ArrayList<DynamicObject> existList = new ArrayList<DynamicObject>(existArray.length);
        for (DynamicObject existObj : existArray) {
            existList.add(existObj);
        }
        Iterator iterator = newList.iterator();
        while (iterator.hasNext()) {
            DynamicObject curObj = (DynamicObject)iterator.next();
            String curId = curObj.getString("org_id");
            boolean ifFound = false;
            Iterator iterator2 = existList.iterator();
            while (iterator2.hasNext()) {
                DynamicObject existObj = (DynamicObject)iterator2.next();
                String existId = existObj.getString("id");
                if (!curId.equals(existId)) continue;
                iterator2.remove();
                ifFound = true;
                break;
            }
            if (ifFound) continue;
            iterator.remove();
        }
        DynamicObject[] result = newList.toArray(new DynamicObject[0]);
        return result;
    }

    private void refreshDimObjList(IFormView view, Map<String, Object> inParams) {
        boolean funPermDimObjInfoNotEmpty;
        Long selId = this.getCurSelDimObjId(view);
        IDataModel iDataModel = view.getModel();
        Long userId = ((DynamicObject)iDataModel.getValue("user")).getLong("id");
        DynamicObject[] funcPermDimObjInfo = this.loadFuncPermDimObjInfo(userId, view, inParams);
        HashSet<Long> dimObjIdsFromDB = new HashSet<Long>(8);
        boolean bl = funPermDimObjInfoNotEmpty = funcPermDimObjInfo != null && funcPermDimObjInfo.length > 0;
        if (funPermDimObjInfoNotEmpty) {
            for (DynamicObject dObj : funcPermDimObjInfo) {
                Long dimObjId = dObj.getLong("org_id");
                dimObjIdsFromDB.add(dimObjId);
            }
        }
        if (!dimObjIdsFromDB.contains(selId)) {
            this.clearDimObjList(view);
            if (funPermDimObjInfoNotEmpty) {
                this.fillDimObjList(funcPermDimObjInfo, view, inParams);
            }
            this.selectDimObjListRow(0, view);
        }
    }

    private void selectDimObjListRow(int rowIndex, IFormView view) {
        EntryGrid eg = (EntryGrid)view.getControl(this.getLeftEntryControlKey());
        IDataModel iDataModel = view.getModel();
        int entryCount = iDataModel.getEntryRowCount(this.getLeftEntryControlKey());
        if (entryCount == 0 || rowIndex + 1 > entryCount) {
            return;
        }
        eg.selectRows(rowIndex);
        eg.getEntryState().selectRow(rowIndex);
        eg.getEntryState().setFocusRow(rowIndex);
        eg.entryRowClick(Integer.valueOf(rowIndex));
    }

    private String getLeftEntryControlKey() {
        return "orglist";
    }

    private void fillDimObjList(DynamicObject[] funcPermInfo, IFormView view, Map<String, Object> inParams) {
        String curCtrlTypeEntNum = (String)inParams.get("curCtrlTypeEntNum");
        String curCtrlTypeFieldKey = (String)inParams.get("curCtrlTypeFieldKey");
        IDataModel model = view.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("orglist", funcPermInfo.length);
        List list = Arrays.stream(funcPermInfo).sorted(Comparator.comparing(x -> x.getLong("org_id"))).collect(Collectors.toList());
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject curDimObjInfo = (DynamicObject)list.get(i);
            model.setValue("org_id", curDimObjInfo.get("org_id"), i);
            model.setValue("dimentitynum", (Object)curCtrlTypeEntNum, i);
            model.setValue(curCtrlTypeFieldKey, curDimObjInfo.get("org_id"), i);
            DynamicObject dimObj = (DynamicObject)model.getValue(curCtrlTypeFieldKey, i);
            model.setValue("dim_name", (Object)dimObj.getString("name"), i);
            model.setValue("org_include_sub_org", curDimObjInfo.get("includesuborg"), i);
        }
        model.endInit();
        view.updateView("orglist");
    }

    private void clearDimObjList(IFormView view) {
        IDataModel iDataModel = view.getModel();
        iDataModel.deleteEntryData("orglist");
    }

    private void reloadCache(Long userId) {
        UserAppCache.removeCache((Long)userId);
        UserMenuCache.removeCache((Long)userId);
        UserHasPermOrgCache.clearUserLoginOrgs((Long)userId);
        UserHasPermDimObjCache.removeCache((Long)userId);
        FieldPermissionCache.removeAllCache();
        DataPermissionCache.removeAllCache();
        DataRuleCache.removeAllCache();
        CacheMrg.clearCache((String)CacheMrg.getType4UserDirectFunPermService());
        CacheMrg.clearCache((String)CacheMrg.getType4UserHasPermItems());
    }

    private UserDataRuleBean getUserDataRuleBeanFromData(IFormView view, Map<String, Object> inParams) {
        String curCtrlTypeEntNum = (String)inParams.get("curCtrlTypeEntNum");
        IDataModel iDataModel = view.getModel();
        Long userId = ((DynamicObject)iDataModel.getValue("user")).getLong("id");
        UserDataRuleBean userDataRuleBean = new UserDataRuleBean();
        userDataRuleBean.setUserId(userId);
        List<UserDataRuleDimBean> dimList = userDataRuleBean.getDimList();
        String permItemSql = "select fid, fdimid, fisincludesub, fappid, fentitynum, fpermitemid, fdataruleid " + "from t_perm_userdatarule " + "where fuserid = ? and fdimtype = ? order by fdimid asc ";
        DB.query((DBRoute)DBRoute.permission, (String)permItemSql, (Object[])new Object[]{userId, curCtrlTypeEntNum}, rs -> {
            while (rs.next()) {
                Long curDimId = rs.getLong("fdimid");
                UserDataRuleDimBean curDimBean = userDataRuleBean.getDimBean(curCtrlTypeEntNum, curDimId);
                if (curDimBean == null) {
                    curDimBean = new UserDataRuleDimBean();
                    dimList.add(curDimBean);
                    curDimBean.setDimId(rs.getLong("fdimid"));
                    curDimBean.setIsIncludeSub(rs.getBoolean("fisincludesub"));
                    curDimBean.setDimType(curCtrlTypeEntNum);
                    curDimBean.setDataStatus(DataStatus.NONE);
                }
                List<UserPermItemRuleBean> permItemRules = curDimBean.getPermItemRules();
                UserPermItemRuleBean upir = new UserPermItemRuleBean();
                upir.setId(rs.getLong("fid"));
                upir.setAppId(rs.getString("fappid"));
                upir.setEntityNum(rs.getString("fentitynum"));
                upir.setPermItemId(rs.getString("fpermitemid"));
                upir.setDataRuleId(rs.getLong("fdataruleid"));
                permItemRules.add(upir);
            }
            return userDataRuleBean;
        });
        String bdPropSql = "select fid, fdimid, fisincludesub, fappid, fentitynum, fpropkey, fpropentnum, fdataruleid " + "from t_perm_userdatarule_prop " + "where fuserid = ? and fdimtype = ? order by fdimid asc ";
        DB.query((DBRoute)DBRoute.permission, (String)bdPropSql, (Object[])new Object[]{userId, curCtrlTypeEntNum}, rs -> {
            while (rs.next()) {
                Long curDimId = rs.getLong("fdimid");
                UserDataRuleDimBean curDimBean = userDataRuleBean.getDimBean(curCtrlTypeEntNum, curDimId);
                if (curDimBean == null) {
                    curDimBean = new UserDataRuleDimBean();
                    dimList.add(curDimBean);
                    curDimBean.setDimId(rs.getLong("fdimid"));
                    curDimBean.setIsIncludeSub(rs.getBoolean("fisincludesub"));
                    curDimBean.setDimType(curCtrlTypeEntNum);
                    curDimBean.setDataStatus(DataStatus.NONE);
                }
                List<UserBdPropRuleBean> bdPropRules = curDimBean.getBdPropRules();
                UserBdPropRuleBean ubpr = new UserBdPropRuleBean();
                ubpr.setId(rs.getLong("fid"));
                ubpr.setAppId(rs.getString("fappid"));
                ubpr.setEntityNum(rs.getString("fentitynum"));
                ubpr.setPropKey(rs.getString("fpropkey"));
                ubpr.setPropEntNum(rs.getString("fpropentnum"));
                ubpr.setDataRuleId(rs.getLong("fdataruleid"));
                bdPropRules.add(ubpr);
            }
            return userDataRuleBean;
        });
        return userDataRuleBean;
    }

    private UserDataRuleBean getUserDataRuleBeanFromCache(IFormView view, Map<String, Object> inParams) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
        String jsonStr = permPageCacheUtil.getBigObject("dataRuleCache");
        if (StringUtils.isEmpty((String)jsonStr) || "null".equals(jsonStr)) {
            UserDataRuleBean udrb = this.getUserDataRuleBeanFromData(view, inParams);
            permPageCacheUtil.putBigObject("dataRuleCache", SerializationUtils.toJsonString((Object)udrb));
            return udrb;
        }
        return (UserDataRuleBean)SerializationUtils.fromJsonString((String)jsonStr, UserDataRuleBean.class);
    }

    protected boolean saveDataRule(Long userId, IFormView view, Map<String, Object> inParams) {
        UserDataRuleBean userDataRuleBeanFromCache = this.getUserDataRuleBeanFromCache(view, inParams);
        if (userDataRuleBeanFromCache == null) {
            log.debug("UserDirectAssignPermTask: \u672a\u627e\u5230\u9700\u8981\u4fdd\u5b58\u6570\u636e\u89c4\u5219\u7684\u5185\u5bb9\u3002");
            return true;
        }
        List<UserDataRuleDimBean> dimList = userDataRuleBeanFromCache.getDimList();
        if (dimList == null || dimList.isEmpty()) {
            log.debug("UserDirectAssignPermTask: \u672a\u627e\u5230\u9700\u8981\u4fdd\u5b58\u6570\u636e\u89c4\u5219\u7684\u5185\u5bb9\u3002");
            return true;
        }
        boolean needSaveDataFound = false;
        for (UserDataRuleDimBean userDataRuleDimBean : dimList) {
            if (userDataRuleDimBean == null) continue;
            DataStatus dataStatus = userDataRuleDimBean.getDataStatus();
            if (dataStatus != null && dataStatus != DataStatus.NONE) {
                needSaveDataFound = true;
                break;
            }
            List<UserPermItemRuleBean> permItemRules = userDataRuleDimBean.getPermItemRules();
            for (UserPermItemRuleBean userPermItemRuleBean : permItemRules) {
                DataStatus permItemDataStatus = userPermItemRuleBean.getDataStatus();
                if (permItemDataStatus == null || permItemDataStatus == DataStatus.NONE) continue;
                needSaveDataFound = true;
                break;
            }
            if (needSaveDataFound) break;
            List<UserBdPropRuleBean> bdPropRules = userDataRuleDimBean.getBdPropRules();
            for (UserBdPropRuleBean bdPropRule : bdPropRules) {
                DataStatus bdPropDataStatus = bdPropRule.getDataStatus();
                if (bdPropDataStatus == null || bdPropDataStatus == DataStatus.NONE) continue;
                needSaveDataFound = true;
                break;
            }
            if (!needSaveDataFound) continue;
            break;
        }
        if (!needSaveDataFound) {
            log.debug("UserDirectAssignPermTask: \u672a\u627e\u5230\u9700\u8981\u4fdd\u5b58\u6570\u636e\u89c4\u5219\u7684\u5185\u5bb9\u3002");
            return true;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date currTime = new Date();
        ArrayList<Long> forDelDimObjIds = new ArrayList<Long>();
        HashMap<Long, Boolean> forUpdDimObjMap = new HashMap<Long, Boolean>();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        HashMap<Long, Long> forUpdPermItemRuleMap = new HashMap<Long, Long>();
        ArrayList<Long> forDelBdPropRulePkIds = new ArrayList<Long>();
        HashMap<Long, Long> forUpdBdPropRuleMap = new HashMap<Long, Long>();
        ArrayList<Object[]> forInsPermItemRuleSqlInfo = new ArrayList<Object[]>();
        ArrayList<Object[]> forInsBdPropRuleSqlInfo = new ArrayList<Object[]>();
        for (UserDataRuleDimBean dimBean : dimList) {
            DataStatus dataStatus = dimBean.getDataStatus();
            if (DataStatus.DELETE == dataStatus) {
                forDelDimObjIds.add(dimBean.getDimId());
                continue;
            }
            if (DataStatus.INSERT == dataStatus) {
                forDelDimObjIds.add(dimBean.getDimId());
            } else if (DataStatus.UPDATE == dataStatus) {
                Boolean isIncludeSub = dimBean.getIsIncludeSub();
                if (isIncludeSub == null) {
                    isIncludeSub = Boolean.FALSE;
                }
                forUpdDimObjMap.put(dimBean.getDimId(), isIncludeSub);
            }
            List<UserPermItemRuleBean> permItemRules = dimBean.getPermItemRules();
            for (UserPermItemRuleBean userPermItemRuleBean : permItemRules) {
                DataStatus permItemDataStatus = userPermItemRuleBean.getDataStatus();
                Long permItemRulePkId = userPermItemRuleBean.getId();
                boolean permItemRulePkIdEmpty = permItemRulePkId == null || permItemRulePkId.equals(0L);
                Long dataRuleId = userPermItemRuleBean.getDataRuleId();
                if (permItemDataStatus == null || permItemDataStatus == DataStatus.NONE) continue;
                if (DataStatus.DELETE == permItemDataStatus) {
                    if (permItemRulePkIdEmpty) continue;
                    arrayList.add(permItemRulePkId);
                    continue;
                }
                if (DataStatus.UPDATE == permItemDataStatus) {
                    if (permItemRulePkIdEmpty) continue;
                    forUpdPermItemRuleMap.put(permItemRulePkId, dataRuleId);
                    continue;
                }
                if (DataStatus.INSERT != permItemDataStatus) continue;
                String appId = userPermItemRuleBean.getAppId();
                String entityNum = userPermItemRuleBean.getEntityNum();
                String permItemId = userPermItemRuleBean.getPermItemId();
                Long dimId = dimBean.getDimId();
                String dimType = dimBean.getDimType();
                Boolean isIncludeSub = dimBean.getIsIncludeSub();
                if (isIncludeSub == null) {
                    isIncludeSub = Boolean.FALSE;
                }
                Object[] permItemRuleSqlParam = new Object[]{appId, entityNum, permItemId, dataRuleId, dimId, dimType, isIncludeSub};
                forInsPermItemRuleSqlInfo.add(permItemRuleSqlParam);
            }
            List<UserBdPropRuleBean> bdPropRules = dimBean.getBdPropRules();
            Iterator iterator = bdPropRules.iterator();
            while (iterator.hasNext()) {
                UserBdPropRuleBean bdPropRule = (UserBdPropRuleBean)iterator.next();
                DataStatus bdPropRuleDataStatus = bdPropRule.getDataStatus();
                Long bdPropRulePkId = bdPropRule.getId();
                boolean bdPropRulePkIdEmpty = bdPropRulePkId == null || bdPropRulePkId.equals(0L);
                Long dataRuleId = bdPropRule.getDataRuleId();
                if (bdPropRuleDataStatus == null || bdPropRuleDataStatus == DataStatus.NONE) continue;
                if (DataStatus.DELETE == bdPropRuleDataStatus) {
                    if (bdPropRulePkIdEmpty) continue;
                    forDelBdPropRulePkIds.add(bdPropRulePkId);
                    continue;
                }
                if (DataStatus.UPDATE == bdPropRuleDataStatus) {
                    if (bdPropRulePkIdEmpty) continue;
                    forUpdBdPropRuleMap.put(bdPropRulePkId, dataRuleId);
                    continue;
                }
                if (DataStatus.INSERT != bdPropRuleDataStatus) continue;
                String appId = bdPropRule.getAppId();
                String entityNum = bdPropRule.getEntityNum();
                String propKey = bdPropRule.getPropKey();
                String propEntNum = bdPropRule.getPropEntNum();
                String dimType = dimBean.getDimType();
                Long dimId = dimBean.getDimId();
                Boolean isIncludeSub = dimBean.getIsIncludeSub();
                if (isIncludeSub == null) {
                    isIncludeSub = Boolean.FALSE;
                }
                Object[] bdPropRuleSqlParam = new Object[]{appId, entityNum, propKey, propEntNum, dataRuleId, dimType, dimId, isIncludeSub};
                forInsBdPropRuleSqlInfo.add(bdPropRuleSqlParam);
            }
        }
        String curCtrlTypeEntNum = (String)inParams.get("curCtrlTypeEntNum");
        try (TXHandle h = TX.required();){
            try {
                Object[] tempParams;
                ArrayList<Object[]> paramList;
                if (!forDelDimObjIds.isEmpty()) {
                    ArrayList<Object[]> delDimObjSqlParams = new ArrayList<Object[]>(8);
                    for (Long l : forDelDimObjIds) {
                        Object[] params = new Object[]{userId, l, curCtrlTypeEntNum};
                        delDimObjSqlParams.add(params);
                    }
                    String delPermItemRuleDimObjSql = "delete from t_perm_userdatarule where fuserid = ? and fdimid = ? and fdimtype = ? ";
                    String string = "delete from t_perm_userdatarule_prop where fuserid = ? and fdimid = ? and fdimtype = ? ";
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)delPermItemRuleDimObjSql, delDimObjSqlParams);
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)string, delDimObjSqlParams);
                }
                if (!arrayList.isEmpty()) {
                    paramList = new ArrayList<Object[]>(8);
                    for (Long l : arrayList) {
                        paramList.add(new Object[]{l});
                    }
                    String delPermItemRulePkIdSql = "delete from t_perm_userdatarule where fid = ? ";
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)delPermItemRulePkIdSql, paramList);
                }
                if (!forDelBdPropRulePkIds.isEmpty()) {
                    paramList = new ArrayList(8);
                    for (Long l : forDelBdPropRulePkIds) {
                        paramList.add(new Object[]{l});
                    }
                    String delBdPropRulePkIdSql = "delete from t_perm_userdatarule_prop where fid = ? ";
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)delBdPropRulePkIdSql, paramList);
                }
                if (!forUpdDimObjMap.isEmpty()) {
                    ArrayList<Object[]> updateDimObjSqlParams = new ArrayList<Object[]>(8);
                    for (Map.Entry entry : forUpdDimObjMap.entrySet()) {
                        Long dimObjId = (Long)entry.getKey();
                        Boolean isIncludeSub = (Boolean)entry.getValue();
                        Object[] params = new Object[]{isIncludeSub, currTime, currUserId, userId, dimObjId, curCtrlTypeEntNum};
                        updateDimObjSqlParams.add(params);
                    }
                    String updPermItemRuleDimObjSql = "update t_perm_userdatarule  set fisincludesub = ?, fmodifytime = ? , fmodifierid = ?  where fuserid = ? and fdimid = ? and fdimtype = ? ";
                    String string = "update t_perm_userdatarule_prop set fisincludesub = ?, fmodifytime = ? , fmodifierid = ?  where fuserid = ? and fdimid = ? and fdimtype = ? ";
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)updPermItemRuleDimObjSql, updateDimObjSqlParams);
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)string, updateDimObjSqlParams);
                }
                if (!forUpdPermItemRuleMap.isEmpty()) {
                    paramList = new ArrayList(8);
                    for (Map.Entry entry : forUpdPermItemRuleMap.entrySet()) {
                        paramList.add(new Object[]{entry.getValue(), currTime, currUserId, entry.getKey()});
                    }
                    String updPermItemRuleIdSql = "update t_perm_userdatarule set fdataruleid = ?, fmodifytime = ? , fmodifierid = ?  where fid = ? ";
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)updPermItemRuleIdSql, paramList);
                }
                if (!forUpdBdPropRuleMap.isEmpty()) {
                    paramList = new ArrayList(8);
                    for (Map.Entry entry : forUpdBdPropRuleMap.entrySet()) {
                        paramList.add(new Object[]{entry.getValue(), currTime, currUserId, entry.getKey()});
                    }
                    String updBdPropRuleIdSql = "update t_perm_userdatarule_prop  set fdataruleid = ?, fmodifytime = ? , fmodifierid = ?  where fid = ? ";
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)updBdPropRuleIdSql, paramList);
                }
                if (!forInsPermItemRuleSqlInfo.isEmpty()) {
                    paramList = new ArrayList(8);
                    String insertPermItemRuleSql = "insert into t_perm_userdatarule(" + "fid, fuserid, fappid, fentitynum, fpermitemid, fdataruleid, fdimid, " + "fdimtype, fisincludesub, fcreatetime, fcreatorid) " + "values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
                    long[] lArray = DB.genLongIds((String)"t_perm_userdatarule", (int)forInsPermItemRuleSqlInfo.size());
                    for (int i = 0; i < forInsPermItemRuleSqlInfo.size(); ++i) {
                        tempParams = (Object[])forInsPermItemRuleSqlInfo.get(i);
                        Object[] newParams = new Object[]{lArray[i], userId, tempParams[0], tempParams[1], tempParams[2], tempParams[3], tempParams[4], tempParams[5], tempParams[6], currTime, currUserId};
                        paramList.add(newParams);
                    }
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)insertPermItemRuleSql, paramList);
                }
                if (!forInsBdPropRuleSqlInfo.isEmpty()) {
                    paramList = new ArrayList(8);
                    String insertBdPropRuleSql = "insert into t_perm_userdatarule_prop(" + "fid, fuserid, fappid, fentitynum, fpropkey, fpropentnum, fdataruleid, " + "fdimtype, fdimid, fisincludesub, fcreatetime, fcreatorid) " + "values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
                    long[] lArray = DB.genLongIds((String)"t_perm_userdatarule_prop", (int)forInsBdPropRuleSqlInfo.size());
                    for (int i = 0; i < forInsBdPropRuleSqlInfo.size(); ++i) {
                        tempParams = (Object[])forInsBdPropRuleSqlInfo.get(i);
                        Object[] newParams = new Object[]{lArray[i], userId, tempParams[0], tempParams[1], tempParams[2], tempParams[3], tempParams[4], tempParams[5], tempParams[6], tempParams[7], currTime, currUserId};
                        paramList.add(newParams);
                    }
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)insertBdPropRuleSql, paramList);
                }
                userDataRuleBeanFromCache = this.getUserDataRuleBeanFromData(view, inParams);
                this.setUserDataRuleBeanToCache(userDataRuleBeanFromCache, view);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                h.markRollback();
                boolean bl = false;
                if (h != null) {
                    if (var20_24 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var20_24.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    private void setUserDataRuleBeanToCache(UserDataRuleBean userDataRuleBean, IFormView view) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
        permPageCacheUtil.putBigObject("dataRuleCache", SerializationUtils.toJsonString((Object)userDataRuleBean));
    }

    private Map<String, Map<String, Object>> loadAllDimObjDataPermFromPageCache(IFormView view) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
        String jsonRuleMap = permPageCacheUtil.get("dataPermCache");
        Map<String, Map<String, Object>> ruleMap = new HashMap<String, Map<String, Object>>(8);
        if (StringUtils.isNotEmpty((String)jsonRuleMap)) {
            ruleMap = (Map)SerializationUtils.fromJsonString((String)jsonRuleMap, Map.class);
        }
        return ruleMap;
    }

    private Map<Long, Boolean> getDimObjIncludeSubInfo(IFormView view) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>();
        IDataModel iDataModel = view.getModel();
        DynamicObjectCollection dimObjColFromUI = iDataModel.getEntryEntity("orglist");
        for (DynamicObject row : dimObjColFromUI) {
            Long dimObjIdFromView = Long.parseLong(row.getString("org_id"));
            if (dimObjIdFromView == null) continue;
            Boolean includeSub = row.getBoolean("org_include_sub_org");
            result.put(dimObjIdFromView, includeSub);
        }
        return result;
    }

    private List<String> getAllDimObjIdsList(IFormView view) {
        IDataModel iDataModel = view.getModel();
        int count = iDataModel.getEntryRowCount("orglist");
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String dimObjId = (String)iDataModel.getValue("org_id", i);
            result.add(dimObjId);
        }
        return result;
    }

    private boolean checkIfExistInDimObjEntryGrid(String strDimObjId, IFormView view) {
        String[] allDimObjIds;
        for (String temp : allDimObjIds = this.getAllDimObjIdsList(view).toArray(new String[0])) {
            if (!temp.equals(strDimObjId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfExistInDataPermTree(String cacheKey, String focusNodeId, IFormView view) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
        Map<String, List<String>> dataTreeNodeMap = UserFuncPermTreeUtil.getTreeCacheNodeMap(permPageCacheUtil, cacheKey, null);
        return dataTreeNodeMap.get(focusNodeId) != null;
    }

    private void insertDataPermEntryRow(String appId, String entityNum, String dataPermRule, DynamicObject dataPermDObj, Set<DynamicObject> forInsertDataPermObj) {
        PermCommonUtil.getQFilterFromEntNumRuleJson((String)entityNum, (String)dataPermRule);
        DynamicObjectCollection doc = dataPermDObj.getDynamicObjectCollection("entitytypelist");
        DynamicObjectType entryRowType = doc.getDynamicObjectType();
        DynamicObject newEntryRow = new DynamicObject(entryRowType);
        newEntryRow.set("entitytype", (Object)entityNum);
        newEntryRow.set("bizapp", (Object)appId);
        newEntryRow.set("rule", (Object)dataPermRule);
        doc.add((Object)newEntryRow);
        forInsertDataPermObj.add(dataPermDObj);
    }

    private void deleteDataPermEntryRow(String pAppId, String entityNum, DynamicObject dataPermDObj, Set<DynamicObject> forUpdateDataPermObj, Set<String> forDelObjDataPermId) {
        if (dataPermDObj != null) {
            String dataPermId = dataPermDObj.getString("id");
            DynamicObjectCollection doc = dataPermDObj.getDynamicObjectCollection("entitytypelist");
            Iterator iterator = doc.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                Object entityTypeDobj = row.get("entitytype");
                String curEntityTypeId = "";
                if (entityTypeDobj instanceof String) {
                    curEntityTypeId = (String)entityTypeDobj;
                } else if (entityTypeDobj instanceof DynamicObject) {
                    curEntityTypeId = ((DynamicObject)entityTypeDobj).getString("id");
                }
                Object bizAppDObj = row.get("bizapp");
                String bizAppId = "";
                if (bizAppDObj instanceof String) {
                    bizAppId = (String)bizAppDObj;
                } else if (bizAppDObj instanceof DynamicObject) {
                    bizAppId = ((DynamicObject)bizAppDObj).getString("id");
                }
                if (entityTypeDobj == null || !entityNum.equals(curEntityTypeId) || !pAppId.equals(bizAppId)) continue;
                iterator.remove();
            }
            if (doc.size() == 0) {
                forDelObjDataPermId.add(dataPermId);
            }
            forUpdateDataPermObj.add(dataPermDObj);
        }
    }

    private void updateDataPermEntryRow(String pAppId, String pEntityNum, String pDataPermRule, DynamicObject pDataPermDObj, Set<DynamicObject> pForUpdateDataPermObj) {
        if (pDataPermDObj != null) {
            PermCommonUtil.getQFilterFromEntNumRuleJson((String)pEntityNum, (String)pDataPermRule);
            DynamicObjectCollection doc = pDataPermDObj.getDynamicObjectCollection("entitytypelist");
            for (DynamicObject row : doc) {
                Object entityTypeDObj = row.get("entitytype");
                Object bizAppDObj = row.get("bizapp");
                if (entityTypeDObj == null) continue;
                String curEntityTypeId = "";
                if (entityTypeDObj instanceof String) {
                    curEntityTypeId = (String)entityTypeDObj;
                } else if (entityTypeDObj instanceof DynamicObject) {
                    curEntityTypeId = ((DynamicObject)entityTypeDObj).getString("id");
                }
                String bizAppId = "";
                if (bizAppDObj instanceof String) {
                    bizAppId = (String)bizAppDObj;
                } else if (bizAppDObj instanceof DynamicObject) {
                    bizAppId = ((DynamicObject)bizAppDObj).getString("id");
                }
                if (!pEntityNum.equals(curEntityTypeId) || !pAppId.equals(bizAppId)) continue;
                row.set("rule", (Object)pDataPermRule);
                break;
            }
            pForUpdateDataPermObj.add(pDataPermDObj);
        }
    }

    private Boolean getIsIncludeSub(Long dimObjId, IFormView view) {
        if (dimObjId == null) {
            return Boolean.FALSE;
        }
        IDataModel iDataModel = view.getModel();
        DynamicObjectCollection dimObjColFromUI = iDataModel.getEntryEntity("orglist");
        for (int i = 0; i < dimObjColFromUI.size(); ++i) {
            DynamicObject row = (DynamicObject)dimObjColFromUI.get(i);
            Long dimObjIdFromView = Long.parseLong(row.getString("org_id"));
            if (dimObjIdFromView == null || !dimObjId.equals(dimObjIdFromView)) continue;
            return row.getBoolean("org_include_sub_org");
        }
        return Boolean.FALSE;
    }

    private void insertObjDataPerm(DynamicObject dataPermDObj, Set<DynamicObject> forInsertObjDataPermObj, String strDimObjId, IFormView view, Map<String, Object> params) {
        String curCtrlType = (String)params.get("curCtrlType");
        IDataModel iDataModel = view.getModel();
        Long userId = ((DynamicObject)iDataModel.getValue("user")).getLong("id");
        String dataPermId = dataPermDObj.getString("id");
        DynamicObject userDataPerm = BusinessDataServiceHelper.newDynamicObject((String)"perm_userdataperm");
        Boolean isIncludeSub = this.getIsIncludeSub(Long.parseLong(strDimObjId), view);
        userDataPerm.set("dataperm", (Object)dataPermId);
        userDataPerm.set("user", (Object)userId);
        userDataPerm.set("org", (Object)Long.parseLong(strDimObjId));
        userDataPerm.set("dimtype", (Object)curCtrlType);
        userDataPerm.set("includesuborg", (Object)isIncludeSub);
        forInsertObjDataPermObj.add(userDataPerm);
    }

    /*
     * WARNING - void declaration
     */
    private void saveDataPerm(List<Long> forDelDimObjIds, IFormView view, Map<String, Object> params) {
        boolean bl;
        String curCtrlType = (String)params.get("curCtrlType");
        IDataModel iDataModel = view.getModel();
        Long userId = ((DynamicObject)iDataModel.getValue("user")).getLong("id");
        HashSet<String> influenceForm = new HashSet<String>(16);
        if (!CollectionUtils.isEmpty(forDelDimObjIds)) {
            DynamicObjectCollection userDataPermDoc = QueryServiceHelper.query((String)"perm_userdataperm", (String)"dataperm", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("org", "in", forDelDimObjIds), new QFilter("dimtype", "=", (Object)curCtrlType)});
            ArrayList<String> dataPermIds = new ArrayList<String>();
            if (userDataPermDoc != null && !userDataPermDoc.isEmpty()) {
                for (DynamicObject[] userUserPermDObj : userDataPermDoc) {
                    String dataPermId = userUserPermDObj.getString("dataperm");
                    dataPermIds.add(dataPermId);
                }
            }
            if (dataPermIds != null && !dataPermIds.isEmpty()) {
                DynamicObject[] deleteDataPerm;
                for (DynamicObject dataPerm : deleteDataPerm = BusinessDataServiceHelper.load((String)"perm_dataperm", (String)"entitytypelist.entitytype, entitytypelist.bizapp", (QFilter[])new QFilter[]{new QFilter("id", "in", dataPermIds)})) {
                    String entityNum = dataPerm.getString("entitytypelist.entitytype");
                    String bizAppId = dataPerm.getString("entitytypelist.bizapp");
                    influenceForm.add(bizAppId + "|" + entityNum);
                }
                DeleteServiceHelper.delete((String)"perm_dataperm", (QFilter[])new QFilter[]{new QFilter("id", "in", dataPermIds)});
            }
            DeleteServiceHelper.delete((String)"perm_userdataperm", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("org", "in", forDelDimObjIds), new QFilter("dimtype", "=", (Object)curCtrlType)});
        }
        Map<String, Map<String, Object>> allDimObjDataPermCache = this.loadAllDimObjDataPermFromPageCache(view);
        StringBuilder sbSelFields = new StringBuilder("dataperm").append(", ").append("org").append(", ").append("dimtype").append(", ").append("includesuborg").append(", ").append("id");
        DynamicObject[] arrUserDataPerm = BusinessDataServiceHelper.load((String)"perm_userdataperm", (String)sbSelFields.toString(), (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("dimtype", "=", (Object)curCtrlType)});
        HashSet<DynamicObject> forUpdateUserDataPermDObjs = new HashSet<DynamicObject>();
        HashMap<String, String> dimObjMapFromDB = new HashMap<String, String>();
        HashMap<Long, Boolean> includeSubInfoFromDB = new HashMap<Long, Boolean>();
        HashMap<Long, Object> dimObjAndUserDataPermObjMap = new HashMap<Long, Object>();
        if (arrUserDataPerm != null && arrUserDataPerm.length > 0) {
            for (int i = 0; i < arrUserDataPerm.length; ++i) {
                DynamicObject userDataPerm = arrUserDataPerm[i];
                if (userDataPerm == null) continue;
                Long l = userDataPerm.getLong("org");
                boolean includeSub = userDataPerm.getBoolean("includesuborg");
                String dataPermId = userDataPerm.getString("dataperm");
                String strDimObjId = String.valueOf(l);
                dimObjMapFromDB.put(strDimObjId, dataPermId);
                includeSubInfoFromDB.put(l, includeSub);
                dimObjAndUserDataPermObjMap.put(l, userDataPerm);
            }
            Map<Long, Boolean> dimObjIncludeSubFromView = this.getDimObjIncludeSubInfo(view);
            for (Map.Entry entry : includeSubInfoFromDB.entrySet()) {
                Boolean includeSubFromView;
                Long dimObjIdFromDB = (Long)entry.getKey();
                Boolean includeSubFromDB = (Boolean)entry.getValue();
                if (dimObjIdFromDB == null || dimObjIdFromDB.equals(0L)) continue;
                if (includeSubFromDB == null) {
                    includeSubFromDB = Boolean.FALSE;
                }
                if ((includeSubFromView = dimObjIncludeSubFromView.get(dimObjIdFromDB)) == null) {
                    includeSubFromView = Boolean.FALSE;
                }
                if (includeSubFromDB.equals(includeSubFromView)) continue;
                DynamicObject userDataPermObj = (DynamicObject)dimObjAndUserDataPermObjMap.get(dimObjIdFromDB);
                userDataPermObj.set("includesuborg", (Object)includeSubFromView);
                forUpdateUserDataPermDObjs.add(userDataPermObj);
            }
        }
        StringBuilder sbSelDataPermFields = new StringBuilder("entitytypelist.entitytype").append(", ").append("entitytypelist.bizapp").append(", ").append("entitytypelist.rule").append(", ").append("id");
        DynamicObject[] arrDataPerm = BusinessDataServiceHelper.load((String)"perm_dataperm", (String)sbSelDataPermFields.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", dimObjMapFromDB.values())});
        HashMap<String, DynamicObject> hashMap = new HashMap<String, DynamicObject>(arrDataPerm.length);
        for (DynamicObject curDataPerm : arrDataPerm) {
            String dataPermId = curDataPerm.getString("id");
            hashMap.put(dataPermId, curDataPerm);
        }
        HashSet<DynamicObject> forInsertUserDataPermDObjs = new HashSet<DynamicObject>();
        HashSet<String> forDelUserDataPermDObjs = new HashSet<String>();
        HashSet<String> forDelDataPermIds = new HashSet<String>();
        HashSet<DynamicObject> forInsertDataPermDObjs = new HashSet<DynamicObject>();
        HashSet<DynamicObject> forUpdateDataPermDObjs = new HashSet<DynamicObject>();
        ArrayList<String> forDelDimObjCache = new ArrayList<String>();
        ArrayList<String> forDelEntityCache = new ArrayList<String>();
        ORM orm = ORM.create();
        int emptyDataPermDObjCount = 0;
        for (Map.Entry<String, Map<String, Object>> entry : allDimObjDataPermCache.entrySet()) {
            void var30_45;
            String strDimObjId = entry.getKey();
            if (!this.checkIfExistInDimObjEntryGrid(strDimObjId, view)) continue;
            Object var30_46 = null;
            if (dimObjMapFromDB.get(strDimObjId) != null) {
                DynamicObject dynamicObject = (DynamicObject)hashMap.get(dimObjMapFromDB.get(strDimObjId));
            }
            if (var30_45 != null) continue;
            ++emptyDataPermDObjCount;
        }
        String[] emptyDataPermIds = orm.genStringIds("perm_dataperm", emptyDataPermDObjCount);
        int emptyDataPermIdsIndex = 0;
        for (Map.Entry entry : allDimObjDataPermCache.entrySet()) {
            String strDimObjId = (String)entry.getKey();
            if (!this.checkIfExistInDimObjEntryGrid(strDimObjId, view)) {
                forDelDimObjCache.add(strDimObjId);
                continue;
            }
            Map entityCacheMap = (Map)entry.getValue();
            DynamicObject dataPermDObj = null;
            if (dimObjMapFromDB.get(strDimObjId) != null) {
                dataPermDObj = (DynamicObject)hashMap.get(dimObjMapFromDB.get(strDimObjId));
            }
            boolean dataPermDObjIfNull = false;
            if (dataPermDObj == null) {
                dataPermDObjIfNull = true;
                dataPermDObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_dataperm");
                String dataPermId = emptyDataPermIds[emptyDataPermIdsIndex++];
                dataPermDObj.set("id", (Object)dataPermId);
                dataPermDObj.set("number", (Object)dataPermId);
                dataPermDObj.set("status", (Object)"C");
                dataPermDObj.set("enable", (Object)"1");
                dataPermDObj.set("creator", (Object)RequestContext.get().getUserId());
                dataPermDObj.set("createtime", (Object)new Date());
            }
            for (String curNodeId : entityCacheMap.keySet()) {
                String entityNum = AllFuncPermTreeUtil.getEntityNumFromNodeId(curNodeId);
                String appId = AllFuncPermTreeUtil.getAppIdFromNodeId(curNodeId);
                String cacheKey = "nodeMap" + '$' + strDimObjId;
                if (!this.checkIfExistInDataPermTree(cacheKey, curNodeId, view)) {
                    forDelEntityCache.add(curNodeId);
                    continue;
                }
                String[] dataPermArr = this.getStrArrFromDataPermissionMap(entityCacheMap, curNodeId);
                if (dataPermArr == null || dataPermArr.length != 2 || "0".equals(dataPermArr[1])) continue;
                if ("1".equals(dataPermArr[1])) {
                    this.insertDataPermEntryRow(appId, entityNum, dataPermArr[0], dataPermDObj, forInsertDataPermDObjs);
                } else if ("2".equals(dataPermArr[1])) {
                    this.deleteDataPermEntryRow(appId, entityNum, dataPermDObj, forUpdateDataPermDObjs, forDelDataPermIds);
                } else if ("3".equals(dataPermArr[1])) {
                    this.updateDataPermEntryRow(appId, entityNum, dataPermArr[0], dataPermDObj, forUpdateDataPermDObjs);
                }
                influenceForm.add(appId + "|" + entityNum);
                entityCacheMap.put(curNodeId, new String[]{dataPermArr[0], "0"});
            }
            if (dataPermDObjIfNull) {
                this.insertObjDataPerm(dataPermDObj, forInsertUserDataPermDObjs, strDimObjId, view, params);
            }
            if (!forDelDataPermIds.isEmpty()) {
                for (DynamicObject userDataPerm : arrUserDataPerm) {
                    String dataPermId = userDataPerm.getString("dataperm");
                    String userDataPermId = userDataPerm.getString("id");
                    if (!forDelDataPermIds.contains(dataPermId)) continue;
                    forDelUserDataPermDObjs.add(userDataPermId);
                    break;
                }
            }
            for (String forDelDimObjId : forDelDimObjCache) {
                allDimObjDataPermCache.remove(forDelDimObjId);
            }
            for (String forDelNodeKey : forDelEntityCache) {
                entityCacheMap.remove(forDelNodeKey);
            }
            allDimObjDataPermCache.put(strDimObjId, entityCacheMap);
        }
        if (!CollectionUtils.isEmpty(forDelDataPermIds)) {
            MainEntityType idet = EntityMetadataCache.getDataEntityType((String)"perm_dataperm");
            DeleteServiceHelper.delete((IDataEntityType)idet, (Object[])forDelDataPermIds.toArray(new String[0]));
        }
        boolean needClearDynamicCache = false;
        boolean bl2 = false;
        if (!CollectionUtils.isEmpty(forInsertDataPermDObjs)) {
            SaveServiceHelper.save((DynamicObject[])forInsertDataPermDObjs.toArray(new DynamicObject[0]));
            bl = true;
            needClearDynamicCache = true;
        }
        if (!CollectionUtils.isEmpty(forUpdateDataPermDObjs) && !bl) {
            SaveServiceHelper.save((DynamicObject[])forUpdateDataPermDObjs.toArray(new DynamicObject[0]));
            needClearDynamicCache = true;
        }
        if (!CollectionUtils.isEmpty(forDelUserDataPermDObjs)) {
            MainEntityType idet = EntityMetadataCache.getDataEntityType((String)"perm_userdataperm");
            DeleteServiceHelper.delete((IDataEntityType)idet, (Object[])forDelUserDataPermDObjs.toArray(new String[0]));
            needClearDynamicCache = true;
        }
        if (!CollectionUtils.isEmpty(forInsertUserDataPermDObjs)) {
            SaveServiceHelper.save((DynamicObject[])forInsertUserDataPermDObjs.toArray(new DynamicObject[0]));
            needClearDynamicCache = true;
        }
        if (!CollectionUtils.isEmpty(forUpdateUserDataPermDObjs)) {
            SaveServiceHelper.save((DynamicObject[])forUpdateUserDataPermDObjs.toArray(new DynamicObject[0]));
            needClearDynamicCache = true;
        }
        if (PermCommonUtil.isEnableAuthorityChangeNotice() && (needClearDynamicCache || !CollectionUtils.isEmpty(influenceForm))) {
            try {
                ArrayList influenceBizEntityInfo = new ArrayList(influenceForm.size());
                for (String info : influenceForm) {
                    String[] infoArr = info.split("\\|");
                    HashMap<String, String> infoMap = new HashMap<String, String>(1);
                    infoMap.put(infoArr[0], infoArr[1]);
                    influenceBizEntityInfo.add(infoMap);
                }
                ArrayList<Long> userIds = new ArrayList<Long>(10);
                userIds.add(userId);
                FormConfigFactory.cancelShowFormDataRights(userIds, influenceBizEntityInfo);
            }
            catch (Exception e) {
                log.warn("[clearDynamicCache]\u8c03\u7528cancelShowFormDataRights\u5f02\u5e38", (Throwable)e);
            }
        }
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
        permPageCacheUtil.put("dataPermCache", SerializationUtils.toJsonString(allDimObjDataPermCache));
    }

    private Map getFieldPermInfoFromCache(IFormView view) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
        Map resultMap = null;
        String jsonStr = permPageCacheUtil.get("fieldPermCache");
        resultMap = StringUtils.isEmpty((String)jsonStr) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        return resultMap;
    }

    private Map<String, Object> getAllDimObjIds(IFormView view) {
        IDataModel iDataModel = view.getModel();
        int count = iDataModel.getEntryRowCount("orglist");
        HashMap<String, Object> result = new HashMap<String, Object>(count);
        for (int i = 0; i < count; ++i) {
            String dimObjId = (String)iDataModel.getValue("org_id", i);
            Object includeSubOrg = iDataModel.getValue("org_include_sub_org", i);
            result.put(dimObjId, includeSubOrg);
        }
        return result;
    }

    private List<String> getAllEntityKey(String cacheKey, IFormView view) {
        Long orgId;
        String strOrgId = null;
        if (cacheKey.contains("$")) {
            strOrgId = cacheKey.substring(cacheKey.indexOf(36) + 1);
        }
        Long l = orgId = strOrgId != null ? Long.valueOf(Long.parseLong(strOrgId)) : null;
        if (orgId == null) {
            TreeView funcPermTreeView = (TreeView)view.getControl("tree_funcperm");
            cacheKey = "nodeMap$" + funcPermTreeView.getKey();
        } else {
            cacheKey = "nodeMap";
        }
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
        Map<String, List<String>> nodeMap = UserFuncPermTreeUtil.getTreeCacheNodeMap(permPageCacheUtil, cacheKey, orgId);
        ArrayList<String> entityKeyList = new ArrayList<String>();
        for (String nodeId : nodeMap.keySet()) {
            if (!nodeId.contains("#entity")) continue;
            String entityNum = AllFuncPermTreeUtil.getEntityNumFromNodeId(nodeId);
            String appId = AllFuncPermTreeUtil.getAppIdFromNodeId(nodeId);
            String entityKey = entityNum + "@" + appId;
            entityKeyList.add(entityKey);
        }
        return entityKeyList;
    }

    private DynamicObject saveFieldPermObj(DynamicObject objFieldPermObj, Map<String, List<Map<String, String>>> cacheMap, List<String> forDelFieldPermObj, List<String> forDelObjFieldPermObj, String fieldPermKey, String fieldPermIdKey) {
        ORM orm = ORM.create();
        DynamicObject fieldPermObj = objFieldPermObj.getDynamicObject("fieldperm");
        if (fieldPermObj == null) {
            fieldPermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_fieldperm");
            String newId = orm.genStringId("perm_fieldperm");
            String newNum = orm.genStringId("perm_fieldperm");
            fieldPermObj.set("number", (Object)newNum);
            fieldPermObj.set("id", (Object)newId);
            objFieldPermObj.set(fieldPermKey, (Object)fieldPermObj);
        } else {
            String fieldPermId = objFieldPermObj.getString(fieldPermIdKey);
            QFilter[] arrFieldPermQFilter = new QFilter[]{new QFilter("id", "=", (Object)fieldPermId)};
            StringBuilder sbFieldPermField = new StringBuilder("number").append(", ").append("entitytype").append(", ").append("bizapp").append(", ").append("fieldname").append(", ").append("rowcondition");
            DynamicObject[] arrFieldPermObj = BusinessDataServiceHelper.load((String)"perm_fieldperm", (String)sbFieldPermField.toString(), (QFilter[])arrFieldPermQFilter);
            if (arrFieldPermObj != null && arrFieldPermObj.length > 0) {
                fieldPermObj = arrFieldPermObj[0];
                objFieldPermObj.set("fieldperm", (Object)fieldPermObj);
            }
        }
        DynamicObjectCollection fieldPermRule = fieldPermObj.getDynamicObjectCollection("fieldrule");
        if (fieldPermRule != null) {
            Iterator iterator = fieldPermRule.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                String entityNumFromDB = row.getString("entitytype.id");
                String appIdFromDB = row.getString("bizapp.id");
                String fieldNumFromDB = row.getString("fieldname");
                String entityKeyFromDB = entityNumFromDB + "@" + appIdFromDB;
                boolean ifFound = false;
                block1: for (Map.Entry<String, List<Map<String, String>>> entry : cacheMap.entrySet()) {
                    String entityKeyFromCache = entry.getKey();
                    List<Map<String, String>> fieldPermRuleFromCache = entry.getValue();
                    for (Map<String, String> map : fieldPermRuleFromCache) {
                        String fieldNumFromCache = map.get("fieldperm_fieldnum");
                        if (!entityKeyFromCache.equals(entityKeyFromDB) || !fieldNumFromCache.equals(fieldNumFromDB)) continue;
                        ifFound = true;
                        break block1;
                    }
                }
                if (ifFound) continue;
                iterator.remove();
            }
        }
        ArrayList<DynamicObject> forAddEntryRows = new ArrayList<DynamicObject>();
        for (Map.Entry<String, List<Map<String, String>>> entry : cacheMap.entrySet()) {
            String entityKeyFromCache = entry.getKey();
            String entityNumFromCache = entityKeyFromCache.substring(0, entityKeyFromCache.indexOf(64));
            String appIdFromCache = entityKeyFromCache.substring(entityKeyFromCache.indexOf(64) + 1);
            List<Map<String, String>> fieldPermRuleFromCache = entry.getValue();
            if (fieldPermRuleFromCache == null || fieldPermRuleFromCache.size() == 0) {
                String objFieldPermId;
                if (fieldPermRule == null) continue;
                Iterator iterator = fieldPermRule.iterator();
                while (iterator.hasNext()) {
                    DynamicObject dynamicObject = (DynamicObject)iterator.next();
                    String appIdFromDB = dynamicObject.getString("bizapp.id");
                    String entityNumFromDB = dynamicObject.getString("entitytype.id");
                    if (!entityKeyFromCache.equals(entityNumFromDB + "@" + appIdFromDB)) continue;
                    iterator.remove();
                }
                if (fieldPermRule.size() != 0) continue;
                if (!forDelFieldPermObj.contains(fieldPermObj.getString("id"))) {
                    forDelFieldPermObj.add(fieldPermObj.getString("id"));
                }
                if (!StringUtils.isNotEmpty((String)(objFieldPermId = objFieldPermObj.getString("id"))) || forDelObjFieldPermObj.contains(objFieldPermObj.getString("id"))) continue;
                forDelObjFieldPermObj.add(objFieldPermObj.getString("id"));
                continue;
            }
            forAddEntryRows.clear();
            for (Map map : fieldPermRuleFromCache) {
                String fieldNumFromCache = (String)map.get("fieldperm_fieldnum");
                String rowConditionFromCache = (String)map.get("fieldperm_rowcondition");
                boolean ifFound = false;
                if (fieldPermRule != null) {
                    for (DynamicObject row : fieldPermRule) {
                        String entityNumFromDB = row.getString("entitytype.id");
                        String appIdFromDB = row.getString("bizapp.id");
                        String fieldNumFromDB = row.getString("fieldname");
                        if (!entityKeyFromCache.equals(entityNumFromDB + "@" + appIdFromDB) || !fieldNumFromCache.equals(fieldNumFromDB)) continue;
                        ifFound = true;
                        row.set("rowcondition", (Object)rowConditionFromCache);
                        break;
                    }
                }
                if (ifFound) continue;
                IDataEntityType iDataEntityType = ((EntryProp)fieldPermObj.getDynamicObjectType().getProperty("fieldrule")).getItemType();
                DynamicObject entryRow = new DynamicObject((DynamicObjectType)iDataEntityType);
                entryRow.set("bizapp", (Object)appIdFromCache);
                entryRow.set("entitytype", (Object)entityNumFromCache);
                entryRow.set("fieldname", (Object)fieldNumFromCache);
                entryRow.set("rowcondition", (Object)rowConditionFromCache);
                forAddEntryRows.add(entryRow);
            }
            for (DynamicObject dynamicObject : forAddEntryRows) {
                fieldPermRule.add((Object)dynamicObject);
                if (forDelFieldPermObj.contains(fieldPermObj.getString("id"))) {
                    forDelFieldPermObj.remove(fieldPermObj.getString("id"));
                }
                if (!forDelObjFieldPermObj.contains(objFieldPermObj.getString("id"))) continue;
                forDelObjFieldPermObj.remove(objFieldPermObj.getString("id"));
            }
        }
        fieldPermObj.set("fieldrule", (Object)fieldPermRule);
        return fieldPermObj;
    }

    private Map<String, Object> saveFieldPermByEntityCache(Long dimObjId, Object includeSubOrg, Long userId, Map<String, List<Map<String, String>>> cacheMap, String cacheKey, IFormView view, Map<String, Object> params) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(1);
        if (CollectionUtils.isEmpty(cacheMap)) {
            return returnMap;
        }
        Set<String> entityKeyCacheSet = cacheMap.keySet();
        if (!CollectionUtils.isEmpty(entityKeyCacheSet)) {
            List<String> allEntityKeyList = this.getAllEntityKey(cacheKey, view);
            Iterator<String> iterator = entityKeyCacheSet.iterator();
            while (iterator.hasNext()) {
                String entityKey = iterator.next();
                if (allEntityKeyList.contains(entityKey)) continue;
                iterator.remove();
            }
        }
        if (CollectionUtils.isEmpty(cacheMap)) {
            return returnMap;
        }
        DynamicObject userFieldPermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userfieldperm");
        userFieldPermObj.set("user", (Object)userId);
        userFieldPermObj.set("org", (Object)dimObjId);
        String curCtrlType = (String)params.get("curCtrlType");
        userFieldPermObj.set("dimtype", (Object)curCtrlType);
        userFieldPermObj.set("includesuborg", includeSubOrg);
        ArrayList<String> forDelFieldPermObj = new ArrayList<String>();
        ArrayList<String> forDelUserFieldPermObj = new ArrayList<String>();
        DynamicObject fieldPermObj = this.saveFieldPermObj(userFieldPermObj, cacheMap, forDelFieldPermObj, forDelUserFieldPermObj, "fieldperm", "fieldperm.id");
        returnMap.put("forDelFieldPermObj", forDelFieldPermObj);
        returnMap.put("forDelUserFieldPermObj", forDelUserFieldPermObj);
        returnMap.put("fieldPermObj", fieldPermObj);
        returnMap.put("userFieldPermObj", userFieldPermObj);
        return returnMap;
    }

    protected void saveFieldPerm(Long userId, List<Long> forDelDimObjIds, IFormView view, Map<String, Object> params) {
        HashMap<String, LinkedList> map = new HashMap<String, LinkedList>(2);
        Map fieldPermCache = this.getFieldPermInfoFromCache(view);
        Map<String, Object> allDimObjIds = this.getAllDimObjIds(view);
        Map<String, Object> returnMap = null;
        for (Map.Entry<String, Object> dimObjInfo : allDimObjIds.entrySet()) {
            Object userFieldPermObj;
            Map entityCache;
            String key = dimObjInfo.getKey();
            Long keyLong = Long.parseLong(key);
            if (!forDelDimObjIds.contains(keyLong) || CollectionUtils.isEmpty((Map)(entityCache = (Map)fieldPermCache.get(key)))) continue;
            String cacheKey = "tree_fieldperm" + '$' + key;
            returnMap = this.saveFieldPermByEntityCache(keyLong, dimObjInfo.getValue(), userId, entityCache, cacheKey, view, params);
            if (CollectionUtils.isEmpty(returnMap)) continue;
            Object fieldPermObj = returnMap.get("fieldPermObj");
            if (null != fieldPermObj) {
                map.computeIfAbsent("fieldPermObj", k -> new LinkedList()).add((DynamicObject)fieldPermObj);
            }
            if (null == (userFieldPermObj = returnMap.get("userFieldPermObj"))) continue;
            map.computeIfAbsent("userFieldPermObj", k -> new LinkedList()).add((DynamicObject)userFieldPermObj);
        }
        String curCtrlType = (String)params.get("curCtrlType");
        DynamicObjectCollection userFieldPermDoc = QueryServiceHelper.query((String)"perm_userfieldperm", (String)"fieldperm.id", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("org", "in", forDelDimObjIds), new QFilter("dimtype", "=", (Object)curCtrlType)});
        Set fieldPermIdSet = userFieldPermDoc.stream().map(x -> x.getString("fieldperm.id")).collect(Collectors.toSet());
        try (TXHandle h = TX.required();){
            try {
                LinkedList userFieldPermObjList;
                if (!CollectionUtils.isEmpty(fieldPermIdSet)) {
                    DeleteServiceHelper.delete((String)"perm_fieldperm", (QFilter[])new QFilter[]{new QFilter("id", "in", fieldPermIdSet)});
                }
                DeleteServiceHelper.delete((String)"perm_userfieldperm", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("org", "in", forDelDimObjIds), new QFilter("dimtype", "=", (Object)curCtrlType)});
                LinkedList fieldPermObjList = (LinkedList)map.get("fieldPermObj");
                if (!CollectionUtils.isEmpty((Collection)fieldPermObjList)) {
                    SaveServiceHelper.save((DynamicObject[])fieldPermObjList.toArray(new DynamicObject[fieldPermObjList.size()]));
                }
                if (!CollectionUtils.isEmpty((Collection)(userFieldPermObjList = (LinkedList)map.get("userFieldPermObj")))) {
                    SaveServiceHelper.save((DynamicObject[])userFieldPermObjList.toArray(new DynamicObject[userFieldPermObjList.size()]));
                }
            }
            catch (Exception e) {
                h.markRollback();
                log.warn("UserDirectAssignPermTask.saveFieldPerm tx error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    private void clearDimObjPageCache(List<Long> forDelDimObjIds, IFormView view) {
        for (int i = 0; i < forDelDimObjIds.size(); ++i) {
            Long delDimObjId = forDelDimObjIds.get(i);
            if (delDimObjId == null || delDimObjId == 0L) continue;
            String cacheKeyFuncPerm = "tree_funcperm" + '$' + delDimObjId;
            String cacheKeyFieldPerm = "tree_fieldperm" + '$' + delDimObjId;
            String cacheKeyDataPerm = "tree_dataperm" + '$' + delDimObjId;
            PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
            permPageCacheUtil.remove(cacheKeyFuncPerm);
            permPageCacheUtil.remove(cacheKeyFieldPerm);
            permPageCacheUtil.remove(cacheKeyDataPerm);
        }
    }

    private boolean notifyTooMuchAssignPerm(IFormView view) {
        Long userId;
        int assignPermCount;
        String strUserId = (String)view.getFormShowParameter().getCustomParam("paramUserId");
        if (StringUtils.isEmpty((String)strUserId)) {
            strUserId = String.valueOf(RequestContext.get().getCurrUserId());
        }
        if ((assignPermCount = DirectAuthorizeHelper.queryDirectAssignPermSize((Long)(userId = Long.valueOf(strUserId)))) > 400000) {
            this.wrapFeedBack(false, "showMess", ResManager.loadKDString((String)"\u5f53\u524d\u88ab\u6388\u6743\u7528\u6237\u5206\u914d\u4e86\u592a\u591a\u6743\u9650\u6570\u636e\uff0c\u4f1a\u6709\u8f83\u5dee\u6027\u80fd\u4f53\u9a8c\uff0c\u5efa\u8bae\u5220\u53bb\u6b64\u5904\u5206\u914d\uff0c\u6362\u7528\u89d2\u8272\u6388\u6743\u6216\u5168\u529f\u80fd\u7528\u6237\u3002", (String)"UserDirectAssignPermTask_19", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
            return true;
        }
        return false;
    }

    private void saveFuncPerm2DB(Long uId, String detailDimType, Set<String> mayChangedDimId, List<Object[]> mParamList, List<Object[]> dParamList, Map<String, Object> inParams) {
        try {
            if (!CollectionUtils.isEmpty(mayChangedDimId)) {
                String curCtrlType = (String)inParams.get("curCtrlType");
                List mayChangedDimIdList = mayChangedDimId.stream().map(String::valueOf).collect(Collectors.toList());
                String mayChangedDimIdSte = String.join((CharSequence)",", mayChangedDimIdList);
                DB.execute((DBRoute)DBRoute.permission, (String)("delete from t_perm_userpermdetail where fuserid = ? and fbizappid > ' ' and fentitytypeid > ' ' and fpermitemid > ' ' and fdimId in(" + mayChangedDimIdSte + ") and fdimtype = ? "), (Object[])new Object[]{uId, detailDimType});
                DB.execute((DBRoute)DBRoute.permission, (String)("delete from t_perm_userperm where fuserid = ? and forgid in(" + mayChangedDimIdSte + ") and fdimtype = ? "), (Object[])new Object[]{uId, curCtrlType});
            }
            if (!CollectionUtils.isEmpty(mParamList)) {
                String mainTSql = "insert into t_perm_userperm (fid, fuserid, forgid, fisincludesuborg, fdimtype) values(?,?,?,?,?)";
                SqlUtil.asyncInsertThrowE(mParamList, (String)mainTSql, (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.basedata);
            }
            if (!CollectionUtils.isEmpty(dParamList)) {
                String detailSql = "insert into t_perm_userpermdetail (fid, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid , fsource, fuserid, fdimid, fisincludesub, fdimtype) values(?,?,?,?,?,?,?,?,?,?,?,?)";
                SqlUtil.asyncInsertThrowE(dParamList, (String)detailSql, (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.basedata);
            }
        }
        catch (Exception e) {
            log.warn("UserDirectAssignPermTask.saveFuncPerm2DB tx error", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private Callable<Map<String, Object>> wrapDetailParamCallable(final Map<String, Object> paraMap) {
        return new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                HashMap<String, Object> map = new HashMap<String, Object>(3);
                map.put("dParamList", new ArrayList(1));
                map.put("busiCheckMsg", "");
                map.put("appEntityMap", new HashMap(1));
                try {
                    Long userId = (Long)paraMap.get("uId");
                    String appNum = (String)paraMap.get("appNum");
                    Long curDimObjId = (Long)paraMap.get("curDimObjId");
                    boolean includeSubOrg = (Boolean)paraMap.get("includeSubOrg");
                    String detailDimType = (String)paraMap.get("detailDimType");
                    TreeView funcPermTreeView = (TreeView)paraMap.get("funcPermTreeView");
                    TreeView fieldPermTreeView = (TreeView)paraMap.get("fieldPermTreeView");
                    TreeView dataPermTreeView = (TreeView)paraMap.get("dataPermTreeView");
                    Set finalMayChangedDimId = (Set)paraMap.get("finalMayChangedDimId");
                    String dimObjName = (String)paraMap.get("dimObjName");
                    int i = (Integer)paraMap.get("index");
                    String mainFId = (String)paraMap.get("mainFId");
                    TreeView allFuncPermTreeView = (TreeView)paraMap.get("allFuncPermTreeView");
                    String curCtrlType = (String)paraMap.get("curCtrlType");
                    String curDimObjIdStr = String.valueOf(curDimObjId);
                    HashMap<String, Object> treeParaMap = new HashMap<String, Object>(16);
                    treeParaMap.put("allFuncPermTreeView", allFuncPermTreeView);
                    treeParaMap.put("userTreeViews", new TreeView[]{funcPermTreeView, fieldPermTreeView, dataPermTreeView});
                    treeParaMap.put("pIds", Collections.singleton(curDimObjIdStr));
                    treeParaMap.put("pAppNum", appNum);
                    treeParaMap.put("pDimension", curCtrlType);
                    treeParaMap.put("curorgId", curDimObjId);
                    treeParaMap.put("pEnable", true);
                    treeParaMap.put("customParam", null);
                    UserFuncPermTreeUtil util = new UserFuncPermTreeUtil(treeParaMap);
                    List<Map<String, String>> userPermInfoList = util.getCurPermData();
                    if (CollectionUtils.isEmpty(userPermInfoList)) {
                        String info = String.format(ResManager.loadKDString((String)"%1$s\u5217\u8868\u7b2c%2$s\u884c\u7684\u201c%3$s\u201d\u672a\u5206\u914d\u529f\u80fd\u6743\u9650\u3002", (String)"UserDirectAssignPermTask_10", (String)systemTypeFormplugin, (Object[])new Object[0]), PermCommonUtil.getDimTypeName((String)curCtrlType), String.valueOf(i + 1), dimObjName);
                        map.put("busiCheckMsg", info);
                        return map;
                    }
                    int size = userPermInfoList.size();
                    long[] detailFIds = DB.genGlobalLongIds((int)size);
                    HashMap<String, Set> appEntityMap = new HashMap<String, Set>(8);
                    ArrayList<Object[]> dParamList = new ArrayList<Object[]>(size);
                    Object[] dParamObj = null;
                    for (int j = 0; j < size; ++j) {
                        Map<String, String> data = userPermInfoList.get(j);
                        if (!finalMayChangedDimId.contains(curDimObjIdStr)) continue;
                        String appId = data.get("appId");
                        String entityNum = data.get("entityNumber");
                        String permItemId = data.get("permItemId");
                        dParamObj = new Object[]{mainFId, detailFIds[j], 0, "10", permItemId, entityNum, appId, "1", userId, curDimObjId, includeSubOrg, detailDimType};
                        dParamList.add(dParamObj);
                        appEntityMap.computeIfAbsent(appId, k -> new HashSet()).add(entityNum);
                    }
                    map.put("dParamList", dParamList);
                    map.put("appEntityMap", appEntityMap);
                    return map;
                }
                catch (Exception e) {
                    log.warn("UserDirectAssignPermTask.wrapDetailParamCallable error.", (Throwable)e);
                    throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
                }
            }
        };
    }

    private String getCurDimObjIdStr(boolean checkOrgDim, DynamicObject dimObj, String curCtrlType) {
        if (checkOrgDim) {
            return dimObj.getString("org_id");
        }
        if ("DIM_BCM_MODEL".equals(curCtrlType) || "bcm_model".equals(curCtrlType)) {
            return dimObj.getString("org_number_id");
        }
        if ("DIM_EPM_MODEL".equals(curCtrlType)) {
            return dimObj.getString("dim_num_id");
        }
        return dimObj.getString("dim_num_id");
    }

    private void clearUsrDireFunMayChangedDimId(Map<String, Object> params) {
        String pageId = (String)params.get("pageId");
        String type = CacheMrg.getType4UserDirectFunPerm();
        String key = "directMayChangedDimId_" + pageId;
        CacheMrg.clearCache((String)type, (String)key);
    }

    protected void recordDataChangeFlag(IFormView view) {
        IDataModel iDataModel;
        Boolean ifDataChanged = (Boolean)(iDataModel = view.getModel()).getValue("datachangeflag");
        iDataModel.setValue("datachangeflag", (Object)(ifDataChanged == false ? 1 : 0));
    }

    protected void recordDataPermToCache(String focusNodeId, String dataPermJson, String dataStatus, String dimObjId, IFormView view) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
        String jsonRuleMap = permPageCacheUtil.get("dataPermCache");
        Map ruleMap = (Map)SerializationUtils.fromJsonString((String)jsonRuleMap, Map.class);
        String strDimObjId = String.valueOf(this.getCurSelDimObjId(view));
        Map<String, Object> dimObjRuleMap = null;
        dimObjRuleMap = StringUtils.isNotEmpty((String)dimObjId) ? (HashMap<String, String[]>)ruleMap.get(dimObjId) : (Map)ruleMap.get(strDimObjId);
        if (dimObjRuleMap == null) {
            dimObjRuleMap = new HashMap<String, String[]>();
        }
        String realFocusNodeId = this.getRealPreviousFoucusNodeId(focusNodeId);
        dimObjRuleMap.put(realFocusNodeId, new String[]{dataPermJson, dataStatus});
        if (StringUtils.isNotEmpty((String)dimObjId)) {
            ruleMap.put(dimObjId, dimObjRuleMap);
        } else {
            ruleMap.put(strDimObjId, dimObjRuleMap);
        }
        permPageCacheUtil.put("dataPermCache", SerializationUtils.toJsonString((Object)ruleMap));
    }

    public String getPageCacheSetDataPermKey(String orgId) {
        if (StringUtils.isNotEmpty((String)orgId) && !"-1".equals(orgId) && !"null".equals(orgId)) {
            return "pageCache_hasSetDataPerm_" + orgId;
        }
        return "pageCache_hasSetDataPerm";
    }

    protected String[] getStrArrFromDataPermissionMap(Map<String, Object> orgRuleMap, String nodeId) {
        Object orgRuleMapValue = orgRuleMap.get(nodeId);
        String[] arrDataPerm = null;
        if (orgRuleMapValue instanceof List) {
            List valueList = (List)orgRuleMapValue;
            if (valueList == null || valueList.size() < 2) {
                return null;
            }
            arrDataPerm = new String[]{(String)valueList.get(0), (String)valueList.get(1)};
        } else if (orgRuleMapValue instanceof String[]) {
            arrDataPerm = (String[])orgRuleMapValue;
        }
        return arrDataPerm;
    }

    protected String getRealPreviousFoucusNodeId(String previousFocusNodeId) {
        String realPreviousFocusNodeId = null;
        realPreviousFocusNodeId = previousFocusNodeId != null && previousFocusNodeId.contains("$") ? previousFocusNodeId.substring(previousFocusNodeId.indexOf(36) + 1, previousFocusNodeId.length()) : previousFocusNodeId;
        return realPreviousFocusNodeId;
    }

    private boolean reqReturn() {
        String queryString = RequestContext.get().getQueryString();
        log.debug("\n reqReturn, queryString:{}", (Object)queryString);
        if (StringUtils.isNotEmpty((String)queryString)) {
            String[] split = queryString.split("&");
            log.debug("\n reqReturn, queryString:{}, split:{}", (Object)queryString, (Object)JSON.toJSONString((Object)split));
            boolean present = Arrays.stream(split).filter(x -> "ac=release".equals(x) || "ac=close".equals(x) || "ac=loadData".equals(x) || "ac=selectTab".equals(x)).findFirst().isPresent();
            log.debug("\n reqReturn, queryString:{}, split:{}, present:{}", new Object[]{queryString, JSON.toJSONString((Object)split), present});
            if (present) {
                return true;
            }
        }
        log.debug("\n reqReturn, queryString:{}, after", (Object)queryString);
        return false;
    }

    private List<Long> getCurSelDimObjIds(IFormView view) {
        EntryGrid eg = (EntryGrid)view.getControl("orglist");
        int[] rows = eg.getSelectRows();
        if (rows == null || rows.length == 0) {
            return new ArrayList<Long>();
        }
        int rowsLength = rows.length;
        if (1 == rowsLength && -1 == rows[0]) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> dimObjIds = new ArrayList<Long>(rowsLength);
        IDataModel iDataModel = view.getModel();
        DynamicObjectCollection entryEntity = iDataModel.getEntryEntity("orglist");
        int entrySize = entryEntity.size();
        for (int i = 0; i < rowsLength; ++i) {
            if (rows[i] > entrySize - 1) continue;
            String strDimObjId = ((DynamicObject)entryEntity.get(rows[i])).getString("org_id");
            Long dimObjId = null;
            dimObjId = StringUtils.isNotEmpty((String)strDimObjId) ? Long.valueOf(Long.parseLong(strDimObjId)) : Long.valueOf(-1L);
            dimObjIds.add(dimObjId);
        }
        return dimObjIds;
    }

    private UserFuncPermTreeUtil initialUserFuncPermTreeUtil(String appNum, String permDimType, Map<String, Object> inParams, IFormView view) {
        if (this.reqReturn()) {
            return null;
        }
        UserFuncPermTreeUtil userFuncPermTreeUtil = null;
        List<Long> dimObjIds = this.getCurSelDimObjIds(view);
        Long curDimObjId = this.getCurSelDimObjId(view);
        if (dimObjIds != null && dimObjIds.size() > 0) {
            TreeView allFuncPermTreeView = (TreeView)view.getControl("tree_allfunctionperm");
            TreeView funcPermTreeView = (TreeView)view.getControl("tree_funcperm");
            TreeView fieldPermTreeView = (TreeView)view.getControl("tree_fieldperm");
            TreeView dataPermTreeView = (TreeView)view.getControl("tree_dataperm");
            userFuncPermTreeUtil = new UserFuncPermTreeUtil(allFuncPermTreeView, new TreeView[]{funcPermTreeView, fieldPermTreeView, dataPermTreeView}, dimObjIds, appNum, permDimType, curDimObjId);
            userFuncPermTreeUtil.initListener();
        }
        return userFuncPermTreeUtil;
    }

    protected void checkAndUpdateDataPermStatus(String previousFocusNodeId, Map<String, Object> orgRuleMap, Map<String, Object> inParams, IFormView view) {
        String realPreviousFocusNodeId = this.getRealPreviousFoucusNodeId(previousFocusNodeId);
        String[] arrDataPerm = this.getStrArrFromDataPermissionMap(orgRuleMap, realPreviousFocusNodeId);
        FilterGrid filterGrid = (FilterGrid)view.getControl("filtergrid_dataperm");
        FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
        List filterRowList = fc.getFilterRow();
        boolean validFilterCondition = false;
        String newDataPermJson = null;
        if (filterRowList == null || filterRowList.isEmpty()) {
            validFilterCondition = false;
        } else {
            validFilterCondition = true;
            newDataPermJson = SerializationUtils.toJsonString((Object)fc);
        }
        String orgId = ((String[])orgRuleMap.get("orgId"))[0];
        List<Object> hasSetEntityKeysList = new ArrayList();
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
        String appNum = permPageCacheUtil.get("FormShowParam_appNum");
        String curCtrlType = (String)inParams.get("curCtrlType");
        UserFuncPermTreeUtil userFuncPermTreeUtil = this.initialUserFuncPermTreeUtil(appNum, curCtrlType, inParams, view);
        if (userFuncPermTreeUtil != null) {
            hasSetEntityKeysList = userFuncPermTreeUtil.getHasSetPermEntityKeys(this.getPageCacheSetDataPermKey(orgId));
        }
        HashSet<Object> hasSetEntityKeysSet = new HashSet();
        if (null != hasSetEntityKeysList && hasSetEntityKeysList.size() > 0) {
            hasSetEntityKeysSet = new HashSet<Object>(hasSetEntityKeysList);
        }
        String entityNum = AllFuncPermTreeUtil.getEntityNumFromNodeId(previousFocusNodeId);
        String appId = AllFuncPermTreeUtil.getAppIdFromNodeId(previousFocusNodeId);
        String entityKey = entityNum + "@" + appId;
        hasSetEntityKeysList = new ArrayList(hasSetEntityKeysSet);
        if (arrDataPerm == null || StringUtils.isEmpty((String)arrDataPerm[0])) {
            if (validFilterCondition) {
                hasSetEntityKeysSet.add(entityKey);
                this.recordDataPermToCache(previousFocusNodeId, newDataPermJson, "1", orgId, view);
                this.recordDataChangeFlag(view);
            }
        } else if (StringUtils.isNotEmpty((String)newDataPermJson)) {
            if (!arrDataPerm[0].equals(newDataPermJson)) {
                this.recordDataPermToCache(previousFocusNodeId, newDataPermJson, "3", orgId, view);
                this.recordDataChangeFlag(view);
            }
        } else {
            hasSetEntityKeysSet.remove(entityKey);
            this.recordDataPermToCache(previousFocusNodeId, newDataPermJson, "2", orgId, view);
            this.recordDataChangeFlag(view);
        }
        hasSetEntityKeysList = new ArrayList<Object>(hasSetEntityKeysSet);
        permPageCacheUtil.put(this.getPageCacheSetDataPermKey(orgId), SerializationUtils.toJsonString(hasSetEntityKeysList));
    }

    public static Set<String> getMayChangedDimId(String pageId) {
        String mayChangedDimIdPageCacheKey = "directMayChangedDimId_" + pageId;
        String removeLeftDimIdStr = CacheMrg.getCache((String)CacheMrg.getType4UserDirectFunPerm(), (String)mayChangedDimIdPageCacheKey);
        if (StringUtils.isNotEmpty((String)removeLeftDimIdStr)) {
            return (Set)SerializationUtils.fromJsonString((String)removeLeftDimIdStr, Set.class);
        }
        return new HashSet<String>(1);
    }

    private Long getCurSelDimObjId(IFormView view) {
        IDataModel dataModel = view.getModel();
        Long dimObjId = null;
        int focusRow = dataModel.getEntryCurrentRowIndex("orglist");
        if (focusRow == -1) {
            return -1L;
        }
        String strDimObjId = (String)dataModel.getValue("org_id", focusRow);
        if (!StringUtils.isNotEmpty((String)strDimObjId)) {
            return -1L;
        }
        dimObjId = Long.parseLong(strDimObjId);
        return dimObjId;
    }

    protected void recordPreviousDataPerm(Map<String, Object> params, IFormView view) {
        boolean hasEnableOldDataRule = (Boolean)params.get("hasEnableOldDataRule");
        if (!hasEnableOldDataRule) {
            return;
        }
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
        String previousFocusNodeId = permPageCacheUtil.get("pagecache_dataperm_previous_focusNode");
        String previousSelDimObjId = permPageCacheUtil.get("pagecache_dataperm_previous_orgId");
        if (previousFocusNodeId != null && previousFocusNodeId.contains("#entity")) {
            HashMap<String, Object> dimObjRuleMap;
            String dataPermCache = permPageCacheUtil.get("dataPermCache");
            if (StringUtils.isEmpty((String)dataPermCache)) {
                return;
            }
            Map ruleMap = (Map)SerializationUtils.fromJsonString((String)dataPermCache, Map.class);
            Long dimObjId = this.getCurSelDimObjId(view);
            String strDimObjId = String.valueOf(dimObjId);
            if (StringUtils.isEmpty((String)previousSelDimObjId)) {
                previousSelDimObjId = strDimObjId;
            }
            if ((dimObjRuleMap = (HashMap<String, Object>)ruleMap.get(previousSelDimObjId)) == null) {
                dimObjRuleMap = new HashMap<String, Object>();
            }
            dimObjRuleMap.put("orgId", new String[]{previousSelDimObjId});
            this.checkAndUpdateDataPermStatus(previousFocusNodeId, dimObjRuleMap, params, view);
        }
    }

    private Set<String> getFinalMayChangedDimIds(Map<String, Object> params, IFormView view) {
        String pageId = (String)params.get("pageId");
        boolean hasEnableOldDataRule = (Boolean)params.get("hasEnableOldDataRule");
        Set<String> mayChangedDimId = UserDirectAssignPermTask.getMayChangedDimId(pageId);
        if (hasEnableOldDataRule) {
            this.recordPreviousDataPerm(params, view);
            PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view.getPageCache());
            String dataPermCache = permPageCacheUtil.get("dataPermCache");
            if (StringUtils.isEmpty((String)dataPermCache)) {
                return mayChangedDimId;
            }
            Map ruleMap = (Map)SerializationUtils.fromJsonString((String)dataPermCache, Map.class);
            for (Map.Entry map : ruleMap.entrySet()) {
                String key = (String)map.getKey();
                Map value = (Map)map.getValue();
                if (CollectionUtils.isEmpty((Map)value)) continue;
                mayChangedDimId.add(key);
            }
        }
        return mayChangedDimId;
    }

    private boolean checkDataRuleCanSave(Map<String, Object> params, IFormView view) {
        EntryGrid bdEntryGrid;
        boolean hasEnableOldDataRule = (Boolean)params.get("hasEnableOldDataRule");
        if (hasEnableOldDataRule) {
            return true;
        }
        EntryGrid dataRuleEntryGrid = (EntryGrid)view.getControl("entryentity_datarule");
        if (dataRuleEntryGrid.getEntryData().getEndIndex() != 0) {
            DynamicObject[] dynamicObjects;
            for (DynamicObject object : dynamicObjects = dataRuleEntryGrid.getEntryData().getDataEntitys()) {
                Object permitem = object.get("permitem");
                Object datarule = object.get("datarule");
                if (permitem != null && datarule == null) {
                    this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u7684\u201c\u65b9\u6848\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectAssignPermTask_20", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                    return false;
                }
                if (permitem == null && datarule != null) {
                    this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u7684\u201c\u6743\u9650\u9879\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectAssignPermTask_21", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                    return false;
                }
                if (permitem != null) continue;
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u7684\u201c\u6743\u9650\u9879\u201d\u548c\u201c\u65b9\u6848\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectAssignPermTask_22", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return false;
            }
        }
        if ((bdEntryGrid = (EntryGrid)view.getControl("entryentity_bddatarule")).getEntryData().getEndIndex() != 0) {
            DynamicObject[] dynamicObjects;
            for (DynamicObject object : dynamicObjects = bdEntryGrid.getEntryData().getDataEntitys()) {
                Object bddatarule = object.get("bddatarule");
                if (null != bddatarule) continue;
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u9875\u7b7e\u201c\u57fa\u7840\u8d44\u6599\u6570\u636e\u8303\u56f4\u201d\u4e2d\u7684\u201c\u65b9\u6848\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserDirectAssignPermTask_23", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return false;
            }
        }
        return true;
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }
}

