/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.model.UgRoleDim;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.log.model.LogOldDataRule;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.permission.model.perm.DimUserEdit;
import kd.bos.permission.service.UserGroupService;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class UsrGrpAssignRoleMultiTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(UsrGrpAssignRoleMultiTask.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"UsrGrpAssignRoleMultiTask", (int)1);
    private static String systemTypeFormplugin = "bos-permission-formplugin";
    private static final String USRGRP = "usrgrp";
    private static final String PGCACHE_NOTLOADEDBUTDEL_LEFTIDS = "pgcache_notLoadedButDel_LeftIds";
    private static final String PGCACHE_LOADEDANDMODIFIEDDATAMAP = "pgcache_loadedAndModifiedDataMap";
    private static final String PGCACHE_BATCHADDDATAMAP = "pgcache_batchAddDataMap";
    private static final String PGCACHE_ISLEFTDIM = "pgcache_isleftdim";
    private static final String ENDTIMECONST = "2999-12-31 23:59:59";

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"UsrGrpAssignRoleMultiTask_0", (String)systemTypeFormplugin, (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        try {
            this.dealMainBusi(params);
            desc = ResManager.loadKDString((String)"\u64cd\u4f5c\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u3002", (String)"UsrGrpAssignRoleMultiTask_1", (String)systemTypeFormplugin, (Object[])new Object[0]);
            int progress = 98;
            this.feedbackProgress(progress, desc, null);
        }
        catch (Exception e) {
            log.warn("UsrGrpAssignRoleMultiTask.execute error", (Throwable)e);
            this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:%1$s", (String)"UsrGrpAssignRoleMultiTask_2", (String)systemTypeFormplugin, (Object[])new Object[0]), e.getMessage()), null);
        }
    }

    private void dealMainBusi(final Map<String, Object> params) {
        try {
            Map batchAddDataMap;
            String jsonMap;
            final String pageId = (String)params.get("pageId");
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            IDataModel dataModel = view.getModel();
            DynamicObject usrGrp = (DynamicObject)dataModel.getValue(USRGRP);
            if (null == usrGrp) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u7ec4", (String)"UsrGrpAssignRoleMultiTask_3", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
                return;
            }
            final String usrGrpId = usrGrp.getString("id");
            int progress = 5;
            this.feedbackProgress(progress, ResManager.loadKDString((String)"\u754c\u9762\u6570\u636e\u83b7\u53d6\u5b8c\u6bd5\uff0c\u51c6\u5907\u8fdb\u884c\u89e3\u6790\u3002", (String)"UsrGrpAssignRoleMultiTask_4", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
            final Map<String, Object> notLoadedButDelDataParamMap = this.getNotLoadedButDelDataParam(usrGrpId, view, pageId);
            progress = 15;
            this.feedbackProgress(progress, ResManager.loadKDString((String)"\u754c\u9762\u4fe1\u606f\u89e3\u6790\u4e2d\u3002", (String)"UsrGrpAssignRoleMultiTask_5", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
            final Map<String, Object> loadedAndModifiedDataParamMap = this.getLoadedAndModifiedDataParam(usrGrpId, view, pageId);
            progress = 25;
            this.feedbackProgress(progress, ResManager.loadKDString((String)"\u754c\u9762\u4fe1\u606f\u89e3\u6790\u4e2d\u3002", (String)"UsrGrpAssignRoleMultiTask_5", (String)systemTypeFormplugin, (Object[])new Object[0]), null);
            final HashSet<String> dimType4log = new HashSet<String>(8);
            final HashSet<Long> dimId4log = new HashSet<Long>(8);
            final HashSet<String> roleId4log = new HashSet<String>(8);
            if (PermCommonUtil.isEnablePermLog() && null != (jsonMap = view.getPageCache().get(PGCACHE_BATCHADDDATAMAP)) && !StringUtils.isEmpty((String)jsonMap) && null != (batchAddDataMap = (Map)SerializationUtils.fromJsonString((String)jsonMap, Map.class)) && !batchAddDataMap.isEmpty()) {
                Set keySet = batchAddDataMap.keySet();
                for (String key : keySet) {
                    if (key.contains("role$")) {
                        String[] roleSplit = key.split("\\$");
                        if (roleSplit.length == 0) continue;
                        for (int i = 1; i < roleSplit.length; ++i) {
                            String roleId = roleSplit[i];
                            roleId4log.add(roleId);
                        }
                        continue;
                    }
                    String[] dimSplit = key.split("\\$");
                    if (dimSplit.length == 0) continue;
                    String dimType = dimSplit[0];
                    dimType4log.add(dimType);
                    for (int i = 1; i < dimSplit.length; ++i) {
                        Long dimId = Long.valueOf(dimSplit[i]);
                        dimId4log.add(dimId);
                    }
                }
            }
            if (this.isStop()) {
                this.stop();
            }
            Future saveDataFuture = pool.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Set dimTypeForlogSet = (Set)notLoadedButDelDataParamMap.get("dimTypeForlogSet");
                    dimTypeForlogSet.addAll((Set)loadedAndModifiedDataParamMap.get("dimTypeForlogSet"));
                    dimTypeForlogSet.addAll(dimType4log);
                    Set dimIdForlogSet = (Set)notLoadedButDelDataParamMap.get("dimIdForlogSet");
                    dimIdForlogSet.addAll((Set)loadedAndModifiedDataParamMap.get("dimIdForlogSet"));
                    dimIdForlogSet.addAll(dimId4log);
                    Set roleIdForlogSet = (Set)notLoadedButDelDataParamMap.get("roleIdForlogSet");
                    roleIdForlogSet.addAll((Set)loadedAndModifiedDataParamMap.get("roleIdForlogSet"));
                    roleIdForlogSet.addAll(roleId4log);
                    List preList = UserGroupHelper.getPURList((Set)roleIdForlogSet, null, (Set)Sets.newHashSet((Object[])new Long[]{Long.valueOf(usrGrpId)}), (Set)dimIdForlogSet, (Set)dimTypeForlogSet, (boolean)false);
                    UsrGrpAssignRoleMultiTask.save2DB(notLoadedButDelDataParamMap, loadedAndModifiedDataParamMap, pageId);
                    List afterList = UserGroupHelper.getPURList((Set)roleIdForlogSet, null, (Set)Sets.newHashSet((Object[])new Long[]{Long.valueOf(usrGrpId)}), (Set)dimIdForlogSet, (Set)dimTypeForlogSet, (boolean)false);
                    Map diffMap = UgRoleDim.logCompareMutiThread((List)preList, (List)afterList);
                    UsrGrpAssignRoleMultiTask.this.busiAfterSave(usrGrpId, diffMap, params);
                    return 1;
                }
            });
            this.cycle2GetDataSaveProgress(progress, saveDataFuture, 98);
        }
        catch (Exception e) {
            log.warn("UsrGrpAssignRoleMultiTask.dealMainBusi error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private void busiAfterSave(String usrGrpId, Map<String, Object> diffPURMap, Map<String, Object> params) throws Exception {
        ArrayList changedUsrGrpIdList = Lists.newArrayList((Object[])new Long[]{Long.valueOf(usrGrpId)});
        HashSet lisenceUserIdSet = new HashSet(1);
        List delList = new LinkedList();
        List addList = new LinkedList();
        HashSet<String> roleIds = new HashSet<String>(8);
        if (!CollectionUtils.isEmpty(diffPURMap)) {
            delList = (List)diffPURMap.get("del");
            addList = (List)diffPURMap.get("add");
            if (null != addList && !addList.isEmpty()) {
                for (UgRoleDim ugRoleDim : addList) {
                    roleIds.add(ugRoleDim.getRoleId());
                    Long addUsrGrpId = ugRoleDim.getUsrGrpId();
                    lisenceUserIdSet.addAll(UserGroupService.getUsersIdByUsrGrpId((Long)addUsrGrpId));
                }
            }
            if (null != delList && !delList.isEmpty()) {
                for (UgRoleDim ugRoleDim : delList) {
                    roleIds.add(ugRoleDim.getRoleId());
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)changedUsrGrpIdList)) {
            Set changedUserIdList = UserGroupService.getUsersIdByUsrGrpIds((List)changedUsrGrpIdList);
            UserHasPermOrgCache.clearUserLoginOrgs((Collection)changedUserIdList);
            List<Object> appEntityAllList = new ArrayList(16);
            if (!CollectionUtils.isEmpty(roleIds)) {
                String langStr = RequestContext.get().getLang().name();
                HashSet<String> appEntityAllSet = new HashSet<String>(16);
                if (PermCommonUtil.hasEnableOldDataRule()) {
                    for (String roleId : roleIds) {
                        List oldDataRuleList = PermRoleLogHelper.getOldDataRuleList((String)roleId, (String)langStr);
                        for (LogOldDataRule oldDataRule : oldDataRuleList) {
                            appEntityAllSet.add(oldDataRule.getAppId() + "|" + oldDataRule.getEntityId());
                        }
                    }
                } else {
                    for (String roleId : roleIds) {
                        LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)roleId, (String)langStr);
                        appEntityAllSet.addAll(newDataRule.getNewDRAppEntitySet());
                    }
                }
                if (!CollectionUtils.isEmpty(appEntityAllSet)) {
                    appEntityAllList = appEntityAllSet.stream().map(x -> {
                        String[] split = x.split("\\|", 2);
                        HashMap<String, String> map = new HashMap<String, String>(2);
                        map.put(split[0], split[1]);
                        return map;
                    }).collect(Collectors.toList());
                    PermCommonUtil.cancelShowForm(new ArrayList(changedUserIdList), appEntityAllList, (boolean)false);
                }
            }
        }
        Map appEntityMap = PermissionServiceHelper.getAppEntityByRoleSet(roleIds);
        LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList(lisenceUserIdSet), (Map)appEntityMap);
        if (!(!PermCommonUtil.isEnablePermLog() || CollectionUtils.isEmpty(diffPURMap) || CollectionUtils.isEmpty(delList) && CollectionUtils.isEmpty(addList))) {
            diffPURMap.put("langStr", RequestContext.get().getLang().name());
            String opbtn = ConstantsHelper.getSave();
            this.usrGrpAssignCommRoleMulti2PermLog("baritem_save", opbtn, StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffPURMap)), params);
        }
        PermissionServiceHelper.clearAllCache();
        this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UsrGrpAssignRoleMultiTask_6", (String)"bos-permission-formplugin", (Object[])new Object[0]), 3000);
    }

    private void usrGrpAssignCommRoleMulti2PermLog(String op, String opbtn, String diffContent, Map<String, Object> params) {
        String opItemNumber = (String)params.get("usrGrpNumber");
        try {
            String opItemId = (String)params.get("usrGrpId");
            String opItemName = (String)params.get("usrGrpName");
            String appId = (String)params.get("appId");
            String formNum = (String)params.get("formNum");
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            String pageId = (String)params.get("pageId");
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"usergroup_assigncommrole");
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.task.UsrGrpAssignRoleMultiTask.usrGrpAssignCommRoleMulti2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", diffContent);
            map.put("oper_id", Long.parseLong(params.get("oper_id").toString()));
            map.put("oper_org_id", Long.parseLong(params.get("oper_org_id").toString()));
            map.put("oper_time", TimeServiceHelper.now());
            map.put("client_type", params.get("client_type"));
            map.put("client_ip", params.get("client_ip"));
            map.put("client_name", params.get("client_name"));
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("UsrGrpAssignRoleMultiTask.usrGrpAssignCommRoleMulti2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private static void save2DB(Map<String, Object> notLoadedButDelDataParamMap, Map<String, Object> loadedAndModifiedDataParamMap, String pageId) {
        try (TXHandle txHandle = TX.required();){
            try {
                List deleteParamList;
                List updateParamList;
                List notLoadedButDelDataParamList = (List)notLoadedButDelDataParamMap.get("deleteParamList");
                if (!notLoadedButDelDataParamList.isEmpty()) {
                    String notLoadedButDelDataSql = (String)notLoadedButDelDataParamMap.get("deleteSql");
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)notLoadedButDelDataSql, (List)notLoadedButDelDataParamList);
                } else if (notLoadedButDelDataParamMap.get("deleteSqlBuilder") != null) {
                    DB.execute((DBRoute)DBRoute.permission, (SqlBuilder)((SqlBuilder)notLoadedButDelDataParamMap.get("deleteSqlBuilder")));
                }
                List insertParamList = (List)loadedAndModifiedDataParamMap.get("insertParamList");
                if (!insertParamList.isEmpty()) {
                    String insertSql = (String)loadedAndModifiedDataParamMap.get("insertSql");
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)insertSql, (List)insertParamList);
                }
                if (!(updateParamList = (List)loadedAndModifiedDataParamMap.get("updateParamList")).isEmpty()) {
                    String updateSql = (String)loadedAndModifiedDataParamMap.get("updateSql");
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)updateSql, (List)updateParamList);
                }
                if (!(deleteParamList = (List)loadedAndModifiedDataParamMap.get("deleteParamList")).isEmpty()) {
                    String deleteSql = (String)loadedAndModifiedDataParamMap.get("deleteSql");
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)deleteSql, (List)deleteParamList);
                }
                IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
                IDataModel dataModel = view.getModel();
                DynamicObject usrGrp = (DynamicObject)dataModel.getValue(USRGRP);
                String usrGrpId = usrGrp.getString("id");
                UsrGrpAssignRoleMultiTask.saveBatchAddData(usrGrpId, view);
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.warn("UsrGrpAssignRoleMultiTask.save2DB error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    private static void saveBatchAddData(String usrGrpId, IFormView view) {
        String jsonMap = view.getPageCache().get(PGCACHE_BATCHADDDATAMAP);
        if (null == jsonMap || StringUtils.isEmpty((String)jsonMap)) {
            return;
        }
        Map batchAddDataMap = (Map)SerializationUtils.fromJsonString((String)jsonMap, Map.class);
        if (null == batchAddDataMap || batchAddDataMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : batchAddDataMap.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (null == value || value.isEmpty()) continue;
            if (key.contains("role$")) {
                UsrGrpAssignRoleMultiTask.saveRoleLeft(usrGrpId, key, value);
                continue;
            }
            UsrGrpAssignRoleMultiTask.saveRoleRight(usrGrpId, key, value);
        }
    }

    private static void saveRoleRight(String usrGrpId, String key, List<String> value) {
        String[] dimSplit = key.split("\\$");
        if (dimSplit.length == 0) {
            return;
        }
        HashSet<String> queryDBDimTypeSet = new HashSet<String>(8);
        HashSet<Long> queryDBDimIdSet = new HashSet<Long>(8);
        HashSet<String> queryDBRoleIdSet = new HashSet<String>(8);
        HashSet<String> dimRoleStrSet = new HashSet<String>(8);
        String dimType = dimSplit[0];
        queryDBDimTypeSet.add(dimType);
        for (int i = 1; i < dimSplit.length; ++i) {
            if (dimRoleStrSet.size() > 1000000) {
                Set dbDimRoleStrSet = UserGroupService.getDimUsrGrpStrSet(queryDBRoleIdSet, queryDBDimTypeSet, queryDBDimIdSet, (Set)Sets.newHashSet((Object[])new Long[]{Long.valueOf(usrGrpId)}), (boolean)true);
                Sets.SetView dbNotExistsDimUserSet = Sets.difference(dimRoleStrSet, (Set)dbDimRoleStrSet);
                UsrGrpAssignRoleMultiTask.handleInsertParamListAndSave(usrGrpId, (Sets.SetView<String>)dbNotExistsDimUserSet);
                dimRoleStrSet.clear();
                queryDBDimIdSet.clear();
                queryDBRoleIdSet.clear();
            }
            Long dimId = Long.valueOf(dimSplit[i]);
            queryDBDimIdSet.add(dimId);
            for (String v : value) {
                String roleId = v.split("\\$")[1];
                queryDBRoleIdSet.add(roleId);
                dimRoleStrSet.add(dimType + "$" + dimId + "$" + roleId);
            }
        }
        Set dbDimRoleStrSet = UserGroupService.getDimUsrGrpStrSet(queryDBRoleIdSet, queryDBDimTypeSet, queryDBDimIdSet, (Set)Sets.newHashSet((Object[])new Long[]{Long.valueOf(usrGrpId)}), (boolean)true);
        Sets.SetView dbNotExistsDimUserSet = Sets.difference(dimRoleStrSet, (Set)dbDimRoleStrSet);
        UsrGrpAssignRoleMultiTask.handleInsertParamListAndSave(usrGrpId, (Sets.SetView<String>)dbNotExistsDimUserSet);
    }

    private static void saveRoleLeft(String usrGrpId, String key, List<String> value) {
        String[] roleSplit = key.split("\\$");
        if (roleSplit.length == 0) {
            return;
        }
        HashSet<String> queryDBDimTypeSet = new HashSet<String>(8);
        HashSet<Long> queryDBDimIdSet = new HashSet<Long>(8);
        HashSet<String> queryDBRoleIdSet = new HashSet<String>(8);
        HashSet<String> dimRoleStrSet = new HashSet<String>(8);
        for (int i = 1; i < roleSplit.length; ++i) {
            if (dimRoleStrSet.size() > 1000000) {
                Set dbDimRoleStrSet = UserGroupService.getDimUsrGrpStrSet(queryDBRoleIdSet, queryDBDimTypeSet, queryDBDimIdSet, (Set)Sets.newHashSet((Object[])new Long[]{Long.valueOf(usrGrpId)}), (boolean)true);
                Sets.SetView dbNotExistsDimUserSet = Sets.difference(dimRoleStrSet, (Set)dbDimRoleStrSet);
                UsrGrpAssignRoleMultiTask.handleInsertParamListAndSave(usrGrpId, (Sets.SetView<String>)dbNotExistsDimUserSet);
                dimRoleStrSet.clear();
                queryDBDimIdSet.clear();
                queryDBRoleIdSet.clear();
            }
            String roleId = roleSplit[i];
            queryDBRoleIdSet.add(roleId);
            for (String v : value) {
                dimRoleStrSet.add(v + "$" + roleId);
                String[] split = v.split("\\$");
                queryDBDimTypeSet.add(split[0]);
                queryDBDimIdSet.add(Long.valueOf(split[1]));
            }
        }
        Set dbDimRoleStrSet = UserGroupService.getDimUsrGrpStrSet(queryDBRoleIdSet, queryDBDimTypeSet, queryDBDimIdSet, (Set)Sets.newHashSet((Object[])new Long[]{Long.valueOf(usrGrpId)}), (boolean)true);
        Sets.SetView dbNotExistsDimUserSet = Sets.difference(dimRoleStrSet, (Set)dbDimRoleStrSet);
        UsrGrpAssignRoleMultiTask.handleInsertParamListAndSave(usrGrpId, (Sets.SetView<String>)dbNotExistsDimUserSet);
    }

    private static void handleInsertParamListAndSave(String usrGrpId, Sets.SetView<String> dbNotExistsDimUserSet) {
        int size = dbNotExistsDimUserSet.size();
        long[] ids = DB.genLongIds((String)"t_perm_usrgrprole", (int)size);
        Date defalueEndTime = DateUtil.toDate((String)ENDTIMECONST, (String)"yyyy-MM-dd HH:mm:ss");
        int index = 0;
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(size);
        for (String dimUser : dbNotExistsDimUserSet) {
            String[] split = dimUser.split("\\$");
            long dimId = Long.parseLong(split[1]);
            String roleId = split[2];
            insertParamList.add(new Object[]{ids[index++], dimId, Long.valueOf(usrGrpId), roleId, split[0], defalueEndTime});
        }
        if (null != insertParamList && !insertParamList.isEmpty()) {
            String batchAddInsertSql = "insert into t_perm_usrgrprole(fid, fdimid, fusrgrpid, froleid, fdimtype,fendtime) values (?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.permission, (String)batchAddInsertSql, insertParamList);
        }
    }

    private Map<String, Object> getLoadedAndModifiedDataParam(String usrGrpId, IFormView view, String pageId) {
        HashSet<String> dimTypeForlogSet = new HashSet<String>(8);
        HashSet<Long> dimIdForlogSet = new HashSet<Long>(8);
        HashSet<String> roleIdForlogSet = new HashSet<String>(8);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("dimTypeForlogSet", dimTypeForlogSet);
        map.put("dimIdForlogSet", dimIdForlogSet);
        map.put("roleIdForlogSet", roleIdForlogSet);
        StringBuilder insertSql = new StringBuilder("insert into t_perm_usrgrprole(fid, fdimid, fusrgrpid, froleid, fincludesub, fdimtype, fstarttime, fendtime) ").append("values (?,?,?,?,?,?,?,?)");
        map.put("insertSql", insertSql.toString());
        map.put("insertParamList", new ArrayList(1));
        StringBuilder updateSql = new StringBuilder("update t_perm_usrgrprole set fincludesub = ? , fstarttime = ? , fendtime = ? ").append(" where froleid = ? and fdimid = ? and fdimtype = ? and fusrgrpid = ? ");
        map.put("updateSql", updateSql.toString());
        map.put("updateParamList", new ArrayList(1));
        StringBuilder deleteSql = new StringBuilder("delete from t_perm_usrgrprole where froleid = ? and fdimid = ? and fdimtype = ? and fusrgrpid = ? ");
        map.put("deleteSql", deleteSql.toString());
        map.put("deleteParamList", new ArrayList(1));
        Map<String, String> loadedAndModifiedDataMap = this.getLoadedAndModifiedDataMap(view);
        Collection<String> values = loadedAndModifiedDataMap.values();
        if (!values.isEmpty()) {
            ArrayList dimUserEdits = new ArrayList(10);
            for (String value : values) {
                if (StringUtils.isEmpty((String)value)) continue;
                dimUserEdits.addAll(SerializationUtils.fromJsonStringToList((String)value, DimUserEdit.class));
            }
            int size = dimUserEdits.size();
            long[] ids = DB.genLongIds((String)"t_perm_usrgrprole", (int)size);
            int index = 0;
            ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(size);
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(size);
            ArrayList<Object[]> deleteParamList = new ArrayList<Object[]>(size);
            for (DimUserEdit dimUserEdit : dimUserEdits) {
                DimUserEdit.DataStatus dataStatus = dimUserEdit.getDataStatus();
                Long dimId = dimUserEdit.getDimId();
                String roleId = dimUserEdit.getRoleId();
                Boolean includeSub = dimUserEdit.getIncludeSub();
                String dimType = dimUserEdit.getDimType();
                Date startTime = dimUserEdit.getStartTime();
                Date endTime = dimUserEdit.getEndTime();
                if (DimUserEdit.DataStatus.INSERT.equals((Object)dataStatus)) {
                    insertParamList.add(new Object[]{ids[index++], dimId, Long.valueOf(usrGrpId), roleId, includeSub, dimType, startTime, endTime});
                } else if (DimUserEdit.DataStatus.UPDATE.equals((Object)dataStatus)) {
                    updateParamList.add(new Object[]{includeSub, startTime, endTime, roleId, dimId, dimType, Long.valueOf(usrGrpId)});
                } else if (DimUserEdit.DataStatus.DELETE.equals((Object)dataStatus)) {
                    deleteParamList.add(new Object[]{roleId, dimId, dimType, Long.valueOf(usrGrpId)});
                }
                dimTypeForlogSet.add(dimType);
                dimIdForlogSet.add(dimId);
                roleIdForlogSet.add(roleId);
            }
            map.put("insertParamList", insertParamList);
            map.put("updateParamList", updateParamList);
            map.put("deleteParamList", deleteParamList);
        }
        return map;
    }

    private Map<String, String> getLoadedAndModifiedDataMap(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String json = pageCache.get(PGCACHE_LOADEDANDMODIFIEDDATAMAP);
        if (StringUtils.isEmpty((String)json)) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            pageCache.put(PGCACHE_LOADEDANDMODIFIEDDATAMAP, SerializationUtils.toJsonString(map));
            return map;
        }
        return (Map)SerializationUtils.fromJsonString((String)json, Map.class);
    }

    private Map<String, Object> getNotLoadedButDelDataParam(String usrGrpId, IFormView view, String pageId) {
        HashSet<String> dimTypeForlogSet = new HashSet<String>(8);
        HashSet<Long> dimIdForlogSet = new HashSet<Long>(8);
        HashSet<String> roleIdForlogSet = new HashSet<String>(8);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("deleteSql", "");
        map.put("deleteParamList", new ArrayList(1));
        map.put("dimTypeForlogSet", dimTypeForlogSet);
        map.put("dimIdForlogSet", dimIdForlogSet);
        map.put("roleIdForlogSet", roleIdForlogSet);
        String delDimIds = view.getPageCache().get(PGCACHE_NOTLOADEDBUTDEL_LEFTIDS);
        if (StringUtils.isEmpty((String)delDimIds) || Objects.equals("[]", delDimIds)) {
            return map;
        }
        List delLeftIdsList = (List)SerializationUtils.fromJsonString((String)delDimIds, List.class);
        ArrayList<Object[]> deleteParamList = new ArrayList<Object[]>(delLeftIdsList.size());
        HashSet<String> delDimInfoStrSet = new HashSet<String>(delLeftIdsList.size());
        for (String delLeftIds : delLeftIdsList) {
            String[] split = delLeftIds.split("\\$");
            if ("role".equals(split[0])) {
                roleIdForlogSet.add(split[1]);
                continue;
            }
            String dimType = split[0];
            Long dimId = Long.valueOf(split[1]);
            dimTypeForlogSet.add(dimType);
            dimIdForlogSet.add(dimId);
            delDimInfoStrSet.add(dimType + dimId);
        }
        if (!CollectionUtils.isEmpty(delDimInfoStrSet)) {
            Set delUsrGrpRoleIds;
            SqlBuilder sb = new SqlBuilder();
            sb.append("select CONCAT(fdimtype,fdimid) as res, fid ", new Object[0]);
            sb.append("from t_perm_usrgrprole ", new Object[0]);
            sb.append(" where fusrgrpid = ?", new Object[]{Long.valueOf(usrGrpId)});
            if (!CollectionUtils.isEmpty(dimTypeForlogSet)) {
                sb.appendIn(" and fdimtype ", dimTypeForlogSet.toArray());
            }
            if (!CollectionUtils.isEmpty(dimIdForlogSet)) {
                sb.appendIn(" and fdimid ", dimIdForlogSet.toArray());
            }
            if (!(delUsrGrpRoleIds = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sb, rs -> {
                HashSet<Long> result = new HashSet<Long>(10);
                while (rs.next()) {
                    String res = rs.getString("res");
                    if (!delDimInfoStrSet.contains(res)) continue;
                    result.add(rs.getLong("fid"));
                }
                return result;
            })).isEmpty()) {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("delete from t_perm_usrgrprole ", new Object[0]);
                sqlBuilder.appendIn(" where fid ", delUsrGrpRoleIds.toArray());
                map.put("deleteSqlBuilder", sqlBuilder);
            }
        }
        if (null != roleIdForlogSet && !roleIdForlogSet.isEmpty()) {
            StringBuilder roleIdStr = new StringBuilder();
            for (String roleId : roleIdForlogSet) {
                roleIdStr.append('\'').append(roleId).append("',");
            }
            roleIdStr.deleteCharAt(roleIdStr.length() - 1);
            map.put("deleteSql", "delete from t_perm_usrgrprole where fusrgrpid = ? and froleid in (" + roleIdStr + ")");
            deleteParamList.add(new Object[]{Long.valueOf(usrGrpId)});
            map.put("deleteParamList", deleteParamList);
            return map;
        }
        return map;
    }

    private void cycle2GetDataSaveProgress(int progress, Future<Object> saveDataFuture, int target) throws ExecutionException {
        Object o = null;
        while (progress < target) {
            try {
                o = saveDataFuture.get(500L, TimeUnit.MILLISECONDS);
                if (1 != (Integer)o) continue;
                progress = target;
            }
            catch (InterruptedException e) {
                progress = this.dataSavingProgress(progress, target);
            }
            catch (TimeoutException e) {
                progress = this.dataSavingProgress(progress, target);
            }
        }
        if (o == null || 1 != (Integer)o) {
            try {
                saveDataFuture.get();
            }
            catch (InterruptedException e) {
                log.warn("UsrGrpAssignRoleMultiTask_cycle2GetDataSaveProgress saveDataFuture.get error.", (Throwable)e);
                this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:%1$s", (String)"UsrGrpAssignRoleMultiTask_2", (String)systemTypeFormplugin, (Object[])new Object[0]), e.getMessage()), null);
            }
        }
    }

    private int dataSavingProgress(int progress, int target) {
        String desc = ResManager.loadKDString((String)"\u6570\u636e\u5b58\u50a8\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"UsrGrpAssignRoleMultiTask_7", (String)systemTypeFormplugin, (Object[])new Object[0]);
        if (progress < target - 1) {
            ++progress;
        }
        this.feedbackProgress(progress, desc, null);
        return progress;
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }
}

