/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.model.UgRoleDim;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.formplugin.plugin.UsrGrpAssignRolePlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.log.model.LogOldDataRule;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class UsrGrpAssignRoleTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(UsrGrpAssignRoleTask.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"UsrGrpAssignRoleTask", (int)2);
    private static final String MAY_CHANGED_DIMID = "mayChangedDimId";
    public static final String PGCACHE_HASLOAD_ORGIDS = "pageCache_HasLoadOrgIds";

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"UsrGrpAssignRoleTask_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        try {
            String pageId = (String)params.get("pageId");
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            IDataModel dataModel = view.getModel();
            this.checkSaveUsrGrpRoleDim(dataModel, params);
            desc = ResManager.loadKDString((String)"\u64cd\u4f5c\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d\u3002", (String)"UsrGrpAssignRoleTask_1", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 98;
            this.feedbackProgress(progress, desc, null);
        }
        catch (Exception e) {
            log.warn("UsrGrpAssignRoleTask.execute error", (Throwable)e);
            this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:%1$s", (String)"UsrGrpAssignRoleTask_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), e.getMessage()), null);
        }
    }

    private void ugAssignRoleSave2PermLog(String op, String opbtn, String opItemId, String opItemNumber, String opItemName, String diffContent, Map<String, Object> params) {
        try {
            String appId = (String)params.get("appId");
            String cloudId = AppMetadataCache.getAppInfo((String)appId).getCloudId();
            String formNum = (String)params.get("formNum");
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"usergroup_assigncommrole");
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", BizAppServiceHelp.getAppIdByFormNum((String)formNum));
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.task.UsrGrpAssignRoleTask.ugAssignRoleSave2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", diffContent);
            map.put("oper_id", Long.parseLong(params.get("oper_id").toString()));
            map.put("oper_org_id", Long.parseLong(params.get("oper_org_id").toString()));
            map.put("oper_time", TimeServiceHelper.now());
            map.put("client_type", params.get("client_type"));
            map.put("client_ip", params.get("client_ip"));
            map.put("client_name", params.get("client_name"));
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            log.warn("UsrGrpAssignRoleTask.ugAssignRoleSave2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private void clearDomainCache(Long userId, Map<String, Object> diffMap) {
        List<Object> appEntityAllList = new ArrayList(16);
        if (null == diffMap || diffMap.isEmpty()) {
            return;
        }
        List delList = (List)diffMap.get("del");
        List addList = (List)diffMap.get("add");
        HashSet<String> roleIds = new HashSet<String>(8);
        HashSet<Long> ugIdSet = new HashSet<Long>(8);
        for (UgRoleDim ugRoleDim : delList) {
            roleIds.add(ugRoleDim.getRoleId());
            ugIdSet.add(ugRoleDim.getUsrGrpId());
        }
        for (UgRoleDim ugRoleDim : addList) {
            roleIds.add(ugRoleDim.getRoleId());
            ugIdSet.add(ugRoleDim.getUsrGrpId());
        }
        String langStr = RequestContext.get().getLang().name();
        if (!CollectionUtils.isEmpty(roleIds)) {
            HashSet<String> appEntityAllSet = new HashSet<String>(16);
            if (PermCommonUtil.hasEnableOldDataRule()) {
                for (String roleId : roleIds) {
                    List oldDataRuleList = PermRoleLogHelper.getOldDataRuleList((String)roleId, (String)langStr);
                    for (LogOldDataRule oldDataRule : oldDataRuleList) {
                        appEntityAllSet.add(oldDataRule.getAppId() + "|" + oldDataRule.getEntityId());
                    }
                }
            } else {
                for (String roleId : roleIds) {
                    LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)roleId, (String)langStr);
                    appEntityAllSet.addAll(newDataRule.getNewDRAppEntitySet());
                }
            }
            if (!CollectionUtils.isEmpty(appEntityAllSet)) {
                appEntityAllList = appEntityAllSet.stream().map(x -> {
                    String[] split = x.split("\\|", 2);
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    map.put(split[0], split[1]);
                    return map;
                }).collect(Collectors.toList());
            }
        }
        Set userListBySet = UserGroupHelper.getUserListBySet(ugIdSet);
        PermCommonUtil.cancelShowForm(new ArrayList(userListBySet), appEntityAllList, (boolean)false);
    }

    protected void reloadCache(Long userId) {
        CacheMrg.clearAllCache();
        CacheMrg.clearHasEnableOldAdmin();
    }

    private void checkSaveUsrGrpRoleDim(IDataModel dataModel, final Map<String, Object> params) {
        String systemTypeFormplugin = "bos-permission-formplugin";
        try {
            final DynamicObject ug = (DynamicObject)dataModel.getValue("usrgrp");
            final Long ugId = (Long)ug.getPkValue();
            final String usrGrpName = ug.getString("name");
            DynamicObjectCollection dimObjs = dataModel.getEntryEntity("list_org");
            int dimObjsSize = dimObjs.size();
            final String curCtrlTypeEntityNum = (String)params.get("curCtrlTypeEntityNum");
            String curCtrlTypeName = (String)params.get("curCtrlTypeName");
            Long ugrCount = UserGroupHelper.getCountByUgId((Long)ugId, (String)curCtrlTypeEntityNum);
            if (0 == dimObjsSize && 0L == ugrCount) {
                this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%s\u201d\u3002", (String)"UsrGrpAssignRoleTask_3", (String)"bos-permission-formplugin", (Object[])new Object[]{curCtrlTypeName}), null);
                return;
            }
            String desc = ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u754c\u9762\u6570\u636e\u83b7\u53d6\u5b8c\u6bd5\uff0c\u51c6\u5907\u8fdb\u884c\u89e3\u6790\u3002", (String)"UsrGrpAssignRoleTask_4", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int progress = 10;
            this.feedbackProgress(progress, desc, null);
            final HashSet<String> roleIdSet = new HashSet<String>(8);
            final String pageId = (String)params.get("pageId");
            final Set<String> mayChangedDimIdSet = UsrGrpAssignRolePlugin.getMayChangedDimId(pageId);
            if (CollectionUtils.isEmpty(mayChangedDimIdSet)) {
                this.busiAfterSaveDimRole(ugId, roleIdSet, pageId);
                return;
            }
            mayChangedDimIdSet.remove("null");
            final Set mayChangedDimIdSetL = mayChangedDimIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            HashSet<String> checkDuplicRoleDimUsrGrp = new HashSet<String>(dimObjsSize);
            DynamicObject dimObj = null;
            String roleId = null;
            String roleName = null;
            Long dimObjId = null;
            String dimObjName = "";
            Boolean includeSubOrg = Boolean.FALSE;
            String curCtrlType = (String)params.get("curCtrlType");
            boolean isSingleOrg = PermFormCommonUtil.isSingleOrg(curCtrlType);
            boolean checkOrgDim = IsoDimHelper.checkOrgDim((String)curCtrlType);
            String dimObjFieldKey = "";
            boolean isOrgDimType = (Boolean)params.get("isOrgDimType");
            dimObjFieldKey = isOrgDimType ? "org_number" : "dim_num";
            final ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(dimObjsSize);
            for (int i = 0; i < dimObjsSize; ++i) {
                dataModel.setEntryCurrentRowIndex("list_org", i);
                dimObj = (DynamicObject)dimObjs.get(i);
                dimObjId = dimObj.getLong(dimObjFieldKey + "_id");
                if (!mayChangedDimIdSetL.contains(dimObjId)) continue;
                dimObjName = checkOrgDim ? dimObj.getString(dimObjFieldKey + ".name") : dimObj.getString("dim_name");
                DynamicObjectCollection roleCollection = dimObj.getDynamicObjectCollection("list_role");
                int roleColSize = roleCollection.size();
                if (0 == roleColSize && !isSingleOrg) {
                    String info = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u201c%2$s\u201d\u672a\u9009\u62e9\u901a\u7528\u89d2\u8272\u3002", (String)"UsrGrpAssignRoleTask_5", (String)"bos-permission-formplugin", (Object[])new Object[0]), String.valueOf(i + 1), dimObjName);
                    this.wrapFeedBack(false, "errorNotice", info, null);
                    return;
                }
                for (int j = 0; j < roleColSize; ++j) {
                    DynamicObject role;
                    DynamicObject role_ = (DynamicObject)roleCollection.get(j);
                    if (null == role_ || null == (role = role_.getDynamicObject("role_number"))) continue;
                    roleId = role.getString("id");
                    roleName = role.getString("name");
                    if (!checkDuplicRoleDimUsrGrp.add(roleId + curCtrlTypeEntityNum + dimObjId + ugId)) {
                        this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u7528\u6237\u7ec4-%1$s-\u89d2\u8272\uff0c\u7528\u6237\u7ec4\uff1a%2$s\uff0c%3$s\uff1a%4$s\uff0c\u89d2\u8272\uff1a%5$s\u3002", (String)"UsrGrpAssignRoleTask_6", (String)systemTypeFormplugin, (Object[])new Object[0]), curCtrlTypeName, usrGrpName, curCtrlTypeName, dimObjName, roleName), null);
                        return;
                    }
                    includeSubOrg = role_.getBoolean("includesub");
                    String fisincludesuborg = null == includeSubOrg || includeSubOrg == false ? "0" : "1";
                    DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_usrgrprole");
                    saveObj.set("dimtype", (Object)curCtrlTypeEntityNum);
                    saveObj.set("dimid", (Object)dimObjId);
                    saveObj.set("includesub", (Object)fisincludesuborg);
                    saveObj.set("usrgrpid", (Object)ugId);
                    saveObj.set("role", (Object)roleId);
                    saveList.add(saveObj);
                    roleIdSet.add(roleId);
                    desc = ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u754c\u9762\u4fe1\u606f\u89e3\u6790\u4e2d\u3002", (String)"UsrGrpAssignRoleTask_7", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                    progress = 10 + 10 / dimObjsSize * i;
                    this.feedbackProgress(progress, desc, null);
                }
            }
            desc = ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u754c\u9762\u4fe1\u606f\u89e3\u6790\u5b8c\u6bd5\uff0c\u8fdb\u884c\u6570\u636e\u5b58\u50a8\u3002", (String)"UsrGrpAssignRoleTask_8", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            progress = 20;
            this.feedbackProgress(progress, desc, null);
            if (this.isStop()) {
                this.stop();
            }
            Future future = pool.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Set<Long> usrGrpIdSet = Collections.singleton(ugId);
                    List preList = UserGroupHelper.getUsrGrpRoleList(null, null, usrGrpIdSet, (Set)mayChangedDimIdSetL, (String)curCtrlTypeEntityNum);
                    UsrGrpAssignRoleTask.this.saveDimRole2DB(ugId, mayChangedDimIdSet, saveList, params);
                    List afterList = UserGroupHelper.getUsrGrpRoleList(null, null, usrGrpIdSet, (Set)mayChangedDimIdSetL, (String)curCtrlTypeEntityNum);
                    UsrGrpAssignRoleTask.this.busiAfterSaveDimRole(ugId, roleIdSet, pageId);
                    Map diffMap = UgRoleDim.logCompareMutiThread((List)preList, (List)afterList);
                    UsrGrpAssignRoleTask.this.reloadCache(ugId);
                    UsrGrpAssignRoleTask.this.clearDomainCache(ugId, diffMap);
                    if (null == diffMap || diffMap.isEmpty()) {
                        return 1;
                    }
                    List delList = (List)diffMap.get("del");
                    List addList = (List)diffMap.get("add");
                    if (!(!PermCommonUtil.isEnablePermLog() || CollectionUtils.isEmpty((Collection)delList) && CollectionUtils.isEmpty((Collection)addList))) {
                        String opbtn = ConstantsHelper.getSave();
                        diffMap.put("langStr", RequestContext.get().getLang().name());
                        String usrGrpNumber = ug.getString("number");
                        UsrGrpAssignRoleTask.this.ugAssignRoleSave2PermLog("baritem_save", opbtn, String.valueOf(ugId), usrGrpNumber, usrGrpName, StrUtil.compress((String)new ObjectMapper().writeValueAsString((Object)diffMap)), params);
                    }
                    return 1;
                }
            });
            Object o = null;
            int target = 98;
            while (progress < target) {
                try {
                    o = future.get(500L, TimeUnit.MILLISECONDS);
                    if (1 != (Integer)o) continue;
                    progress = target;
                }
                catch (InterruptedException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
                catch (TimeoutException e) {
                    progress = this.dataSavingProgress(progress, target);
                }
            }
        }
        catch (Exception e) {
            log.warn("UsrGrpAssignRoleTask.saveDimUsrGrp error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private int dataSavingProgress(int progress, int target) {
        String desc = ResManager.loadKDString((String)"\u6570\u636e\u5b58\u50a8\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"UsrGrpAssignRoleTask_9", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        if (progress < target - 1) {
            ++progress;
        }
        this.feedbackProgress(progress, desc, null);
        return progress;
    }

    private void saveDimRole2DB(Long uId, Set<String> mayChangedDimIdSet, List<DynamicObject> saveList, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(saveList) && CollectionUtils.isEmpty(mayChangedDimIdSet)) {
            return;
        }
        String mayChangedDimIdStr = String.join((CharSequence)",", mayChangedDimIdSet);
        try (TXHandle txHandle = TX.required();){
            try {
                String curCtrlTypeEntityNum = (String)params.get("curCtrlTypeEntityNum");
                StringBuilder delSb = new StringBuilder();
                delSb.append("delete from t_perm_usrgrprole where froleid > ' ' ");
                delSb.append(" and fdimtype ='").append(curCtrlTypeEntityNum).append("' and fincludesub in ('0','1')");
                delSb.append(" and fusrgrpid = ").append(uId);
                delSb.append(" and fdimid in (").append(mayChangedDimIdStr).append(")");
                DB.execute((DBRoute)DBRoute.base, (String)delSb.toString());
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.warn("UsrGrpAssignRoleTask.saveDimRole2DB error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    private void busiAfterSaveDimRole(Long ugId, Set<String> roleIdSet, String pageId) {
        Map appEntityMap = PermissionServiceHelper.getAppEntityByRoleSet(roleIdSet);
        LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList(UserGroupHelper.getUserListBySet(Collections.singleton(ugId))), (Map)appEntityMap);
        String type = CacheMrg.getType4UserRoleDim();
        String key = "mayChangedDimId_" + pageId;
        CacheMrg.clearCache((String)type, (String)key);
        this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UsrGrpAssignRoleTask_10", (String)"bos-permission-formplugin", (Object[])new Object[0]), 3000);
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }
}

