/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.task.permlog;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.schedule.executor.AbstractTask;

public class PermLogFullUserInfoTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(PermLogFullUserInfoTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            PermLogFullUserInfoTask.dealUserDirectOrDisPerm("t_perm_log_diff_dimfunc");
            PermLogFullUserInfoTask.dealUserDirectOrDisPerm("t_perm_log_diff_dimdis");
        }
        catch (Exception e) {
            log.warn("PermLogFullUserInfoTask.execute, \u8fd0\u884c\u5f02\u5e38 ", (Throwable)e);
        }
    }

    private static void dealUserDirectOrDisPerm(String tableName) {
        final HashMap permLogIdUserIdMap = new HashMap(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select top 5000 a.fid, a.fop_item_id");
        sb.append(" from t_perm_log a");
        sb.append(" inner join ").append(tableName).append(" b on b.fperm_logid = a.fid");
        sb.append(" where b.fuser_id = 0 ");
        DB.query((DBRoute)DBRoute.log, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    permLogIdUserIdMap.put(rs.getLong("fid"), rs.getLong("fop_item_id"));
                }
                return null;
            }
        });
        if (null == permLogIdUserIdMap || permLogIdUserIdMap.isEmpty()) {
            return;
        }
        Map allUserInfo = UserHelper.getUserInfoMapByIds(permLogIdUserIdMap.values().stream().collect(Collectors.toSet()), null);
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(10);
        for (Map.Entry permLogIdUserId : permLogIdUserIdMap.entrySet()) {
            User user;
            Long permLogId = (Long)permLogIdUserId.getKey();
            Long userId = (Long)permLogIdUserId.getValue();
            if (null == permLogId || Objects.equals(0L, permLogId) || null == userId || Objects.equals(0L, userId) || null == (user = (User)allUserInfo.get(userId))) continue;
            updateParamList.add(new Object[]{user.getFid(), user.getFtruename(), user.getFnumber(), user.getFusername(), permLogId});
        }
        if (null != updateParamList && !updateParamList.isEmpty()) {
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("update ").append(tableName);
            updateSql.append(" set fuser_id = ?, fuser_name = ?, fuser_number = ?, fuser_username = ? where fperm_logid = ?");
            PermLogFullUserInfoTask.batExecute(updateSql.toString(), updateParamList);
        }
    }

    private static void batExecute(String sql, List<Object[]> collect) {
        DB.executeBatch((DBRoute)DBRoute.log, (String)sql, collect);
    }
}

