/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.tools;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PermCacheMonitorFormPlugin
extends AbstractFormPlugin {
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String CACHEKEY_TREEENTRYENTITY = "cachekeytreeentryentity";
    private static final String CACHEVALUE_TREEENTRYENTITY = "cachevaluetreeentryentity";
    private static final String CACHE_KEY = "cachekey";
    private static final String CACHE_VALUE = "cachevalue";
    private static final String CACHE_VALUE_TAG = "cachevalue_tag";
    private static final String PID = "pid";
    private static final String LONG_ID = "longid";
    private Map<String, AppInfo> allAppInfo;
    private int idSeq = 0;
    private int bdIdSeq = 0;

    public void afterCreateNewData(EventObject e) {
        this.loadPermCache();
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String operateKey;
        switch (operateKey = event.getOperateKey()) {
            case "refresh": {
                this.getModel().deleteEntryData(TREEENTRYENTITY);
                this.clearBdEntry();
                this.loadPermCache();
                break;
            }
            case "export": {
                this.export();
                break;
            }
            case "basedataload": {
                HashSet<String> keyList = new HashSet<String>(16);
                HashSet<String> valueList = new HashSet<String>(16);
                this.getSelectedRows(keyList, valueList, null, null);
                this.loadBaseDataOp(keyList, valueList);
                break;
            }
            case "basedataloaddirect": {
                this.loadBaseDataDirectOp();
                break;
            }
            case "basedataloadall": {
                this.loadBaseDataAllOp();
                break;
            }
        }
    }

    private void clearBdEntry() {
        this.getModel().deleteEntryData(CACHEKEY_TREEENTRYENTITY);
        this.getModel().deleteEntryData(CACHEVALUE_TREEENTRYENTITY);
    }

    private void loadPermCache() {
        Map allCacheTypes = CacheMrg.getAllCacheTypes();
        this.getModel().beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (Map.Entry entry : allCacheTypes.entrySet()) {
            String cacheType = (String)entry.getKey();
            String name = (String)entry.getValue();
            Map cacheMap = CacheMrg.getCache((String)cacheType);
            String value = null;
            if (cacheMap != null && !cacheMap.isEmpty()) {
                value = SerializationUtils.toJsonString((Object)cacheMap);
            }
            DynamicObject parentRow = this.addRow(entryEntity, null, name, cacheType, value);
            if (value == null) continue;
            this.parse(entryEntity, parentRow, value);
        }
        this.getModel().endInit();
        this.getView().updateView(TREEENTRYENTITY);
    }

    private void parse(DynamicObjectCollection entryEntity, DynamicObject parentRow, String cacheValue) {
        try {
            List list = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            for (String element : list) {
                this.parse(entryEntity, parentRow, element);
            }
        }
        catch (Exception e) {
            try {
                Map map = (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    DynamicObject rowObj = this.addRow(entryEntity, parentRow, null, key, value);
                    if (value == null) continue;
                    this.parse(entryEntity, rowObj, value.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private DynamicObject addRow(DynamicObjectCollection entryEntity, DynamicObject parentRow, String name, String key, Object valueObj) {
        int parentId;
        ++this.idSeq;
        int n = parentId = parentRow == null ? 0 : parentRow.getInt("id");
        if (this.idSeq == parentId) {
            return this.addRow(entryEntity, parentRow, name, key, valueObj);
        }
        String value = valueObj == null ? "" : valueObj.toString();
        DynamicObject dynamicObject = entryEntity.addNew();
        dynamicObject.set("id", (Object)this.idSeq);
        dynamicObject.set(PID, (Object)parentId);
        if (parentRow == null) {
            dynamicObject.set(LONG_ID, (Object)(parentId + "!" + this.idSeq));
        } else {
            dynamicObject.set(LONG_ID, (Object)(parentRow.getString(LONG_ID) + "!" + this.idSeq));
        }
        dynamicObject.set("cacheName", (Object)name);
        dynamicObject.set(CACHE_KEY, (Object)key);
        dynamicObject.set(CACHE_VALUE, (Object)(value.length() > 100 ? value.substring(0, 100) + "..." : value));
        dynamicObject.set(CACHE_VALUE_TAG, (Object)value);
        return dynamicObject;
    }

    private void getSelectedRows(Set<String> keyList, Set<String> valueList, Set<Integer> ids, TreeSet<String> longIds) {
        AbstractGrid.GridState entryState = ((TreeEntryGrid)this.getControl(TREEENTRYENTITY)).getEntryState();
        int[] selectedRows = entryState.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u6570\u636e\u3002", (String)"PermCacheMonitorFormPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (int selectedRow : selectedRows) {
            DynamicObject rowObj = (DynamicObject)entryEntity.get(selectedRow);
            if (ids != null) {
                ids.add(rowObj.getInt("id"));
            }
            String key = rowObj.getString(CACHE_KEY);
            if (keyList != null && StringUtils.isNotBlank((CharSequence)key)) {
                keyList.add(key);
            }
            String value = rowObj.getString(CACHE_VALUE_TAG);
            if (valueList != null && StringUtils.isNotBlank((CharSequence)value)) {
                valueList.add(value);
            }
            if (longIds == null) continue;
            longIds.add(rowObj.getString(LONG_ID));
        }
    }

    private void loadBaseDataOp(Set<String> keyList, Set<String> valueList) {
        this.clearBdEntry();
        SplitContainer splitc = (SplitContainer)this.getControl("splitcontainerap");
        splitc.setCollapse("bdsplitpanelap", false);
        if (!this.loadBaseData(keyList, valueList)) {
            return;
        }
        boolean keyEmpty = this.getModel().getEntryEntity(CACHEKEY_TREEENTRYENTITY).isEmpty();
        boolean valueEmpty = this.getModel().getEntryEntity(CACHEVALUE_TREEENTRYENTITY).isEmpty();
        if (keyEmpty && valueEmpty) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f\u3002\u672a\u627e\u5230\u53ef\u4ee5\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PermCacheMonitorFormPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f\u3002", (String)"PermCacheMonitorFormPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            Tab tab = (Tab)this.getControl("tabap");
            if (!keyEmpty) {
                tab.activeTab("cachekeytab");
            } else {
                tab.activeTab("cachevaluetab");
            }
        }
    }

    private void loadBaseDataDirectOp() {
        HashSet<Integer> ids = new HashSet<Integer>();
        this.getSelectedRows(null, null, ids, null);
        if (ids.isEmpty()) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        HashSet<String> keyList = new HashSet<String>(entryEntity.size());
        HashSet<String> valueList = new HashSet<String>(entryEntity.size());
        for (DynamicObject rowObj : entryEntity) {
            String value;
            int id = rowObj.getInt("id");
            int parentId = rowObj.getInt(PID);
            if (!ids.contains(id) && !ids.contains(parentId)) continue;
            String key = rowObj.getString(CACHE_KEY);
            if (StringUtils.isNotBlank((CharSequence)key)) {
                keyList.add(key);
            }
            if (!StringUtils.isNotBlank((CharSequence)(value = rowObj.getString(CACHE_VALUE_TAG)))) continue;
            valueList.add(value);
        }
        this.loadBaseDataOp(keyList, valueList);
    }

    private void loadBaseDataAllOp() {
        TreeSet<String> longIds = new TreeSet<String>();
        this.getSelectedRows(null, null, null, longIds);
        if (longIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        HashSet<String> keyList = new HashSet<String>(entryEntity.size());
        HashSet<String> valueList = new HashSet<String>(entryEntity.size());
        for (DynamicObject rowObj : entryEntity) {
            String value;
            String key;
            String longId = rowObj.getString(LONG_ID);
            if (!longIds.contains(longId)) {
                boolean needAdd = false;
                for (String parentLongId : longIds) {
                    if (!longId.startsWith(parentLongId + "!")) continue;
                    needAdd = true;
                    break;
                }
                if (!needAdd) continue;
            }
            if (StringUtils.isNotBlank((CharSequence)(key = rowObj.getString(CACHE_KEY)))) {
                keyList.add(key);
            }
            if (!StringUtils.isNotBlank((CharSequence)(value = rowObj.getString(CACHE_VALUE_TAG)))) continue;
            valueList.add(value);
        }
        this.loadBaseDataOp(keyList, valueList);
    }

    private boolean loadBaseData(Set<String> keyList, Set<String> valueList) {
        if (keyList.isEmpty() && valueList.isEmpty()) {
            return false;
        }
        Object entityTypes = this.getModel().getValue("entityTypes");
        if (StringUtils.isBlank((Object)entityTypes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u952e\u503c\u5bf9\u5e94\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"PermCacheMonitorFormPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return false;
        }
        String[] entityTypeArr = entityTypes.toString().split(",");
        LinkedHashMap<String, BasedataEntityType> entityTypeMap = new LinkedHashMap<String, BasedataEntityType>(entityTypeArr.length);
        for (String entityType : entityTypeArr) {
            if (!StringUtils.isNotBlank((CharSequence)entityType)) continue;
            try {
                BasedataEntityType dataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityType);
                entityTypeMap.put(entityType, dataEntityType);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (entityTypeMap.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u952e\u503c\u5bf9\u5e94\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"PermCacheMonitorFormPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.loadBaseData(CACHE_KEY, entityTypeMap, keyList);
        this.loadBaseData(CACHE_VALUE, entityTypeMap, valueList);
        return true;
    }

    private void loadBaseData(String property, Map<String, BasedataEntityType> entityTypeMap, Set<String> values) {
        if (values.isEmpty()) {
            return;
        }
        HashSet<Long> longPks = new HashSet<Long>(16);
        HashSet<String> stringPks = new HashSet<String>(16);
        values.forEach(value -> this.getPks((Set<Long>)longPks, (Set<String>)stringPks, (String)value));
        if (longPks.isEmpty() && stringPks.isEmpty()) {
            return;
        }
        this.getModel().beginInit();
        for (Map.Entry<String, BasedataEntityType> entry : entityTypeMap.entrySet()) {
            if ("bos_menu".equals(entry.getKey())) {
                this.loadMenu(property, entry.getValue(), stringPks);
                continue;
            }
            this.loadBaseData(property, entry.getValue(), longPks, stringPks);
        }
        this.getModel().endInit();
        String entityProp = property + TREEENTRYENTITY;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(property + TREEENTRYENTITY);
        if (entryEntity.isEmpty()) {
            return;
        }
        this.getView().updateView(entityProp);
        ArrayList<Integer> rootRowIndexes = new ArrayList<Integer>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (0 != ((DynamicObject)entryEntity.get(i)).getInt(PID)) continue;
            rootRowIndexes.add(i);
        }
        if (!rootRowIndexes.isEmpty()) {
            int[] rows = new int[rootRowIndexes.size()];
            for (int i = 0; i < rootRowIndexes.size(); ++i) {
                rows[i] = (Integer)rootRowIndexes.get(i);
            }
            TreeEntryGrid orgTreeEntryGrid = (TreeEntryGrid)this.getControl(entityProp);
            orgTreeEntryGrid.expand(rows);
        }
    }

    private void loadMenu(String property, BasedataEntityType dataEntityType, Set<String> stringPks) {
        if (stringPks.isEmpty()) {
            return;
        }
        ArrayList<AppMenuInfo> menuInfoList = new ArrayList<AppMenuInfo>(stringPks.size());
        Map allAppMenus = AppMetadataCache.getAllAppMenus();
        for (Map.Entry entry : allAppMenus.entrySet()) {
            for (AppMenuInfo appMenuInfo : (List)entry.getValue()) {
                if (!stringPks.contains(appMenuInfo.getId())) continue;
                menuInfoList.add(appMenuInfo);
            }
        }
        if (menuInfoList.isEmpty()) {
            return;
        }
        String entityType = dataEntityType.getName();
        LocaleString entityDisplayName = dataEntityType.getDisplayName();
        String entityName = entityDisplayName == null ? entityType : entityDisplayName.getLocaleValue();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(property + TREEENTRYENTITY);
        int parentId = this.addBdRow(entryEntity, 0, property, "", entityType, entityName, null);
        for (AppMenuInfo appMenuInfo : menuInfoList) {
            LocaleString nameL = appMenuInfo.getName();
            String name = nameL == null ? appMenuInfo.getFormId() : nameL.getLocaleValue();
            this.addBdRow(entryEntity, parentId, property, appMenuInfo.getId(), appMenuInfo.getFormId(), name, null);
        }
    }

    private void loadBaseData(String property, BasedataEntityType dataEntityType, Set<Long> longPks, Set<String> stringPks) {
        String entityType = dataEntityType.getName();
        LocaleString entityDisplayName = dataEntityType.getDisplayName();
        String entityName = entityDisplayName == null ? entityType : entityDisplayName.getLocaleValue();
        boolean isApp = false;
        try {
            String enableProp;
            String nameProp;
            Set<Object> params;
            ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
            if (primaryKey instanceof LongProp) {
                if (longPks.isEmpty()) {
                    return;
                }
                params = longPks;
            } else {
                if (stringPks.isEmpty()) {
                    return;
                }
                if ("bos_devportal_appruntime".equals(entityType)) {
                    params = this.convertAppPks(stringPks);
                    isApp = true;
                } else {
                    params = stringPks;
                }
            }
            StringJoiner selectProperties = new StringJoiner(",");
            selectProperties.add(primaryKey.getName());
            String numberProp = dataEntityType.getNumberProperty();
            if (numberProp != null) {
                selectProperties.add(numberProp);
            }
            if ((nameProp = dataEntityType.getNameProperty()) != null) {
                selectProperties.add(nameProp);
            }
            if ((enableProp = dataEntityType.getForbidStatus()) != null) {
                selectProperties.add(enableProp);
            }
            QFilter idFilter = new QFilter(primaryKey.getName(), "in", params);
            String idProp = null;
            if ("bos_entityobject".equals(entityType)) {
                idProp = "dentityid";
                selectProperties.add(idProp);
                idFilter = idFilter.or(new QFilter(idProp, "in", params));
            }
            QFilter[] filters = new QFilter[]{idFilter};
            Map objMap = BusinessDataServiceHelper.loadFromCache((String)entityType, (String)selectProperties.toString(), (QFilter[])filters);
            if (objMap == null || objMap.isEmpty()) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(property + TREEENTRYENTITY);
            int parentId = this.addBdRow(entryEntity, 0, property, "", entityType, entityName, null);
            for (Map.Entry entry : objMap.entrySet()) {
                Object id = entry.getKey();
                DynamicObject obj = (DynamicObject)entry.getValue();
                AppInfo appInfo = null;
                if (idProp == null) {
                    if (isApp) {
                        appInfo = this.getAllAppInfo().get(id);
                    }
                    if (appInfo != null) {
                        id = appInfo.getId();
                    }
                } else {
                    id = obj.get(idProp);
                }
                String number = numberProp == null ? "" : obj.getString(numberProp);
                String name = nameProp == null ? "" : obj.getString(nameProp);
                String enable = enableProp == null ? "0" : obj.getString(enableProp);
                this.addBdRow(entryEntity, parentId, property, id, number, name, enable);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private int addBdRow(DynamicObjectCollection entryEntity, int parentId, String property, Object id, Object number, Object name, Object enable) {
        ++this.bdIdSeq;
        if (this.bdIdSeq == parentId) {
            return this.addBdRow(entryEntity, parentId, property, id, number, name, enable);
        }
        DynamicObject rowObj = entryEntity.addNew();
        rowObj.set("id", (Object)this.bdIdSeq);
        rowObj.set(PID, (Object)parentId);
        String rowIdProp = property + "bdid";
        rowObj.set(rowIdProp, id);
        String rowNumberProp = property + "bdnumber";
        rowObj.set(rowNumberProp, number);
        String rowNameProp = property + "bdname";
        rowObj.set(rowNameProp, name);
        String enableProp = property + "bdenable";
        rowObj.set(enableProp, enable == null ? "1" : enable);
        return this.bdIdSeq;
    }

    private Set<String> convertAppPks(Set<String> pks) {
        if (pks.isEmpty()) {
            return pks;
        }
        HashSet<String> appPks = new HashSet<String>(pks.size());
        Map<String, AppInfo> allAppInfoMap = this.getAllAppInfo();
        for (Map.Entry<String, AppInfo> entry : allAppInfoMap.entrySet()) {
            AppInfo appInfo = entry.getValue();
            if (!pks.contains(appInfo.getId())) continue;
            appPks.add(appInfo.getNumber());
        }
        return appPks;
    }

    private Map<String, AppInfo> getAllAppInfo() {
        if (this.allAppInfo == null) {
            this.allAppInfo = AppMetadataCache.getAllAppInfo();
        }
        return this.allAppInfo;
    }

    private void getPks(Set<Long> longPks, Set<String> stringPks, String value) {
        String[] values = value.trim().split("_");
        if (values.length == 1) {
            try {
                List list = (List)SerializationUtils.fromJsonString((String)value, List.class);
                for (Object v : list) {
                    if (v == null) continue;
                    this.getPks(longPks, stringPks, v.toString());
                }
            }
            catch (Exception e1) {
                if (value.startsWith("SuperUserInfo")) {
                    value = value.substring("SuperUserInfo".length());
                }
                try {
                    longPks.add(Long.valueOf(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stringPks.add(value);
            }
        } else {
            for (String v : values) {
                this.getPks(longPks, stringPks, v);
            }
        }
    }

    private void export() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(entryEntity.size());
        for (DynamicObject rowObj : entryEntity) {
            if (!"0".equals(rowObj.getString(PID))) continue;
            cacheMap.put(rowObj.getString(CACHE_KEY), this.parse(rowObj.getString(CACHE_VALUE_TAG)));
        }
        try (ByteArrayInputStream ins = new ByteArrayInputStream(SerializationUtils.toJsonString(cacheMap).getBytes(StandardCharsets.UTF_8));){
            LocalDateTime localDateTime = LocalDateTime.now();
            String date = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH-mm-ss"));
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("PermissionCache_" + date + ".json", (InputStream)ins, 5000);
            this.getView().openUrl(url);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{"Export Error: " + e.getMessage()});
        }
    }

    private Object parse(String cacheValue) {
        try {
            List cacheList = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            ArrayList<Object> jsonList = new ArrayList<Object>(cacheList.size());
            for (Object element : cacheList) {
                jsonList.add(this.parse(element == null ? "" : element.toString()));
            }
            return jsonList;
        }
        catch (Exception e) {
            try {
                Map cacheMap = (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
                HashMap jsonMap = new HashMap(cacheMap.size());
                for (Map.Entry entry : cacheMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value != null) {
                        value = this.parse(value.toString());
                    }
                    jsonMap.put(key, value);
                }
                return jsonMap;
            }
            catch (Exception e1) {
                return cacheValue;
            }
        }
    }
}

