/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdminSchemeAssignedTreeView {
    private static final String PREFIX_CLOUD = "cloud#";
    private static final String PREFIX_APP = "app#";
    private static final String PREFIX_ENTITY = "entity#";
    private static final String PAGECACHE_TREENODE_ASSIGNED = "pagecache_treenode_assigned";
    private static final String PROP_PARENTID = "parentid";
    private TreeView treeview;
    private IPageCache pageCache = null;
    private Map<String, String> nameMap = null;
    private Map<String, String> nodeMap = null;
    private Long curAdminType = null;

    public AdminSchemeAssignedTreeView(TreeView treeview, Long pAdminTypeId) {
        this.treeview = treeview;
        this.pageCache = (IPageCache)treeview.getView().getService(IPageCache.class);
        this.curAdminType = pAdminTypeId;
    }

    private String getNAME_FUNCPERM() {
        return ResManager.loadKDString((String)"\u5df2\u5206\u914d", (String)"AdminSchemeAssignedTreeView_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    public void addNode(List<Long> adminTypeIds, List<Map<String, Object>> selectedNodes) {
        if (adminTypeIds == null || adminTypeIds.isEmpty() || selectedNodes == null || selectedNodes.isEmpty()) {
            return;
        }
        this.nameMap = (Map)SerializationUtils.fromJsonString((String)this.pageCache.get("nameMap"), Map.class);
        this.nodeMap = (Map)SerializationUtils.fromJsonString((String)this.pageCache.get("nodeMap"), Map.class);
        ArrayList<Map<String, Object>> cloudMap = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> appMap = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> entityMap = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> nodeInfo : selectedNodes) {
            String id = nodeInfo.get("id").toString();
            if (id.startsWith(PREFIX_CLOUD)) {
                cloudMap.add(nodeInfo);
                continue;
            }
            if (id.startsWith(PREFIX_APP)) {
                appMap.add(nodeInfo);
                continue;
            }
            if (!id.startsWith(PREFIX_ENTITY)) continue;
            entityMap.add(nodeInfo);
        }
        String curAdminType = adminTypeIds.get(0).toString();
        if (adminTypeIds.size() == 1) {
            String JsonStr = this.pageCache.get(curAdminType);
            Set entityIds = null;
            if (StringUtils.isNotEmpty((String)JsonStr)) {
                entityIds = (Set)SerializationUtils.fromJsonString((String)JsonStr, Set.class);
                for (String entityId : entityIds) {
                    HashMap<String, String> entityNode = new HashMap<String, String>();
                    entityNode.put("id", entityId);
                    String parentId = this.nodeMap.get(entityId);
                    entityNode.put(PROP_PARENTID, parentId);
                    String text = this.nameMap.get(entityId);
                    entityNode.put("text", text);
                    if (StringUtils.isEmpty((String)parentId) || StringUtils.isEmpty((String)text)) continue;
                    entityMap.add(entityNode);
                }
            }
        }
        this.recordCache(adminTypeIds, entityMap);
        String assignTreeNodeCache = this.pageCache.get("pagecache_treenode_assigned_" + curAdminType);
        boolean isNewTree = StringUtils.isEmpty((String)assignTreeNodeCache);
        if (!isNewTree) {
            String cache_PreviousAdminType = this.pageCache.get("pgCache_previousAdminType");
            if (StringUtils.isNotEmpty((String)cache_PreviousAdminType)) {
                if (!curAdminType.equals(cache_PreviousAdminType)) {
                    isNewTree = true;
                }
            } else {
                isNewTree = true;
            }
        }
        this.updateTree(cloudMap, appMap, entityMap, isNewTree);
    }

    public void removeNode(List<Long> adminTypeIds, List<Map<String, Object>> selectedNodes) {
        if (adminTypeIds == null || adminTypeIds.isEmpty() || selectedNodes == null || selectedNodes.isEmpty()) {
            return;
        }
        ArrayList<String> idsForRemove = new ArrayList<String>(selectedNodes.size());
        for (Map<String, Object> nodeInfo : selectedNodes) {
            String id = nodeInfo.get("id").toString();
            idsForRemove.add(id);
        }
        for (Long adminTypeId : adminTypeIds) {
            String jsonStr = this.pageCache.get(adminTypeId.toString());
            if (StringUtils.isEmpty((String)jsonStr)) continue;
            String adminTypeAssignedCache = this.pageCache.get("pagecache_treenode_assigned_" + adminTypeId);
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)adminTypeAssignedCache, TreeNode.class);
            Set entityIds = (Set)SerializationUtils.fromJsonString((String)jsonStr, Set.class);
            for (String id : idsForRemove) {
                entityIds.remove(id);
                rootNode.deleteChildNode(id);
            }
            this.pageCache.put(adminTypeId.toString(), SerializationUtils.toJsonString((Object)entityIds));
            this.pageCache.put("pagecache_treenode_assigned_" + adminTypeId, SerializationUtils.toJsonString((Object)rootNode));
        }
        this.treeview.deleteNodes(idsForRemove);
    }

    private void recordCache(List<Long> adminTypeIds, List<Map<String, Object>> entityMap) {
        if (adminTypeIds == null || adminTypeIds.isEmpty() || entityMap == null || entityMap.isEmpty()) {
            return;
        }
        HashSet<String> entityIdForAdd = new HashSet<String>(entityMap.size());
        for (Map<String, Object> entityInfo : entityMap) {
            String id = entityInfo.get("id").toString();
            entityIdForAdd.add(id);
        }
        for (Long adminTypeId : adminTypeIds) {
            String JsonStr = this.pageCache.get(adminTypeId.toString());
            Set entityIds = null;
            entityIds = StringUtils.isNotEmpty((String)JsonStr) ? (Set)SerializationUtils.fromJsonString((String)JsonStr, Set.class) : new HashSet();
            entityIds.addAll(entityIdForAdd);
            this.pageCache.put(adminTypeId.toString(), SerializationUtils.toJsonString(entityIds));
        }
    }

    private void updateTree(List<Map<String, Object>> cloudMap, List<Map<String, Object>> appMap, List<Map<String, Object>> entityMap, boolean isNewTree) {
        String text;
        String parentId;
        String id;
        boolean isShowNum = this.pageCache.get("isShowNum") != null && Boolean.parseBoolean(this.pageCache.get("isShowNum"));
        TreeNode rootNode = null;
        if (isNewTree || isShowNum) {
            rootNode = this.refreshTreeView();
        } else {
            this.treeview.deleteAllNodes();
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.pageCache.get("pagecache_treenode_assigned_" + this.curAdminType), TreeNode.class);
            this.treeview.addNode(rootNode);
        }
        ArrayList<TreeNode> forAddNodes = new ArrayList<TreeNode>();
        if (cloudMap != null && !cloudMap.isEmpty()) {
            for (Map<String, Object> cloudNode : cloudMap) {
                id = cloudNode.get("id").toString();
                parentId = rootNode.getId();
                text = cloudNode.get("text").toString();
                if (rootNode.getTreeNode(id, 1) != null) continue;
                TreeNode forAddNode = new TreeNode(parentId, id, text);
                rootNode.addChild(forAddNode);
                forAddNodes.add(forAddNode);
            }
        }
        if (appMap != null && !appMap.isEmpty()) {
            for (Map<String, Object> appNode : appMap) {
                id = appNode.get("id").toString();
                parentId = appNode.get(PROP_PARENTID).toString();
                text = appNode.get("text").toString();
                if (rootNode.getTreeNode(id, 2) != null) continue;
                TreeNode parentNode = rootNode.getTreeNode(parentId, 1);
                if (parentNode == null) {
                    String parentName = this.nameMap.get(parentId);
                    String grantId = this.nodeMap.get(parentId);
                    if (StringUtils.isEmpty((String)grantId)) {
                        grantId = rootNode.getId();
                    }
                    parentNode = new TreeNode(grantId, parentId, parentName);
                    rootNode.addChild(parentNode);
                    forAddNodes.add(parentNode);
                }
                TreeNode forAddNode = new TreeNode(parentId, id, text);
                parentNode.addChild(forAddNode);
                forAddNodes.add(forAddNode);
            }
        }
        if (entityMap != null && !entityMap.isEmpty()) {
            ArrayList<String> entityIds = new ArrayList<String>(entityMap.size());
            for (Map<String, Object> entityNode : entityMap) {
                String id2 = entityNode.get("id").toString();
                if (entityIds.contains(id2)) continue;
                entityIds.add(id2);
                String parentId2 = entityNode.get(PROP_PARENTID).toString();
                String text2 = entityNode.get("text").toString();
                TreeNode parentNode = rootNode.getTreeNode(parentId2, 2);
                if (parentNode == null) {
                    String parentName = this.nameMap.get(parentId2);
                    String grantId = this.nodeMap.get(parentId2);
                    parentNode = new TreeNode(grantId, parentId2, parentName);
                    TreeNode grantNode = rootNode.getTreeNode(grantId, 1);
                    if (grantNode == null) {
                        String grantName = this.nameMap.get(grantId);
                        grantNode = new TreeNode(rootNode.getId(), grantId, grantName);
                        rootNode.addChild(grantNode);
                        forAddNodes.add(grantNode);
                    }
                    grantNode.addChild(parentNode);
                    forAddNodes.add(parentNode);
                }
                TreeNode forAddNode = new TreeNode(parentId2, id2, text2);
                parentNode.addChild(forAddNode);
                forAddNodes.add(forAddNode);
            }
        }
        this.treeview.addNodes(forAddNodes);
        if (!isShowNum) {
            this.pageCache.put("pagecache_treenode_assigned_" + this.curAdminType, SerializationUtils.toJsonString((Object)rootNode));
        }
        this.treeview.expand("root#FIRST");
        this.treeview.expand("cloud#83bfebc800000bac");
    }

    private TreeNode createRootNode() {
        TreeNode rootNode = new TreeNode("", "root#FIRST", new LocaleString(this.getNAME_FUNCPERM()).toString());
        return rootNode;
    }

    public TreeNode refreshTreeView() {
        TreeNode rootNode = this.createRootNode();
        this.treeview.deleteAllNodes();
        this.treeview.addNode(rootNode);
        return rootNode;
    }

    public void uncheckNode(String rootNodeId) {
        this.treeview.uncheckNode(rootNodeId);
    }
}

