/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdminSchemePermTreeView {
    private static final String SYS_CLOUD_ID = "83bfebc800000bac";
    private static final String PREFIX_CLOUD = "cloud#";
    public static final String ROOT_NODE = "cloud#83bfebc800000bac";
    private static final String PREFIX_APP = "app#";
    private static final String PREFIX_ENTITY = "entity#";
    private static final String FLAG_HASLOADEDFROMCACHE = "flag_hasLoadedFromCache";
    private static final String PROP_ENTD_ID = "entd_id";
    private static final String PROP_ENTD_NUM = "entd_num";
    private static final String PROP_APP_ID = "app_id";
    private TreeView treeview;
    private IPageCache pageCache = null;
    private Map<String, String> nameMap = null;
    private Map<String, String> nodeMap = null;
    private Set<String> entityIdSet = null;
    private static final String PGCACHE_TREENODE_ALL_ADMINSCHEME = "pgcache_treenode_all_adminscheme";
    private static Log logger = LogFactory.getLog(AdminSchemePermTreeView.class);

    public AdminSchemePermTreeView(TreeView treeview) {
        this.treeview = treeview;
        this.pageCache = (IPageCache)treeview.getView().getService(IPageCache.class);
    }

    private String getSysCloudName() {
        boolean isShowNum = this.pageCache.get("isShowNum") != null && Boolean.parseBoolean(this.pageCache.get("isShowNum"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"SYS")});
        return isShowNum ? load[0].getString("name") + "(SYS)" : load[0].getString("name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTreeView() {
        boolean isShowNum = this.pageCache.get("isShowNum") != null && Boolean.parseBoolean(this.pageCache.get("isShowNum"));
        this.nameMap = new HashMap<String, String>();
        this.nodeMap = new HashMap<String, String>();
        this.entityIdSet = new HashSet<String>();
        String allAdminSchemeTreeNodeCache = this.pageCache.get(PGCACHE_TREENODE_ALL_ADMINSCHEME);
        if (StringUtils.isNotEmpty((String)allAdminSchemeTreeNodeCache)) {
            this.treeview.deleteAllNodes();
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)allAdminSchemeTreeNodeCache, TreeNode.class);
            this.treeview.addNode(rootNode);
            this.treeview.expand(ROOT_NODE);
            return;
        }
        HashSet<String> appIds = new HashSet<String>();
        String algoKeyPrefix = this.getClass().getName() + ".adminSchemePermTreeViewRefresh.";
        DataSet bizUnitRelFormDS = null;
        DataSet bizObjAppDS = null;
        DataSet entityDesignDS = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet appEntDS = null;
        Object funcPermDS = null;
        DataSet entDS = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        DataSet finalDS = null;
        try {
            bizUnitRelFormDS = DB.queryDataSet((String)(algoKeyPrefix + "bizUnitRelFormDS"), (DBRoute)DBRoute.meta, (String)"SELECT case b.fmasterid when ' ' then a.fbizappid else b.fmasterid end burf_appid, a.fformid burf_formid FROM t_meta_bizunitrelform a left join t_meta_bizapp b on a.fbizappid = b.fid");
            bizObjAppDS = DB.queryDataSet((String)(algoKeyPrefix + "bizObjAppDS"), (DBRoute)DBRoute.permission, (String)"SELECT fbizappid entapp_appid, fbizobjid entapp_entnum FROM t_perm_bizobjapp");
            entityDesignDS = DB.queryDataSet((String)(algoKeyPrefix + "entityDesignDS"), (DBRoute)DBRoute.meta, (String)"select fid ent_id, fnumber ent_num from t_meta_entitydesign");
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on("entapp_entnum", "ent_num").select(new String[]{"entapp_appid", "ent_id"}).finish();
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS);
            StringBuilder sbEntSql = new StringBuilder().append(" select entd.FID entd_id, entd.fnumber entd_num ").append(" from t_meta_entitydesign entd ").append(" where entd.FISTEMPLATE = '0' ").append(" and entd.ftype = '0' ");
            entDS = DB.queryDataSet((String)(algoKeyPrefix + "entDS"), (DBRoute)DBRoute.meta, (String)sbEntSql.toString());
            appEntPermItemDS2 = appEntDS.join(entDS).on("burf_formid", PROP_ENTD_ID).select(new String[]{"burf_appid"}, new String[]{PROP_ENTD_NUM, PROP_ENTD_ID}).finish();
            StringBuilder sbCloudAppSql = new StringBuilder(300).append("select app.fid app_id, app.fnumber app_num ").append(" from t_meta_bizapp app ").append(" WHERE app.ftype <> '2'  ").append(" AND app.FVISIBLE = '1' ").append(" AND app.FDEPLOYSTATUS = '2' ").append(" AND app.FBIZCLOUDID = ? ");
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + "cloudAppDS"), (DBRoute)DBRoute.meta, (String)sbCloudAppSql.toString(), (Object[])new Object[]{SYS_CLOUD_ID});
            finalDS = appEntPermItemDS2.join(cloudAppDS).on("burf_appid", PROP_APP_ID).select(new String[]{PROP_ENTD_NUM, PROP_ENTD_ID}, new String[]{PROP_APP_ID, "app_num"}).finish();
            Map<String, String> ifControlMap = this.getIfSkipMap();
            TreeNode rootNode = this.createRootNode();
            ArrayList<String> entityHasLoad = new ArrayList<String>(1000);
            PermCommonUtil.ifCtrlAndMatchDim((String)"DIM_ORG", ifControlMap);
            this.treeview.deleteAllNodes();
            while (finalDS.hasNext()) {
                TreeNode entityNode;
                TreeNode appNode;
                Row row = finalDS.next();
                String entityNum = row.getString(PROP_ENTD_NUM);
                List excludedEntitys = PermCommonUtil.getAdminPermExcludedEntities();
                if ("false".equals(ifControlMap.get(entityNum)) || excludedEntitys.contains(entityNum) || entityHasLoad.contains(entityNum)) continue;
                entityHasLoad.add(entityNum);
                String appId = row.getString(PROP_APP_ID);
                String appNum = row.getString("app_num");
                String appLongId = PREFIX_APP + appId;
                String appName = isShowNum ? AppHelper.getMetaAppInfo((String)appNum).getName().getLocaleValue() + "(" + appNum + ")" : AppHelper.getMetaAppInfo((String)appNum).getName().getLocaleValue();
                String entityName = isShowNum ? PermFormCommonUtil.getRuntimeFormName(entityNum) + "(" + entityNum + ")" : PermFormCommonUtil.getRuntimeFormName(entityNum);
                String entityLongID = PREFIX_ENTITY + entityNum + "@" + appId;
                this.entityIdSet.add(entityNum);
                if (appIds.contains(appId)) {
                    appNode = rootNode.getTreeNode(appLongId, 1);
                    entityNode = this.createNode(appLongId, entityLongID, entityName);
                    appNode.addChild(entityNode);
                    continue;
                }
                appNode = this.createNode(ROOT_NODE, appLongId, appName);
                rootNode.addChild(appNode);
                entityNode = this.createNode(appLongId, entityLongID, entityName);
                appNode.addChild(entityNode);
                appIds.add(appId);
            }
            this.treeview.addNode(rootNode);
            this.treeview.expand(ROOT_NODE);
            this.pageCache.put(PGCACHE_TREENODE_ALL_ADMINSCHEME, SerializationUtils.toJsonString((Object)rootNode));
            this.recordCache();
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
    }

    private void recordCache() {
        this.pageCache.put("nameMap", SerializationUtils.toJsonString(this.nameMap));
        this.pageCache.put("nodeMap", SerializationUtils.toJsonString(this.nodeMap));
        this.pageCache.put("entityIdSet", SerializationUtils.toJsonString(this.entityIdSet));
    }

    private TreeNode createNode(String parentId, String nodeId, String nodeText) {
        TreeNode node = new TreeNode(parentId, nodeId, nodeText);
        this.nameMap.put(nodeId, nodeText);
        this.nodeMap.put(nodeId, parentId);
        return node;
    }

    private TreeNode createRootNode() {
        TreeNode rootNode = new TreeNode("", ROOT_NODE, this.getSysCloudName());
        this.nameMap.put(ROOT_NODE, this.getSysCloudName());
        return rootNode;
    }

    public Map<String, String> getIfSkipMap() {
        HashMap<String, String> ifSkipMap = null;
        String ifSkipMapCacheStr = this.pageCache.get("pgcache_EntityCtrlDim");
        if (StringUtils.isEmpty((String)ifSkipMapCacheStr)) {
            ifSkipMap = new HashMap();
        } else {
            ifSkipMap = (Map)SerializationUtils.fromJsonString((String)ifSkipMapCacheStr, Map.class);
            ifSkipMap.put(FLAG_HASLOADEDFROMCACHE, "1");
        }
        return ifSkipMap;
    }

    public void uncheckNode(String rootNodeId) {
        this.treeview.uncheckNode(rootNodeId);
    }
}

