/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.util;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormConfig;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.CloudHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IndustryHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermGrayHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.formplugin.enumeration.PermTreeLevel;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.formplugin.util.PermPageCacheUtil;
import kd.bos.permission.formplugin.util.PermTreeUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.StringUtils;

public class AllFuncPermTreeUtil
implements TreeNodeQueryListener {
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final String ISSHOWNUM = "isShowNum";
    private static Log logger = LogFactory.getLog(AllFuncPermTreeUtil.class);
    public static final String ID_ROOTNODE = "root#FIRST";
    public static final String NODESUFFIX_FIRST = "#" + (Object)((Object)PermTreeLevel.FIRST);
    public static final String NODESUFFIX_CLOUD = "#cloud";
    public static final String NODESUFFIX_APP = "#app";
    public static final String NODESUFFIX_ENTITY = "#entity";
    public static final String NODESUFFIX_PERMITEM = "#permItem";
    private static final String FIELD_APP_MASTERID = "app_masterid";
    @Deprecated
    public static final String TO_BE_ASSIGNED_USER_ID = "to_be_assigned_user_id";
    private static final String FLAG_HASLOADEDFROMCACHE = "flag_hasLoadedFromCache";
    private static final String CACHE_SHOW_FORMNUMS = "cache_show_formnums";
    private static final String CACHE_NOTSHOW_FORMNUMS = "cache_notshow_formnums";
    public static final String BASESERVICE_BIZAPPID = "83bfebc8000037ac";
    private static final String ENTAPPMAP = "entAppMap";
    private static final String ENTDESIGNMAP = "entDesignMap";
    private static final String CLOUD_BLACK = "cloudBlack";
    private static final String APP_BLACK = "appBlack";
    private static final String ENTITY_BLACK = "entityBlack";
    private static final String PERMISSION_BLACK = "permissionBlack";
    private TreeView treeView = null;
    private String appNum = null;
    private String dimension = null;
    Map<String, Object> myParaMap = null;
    private PermPageCacheUtil permPageCacheUtil = null;
    private Set<String> filterAppIds = null;
    private Set<String> filterEntNums = null;
    private Set<String> filterEntKeys = null;
    private Map<String, List<String>> appAndEntNumsBlackMap = new HashMap<String, List<String>>(8);
    private Map<String, Object> blackMap = null;
    private boolean ifShowPermItemNode = true;
    private boolean needLogDebugInfo = true;
    private static final String SYS_CLOUD_APP = "SYS_CLOUD_APP";

    public static String getNAME_FUNCPERM() {
        return ResManager.loadKDString((String)"\u529f\u80fd\u6743\u9650", (String)"AllFuncPermTreeUtil_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    public static String getDataRuleRootNodeName() {
        return ResManager.loadKDString((String)"\u5168\u90e8", (String)"AllFuncPermTreeUtil_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    private void logDebugInfo(String debugInfo, Object ... paramObjs) {
        if (!this.needLogDebugInfo) {
            return;
        }
        logger.debug(String.format(debugInfo, paramObjs));
    }

    @Deprecated
    public AllFuncPermTreeUtil(TreeView pTreeView, String pAppNum, String pDimension, boolean pIfShowPermItemNode) {
        this(pTreeView, pAppNum, pDimension, pIfShowPermItemNode, null);
    }

    public AllFuncPermTreeUtil(TreeView pTreeView, String pAppNum, String pDimension, boolean pIfShowPermItemNode, Map<String, Object> paraMap) {
        this(pTreeView, pAppNum, pDimension, paraMap);
        this.ifShowPermItemNode = pIfShowPermItemNode;
    }

    @Deprecated
    public AllFuncPermTreeUtil(TreeView pTreeView, String pAppNum, String pDimension) {
        this(pTreeView, pAppNum, pDimension, null);
    }

    public AllFuncPermTreeUtil(TreeView pTreeView, String pAppNum, String pDimension, Map<String, Object> paraMap) {
        String sysCloudApps;
        String hasGetSysCloudApp;
        String entDesignMapStr;
        String hasGetEntDesignMap;
        String entAppMapStr;
        String[] suitableDimType;
        this.treeView = pTreeView;
        this.appNum = pAppNum;
        this.dimension = pDimension == null ? "DIM_ORG" : ((suitableDimType = PermCommonUtil.getSuitableDimType((String)pDimension)) != null && suitableDimType.length > 0 ? suitableDimType[0] : "DIM_ORG");
        if (null == paraMap) {
            this.myParaMap = new HashMap<String, Object>(8);
            this.myParaMap.put("dimension", this.dimension);
            this.myParaMap.put("dimDiffHide", "1");
            boolean isOrgDim = IsoDimHelper.checkOrgDim((String)pDimension);
            if (!isOrgDim) {
                this.myParaMap.put("curDimNullShow", "0");
            } else {
                this.myParaMap.put("curDimNullShow", "1");
            }
        } else {
            this.myParaMap = paraMap;
            if (null == this.myParaMap.get("dimension")) {
                this.myParaMap.put("dimension", this.dimension);
            }
            if (null == this.myParaMap.get("dimDiffHide")) {
                this.myParaMap.put("dimDiffHide", "1");
            }
        }
        IPageCache pageCache = (IPageCache)pTreeView.getView().getService(IPageCache.class);
        this.permPageCacheUtil = new PermPageCacheUtil(pageCache);
        String hasGetEntAppMap = this.permPageCacheUtil.get("hasGetEntAppMap");
        if (StringUtils.isEmpty((String)hasGetEntAppMap) && StringUtils.isEmpty((String)(entAppMapStr = this.permPageCacheUtil.getBigObject(ENTAPPMAP)))) {
            this.permPageCacheUtil.putBigObject(ENTAPPMAP, SerializationUtils.toJsonString((Object)FormHelper.getEntAppMap()));
            this.permPageCacheUtil.put("hasGetEntAppMap", "1");
        }
        if (StringUtils.isEmpty((String)(hasGetEntDesignMap = this.permPageCacheUtil.get("hasGetEntDesignMap"))) && StringUtils.isEmpty((String)(entDesignMapStr = this.permPageCacheUtil.getBigObject(ENTDESIGNMAP)))) {
            this.permPageCacheUtil.putBigObject(ENTDESIGNMAP, SerializationUtils.toJsonString((Object)FormHelper.getEntDesignInfo(null)));
            this.permPageCacheUtil.put("hasGetEntDesignMap", "1");
        }
        if (StringUtils.isEmpty((String)(hasGetSysCloudApp = this.permPageCacheUtil.get("hasGetSysCloudApp"))) && StringUtils.isEmpty((String)(sysCloudApps = this.permPageCacheUtil.getBigObject(SYS_CLOUD_APP)))) {
            this.permPageCacheUtil.putBigObject(SYS_CLOUD_APP, SerializationUtils.toJsonString((Object)AdminSchemeHelper.queryAllSysApp((boolean)false, (boolean)true)));
            this.permPageCacheUtil.put("hasGetSysCloudApp", "1");
        }
    }

    public Set<String> getFilterAppIds() {
        return this.filterAppIds;
    }

    public void setFilterAppIds(Set<String> filterAppIds) {
        this.filterAppIds = filterAppIds;
    }

    public Set<String> getFilterEntNums() {
        return this.filterEntNums;
    }

    public void setFilterEntNums(Set<String> filterEntNums) {
        this.filterEntNums = filterEntNums;
    }

    public void setFilterEntKey(Set<String> pFilterEntKeys) {
        this.filterEntKeys = pFilterEntKeys;
    }

    public Set<String> getFilterEntKeys() {
        return this.filterEntKeys;
    }

    public void initListener() {
        this.treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public TreeNode createRootNode() {
        return this.createRootNode(null);
    }

    public TreeNode createRootNode(String nodeName) {
        if (nodeName == null) {
            nodeName = AllFuncPermTreeUtil.getNAME_FUNCPERM();
        }
        TreeNode rootNode = new TreeNode("", ID_ROOTNODE, nodeName, true);
        return rootNode;
    }

    public static String getUserTypesByAppNum(String pAppNum) {
        if ("BASE".equals(pAppNum)) {
            return "1,5";
        }
        if ("SCP".equals(pAppNum)) {
            return "3";
        }
        return null;
    }

    public TreeNode initTree(boolean ifShow, String rootNodeName) {
        TreeNode rootNode = this.createRootNode(rootNodeName);
        rootNode.setIsOpened(true);
        this.addCloudNode(rootNode, null, ifShow);
        return rootNode;
    }

    public TreeNode initTree(boolean ifShow, String rootNodeName, TreeNode paramTreeNode) {
        if (ifShow && null != paramTreeNode && !paramTreeNode.getText().equals(rootNodeName)) {
            paramTreeNode.setText(rootNodeName);
            this.treeView.addNode(paramTreeNode);
            return paramTreeNode;
        }
        return this.initTree(ifShow, rootNodeName);
    }

    public TreeNode initTree(boolean ifShow) {
        return this.initTree(ifShow, null);
    }

    public Map<String, String> getIfSkipMap() {
        HashMap<String, String> ifSkipMap = null;
        String ifSkipMapCacheStr = this.permPageCacheUtil.get("pgcache_EntityCtrlDim");
        if (StringUtils.isEmpty((String)ifSkipMapCacheStr)) {
            ifSkipMap = new HashMap(8);
        } else {
            ifSkipMap = (Map)SerializationUtils.fromJsonString((String)ifSkipMapCacheStr, Map.class);
            ifSkipMap.put(FLAG_HASLOADEDFROMCACHE, "1");
        }
        return ifSkipMap;
    }

    private void appendAppFilter(StringBuilder sb, boolean showAll) {
        Set disabledAppIds;
        List<String> appIdsBlackListFromStd;
        Set appBlack;
        String appIdBlackList;
        List filterAppIds;
        String filterAppIdRangeCache;
        String filterAppNum = this.permPageCacheUtil.get("FormShowParam_appNum");
        if (StringUtils.isNotEmpty((String)filterAppNum) && !showAll) {
            if (filterAppNum.contains(",")) {
                String[] filterAppNumArr = filterAppNum.split(",");
                sb.append(" and app.fnumber in(");
                for (int i = 0; i < filterAppNumArr.length; ++i) {
                    if (StringUtils.isEmpty((String)filterAppNumArr[i])) continue;
                    sb.append('\'').append(filterAppNumArr[i].trim()).append('\'');
                    if (i == filterAppNumArr.length - 1) continue;
                    sb.append(',');
                }
                sb.append(") ");
            } else if (!"BASE".equals(filterAppNum) && !"SCP".equals(filterAppNum)) {
                sb.append(" and app.fnumber = '").append(filterAppNum).append("' ");
            }
        }
        if (StringUtils.isNotEmpty((String)(filterAppIdRangeCache = this.permPageCacheUtil.get("pageCache_adminChargeApp"))) && (filterAppIds = (List)SerializationUtils.fromJsonString((String)filterAppIdRangeCache, List.class)) != null && !filterAppIds.isEmpty()) {
            List allSysAppIds;
            boolean enableSysAuthority = PermCommonUtil.isEnableSysAuthority();
            if (!enableSysAuthority && (allSysAppIds = AdminSchemeHelper.queryAllSysApp((boolean)false, (boolean)false, (boolean)true)) != null && !allSysAppIds.isEmpty()) {
                filterAppIds.removeAll(allSysAppIds);
            }
            Map<String, List<String>> allExtAppIds = PermFormCommonUtil.getAllExtAppIds(filterAppIds);
            for (List<String> list : allExtAppIds.values()) {
                filterAppIds.addAll(list);
            }
            String filterAppIdsStr = String.join((CharSequence)"','", filterAppIds);
            sb.append(" and app.fid in ('").append(filterAppIdsStr).append("') ");
        }
        if (StringUtils.isNotEmpty((String)(appIdBlackList = RunModeServiceHelper.getAppIdFromBlacklist()))) {
            sb.append(" and app.fid not in (").append(appIdBlackList).append(')');
        }
        if (this.blackMap == null) {
            this.blackMap = PermCommonUtil.getImpleConfigBlack();
        }
        if (!CollectionUtils.isEmpty(this.blackMap) && !CollectionUtils.isEmpty((Collection)(appBlack = (Set)this.blackMap.get(APP_BLACK)))) {
            String appBlackStr = String.join((CharSequence)"','", appBlack);
            sb.append(" and app.fid not in ('").append(appBlackStr).append("') ");
        }
        if (!CollectionUtils.isEmpty(appIdsBlackListFromStd = PermFormCommonUtil.getAppIdsFromStdBlackList())) {
            String appIdsBlackListFromStdStr = String.join((CharSequence)"','", appIdsBlackListFromStd);
            sb.append(" and app.fid not in ('").append(appIdsBlackListFromStdStr).append("')");
        }
        if (null != (disabledAppIds = ManageServiceHelper.getDisabledAppIds()) && !disabledAppIds.isEmpty()) {
            String disabledAppIdsStr = String.join((CharSequence)"','", disabledAppIds);
            sb.append(" and app.fid not in ('").append(disabledAppIdsStr).append("')");
        }
    }

    private void appendAppFilter(StringBuilder sb) {
        this.appendAppFilter(sb, false);
    }

    private void generateCloudSeqCache() {
        String cloudSeqCache = this.permPageCacheUtil.get("pgcache_cloudseq");
        if (StringUtils.isNotEmpty((String)cloudSeqCache)) {
            return;
        }
        HashMap<String, Integer> cloudSeqMap = new HashMap<String, Integer>(8);
        DynamicObjectCollection bizClouds = BizCloudServiceHelp.getAllBizClouds();
        if (bizClouds == null || bizClouds.isEmpty()) {
            return;
        }
        for (DynamicObject bizCloud : bizClouds) {
            Integer cloudSeq = bizCloud.getInt("sequence");
            String id = bizCloud.getString("id") + NODESUFFIX_CLOUD;
            cloudSeqMap.put(id, cloudSeq);
        }
        this.permPageCacheUtil.put("pgcache_cloudseq", SerializationUtils.toJsonString(cloudSeqMap));
    }

    private void appendUserType(StringBuilder sb) {
        DynamicObject user;
        String userTypes = AllFuncPermTreeUtil.getUserTypesByAppNum(this.appNum);
        String userIdStr = this.permPageCacheUtil.get(TO_BE_ASSIGNED_USER_ID);
        String toBeAssignUser_Types = "";
        if (StringUtils.isNotEmpty((String)userIdStr) && (user = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(userIdStr), (String)"bos_user", (String)"usertype")) != null) {
            toBeAssignUser_Types = user.getString("usertype");
        }
        if ((userTypes = StringUtils.isEmpty((String)userTypes) ? toBeAssignUser_Types : userTypes + "," + toBeAssignUser_Types) != null && StringUtils.isNotEmpty((String)userTypes)) {
            sb.append(" and (");
            String[] arrUserType = userTypes.split(",");
            for (int i = 0; i < arrUserType.length; ++i) {
                String userType = arrUserType[i];
                if (i != 0) {
                    sb.append(" or ");
                }
                sb.append(" app.fusertype = '").append(userType).append("' ").append(" or app.fusertype like '").append(userType).append(",%' ").append(" or app.fusertype like '%,").append(userType).append("' ").append(" or app.fusertype like '%,").append(userType).append(",%' ");
            }
            sb.append(')');
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent e) {
        if (e.getNodeId() == null) {
            return;
        }
        String nodeId = e.getNodeId().toString();
        String parentId = nodeId.substring(0, nodeId.indexOf(35));
        if (nodeId.indexOf(NODESUFFIX_CLOUD) > 0) {
            this.addAppNode(parentId, null);
        } else if (nodeId.indexOf(NODESUFFIX_APP) > 0) {
            this.addEntityNode(parentId);
        } else if (nodeId.indexOf(NODESUFFIX_ENTITY) > 0) {
            this.addPermItemNode(parentId);
        }
    }

    public static String getEntityNumFromNodeId(String nodeId) {
        String result = null;
        if (StringUtils.isEmpty((String)nodeId)) {
            return null;
        }
        if (nodeId.indexOf(124) == -1 || nodeId.indexOf(64) == -1) {
            return null;
        }
        result = nodeId.substring(nodeId.indexOf(124) + 1, nodeId.indexOf(64));
        return result;
    }

    public static String getAppIdFromNodeId(String nodeId) {
        String result = null;
        if (StringUtils.isEmpty((String)nodeId)) {
            return null;
        }
        if (nodeId.indexOf(64) == -1 || nodeId.indexOf(35) == -1) {
            return null;
        }
        result = nodeId.substring(nodeId.indexOf(64) + 1, nodeId.indexOf(35));
        return result;
    }

    private String getCloudName(String cloudId, String cloudNum, Map<String, String> allCloudIdNameMap, boolean isShowNum) {
        String result = "";
        String cloudName = allCloudIdNameMap.get(cloudId);
        result = StringUtils.isEmpty((String)cloudName) ? cloudNum : (isShowNum ? cloudName + "(" + cloudNum + ")" : cloudName);
        return result;
    }

    private String getAppName(String appId, Map<String, String> allAppIdNumberMap, Map<String, AppInfo> allAppInfo, boolean isShowNum) {
        String orgnlAppNum = allAppIdNumberMap.get(appId);
        if (StringUtils.isEmpty((String)orgnlAppNum)) {
            return appId;
        }
        AppInfo appInfo = allAppInfo.get(orgnlAppNum);
        String appName = "";
        if (appInfo != null) {
            appName = appInfo.getName().getLocaleValue();
            if (StringUtils.isEmpty((String)appName)) {
                appName = orgnlAppNum;
            } else if (isShowNum) {
                appName = appName + "(" + orgnlAppNum + ")";
            }
        } else {
            appName = orgnlAppNum;
        }
        return appName;
    }

    private boolean getIsShowNumFlag() {
        return this.permPageCacheUtil.get(ISSHOWNUM) != null && Boolean.parseBoolean(this.permPageCacheUtil.get(ISSHOWNUM));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode searchAllFuncPermTreeByText(String searchText, List<String> filterAppIdList) {
        TreeNode treeNode;
        String curTreeViewKey;
        boolean isShowNum = this.getIsShowNumFlag();
        if (!SqlUtil.checkSearchText((String)searchText)) {
            this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u4e2d\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff08%\uff0c'\uff09\u6216\u5168\u90e8\u4e3a_\u3002", (String)"AllFuncPermTreeUtil_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            String isSearchMode = this.permPageCacheUtil.get("isSearchMode");
            if (StringUtils.isNotEmpty((String)isSearchMode) && isSearchMode.equals("true")) {
                this.permPageCacheUtil.remove("isSearchMode");
            }
            return null;
        }
        String langStr = RequestContext.get().getLang().name();
        String rootNodeName = null;
        String filterAppIds = null;
        StringBuilder filterAppIdsBuilder = new StringBuilder();
        if (!CollectionUtils.isEmpty(filterAppIdList)) {
            if (filterAppIdList.contains("FIRST")) {
                rootNodeName = ResManager.loadKDString((String)"\u5168\u90e8", (String)"AllFuncPermTreeUtil_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            } else {
                filterAppIdsBuilder.append('(');
                for (int i = 0; i < filterAppIdList.size(); ++i) {
                    filterAppIdsBuilder.append('\'').append(filterAppIdList.get(i)).append('\'');
                    if (i == filterAppIdList.size() - 1) continue;
                    filterAppIdsBuilder.append(',');
                }
                filterAppIdsBuilder.append(')');
                filterAppIds = filterAppIdsBuilder.toString();
            }
        }
        if ("tree_datarule".equals(curTreeViewKey = this.treeView.getKey())) {
            rootNodeName = ConstantsHelper.getAssignObj();
        }
        String algoKeyPrefix = this.getClass().getName() + ".searchAllFuncPermTreeByText.";
        DataSet appEntPermItemDs = null;
        DataSet entDsOfDesign = null;
        DataSet entDS = null;
        DataSet entDsOfRuntime = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        DataSet finalDS = null;
        try {
            String searchStr = "%" + searchText + "%";
            Object[] params = new Object[]{langStr, searchStr};
            entDsOfRuntime = FormHelper.getEntDsOfRuntime((String)searchText, (boolean)isShowNum);
            Map entNumNameMapOfRuntime = FormHelper.getEntNumNameMapOfRuntime((String)searchText, (boolean)isShowNum, (DataSet)entDsOfRuntime.copy());
            entDsOfDesign = FormHelper.getEntDsOfDesign(null, (boolean)isShowNum, (boolean)false, (String)"0", null, (Set)Sets.newHashSet((Object[])new String[]{"ReportQueryListModel"}), null, entNumNameMapOfRuntime.keySet());
            entDS = entDsOfRuntime.join(entDsOfDesign).on("runtimeEntId", "designEntNum").select(new String[]{"runtimeEntName as fname"}, new String[]{"designEntId as entd_id", "designEntNum as entd_num"}).finish();
            appEntPermItemDs = this.entAppMap2Ds();
            appEntPermItemDS2 = appEntPermItemDs.join(entDS).on("funcperm_entid", "entd_id").select(new String[]{"burf_appid"}, new String[]{"entd_num", "entd_id", "fname"}).finish();
            StringBuilder sbSql = new StringBuilder(1300).append("select cloud.fid cloud_id,cloud.fnumber cloud_num, cloudl.fname cloud_name, cloud.fseq cloud_seq, ").append(" app.FID app_id, app.fnumber app_num, app.fmasterid AS app_masterid ").append(" from t_meta_bizapp app ").append(" INNER JOIN t_meta_bizcloud cloud ON (cloud.FID = app.FBIZCLOUDID) ").append(" LEFT JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = cloud.FID AND cloudl.FLOCALEID = ?)").append(" WHERE ").append(" app.fdeploystatus = '2' ");
            this.appendCloudFilter(sbSql);
            params = new Object[]{langStr};
            if (StringUtils.isNotEmpty((String)filterAppIds)) {
                sbSql.append(" AND app.fId IN ").append(filterAppIds);
            }
            this.appendAppFilter(sbSql);
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + "cloudAppDS"), (DBRoute)DBRoute.meta, (String)sbSql.toString(), (Object[])params);
            finalDS = appEntPermItemDS2.join(cloudAppDS).on("burf_appid", "app_id").select(new String[]{"entd_num", "entd_id", "fname"}, new String[]{"cloud_id", "cloud_name", "cloud_num", FIELD_APP_MASTERID, "app_id", "app_num"}).finish();
            finalDS = this.addGrayInfoToDSForSearch(finalDS, searchText);
            this.treeView.deleteAllNodes();
            TreeNode rootNode = this.createRootNode(rootNodeName);
            String rootNodeId = rootNode.getId();
            this.treeView.addNode(rootNode);
            HashSet<String> cloudIds = new HashSet<String>(8);
            HashSet<String> appIds = new HashSet<String>(8);
            boolean isEnableProductSetting = PermCommonUtil.isEnableProductSetting();
            Map allAppInfo = AppMetadataCache.getAllAppInfo();
            Map<String, String> ifControlMap = this.getIfSkipMap();
            PermCommonUtil.getFormShowOnTreeStatusMap(this.myParaMap, ifControlMap);
            Map runModeBlackList_AppEntMap = PermCommonUtil.getRunModeBlackList_AppEntMap();
            Set<String> matchUserTypeAppIds = this.getMatchUserTypeAppIds();
            Map extAppAndOrgnlAppRel = AppHelper.getExtAppAndOrgnlAppRel();
            String strNotShowFormNums = this.permPageCacheUtil.get(CACHE_NOTSHOW_FORMNUMS);
            List formnums = null;
            if (StringUtils.isNotEmpty((String)strNotShowFormNums)) {
                formnums = (List)SerializationUtils.fromJsonString((String)strNotShowFormNums, List.class);
            }
            String adminGroupMenuShowOnTree = this.permPageCacheUtil.get("adminGroupMenuShowOnTree");
            Set<String> notshow_formnums = AllFuncPermTreeUtil.adminGroupMenuCannot2NormalUser(formnums, adminGroupMenuShowOnTree);
            Map allCloudIdNameMap = CloudHelper.getAllCloudIdNameMap();
            Map allAppIdNumberMap = AppHelper.getAllAppIdNumberMap();
            while (finalDS.hasNext()) {
                TreeNode cloudNode;
                TreeNode entityNode;
                Row row = finalDS.next();
                String entityNum = row.getString("entd_num");
                String tempAppId = row.getString("app_id");
                if (StringUtils.isEmpty((String)tempAppId) || StringUtils.isEmpty((String)(tempAppId = (String)extAppAndOrgnlAppRel.get(tempAppId))) || !matchUserTypeAppIds.contains(tempAppId) || "false".equals(ifControlMap.get(entityNum)) || notshow_formnums.contains(entityNum)) continue;
                if (isEnableProductSetting) {
                    List<String> formNumsFromStdBlackList = this.appAndEntNumsBlackMap.get(tempAppId);
                    if (null == formNumsFromStdBlackList) {
                        formNumsFromStdBlackList = PermFormCommonUtil.getFormNumsByAppFromStdBlackList(tempAppId);
                        this.appAndEntNumsBlackMap.put(tempAppId, formNumsFromStdBlackList);
                    }
                    if (!CollectionUtils.isEmpty(formNumsFromStdBlackList) && formNumsFromStdBlackList.contains(entityNum)) continue;
                }
                String cloudId = row.getString("cloud_id");
                String cloudNodeId = cloudId + NODESUFFIX_CLOUD;
                String cloudNum = row.getString("cloud_num");
                String cloudName = this.getCloudName(cloudId, cloudNum, allCloudIdNameMap, isShowNum);
                String appMasterId = row.getString(FIELD_APP_MASTERID);
                if (StringUtils.isNotEmpty((String)appMasterId)) {
                    tempAppId = appMasterId;
                }
                String appNodeId = tempAppId + NODESUFFIX_APP;
                String appName = this.getAppName(tempAppId, allAppIdNumberMap, allAppInfo, isShowNum);
                Set blackLists_entityNum = (Set)runModeBlackList_AppEntMap.get(tempAppId);
                if (blackLists_entityNum != null && blackLists_entityNum.contains(entityNum)) continue;
                String entityName = row.getString("fname");
                String entityId = row.getString("entd_id");
                String entityLongID = entityId + "|" + entityNum + "@" + tempAppId + NODESUFFIX_ENTITY;
                if (isShowNum) {
                    entityName = entityName + "(" + entityNum + ")";
                }
                if (cloudIds.contains(cloudNodeId)) {
                    if (appIds.contains(appNodeId)) {
                        TreeNode appNode = rootNode.getTreeNode(appNodeId, 2);
                        boolean duplicateFlag = false;
                        for (TreeNode child : appNode.getChildren()) {
                            if (!child.getId().equals(entityLongID)) continue;
                            duplicateFlag = true;
                            break;
                        }
                        if (duplicateFlag) continue;
                        entityNode = new TreeNode(appNodeId, entityLongID, entityName, this.ifShowPermItemNode);
                        appNode.addChild(entityNode);
                        this.treeView.expand(appNodeId);
                        continue;
                    }
                    cloudNode = rootNode.getTreeNode(cloudNodeId, 1);
                    TreeNode appNode = new TreeNode(cloudNodeId, appNodeId, appName, true);
                    appIds.add(appNodeId);
                    cloudNode.addChild(appNode);
                    this.treeView.expand(cloudNodeId);
                    entityNode = new TreeNode(appNodeId, entityLongID, entityName, this.ifShowPermItemNode);
                    appNode.addChild(entityNode);
                    this.treeView.expand(appNodeId);
                    continue;
                }
                cloudNode = new TreeNode(rootNodeId, cloudNodeId, cloudName, true);
                cloudIds.add(cloudNodeId);
                rootNode.addChild(cloudNode);
                this.treeView.expand(rootNodeId);
                TreeNode appNode = new TreeNode(cloudNodeId, appNodeId, appName, true);
                appIds.add(appNodeId);
                cloudNode.addChild(appNode);
                this.treeView.expand(cloudNodeId);
                entityNode = new TreeNode(appNodeId, entityLongID, entityName, this.ifShowPermItemNode);
                appNode.addChild(entityNode);
                this.treeView.expand(appNodeId);
            }
            List children = rootNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) {
                this.treeView.deleteAllNodes();
                rootNode = new TreeNode("", ID_ROOTNODE, AllFuncPermTreeUtil.getNAME_FUNCPERM(), false);
                this.treeView.addNode(rootNode);
            }
            treeNode = rootNode;
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
        return treeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloudNode(TreeNode rootNode, String nodeId, boolean ifShow) {
        this.generateCloudSeqCache();
        String langStr = RequestContext.get().getLang().name();
        boolean isShowNum = this.getIsShowNumFlag();
        DataSet entDS = null;
        DataSet appEntPermItemDs = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        DataSet cloudDS = null;
        DataSet appDS = null;
        DataSet finalDS = null;
        try {
            appEntPermItemDs = this.entAppMap2Ds();
            entDS = this.entDesignMap2Ds();
            appEntPermItemDS2 = appEntPermItemDs.join(entDS).on("funcperm_entid", "entd_id").select(new String[]{"burf_appid"}, new String[]{"entd_num"}).finish();
            if (!CollectionUtils.isEmpty(this.filterAppIds)) {
                String filterAppIdStr = String.join((CharSequence)"','", this.filterAppIds);
                appEntPermItemDS2 = appEntPermItemDS2.filter(" burf_appid in ('" + filterAppIdStr + "') ");
            }
            if (!CollectionUtils.isEmpty(this.filterEntNums)) {
                String filterEntNumStr = String.join((CharSequence)"','", this.filterEntNums);
                appEntPermItemDS2 = appEntPermItemDS2.filter(" entd_num in ('" + filterEntNumStr + "') ");
            }
            cloudDS = this.getCloudDS(langStr, nodeId);
            appDS = this.getAppDS();
            cloudAppDS = cloudDS.join(appDS).on("cloud_id", "fbizcloudid").select(new String[]{"cloud_id", "cloud_name", "cloud_num", "cloud_seq"}, new String[]{"app_id"}).finish();
            finalDS = appEntPermItemDS2.join(cloudAppDS).on("burf_appid", "app_id").select(new String[]{"entd_num"}, new String[]{"cloud_id", "cloud_name", "cloud_num", "cloud_seq", "app_id"}).finish().orderBy(new String[]{"cloud_seq asc"});
            ArrayList<TreeNode> list = new ArrayList<TreeNode>(50);
            Map<String, String> ifControlMap = this.getIfSkipMap();
            PermCommonUtil.getFormShowOnTreeStatusMap(this.myParaMap, ifControlMap);
            Map allCloudIdNameMap = CloudHelper.getAllCloudIdNameMap();
            Set<String> matchUserTypeAppIds = this.getMatchUserTypeAppIds();
            Map extAppAndOrgnlAppRel = AppHelper.getExtAppAndOrgnlAppRel(null, (boolean)true);
            HashSet<String> cloudIdSet = new HashSet<String>(50);
            while (finalDS.hasNext()) {
                String cloudId;
                String id;
                String appId;
                Row row = finalDS.next();
                String entityNum = row.getString("entd_num");
                if ("false".equals(ifControlMap.get(entityNum)) || StringUtils.isEmpty((String)(appId = row.getString("app_id"))) || StringUtils.isEmpty((String)(appId = (String)extAppAndOrgnlAppRel.get(appId))) || !matchUserTypeAppIds.contains(appId) || cloudIdSet.contains(id = (cloudId = row.getString("cloud_id")) + NODESUFFIX_CLOUD)) continue;
                cloudIdSet.add(id);
                String cloudNum = row.getString("cloud_num");
                String cloudName = this.getCloudName(cloudId, cloudNum, allCloudIdNameMap, isShowNum);
                TreeNode cloudNode = new TreeNode(ID_ROOTNODE, id, cloudName, true);
                list.add(cloudNode);
            }
            this.permPageCacheUtil.put("pgcache_EntityCtrlDim", SerializationUtils.toJsonString(ifControlMap));
            boolean cosmicUser = PermCommonUtil.isCosmicUser((Long)RequestContext.get().getCurrUserId());
            HashSet<String> cloudNodeIdSet = new HashSet<String>();
            for (TreeNode cloudNode : list) {
                rootNode.addChild(cloudNode);
                if (!cosmicUser) continue;
                cloudNode.setIsOpened(true);
                cloudNodeIdSet.add(cloudNode.getId());
            }
            if (cosmicUser) {
                this.permPageCacheUtil.put("allFuncPermTree_rootNodeId", rootNode.getId());
                this.permPageCacheUtil.put("allFuncPermTree_sysCloudNodeId", SerializationUtils.toJsonString(cloudNodeIdSet));
            }
            if (ifShow) {
                this.treeView.addNode(rootNode);
            }
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
    }

    private DataSet getAppDS() {
        StringBuilder sb = new StringBuilder();
        sb.append(" select app.FID app_id, app.fbizcloudid");
        sb.append(" from t_meta_bizapp app");
        sb.append(" WHERE ");
        sb.append(" app.fdeploystatus = '2' ");
        boolean chkincludeall = false;
        String includeall = this.permPageCacheUtil.get("pageCache_chkincludeall");
        if (StringUtils.isNotEmpty((String)includeall)) {
            chkincludeall = Boolean.parseBoolean(includeall);
        }
        this.appendAppFilter(sb, chkincludeall);
        String algoKeyPrefix = this.getClass().getName() + ".getAppDS.";
        return DB.queryDataSet((String)(algoKeyPrefix + "appDS"), (DBRoute)DBRoute.meta, (String)sb.toString(), null);
    }

    private DataSet getCloudDS(String langStr, String nodeId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select cloud.fid cloud_id, cloudl.fname cloud_name, cloud.fseq cloud_seq,cloud.fnumber cloud_num");
        sb.append(" from t_meta_bizcloud cloud");
        sb.append(" left JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = cloud.FID AND cloudl.FLOCALEID = ?)");
        sb.append(" WHERE 1=1");
        Object[] params = null;
        if (StringUtils.isNotEmpty((String)nodeId)) {
            sb.append(" and cloud.fid = ? ");
            params = new Object[]{langStr, nodeId};
        } else {
            params = new Object[]{langStr};
        }
        this.appendCloudFilter(sb);
        String algoKeyPrefix = this.getClass().getName() + ".getCloudDS.";
        return DB.queryDataSet((String)(algoKeyPrefix + "cloudDS"), (DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])params);
    }

    private DataSet entAppMap2Ds() {
        Map entAppMap = new HashMap(1);
        String entAppMapStr = this.permPageCacheUtil.getBigObject(ENTAPPMAP);
        if (StringUtils.isNotEmpty((String)entAppMapStr)) {
            entAppMap = (Map)SerializationUtils.fromJsonString((String)entAppMapStr, Map.class);
        }
        Algo algo = Algo.create((String)"AllFuncPermTreeUtil.entAppMap2Ds");
        ArrayList<Field> permFields = new ArrayList<Field>(2);
        permFields.add(new Field("funcperm_entid", (DataType)DataType.StringType));
        permFields.add(new Field("burf_appid", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(permFields.toArray(new Field[0]));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (Map.Entry entApp : entAppMap.entrySet()) {
            LinkedList value = new LinkedList((Collection)entApp.getValue());
            if (CollectionUtils.isEmpty(value)) continue;
            for (String str : value) {
                builder.append(new Object[]{entApp.getKey(), str});
            }
        }
        return builder.build();
    }

    private DataSet entDesignMap2Ds() {
        Map entDesignMap = new HashMap(1);
        String entDesignMapStr = this.permPageCacheUtil.getBigObject(ENTDESIGNMAP);
        if (StringUtils.isNotEmpty((String)entDesignMapStr)) {
            entDesignMap = (Map)SerializationUtils.fromJsonString((String)entDesignMapStr, Map.class);
        }
        Algo algo = Algo.create((String)"AllFuncPermTreeUtil.entDesignMap2Ds");
        ArrayList<Field> permFields = new ArrayList<Field>(2);
        permFields.add(new Field("entd_id", (DataType)DataType.StringType));
        permFields.add(new Field("entd_num", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(permFields.toArray(new Field[0]));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (Map.Entry ent : entDesignMap.entrySet()) {
            Map value = (Map)ent.getValue();
            if (CollectionUtils.isEmpty((Map)value)) continue;
            builder.append(new Object[]{value.get("id"), value.get("number")});
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppNode(String cloudId, String nodeId) {
        Map extAppAndOrgnlAppRel = AppHelper.getExtAppAndOrgnlAppRel();
        String algoKeyPrefix = this.getClass().getName() + ".addAppNode.";
        DataSet entDS = null;
        DataSet appEntPermItemDs = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        DataSet finalDS = null;
        try {
            StringBuilder sbFilterStr;
            entDS = DB.queryDataSet((String)(algoKeyPrefix + "entDS"), (DBRoute)DBRoute.meta, (String)"select entd.FID entd_id, entd.fnumber entd_num  from t_meta_entitydesign entd  where entd.FISTEMPLATE = '0' AND entd.FTYPE = '0' ");
            appEntPermItemDs = this.entAppMap2Ds();
            appEntPermItemDS2 = appEntPermItemDs.join(entDS).on("funcperm_entid", "entd_id").select(new String[]{"burf_appid"}, new String[]{"entd_num"}).finish();
            if (!CollectionUtils.isEmpty(this.filterAppIds)) {
                sbFilterStr = new StringBuilder();
                for (String filterIds : this.filterAppIds) {
                    sbFilterStr.append('\'').append(filterIds).append('\'').append(',');
                }
                if (sbFilterStr.length() > 1) {
                    sbFilterStr.deleteCharAt(sbFilterStr.length() - 1);
                }
                appEntPermItemDS2 = appEntPermItemDS2.filter(" burf_appid in (" + sbFilterStr + ") ");
            }
            if (!CollectionUtils.isEmpty(this.filterEntNums)) {
                sbFilterStr = new StringBuilder();
                for (String filterId : this.filterEntNums) {
                    sbFilterStr.append('\'').append(filterId).append('\'').append(',');
                }
                if (sbFilterStr.length() > 1) {
                    sbFilterStr.deleteCharAt(sbFilterStr.length() - 1);
                }
                appEntPermItemDS2 = appEntPermItemDS2.filter(" entd_num in (" + sbFilterStr + ") ");
            }
            StringBuilder sb = new StringBuilder().append("select app.fid app_id, app.fnumber app_num, app.findustry app_industry ").append(" from t_meta_bizapp app ").append(" INNER JOIN t_meta_bizcloud cloud ON (cloud.FID = app.FBIZCLOUDID) ").append(" WHERE ").append(" app.fdeploystatus = '2' ").append(" AND cloud.FID = ? ");
            Object[] params = new Object[]{cloudId};
            if (StringUtils.isNotEmpty((String)nodeId)) {
                sb.append(" and app.fid = ? ");
                params = new Object[]{cloudId, nodeId};
            }
            boolean chkincludeall = false;
            String includeall = this.permPageCacheUtil.get("pageCache_chkincludeall");
            if (StringUtils.isNotEmpty((String)includeall)) {
                chkincludeall = Boolean.parseBoolean(includeall);
            }
            this.appendAppFilter(sb, chkincludeall);
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + "cloudAppDS"), (DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])params);
            finalDS = appEntPermItemDS2.join(cloudAppDS).on("burf_appid", "app_id").select(new String[]{"entd_num"}, new String[]{"app_id", "app_num", "app_industry"}).finish();
            Map industryMap = IndustryHelper.getAllIndustryInfo();
            Map allAppInfo = AppMetadataCache.getAllAppInfo();
            Map allAppIdNumberMap = AppHelper.getAllAppIdNumberMap();
            Map<String, String> ifControlMap = this.getIfSkipMap();
            PermCommonUtil.getFormShowOnTreeStatusMap(this.myParaMap, ifControlMap);
            boolean isShowNum = this.getIsShowNumFlag();
            ArrayList<TreeNode> listNode = new ArrayList<TreeNode>(20);
            HashSet<String> appIdSet = new HashSet<String>(20);
            Set<String> matchUserTypeAppIds = this.getMatchUserTypeAppIds();
            while (finalDS.hasNext()) {
                String industryName;
                String id;
                String appId;
                Row row = finalDS.next();
                String entityNum = row.getString("entd_num");
                if ("false".equals(ifControlMap.get(entityNum)) || StringUtils.isEmpty((String)(appId = row.getString("app_id"))) || StringUtils.isEmpty((String)(appId = (String)extAppAndOrgnlAppRel.get(appId))) || !matchUserTypeAppIds.contains(appId) || appIdSet.contains(id = appId + NODESUFFIX_APP)) continue;
                appIdSet.add(id);
                String name = this.getAppName(appId, allAppIdNumberMap, allAppInfo, isShowNum);
                Long appIndustryId = row.getLong("app_industry");
                if (appIndustryId != null && appIndustryId != 0L && StringUtils.isNotEmpty((String)(industryName = (String)industryMap.get(appIndustryId)))) {
                    name = name + "(" + industryName + ")";
                }
                TreeNode appNode = new TreeNode(cloudId + NODESUFFIX_CLOUD, id, name, true);
                listNode.add(appNode);
            }
            this.addGrayAppNode(cloudId, listNode);
            if (listNode.size() > 0) {
                listNode.sort(Comparator.comparing(TreeNode::getId));
                this.treeView.addNodes(listNode);
            }
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
    }

    private void addGrayAppNode(String cloudId, List<TreeNode> listNode) {
        String assignPermUserId = this.permPageCacheUtil.get(TO_BE_ASSIGNED_USER_ID);
        String accountId = RequestContext.get().getAccountId();
        Map appNumAndGroupMap = GrayStrategy.getUserAppGroup((String)assignPermUserId, (String)accountId);
        this.logDebugInfo("assignPermUserId:%s, accountId:%s, appNumAndGroupMap:%s", assignPermUserId, accountId, appNumAndGroupMap);
        if (CollectionUtils.isEmpty((Map)appNumAndGroupMap)) {
            this.logDebugInfo("CollectionUtils.isEmpty(appNumAndGroupMap)", new Object[0]);
            return;
        }
        Set userGrayAppNums = appNumAndGroupMap.keySet();
        HashSet<String> appNums = new HashSet<String>(8);
        HashSet<String> appGroups = new HashSet<String>(8);
        for (String appGroup : appNumAndGroupMap.values()) {
            appGroups.add(appGroup);
        }
        this.logDebugInfo("appGroups:%s", appGroups);
        for (String appGroup : appGroups) {
            List formConfigs = PermGrayHelper.loadGrayFormConfigList((String)appGroup);
            for (FormConfig fc : formConfigs) {
                String tempAppNum = fc.getBizAppNumber();
                if (StringUtils.isEmpty((String)tempAppNum) || !userGrayAppNums.contains(tempAppNum)) {
                    this.logDebugInfo("StringUtils.isEmpty(tempAppNum[%s]) || !userGrayAppNums[%s].contains(tempAppNum))", tempAppNum, userGrayAppNums);
                    continue;
                }
                appNums.add(tempAppNum);
            }
            this.logDebugInfo("appGroup:%s, appNums:%s", appGroup, appNums);
        }
        List loadGrayAppInfoList = PermGrayHelper.loadGrayAppInfoList();
        for (String tempAppNum : appNums) {
            if (StringUtils.isEmpty((String)tempAppNum)) {
                this.logDebugInfo("StringUtils.isEmpty(tempAppNum) %s", tempAppNum);
                continue;
            }
            AppInfo appInfo = PermGrayHelper.findGrayAppInfoByNum((String)tempAppNum, (List)loadGrayAppInfoList);
            if (appInfo == null) {
                this.logDebugInfo("appInfo==null tempAppNum:%s", tempAppNum);
                continue;
            }
            String appCloudId = appInfo.getCloudId();
            this.logDebugInfo("tempAppNum:%s, appCloudId:%s", tempAppNum, appCloudId);
            if (!cloudId.equals(appCloudId)) {
                this.logDebugInfo("!cloudId [%s] .equals(appCloudId [%s])", cloudId, appCloudId);
                continue;
            }
            TreeNode tn = new TreeNode(cloudId + NODESUFFIX_CLOUD, appInfo.getId() + NODESUFFIX_APP, appInfo.getName().getLocaleValue(), true);
            listNode.add(tn);
        }
    }

    public void addEntityNode(String appId) {
        this.addEntityNode(appId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addEntityNode(String appId, Object[] customParam) {
        List<String> forQueryAppIds = PermFormCommonUtil.getAllExtAppId(appId);
        forQueryAppIds.add(appId);
        HashMap<String, String> extAppIdAndOrnlAppIdMap = new HashMap<String, String>(8);
        for (String tempAppId : forQueryAppIds) {
            extAppIdAndOrnlAppIdMap.put(tempAppId, appId);
        }
        Map pAllEntNumAndNameMap = null;
        if (customParam != null && customParam.length >= 1) {
            pAllEntNumAndNameMap = (Map)customParam[0];
        }
        Map entityInfo = null;
        if (this.blackMap == null) {
            this.blackMap = PermCommonUtil.getImpleConfigBlack();
        }
        if (!CollectionUtils.isEmpty(this.blackMap)) {
            entityInfo = (Map)this.blackMap.get(ENTITY_BLACK);
        }
        String algoKeyPrefix = this.getClass().getName() + ".addEntityNode.";
        DataSet entDS = null;
        DataSet appEntPermItemDs = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        DataSet finalDS = null;
        try {
            StringBuilder sbFilterStr;
            String appNumber;
            String formBlacklist;
            String adminGroupMenuShowOnTree;
            Set<String> formnumSet;
            StringBuilder sb = new StringBuilder().append(" select entd.FID entd_id, entd.fnumber entd_num, entd.fmodeltype entd_modeltype ").append(" from t_meta_entitydesign entd ").append(" where entd.FISTEMPLATE = '0' ").append(" AND entd.FTYPE = '0' ").append(" and fmodeltype <> 'ReportQueryListModel' ");
            HashSet entityFilter = new HashSet(16);
            String strShowFormNums = this.permPageCacheUtil.get(CACHE_SHOW_FORMNUMS);
            if (StringUtils.isNotEmpty((String)strShowFormNums)) {
                List formNums = (List)SerializationUtils.fromJsonString((String)strShowFormNums, List.class);
                entityFilter.addAll(formNums);
            }
            if (!CollectionUtils.isEmpty(entityFilter)) {
                StringBuilder strFilter = new StringBuilder();
                for (String formNum : entityFilter) {
                    strFilter.append('\'').append(formNum).append("',");
                }
                strFilter.deleteCharAt(strFilter.length() - 1);
                sb.append(" AND entd.fnumber in (").append((CharSequence)strFilter).append(") ");
            }
            String strNotShowFormNums = this.permPageCacheUtil.get(CACHE_NOTSHOW_FORMNUMS);
            List formnums = null;
            if (StringUtils.isNotEmpty((String)strNotShowFormNums)) {
                formnums = (List)SerializationUtils.fromJsonString((String)strNotShowFormNums, List.class);
            }
            if ((formnumSet = AllFuncPermTreeUtil.adminGroupMenuCannot2NormalUser(formnums, adminGroupMenuShowOnTree = this.permPageCacheUtil.get("adminGroupMenuShowOnTree"))) != null && !formnumSet.isEmpty()) {
                StringBuilder sbStrFornum = new StringBuilder();
                for (String formnum : formnumSet) {
                    sbStrFornum.append('\'').append(formnum).append("',");
                }
                String strFornum = sbStrFornum.substring(0, sbStrFornum.length() - 1);
                sb.append(" AND entd.fnumber not in (").append(strFornum).append(") ");
            }
            if (StringUtils.isNotEmpty((String)(formBlacklist = RunModeServiceHelper.getEntityNumFromBlacklist((String)(appNumber = AppMetadataCache.getAppNumberById((String)appId)))))) {
                sb.append(" AND entd.fnumber not in (").append(formBlacklist).append(") ");
            }
            entDS = DB.queryDataSet((String)(algoKeyPrefix + "entDS"), (DBRoute)DBRoute.meta, (String)sb.toString());
            appEntPermItemDs = this.entAppMap2Ds();
            appEntPermItemDS2 = appEntPermItemDs.join(entDS).on("funcperm_entid", "entd_id").select(new String[]{"burf_appid"}, new String[]{"entd_num", "entd_id", "entd_modeltype"}).finish();
            if (!CollectionUtils.isEmpty(this.filterAppIds)) {
                sbFilterStr = new StringBuilder();
                for (String filterIds : this.filterAppIds) {
                    sbFilterStr.append('\'').append(filterIds).append('\'').append(',');
                }
                if (sbFilterStr.length() > 1) {
                    sbFilterStr.deleteCharAt(sbFilterStr.length() - 1);
                }
                appEntPermItemDS2 = appEntPermItemDS2.filter(" burf_appid in (" + sbFilterStr + ") ");
            }
            if (!CollectionUtils.isEmpty(this.filterEntNums)) {
                sbFilterStr = new StringBuilder();
                for (String filterIds : this.filterEntNums) {
                    sbFilterStr.append('\'').append(filterIds).append('\'').append(',');
                }
                if (sbFilterStr.length() > 1) {
                    sbFilterStr.deleteCharAt(sbFilterStr.length() - 1);
                }
                appEntPermItemDS2 = appEntPermItemDS2.filter(" entd_num in (" + sbFilterStr + ") ");
            }
            if (!CollectionUtils.isEmpty(this.filterEntKeys)) {
                appEntPermItemDS2 = this.changeExtAppIdToOrgnlAppIdInDataSet(appEntPermItemDS2, extAppIdAndOrnlAppIdMap);
                StringBuilder finalFilterStr = new StringBuilder();
                for (String filterIds : this.filterEntKeys) {
                    Object[] entKeyArr = filterIds.split("@");
                    if (ArrayUtils.isEmpty((Object[])entKeyArr)) continue;
                    if (finalFilterStr.length() > 0) {
                        finalFilterStr.append(" or ");
                    }
                    finalFilterStr = finalFilterStr.append(" (burf_appid = '").append((String)entKeyArr[1]).append("' ").append(" and entd_num = '").append((String)entKeyArr[0]).append("') ");
                }
                appEntPermItemDS2 = appEntPermItemDS2.filter(finalFilterStr.toString());
            }
            StringBuilder sbCloudAppSql = new StringBuilder().append("select app.fid app_id, app.fnumber app_num, app.findustry app_industry ").append(" from t_meta_bizapp app ").append(" INNER JOIN t_meta_bizcloud cloud ON cloud.FID = app.FBIZCLOUDID   ");
            sbCloudAppSql.append(" AND app.FID in (");
            for (int i = 0; i < forQueryAppIds.size(); ++i) {
                String forQueryAppId = forQueryAppIds.get(i);
                sbCloudAppSql.append('\'').append(forQueryAppId).append('\'');
                if (i == forQueryAppIds.size() - 1) continue;
                sbCloudAppSql.append(',');
            }
            sbCloudAppSql.append(") ");
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + "cloudAppDS"), (DBRoute)DBRoute.meta, (String)sbCloudAppSql.toString());
            finalDS = appEntPermItemDS2.join(cloudAppDS).on("burf_appid", "app_id").select(new String[]{"entd_num", "entd_id"}, new String[0]).finish();
            ArrayList<TreeNode> listNodeInMenu = new ArrayList<TreeNode>();
            ArrayList<TreeNode> listNode = new ArrayList<TreeNode>(500);
            List<String> formNumsFromStdBlackList = PermFormCommonUtil.getFormNumsByAppFromStdBlackList(appId);
            boolean notNullFlag_formNumsFromStdBlackList = formNumsFromStdBlackList != null && !formNumsFromStdBlackList.isEmpty();
            HashSet<String> entityNumSet = new HashSet<String>(500);
            if (pAllEntNumAndNameMap == null) {
                pAllEntNumAndNameMap = PermCommonUtil.getAllEntNumAndNameMap();
            }
            Map<String, String> ifControlMap = this.getIfSkipMap();
            PermCommonUtil.getFormShowOnTreeStatusMap(this.myParaMap, ifControlMap);
            boolean isShowNum = this.getIsShowNumFlag();
            while (finalDS.hasNext()) {
                void var33_36;
                Set entityNums;
                Row row = finalDS.next();
                String entityNum = row.getString("entd_num");
                if (!CollectionUtils.isEmpty((Map)entityInfo) && StringUtils.isNotEmpty((String)entityNum) && !CollectionUtils.isEmpty((Collection)(entityNums = (Set)entityInfo.get(appId))) && StringUtils.isNotEmpty((String)entityNum) && entityNums.contains(entityNum) || "false".equals(ifControlMap.get(entityNum)) || notNullFlag_formNumsFromStdBlackList && formNumsFromStdBlackList.contains(entityNum) || entityNumSet.contains(entityNum)) continue;
                entityNumSet.add(entityNum);
                String id = row.getString("entd_id") + "|" + entityNum + "@" + appId + NODESUFFIX_ENTITY;
                String string = (String)pAllEntNumAndNameMap.get(entityNum);
                if (StringUtils.isEmpty((String)string)) {
                    String string2 = PermFormCommonUtil.getRuntimeFormName(entityNum);
                }
                if (isShowNum) {
                    void var33_39;
                    String string3 = (String)var33_39 + "(" + entityNum + ")";
                }
                TreeNode entityNode = new TreeNode(appId + NODESUFFIX_APP, id, (String)var33_36, this.ifShowPermItemNode);
                listNode.add(entityNode);
            }
            List<AppMenuElement> listMenuNode = null;
            try {
                listMenuNode = PermTreeUtil.getSortedMenuList(appId);
            }
            catch (Exception e) {
                listMenuNode = new ArrayList<AppMenuElement>();
            }
            ArrayList<String> formNums = new ArrayList<String>(8);
            for (AppMenuElement appMenuElement : listMenuNode) {
                String formNum = appMenuElement.getFormNumber();
                if (StringUtils.isEmpty((String)formNum)) continue;
                formNums.add(formNum);
            }
            Map formNumAndEntNumsMap = PermCommonUtil.getEntityNumsByFormNums(formNums);
            for (AppMenuElement menuNode : listMenuNode) {
                String entityNum;
                String formNum = menuNode.getFormNumber();
                if (StringUtils.isEmpty((String)formNum) || StringUtils.isEmpty((String)(entityNum = (String)formNumAndEntNumsMap.get(formNum)))) continue;
                if ("empty".equals(entityNum)) {
                    entityNum = menuNode.getFormNumber();
                }
                if (StringUtils.isEmpty((String)entityNum)) continue;
                Iterator iter = listNode.iterator();
                while (iter.hasNext()) {
                    TreeNode treeNode = (TreeNode)iter.next();
                    String entityNumFromTreeNode = treeNode.getId();
                    if ((entityNumFromTreeNode = AllFuncPermTreeUtil.getEntityNumFromNodeId(entityNumFromTreeNode)) == null || !entityNumFromTreeNode.equals(entityNum)) continue;
                    listNodeInMenu.add(treeNode);
                    iter.remove();
                }
            }
            if (listNodeInMenu.size() > 0) {
                this.treeView.addNodes(listNodeInMenu);
            }
            this.addGrayEntityNode(appId, listNode);
            if (listNode.size() > 0) {
                final Collator collator = Collator.getInstance(RequestContext.get().getLang().getLocale());
                listNode.sort(new Comparator<TreeNode>(){

                    @Override
                    public int compare(TreeNode o1, TreeNode o2) {
                        return collator.compare(o1.getText(), o2.getText());
                    }
                });
                this.treeView.addNodes(listNode);
            }
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
    }

    private static Set<String> adminGroupMenuCannot2NormalUser(List<String> formnums, String adminGroupMenuShowOnTree) {
        HashSet<String> formnumSet;
        HashSet<String> hashSet = formnumSet = null == formnums || formnums.isEmpty() ? new HashSet<String>(0) : new HashSet<String>(formnums);
        if (StringUtils.isEmpty((String)adminGroupMenuShowOnTree) || Objects.equals("0", adminGroupMenuShowOnTree)) {
            formnumSet.add("perm_admingroup");
            formnumSet.add("perm_useradmingroup");
        }
        return formnumSet;
    }

    private DataSet changeExtAppIdToOrgnlAppIdInDataSet(DataSet appEntPermItemDS2, Map<String, String> extAppIdAndOrnlAppIdMap) {
        if (appEntPermItemDS2 == null) {
            return null;
        }
        Algo algo = Algo.create((String)"AllFuncPermTreeUtil.changeExtAppIdToOrgnlAppIdInDataSet");
        ArrayList<Field> permFields = new ArrayList<Field>(4);
        permFields.add(new Field("burf_appid", (DataType)DataType.StringType));
        permFields.add(new Field("entd_num", (DataType)DataType.StringType));
        permFields.add(new Field("entd_id", (DataType)DataType.StringType));
        permFields.add(new Field("entd_modeltype", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(permFields.toArray(new Field[4]));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        while (appEntPermItemDS2.hasNext()) {
            Row row = appEntPermItemDS2.next();
            String appId = row.getString("burf_appid");
            if (StringUtils.isEmpty((String)appId)) continue;
            String orgnlAppId = extAppIdAndOrnlAppIdMap.get(appId);
            if (StringUtils.isEmpty((String)orgnlAppId)) {
                orgnlAppId = appId;
            }
            builder.append(new Object[]{orgnlAppId, row.getString("entd_num"), row.getString("entd_id"), row.getString("entd_modeltype")});
        }
        return builder.build();
    }

    private void addGrayEntityNode(String appId, List<TreeNode> listNode) {
        String assignPermUserId = this.permPageCacheUtil.get(TO_BE_ASSIGNED_USER_ID);
        String accountId = RequestContext.get().getAccountId();
        Map appNumAndGroupMap = GrayStrategy.getUserAppGroup((String)assignPermUserId, (String)accountId);
        this.logDebugInfo("assignPermUserId:%s, accountId:%s, appNumAndGroupMap:%s", assignPermUserId, accountId, appNumAndGroupMap);
        if (CollectionUtils.isEmpty((Map)appNumAndGroupMap)) {
            this.logDebugInfo("CollectionUtils.isEmpty(appNumAndGroupMap)", new Object[0]);
            return;
        }
        AppInfo appInfo = PermGrayHelper.findGrayAppInfoById((String)appId);
        if (appInfo == null) {
            this.logDebugInfo("appInfo==null appId:%s", appId);
            return;
        }
        String curAppNum = appInfo.getAppId();
        if (StringUtils.isEmpty((String)curAppNum)) {
            this.logDebugInfo("StringUtils.isEmpty(curAppNum)", new Object[0]);
            return;
        }
        String appGroup = GrayStrategy.getAppGroup((String)curAppNum);
        if (StringUtils.isEmpty((String)appGroup)) {
            this.logDebugInfo("StringUtils.isEmpty(appGroup)", new Object[0]);
            return;
        }
        List formConfigs = PermGrayHelper.loadGrayFormConfigList((String)appGroup);
        if (CollectionUtils.isEmpty((Collection)formConfigs)) {
            this.logDebugInfo("CollectionUtils.isEmpty(formConfigs)", new Object[0]);
            return;
        }
        HashMap<String, String> entityNumNameMap = new HashMap<String, String>(8);
        for (Object fc : formConfigs) {
            String entityNum = fc.getEntityTypeId();
            String entityName = fc.getCaption().getLocaleValue();
            String tempAppNum = fc.getBizAppNumber();
            if (!curAppNum.equals(tempAppNum)) {
                this.logDebugInfo("!curAppNum[%s].equals(tempAppNum[%s])", curAppNum, tempAppNum);
                continue;
            }
            entityNumNameMap.put(entityNum, entityName);
        }
        StringBuilder sbEntNumSqlStr = new StringBuilder();
        for (String tempEntNum : entityNumNameMap.keySet()) {
            if (StringUtils.isEmpty((String)tempEntNum)) {
                this.logDebugInfo("StringUtils.isEmpty(tempEntNum)", tempEntNum);
                continue;
            }
            sbEntNumSqlStr.append('\'').append(tempEntNum).append('\'').append(',');
        }
        int lastCommaIndex = sbEntNumSqlStr.lastIndexOf(",");
        if (lastCommaIndex != -1) {
            sbEntNumSqlStr.deleteCharAt(lastCommaIndex);
        }
        final HashMap entNumIdMap = new HashMap(8);
        StringBuilder sbQueryFunPermSql = new StringBuilder("select distinct fdentitytypeid, fentitytypeid from t_perm_functionperm ").append(" where fentitytypeid in(").append((CharSequence)sbEntNumSqlStr).append(") ");
        DB.query((DBRoute)DBRoute.permission, (String)sbQueryFunPermSql.toString(), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String entId = rs.getString("fdentitytypeid");
                    String entNum = rs.getString("fentitytypeid");
                    entNumIdMap.put(entNum, entId);
                }
                return null;
            }
        });
        this.logDebugInfo("entPermItemMap:%s", entNumIdMap);
        for (Map.Entry entry : entNumIdMap.entrySet()) {
            String entNum = (String)entry.getKey();
            String entId = (String)entry.getValue();
            String entName = (String)entityNumNameMap.get(entNum);
            String entNodeId = entId + "|" + entNum + "@" + appId + NODESUFFIX_ENTITY;
            TreeNode tn = new TreeNode(appId + NODESUFFIX_APP, entNodeId, entName, this.ifShowPermItemNode);
            listNode.add(tn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermItemNode(String parentNodeId) {
        Map adminSysPerm;
        Map entityMap;
        String adminSysPermStr;
        String langStr = RequestContext.get().getLang().name();
        boolean isShowNum = this.getIsShowNumFlag();
        String entityId = parentNodeId.substring(0, parentNodeId.indexOf(124));
        String entityNum = parentNodeId.substring(parentNodeId.indexOf(124) + 1, parentNodeId.indexOf(64));
        String appId = parentNodeId.substring(parentNodeId.indexOf(64) + 1);
        List permItems = null;
        List sysCloudApps = (List)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.getBigObject(SYS_CLOUD_APP), List.class);
        if (sysCloudApps.contains(appId) && StringUtils.isNotEmpty((String)(adminSysPermStr = this.permPageCacheUtil.getBigObject("pageCache_adminSysPerm"))) && (entityMap = (Map)(adminSysPerm = (Map)SerializationUtils.fromJsonString((String)adminSysPermStr, Map.class)).get(appId)) != null) {
            permItems = (List)entityMap.get(entityNum);
        }
        String algoKeyPrefix = this.getClass().getName() + ".addEntityNode.";
        DataSet finalDS = null;
        try {
            Object[] param;
            StringBuilder sql = new StringBuilder(" SELECT funcperm.fentitytypeid funcperm_entnum, funcperm.FDENTITYTYPEID funcperm_entid, funcperm.FID funcperm_id, funcperm.fseq permitem_seq, ").append(" permitem.fid permiteml_id, permiteml.fname permiteml_name, permitem.fnumber permitem_num ").append(" FROM t_perm_functionperm funcperm ").append(" INNER JOIN t_perm_permitem permitem ON permitem.FID = funcperm.FPERMITEMID ").append(" LEFT JOIN t_perm_permitem_l permiteml ON (permiteml.FID = permitem.FID AND permiteml.FLOCALEID = ?) ").append(" WHERE funcperm.FDENTITYTYPEID = ? ");
            if (permItems != null && !permItems.isEmpty()) {
                param = new Object[permItems.size() + 2];
                param[0] = langStr;
                param[1] = entityId;
                sql.append(" AND permitem.fid IN (");
                for (int i = 0; i < permItems.size(); ++i) {
                    param[i + 2] = permItems.get(i);
                    sql.append('?').append(',');
                }
                sql.deleteCharAt(sql.length() - 1).append(") ");
            } else {
                param = new Object[]{langStr, entityId};
            }
            finalDS = DB.queryDataSet((String)(algoKeyPrefix + "funcPermDS"), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])param).distinct();
            HashMap<String, String> permItemMap = new HashMap<String, String>(20);
            ArrayList<TreeNode> listNode = new ArrayList<TreeNode>(20);
            Map allPermItemIdNameMap = PermItemHelper.getAllPermItemIdNameMap();
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                String permItemId = row.getString("permiteml_id");
                String permItemNum = row.getString("permitem_num");
                String funcPermEntityNum = row.getString("funcperm_entnum");
                Integer permItemSeq = row.getInteger("permitem_seq");
                String id = funcPermEntityNum + '|' + permItemId + '@' + appId + NODESUFFIX_PERMITEM;
                permItemMap.put(id, permItemNum);
                String name = (String)allPermItemIdNameMap.get(permItemId);
                if (StringUtils.isEmpty((String)name)) {
                    name = permItemNum;
                } else if (isShowNum) {
                    name = name + "(" + permItemNum + ")";
                }
                TreeNode permItemNode = new TreeNode(parentNodeId + NODESUFFIX_ENTITY, id, name, false, (Object)permItemSeq);
                listNode.add(permItemNode);
            }
            if (!listNode.isEmpty()) {
                listNode.sort((o1, o2) -> {
                    String id1 = o1.getId();
                    String id2 = o2.getId();
                    Integer seq1 = (Integer)o1.getData();
                    Integer seq2 = (Integer)o2.getData();
                    if (seq1 == null || seq2 == null || Integer.valueOf(0).equals(seq1) && Integer.valueOf(0).equals(seq2)) {
                        String permItemNum1 = (String)permItemMap.get(id1);
                        String permItemNum2 = (String)permItemMap.get(id2);
                        return permItemNum1.compareTo(permItemNum2);
                    }
                    return seq1.compareTo(seq2);
                });
                this.treeView.addNodes(listNode);
            }
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
    }

    private void appendCloudFilter(StringBuilder sb) {
        Set disabledCloudIds;
        Set cloudBlack;
        List<String> cloudIdsBlackListFromStd;
        String cloudIdBlackList;
        boolean enableSysAuthority;
        String[] filterCloudNumsArr;
        sb.append(" and cloud.fid <> '2HGKCE94QELW' ");
        if (PermCommonUtil.isCosmicUser((Long)RequestContext.get().getCurrUserId())) {
            sb.append(" and cloud.fid in('83bfebc800000bac', '0QLCSO6KKZC9') ");
            return;
        }
        String filterCloudNumsStr = this.permPageCacheUtil.get("FormShowParam_cloudNums");
        if (StringUtils.isNotEmpty((String)filterCloudNumsStr) && (filterCloudNumsArr = filterCloudNumsStr.split(",")) != null && filterCloudNumsArr.length > 0) {
            ArrayList<String> tempList = new ArrayList<String>(8);
            for (String filterCloudNum : filterCloudNumsArr) {
                if (StringUtils.isEmpty((String)filterCloudNum)) continue;
                filterCloudNum = filterCloudNum.trim();
                tempList.add(filterCloudNum);
            }
            String filterCloudNumStr = String.join((CharSequence)"','", tempList);
            sb.append(" and cloud.fnumber in ('").append(filterCloudNumStr).append("') ");
        }
        if (!(enableSysAuthority = PermCommonUtil.isEnableSysAuthority())) {
            sb.append(" and cloud.fid not in('83bfebc800000bac') ");
        }
        if (StringUtils.isNotEmpty((String)(cloudIdBlackList = RunModeServiceHelper.getCloudIdsFromBlackList()))) {
            sb.append(" and cloud.fid not in (").append(cloudIdBlackList).append(')');
        }
        if (!CollectionUtils.isEmpty(cloudIdsBlackListFromStd = PermFormCommonUtil.getCloudIdsFromStdBlackList())) {
            String cloudIdsBlackListFromStdStr = String.join((CharSequence)"','", cloudIdsBlackListFromStd);
            sb.append(" and cloud.fid not in ('").append(cloudIdsBlackListFromStdStr).append("') ");
        }
        if (this.blackMap == null) {
            this.blackMap = PermCommonUtil.getImpleConfigBlack();
        }
        if (!CollectionUtils.isEmpty(this.blackMap) && !CollectionUtils.isEmpty((Collection)(cloudBlack = (Set)this.blackMap.get(CLOUD_BLACK)))) {
            String cloudBlackStr = String.join((CharSequence)"','", cloudBlack);
            sb.append(" and cloud.fid not in ('").append(cloudBlackStr).append("') ");
        }
        if (null != (disabledCloudIds = ManageServiceHelper.getDisabledCloudIds()) && !disabledCloudIds.isEmpty()) {
            String disabledCloudIdsStr = String.join((CharSequence)"','", disabledCloudIds);
            sb.append(" and cloud.fid not in ('").append(disabledCloudIdsStr).append("') ");
        }
    }

    private DataSet getGrayInfoDataSetForSearch(DataSet refDS, String searchText) {
        String accountId;
        String assignPermUserId = this.permPageCacheUtil.get(TO_BE_ASSIGNED_USER_ID);
        Map appNumAndGroupMap = GrayStrategy.getUserAppGroup((String)assignPermUserId, (String)(accountId = RequestContext.get().getAccountId()));
        if (CollectionUtils.isEmpty((Map)appNumAndGroupMap)) {
            return null;
        }
        Set userGrayAppNums = appNumAndGroupMap.keySet();
        HashMap<String, Set> appNumEntNumMap = new HashMap<String, Set>();
        HashMap<String, String> entNumNameMap = new HashMap<String, String>();
        HashSet<String> appGroups = new HashSet<String>(8);
        for (String appGroup : appNumAndGroupMap.values()) {
            if (StringUtils.isEmpty((String)appGroup)) continue;
            appGroups.add(appGroup);
        }
        for (String appGroup : appGroups) {
            List formConfigs = PermGrayHelper.loadGrayFormConfigList((String)appGroup);
            Iterator iterator = formConfigs.iterator();
            while (iterator.hasNext()) {
                FormConfig fc = (FormConfig)iterator.next();
                String tempAppNum = fc.getBizAppNumber();
                String entityNum = fc.getEntityTypeId();
                String entityName = fc.getCaption().getLocaleValue();
                if (!entityName.contains(searchText)) continue;
                entNumNameMap.put(entityNum, entityName);
                if (!userGrayAppNums.contains(tempAppNum) || !StringUtils.isNotEmpty((String)tempAppNum)) continue;
                appNumEntNumMap.computeIfAbsent(tempAppNum, k -> new HashSet()).add(entityNum);
            }
        }
        List grayAppInfos = PermGrayHelper.loadGrayAppInfoList();
        HashMap<String, List> cloudAppMap = new HashMap<String, List>();
        for (String tempAppNum : appNumEntNumMap.keySet()) {
            AppInfo appInfo = PermGrayHelper.findGrayAppInfoByNum((String)tempAppNum, (List)grayAppInfos);
            if (appInfo == null) continue;
            String cloudId = appInfo.getCloudId();
            String appId = appInfo.getId();
            cloudAppMap.computeIfAbsent(cloudId, k -> new ArrayList()).add(new String[]{appId, tempAppNum});
        }
        Map cloudObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)"id,number,name", (QFilter[])new QFilter("id", "in", cloudAppMap.keySet()).toArray());
        Collection values = cloudObjMap.values();
        HashMap<String, String> cloudIdNameMap = new HashMap<String, String>(values.size());
        HashMap<String, String> cloudIdNumMap = new HashMap<String, String>(values.size());
        for (Object cloudObj : values) {
            String cloudId = (String)cloudObj.getPkValue();
            String cloudName = cloudObj.getString("name");
            String cloudNum = cloudObj.getString("number");
            cloudIdNameMap.put(cloudId, cloudName);
            cloudIdNumMap.put(cloudId, cloudNum);
        }
        StringBuilder sbEntNumSqlStr = new StringBuilder();
        for (Set tempEntNums : appNumEntNumMap.values()) {
            if (CollectionUtils.isEmpty((Collection)tempEntNums)) continue;
            for (String tempEntNum : tempEntNums) {
                sbEntNumSqlStr.append('\'').append(tempEntNum).append('\'').append(',');
            }
        }
        int lastCommaIndex = sbEntNumSqlStr.lastIndexOf(",");
        if (lastCommaIndex != -1) {
            sbEntNumSqlStr.deleteCharAt(lastCommaIndex);
        }
        if (StringUtils.isEmpty((String)sbEntNumSqlStr.toString())) {
            return null;
        }
        StringBuilder sbQueryFunPermSql = new StringBuilder("select fid, fdentitytypeid, fentitytypeid, fpermitemid from t_perm_functionperm ").append(" where fentitytypeid in(").append((CharSequence)sbEntNumSqlStr).append(") ");
        final HashMap entPermItemMap = new HashMap(8);
        final HashMap entNumIdMap = new HashMap(8);
        final HashSet permItemIds = new HashSet();
        DB.query((DBRoute)DBRoute.permission, (String)sbQueryFunPermSql.toString(), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String funPermId = rs.getString("fid");
                    String entId = rs.getString("fdentitytypeid");
                    String entNum = rs.getString("fentitytypeid");
                    String permItemId = rs.getString("fpermitemid");
                    entPermItemMap.computeIfAbsent(entNum, k -> new ArrayList()).add(new String[]{permItemId, funPermId});
                    entNumIdMap.put(entNum, entId);
                    permItemIds.add(permItemId);
                }
                return null;
            }
        });
        HashMap<String, String[]> permItemInfoMap = new HashMap<String, String[]>();
        Map permItemObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_permitem", (String)"id,number,name", (QFilter[])new QFilter("id", "in", permItemIds).toArray());
        for (DynamicObject permItemObj : permItemObjMap.values()) {
            String permItemId = permItemObj.getString("id");
            String permItemNum = permItemObj.getString("number");
            String permItemName = permItemObj.getString("name");
            permItemInfoMap.computeIfAbsent(permItemId, k -> new String[]{permItemNum, permItemName});
        }
        Algo algo = Algo.create((String)"kd.bos.permission.formplugin.util.UserFuncPermTreeUtil.addGrayInfoToDS");
        RowMeta rowMeta = refDS.getRowMeta();
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        Field[] fields = rowMeta.getFields();
        ArrayList grayDataList = new ArrayList();
        for (Map.Entry entry : cloudIdNameMap.entrySet()) {
            String cloudId = (String)entry.getKey();
            String cloudName = (String)entry.getValue();
            List appInfos = (List)cloudAppMap.get(cloudId);
            if (CollectionUtils.isEmpty((Collection)appInfos)) continue;
            for (String[] appInfoArr : appInfos) {
                String appId = appInfoArr[0];
                String tempAppNum = appInfoArr[1];
                Set entNums = (Set)appNumEntNumMap.get(tempAppNum);
                if (CollectionUtils.isEmpty((Collection)entNums)) continue;
                for (String entNum : entNums) {
                    List permItemInfos = (List)entPermItemMap.get(entNum);
                    if (CollectionUtils.isEmpty((Collection)permItemInfos)) continue;
                    String entId = (String)entNumIdMap.get(entNum);
                    HashMap<String, String> grayDataInfo = new HashMap<String, String>();
                    grayDataInfo.put("entd_num", entNum);
                    grayDataInfo.put("entd_id", entId);
                    grayDataInfo.put("fname", (String)entNumNameMap.get(entNum));
                    grayDataInfo.put("cloud_id", cloudId);
                    grayDataInfo.put("cloud_name", cloudName);
                    grayDataInfo.put("cloud_num", (String)cloudIdNumMap.get(cloudId));
                    grayDataInfo.put(FIELD_APP_MASTERID, appId);
                    grayDataInfo.put("app_id", appId);
                    grayDataInfo.put("app_num", tempAppNum);
                    grayDataList.add(grayDataInfo);
                }
            }
        }
        for (Map map : grayDataList) {
            Object[] rowDataArr = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                rowDataArr[i] = map.get(fields[i].getName());
            }
            builder.append(rowDataArr);
        }
        return builder.build();
    }

    private DataSet addGrayInfoToDSForSearch(DataSet finalDS, String searchText) {
        DataSet grayDataSet = this.getGrayInfoDataSetForSearch(finalDS, searchText);
        if (grayDataSet == null) {
            return finalDS;
        }
        finalDS = finalDS.union(grayDataSet);
        return finalDS;
    }

    public void recordIsReportFormOrNotByTreeNodeId(String treeNodeId) {
        Boolean isReportFormModel = false;
        if (treeNodeId.contains(NODESUFFIX_ENTITY)) {
            String entId = treeNodeId.split("\\|")[0];
            String sql = "select fmodeltype from t_meta_mainentityinfo where fdentityid = ? ";
            isReportFormModel = (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{entId}, rs -> {
                if (rs.next()) {
                    return "ReportFormModel".equals(rs.getString("fmodeltype"));
                }
                return false;
            });
        }
        this.permPageCacheUtil.put("treeNodeIsReportForm", isReportFormModel.toString());
    }

    private Set<String> getMatchUserTypeAppIds() {
        StringBuilder sbAppRuntimeSql = new StringBuilder().append("select app.fid app_id ").append(" from t_meta_appruntime app where app.fdeploystatus = '2' ");
        this.appendUserType(sbAppRuntimeSql);
        String algoKeyPrefix = this.getClass().getName();
        HashSet<String> matchUserTypeAppIds = new HashSet<String>(8);
        try (DataSet appRuntimeDS = DB.queryDataSet((String)(algoKeyPrefix + "getMatchUserTypeAppIds"), (DBRoute)DBRoute.meta, (String)sbAppRuntimeSql.toString(), null);){
            while (appRuntimeDS.hasNext()) {
                Row row = appRuntimeDS.next();
                String matchAppId = row.getString("app_id");
                if (StringUtils.isEmpty((String)matchAppId)) continue;
                matchUserTypeAppIds.add(matchAppId);
            }
        }
        return matchUserTypeAppIds;
    }
}

