/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormConfig;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.CloudHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.PermGrayHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.permbase.Cloud;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.perm.Entity;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class FuncPermTreeUtil {
    private static final Log logger = LogFactory.getLog(FuncPermTreeUtil.class);
    protected IPageCache pageCache;
    protected static final String VALUE_TRUE = "true";
    protected static final String PGCACHE_ENTITY_ASSIGNABLE_PERMITEM_MAP = "entityAssignablePermItemMap";

    public FuncPermTreeUtil(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public List<String> getAllFuncPermTreeData(Map<String, Object> allFunPermTreeParaMap) {
        ArrayList<String> arrayList;
        String dimType = (String)allFunPermTreeParaMap.get("dimType");
        String dimDiffHide = (String)allFunPermTreeParaMap.get("dimDiffHide");
        boolean filterBySysCloudApp = (Boolean)allFunPermTreeParaMap.get("filterBySysCloudApp");
        boolean fieldDrSpecialLeftTreeHide = null == allFunPermTreeParaMap.get("fieldDrSpecialLeftTreeHide") ? false : (Boolean)allFunPermTreeParaMap.get("fieldDrSpecialLeftTreeHide");
        DataSet publishAppDataSet = null;
        DataSet allUserAppDataSet = null;
        DataSet appCloudDataSet = null;
        DataSet entDataSet = null;
        DataSet entDataSetForAllUserApp = null;
        DataSet appCloudDataSetForAllUserApp = null;
        try {
            HashSet disabledAppIds;
            String showForSpecialUser;
            HashSet adminChargeApps;
            Map<String, String> entityNumNameMap = this.getEntityNumNameMap();
            String[] suitableDimType = PermCommonUtil.getSuitableDimType((String)dimType);
            String appNumForUser = null == this.pageCache || StringUtils.isEmpty((String)this.pageCache.get("FormShowParam_appNum")) ? null : this.pageCache.get("FormShowParam_appNum");
            StringBuilder appNumFilter = this.appendAppNumFilter(appNumForUser);
            List allUserAppIds = PermCommonUtil.getAllUserAppIds();
            HashSet allUserAppIdSet = null == allUserAppIds ? new HashSet(1) : new HashSet(allUserAppIds);
            allUserAppIdSet = null == allUserAppIdSet ? new HashSet(1) : allUserAppIdSet;
            HashSet notCheckPermAllUserAppIds = new HashSet(allUserAppIdSet);
            Map allAppInfo = AppMetadataCache.getAllAppInfo();
            Map checkPermAllUserAppEntMap = PermCommonUtil.getCheckPermAllUserAppEntMap();
            checkPermAllUserAppEntMap = null == checkPermAllUserAppEntMap ? new HashMap(1) : checkPermAllUserAppEntMap;
            notCheckPermAllUserAppIds.removeAll(checkPermAllUserAppEntMap.keySet());
            StringBuilder querySql = new StringBuilder();
            querySql.append("SELECT ent.fid, ent.fnumber, app.fid appid, app.fnumber appnum, app.fseq appseq, ").append(" app.fmasterid appmasterid, app2.fnumber appmasternum, ").append(" cloud.fid cloudid, cloud.fnumber cloudnum, cloud.fseq cloudseq ").append("FROM t_meta_entitydesign ent ").append("LEFT JOIN t_meta_bizapp app ON (app.fid = ent.fbizappid AND app.falluserapp = '0' AND app.fdeploystatus = '2' ").append((CharSequence)appNumFilter).append(") LEFT JOIN t_meta_bizapp app2 ON (app.fmasterid = app2.fid) ").append("LEFT JOIN t_meta_bizcloud cloud ON (cloud.fid = app.fbizcloudid) ").append("WHERE (ent.fmasterid is null OR ent.fmasterid = ' ') AND ent.fistemplate = '0' AND ent.fmodeltype <> 'ReportQueryListModel' ").append("AND cloud.fid <> '2HGKCE94QELW' ");
            Set appMasterIdSet = (Set)DB.query((DBRoute)DBRoute.meta, (String)querySql.toString(), null, rs -> {
                HashSet<String> result = new HashSet<String>(128);
                while (rs.next()) {
                    String appmasterid;
                    String cloudId = rs.getString("cloudid");
                    if (StringUtils.isEmpty((String)cloudId) || !StringUtils.isNotEmpty((String)(appmasterid = rs.getString("appmasterid"))) || !StringUtils.isNotEmpty((String)appmasterid.trim())) continue;
                    result.add(appmasterid);
                }
                return result;
            });
            Map cloudMap = CloudHelper.getCloudMap((Set)appMasterIdSet);
            HashSet finalAllUserAppIdSet = allUserAppIdSet;
            Set entitySet = (Set)DB.query((DBRoute)DBRoute.meta, (String)querySql.toString(), null, rs -> {
                HashSet<String> result = new HashSet<String>(20000);
                while (rs.next()) {
                    String cloudId = rs.getString("cloudid");
                    if (StringUtils.isEmpty((String)cloudId)) continue;
                    String appmasterid = rs.getString("appmasterid");
                    String appId = rs.getString("appmasterid");
                    String appNum = rs.getString("appmasternum");
                    if (StringUtils.isEmpty((String)appId)) {
                        appId = rs.getString("appId");
                        appNum = rs.getString("appnum");
                        if (StringUtils.isEmpty((String)appId)) continue;
                    }
                    String appSeqStr = AppHelper.getAppSeqStr((Map)allAppInfo, (String)rs.getString("appseq"), (String)appNum);
                    if (finalAllUserAppIdSet.contains(appId)) continue;
                    String cloudNum = "";
                    String cloudSeq = "";
                    if (StringUtils.isNotEmpty((String)appmasterid) && StringUtils.isNotEmpty((String)appmasterid.trim())) {
                        Cloud cloud = (Cloud)cloudMap.get(appmasterid);
                        if (null != cloud) {
                            cloudId = cloud.getCloudId();
                            cloudNum = cloud.getCloudNumber();
                            cloudSeq = String.valueOf(cloud.getCloudSeq());
                        }
                    } else {
                        cloudNum = rs.getString("cloudnum");
                        cloudSeq = rs.getString("cloudseq");
                    }
                    String entityNum = rs.getString("fnumber");
                    String info = String.join((CharSequence)"    ", cloudSeq, cloudId, cloudNum, appSeqStr, appId, appNum, entityNum);
                    result.add(info);
                }
                return result;
            });
            querySql.setLength(0);
            List checkPermAllUserAppIdList = PermCommonUtil.getCheckPermAllUserAppIdList();
            Sets.SetView notCtrlPermAllUserAppIdSet = Sets.difference(allUserAppIdSet, new HashSet(checkPermAllUserAppIdList));
            querySql.append("SELECT fbizappid appid, fbizobjid entitynum FROM t_perm_bizobjapp ");
            querySql.append(" where fbizappid not in(").append(ListUtil.getSqlList((Collection)notCtrlPermAllUserAppIdSet)).append(')');
            publishAppDataSet = DB.queryDataSet((String)"publishAppDataSet", (DBRoute)DBRoute.permission, (String)querySql.toString());
            querySql.setLength(0);
            querySql.append("SELECT app.fid appid, app.fnumber appnum, app.fseq appseq, cloud.fid cloudid, cloud.fnumber cloudnum, cloud.fseq cloudseq FROM t_meta_bizapp app ").append("LEFT JOIN t_meta_bizcloud cloud ON app.fbizcloudid = cloud.fid ").append("WHERE (app.fmasterid is null OR app.fmasterid = ' ') AND app.fdeploystatus = '2' ").append("AND cloud.fid <> '2HGKCE94QELW' ").append((CharSequence)appNumFilter);
            appCloudDataSet = DB.queryDataSet((String)"appCloudDataSet", (DBRoute)DBRoute.meta, (String)querySql.toString());
            appCloudDataSetForAllUserApp = appCloudDataSet.copy();
            querySql.setLength(0);
            querySql.append("SELECT ent.fnumber entNum ");
            querySql.append(" FROM t_meta_entitydesign ent ");
            querySql.append(" WHERE ent.fistemplate = '0' AND ent.fmodeltype <> 'ReportQueryListModel' ");
            entDataSet = DB.queryDataSet((String)"entDataSet", (DBRoute)DBRoute.meta, (String)querySql.toString());
            entDataSetForAllUserApp = entDataSet.copy();
            publishAppDataSet = publishAppDataSet.join(appCloudDataSet).on("appid", "appid").select(new String[]{"entitynum"}, new String[]{"appid", "appnum", "appseq", "cloudid", "cloudnum", "cloudseq"}).finish();
            publishAppDataSet = publishAppDataSet.join(entDataSet).on("entitynum", "entNum").select(new String[]{"entitynum", "appid", "appnum", "appseq", "cloudid", "cloudnum", "cloudseq"}, new String[0]).finish();
            this.appendEntityInfo(entitySet, publishAppDataSet, allAppInfo);
            querySql.setLength(0);
            querySql.append("SELECT fappid appid, fentitynum entitynum FROM t_perm_alluserappent a ");
            allUserAppDataSet = DB.queryDataSet((String)"allUserAppDataSet", (DBRoute)DBRoute.permission, (String)querySql.toString());
            allUserAppDataSet = allUserAppDataSet.join(appCloudDataSetForAllUserApp).on("appid", "appid").select(new String[]{"entitynum"}, new String[]{"appid", "appnum", "appseq", "cloudid", "cloudnum", "cloudseq"}).finish();
            allUserAppDataSet = allUserAppDataSet.join(entDataSetForAllUserApp).on("entitynum", "entNum").select(new String[]{"entitynum", "appid", "appnum", "appseq", "cloudid", "cloudnum", "cloudseq"}, new String[0]).finish();
            FuncPermTreeUtil.appendAllUserAppAuth(allUserAppDataSet, entitySet, allAppInfo);
            this.getGrayInfoNode(entitySet, entityNumNameMap);
            querySql.setLength(0);
            querySql.append("SELECT distinct fp.fentitytypeid entitynum, fp.fpermitemid permitemid, pit.fnumber ").append(" FROM t_perm_functionperm fp ").append("LEFT JOIN t_perm_permitem pit ON pit.fid = fp.fpermitemid ").append("ORDER BY fp.fentitytypeid, pit.fnumber ");
            Map entityPermItemMap = (Map)DB.query((DBRoute)DBRoute.permission, (String)querySql.toString(), null, rs -> {
                HashMap<String, List> result = new HashMap<String, List>(2000);
                while (rs.next()) {
                    String entityNum = rs.getString("entitynum");
                    String permItemId = rs.getString("permitemid");
                    result.computeIfAbsent(entityNum, k -> new ArrayList(20)).add(permItemId);
                }
                return result;
            });
            List permNodeDetail = entitySet.stream().sorted().collect(Collectors.toList());
            HashMap entForbidDataPermTreeMap = null;
            if (fieldDrSpecialLeftTreeHide) {
                entForbidDataPermTreeMap = new HashMap(8);
            }
            HashMap formShowOnTreeStatusMap = new HashMap(8);
            HashMap<String, String> formShowOnTreeStatusParaMap = new HashMap<String, String>(8);
            formShowOnTreeStatusParaMap.put("dimension", suitableDimType[0]);
            formShowOnTreeStatusParaMap.put("dimDiffHide", dimDiffHide);
            PermCommonUtil.getFormShowOnTreeStatusMap(formShowOnTreeStatusParaMap, formShowOnTreeStatusMap, entForbidDataPermTreeMap);
            String appIdBlackList = StringUtils.isEmpty((String)RunModeServiceHelper.getAppIdFromBlacklist()) ? "" : RunModeServiceHelper.getAppIdFromBlacklist();
            ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
            Map appEntMapRunModeBlackList = PermCommonUtil.getRunModeBlackList_AppEntMap();
            List formBlackList_ = service.getFormBlackList();
            HashSet formNumsFromStdBlackSet = null == formBlackList_ || formBlackList_.isEmpty() ? new HashSet(0) : new HashSet(formBlackList_);
            List appIdBlackList_ = service.getAppIdBlackList();
            HashSet appIdsInBlackSet = null == appIdBlackList_ || appIdBlackList_.isEmpty() ? new HashSet(0) : new HashSet(appIdBlackList_);
            boolean enableSysAuthority = PermCommonUtil.isEnableSysAuthority();
            List sysCloudAppList = AdminSchemeHelper.queryAllSysApp((boolean)false, (boolean)false);
            HashSet sysCloudApp = null == sysCloudAppList ? new HashSet(0) : new HashSet(sysCloudAppList);
            Long curUserId = RequestContext.get().getCurrUserId();
            HashMap paraMap = new HashMap(8);
            paraMap.put("sysCloudApp", sysCloudApp);
            List adminChargeAppList = PermissionServiceHelper.getAdminChargeApps((Long)curUserId, paraMap);
            HashSet hashSet = adminChargeApps = null == adminChargeAppList ? new HashSet(0) : new HashSet(adminChargeAppList);
            if (notCheckPermAllUserAppIds != null && !notCheckPermAllUserAppIds.isEmpty()) {
                adminChargeApps.removeAll(notCheckPermAllUserAppIds);
            }
            boolean showForSpecial = false;
            String string = showForSpecialUser = null == this.pageCache || StringUtils.isEmpty((String)this.pageCache.get("FormShowParam_ShowForSpecialUser")) ? null : this.pageCache.get("FormShowParam_ShowForSpecialUser");
            if (VALUE_TRUE.equals(showForSpecialUser)) {
                showForSpecial = true;
            }
            Map adminSysPermTwoMap = AdminPermCache.getAdminSysPermTwoMap((Long)curUserId);
            Map adminSysAppEntSetMap = null;
            Map adminSysEntPermItemSetMap = null;
            if (adminSysPermTwoMap != null) {
                adminSysAppEntSetMap = (Map)adminSysPermTwoMap.get("adminSysAppEntSetMap");
                adminSysEntPermItemSetMap = (Map)adminSysPermTwoMap.get("adminSysEntPermItemSetMap");
            }
            Map blackMap = PermCommonUtil.getImpleConfigBlack();
            Map entityBlackMap = (Map)blackMap.get("entityBlack");
            Map appEnNumPermBlackMap = (Map)blackMap.get("permissionBlack");
            HashSet disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
            if (disabledCloudIds == null) {
                disabledCloudIds = new HashSet(16);
            }
            if ((disabledAppIds = ManageServiceHelper.getDisabledAppIds()) == null) {
                disabledAppIds = new HashSet(16);
            }
            ArrayList<String> dataBeanInfos = new ArrayList<String>(permNodeDetail.size());
            Map<String, String> allPermNodeInfoMap = this.getAllPermNodeInfoMap();
            Map<String, String> allEntityInfoMap = this.getAllEntityInfoMap();
            Set<String> matchUserTypeAppIds = this.getMatchUserTypeAppIds();
            for (String permNode : permNodeDetail) {
                Set entityNums;
                List entityPermItem;
                Set entityNums_RunModeblackList;
                String[] arr = permNode.split("    ");
                if (arr.length < 7) continue;
                String cloudSeq = arr[0];
                String cloudId = arr[1];
                String cloudNum = arr[2];
                String appId = arr[4];
                String appNum = arr[5];
                String appSeq = AppHelper.getAppSeqStr((Map)allAppInfo, (String)arr[3], (String)appNum);
                String entityNum = arr[6];
                String entityName = entityNumNameMap.get(entityNum);
                if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entityNum) || Objects.equals("perm_admingroup", entityNum) || Objects.equals("perm_useradmingroup", entityNum) || matchUserTypeAppIds != null && !matchUserTypeAppIds.contains(appId)) continue;
                String permInfo = String.join((CharSequence)"    ", cloudSeq, cloudNum, cloudId, appSeq, appNum, appId, entityNum, entityName);
                allEntityInfoMap.put(appId + "|" + entityNum, permInfo);
                if (null != entForbidDataPermTreeMap && null != entForbidDataPermTreeMap.get(entityNum) && ((Boolean)entForbidDataPermTreeMap.get(entityNum)).booleanValue() || disabledCloudIds.contains(cloudId) || disabledAppIds.contains(appId) || appIdBlackList.contains(appId) || appIdsInBlackSet.contains(appId) || (entityNums_RunModeblackList = (Set)appEntMapRunModeBlackList.get(appId)) != null && entityNums_RunModeblackList.contains(entityNum) || formNumsFromStdBlackSet.contains(entityNum) || !showForSpecial && !adminChargeApps.contains(appId) || "false".equals(formShowOnTreeStatusMap.get(entityNum)) || CollectionUtils.isEmpty((Collection)(entityPermItem = (List)entityPermItemMap.get(entityNum))) || filterBySysCloudApp && !enableSysAuthority && sysCloudApp.contains(appId)) continue;
                if (enableSysAuthority && sysCloudApp.contains(appId)) {
                    Set adminSysEntSet;
                    if (adminSysAppEntSetMap != null && !adminSysAppEntSetMap.isEmpty() && (null == (adminSysEntSet = (Set)adminSysAppEntSetMap.get(appId)) || !adminSysEntSet.contains(entityNum))) continue;
                    if (adminSysEntPermItemSetMap != null && !adminSysEntPermItemSetMap.isEmpty()) {
                        Set adminSysPermItemSet = (Set)adminSysEntPermItemSetMap.get(entityNum);
                        if (CollectionUtils.isEmpty((Collection)adminSysPermItemSet)) {
                            entityPermItemMap.remove(entityNum);
                            continue;
                        }
                        entityPermItemMap.put(entityNum, new ArrayList(adminSysPermItemSet));
                    }
                }
                if (null != entityBlackMap && !entityBlackMap.isEmpty() && StringUtils.isNotEmpty((String)entityNum) && null != (entityNums = (Set)entityBlackMap.get(appId)) && !entityNums.isEmpty() && entityNums.contains(entityNum)) {
                    entityPermItemMap.remove(entityNum);
                    continue;
                }
                if (null != appEnNumPermBlackMap && !appEnNumPermBlackMap.isEmpty()) {
                    List permissions;
                    Map entityNumPerms = (Map)appEnNumPermBlackMap.get(appId);
                    List list = permissions = CollectionUtils.isEmpty((Map)entityNumPerms) ? null : (List)entityNumPerms.get(entityNum);
                    if (null != permissions && !permissions.isEmpty()) {
                        ((List)entityPermItemMap.get(entityNum)).removeAll(permissions);
                        continue;
                    }
                }
                allPermNodeInfoMap.put(appId + "|" + entityNum, permInfo);
                dataBeanInfos.add(permInfo);
            }
            HashMap<String, String> entityPermItemFinalMap = new HashMap<String, String>(entityPermItemMap.size());
            for (Map.Entry entry : entityPermItemMap.entrySet()) {
                String key = (String)entry.getKey();
                String permItems = String.join((CharSequence)",", (Iterable)entry.getValue());
                entityPermItemFinalMap.put(key, permItems);
            }
            if (null != this.pageCache) {
                this.putEntityAssignablePermItemMap(entityPermItemFinalMap);
                this.putAllPermNodeInfoMap(allPermNodeInfoMap);
                this.putAllEntityInfoMap(allEntityInfoMap);
            }
            arrayList = dataBeanInfos;
        }
        catch (Exception e) {
            try {
                logger.warn("FuncPermTreeUtil.getAllFuncPermTreeData error", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{publishAppDataSet, allUserAppDataSet, entDataSet, appCloudDataSet, entDataSetForAllUserApp, appCloudDataSetForAllUserApp});
                throw throwable;
            }
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{publishAppDataSet, allUserAppDataSet, entDataSet, appCloudDataSet, entDataSetForAllUserApp, appCloudDataSetForAllUserApp});
        return arrayList;
    }

    private static void appendAllUserAppAuth(DataSet allUserAppDataSet, Set<String> entitySet, Map<String, AppInfo> allAppInfo) {
        Set checkPermAllUserEntNumSet = PermCommonUtil.getCheckPermAllUserEntNumSet();
        Map appIdByFormNum = FormHelper.getAppIdByFormNum(new ArrayList(checkPermAllUserEntNumSet));
        while (allUserAppDataSet.hasNext()) {
            String appId;
            Row next = allUserAppDataSet.next();
            String entityNum = next.getString("entitynum");
            String oriAppId = (String)appIdByFormNum.get(entityNum);
            if (StringUtils.isEmpty((String)oriAppId)) continue;
            String appNum = next.getString("appnum");
            String appSeq = "0";
            AppInfo appInfo = allAppInfo.get(appNum);
            if (appInfo != null) {
                Short seq = appInfo.getSeq();
                if (seq != null) {
                    appSeq = seq.toString();
                }
            } else {
                appSeq = next.getString("appseq");
            }
            if (StringUtils.isEmpty((String)appSeq)) {
                appSeq = "0";
            }
            if (!Objects.equals(oriAppId, appId = next.getString("appid"))) continue;
            String cloudSeq = next.getString("cloudseq");
            String cloudNum = next.getString("cloudnum");
            String cloudId = next.getString("cloudid");
            if (StringUtils.isEmpty((String)cloudId)) continue;
            String info = String.join((CharSequence)"    ", cloudSeq, cloudId, cloudNum, appSeq, appId, appNum, entityNum);
            entitySet.add(info);
        }
    }

    private StringBuilder appendAppNumFilter(String appNum) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((String)appNum)) {
            return sb;
        }
        if (appNum.contains(",")) {
            String[] appNumArr = appNum.split(",");
            sb.append(" and app.fnumber in(");
            for (int i = 0; i < appNumArr.length; ++i) {
                if (StringUtils.isEmpty((String)appNumArr[i])) continue;
                sb.append('\'').append(appNumArr[i].trim()).append('\'');
                if (i == appNumArr.length - 1) continue;
                sb.append(',');
            }
            sb.append(") ");
        } else if (!"BASE".equals(appNum) && !"SCP".equals(appNum)) {
            sb.append(" and app.fnumber = '").append(appNum).append("' ");
        }
        return sb;
    }

    private StringBuilder appendUserTypeFilter(String appNum, StringBuilder sb) {
        Long userIdL;
        DynamicObject user;
        String userIdStr;
        String[] split;
        HashSet finalUserTypeSet = new HashSet(8);
        String userTypes = FuncPermTreeUtil.getUserTypesByAppNum(appNum);
        if (userTypes != null && StringUtils.isNotEmpty((String)userTypes) && null != (split = userTypes.split(",")) && split.length > 0) {
            finalUserTypeSet.addAll(Arrays.stream(split).filter(x -> StringUtils.isNotEmpty((String)x)).collect(Collectors.toSet()));
        }
        if (StringUtils.isNotEmpty((String)(userIdStr = this.pageCache.get("paramUserId"))) && (user = BusinessDataServiceHelper.loadSingleFromCache((Object)(userIdL = Long.valueOf(userIdStr)), (String)"bos_user", (String)"usertype, usertypes")) != null) {
            Set userType;
            Map userTypeMap;
            String toBeAssignUser_Types = user.getString("usertype");
            if (StringUtils.isNotEmpty((String)toBeAssignUser_Types)) {
                finalUserTypeSet.addAll(Arrays.stream(toBeAssignUser_Types.split(",")).filter(x -> StringUtils.isNotEmpty((String)x)).collect(Collectors.toSet()));
            }
            if (null != (userTypeMap = UserHelper.getUserTypeMap((Set)Sets.newHashSet((Object[])new Long[]{userIdL}))) && !userTypeMap.isEmpty() && null != (userType = (Set)userTypeMap.get(userIdL)) && !userType.isEmpty()) {
                finalUserTypeSet.addAll(userType);
            }
        }
        if (null == finalUserTypeSet || finalUserTypeSet.isEmpty()) {
            return sb;
        }
        int index = 0;
        sb.append(" AND (");
        for (String userType : finalUserTypeSet) {
            if (index != 0) {
                sb.append(" OR ");
            }
            sb.append(" app.fusertype = '").append(userType).append("' ").append(" OR app.fusertype like '").append(userType).append(",%' ").append(" OR app.fusertype like '%,").append(userType).append("' ").append(" OR app.fusertype like '%,").append(userType).append(",%' ");
            ++index;
        }
        sb.append(')');
        return sb;
    }

    public static String getUserTypesByAppNum(String pAppNum) {
        if ("BASE".equals(pAppNum)) {
            return "1,5";
        }
        if ("SCP".equals(pAppNum)) {
            return "3";
        }
        return null;
    }

    private void getGrayInfoNode(Set<String> entitySet, Map<String, String> entityNumNameMap) {
        String accountId;
        String assignPermUserId = this.pageCache.get("paramUserId");
        Map appNumAndGroupMap = GrayStrategy.getUserAppGroup((String)assignPermUserId, (String)(accountId = RequestContext.get().getAccountId()));
        if (CollectionUtils.isEmpty((Map)appNumAndGroupMap)) {
            logger.debug(assignPermUserId + " : Empty (appNumAndGroupMap)");
            return;
        }
        String sql = "SELECT fid, fseq, fnumber FROM t_meta_bizcloud ";
        Map cloudInfoMap = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            HashMap<String, String> cloudInfo = new HashMap<String, String>(16);
            while (rs.next()) {
                String cloudId = rs.getString("fid");
                String seq = rs.getString("fseq");
                String number = rs.getString("fnumber");
                cloudInfo.put(cloudId, String.join((CharSequence)"    ", seq, number, cloudId));
            }
            return cloudInfo;
        });
        Set userGrayAppNums = appNumAndGroupMap.keySet();
        HashSet appGroups = new HashSet(8);
        List loadGrayAppInfoList = PermGrayHelper.loadGrayAppInfoList();
        appGroups.addAll(appNumAndGroupMap.values());
        for (String appGroup : appGroups) {
            List formConfigs = PermGrayHelper.loadGrayFormConfigList((String)appGroup);
            for (FormConfig fc : formConfigs) {
                String appCloudId;
                String cloudInfo;
                AppInfo appInfo;
                String tempAppNum = fc.getBizAppNumber();
                String entityNum = fc.getEntityTypeId();
                if (StringUtils.isEmpty((String)tempAppNum) || !userGrayAppNums.contains(tempAppNum) || (appInfo = PermGrayHelper.findGrayAppInfoByNum((String)tempAppNum, (List)loadGrayAppInfoList)) == null || StringUtils.isEmpty((String)(cloudInfo = (String)cloudInfoMap.get(appCloudId = appInfo.getCloudId())))) continue;
                String appId = appInfo.getId();
                String appNum = appInfo.getNumber();
                String appSeq = String.valueOf(appInfo.getSeq());
                String entityName = entityNumNameMap.get(entityNum);
                String permInfo = String.join((CharSequence)"    ", cloudInfo, appSeq, appNum, appId, entityNum, entityName);
                entitySet.add(permInfo);
            }
        }
    }

    private void appendEntityInfo(Set<String> entitySet, DataSet dataSet, Map<String, AppInfo> allAppInfo) {
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            String cloudId = next.getString("cloudid");
            if (StringUtils.isEmpty((String)cloudId)) continue;
            String appNum = next.getString("appnum");
            AppInfo appInfo = allAppInfo.get(appNum);
            String appSeq = "0";
            if (appInfo != null) {
                Short seq = appInfo.getSeq();
                if (seq != null) {
                    appSeq = seq.toString();
                }
            } else {
                appSeq = next.getString("appseq");
            }
            if (StringUtils.isEmpty((String)appSeq)) {
                appSeq = "0";
            }
            String cloudSeq = next.getString("cloudseq");
            String cloudNum = next.getString("cloudnum");
            String appId = next.getString("appid");
            if (StringUtils.isEmpty((String)appId)) continue;
            String entityNum = next.getString("entitynum");
            String info = String.join((CharSequence)"    ", cloudSeq, cloudId, cloudNum, appSeq, appId, appNum, entityNum);
            entitySet.add(info);
        }
    }

    public void initFuncPermLeftTree(TreeView tv, String dimType, boolean showNum) {
        String treeViewKey = tv.getKey();
        String searchMode = this.pageCache.getBigObject("allFuncPermTreeSearchMode");
        if (StringUtils.isNotEmpty((String)searchMode)) {
            List searchInfos = SerializationUtils.fromJsonStringToList((String)searchMode, String.class);
            this.rebuildTree(treeViewKey, tv, searchInfos, true, showNum);
            return;
        }
        tv.deleteAllNodes();
        String rootNodeStr = this.pageCache.getBigObject(treeViewKey);
        if (StringUtils.isNotEmpty((String)rootNodeStr)) {
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
            tv.addNode(rootNode);
            return;
        }
        HashMap<String, Object> allFunPermTreeParaMap = new HashMap<String, Object>();
        allFunPermTreeParaMap.put("dimType", dimType);
        allFunPermTreeParaMap.put("dimDiffHide", "1");
        allFunPermTreeParaMap.put("filterBySysCloudApp", true);
        List<String> dataBeanInfos = this.getAllFuncPermTreeData(allFunPermTreeParaMap);
        HashMap<String, Map<String, List<String>>> dataResource = new HashMap<String, Map<String, List<String>>>(16);
        this.processData(true, dataResource, dataBeanInfos);
        this.pageCache.putBigObject(dimType, SerializationUtils.toJsonString(dataResource));
        TreeNode rootNode = ConstantsHelper.getTreeRootNode((boolean)true, (String)ConstantsHelper.getFuncPerm());
        rootNode.setIsOpened(true);
        tv.addNode(rootNode);
        this.createCloudNodes(rootNode, dataResource, showNum);
        this.pageCache.putBigObject(treeViewKey, SerializationUtils.toJsonString((Object)rootNode));
    }

    public void rebuildTree(String treeView, TreeView tv, List<String> searchInfos, boolean funcPermTree, boolean showNum) {
        TreeNode rootNode;
        switch (treeView) {
            case "tree_allfunctionperm": {
                rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getFuncPerm());
                rootNode.setIsOpened(true);
                break;
            }
            case "tree_datarule": {
                rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAssignObj());
                rootNode.setIsOpened(true);
                break;
            }
            case "tree_funcperm": 
            case "tree_disfunperm": 
            case "tree_fieldperm": 
            case "tree_dataperm": {
                rootNode = ConstantsHelper.getTreeRootNode((boolean)false, (String)ConstantsHelper.getAllreadyAssignDesc());
                rootNode.setIsOpened(true);
                break;
            }
            default: {
                return;
            }
        }
        tv.deleteAllNodes();
        tv.addNode(rootNode);
        Map<String, String> cloudNameMap = this.getCloudNameMap();
        Map<String, String> cloudNumberMap = this.getCloudNumberMap();
        Map<String, String> appNameMap = this.getAppNameMap();
        Map<String, String> entityNumNameMap = this.getEntityNumNameMap();
        Map<String, String> permItemIdNameMap = this.getPermItemIdNameMap();
        if (!CollectionUtils.isEmpty(searchInfos)) {
            String lastKey = "";
            String lastEntityNode = "";
            TreeNode cloudNode = null;
            TreeNode appNode = null;
            TreeNode entityNode = null;
            String entityNodeId = "";
            for (String searchInfo : searchInfos) {
                Object[] arr = searchInfo.split("    ");
                String cloudId = arr[2];
                if ("2HGKCE94QELW".equals(cloudId)) continue;
                String appId = arr[5];
                String entityNum = arr[6];
                String curKey = cloudId + '_' + appId + '_' + entityNum;
                if (!lastKey.equals(curKey)) {
                    String appNodeId;
                    lastKey = curKey;
                    String cloudNodeId = "cloud#" + cloudId;
                    cloudNode = rootNode.getTreeNode(cloudNodeId);
                    if (cloudNode == null) {
                        String cloudName = cloudNameMap.get(cloudId);
                        String cloudNumber = cloudNumberMap.get(cloudId);
                        if (StringUtils.isEmpty((String)cloudName)) {
                            cloudName = cloudNumber;
                        } else if (showNum) {
                            cloudName = cloudName + '(' + cloudNumber + ')';
                        }
                        cloudNode = new TreeNode("-1", cloudNodeId, cloudName);
                        cloudNode.setIsOpened(true);
                        rootNode.addChild(cloudNode);
                    }
                    if ((appNode = cloudNode.getTreeNode(appNodeId = "app#" + appId)) == null) {
                        String appName = appNameMap.get(appId);
                        if (StringUtils.isEmpty((String)appName)) {
                            appName = appId;
                        }
                        if (showNum) {
                            String appNumber = StringUtils.isEmpty((String)arr[4]) ? "NotFound" : arr[4];
                            appName = appName + '(' + appNumber + ')';
                        }
                        appNode = new TreeNode(cloudNodeId, appNodeId, appName);
                        appNode.setIsOpened(true);
                        cloudNode.addChild(appNode);
                    }
                    entityNodeId = "entity#" + entityNum + '@' + appId;
                    if (!lastEntityNode.equals("") && lastEntityNode.equals(entityNodeId) && funcPermTree) continue;
                    lastEntityNode = entityNodeId;
                    entityNode = appNode.getTreeNode(entityNodeId);
                    if (entityNode == null) {
                        String entityName = entityNumNameMap.get(entityNum);
                        if (StringUtils.isEmpty((String)entityName)) {
                            entityName = entityNum;
                            entityNum = "NotFound";
                        }
                        if (showNum) {
                            entityName = entityName + '(' + entityNum + ')';
                        }
                        entityNode = new TreeNode(appNodeId, entityNodeId, entityName);
                        appNode.addChild(entityNode);
                    }
                }
                if (!funcPermTree) continue;
                if (arr.length < 10) {
                    logger.debug("arr[]:" + Arrays.toString(arr));
                    continue;
                }
                String permItemId = arr[9];
                String permItemNodeId = "permitem#" + permItemId + '@' + (String)arr[6] + '|' + appId;
                Object permItemName = permItemIdNameMap.get(permItemId);
                Object permItemNumber = arr[8];
                if (StringUtils.isEmpty((String)permItemName)) {
                    permItemName = permItemNumber;
                } else if (showNum) {
                    permItemName = (String)permItemName + '(' + (String)permItemNumber + ')';
                }
                TreeNode permItemNode = new TreeNode(entityNodeId, permItemNodeId, (String)permItemName);
                entityNode.addChild(permItemNode);
            }
        }
    }

    public void createCloudNodes(TreeNode rootNode, Map<String, Map<String, List<String>>> dataResource, boolean showNum) {
        if (!CollectionUtils.isEmpty(dataResource)) {
            Map<String, String> cloudNameMap = this.getCloudNameMap();
            Map<String, String> cloudNumberMap = this.getCloudNumberMap();
            List<String> cloudInfos = dataResource.get("root#").get("-1");
            for (String cloudInfo : cloudInfos) {
                int index;
                String cloudId = cloudInfo.substring((index = cloudInfo.lastIndexOf(35)) + 1);
                if ("2HGKCE94QELW".equals(cloudId)) continue;
                String cloudName = cloudNameMap.get(cloudId);
                String cloudNumber = cloudNumberMap.get(cloudId);
                if (StringUtils.isEmpty((String)cloudName)) {
                    cloudName = cloudNumber;
                } else if (showNum) {
                    cloudName = cloudName + '(' + cloudNumber + ')';
                }
                TreeNode cloudNode = new TreeNode("-1", cloudInfo, cloudName, true);
                rootNode.addChild(cloudNode);
            }
        }
    }

    public void commonAddNode(TreeView tv, String nodeId, Map<String, Map<String, List<String>>> dataResource, boolean showNum) {
        List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
        ArrayList<TreeNode> nodes = null;
        boolean checkFlag = checkedNodeIds.contains(nodeId);
        if (nodeId.startsWith("cloud#")) {
            Map<String, String> appNumberMap = this.getAppNumberMap();
            Map allAppInfo = AppMetadataCache.getAllAppInfo();
            List<String> appInfos = dataResource.get("cloud#").get(nodeId);
            nodes = new ArrayList<TreeNode>(appInfos.size());
            for (String appInfo : appInfos) {
                int n;
                String appId = appInfo.substring((n = appInfo.lastIndexOf(35)) + 1);
                if ("2HGKTA7HH43C".equals(appId)) continue;
                String appName = "";
                String orgnlAppNum = appNumberMap.get(appId);
                AppInfo tempAppInfo = (AppInfo)allAppInfo.get(orgnlAppNum);
                if (tempAppInfo != null) {
                    appName = tempAppInfo.getName().getLocaleValue();
                    String appNumber = tempAppInfo.getNumber();
                    if (StringUtils.isEmpty((String)appName)) {
                        appName = appNumber;
                    } else if (showNum) {
                        appName = appName + '(' + appNumber + ')';
                    }
                } else {
                    appName = appId;
                }
                TreeNode appNode = new TreeNode(nodeId, appInfo, appName, true);
                appNode.setCheckable(checkFlag);
                nodes.add(appNode);
            }
            Map focusNode = tv.getTreeState().getFocusNode();
            if (!CollectionUtils.isEmpty((Map)focusNode) && showNum) {
                int index;
                String string;
                String cloudId;
                Map<String, String> cloudNumberMap = this.getCloudNumberMap();
                String cloudNum = cloudNumberMap.get(cloudId = (string = (String)focusNode.get("id")).substring((index = string.lastIndexOf(35)) + 1));
                if (StringUtils.isEmpty((String)cloudNum)) {
                    cloudNum = "NotFound";
                }
                String text = (String)focusNode.get("text");
                text = text + '(' + cloudNum + ')';
                tv.updateNode(new TreeNode("-1", string, text, true));
            }
            tv.addNodes(nodes);
        } else if (nodeId.startsWith("app#")) {
            String key = tv.getKey();
            boolean isParent = "tree_allfunctionperm".equals(key) || "tree_funcperm".equals(key) || "tree_disfunperm".equals(key);
            List<String> entityInfos = dataResource.get("app#").get(nodeId);
            nodes = new ArrayList(entityInfos.size());
            HashSet<String> entityNums = new HashSet<String>(8);
            for (String string : entityInfos) {
                int startIndex = string.lastIndexOf(35);
                int endIndex = string.lastIndexOf(64);
                String entityNum = string.substring(startIndex + 1, endIndex);
                entityNums.add(entityNum);
            }
            Map entInfoMap = FormHelper.getEntMap(entityNums, (String)"number");
            for (String strEntityInfo : entityInfos) {
                int startIndex = strEntityInfo.lastIndexOf(35);
                int endIndex = strEntityInfo.lastIndexOf(64);
                String entityNum = strEntityInfo.substring(startIndex + 1, endIndex);
                Set entitySet = (Set)entInfoMap.get(entityNum);
                String entityName = "";
                if (entitySet != null && !entitySet.isEmpty()) {
                    Entity[] entityInfoArr = entitySet.toArray(new Entity[0]);
                    Entity entityInfo = entityInfoArr[0];
                    entityName = entityInfo.getEntityName();
                }
                if (StringUtils.isEmpty((String)entityName)) {
                    entityName = entityNum;
                } else if (showNum) {
                    entityName = entityName + '(' + entityNum + ')';
                }
                TreeNode entityNode = new TreeNode(nodeId, strEntityInfo, entityName, isParent);
                entityNode.setCheckable(checkFlag);
                nodes.add(entityNode);
            }
            tv.addNodes(nodes);
        } else if (nodeId.startsWith("entity#")) {
            String key = tv.getKey();
            boolean allFuncPermTree = "tree_allfunctionperm".equals(key);
            Map<String, String> allPermNodeInfoMap = this.getAllPermNodeInfoMap();
            Map<String, String> entityAssignablePermItemMap = this.getEntityAssignablePermItemMap();
            Map<String, String> permItemIdNameMap = this.getPermItemIdNameMap();
            Map<String, String> map = this.getPermItemIdNumberMap();
            List<String> permItemNodeInfoList = this.getEntityPermItemNodeInfo(allFuncPermTree, dataResource, allPermNodeInfoMap, map, entityAssignablePermItemMap, Lists.newArrayList((Object[])new String[]{nodeId}));
            nodes = new ArrayList(permItemNodeInfoList.size());
            for (String permItemNodeInfo : permItemNodeInfoList) {
                Object[] arr = permItemNodeInfo.split("    ");
                String appId = arr[5];
                String entityNum = arr[6];
                if (arr.length < 10) {
                    logger.debug("arr[]:" + Arrays.toString(arr));
                    continue;
                }
                String permItemId = arr[9];
                String permItemName = permItemIdNameMap.get(permItemId);
                if (showNum) {
                    Object permItemNumber = arr[8];
                    if (StringUtils.isEmpty((String)permItemNumber)) {
                        permItemNumber = "NotFound";
                    }
                    permItemName = permItemName + '(' + (String)permItemNumber + ')';
                }
                String permItemKey = "permitem#" + permItemId + "@" + entityNum + "|" + appId;
                TreeNode permItemNode = new TreeNode(nodeId, permItemKey, permItemName, false);
                permItemNode.setCheckable(checkFlag);
                nodes.add(permItemNode);
            }
        }
        tv.addNodes(nodes);
        if (checkFlag) {
            tv.checkNodes(nodes);
        }
    }

    public List<String> getEntityPermItemNodeInfo(boolean allFuncPermTree, Map<String, Map<String, List<String>>> dataResource, Map<String, String> allEntityInfoMap, Map<String, String> permItemIdNumberMap, Map<String, String> entityAssignablePermItemMap, List<String> checkedNodeIds) {
        if (allFuncPermTree) {
            return this.getAllFuncPermTreeEntityPermItemNodeInfo(checkedNodeIds, entityAssignablePermItemMap, allEntityInfoMap, permItemIdNumberMap);
        }
        Map<String, List<String>> entityPermItemMap = dataResource.get("entity#");
        ArrayList<String> permItemNodeKeys = new ArrayList<String>(100);
        for (String checkedNodeId : checkedNodeIds) {
            permItemNodeKeys.addAll((Collection<String>)entityPermItemMap.get(checkedNodeId));
        }
        return this.getPermItemNodeInfo(allFuncPermTree, dataResource, permItemNodeKeys, allEntityInfoMap, permItemIdNumberMap);
    }

    private List<String> getAllFuncPermTreeEntityPermItemNodeInfo(List<String> entityNodeIds, Map<String, String> entityAssignablePermItemMap, Map<String, String> allEntityInfoMap, Map<String, String> permItemIdNumberMap) {
        ArrayList<String> result = new ArrayList<String>(100);
        for (String entityNodeId : entityNodeIds) {
            String[] permItemArr;
            String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"entity#", (String)entityNodeId);
            String appId = nodeInfoArr[0];
            String entityNum = nodeInfoArr[1];
            String entityPermInfo = allEntityInfoMap.get(appId + "|" + entityNum);
            if (StringUtils.isEmpty((String)entityPermInfo)) continue;
            for (String permItemId : permItemArr = entityAssignablePermItemMap.get(entityNum).split(",")) {
                if (StringUtils.isEmpty((String)permItemId)) continue;
                String permItemNum = permItemIdNumberMap.get(permItemId);
                result.add(String.join((CharSequence)"    ", entityPermInfo, permItemNum, permItemId));
            }
        }
        return result;
    }

    private List<String> getPermItemNodeInfo(List<String> permItemNodeKeys, Map<String, String> allEntityInfoMap, Map<String, String> permItemIdNumberMap) {
        return this.getPermItemNodeInfo(true, null, permItemNodeKeys, allEntityInfoMap, permItemIdNumberMap);
    }

    private List<String> getPermItemNodeInfo(boolean allFuncPermTree, Map<String, Map<String, List<String>>> dataResource, List<String> permItemNodeKeys, Map<String, String> allEntityInfoMap, Map<String, String> permItemIdNumberMap) {
        ArrayList<String> result = new ArrayList<String>(permItemNodeKeys.size());
        for (String permItemNodeKey : permItemNodeKeys) {
            String entityNodeKey;
            List<String> permItemNodeInfoList;
            Map<String, List<String>> entityMap;
            String[] nodeInfoArr = PermCommonUtil.getPermInfoFromNodeId((String)"permitem#", (String)permItemNodeKey);
            String appId = nodeInfoArr[0];
            String entityNum = nodeInfoArr[1];
            String permItemId = nodeInfoArr[2];
            if (StringUtils.isEmpty((String)permItemId)) continue;
            String entityPermInfo = null;
            if (allFuncPermTree ? StringUtils.isEmpty((String)(entityPermInfo = allEntityInfoMap.get(appId + "|" + entityNum))) : StringUtils.isEmpty((String)(entityPermInfo = allEntityInfoMap.get(appId + "|" + entityNum))) && StringUtils.isEmpty((String)(entityPermInfo = FuncPermTreeUtil.getEntityPermInfo(appId, entityNum))) || (entityMap = dataResource.get("entity#")) == null || (permItemNodeInfoList = entityMap.get(entityNodeKey = "entity#" + entityNum + "@" + appId)) == null) continue;
            String permItemNum = permItemIdNumberMap.get(permItemId);
            result.add(String.join((CharSequence)"    ", entityPermInfo, permItemNum, permItemId));
        }
        return result;
    }

    private static String getEntityPermInfo(String appId, String entityNum) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("SELECT app.fnumber appnum, app.fseq appseq, cloud.fid cloudid, cloud.fnumber cloudnum, cloud.fseq cloudseq ").append("FROM t_meta_bizapp app ").append("LEFT JOIN t_meta_bizcloud cloud ON (cloud.fid = app.fbizcloudid) ").append("WHERE app.fid = ? ");
        String cloudAppInfo = (String)DB.query((DBRoute)DBRoute.meta, (String)querySql.toString(), (Object[])new Object[]{appId}, rs -> {
            if (rs.next()) {
                String cloudSeq = rs.getString("cloudseq");
                String cloudId = rs.getString("cloudid");
                String cloudNum = rs.getString("cloudnum");
                String appSeq = rs.getString("appseq");
                String appNum = rs.getString("appnum");
                if (StringUtils.isEmpty((String)cloudSeq) || StringUtils.isEmpty((String)cloudId) || StringUtils.isEmpty((String)cloudNum) || StringUtils.isEmpty((String)appSeq) || StringUtils.isEmpty((String)appNum)) {
                    return "";
                }
                return String.join((CharSequence)"    ", cloudSeq, cloudNum, cloudId, appSeq, appNum, appId);
            }
            return "";
        });
        if (StringUtils.isEmpty((String)cloudAppInfo)) {
            return "";
        }
        querySql.setLength(0);
        querySql.append("SELECT entl.fname ").append("FROM t_meta_entitydesign ent ").append("LEFT JOIN t_meta_entitydesign_l entl ON (entl.fid = ent.fid AND entl.flocaleid = ?) ").append("WHERE ent.fnumber = ? ");
        String entityName = (String)DB.query((DBRoute)DBRoute.meta, (String)querySql.toString(), (Object[])new Object[]{RequestContext.get().getLang().name(), entityNum}, rs -> {
            if (rs.next()) {
                return rs.getString("fname");
            }
            return "";
        });
        if (StringUtils.isEmpty((String)entityName)) {
            return "";
        }
        return String.join((CharSequence)"    ", cloudAppInfo, entityNum, entityName);
    }

    public Set<String> getRealSelectedNode(boolean allFuncPermTree, Map<String, Map<String, List<String>>> dataResource, List<String> checkedNodeIds, Map<String, String> allEntityInfoMap) {
        Map<String, String> permItemIdNumberMap = this.getPermItemIdNumberMap();
        Map<String, String> entityAssignablePermItemMap = this.getEntityAssignablePermItemMap();
        HashSet<String> selectedPermNode = new HashSet<String>(100);
        for (String checkedNodeId : checkedNodeIds) {
            List<String> permItemNodeInfo;
            if (checkedNodeId.startsWith("permitem#")) {
                permItemNodeInfo = this.getPermItemNodeInfo(Lists.newArrayList((Object[])new String[]{checkedNodeId}), allEntityInfoMap, permItemIdNumberMap);
                selectedPermNode.addAll(permItemNodeInfo);
                continue;
            }
            if (checkedNodeId.startsWith("entity#")) {
                permItemNodeInfo = this.getEntityPermItemNodeInfo(allFuncPermTree, dataResource, allEntityInfoMap, permItemIdNumberMap, entityAssignablePermItemMap, Lists.newArrayList((Object[])new String[]{checkedNodeId}));
                selectedPermNode.addAll(permItemNodeInfo);
                continue;
            }
            if (checkedNodeId.startsWith("app#")) {
                List<String> entityList = dataResource.get("app#").get(checkedNodeId);
                List<String> permItemNodeInfo2 = this.getEntityPermItemNodeInfo(allFuncPermTree, dataResource, allEntityInfoMap, permItemIdNumberMap, entityAssignablePermItemMap, entityList);
                selectedPermNode.addAll(permItemNodeInfo2);
                continue;
            }
            if (!checkedNodeId.startsWith("cloud#")) continue;
            List<String> appList = dataResource.get("cloud#").get(checkedNodeId);
            for (String app : appList) {
                List<String> entityList = dataResource.get("app#").get(app);
                List<String> permItemNodeInfo3 = this.getEntityPermItemNodeInfo(allFuncPermTree, dataResource, allEntityInfoMap, permItemIdNumberMap, entityAssignablePermItemMap, entityList);
                selectedPermNode.addAll(permItemNodeInfo3);
            }
        }
        return selectedPermNode;
    }

    public void processData(boolean allFuncPermTree, Map<String, Map<String, List<String>>> dataResource, List<String> dataBeanInfos) {
        LinkedHashSet<String> cloudSet = new LinkedHashSet<String>(16);
        HashMap rootCloudMap = new HashMap(16);
        HashMap<String, LinkedHashSet> cloudAppMap = new HashMap<String, LinkedHashSet>(16);
        LinkedHashMap<String, LinkedHashSet> appEntityMap = new LinkedHashMap<String, LinkedHashSet>(16);
        HashMap<String, LinkedHashSet> entityPermItemMap = new HashMap<String, LinkedHashSet>(16);
        for (String permInfo : dataBeanInfos) {
            Object[] arr = permInfo.split("    ");
            String cloudKey = "cloud#" + arr[2];
            String appId = arr[5];
            String appKey = "app#" + appId;
            String entityNum = arr[6];
            String entityKey = "entity#" + entityNum + "@" + appId;
            cloudSet.add(cloudKey);
            cloudAppMap.computeIfAbsent(cloudKey, k -> new LinkedHashSet()).add(appKey);
            if (allFuncPermTree) {
                appEntityMap.computeIfAbsent(appKey, k -> new LinkedHashSet(10)).add(entityKey);
                continue;
            }
            appEntityMap.computeIfAbsent(appKey, k -> new LinkedHashSet(10)).add(entityKey);
            if (arr.length < 10) {
                logger.debug("arr[]:" + Arrays.toString(arr));
                continue;
            }
            String permItemId = arr[9];
            String permItemKey = "permitem#" + permItemId + "@" + entityNum + "|" + appId;
            entityPermItemMap.computeIfAbsent(entityKey, k -> new LinkedHashSet()).add(permItemKey);
        }
        rootCloudMap.put("-1", new ArrayList(cloudSet));
        dataResource.put("root#", rootCloudMap);
        HashMap cloudAppMap_ = new HashMap(16);
        LinkedHashMap appEntityMap_ = new LinkedHashMap(16);
        HashMap entityPermItemMap_ = new HashMap(16);
        for (Map.Entry cloudApp : cloudAppMap.entrySet()) {
            cloudAppMap_.put(cloudApp.getKey(), new ArrayList((Collection)cloudApp.getValue()));
        }
        for (Map.Entry appEntity : appEntityMap.entrySet()) {
            appEntityMap_.put(appEntity.getKey(), new ArrayList((Collection)appEntity.getValue()));
        }
        for (Map.Entry entityPermItem : entityPermItemMap.entrySet()) {
            entityPermItemMap_.put(entityPermItem.getKey(), new ArrayList((Collection)entityPermItem.getValue()));
        }
        dataResource.put("cloud#", cloudAppMap_);
        dataResource.put("app#", appEntityMap_);
        if (!allFuncPermTree) {
            dataResource.put("entity#", entityPermItemMap_);
        }
    }

    public Map<String, String> getCloudNameMap() {
        Map cloudNameMap;
        String cloudNameMapStr = this.pageCache.getBigObject("cloudNameMap");
        if (StringUtils.isNotEmpty((String)cloudNameMapStr)) {
            cloudNameMap = (Map)SerializationUtils.fromJsonString((String)cloudNameMapStr, Map.class);
        } else {
            cloudNameMap = CloudHelper.getAllCloudIdNameMap();
            this.pageCache.putBigObject("cloudNameMap", SerializationUtils.toJsonString((Object)cloudNameMap));
        }
        return cloudNameMap;
    }

    public Map<String, String> getCloudNumberMap() {
        Map cloudNumberMap;
        String cloudNumberMapStr = this.pageCache.getBigObject("cloudNumberMap");
        if (StringUtils.isNotEmpty((String)cloudNumberMapStr)) {
            cloudNumberMap = (Map)SerializationUtils.fromJsonString((String)cloudNumberMapStr, Map.class);
        } else {
            cloudNumberMap = CloudHelper.getCloudIdAndNum();
            this.pageCache.putBigObject("cloudNumberMap", SerializationUtils.toJsonString((Object)cloudNumberMap));
        }
        return cloudNumberMap;
    }

    public Map<String, String> getAppNameMap() {
        Map appNameMap;
        String appNameMapStr = this.pageCache.getBigObject("appNameMap");
        if (StringUtils.isNotEmpty((String)appNameMapStr)) {
            appNameMap = (Map)SerializationUtils.fromJsonString((String)appNameMapStr, Map.class);
        } else {
            appNameMap = AppHelper.getAllAppIdNameMap();
            this.pageCache.putBigObject("appNameMap", SerializationUtils.toJsonString((Object)appNameMap));
        }
        return appNameMap;
    }

    public Map<String, String> getAppNumberMap() {
        Map appNumberMap;
        String appNumberMapStr = this.pageCache.getBigObject("appNumberMap");
        if (StringUtils.isNotEmpty((String)appNumberMapStr)) {
            appNumberMap = (Map)SerializationUtils.fromJsonString((String)appNumberMapStr, Map.class);
        } else {
            appNumberMap = AppHelper.getAllAppIdNumberMap();
            this.pageCache.putBigObject("appNumberMap", SerializationUtils.toJsonString((Object)appNumberMap));
        }
        return appNumberMap;
    }

    public Map<String, String> getEntityNumNameMap() {
        Map entityNumNameMap;
        String entityNumNameMapStr = this.pageCache.getBigObject("entityNumNameMap");
        if (StringUtils.isNotEmpty((String)entityNumNameMapStr)) {
            entityNumNameMap = (Map)SerializationUtils.fromJsonString((String)entityNumNameMapStr, Map.class);
        } else {
            entityNumNameMap = PermCommonUtil.getAllEntNumAndNameMap();
            this.putEntityNumNameMap(entityNumNameMap);
        }
        return entityNumNameMap;
    }

    public void putEntityNumNameMap(Map<String, String> entityNumNameMap) {
        this.pageCache.putBigObject("entityNumNameMap", SerializationUtils.toJsonString(entityNumNameMap));
    }

    public Map<String, String> getPermItemIdNameMap() {
        Map permItemIdNameMap;
        String permItemIdNameMapStr = this.pageCache.getBigObject("permItemIdNameMap");
        if (StringUtils.isNotEmpty((String)permItemIdNameMapStr)) {
            permItemIdNameMap = (Map)SerializationUtils.fromJsonString((String)permItemIdNameMapStr, Map.class);
        } else {
            permItemIdNameMap = PermItemHelper.getAllPermItemIdNameMap();
            this.pageCache.putBigObject("permItemIdNameMap", SerializationUtils.toJsonString((Object)permItemIdNameMap));
        }
        return permItemIdNameMap;
    }

    public Map<String, String> getPermItemIdNumberMap() {
        Map permItemIdNumberMap;
        String permItemIdNumberMapStr = this.pageCache.getBigObject("permItemIdNumberMap");
        if (StringUtils.isNotEmpty((String)permItemIdNumberMapStr)) {
            permItemIdNumberMap = (Map)SerializationUtils.fromJsonString((String)permItemIdNumberMapStr, Map.class);
        } else {
            permItemIdNumberMap = PermItemHelper.getAllPermItemIdNumberMap();
            this.pageCache.putBigObject("permItemIdNumberMap", SerializationUtils.toJsonString((Object)permItemIdNumberMap));
        }
        return permItemIdNumberMap;
    }

    public Map<String, Map<String, String>> getEntityFieldNameMap() {
        HashMap<String, Map<String, String>> entityFieldNameMap;
        String entityFieldNameMapStr = this.pageCache.getBigObject("entityFieldNameMap");
        if (StringUtils.isNotEmpty((String)entityFieldNameMapStr)) {
            entityFieldNameMap = (HashMap<String, Map<String, String>>)SerializationUtils.fromJsonString((String)entityFieldNameMapStr, Map.class);
        } else {
            entityFieldNameMap = new HashMap<String, Map<String, String>>(16);
            this.pageCache.putBigObject("entityFieldNameMap", SerializationUtils.toJsonString(entityFieldNameMap));
        }
        return entityFieldNameMap;
    }

    public Map<String, String> getEntityAssignablePermItemMap() {
        HashMap<String, String> entityAssignablePermItemMap;
        String entityAssignablePermItemMapStr = this.pageCache.getBigObject(PGCACHE_ENTITY_ASSIGNABLE_PERMITEM_MAP);
        if (StringUtils.isNotEmpty((String)entityAssignablePermItemMapStr)) {
            entityAssignablePermItemMap = (HashMap<String, String>)SerializationUtils.fromJsonString((String)entityAssignablePermItemMapStr, Map.class);
        } else {
            entityAssignablePermItemMap = new HashMap<String, String>(16);
            this.putEntityAssignablePermItemMap(entityAssignablePermItemMap);
        }
        return entityAssignablePermItemMap;
    }

    public void putEntityAssignablePermItemMap(Map<String, String> entityAssignablePermItemMap) {
        this.pageCache.putBigObject(PGCACHE_ENTITY_ASSIGNABLE_PERMITEM_MAP, SerializationUtils.toJsonString(entityAssignablePermItemMap));
    }

    public Map<String, String> getAllPermNodeInfoMap() {
        LinkedHashMap<String, String> allPermNodeInfoMap;
        String allPermNodeInfoMapStr = this.pageCache.getBigObject("allPermNodeInfoMap");
        if (StringUtils.isNotEmpty((String)allPermNodeInfoMapStr)) {
            allPermNodeInfoMap = (LinkedHashMap<String, String>)SerializationUtils.fromJsonString((String)allPermNodeInfoMapStr, Map.class);
        } else {
            allPermNodeInfoMap = new LinkedHashMap<String, String>(16);
            this.putAllPermNodeInfoMap(allPermNodeInfoMap);
        }
        return allPermNodeInfoMap;
    }

    public void putAllPermNodeInfoMap(Map<String, String> allPermNodeInfoMap) {
        this.pageCache.putBigObject("allPermNodeInfoMap", SerializationUtils.toJsonString(allPermNodeInfoMap));
    }

    public Map<String, String> getAllEntityInfoMap() {
        HashMap<String, String> allEntityInfoMap;
        String allEntityInfoMapStr = this.pageCache.getBigObject("allEntityInfoMap");
        if (StringUtils.isNotEmpty((String)allEntityInfoMapStr)) {
            allEntityInfoMap = (HashMap<String, String>)SerializationUtils.fromJsonString((String)allEntityInfoMapStr, Map.class);
        } else {
            allEntityInfoMap = new HashMap<String, String>(16);
            this.putAllEntityInfoMap(allEntityInfoMap);
        }
        return allEntityInfoMap;
    }

    public void putAllEntityInfoMap(Map<String, String> allEntityInfoMap) {
        this.pageCache.putBigObject("allEntityInfoMap", SerializationUtils.toJsonString(allEntityInfoMap));
    }

    private Set<String> getMatchUserTypeAppIds() {
        StringBuilder sbAppRuntimeSql = new StringBuilder().append("select app.fid app_id ").append(" from t_meta_appruntime app where app.fdeploystatus = '2' ");
        String appNumForUser = null == this.pageCache || StringUtils.isEmpty((String)this.pageCache.get("FormShowParam_appNum")) ? null : this.pageCache.get("FormShowParam_appNum");
        this.appendUserTypeFilter(appNumForUser, sbAppRuntimeSql);
        String algoKeyPrefix = this.getClass().getName();
        HashSet<String> matchUserTypeAppIds = new HashSet<String>(8);
        try (DataSet appRuntimeDS = DB.queryDataSet((String)(algoKeyPrefix + "getMatchUserTypeAppIds"), (DBRoute)DBRoute.meta, (String)sbAppRuntimeSql.toString(), null);){
            while (appRuntimeDS.hasNext()) {
                Row row = appRuntimeDS.next();
                String matchAppId = row.getString("app_id");
                if (StringUtils.isEmpty((String)matchAppId)) continue;
                matchUserTypeAppIds.add(matchAppId);
            }
        }
        return matchUserTypeAppIds;
    }
}

