/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.CloudHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.model.permbase.App;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class OpRuleLeftTreeUtil
implements TreeNodeQueryListener {
    private static final String BIZ_UNIT_REL_FORM_DS = "bizUnitRelFormDS";
    private static final String BIZ_OBJ_APP_DS = "bizObjAppDS";
    private static final String ENTITY_DESIGN_DS = "entityDesignDS";
    private static final String ENT_DS = "entDS";
    private static final String CLOUD_APP_DS = "cloudAppDS";
    private static final String FIELD_ENTAPP_ENTNUM = "entapp_entnum";
    private static final String FIELD_ENT_NUM = "ent_num";
    private static final String FIELD_ENTAPP_APPID = "entapp_appid";
    private static final String FIELD_ENT_ID = "ent_id";
    private static final String FIELD_BURF_FORMID = "burf_formid";
    private static final String FIELD_ENTD_ID = "entd_id";
    private static final String FIELD_ENTD_NUM = "entd_num";
    private static final String FIELD_BURF_APPID = "burf_appid";
    private static final String FIELD_APP_ID = "app_id";
    private static final String FIELD_CLOUDL_ID = "cloudl_id";
    private static final String FIELD_CLOUDL_NAME = "cloudl_name";
    private static final String FIELD_APP_NAME = "app_name";
    private static final String FIELD_ENTDL_NAME = "entdl_name";
    private static final String PAGECACHE_ENTITYNAMEMAP = "pagecache_entitynamemap_";
    private static Log logger = LogFactory.getLog(OpRuleLeftTreeUtil.class);
    public static final String ROOTNODE_ID = "root#FIRST";
    private TreeView treeView = null;
    private IPageCache pageCache = null;

    public static String getROOTNODE_NAME() {
        return ResManager.loadKDString((String)"\u5168\u90e8", (String)"OpRuleLeftTreeUtil_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    public OpRuleLeftTreeUtil(TreeView treeView) {
        this.treeView = treeView;
        this.pageCache = (IPageCache)treeView.getView().getService(IPageCache.class);
    }

    public void initListener() {
        this.treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public TreeNode createRootNode() {
        TreeNode rootNode = new TreeNode("", ROOTNODE_ID, OpRuleLeftTreeUtil.getROOTNODE_NAME(), true);
        return rootNode;
    }

    public TreeNode initTree(boolean ifShow, boolean isShowNum) {
        TreeNode rootNode = this.createRootNode();
        rootNode.setIsOpened(true);
        this.pageCache.put("pgCache_isShowNum", isShowNum + "");
        this.addCloudNode(rootNode, null, ifShow);
        return rootNode;
    }

    private void appendAppFilter(StringBuilder sb) {
        HashSet<String> disabledAppIds;
        List<String> appIdsBlackListFromStd;
        String appIdBlackList;
        List filterAppIds;
        IPageCache pageCache = (IPageCache)this.treeView.getView().getService(IPageCache.class);
        String filterAppIdRangeCache = pageCache.get("pageCache_adminChargeApp");
        if (StringUtils.isNotEmpty((String)filterAppIdRangeCache) && (filterAppIds = (List)SerializationUtils.fromJsonString((String)filterAppIdRangeCache, List.class)) != null && !filterAppIds.isEmpty()) {
            sb.append(" and app.fid in(");
            for (int i = 0; i < filterAppIds.size(); ++i) {
                String filterAppId = (String)filterAppIds.get(i);
                sb.append('\'').append(filterAppId).append('\'');
                if (i == filterAppIds.size() - 1) continue;
                sb.append(',');
            }
            sb.append(") ");
        }
        if (StringUtils.isNotEmpty((String)(appIdBlackList = RunModeServiceHelper.getAppIdFromBlacklist()))) {
            sb.append(" and app.fid not in (").append(appIdBlackList).append(')');
        }
        if (!CollectionUtils.isEmpty(appIdsBlackListFromStd = PermFormCommonUtil.getAppIdsFromStdBlackList())) {
            for (int i = 0; i < appIdsBlackListFromStd.size(); ++i) {
                appIdsBlackListFromStd.set(i, "'" + appIdsBlackListFromStd.get(i) + "'");
            }
            String appIds = String.join((CharSequence)",", appIdsBlackListFromStd);
            if (StringUtils.isNotEmpty((String)appIds)) {
                sb.append(" and app.fid not in (").append(appIds).append(')');
            }
        }
        if ((disabledAppIds = ManageServiceHelper.getDisabledAppIds()) == null) {
            disabledAppIds = new HashSet<String>(10);
        }
        disabledAppIds.add("2HGKTA7HH43C");
        String disabledAppIdsStr = String.join((CharSequence)"','", disabledAppIds);
        sb.append(" and app.fid not in ('").append(disabledAppIdsStr).append("')");
    }

    private List<String> getAdminChargeAppIds() {
        List filterAppIds = null;
        IPageCache pageCache = (IPageCache)this.treeView.getView().getService(IPageCache.class);
        String filterAppIdRangeCache = pageCache.get("pageCache_adminChargeApp");
        if (StringUtils.isNotEmpty((String)filterAppIdRangeCache)) {
            filterAppIds = (List)SerializationUtils.fromJsonString((String)filterAppIdRangeCache, List.class);
        }
        List allUserAppIds = PermCommonUtil.getAllUserAppIds();
        if (filterAppIds != null) {
            filterAppIds.addAll(allUserAppIds);
        }
        return filterAppIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloudNode(TreeNode rootNode, String nodeId, boolean ifShow) {
        String langStr = RequestContext.get().getLang().name();
        boolean isChineseLocale = "zh_CN".equals(langStr);
        String algoKeyPrefix = this.getClass().getName() + ".addCloudNode.";
        boolean isShowNum = false;
        String pgCache_isShowNum = this.pageCache.get("pgCache_isShowNum");
        if (StringUtils.isNotEmpty((String)pgCache_isShowNum)) {
            isShowNum = Boolean.parseBoolean(pgCache_isShowNum);
        }
        DataSet bizUnitRelFormDS = null;
        DataSet bizObjAppDS = null;
        DataSet entityDesignDS = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet appEntDS = null;
        DataSet entDS = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        DataSet finalDS = null;
        try {
            bizUnitRelFormDS = DB.queryDataSet((String)(algoKeyPrefix + BIZ_UNIT_REL_FORM_DS), (DBRoute)DBRoute.meta, (String)"SELECT fbizappid burf_appid, fformid burf_formid FROM t_meta_bizunitrelform");
            bizObjAppDS = DB.queryDataSet((String)(algoKeyPrefix + BIZ_OBJ_APP_DS), (DBRoute)DBRoute.permission, (String)"SELECT fbizappid entapp_appid, fbizobjid entapp_entnum FROM t_perm_bizobjapp");
            entityDesignDS = DB.queryDataSet((String)(algoKeyPrefix + ENTITY_DESIGN_DS), (DBRoute)DBRoute.meta, (String)"select fid ent_id, fnumber ent_num from t_meta_entitydesign");
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on(FIELD_ENTAPP_ENTNUM, FIELD_ENT_NUM).select(new String[]{FIELD_ENTAPP_APPID, FIELD_ENT_ID}).finish();
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS);
            entDS = DB.queryDataSet((String)(algoKeyPrefix + ENT_DS), (DBRoute)DBRoute.meta, (String)"select entd.FID entd_id, entd.fnumber entd_num  from t_meta_entitydesign entd  where entd.FISTEMPLATE = '0'  and entd.fmodeltype in('BillFormModel', 'BaseFormModel','LogBillFormModel') ");
            appEntPermItemDS2 = appEntDS.join(entDS).on(FIELD_BURF_FORMID, FIELD_ENTD_ID).select(new String[]{FIELD_BURF_APPID}, new String[]{FIELD_ENTD_NUM}).finish();
            StringBuilder sb = new StringBuilder().append("SELECT cloud.fid cloudl_id, ");
            if (isChineseLocale) {
                sb.append(" cloudl.fname cloudl_name, ");
            } else {
                sb.append(" case when cloudl.fname is null or cloudl.fname = '' or cloudl.fname = ' ' ").append(" then cloudl2.fname ").append(" else cloudl.fname ").append("end cloudl_name, ");
            }
            sb.append(" cloud.fseq cloud_seq,cloud.fnumber cloud_num,").append(" app.FID app_id ").append(" FROM t_meta_bizapp app ").append(" INNER JOIN t_meta_bizcloud cloud ON (cloud.FID = app.FBIZCLOUDID) ").append(" LEFT JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = cloud.FID AND cloudl.FLOCALEID = ?) ");
            if (!isChineseLocale) {
                sb.append(" LEFT JOIN t_meta_bizcloud_l cloudl2 ON (cloudl2.FID = cloud.FID AND cloudl2.FLOCALEID = 'zh_CN') ");
            }
            sb.append(" WHERE app.fdeploystatus = '2' ");
            if (StringUtils.isNotEmpty((String)nodeId)) {
                sb.append(" and cloud.fid = '").append(nodeId).append("' ");
            }
            this.appendCloudFilter(sb);
            this.appendAppFilter(sb);
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{langStr});
            finalDS = appEntPermItemDS2.join(cloudAppDS).on(FIELD_BURF_APPID, FIELD_APP_ID).select(new String[]{FIELD_ENTD_NUM}, new String[]{FIELD_CLOUDL_ID, FIELD_CLOUDL_NAME, "cloud_seq", "cloud_num"}).finish().orderBy(new String[]{"cloud_seq asc"});
            ArrayList<TreeNode> list = new ArrayList<TreeNode>(30);
            HashSet<String> cloudIds = new HashSet<String>(30);
            final HashMap<String, String> cloudSeqMap = new HashMap<String, String>(30);
            Map permControlType = PermCommonUtil.getPermControlType();
            while (finalDS.hasNext()) {
                String cloudId;
                Row row = finalDS.next();
                String entityNum = row.getString(FIELD_ENTD_NUM);
                PermissionControlType permissionControlType = (PermissionControlType)permControlType.get(entityNum);
                if (permissionControlType != null && permissionControlType.isForbidDataPerm() || cloudIds.contains(cloudId = row.getString(FIELD_CLOUDL_ID))) continue;
                cloudIds.add(cloudId);
                String id = cloudId + "#cloud";
                String name = row.getString(FIELD_CLOUDL_NAME);
                String cloudNum = row.getString("cloud_num");
                if (StringUtils.isEmpty((String)name)) {
                    name = cloudNum;
                } else if (isShowNum) {
                    name = name + "(" + cloudNum + ")";
                }
                String seq = row.getString("cloud_seq");
                TreeNode cloudNode = new TreeNode(ROOTNODE_ID, id, name, true);
                list.add(cloudNode);
                cloudSeqMap.put(id, seq);
            }
            this.addExtraCloudNode(ROOTNODE_ID, list, isShowNum);
            Collections.sort(list, new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode o1, TreeNode o2) {
                    String seq1 = (String)cloudSeqMap.get(o1.getId());
                    String seq2 = (String)cloudSeqMap.get(o2.getId());
                    if (StringUtils.isEmpty((String)seq1) || StringUtils.isEmpty((String)seq2)) {
                        return 0;
                    }
                    return Integer.valueOf(seq1).compareTo(Integer.valueOf(seq2));
                }
            });
            for (TreeNode cloudNode : list) {
                rootNode.addChild(cloudNode);
            }
            if (ifShow) {
                this.treeView.addNode(rootNode);
            }
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
    }

    private void addExtraCloudNode(String rootnodeId, List<TreeNode> list, boolean isShowNum) {
        Set disabledCloudIds;
        List<String> adminChargeAppIds = this.getAdminChargeAppIds();
        ArrayList<String> notInCloudIds = new ArrayList<String>(20);
        for (TreeNode node : list) {
            String nodeId = node.getId();
            String cloudId = nodeId.substring(0, nodeId.indexOf(35));
            notInCloudIds.add(cloudId);
        }
        if (notInCloudIds.size() == 0) {
            return;
        }
        List<String> cloudIdsBlackListFromStd = PermFormCommonUtil.getCloudIdsFromStdBlackList();
        if (!CollectionUtils.isEmpty(cloudIdsBlackListFromStd)) {
            notInCloudIds.addAll(cloudIdsBlackListFromStd);
        }
        if (null != (disabledCloudIds = ManageServiceHelper.getDisabledCloudIds()) && !disabledCloudIds.isEmpty()) {
            notInCloudIds.addAll(disabledCloudIds);
        }
        QFilter notInCloudFilter = new QFilter("id", "not in", notInCloudIds);
        QFilter[] filters = new QFilter[]{notInCloudFilter};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_devportal_bizcloud", (String)"id,name,number", (QFilter[])(filters = RunModeServiceHelper.getCloudIdBlacklistFilters((QFilter[])filters, (String)"id")));
        if (doc == null || doc.size() == 0) {
            return;
        }
        HashMap<String, String> extraCloudInfos = new HashMap<String, String>();
        for (DynamicObject dObj : doc) {
            String name = dObj.getString("name");
            if (isShowNum) {
                name = name + "(" + dObj.getString("number") + ")";
            }
            extraCloudInfos.put(dObj.getString("id"), name);
        }
        QFilter cloudIdFilter = new QFilter("bizcloud", "in", extraCloudInfos.keySet());
        QFilter deployFilter = new QFilter("deploystatus", "=", (Object)"2");
        QFilter visibleFilter = new QFilter("visible", "=", (Object)"1");
        Map cloudAppIdSetMap = CloudHelper.getCloudAppIdSetMap((QFilter[])new QFilter[]{cloudIdFilter, deployFilter, visibleFilter});
        HashMap<String, String> extraAppInfos = new HashMap<String, String>();
        HashMap<String, String> appIdNumMap = new HashMap<String, String>(8);
        Map allAppMenus = AppMetadataCache.getAllAppMenus();
        block6: for (Map.Entry extraCloudInfo : extraCloudInfos.entrySet()) {
            String extraCloudId = (String)extraCloudInfo.getKey();
            String extraCloudName = (String)extraCloudInfo.getValue();
            Set appIdSet = (Set)cloudAppIdSetMap.get(extraCloudId);
            if (null == appIdSet || appIdSet.isEmpty()) continue;
            extraAppInfos.clear();
            for (App app : appIdSet) {
                String appId = app.getAppId();
                if (adminChargeAppIds != null && !adminChargeAppIds.contains(appId)) continue;
                String appName = app.getAppName();
                String appNumber = app.getAppNumber();
                if (isShowNum) {
                    appName = appName + "(" + appNumber + ")";
                }
                extraAppInfos.put(appId, appName);
                appIdNumMap.put(appId, appNumber);
            }
            for (Map.Entry entry : extraAppInfos.entrySet()) {
                List<String> properBillFormNums;
                String extraAppId = (String)entry.getKey();
                AppInfo appInfo = AppHelper.getMetaAppInfo((String)extraAppId);
                boolean allUserApp = appInfo.isAllUserApp();
                if (!allUserApp) continue;
                ArrayList<String> formNums = new ArrayList<String>();
                List appMenuInfos = null;
                try {
                    String appNum = (String)appIdNumMap.get(extraAppId);
                    if (StringUtils.isEmpty((String)appNum)) continue;
                    appMenuInfos = (List)allAppMenus.get(appNum);
                }
                catch (Exception e) {
                    logger.warn(String.format("\u8bfb\u53d6 %s\u7684\u5143\u6570\u636e\u4fe1\u606f\u65f6\u51fa\u9519", extraAppId));
                    continue;
                }
                if (null == appMenuInfos) continue;
                for (AppMenuInfo appMenuInfo : appMenuInfos) {
                    boolean needSkip;
                    String formId = appMenuInfo.getFormId();
                    String parameter = appMenuInfo.getParams();
                    String formNum = null;
                    if (StringUtils.isNotEmpty((String)formId)) {
                        formNum = formId;
                        formNums.add(formNum);
                    }
                    if (StringUtils.isNotEmpty((String)parameter)) {
                        JSONObject paramJsonObj = JSON.parseObject((String)parameter);
                        formNum = paramJsonObj.getString("formId");
                    }
                    if ((needSkip = StringUtils.isEmpty((String)formId)) || formNum != null) continue;
                    try {
                        MainEntityType met = EntityMetadataCache.getDataEntityTypeById((String)formId);
                        if (!(met instanceof BillEntityType)) continue;
                        formNum = met.getName();
                        formNums.add(formNum);
                    }
                    catch (Exception e) {
                        logger.warn(String.format("\u8bfb\u53d6 %s\u7684\u5143\u6570\u636e\u4fe1\u606f\u65f6\u51fa\u9519", formId));
                    }
                }
                if (formNums.size() == 0 || (properBillFormNums = this.properBillForm(formNums)) == null || properBillFormNums.size() == 0) continue;
                String id = extraCloudId + "#cloud";
                TreeNode newNode = new TreeNode(rootnodeId, id, extraCloudName, true);
                list.add(newNode);
                continue block6;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppNode(String parentNodeId, String nodeId) {
        String langStr = RequestContext.get().getLang().name();
        boolean isChineseLocale = "zh_CN".equals(langStr);
        boolean isShowNum = false;
        String pgCache_isShowNum = this.pageCache.get("pgCache_isShowNum");
        if (StringUtils.isNotEmpty((String)pgCache_isShowNum)) {
            isShowNum = Boolean.parseBoolean(pgCache_isShowNum);
        }
        String algoKeyPrefix = this.getClass().getName() + ".addAppNode.";
        DataSet bizUnitRelFormDS = null;
        DataSet bizObjAppDS = null;
        DataSet entityDesignDS = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet appEntDS = null;
        DataSet entDS = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        DataSet finalDS = null;
        try {
            bizUnitRelFormDS = DB.queryDataSet((String)(algoKeyPrefix + BIZ_UNIT_REL_FORM_DS), (DBRoute)DBRoute.meta, (String)"SELECT fbizappid burf_appid, fformid burf_formid FROM t_meta_bizunitrelform");
            bizObjAppDS = DB.queryDataSet((String)(algoKeyPrefix + BIZ_OBJ_APP_DS), (DBRoute)DBRoute.permission, (String)"SELECT fbizappid entapp_appid, fbizobjid entapp_entnum FROM t_perm_bizobjapp");
            entityDesignDS = DB.queryDataSet((String)(algoKeyPrefix + ENTITY_DESIGN_DS), (DBRoute)DBRoute.meta, (String)"select fid ent_id, fnumber ent_num from t_meta_entitydesign");
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on(FIELD_ENTAPP_ENTNUM, FIELD_ENT_NUM).select(new String[]{FIELD_ENTAPP_APPID, FIELD_ENT_ID}).finish();
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS);
            entDS = DB.queryDataSet((String)(algoKeyPrefix + ENT_DS), (DBRoute)DBRoute.meta, (String)"SELECT entd.FID entd_id, entd.fnumber entd_num  FROM t_meta_entitydesign entd  WHERE entd.FISTEMPLATE = '0'  AND entd.fmodeltype in('BillFormModel', 'BaseFormModel','LogBillFormModel') ");
            appEntPermItemDS2 = appEntDS.join(entDS).on(FIELD_BURF_FORMID, FIELD_ENTD_ID).select(new String[]{FIELD_BURF_APPID}, new String[]{FIELD_ENTD_NUM}).finish();
            StringBuilder sb = new StringBuilder().append("select app.fid app_id, app.fnumber app_num, appl.fname app_name, ");
            if (isChineseLocale) {
                sb.append("appl2.fname app_name2, ");
            } else {
                sb.append("case when appl2.fname is null or appl2.fname = '' or appl2.fname= ' ' ").append("then appl3.fname ").append("else appl2.fname ").append("end app_name2 , ");
            }
            sb.append("app.findustry app_industry, app.fseq app_seq ").append(" from t_meta_bizapp app ").append(" LEFT JOIN t_meta_bizapp_l appl ON (app.FID = appl.FID and appl.FLOCALEID = ?) ").append(" LEFT JOIN t_meta_appruntime_l appl2 ON  (app.FNUMBER = appl2.FAPPID and appl2.FLOCALEID = ?) ");
            if (!isChineseLocale) {
                sb.append(" LEFT JOIN t_meta_appruntime_l appl3 ON  (app.FNUMBER = appl3.FAPPID and appl3.FLOCALEID = 'zh_CN') ");
            }
            sb.append(" INNER JOIN t_meta_bizcloud cloud ON (cloud.FID = app.FBIZCLOUDID) ").append(" WHERE cloud.FID = ? ").append(" AND app.fdeploystatus = '2' ").append(" AND app.ftype <> '2'  ");
            Object[] params = new Object[]{langStr, langStr, parentNodeId};
            if (StringUtils.isNotEmpty((String)nodeId)) {
                sb.append(" and app.fid = ? ");
                params = new Object[]{langStr, langStr, parentNodeId, nodeId};
            }
            this.appendAppFilter(sb);
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])params);
            finalDS = appEntPermItemDS2.join(cloudAppDS).on(FIELD_BURF_APPID, FIELD_APP_ID).select(new String[]{FIELD_ENTD_NUM}, new String[]{FIELD_APP_ID, "app_num", FIELD_APP_NAME, "app_name2", "app_industry", "app_seq"}).finish().orderBy(new String[]{"app_seq asc"});
            ArrayList<TreeNode> resultList = new ArrayList<TreeNode>(20);
            HashSet<String> hasAddAppIds = new HashSet<String>(20);
            Map permControlType = PermCommonUtil.getPermControlType();
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                String appId = row.getString(FIELD_APP_ID);
                String entityNum = row.getString(FIELD_ENTD_NUM);
                PermissionControlType permissionControlType = (PermissionControlType)permControlType.get(entityNum);
                if (permissionControlType != null && permissionControlType.isForbidDataPerm() || !hasAddAppIds.add(appId)) continue;
                String id = appId + "#app";
                String name = row.getString("app_name2");
                String appNum = row.getString("app_num");
                if (StringUtils.isEmpty((String)name)) {
                    name = appNum;
                } else if (isShowNum) {
                    name = name + "(" + appNum + ")";
                }
                TreeNode appNode = new TreeNode(parentNodeId + "#cloud", id, name, true);
                resultList.add(appNode);
            }
            this.addExtraAppNode(parentNodeId, resultList, isShowNum);
            if (resultList.size() > 0) {
                resultList.sort(Comparator.comparing(TreeNode::getId));
                this.treeView.addNodes(resultList);
            }
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
    }

    private void addExtraAppNode(String cloudId, List<TreeNode> listNode, boolean isShowNum) {
        List<String> adminChargeAppIds = this.getAdminChargeAppIds();
        ArrayList<String> notInAppIds = new ArrayList<String>(20);
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        if (null != disabledAppIds && !disabledAppIds.isEmpty()) {
            notInAppIds.addAll(disabledAppIds);
        }
        for (TreeNode node : listNode) {
            String nodeId = node.getId();
            String appId = nodeId.substring(0, nodeId.indexOf(35));
            notInAppIds.add(appId);
        }
        List<String> appIdsBlackListFromStd = PermFormCommonUtil.getAppIdsFromStdBlackList();
        if (!CollectionUtils.isEmpty(appIdsBlackListFromStd)) {
            notInAppIds.addAll(appIdsBlackListFromStd);
        }
        ArrayList<QFilter> qf = new ArrayList<QFilter>();
        if (null != notInAppIds && notInAppIds.size() > 0) {
            QFilter notInAppFilter = new QFilter("id", "not in", notInAppIds);
            qf.add(notInAppFilter);
        }
        QFilter cloudIdFilter = new QFilter("bizcloud", "in", (Object)cloudId);
        QFilter deployFilter = new QFilter("deploystatus", "=", (Object)"2");
        QFilter visibleFilter = new QFilter("visible", "=", (Object)"1");
        QFilter notExtendFilter = new QFilter("type", "=", (Object)"0");
        qf.add(cloudIdFilter);
        qf.add(deployFilter);
        qf.add(visibleFilter);
        qf.add(notExtendFilter);
        QFilter[] filters = qf.toArray(new QFilter[0]);
        filters = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])filters, (String)"id");
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,name,number", (QFilter[])filters);
        if (doc == null || doc.size() == 0) {
            return;
        }
        HashMap<String, String> extraAppInfos = new HashMap<String, String>();
        for (DynamicObject dObj : doc) {
            String appId = dObj.getString("id");
            if (adminChargeAppIds != null && !adminChargeAppIds.contains(appId)) continue;
            String name = dObj.getString("name");
            if (isShowNum) {
                name = name + "(" + dObj.getString("number") + ")";
            }
            extraAppInfos.put(appId, name);
        }
        for (Map.Entry extraAppInfo : extraAppInfos.entrySet()) {
            String extraAppId = (String)extraAppInfo.getKey();
            String extraAppName = (String)extraAppInfo.getValue();
            ArrayList<String> formNums = new ArrayList<String>();
            AppInfo appInfo = AppHelper.getMetaAppInfo((String)extraAppId);
            boolean allUserApp = appInfo.isAllUserApp();
            if (!allUserApp) continue;
            List menuElementlist = BizAppServiceHelp.getAllAppMenusByAppID((String)extraAppId);
            for (AppMenuElement menuElement : menuElementlist) {
                boolean needSkip;
                String formId = menuElement.getFormId();
                String visible = menuElement.getVisible();
                String parameter = menuElement.getParameter();
                String formNum = null;
                if (StringUtils.isNotEmpty((String)parameter)) {
                    JSONObject paramJsonObj = JSON.parseObject((String)parameter);
                    formNum = paramJsonObj.getString("formId");
                }
                if ((needSkip = StringUtils.isEmpty((String)formId) || "0".equals(visible)) || formNum != null) continue;
                try {
                    MainEntityType met = EntityMetadataCache.getDataEntityTypeById((String)formId);
                    if (!(met instanceof BillEntityType)) continue;
                    formNum = met.getName();
                    formNums.add(formNum);
                }
                catch (Exception e) {
                    logger.warn(String.format("\u8bfb\u53d6 %s\u7684\u5143\u6570\u636e\u4fe1\u606f\u65f6\u51fa\u9519", formId));
                }
            }
            if (formNums.size() == 0) continue;
            List<String> properBillFormNums = this.properBillForm(formNums);
            if (properBillFormNums == null || properBillFormNums.size() == 0) {
                return;
            }
            String newParentNodeId = cloudId + "#cloud";
            String newNodeId = extraAppId + "#app";
            TreeNode newNode = new TreeNode(newParentNodeId, newNodeId, extraAppName, true);
            listNode.add(newNode);
        }
    }

    private List<String> properBillForm(List<String> pFormNums) {
        StringBuilder sbNums = new StringBuilder();
        final int formNumsSize = pFormNums.size();
        for (int i = 0; i < formNumsSize; ++i) {
            sbNums.append('\'').append(pFormNums.get(i)).append('\'');
            if (i == formNumsSize - 1) continue;
            sbNums.append(',');
        }
        String nums = sbNums.toString();
        StringBuilder sbSql = new StringBuilder().append("SELECT FNumber ").append("FROM t_meta_formdesign t  ").append("WHERE t.FISTEMPLATE = '0' ").append("AND t.fmodeltype in('BillFormModel', 'BaseFormModel','LogBillFormModel')  ").append("AND t.FNumber in(").append(nums).append(") ");
        List billFormNums = (List)DB.query((DBRoute)DBRoute.meta, (String)sbSql.toString(), null, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> resultList = new ArrayList<String>(formNumsSize);
                while (rs.next()) {
                    resultList.add(rs.getString(1));
                }
                return resultList;
            }
        });
        return billFormNums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntityNode(String appId) {
        boolean isShowNum = false;
        String pgCache_isShowNum = this.pageCache.get("pgCache_isShowNum");
        if (StringUtils.isNotEmpty((String)pgCache_isShowNum)) {
            isShowNum = Boolean.parseBoolean(pgCache_isShowNum);
        }
        String algoKeyPrefix = this.getClass().getName() + ".addEntityNode.";
        DataSet bizUnitRelFormDS = null;
        DataSet bizObjAppDS = null;
        DataSet entityDesignDS = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet appEntDS = null;
        Object funcPermDS = null;
        DataSet entDS = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        DataSet finalDS = null;
        try {
            bizUnitRelFormDS = DB.queryDataSet((String)(algoKeyPrefix + BIZ_UNIT_REL_FORM_DS), (DBRoute)DBRoute.meta, (String)"SELECT fbizappid burf_appid, fformid burf_formid FROM t_meta_bizunitrelform");
            bizObjAppDS = DB.queryDataSet((String)(algoKeyPrefix + BIZ_OBJ_APP_DS), (DBRoute)DBRoute.permission, (String)"SELECT fbizappid entapp_appid, fbizobjid entapp_entnum FROM t_perm_bizobjapp");
            entityDesignDS = DB.queryDataSet((String)(algoKeyPrefix + ENTITY_DESIGN_DS), (DBRoute)DBRoute.meta, (String)"select fid ent_id, fnumber ent_num from t_meta_entitydesign");
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on(FIELD_ENTAPP_ENTNUM, FIELD_ENT_NUM).select(new String[]{FIELD_ENTAPP_APPID, FIELD_ENT_ID}).finish();
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS);
            StringBuilder sbEntSql = new StringBuilder().append(" select entd.FID entd_id, entd.fnumber entd_num ").append(" from t_meta_entitydesign entd ").append(" where entd.FISTEMPLATE = '0' ").append(" and entd.fmodeltype in('BillFormModel', 'BaseFormModel','LogBillFormModel') ").append(" AND entd.FTYPE = '0' ");
            String appNnum = AppMetadataCache.getAppNumberById((String)appId);
            String entityNumBlacklist = RunModeServiceHelper.getEntityNumFromBlacklist((String)appNnum);
            if (StringUtils.isNotEmpty((String)entityNumBlacklist)) {
                sbEntSql.append(" and entd.FNUMBER not in (").append(entityNumBlacklist).append(") ");
            }
            entDS = DB.queryDataSet((String)(algoKeyPrefix + ENT_DS), (DBRoute)DBRoute.meta, (String)sbEntSql.toString());
            appEntPermItemDS2 = appEntDS.join(entDS).on(FIELD_BURF_FORMID, FIELD_ENTD_ID).select(new String[]{FIELD_BURF_APPID}, new String[]{FIELD_ENTD_NUM, FIELD_ENTD_ID}).finish();
            StringBuilder sbCloudAppSql = new StringBuilder().append("select app.fid app_id, app.fnumber app_num, app.findustry app_industry ").append(" from t_meta_bizapp app ").append(" WHERE app.FID = ? ");
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)sbCloudAppSql.toString(), (Object[])new Object[]{appId});
            finalDS = appEntPermItemDS2.join(cloudAppDS).on(FIELD_BURF_APPID, FIELD_APP_ID).select(new String[]{FIELD_ENTD_NUM, FIELD_ENTD_ID}, new String[0]).finish();
            ArrayList<TreeNode> listNode = new ArrayList<TreeNode>(50);
            List<String> formNumsFromStdBlackList = PermFormCommonUtil.getFormNumsByAppFromStdBlackList(appId);
            List<String> entityNumList = this.getEntityNumList(finalDS.copy());
            String langStr = RequestContext.get().getLang().name();
            String entitynamemapCache = this.pageCache.get(PAGECACHE_ENTITYNAMEMAP);
            Map entityNameMap = null;
            if (StringUtils.isEmpty((String)entitynamemapCache)) {
                entityNameMap = PermCommonUtil.getAllEntNumAndNameMap();
                this.pageCache.put(PAGECACHE_ENTITYNAMEMAP, SerializationUtils.toJsonString((Object)entityNameMap));
            } else {
                entityNameMap = (Map)SerializationUtils.fromJsonString((String)entitynamemapCache, Map.class);
            }
            Map permControlType = PermCommonUtil.getPermControlType();
            while (finalDS.hasNext()) {
                String name;
                String id;
                block12: {
                    Row row = finalDS.next();
                    String entityNum = row.getString(FIELD_ENTD_NUM);
                    PermissionControlType permissionControlType = (PermissionControlType)permControlType.get(entityNum);
                    if (permissionControlType != null && permissionControlType.isForbidDataPerm()) {
                        formNumsFromStdBlackList.add(entityNum);
                        continue;
                    }
                    if (!CollectionUtils.isEmpty(formNumsFromStdBlackList) && formNumsFromStdBlackList.contains(entityNum)) continue;
                    id = row.getString(FIELD_ENTD_ID) + "|" + entityNum + "@" + appId + "#entity";
                    try {
                        name = (String)entityNameMap.get(entityNum);
                        if (StringUtils.isEmpty((String)name)) {
                            name = PermFormCommonUtil.getRuntimeFormName(entityNum);
                        }
                        if (!isShowNum) break block12;
                        name = name + "(" + entityNum + ")";
                    }
                    catch (Exception e) {
                        logger.warn("\u83b7\u53d6\u5b9e\u4f53\u540d\u79f0\u51fa\u9519\uff1a", (Throwable)e);
                        continue;
                    }
                }
                TreeNode entityNode = new TreeNode(appId + "#app", id, name, false);
                listNode.add(entityNode);
            }
            this.addExtraEntityNodeFromRuntime(appId, listNode, formNumsFromStdBlackList, isShowNum);
            this.addExtraEntityNodeFromMenuMeta(appId, listNode, formNumsFromStdBlackList, isShowNum);
            if (listNode.size() > 0) {
                listNode.sort(Comparator.comparing(TreeNode::getId));
                this.treeView.addNodes(listNode);
            }
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
    }

    private List<String> getEntityNumList(DataSet ds) {
        HashSet<String> set = new HashSet<String>(64);
        while (ds.hasNext()) {
            Row row = ds.next();
            String entityNum = row.getString(FIELD_ENTD_NUM);
            set.add(entityNum);
        }
        return new ArrayList<String>(set);
    }

    private void addExtraEntityNodeFromRuntime(final String appNodeId, final List<TreeNode> listNode, final List<String> formNumsFromStdBlackList, final boolean isShowNum) {
        List runTimeFormIds = BizAppServiceHelp.getFormsIdByAppId((String)appNodeId);
        if (runTimeFormIds == null || runTimeFormIds.isEmpty()) {
            return;
        }
        ArrayList<String> existFormIds = new ArrayList<String>(listNode.size());
        for (TreeNode node : listNode) {
            String nodeId = node.getId();
            String existFormId = nodeId.substring(0, nodeId.indexOf(124));
            existFormIds.add(existFormId);
        }
        runTimeFormIds.removeAll(existFormIds);
        if (runTimeFormIds.isEmpty()) {
            return;
        }
        StringBuilder sbSql = new StringBuilder("select fid, fnumber from t_meta_entitydesign ").append(" where ftype = '0' ").append("and fmodeltype in('BillFormModel', 'BaseFormModel','LogBillFormModel') ").append("and fid in(");
        for (int i = 0; i < runTimeFormIds.size(); ++i) {
            sbSql.append('\'').append((String)runTimeFormIds.get(i)).append('\'');
            if (i != runTimeFormIds.size() - 1) {
                sbSql.append(", ");
                continue;
            }
            sbSql.append(')');
        }
        DB.query((DBRoute)DBRoute.meta, (String)sbSql.toString(), null, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String name;
                    String id;
                    block3: {
                        String entityId = rs.getString("fid");
                        String entityNum = rs.getString("fnumber");
                        if (!CollectionUtils.isEmpty((Collection)formNumsFromStdBlackList) && formNumsFromStdBlackList.contains(entityNum)) continue;
                        id = entityId + "|" + entityNum + "@" + appNodeId + "#entity";
                        name = "";
                        try {
                            entityNum = FormMetadataCache.getFormConfig((String)entityNum).getEntityTypeId();
                            name = FormMetadataCache.getFormConfig((String)entityNum).getCaption().getLocaleValue();
                            if (!isShowNum) break block3;
                            name = name + "(" + entityNum + ")";
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage());
                            continue;
                        }
                    }
                    TreeNode entityNode = new TreeNode(appNodeId + "#app", id, name, false);
                    listNode.add(entityNode);
                }
                return null;
            }
        });
    }

    private void addExtraEntityNodeFromMenuMeta(String appNodeId, List<TreeNode> listNode, List<String> formNumsFromStdBlackList, boolean isShowNum) {
        AppInfo appInfo = AppHelper.getMetaAppInfo((String)appNodeId);
        boolean allUserApp = appInfo.isAllUserApp();
        if (!allUserApp) {
            return;
        }
        int listNodeSize = listNode.size();
        ArrayList<String> existFormIds = new ArrayList<String>(listNodeSize);
        ArrayList<String> existEntityNums = new ArrayList<String>(listNodeSize);
        for (TreeNode node : listNode) {
            String nodeId = node.getId();
            String existFormId = nodeId.substring(0, nodeId.indexOf(124));
            String existEntityNum = nodeId.substring(nodeId.indexOf(124) + 1, nodeId.indexOf(64));
            existFormIds.add(existFormId);
            existEntityNums.add(existEntityNum);
        }
        List menuElementlist = BizAppServiceHelp.getAllAppMenusByAppID((String)appNodeId);
        int menuElementListSize = menuElementlist.size();
        HashMap formMapInfo = new HashMap(menuElementListSize);
        ArrayList<String> formNums = new ArrayList<String>(menuElementListSize);
        ArrayList<String> allMenuFormIds = new ArrayList<String>(menuElementListSize);
        for (Object menuElement : menuElementlist) {
            String formId = menuElement.getFormId();
            allMenuFormIds.add(formId);
        }
        Map<String, String[]> formInfoMap = OpRuleLeftTreeUtil.getFormInfoMap(allMenuFormIds);
        for (AppMenuElement menuElement : menuElementlist) {
            boolean needSkip;
            String formId = menuElement.getFormId();
            String formName = menuElement.getFormName();
            String visible = menuElement.getVisible();
            String formNum = null;
            if (StringUtils.isEmpty((String)formId)) continue;
            String[] arrValue = formInfoMap.get(formId);
            String entityNum = null;
            if (arrValue != null && arrValue.length > 0) {
                formNum = arrValue[0];
                try {
                    entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
                }
                catch (Exception e) {
                    logger.warn("\u83b7\u53d6" + formNum + "\u7684\u5b9e\u4f53\u6807\u8bc6\u51fa\u9519\uff1a", (Throwable)e);
                    continue;
                }
            }
            boolean bl = needSkip = "0".equals(visible) || existFormIds.contains(formId) || existEntityNums.contains(entityNum);
            if (needSkip) continue;
            formNums.add(formNum);
            HashMap<String, String> idNameMap = new HashMap<String, String>();
            idNameMap.put(formId, formName);
            formMapInfo.put(formNum, idNameMap);
        }
        if (formNums.isEmpty()) {
            return;
        }
        List<String> properBillFormNums = this.properBillForm(formNums);
        if (properBillFormNums == null || properBillFormNums.isEmpty()) {
            return;
        }
        Map appEntMap_RunModeBlackList = PermCommonUtil.getRunModeBlackList_AppEntMap();
        for (String billFormNum : properBillFormNums) {
            String formName;
            String formId;
            String newParentNodeId;
            block12: {
                Set entityNumsBlackList;
                if (!CollectionUtils.isEmpty(formNumsFromStdBlackList) && formNumsFromStdBlackList.contains(billFormNum) || !CollectionUtils.isEmpty((Map)appEntMap_RunModeBlackList) && (entityNumsBlackList = (Set)appEntMap_RunModeBlackList.get(appNodeId)) != null && entityNumsBlackList.contains(billFormNum)) continue;
                newParentNodeId = appNodeId + "#app";
                Map idNameMap = (Map)formMapInfo.get(billFormNum);
                Map.Entry entry = idNameMap.entrySet().iterator().next();
                formId = (String)entry.getKey();
                formName = "";
                try {
                    billFormNum = FormMetadataCache.getFormConfig((String)billFormNum).getEntityTypeId();
                    formName = FormMetadataCache.getFormConfig((String)billFormNum).getCaption().getLocaleValue();
                    if (!isShowNum) break block12;
                    formName = formName + "(" + billFormNum + ")";
                }
                catch (Exception e) {
                    logger.warn(e.getMessage());
                    continue;
                }
            }
            String newNodeId = formId + "|" + billFormNum + "@" + appNodeId + "#entity";
            TreeNode newNode = new TreeNode(newParentNodeId, newNodeId, formName, false);
            listNode.add(newNode);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent e) {
        boolean isAppNode;
        if (e.getNodeId() == null) {
            return;
        }
        String nodeId = e.getNodeId().toString();
        String parentId = nodeId.substring(0, nodeId.indexOf(35));
        boolean isCloudNode = nodeId.indexOf("#cloud") > 0;
        boolean bl = isAppNode = nodeId.indexOf("#app") > 0;
        if (isCloudNode) {
            this.addAppNode(parentId, null);
        } else if (isAppNode) {
            this.addEntityNode(parentId);
        }
    }

    private static Map<String, String[]> getFormInfoMap(List<String> formIds) {
        String langStr = RequestContext.get().getLang().name();
        final HashMap<String, String[]> entityIdNumMap = new HashMap<String, String[]>();
        StringBuilder sb = new StringBuilder().append("SELECT                     ").append("\tt.fid     id,           ").append("\tt.fnumber number,       ").append("\tl.fname   name          ").append("FROM                       ").append("\tt_meta_formdesign t    ").append("\tleft join t_meta_formdesign_l l   ").append("\ton t.fid = l.fid   ").append("WHERE l.flocaleid = '").append(langStr).append("' ");
        if (formIds != null && formIds.size() > 0) {
            sb.append(" AND t.fid in (");
            int size = formIds.size();
            for (int i = 0; i < size; ++i) {
                sb.append('\'').append(formIds.get(i)).append('\'');
                if (i == size - 1) continue;
                sb.append(',');
            }
            sb.append(") ");
        }
        String sql = sb.toString();
        DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String[]>>(){

            public Map<String, String[]> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    entityIdNumMap.put(rs.getString("id"), new String[]{rs.getString("number"), rs.getString("name")});
                }
                return entityIdNumMap;
            }
        });
        return entityIdNumMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchBillTreeByText(String searchText, boolean isShowNum) {
        String langStr = RequestContext.get().getLang().name();
        boolean isChineseLocale = "zh_CN".equals(langStr);
        String algoKeyPrefix = this.getClass().getName() + ".searchBillTreeByText.";
        DataSet bizUnitRelFormDS = null;
        DataSet bizObjAppDS = null;
        DataSet menuEntNumDS = null;
        DataSet formAndEntMapDS = null;
        DataSet entityDesignDS = null;
        Object entityDesignDSCopy = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet appEntDS = null;
        DataSet entDsOfDesign = null;
        DataSet entDS = null;
        DataSet entDsOfRuntime = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        DataSet finalDS = null;
        try {
            bizUnitRelFormDS = DB.queryDataSet((String)(algoKeyPrefix + BIZ_UNIT_REL_FORM_DS), (DBRoute)DBRoute.meta, (String)"SELECT distinct fbizappid burf_appid, fformid burf_formid FROM t_meta_bizunitrelform");
            bizObjAppDS = DB.queryDataSet((String)(algoKeyPrefix + BIZ_OBJ_APP_DS), (DBRoute)DBRoute.permission, (String)"SELECT distinct fbizappid entapp_appid, fbizobjid entapp_entnum FROM t_perm_bizobjapp");
            entityDesignDS = DB.queryDataSet((String)(algoKeyPrefix + ENTITY_DESIGN_DS), (DBRoute)DBRoute.meta, (String)"select fid ent_id, fnumber ent_num from t_meta_entitydesign");
            menuEntNumDS = DB.queryDataSet((String)(algoKeyPrefix + BIZ_OBJ_APP_DS), (DBRoute)DBRoute.meta, (String)"select distinct ar.fid app_id, mr.fformid menu_form_num from t_meta_menuruntime mr  inner join t_meta_appruntime ar on mr.fappid = ar.fappid  where mr.fformid <> ' ' and falluserapp = '1' ");
            formAndEntMapDS = DB.queryDataSet((String)(algoKeyPrefix + BIZ_OBJ_APP_DS), (DBRoute)DBRoute.meta, (String)" select fd.fnumber form_num, ed.fid ent_id from t_meta_formdesign fd inner join t_meta_entitydesign ed on (fd.fentityid = ed.fid) where fd.ftype = '0' ");
            menuEntNumDS = menuEntNumDS.join(formAndEntMapDS).on("menu_form_num", "form_num").select(new String[]{FIELD_APP_ID, FIELD_ENT_ID}).finish();
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on(FIELD_ENTAPP_ENTNUM, FIELD_ENT_NUM).select(new String[]{FIELD_ENTAPP_APPID, FIELD_ENT_ID}).finish();
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS).union(menuEntNumDS);
            entDsOfRuntime = FormHelper.getEntDsOfRuntime((String)searchText, (boolean)isShowNum);
            Map entNumNameMapOfRuntime = FormHelper.getEntNumNameMapOfRuntime((String)searchText, (boolean)isShowNum, (DataSet)entDsOfRuntime.copy());
            entDsOfDesign = FormHelper.getEntDsOfDesign(null, (boolean)isShowNum, (boolean)false, (String)"0", (Set)Sets.newHashSet((Object[])new String[]{"BillFormModel", "BaseFormModel", "LogBillFormModel"}), null, (String)"0", entNumNameMapOfRuntime.keySet());
            entDS = entDsOfRuntime.join(entDsOfDesign).on("runtimeEntId", "designEntNum").select(new String[]{"runtimeEntName as entdl_name"}, new String[]{"designEntId as entd_id", "designEntNum as entd_num"}).finish();
            appEntPermItemDS2 = appEntDS.join(entDS).on(FIELD_BURF_FORMID, FIELD_ENTD_ID).select(new String[]{FIELD_BURF_APPID}, new String[]{FIELD_ENTD_NUM, FIELD_ENTDL_NAME, FIELD_ENTD_ID}).finish();
            StringBuilder sb = new StringBuilder().append("SELECT cloud.fid cloudl_id, cloudl.fname cloudl_name, cloud.fseq cloud_seq, cloud.fnumber cloud_num, ").append(" app.FID app_id, appl.fname app_name, ");
            if (isChineseLocale) {
                sb.append("appl2.fname app_name2, ");
            } else {
                sb.append("case when appl2.fname is null or appl2.fname = '' or appl2.fname= ' ' ").append("then appl3.fname ").append("else appl2.fname ").append("end app_name2 , ");
            }
            sb.append(" app.fnumber app_num ").append(" FROM t_meta_bizapp app ").append(" LEFT JOIN t_meta_bizapp_l appl ON (app.FID = appl.FID and appl.FLOCALEID = ?) ").append(" LEFT JOIN t_meta_appruntime_l appl2 ON  (app.FNUMBER = appl2.FAPPID and appl2.FLOCALEID = ?) ");
            if (!isChineseLocale) {
                sb.append(" LEFT JOIN t_meta_appruntime_l appl3 ON  (app.FNUMBER = appl3.FAPPID and appl3.FLOCALEID = 'zh_CN') ");
            }
            sb.append(" INNER JOIN t_meta_bizcloud cloud ON (cloud.FID = app.FBIZCLOUDID) ").append(" LEFT JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = cloud.FID AND cloudl.FLOCALEID = ?)").append(" WHERE app.fdeploystatus = '2' ");
            this.appendCloudFilter(sb);
            this.appendAppFilter(sb);
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{langStr, langStr, langStr});
            finalDS = appEntPermItemDS2.join(cloudAppDS).on(FIELD_BURF_APPID, FIELD_APP_ID).select(new String[]{FIELD_ENTD_NUM, FIELD_ENTDL_NAME, FIELD_ENTD_ID}, new String[]{FIELD_CLOUDL_ID, FIELD_CLOUDL_NAME, FIELD_APP_ID, FIELD_APP_NAME, "app_name2", "cloud_num", "app_num"}).finish();
            this.treeView.deleteAllNodes();
            TreeNode rootNode = this.createRootNode();
            String rootNodeId = rootNode.getId();
            this.treeView.addNode(rootNode);
            ArrayList<String> cloudIds = new ArrayList<String>();
            ArrayList<String> appIds = new ArrayList<String>();
            HashSet<String> appEntSet = new HashSet<String>(50);
            List<String> formNumsFromStdBlackList = PermFormCommonUtil.getFormNumsFromStdBlackList();
            Map extAppAndOrgnlAppRel = AppHelper.getExtAppAndOrgnlAppRel();
            Map permControlType = PermCommonUtil.getPermControlType();
            Map runModeBlackList_AppEntMap = PermCommonUtil.getRunModeBlackList_AppEntMap();
            while (finalDS.hasNext()) {
                TreeNode entityNode;
                TreeNode appNode;
                TreeNode cloudNode;
                String appIdEntNumStr;
                String appName;
                Set entityNums_blackList;
                String appId;
                Row row = finalDS.next();
                String entityNum = row.getString(FIELD_ENTD_NUM);
                PermissionControlType permissionControlType = (PermissionControlType)permControlType.get(entityNum);
                if (permissionControlType != null && permissionControlType.isForbidDataPerm()) continue;
                String cloudId = row.getString(FIELD_CLOUDL_ID) + "#cloud";
                String cloudName = row.getString(FIELD_CLOUDL_NAME);
                String cloudNum = row.getString("cloud_num");
                if (isShowNum) {
                    cloudName = cloudName + "(" + cloudNum + ")";
                }
                if (StringUtils.isNotEmpty((String)(appId = (String)extAppAndOrgnlAppRel.get(row.getString(FIELD_APP_ID)))) && (entityNums_blackList = (Set)runModeBlackList_AppEntMap.get(appId)) != null && entityNums_blackList.contains(entityNum)) continue;
                String appNum = row.getString("app_num");
                String appLongId = appId + "#app";
                String string = appName = StringUtils.isNotEmpty((String)row.getString("app_name2")) ? row.getString("app_name2") : row.getString(FIELD_APP_NAME);
                if (isShowNum) {
                    appName = appName + "(" + appNum + ")";
                }
                String entityNodeId = row.getString(FIELD_ENTD_ID) + "|" + entityNum + "@" + appId + "#entity";
                String entityName = (String)entNumNameMapOfRuntime.get(entityNum);
                if (isShowNum) {
                    entityName = entityName + "(" + entityNum + ")";
                }
                if (StringUtils.isEmpty((String)entityName)) {
                    entityName = PermFormCommonUtil.getRuntimeFormName(entityNum);
                }
                if (!CollectionUtils.isEmpty(formNumsFromStdBlackList) && formNumsFromStdBlackList.contains(entityNum) || appEntSet.contains(appIdEntNumStr = appId + "_" + entityNum)) continue;
                appEntSet.add(appIdEntNumStr);
                if (cloudIds.contains(cloudId)) {
                    if (appIds.contains(appLongId)) {
                        TreeNode appNode2 = rootNode.getTreeNode(appLongId, 2);
                        TreeNode entityNode2 = new TreeNode(appLongId, entityNodeId, entityName, false);
                        appNode2.addChild(entityNode2);
                        this.treeView.expand(appLongId);
                        continue;
                    }
                    cloudNode = rootNode.getTreeNode(cloudId, 1);
                    appNode = new TreeNode(cloudId, appLongId, appName, true);
                    appIds.add(appLongId);
                    cloudNode.addChild(appNode);
                    this.treeView.expand(cloudId);
                    entityNode = new TreeNode(appLongId, entityNodeId, entityName, false);
                    appNode.addChild(entityNode);
                    this.treeView.expand(appLongId);
                    continue;
                }
                cloudNode = new TreeNode(rootNodeId, cloudId, cloudName, true);
                cloudIds.add(cloudId);
                rootNode.addChild(cloudNode);
                this.treeView.expand(rootNodeId);
                appNode = new TreeNode(cloudId, appLongId, appName, true);
                appIds.add(appLongId);
                cloudNode.addChild(appNode);
                this.treeView.expand(cloudId);
                entityNode = new TreeNode(appLongId, entityNodeId, entityName, false);
                appNode.addChild(entityNode);
                this.treeView.expand(appLongId);
            }
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, formAndEntMapDS, entityDesignDSCopy, bizObjAppJoinEntityDesignDS, appEntDS, entDS, entDsOfDesign, appEntPermItemDS2, entDsOfRuntime, cloudAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, formAndEntMapDS, entityDesignDSCopy, bizObjAppJoinEntityDesignDS, appEntDS, entDS, entDsOfDesign, appEntPermItemDS2, entDsOfRuntime, cloudAppDS, finalDS});
    }

    private void appendCloudFilter(StringBuilder sb) {
        Set disabledCloudIds;
        List<String> cloudIdsBlackListFromStd;
        String cloudIdBlackList = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (StringUtils.isNotEmpty((String)cloudIdBlackList)) {
            sb.append(" and cloud.fid not in (").append(cloudIdBlackList).append(')');
        }
        if (!CollectionUtils.isEmpty(cloudIdsBlackListFromStd = PermFormCommonUtil.getCloudIdsFromStdBlackList())) {
            for (int i = 0; i < cloudIdsBlackListFromStd.size(); ++i) {
                cloudIdsBlackListFromStd.set(i, "'" + cloudIdsBlackListFromStd.get(i) + "'");
            }
            String cloudIds = String.join((CharSequence)",", cloudIdsBlackListFromStd);
            if (StringUtils.isNotEmpty((String)cloudIds)) {
                sb.append(" and cloud.fid not in (").append(cloudIds).append(')');
            }
        }
        if (null != (disabledCloudIds = ManageServiceHelper.getDisabledCloudIds()) && !disabledCloudIds.isEmpty()) {
            String disabledCloudIdsStr = String.join((CharSequence)"','", disabledCloudIds);
            sb.append(" and cloud.fid not in ('").append(disabledCloudIdsStr).append("') ");
        }
    }
}

