/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.IndustryHelper;
import kd.bos.permission.cache.helper.OperationHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.enumeration.PermTreeLevel;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionQuery;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermFormCommonUtil {
    private static final String MESSAGE_I_DATA_MODEL_CAN_NOT_BE_NULL = "IDataModel can not be null";
    private static Log logger = LogFactory.getLog(PermFormCommonUtil.class);

    public static void setData(String propName, int rowIndex, IDataModel iDataModel, Object value) {
        if (iDataModel == null) {
            throw new IllegalArgumentException(MESSAGE_I_DATA_MODEL_CAN_NOT_BE_NULL);
        }
        if (rowIndex < 0) {
            iDataModel.setValue(propName, value);
        } else {
            iDataModel.setValue(propName, value, rowIndex);
        }
    }

    public static void setDataIfChange(String propName, int rowIndex, IDataModel iDataModel, Object value) {
        if (iDataModel == null) {
            throw new IllegalArgumentException(MESSAGE_I_DATA_MODEL_CAN_NOT_BE_NULL);
        }
        Object oldValue = null;
        oldValue = rowIndex == -1 ? iDataModel.getValue(propName) : iDataModel.getValue(propName, rowIndex);
        if (oldValue == value || oldValue.equals(value)) {
            return;
        }
        PermFormCommonUtil.setData(propName, rowIndex, iDataModel, value);
    }

    public static String loadBaseDataId(String propName, int rowIndex, IDataModel iDataModel) {
        if (iDataModel == null) {
            throw new IllegalArgumentException(MESSAGE_I_DATA_MODEL_CAN_NOT_BE_NULL);
        }
        Object id = PermFormCommonUtil.loadBaseDataIdObj(propName, rowIndex, iDataModel);
        return id == null || id.equals(0L) ? null : id.toString();
    }

    public static <T> T loadBaseDataIdObj(String propName, int rowIndex, IDataModel iDataModel) {
        Object idObj;
        if (iDataModel == null) {
            throw new IllegalArgumentException(MESSAGE_I_DATA_MODEL_CAN_NOT_BE_NULL);
        }
        Object object = idObj = rowIndex < 0 ? iDataModel.getValue(propName + "_id") : iDataModel.getValue(propName + "_id", rowIndex);
        if (Integer.class.isInstance(idObj)) {
            return (T)Long.valueOf(((Integer)idObj).intValue());
        }
        return (T)idObj;
    }

    public static <PROPERTY_TYPE> PROPERTY_TYPE getEntityProperty(DynamicObject entity, String propertyName) {
        int firstPointIndex = propertyName.trim().indexOf(46);
        if (firstPointIndex < 0) {
            return (PROPERTY_TYPE)entity.get(propertyName);
        }
        String subPropertyName = propertyName.substring(0, firstPointIndex);
        DynamicObject subEntity = entity.getDynamicObject(subPropertyName);
        return PermFormCommonUtil.getEntityProperty(subEntity, propertyName.trim().substring(firstPointIndex + 1));
    }

    public static String getEntityPropertyDisplayName(DynamicObjectType dynamicObjectType, String propertyName) {
        String[] propertyNameArray;
        LinkedBlockingDeque<String> displayNameStack = new LinkedBlockingDeque<String>();
        for (String subPropertyName : propertyNameArray = propertyName.split("\\s*[.]+\\s*")) {
            DynamicProperty subProperty = dynamicObjectType.getProperty(subPropertyName);
            LocaleString subPropertyLocaleDisplayName = subProperty.getDisplayName();
            String subPropertyDisplayName = subPropertyLocaleDisplayName == null ? "" : subPropertyLocaleDisplayName.toString();
            displayNameStack.offerLast(subPropertyDisplayName);
            if (!EntryProp.class.isInstance(subProperty)) continue;
            EntryProp entryProp = (EntryProp)EntryProp.class.cast(subProperty);
            EntryType entryType = (EntryType)entryProp.getItemType();
            dynamicObjectType = entryType;
        }
        Iterator displayNameIterator = displayNameStack.iterator();
        StringBuilder displayNameBuffer = new StringBuilder();
        while (displayNameIterator.hasNext()) {
            displayNameBuffer.append((String)displayNameIterator.next());
            if (!displayNameIterator.hasNext()) continue;
            displayNameBuffer.append('.');
        }
        return displayNameBuffer.toString();
    }

    public static int[] getSelectedRowIndexArray(IFormView iFormView, IDataModel iDataModel, String listKey) {
        int[] nArray;
        Control listControl = iFormView.getControl(listKey);
        if (!EntryGrid.class.isInstance(listControl)) {
            return new int[]{iDataModel.getEntryCurrentRowIndex(listKey)};
        }
        EntryGrid entryGrid = (EntryGrid)EntryGrid.class.cast(listControl);
        AbstractGrid.GridState gridState = entryGrid.getEntryState();
        int[] selectedRowIndexArray = gridState.getSelectedRows();
        if (selectedRowIndexArray == null || selectedRowIndexArray.length == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = iDataModel.getEntryCurrentRowIndex(listKey);
        } else {
            nArray = selectedRowIndexArray;
        }
        return nArray;
    }

    public static Set<String> getSelectedIdSet(IFormView iFormView, IDataModel iDataModel, String listKey, String idPropertyName) {
        int[] selectedListIndexArray = PermFormCommonUtil.getSelectedRowIndexArray(iFormView, iDataModel, listKey);
        if (selectedListIndexArray == null || selectedListIndexArray.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> idSet = new HashSet<String>(selectedListIndexArray.length);
        for (int selectedListIndex : selectedListIndexArray) {
            String id;
            if (selectedListIndex < 0 || StringUtils.isEmpty((String)(id = (String)iDataModel.getValue(idPropertyName, selectedListIndex)))) continue;
            idSet.add(id);
        }
        return idSet;
    }

    public static Set<String> getAllListIdSet(IDataModel iDataModel, String listKey, String idPropertyName) {
        HashSet<String> idSet = new HashSet<String>();
        int listRowCount = iDataModel.getEntryRowCount(listKey);
        String id = null;
        DynamicObjectCollection entryEntity = iDataModel.getEntryEntity(listKey);
        for (int index = 0; index < listRowCount; ++index) {
            Object value = ((DynamicObject)entryEntity.get(index)).get(idPropertyName);
            if (value instanceof String) {
                id = (String)value;
            } else if (value instanceof DynamicObject) {
                id = ((DynamicObject)value).getPkValue().toString();
            } else if (value instanceof Long) {
                id = value.toString();
            }
            if (StringUtils.isEmpty((String)id)) continue;
            idSet.add(id);
        }
        return idSet;
    }

    public static Set<Long> getAllLongIdSet(IDataModel dataModel, String entryKey, String propertyNum) {
        int rowCount = dataModel.getEntryRowCount(entryKey);
        if (rowCount <= 0) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> idSet = new HashSet<Long>(rowCount);
        for (int index = 0; index < rowCount; ++index) {
            Long id = null;
            Object value = dataModel.getValue(propertyNum, index);
            if (value instanceof DynamicObject) {
                id = (Long)((DynamicObject)dataModel.getValue(propertyNum, index)).getPkValue();
            } else if (value instanceof Long) {
                id = (Long)value;
            }
            if (id == null) continue;
            idSet.add(id);
        }
        return idSet;
    }

    public static TreeNode createTreeNode(String nodeId, String nodeText, Object ... customParams) {
        String parentId = customParams != null && customParams.length > 0 ? (String)customParams[0] : null;
        boolean isParent = customParams != null && customParams.length > 1 ? (Boolean)customParams[1] : true;
        Object data = customParams != null && customParams.length > 2 ? customParams[2] : null;
        TreeNode treeNode = new TreeNode(parentId, nodeId, nodeText, isParent, data);
        return treeNode;
    }

    public static String getSelectedTreeNodeId(IFormView iFormView, String treeKey) {
        TreeView fieldPermTreeView = (TreeView)iFormView.getControl(treeKey);
        TreeView.TreeState fieldPermTreeViewState = fieldPermTreeView.getTreeState();
        String focusNodeId = fieldPermTreeViewState.getFocusNodeId();
        return focusNodeId;
    }

    public static DynamicObject getDynamicObjectFromMul(DynamicObject mulDynamicObject) {
        return mulDynamicObject.getDynamicObject("FBasedataId");
    }

    public static boolean isCollectionEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isMapEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    @Deprecated
    public static Map<String, String> getOperationInfoMap(String bizObjectId) {
        return OperationHelper.getOperationInfoMap((String)bizObjectId);
    }

    @Deprecated
    public static Map<String, String> getOperationTypeInfoMap(String bizObjectId) {
        return OperationHelper.getOperationTypeInfoMap((String)bizObjectId);
    }

    public static Map<String, String[]> getEntityInfoMap(String langStr) {
        final HashMap<String, String[]> entityIdNumMap = new HashMap<String, String[]>();
        String sql = "SELECT                     " + "\tt.fid     id,           " + "\tt.fnumber number,       " + "\tl.fname   name          " + "FROM                       " + "\tt_meta_entitydesign t,  " + "\tt_meta_entitydesign_l l " + "WHERE                      " + "\tt.fid = l.fid           " + "AND l.flocaleid = ? ";
        Object[] params = new Object[]{langStr};
        DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, String[]>>(){

            public Map<String, String[]> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    entityIdNumMap.put(rs.getString("id"), new String[]{rs.getString("number"), rs.getString("name")});
                }
                return entityIdNumMap;
            }
        });
        return entityIdNumMap;
    }

    public static <T> List<T> changeArrayToList(T[] arrStr) {
        ArrayList<T> resultList = null;
        if (arrStr != null && arrStr.length > 0) {
            int arrStrLength = arrStr.length;
            resultList = new ArrayList<T>(arrStrLength);
            for (int i = 0; i < arrStrLength; ++i) {
                resultList.add(arrStr[i]);
            }
        }
        return resultList;
    }

    public static void updateTreeNode(TreeNode tree, TreeNode updateTreeNode) {
        String parentId = updateTreeNode.getParentid();
        String id = updateTreeNode.getId();
        if (parentId.equals("")) {
            return;
        }
        TreeNode parentNode = tree.getTreeNode(parentId, PermTreeLevel.FIFTH.getIntLevel() + 1);
        List childList = parentNode.getChildren();
        for (int i = 0; i < childList.size(); ++i) {
            TreeNode tn = (TreeNode)childList.get(i);
            if (!tn.getId().equals(id)) continue;
            childList.set(i, updateTreeNode);
            parentNode.setChildren(childList);
            break;
        }
    }

    @SdkInternal
    public static void closeClientForm(IFormView fv) {
        IFormView parentView;
        IFormView mainview;
        FormShowParameter param = fv.getFormShowParameter();
        if (param.getOpenStyle().getShowType().equals((Object)ShowType.NewTabPage) && (mainview = fv.getMainView()) != null) {
            parentView = fv.getView(fv.getFormShowParameter().getParentPageId());
            if (param.getOpenStyle().getShowType() != ShowType.Modal) {
                Control c;
                Control control = c = parentView == null ? null : parentView.getControl("_submaintab_");
                if (c instanceof Tab) {
                    param.getOpenStyle().setTargetKey("_submaintab_");
                    mainview = parentView;
                } else if (c == null) {
                    IPageCache pageCache = (IPageCache)mainview.getService(IPageCache.class);
                    String _submaintab_count_ = pageCache.get("_submaintab_count_");
                    int count = _submaintab_count_ == null ? 3 : Integer.parseInt(_submaintab_count_);
                    pageCache.put("_submaintab_count_", Integer.toString(--count) + "");
                }
            }
        }
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("pageId", fv.getPageId());
        ((IClientViewProxy)fv.getService(IClientViewProxy.class)).addAction("closeWindow", arg);
        parentView = fv.getParentView();
        if (parentView != null && fv.getFormShowParameter().getCloseCallBack() != null) {
            IFormController srv = (IFormController)parentView.getService(IFormController.class);
            srv.formClosedCallBack(fv);
            fv.sendFormAction(parentView);
        }
    }

    public static Map<Long, String[]> getOrgInfo(List<Long> orgIds) {
        String selFields = "id" + ',' + "number" + ',' + "name";
        DynamicObject[] arrDObj = BusinessDataServiceHelper.load((String)"bos_org", (String)selFields, (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)});
        HashMap<Long, String[]> result = new HashMap<Long, String[]>(arrDObj.length);
        for (DynamicObject dObj : arrDObj) {
            Long orgId = dObj.getLong("id");
            String orgNumber = dObj.getString("number");
            String orgName = dObj.getString("name");
            result.put(orgId, new String[]{orgNumber, orgName});
        }
        return result;
    }

    @Deprecated
    public static List<Map<String, String>> getOpInfoList(String entityNum) {
        return OperationHelper.getOpInfoList((String)entityNum);
    }

    public static void setFilterGridAddBtnVisible(IFormView fv, String filterGridKey, boolean visible) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)fv.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(filterGridKey, "setAddBtnStatus", new Object[]{!visible});
    }

    public static boolean isAdminPartnerUser(Long userId) {
        boolean isAdminPartner;
        DynamicObject[] bizPartner = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"isadmin", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
        return bizPartner != null && bizPartner.length > 0 && (isAdminPartner = bizPartner[0].getBoolean("isadmin"));
    }

    @Deprecated
    public static void refreshUserAppCache(List<Object> roleIds) {
        CacheMrg.clearAllCache();
    }

    @SdkInternal
    public static void setDataChanged(IDataModel dataModel, boolean includeEntry, boolean changed) {
        dataModel.setDataChanged(changed);
        dataModel.getDataEntity(includeEntry).getDataEntityState().setRemovedItems(Boolean.valueOf(changed));
    }

    @Deprecated
    @SdkInternal
    public static Map<Long, String> getAllIndustryInfo() {
        return IndustryHelper.getAllIndustryInfo();
    }

    @SdkInternal
    public static String getRuntimeFormName(String formNum) {
        String name = "";
        try {
            String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
            name = FormMetadataCache.getFormConfig((String)entityNum).getCaption().getLocaleValue();
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            name = formNum;
        }
        return name;
    }

    @SdkInternal
    public static Map<String, List<String>> getAllExtAppIds(final List<String> originalAppIds) {
        final HashMap<String, List<String>> oriAppWithExtAppIdResult = new HashMap<String, List<String>>();
        StringBuilder allExtAppIdsSbSql = new StringBuilder("SELECT fid, fmasterid FROM t_meta_bizapp WHERE ((fid <> fmasterid) AND (fmasterid<>' '))");
        DB.query((DBRoute)DBRoute.meta, (String)allExtAppIdsSbSql.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String extAppId = rs.getString("fid");
                    String orignalAppId = rs.getString("fmasterid");
                    if (!originalAppIds.contains(orignalAppId) || originalAppIds.contains(extAppId) || orignalAppId.isEmpty()) continue;
                    oriAppWithExtAppIdResult.computeIfAbsent(orignalAppId, k -> new ArrayList()).add(extAppId);
                }
                return null;
            }
        });
        return oriAppWithExtAppIdResult;
    }

    @SdkInternal
    public static List<String> getAllExtAppId(String originalAppId) {
        StringBuilder sb = new StringBuilder("select fid from t_meta_bizapp where fmasterid = ? ").append(" and fid <> ? ");
        final ArrayList<String> result = new ArrayList<String>();
        Object[] params = new Object[]{originalAppId, originalAppId};
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    result.add(rs.getString("fid"));
                }
                return null;
            }
        });
        return result;
    }

    @Deprecated
    @SdkInternal
    public static Map<String, String> getExtAppAndOrgnlAppRel() {
        return AppHelper.getExtAppAndOrgnlAppRel();
    }

    @Deprecated
    @SdkInternal
    public static void addLog(String opName, String opDescription, String bizObjID) {
        PermCommonUtil.addLog((String)opName, (String)opDescription, (String)bizObjID, null);
    }

    @Deprecated
    @SdkInternal
    public static void addLogWithAppId(String opName, String opDescription, String bizObjID, String appId) {
        PermCommonUtil.addLog((String)opName, (String)opDescription, (String)bizObjID, null, null, (String)appId);
    }

    @Deprecated
    @SdkInternal
    public static void addLog(String opName, String opDescription, String bizObjID, Date operationTime) {
        PermCommonUtil.addLog((String)opName, (String)opDescription, (String)bizObjID, (Date)operationTime);
    }

    @Deprecated
    @SdkInternal
    public static boolean isSingleOrg() {
        return PermCommonUtil.isSingleOrg();
    }

    @SdkInternal
    public static boolean isSingleOrg(String curCtrlType) {
        boolean isSingleOrg = PermCommonUtil.isSingleOrg();
        return ("DIM_ORG".equals(curCtrlType) || "bos_org".equals(curCtrlType)) && isSingleOrg;
    }

    @Deprecated
    @SdkInternal
    public static List<String> getCloudIdsFromStdBlackList() {
        return PermCommonUtil.getCloudIdsFromStdBlackList();
    }

    @Deprecated
    @SdkInternal
    public static List<String> getAppIdsFromStdBlackList() {
        return PermCommonUtil.getAppIdsFromStdBlackList();
    }

    public static List<String> getFormNumsFromStdBlackList() {
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List formNums = service.getFormBlackList();
        return formNums;
    }

    @SdkInternal
    public static List<String> getFormNumsByAppFromStdBlackList(String appId) {
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List formNums = service.getFormBlackListByAppId(appId);
        return formNums;
    }

    @Deprecated
    @SdkInternal
    public static List<String> getFieldKeysFromStdBlackList(String formNum) {
        return PermCommonUtil.getFieldKeysFromStdBlackList((String)formNum);
    }

    public static List<String> getEntNumByAppFromRunModeBlackList(String appId) {
        ArrayList<String> resultList = new ArrayList<String>();
        String appNumber = AppMetadataCache.getAppNumberById((String)appId);
        String entNumBlackListStr = RunModeServiceHelper.getEntityNumFromBlacklist((String)appNumber);
        if (StringUtils.isEmpty((String)entNumBlackListStr)) {
            return resultList;
        }
        String[] arrEntNums = entNumBlackListStr.split(",");
        if (arrEntNums == null || arrEntNums.length == 0) {
            return resultList;
        }
        for (String entNum : arrEntNums) {
            String entNumTrim = entNum.trim();
            if (StringUtils.isEmpty((String)entNumTrim)) continue;
            int firstIndex = entNumTrim.indexOf(39);
            int lastIndex = entNumTrim.lastIndexOf(39);
            if (firstIndex == -1 || lastIndex == -1 || firstIndex == lastIndex) continue;
            resultList.add(entNumTrim.substring(firstIndex + 1, lastIndex));
        }
        return resultList;
    }

    public static ListShowParameter getUserF7ListShowParameter(IPageCache pageCache, Set<Long> curUserIdsSet) {
        return PermFormCommonUtil.getUserF7ListShowParameter(pageCache, curUserIdsSet, Boolean.TRUE, Boolean.FALSE);
    }

    public static ListShowParameter getUserF7ListShowParameter(IPageCache pageCache, Set<Long> curUserIdsSet, Boolean isOrgBaseAdmin, Boolean isforbidden) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true, (int)0);
        if (curUserIdsSet == null) {
            curUserIdsSet = new HashSet<Long>(1);
        }
        curUserIdsSet.add(RequestContext.get().getCurrUserId());
        String userQFilterJson = pageCache.get("CustomQFilter_UserIds");
        ArrayList<QFilter> qList = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((String)userQFilterJson)) {
            QFilter userQFilter = QFilter.fromSerializedString((String)userQFilterJson);
            qList.add(userQFilter);
            lsp.setListFilterParameter(new ListFilterParameter(qList, null));
        } else {
            String customUserObjIds = pageCache.get("CustomFilter_UserIds");
            if (StringUtils.isNotEmpty((String)customUserObjIds)) {
                List strDimUserIdList = (List)SerializationUtils.fromJsonString((String)customUserObjIds, List.class);
                ArrayList<Long> userObjIdList = new ArrayList<Long>(strDimUserIdList.size());
                for (Object strUserObjId : strDimUserIdList) {
                    userObjIdList.add(Long.parseLong(strUserObjId.toString()));
                }
                qList.add(new QFilter("id", "in", userObjIdList));
                lsp.setListFilterParameter(new ListFilterParameter(qList, null));
            }
        }
        List qFilters = lsp.getListFilterParameter().getQFilters();
        QFilter qFilter = new QFilter("id", "not in", curUserIdsSet).and("usertype", "!=", (Object)"6").and("enable", "=", (Object)"1");
        if (null != isforbidden) {
            qFilter.and("isforbidden", "=", (Object)(isforbidden != false ? "1" : "0"));
        }
        qFilters.add(qFilter);
        lsp.setListFilterParameter(new ListFilterParameter(qFilters, null));
        if (PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            lsp.setCustomParam("isOrgBaseAdmin", (Object)isOrgBaseAdmin);
        }
        lsp.setCustomParam("externalUserType", (Object)"all");
        return lsp;
    }

    public static ListShowParameter getDimF7ListShowParameter(IPageCache pageCache, Set<Long> curDimIdsSet, String curDimType) {
        DynamicObject curCtrlTypeObj = QueryServiceHelper.queryOne((String)"perm_ctrltype", (String)"name", (QFilter[])new QFilter[]{new QFilter("bizobjectid", "=", (Object)curDimType)});
        String curDimTypeName = curCtrlTypeObj.getString("name");
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)curDimType, (boolean)true, (int)0);
        lsp.setCaption(curDimTypeName);
        String dimObjQFilterCache = pageCache.get("CustomQFilter_DimObjIds");
        ArrayList<QFilter> qList = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((String)dimObjQFilterCache)) {
            QFilter dimObjQFilter = QFilter.fromSerializedString((String)dimObjQFilterCache);
            qList.add(dimObjQFilter);
            lsp.setListFilterParameter(new ListFilterParameter(qList, null));
        } else {
            String customDimObjIds = pageCache.get("CustomFilter_DimObjIds");
            if (StringUtils.isNotEmpty((String)customDimObjIds)) {
                List strDimObjIdList = (List)SerializationUtils.fromJsonString((String)customDimObjIds, List.class);
                ArrayList<Long> dimObjIdList = new ArrayList<Long>(strDimObjIdList.size());
                for (Object strDimObjId : strDimObjIdList) {
                    dimObjIdList.add(Long.parseLong(strDimObjId.toString()));
                }
                qList.add(new QFilter("id", "in", dimObjIdList));
                lsp.setListFilterParameter(new ListFilterParameter(qList, null));
            }
        }
        List qFilters = lsp.getListFilterParameter().getQFilters();
        if ("bos_org".equals(curDimType)) {
            lsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
            lsp.setCustomParam("isAddChargeOrgFilter", (Object)Boolean.TRUE);
            lsp.setCustomParam("showAdminOrgViewType", (Object)Boolean.TRUE);
        }
        qFilters.add(new QFilter("id", "not in", curDimIdsSet));
        lsp.setListFilterParameter(new ListFilterParameter(qFilters, null));
        lsp.setF7ClickByFilter(true);
        return lsp;
    }

    public static ListShowParameter getFpsF7ListShowParameter(IPageCache pageCache, List<QFilter> paramQFilterList) {
        String customQFilterJson;
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"perm_fieldscheme", (boolean)true, (int)0);
        ArrayList<QFilter> qList = new ArrayList<QFilter>(10);
        if (null != paramQFilterList && !paramQFilterList.isEmpty()) {
            qList.addAll(paramQFilterList);
        }
        if (StringUtils.isNotEmpty((String)(customQFilterJson = pageCache.get("CustomQFilter_Fps")))) {
            QFilter customQFilter = QFilter.fromSerializedString((String)customQFilterJson);
            qList.add(customQFilter);
        }
        lsp.setListFilterParameter(new ListFilterParameter(qList, null));
        return lsp;
    }

    public static void entF7ChangeF7Caption(String propEnt, String captionName, BeforeF7SelectEvent evt) {
        Object source = evt.getSource();
        if (StringUtils.isEmpty((String)propEnt) || null == source) {
            return;
        }
        if (source instanceof BasedataEdit) {
            BasedataEdit bd = (BasedataEdit)source;
            if (null == bd) {
                return;
            }
            String fieldKey = bd.getFieldKey();
            if (StringUtils.isEmpty((String)fieldKey)) {
                return;
            }
            if (Objects.equals(propEnt, fieldKey)) {
                FormShowParameter formShowParameter = evt.getFormShowParameter();
                if (null == formShowParameter) {
                    return;
                }
                formShowParameter.setCaption(captionName);
            }
        }
    }

    public static List<String> getPermDetailInAdminCharge(IFormView view, List<String> curPermDetail) {
        ArrayList<String> chargePermDetail = new ArrayList<String>(10);
        List adminChargeApps = AdminPermCache.getAdminChargeApps((Long)RequestContext.get().getCurrUserId(), null);
        if (adminChargeApps.isEmpty()) {
            return curPermDetail;
        }
        HashSet<String> appNotInCharge = new HashSet<String>(10);
        for (String permDetail : curPermDetail) {
            String[] arr = permDetail.split("    ");
            String appId = arr[5];
            if (adminChargeApps.contains(appId)) {
                chargePermDetail.add(permDetail);
                continue;
            }
            appNotInCharge.add(appId);
        }
        String notInChargeAppMes = PermFormCommonUtil.getNotInChargeAppMes(!chargePermDetail.isEmpty(), appNotInCharge, ResManager.loadKDString((String)"\u79fb\u9664", (String)"PermFormCommonUtil_5", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((String)notInChargeAppMes)) {
            view.showErrorNotification(notInChargeAppMes);
        }
        return chargePermDetail;
    }

    public static String getNotInChargeAppMes(boolean partSuccess, Set<String> appNotInCharge, String operationName) {
        if (CollectionUtils.isEmpty(appNotInCharge)) {
            return null;
        }
        int dontChargeAppCount = appNotInCharge.size();
        StringBuilder builder = new StringBuilder();
        if (partSuccess) {
            String mes = String.format(ResManager.loadKDString((String)"%1$s\u6210\u529f", (String)"PermFormCommonUtil_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), operationName);
            builder.append(mes).append("\uff0c");
        }
        int threshold = Math.min(dontChargeAppCount, 3);
        if (dontChargeAppCount <= 3) {
            builder.append(ResManager.loadKDString((String)"\u5e94\u7528", (String)"PermFormCommonUtil_1", (String)"bos-permission-formplugin", (Object[])new Object[0])).append("\uff1a");
        }
        Map allAppIdNameMap = AppHelper.getAllAppIdNameMap(appNotInCharge);
        Collection appNames = allAppIdNameMap.values();
        int count = 0;
        for (String appName : appNames) {
            builder.append("\u201c").append(appName).append("\u201d\uff0c");
            if (++count != threshold) continue;
            break;
        }
        builder.deleteCharAt(builder.length() - 1);
        if (dontChargeAppCount > 3) {
            builder.append(String.format(ResManager.loadKDString((String)"\u7b49%1$s\u4e2a\u5e94\u7528", (String)"PermFormCommonUtil_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), dontChargeAppCount));
        }
        builder.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5728\u5f53\u524d\u7528\u6237\u6240\u5728\u7ba1\u7406\u5458\u5206\u7ec4\u5e94\u7528\u7ba1\u8f96\u8303\u56f4\u5185\uff0c\u65e0\u6cd5%1$s\u3002", (String)"PermFormCommonUtil_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), operationName));
        return builder.toString();
    }

    public static String getOperationRuleEntity() {
        return "bos_billorgtpl";
    }

    public static Set<String> parseFilterGrid(String rule) {
        if (StringUtils.isEmpty((String)rule)) {
            return new HashSet<String>(0);
        }
        rule = PermCommonUtil.replaceBackSlach((String)rule);
        JSONObject jsonObj = JSONObject.parseObject((String)rule);
        JSONArray jsonArray = jsonObj.getJSONArray("filterRow");
        HashSet<String> fields = new HashSet<String>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject filterRow = (JSONObject)jsonArray.getObject(i, JSONObject.class);
            String fieldName = filterRow.getString("fieldName");
            int pointIndex = fieldName.indexOf(46);
            if (pointIndex > 0) {
                fieldName = fieldName.substring(0, pointIndex);
            }
            fields.add(fieldName);
        }
        return fields;
    }

    public static void cancelShowFormDataRights(List<Map<String, String>> appEntityList) {
        if (CollectionUtils.isEmpty(appEntityList) || !PermCommonUtil.isEnableAuthorityChangeNotice()) {
            return;
        }
        try {
            List sessionIds = SessionQuery.getUserSessions((String)RequestContext.get().getAccountId());
            HashSet<Long> userIdSet = new HashSet<Long>(128);
            for (SessionInfo sessionInfo : sessionIds) {
                Long userId = Long.parseLong(sessionInfo.getUserId());
                userIdSet.add(userId);
            }
            FormConfigFactory.cancelShowFormDataRights(new ArrayList(userIdSet), appEntityList);
        }
        catch (Exception e) {
            logger.warn("[PermFormCommonUtil.cancelShowFormDataRights]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
        }
    }
}

