/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermPageCacheUtil {
    private IPageCache pageCache;
    public static final String KEYLIST = "PermPageCache_KeyList";

    public PermPageCacheUtil(IPageCache pPageCache) {
        this.pageCache = pPageCache;
        this.addExtraKey();
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    private void addExtraKey() {
        List<String> keyList = this.getKeyList();
        if (keyList != null && keyList.size() == 0) {
            keyList.add("CustomFilter_OrgIds");
            keyList.add("CustomFilter_DimObjIds");
            keyList.add("CustomFilter_UserIds");
            keyList.add("CustomFilter_RoleIds");
            keyList.add("CustomQFilter_DimObjIds");
            keyList.add("CustomQFilter_UserIds");
            keyList.add("CustomQFilter_RoleIds");
            this.pageCache.put(KEYLIST, SerializationUtils.toJsonString(keyList));
        }
    }

    public String get(String key) {
        return this.pageCache.get(key);
    }

    public String getBigObject(String key) {
        return this.pageCache.getBigObject(key);
    }

    public List<String> getKeyList() {
        List keyList = null;
        String keyListValue = this.pageCache.get(KEYLIST);
        keyList = StringUtils.isNotEmpty((String)keyListValue) ? (List)SerializationUtils.fromJsonString((String)keyListValue, List.class) : new ArrayList();
        return keyList;
    }

    public void put(String key, String value) {
        this.pageCache.put(key, value);
        List<String> keyList = this.getKeyList();
        if (!keyList.contains(key)) {
            keyList.add(key);
        }
        this.pageCache.put(KEYLIST, SerializationUtils.toJsonString(keyList));
    }

    public void putBigObject(String key, String value) {
        this.pageCache.putBigObject(key, value);
        List<String> keyList = this.getKeyList();
        if (!keyList.contains(key)) {
            keyList.add(key);
        }
        this.pageCache.put(KEYLIST, SerializationUtils.toJsonString(keyList));
    }

    public void remove(String key) {
        this.pageCache.remove(key);
        List<String> keyList = this.getKeyList();
        keyList.remove(key);
        this.pageCache.put(KEYLIST, SerializationUtils.toJsonString(keyList));
    }

    public void removeBig(List<String> keys) {
        keys.forEach(x -> this.pageCache.removeBigObject(x));
        List<String> keyList = this.getKeyList();
        keyList.removeAll(keys);
        this.pageCache.put(KEYLIST, SerializationUtils.toJsonString(keyList));
    }

    public void removeAllCustomCache() {
        List<String> allCustomKeyList = this.getKeyList();
        for (String key : allCustomKeyList) {
            this.pageCache.remove(key);
        }
        allCustomKeyList = new ArrayList<String>();
        this.pageCache.put(KEYLIST, SerializationUtils.toJsonString(allCustomKeyList));
    }

    public void removeSpecCache(String keyPart) {
        List<String> allCustomKeyList = this.getKeyList();
        Iterator<String> iterator = allCustomKeyList.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.contains(keyPart)) continue;
            this.pageCache.remove(key);
            iterator.remove();
        }
        this.pageCache.put(KEYLIST, SerializationUtils.toJsonString(allCustomKeyList));
    }
}

