/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.util;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DbInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FieldName;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterBuilderParameter;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.DrHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.query.ChoiceFieldPageCustomQuery;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.enums.EnumsFieldPermCtrlMode;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermQueryReportUtil {
    private static Log logger = LogFactory.getLog(PermQueryReportUtil.class);
    private static final String[] VALUE = new String[]{"''", "''", "''", "''", "''"};
    private static final String[] FIELD_NAME = new String[]{"propkey", "ctrlfield", "ctrlmode", "ctrlfieldtype", "fieldscheme"};

    public static void setCloudFilterForStdBlackList(BasedataEdit cloudF7) {
        List<String> filterCloudIds = PermFormCommonUtil.getCloudIdsFromStdBlackList();
        if (!CollectionUtils.isEmpty(filterCloudIds)) {
            cloudF7.addBeforeF7SelectListener(listener -> {
                ListShowParameter params = (ListShowParameter)listener.getFormShowParameter();
                List filters = params.getListFilterParameter().getQFilters();
                filters.add(new QFilter("id", "not in", (Object)filterCloudIds));
            });
        }
    }

    public static void setBizObjectFilter(BasedataEdit objectTypeCtrl, IDataModel dataModel, String appKey) {
        objectTypeCtrl.addBeforeF7SelectListener(listener -> {
            ListShowParameter params = (ListShowParameter)listener.getFormShowParameter();
            List filters = params.getListFilterParameter().getQFilters();
            DynamicObjectCollection appList = (DynamicObjectCollection)dataModel.getValue(appKey);
            Set<String> allbizObjByApps = PermQueryReportUtil.getAllBizObjByAppListIncludeExt(appList);
            List<String> formNumsFromStdBlackList = PermFormCommonUtil.getFormNumsFromStdBlackList();
            if (!CollectionUtils.isEmpty(formNumsFromStdBlackList)) {
                allbizObjByApps.removeAll(formNumsFromStdBlackList);
            }
            filters.add(new QFilter("id", "in", allbizObjByApps));
            List<String> appIdsFromStdBlackList = PermFormCommonUtil.getAppIdsFromStdBlackList();
            if (!CollectionUtils.isEmpty(appIdsFromStdBlackList)) {
                filters.add(new QFilter("bizappid", "not in", appIdsFromStdBlackList));
            }
        });
    }

    public static void setPermItemFilter(BasedataEdit permItemF7, IDataModel dataModel, String entityKey) {
        permItemF7.addBeforeF7SelectListener(listener -> {
            ListShowParameter params = (ListShowParameter)listener.getFormShowParameter();
            List filters = params.getListFilterParameter().getQFilters();
            DynamicObjectCollection entList = (DynamicObjectCollection)dataModel.getValue(entityKey);
            if (entList == null || entList.isEmpty()) {
                return;
            }
            ArrayList<String> entIds = new ArrayList<String>(entList.size());
            for (DynamicObject entity : entList) {
                entIds.add(entity.get("fbasedataid_id") + "");
            }
            DynamicObjectCollection permItemObjCol = QueryServiceHelper.query((String)"perm_functionperm", (String)"permitem", (QFilter[])new QFilter[]{new QFilter("entitytype", "in", entIds)});
            if (permItemObjCol == null || permItemObjCol.isEmpty()) {
                return;
            }
            HashSet<String> permItemIds = new HashSet<String>(permItemObjCol.size());
            for (DynamicObject permItemObj : permItemObjCol) {
                permItemIds.add(permItemObj.getString("permitem"));
            }
            filters.add(new QFilter("id", "in", permItemIds));
        });
    }

    public static void setAppFilter(BasedataEdit appF7, IDataModel dataModel, String cloudKey) {
        appF7.addBeforeF7SelectListener(listener -> {
            List<String> appIdsFromStdBlackList;
            ListShowParameter params = (ListShowParameter)listener.getFormShowParameter();
            List filters = params.getListFilterParameter().getQFilters();
            DynamicObjectCollection cloudList = (DynamicObjectCollection)dataModel.getValue(cloudKey);
            List<Object> allAppsByCloud = PermQueryReportUtil.getAllAppsByCloudList(cloudList);
            filters.add(new QFilter("id", "in", allAppsByCloud));
            List<String> cloudIdsFromStdBlackLists = PermFormCommonUtil.getCloudIdsFromStdBlackList();
            if (!CollectionUtils.isEmpty(cloudIdsFromStdBlackLists)) {
                filters.add(new QFilter("cloud", "not in", cloudIdsFromStdBlackLists));
            }
            if (!CollectionUtils.isEmpty(appIdsFromStdBlackList = PermFormCommonUtil.getAppIdsFromStdBlackList())) {
                filters.add(new QFilter("id", "not in", appIdsFromStdBlackList));
            }
        });
    }

    public static List<Object> getAllAppsByCloudList(DynamicObjectCollection cloudList) {
        ArrayList<Object> appIdList = new ArrayList<Object>();
        ArrayList<String> appIdListForDel = new ArrayList<String>();
        ArrayList<Object> cloudIdList = new ArrayList<Object>();
        for (DynamicObject dynamicObject : cloudList) {
            String number = (String)dynamicObject.get(2);
            QFilter numberFilter = new QFilter("id", "=", (Object)number);
            DynamicObject cloud = QueryServiceHelper.queryOne((String)"bos_devportal_bizcloud", (String)"id", (QFilter[])new QFilter[]{numberFilter});
            if (cloud == null) continue;
            cloudIdList.add(cloud.get("id"));
        }
        QFilter cloudfilter = new QFilter("bizcloud_id", "in", cloudIdList);
        QFilter statusfilter = new QFilter("deploystatus", "=", (Object)"2");
        QFilter visiblefilter = new QFilter("visible", "=", (Object)Character.valueOf('1'));
        QFilter[] filters = null;
        filters = cloudIdList.size() > 0 ? new QFilter[]{cloudfilter, statusfilter, visiblefilter} : new QFilter[]{statusfilter, visiblefilter};
        DynamicObjectCollection lst = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,masterid", (QFilter[])filters);
        for (DynamicObject dynamicObject : lst) {
            String id = dynamicObject.getString("id");
            String masterid = dynamicObject.getString("masterid");
            appIdList.add(id);
            if (kd.bos.orm.util.StringUtils.isEmpty((Object)masterid)) continue;
            appIdListForDel.add(masterid);
        }
        appIdList.removeAll(appIdListForDel);
        return appIdList;
    }

    public static Set<String> getAllBizObjByAppListIncludeExt(DynamicObjectCollection appList) {
        final HashSet<Object> appIdList = new HashSet<Object>(8);
        HashSet<String> addSet = new HashSet<String>(8);
        String param = "";
        if (!appList.isEmpty()) {
            for (Object dynamicObject : appList) {
                appIdList.add(dynamicObject.get(2));
            }
            final StringBuilder appParam = new StringBuilder();
            for (Object e : appIdList) {
                appParam.append('\'').append(e).append('\'').append(',');
            }
            appParam.deleteCharAt(appParam.length() - 1);
            param = appParam.toString();
            StringBuilder extAppId = new StringBuilder();
            extAppId.append("select finheritpath from t_meta_bizapp");
            extAppId.append(" where fid in (").append(param).append(')').append(" and finheritpath <> ' ' ");
            DB.query((DBRoute)DBRoute.meta, (String)extAppId.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

                public Void handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        String[] split;
                        String inheritPath = rs.getString("finheritpath");
                        for (String appId : split = inheritPath.split(",")) {
                            appIdList.add(appId);
                            appParam.append(",'").append(appId).append('\'');
                        }
                    }
                    return null;
                }
            });
            param = appParam.toString();
        }
        String sql = "select fbizobjid from t_perm_bizobjapp ";
        if (!appList.isEmpty()) {
            sql = sql + " where fbizappid in ( " + param + ")";
        }
        DB.query((DBRoute)DBRoute.permission, (String)sql, resultSet -> {
            while (resultSet.next()) {
                addSet.add(resultSet.getString("fbizobjid"));
            }
            return null;
        });
        sql = "select fid from t_meta_mainentityinfo ";
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)param)) {
            sql = sql + " where fbizappid in ( " + param + ")";
        }
        DB.query((DBRoute)DBRoute.meta, (String)sql, resultSet -> {
            while (resultSet.next()) {
                addSet.add(resultSet.getString("fid"));
            }
            return null;
        });
        return addSet;
    }

    public static void addF7Filter(BasedataEdit cloudF7, BasedataEdit appF7, BasedataEdit entityF7, BasedataEdit permItemF7, BasedataEdit userF7, IDataModel model, Map<String, String> fieldNumMap) {
        if (cloudF7 != null) {
            PermQueryReportUtil.setCloudFilterForStdBlackList(cloudF7);
        }
        if (appF7 != null) {
            PermQueryReportUtil.setAppFilter(appF7, model, fieldNumMap.get("cloudfilter"));
        }
        if (entityF7 != null) {
            PermQueryReportUtil.setBizObjectFilter(entityF7, model, fieldNumMap.get("appfilter"));
        }
        if (permItemF7 != null) {
            PermQueryReportUtil.setPermItemFilter(permItemF7, model, fieldNumMap.get("entityfilter"));
        }
        if (userF7 != null) {
            userF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("externalUserType", (Object)"all");
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> filter = new ArrayList<QFilter>(8);
                filter.add(new QFilter("enable", "=", (Object)"1"));
                filter.add(new QFilter("isforbidden", "=", (Object)"0"));
                formShowParameter.getListFilterParameter().getQFilters().addAll(filter);
            });
        }
    }

    public static String idListToStr(DynamicObjectCollection objList) {
        if (objList == null || objList.isEmpty()) {
            return "('')";
        }
        StringBuilder sb = new StringBuilder("(");
        for (DynamicObject obj : objList) {
            sb.append('\'').append(obj.get("id")).append('\'').append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        return sb.toString();
    }

    public static void appendFilters(StringBuilder sql, String filter, String alias, String colName) {
        if (!filter.equals("('')")) {
            sql.append(String.format(" and %s.%s in ", alias, colName)).append(filter);
        }
    }

    public static void appendFilters(StringBuilder sql, String selectDimType, String orgFilter, Long dim, String alias, String colName) {
        if ("bos_org".equals(selectDimType)) {
            if (!"('')".equals(orgFilter)) {
                sql.append(String.format(" and %s.%s in ", alias, colName)).append(orgFilter);
            }
        } else if (dim != 0L) {
            sql.append(String.format(" and %s.%s = ", alias, colName)).append(dim);
        }
    }

    public static List<String> getFilterEntityNums(DynamicObjectCollection col) {
        if (col == null || col.isEmpty()) {
            return null;
        }
        Set entityNumSet = col.stream().map(obj -> obj.getString("id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(entityNumSet)) {
            return null;
        }
        final ArrayList<String> entityNums = new ArrayList<String>(col.size());
        String entityNumStr = String.join((CharSequence)"','", entityNumSet);
        StringBuilder sql = new StringBuilder();
        sql.append("select fnumber from t_meta_formdesign  where fid in ");
        sql.append("(select  fmasterid from t_meta_formdesign where fnumber in ('");
        sql.append(entityNumStr).append("')").append(" and fmasterid != ' ' )");
        sql.append(" union ");
        sql.append("select  fnumber from t_meta_formdesign where fnumber in ('");
        sql.append(entityNumStr);
        sql.append("') and fmasterid = ' ' ");
        DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String number = rs.getString("fnumber");
                    entityNums.add(number);
                }
                return null;
            }
        });
        return entityNums;
    }

    public static String getFilterEntityNumsStr(DynamicObjectCollection col) {
        List<String> filterEntityNums = PermQueryReportUtil.getFilterEntityNums(col);
        if (CollectionUtils.isEmpty(filterEntityNums)) {
            return "('')";
        }
        StringBuilder sb = new StringBuilder("(");
        for (String entityNum : filterEntityNums) {
            sb.append('\'').append(entityNum).append('\'').append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        return sb.toString();
    }

    public static List<String> getFilterAppIds(DynamicObjectCollection objList) {
        if (CollectionUtils.isEmpty((Collection)objList)) {
            return new ArrayList<String>(1);
        }
        Set appIdSet = objList.stream().map(obj -> obj.getString("id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(appIdSet)) {
            return new ArrayList<String>(1);
        }
        final ArrayList<String> appIdList = new ArrayList<String>(appIdSet.size());
        String appIdStr = String.join((CharSequence)"','", appIdSet);
        StringBuilder sql = new StringBuilder();
        sql.append("select fid, fmasterid from t_meta_bizapp");
        sql.append(" where fid in ('").append(appIdStr).append("')");
        DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    String fmasterid = rs.getString("fmasterid");
                    appIdList.add(kd.bos.util.StringUtils.isEmpty((String)fmasterid) ? fid : fmasterid);
                }
                return null;
            }
        });
        return appIdList;
    }

    public static String getFilterAppIdsStr(DynamicObjectCollection col) {
        List<String> filterAppIds = PermQueryReportUtil.getFilterAppIds(col);
        if (CollectionUtils.isEmpty(filterAppIds)) {
            return "('')";
        }
        StringBuilder sb = new StringBuilder("(");
        for (String appid : filterAppIds) {
            sb.append('\'').append(appid).append('\'').append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        return sb.toString();
    }

    public static DataSet getCloudAndAppDs(String appFilter, String cloudFilter, String algoKey) {
        String localeName = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select app.fid as appid, apprtl.fname as app, ").append(" cloudl.fname as cloud ").append("from t_meta_bizapp app ").append("left join t_meta_appruntime_l apprtl on (apprtl.fappid = app.fnumber and apprtl.flocaleid = ?) ").append("left join t_meta_bizapp_l appl on (appl.fid = app.fid and appl.flocaleid = ?) ").append("join t_meta_bizcloud cloud on app.fbizcloudid=cloud.fid ").append("left join t_meta_bizcloud_l cloudl on (cloudl.fid = cloud.fid and cloudl.flocaleid = ?) where 1=1 ");
        PermQueryReportUtil.appendFilters(sql, appFilter, "app", "fid");
        PermQueryReportUtil.appendFilters(sql, cloudFilter, "cloud", "fid");
        Object[] params = new Object[]{localeName, localeName, localeName};
        return DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params);
    }

    public static DataSet getDimInfoDs(String selectDimType, String orgFilter, Long dim, String algoKey) {
        if (selectDimType.equals("bos_org")) {
            StringBuilder sql = new StringBuilder("select org.fid as dimid,org.fnumber as dimtypenum, ").append("case when orgl.fname is null or orgl.fname = '' or orgl.fname = ' ' ").append("then org.fname ").append("else orgl.fname ").append("end as dimtypename ").append("from t_org_org org ").append("left join t_org_org_l orgl on (org.fid = orgl.fid and orgl.flocaleid = ?) ").append("where 1=1 ");
            PermQueryReportUtil.appendFilters(sql, orgFilter, "org", "fid");
            return DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])new Object[]{RequestContext.get().getLang().name()});
        }
        BasedataEntityType dataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)selectDimType);
        String numberProperty = dataEntityType.getNumberProperty();
        String nameProperty = dataEntityType.getNameProperty();
        QFilter qFilter = null;
        if (!dim.equals(0L)) {
            qFilter = new QFilter("id", "=", (Object)dim);
        }
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)selectDimType, (String)("id as dimid," + numberProperty + " as dimtypenum ," + nameProperty + " as dimtypename"), (QFilter[])new QFilter[]{qFilter}, null);
    }

    public static DataSet orderByAndFilterResult(ReportQueryParam reportQueryParam, DataSet result, String[] defaultSort) {
        result = result.distinct();
        String sortInfo = reportQueryParam.getSortInfo();
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)sortInfo)) {
            if (defaultSort == null || defaultSort.length == 0) {
                result = result.orderBy(new String[]{sortInfo});
            } else {
                String[] sortInfoArr = new String[defaultSort.length + 1];
                sortInfoArr[0] = sortInfo;
                System.arraycopy(defaultSort, 0, sortInfoArr, 1, defaultSort.length + 1 - 1);
                result = result.orderBy(sortInfoArr);
            }
        } else if (defaultSort != null && defaultSort.length != 0) {
            result = result.orderBy(defaultSort);
        }
        List filters = reportQueryParam.getFilter().getHeadFilters();
        if (!filters.isEmpty()) {
            for (QFilter qFilter : filters) {
                String property = qFilter.getProperty();
                String convertToAlgoExpression = qFilter.tryConvertToAlgoExpression();
                if (Objects.equals("starttime", property) || Objects.equals("endtime", property) && kd.bos.util.StringUtils.isNotEmpty((String)convertToAlgoExpression)) {
                    HashMap<String, Object> params = new HashMap<String, Object>(8);
                    StringBuilder express = new StringBuilder();
                    PermQueryReportUtil.getMyDateConvertToAlgoExpression(express, params, qFilter, 1);
                    result = result.filter(express.toString(), params);
                    continue;
                }
                result = result.filter(convertToAlgoExpression);
            }
        }
        return result;
    }

    private static void getMyDateConvertToAlgoExpression(StringBuilder express, Map<String, Object> params, QFilter qFilter, int varIndex) {
        String property = qFilter.getProperty();
        String cp = qFilter.getCP();
        Object value = qFilter.getValue();
        if (varIndex > 1) {
            express.append(" AND ");
        }
        String keyStr = "var" + varIndex;
        express.append(property).append(cp).append(keyStr);
        if (Objects.equals("=", cp)) {
            params.put(keyStr, DateUtil.toDate((String)((String)value), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            params.put(keyStr, value);
        }
        List nests = qFilter.getNests(true);
        if (null == nests || nests.isEmpty()) {
            return;
        }
        for (QFilter.QFilterNest qFilterNest : nests) {
            QFilter filter = qFilterNest.getFilter();
            if (null == filter) continue;
            PermQueryReportUtil.getMyDateConvertToAlgoExpression(express, params, filter, ++varIndex);
        }
    }

    public static void fieldPermDataHandle(DynamicObject rowData, DynamicObject entity) {
        HashMap hasLoadMap;
        String fieldName;
        String ctrlField = rowData.getString("ctrlfield");
        if (kd.bos.orm.util.StringUtils.isEmpty((Object)ctrlField) || entity == null) {
            return;
        }
        String entityNum = entity.getString("number");
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)entityNum) && !kd.bos.orm.util.StringUtils.isEmpty((Object)(fieldName = FormHelper.getEntityFieldName(hasLoadMap = new HashMap(8), (String)entityNum, (String)ctrlField)))) {
            rowData.set("ctrlField", (Object)fieldName);
        }
    }

    public static void dataRuleHandle(DynamicObject rowData, DynamicObject entity) {
        String ruleField;
        String entityNum;
        boolean isDataRule = rowData.containsProperty("propkey");
        if (isDataRule) {
            String[] split;
            if (null == entity) {
                return;
            }
            entityNum = entity.getString("number");
            ruleField = "datarule";
            String propkey = rowData.getString("propkey");
            if (!"-".equals(propkey) && (split = propkey.split(",")).length == 2) {
                String propKeyName = PermQueryReportUtil.getPropKeyName(entityNum, split[1]);
                entityNum = split[0];
                rowData.set("propkey", (Object)propKeyName);
            }
        } else {
            entityNum = entity == null ? "bos_billorgtpl" : entity.getString("number");
            ruleField = "oprule";
        }
        String ruleJson = rowData.getString(ruleField);
        if (kd.bos.util.StringUtils.isNotEmpty((String)ruleJson) && kd.bos.util.StringUtils.isNotEmpty((String)entityNum) && ruleJson.contains("filterRow")) {
            FilterBuilder builder;
            MainEntityType entityType;
            FilterCondition condition;
            try {
                condition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleJson, FilterCondition.class);
            }
            catch (Exception e) {
                logger.debug("PermQueryReportUtil.dataRuleHandle.ruleJson:" + e.getMessage());
                return;
            }
            List beforeFilterRow = condition.getFilterRow();
            if (null == beforeFilterRow || beforeFilterRow.isEmpty()) {
                return;
            }
            HashMap<Integer, SimpleFilterRow> map = new HashMap<Integer, SimpleFilterRow>(8);
            int size = beforeFilterRow.size();
            for (int i = 0; i < size; ++i) {
                SimpleFilterRow filterRow = (SimpleFilterRow)beforeFilterRow.get(i);
                String compareType = filterRow.getCompareType();
                if (!compareType.contains("perm_myhasright_")) continue;
                map.put(i, filterRow.clone());
            }
            try {
                entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
            }
            catch (Exception e1) {
                logger.error((Throwable)e1);
                return;
            }
            condition = PermCommonUtil.replaceMyHasRight((String)"", (MainEntityType)entityType, (FilterCondition)condition, (boolean)false);
            FilterBuilderParameter fbp = new FilterBuilderParameter(entityType, condition);
            fbp.setNeedParse(false);
            try {
                builder = new FilterBuilder(fbp);
            }
            catch (Exception e) {
                logger.debug("PermQueryReportUtil.dataRuleHandle.FilterBuilder:" + e.getMessage());
                return;
            }
            builder.setTimeService((ITimeService)new TimeService());
            builder.setUserService((IUserService)new UserService());
            builder.buildFilter();
            FilterObject filterObject = builder.getFilterObject();
            String rule = PermCommonUtil.filterObjectToString((FilterObject)filterObject);
            if (kd.bos.util.StringUtils.isEmpty((String)rule)) {
                return;
            }
            if (map.isEmpty()) {
                rowData.set(ruleField, (Object)rule);
                return;
            }
            PermCtrlTypeReq req = new PermCtrlTypeReq(null, (Set)Sets.newHashSet((Object[])new String[]{"1"}), null, null, null);
            Map permCtrlTypeMap = IsoDimHelper.getEntPermCtrlTypeMap((PermCtrlTypeReq)req);
            List logics = filterObject.getFilterMetaData().getLogics();
            String andLogicName = ((LogicOperate)logics.get(0)).getName();
            String orLogicName = ((LogicOperate)logics.get(1)).getName();
            String ruleOri = rule;
            rule = rule.replaceAll(andLogicName, "@@");
            rule = rule.replaceAll(orLogicName, "@@");
            String[] split = rule.split("@@");
            String myHasRightPrefixDesc = DrHelper.getMyHasRightPrefixDesc();
            for (Map.Entry kk : map.entrySet()) {
                String dimType;
                PermCtrlType permCtrlType;
                SimpleFilterRow value;
                String compareType;
                Integer key = (Integer)kk.getKey();
                String splitIdxStr = split[key];
                if (null == splitIdxStr || kd.bos.util.StringUtils.isEmpty((String)splitIdxStr) || !(compareType = (value = (SimpleFilterRow)kk.getValue()).getCompareType()).contains("perm_myhasright_") || null == (permCtrlType = (PermCtrlType)permCtrlTypeMap.get(dimType = compareType.replace("perm_myhasright_", "")))) continue;
                String fieldCaption = PermQueryReportUtil.getFieldCaption(value.getFieldName(), filterObject);
                String replacement = fieldCaption + " " + myHasRightPrefixDesc + permCtrlType.getName();
                splitIdxStr = splitIdxStr.trim();
                splitIdxStr = splitIdxStr.replace("( ", "");
                splitIdxStr = splitIdxStr.replace("(( ", "");
                splitIdxStr = splitIdxStr.replace("((( ", "");
                splitIdxStr = splitIdxStr.replace(" )", "");
                splitIdxStr = splitIdxStr.replace(" ))", "");
                splitIdxStr = splitIdxStr.replace(" )))", "");
                ruleOri = ruleOri.replace(splitIdxStr, replacement);
            }
            rowData.set(ruleField, (Object)ruleOri);
        }
    }

    private static String getFieldCaption(String fieldName, FilterObject filterObject) {
        String fieldCaption = "";
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return fieldCaption;
        }
        FieldName fieldNameObj = EntityTypeUtil.getORMFieldName((String)fieldName, (EntityType)filterObject.getDataType());
        fieldCaption = fieldNameObj != null && fieldNameObj.getFieldCaption() != null ? fieldNameObj.getFieldCaption().toString() : fieldName;
        return fieldCaption;
    }

    private static String getPropKeyName(String entNum, String propKey) {
        LocaleString displayName;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entNum);
        if (dataEntityType == null) {
            return propKey;
        }
        IDataEntityProperty property = dataEntityType.findProperty(propKey);
        if (property != null && (displayName = property.getDisplayName()) != null) {
            return displayName.toString();
        }
        List maps = new ChoiceFieldPageCustomQuery().parseProperty((IDataEntityType)dataEntityType);
        for (Map map : maps) {
            String key = (String)map.get("field_id");
            if (!propKey.equals(key)) continue;
            return (String)map.get("field_name");
        }
        return propKey;
    }

    public static DataSet getRoleFieldPermDs(String roleFilter, String appFilter, String entityFilter, int controlMode) {
        String localeName = RequestContext.get().getLang().name();
        String cantReadText = ResManager.loadKDString((String)"\u7981\u6b62\u67e5\u770b", (String)"PermQueryReportUtil_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        String cantWriteText = ResManager.loadKDString((String)"\u7981\u6b62\u7f16\u8f91", (String)"PermQueryReportUtil_1", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        String invalidText = ResManager.loadKDString((String)"\u975e\u6cd5\u503c", (String)"PermQueryReportUtil_2", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        Object[] params = new Object[]{localeName};
        Algo algo = Algo.create((String)"PermQueryReportUtil.getRolePermDS");
        ArrayList<Field> permFields = new ArrayList<Field>(8);
        permFields.add(new Field("roleid", (DataType)DataType.StringType));
        permFields.add(new Field("funcpermitem", (DataType)DataType.StringType));
        permFields.add(new Field("appid", (DataType)DataType.StringType));
        permFields.add(new Field("entity", (DataType)DataType.StringType));
        permFields.add(new Field("datarulepermitem", (DataType)DataType.StringType));
        permFields.add(new Field("datarulename", (DataType)DataType.StringType));
        permFields.add(new Field("datarule", (DataType)DataType.StringType));
        permFields.add(new Field("propkey", (DataType)DataType.StringType));
        permFields.add(new Field("ctrlfield", (DataType)DataType.StringType));
        permFields.add(new Field("ctrlmode", (DataType)DataType.StringType));
        permFields.add(new Field("ctrlfieldtype", (DataType)DataType.StringType));
        permFields.add(new Field("fieldscheme", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(permFields.toArray(new Field[0]));
        StringBuilder sql = new StringBuilder();
        sql.append("select rfp.froleid as roleid,'' as funcpermitem,fpd.fbizappid as appid,fpd.fentitytypeid as entity,").append("'' as datarulepermitem,'' as datarulename,'' as datarule,'' as propkey,fpd.ffieldname as ctrlfield,").append(" fpd.fcontrolmode as ctrlmode, ").append("'' as ctrlfieldtype,'' as fieldscheme ").append("from t_perm_rolefieldperm rfp ").append("join t_perm_fieldpermdetail fpd on (rfp.ffieldpermid = fpd.fid) ").append("where 1=1 ");
        PermQueryReportUtil.appendFilters(sql, roleFilter, "rfp", "froleid");
        PermQueryReportUtil.appendFilters(sql, entityFilter, "fpd", "fentitytypeid");
        PermQueryReportUtil.appendFilters(sql, appFilter, "fpd", "fbizappid");
        if (controlMode != 1) {
            sql.append(" and fpd.fcontrolmode = '").append(controlMode).append("'");
        } else {
            sql.append(" and fpd.fcontrolmode <> ").append("'0'");
        }
        DbInput roleFieldPermInput = new DbInput("PermQueryReportUtil.roleFieldPermInput", DBRoute.permission.getRouteKey(), sql.toString(), null, rowMeta);
        sql.setLength(0);
        sql.append("select rfs.froleid as roleid,'' as funcpermitem,rfs.fappid as appid,rfs.fentnum as entity,").append("'' as datarulepermitem,'' as datarulename,'' as datarule,'' as propkey,'' as ctrlfield, ").append(" fs.fcontrolmode as ctrlmode, ").append("fs.fcontrolfieldtype as ctrlfieldtype, ").append("case when fsl.fname is null or fsl.fname = '' or fsl.fname = ' ' ").append("then fs.fname else fsl.fname end as fieldscheme ").append("from t_perm_rolefieldscheme rfs ").append("join t_perm_fieldscheme fs on rfs.ffieldpermschemeid = fs.fid ").append("left join t_perm_fieldscheme_l fsl on (fs.fid = fsl.fid and fsl.flocaleid = ?) ").append("where fs.fenable = '1' and fs.ffieldfrom = '1' ");
        PermQueryReportUtil.appendFilters(sql, roleFilter, "rfs", "froleid");
        PermQueryReportUtil.appendFilters(sql, entityFilter, "rfs", "fentnum");
        PermQueryReportUtil.appendFilters(sql, appFilter, "rfs", "fappid");
        if (controlMode != 1) {
            sql.append(" and fs.fcontrolmode = '").append(controlMode).append("'");
        } else {
            sql.append(" and fs.fcontrolmode <> ").append("'0'");
        }
        DbInput roleFieldSchemeTypeInput = new DbInput("PermQueryReportUtil.roleFieldSchemeTypeInput", DBRoute.permission.getRouteKey(), sql.toString(), params, rowMeta);
        sql.setLength(0);
        sql.append("select rfs.froleid as roleid,'' as funcpermitem,rfs.fappid as appid,rfs.fentnum as entity,").append("'' as datarulepermitem,'' as datarulename,'' as datarule,'' as propkey,fsd.ffieldname as ctrlfield,").append(" fsd.fcontrolmode as ctrlmode, ").append("'' as ctrlfieldtype, ").append("case when fsl.fname is null or fsl.fname = '' or fsl.fname = ' ' ").append("then fs.fname else fsl.fname end as fieldscheme ").append("from t_perm_rolefieldscheme rfs ").append("join t_perm_fieldscheme fs on rfs.ffieldpermschemeid = fs.fid ").append("left join t_perm_fieldscheme_l fsl on (fs.fid = fsl.fid and fsl.flocaleid = ?) ").append("join t_perm_fieldschemed fsd on fs.fid = fsd.fid ").append("where fs.fenable = '1' and fs.ffieldfrom = '2' ");
        PermQueryReportUtil.appendFilters(sql, roleFilter, "rfs", "froleid");
        PermQueryReportUtil.appendFilters(sql, entityFilter, "rfs", "fentnum");
        PermQueryReportUtil.appendFilters(sql, appFilter, "rfs", "fappid");
        if (controlMode != 1) {
            sql.append(" and fsd.fcontrolmode = '").append(controlMode).append("'");
        } else {
            sql.append(" and fsd.fcontrolmode <> ").append("'0'");
        }
        DbInput roleFieldSchemeDetailInput = new DbInput("PermQueryReportUtil.roleFieldSchemeDetailInput", DBRoute.permission.getRouteKey(), sql.toString(), params, rowMeta);
        try (DataSet tempDS = algo.createDataSet(new Input[]{roleFieldPermInput, roleFieldSchemeTypeInput, roleFieldSchemeDetailInput});){
            RowMeta tempDSRowMeta = tempDS.getRowMeta();
            Algo roleFieldPermAlgo = Algo.create((String)"PermQueryReportUtil.getRoleFieldPermDs");
            DataSetBuilder builder = roleFieldPermAlgo.createDataSetBuilder(tempDSRowMeta);
            while (tempDS.hasNext()) {
                Row row = tempDS.next();
                String controlModeStr = row.getString("ctrlmode");
                controlModeStr = EnumsFieldPermCtrlMode.FORBID_VIEW.getType().equals(controlModeStr) ? cantReadText : (EnumsFieldPermCtrlMode.FORBID_EDIT.getType().equals(controlModeStr) ? cantWriteText : invalidText);
                builder.append(new Object[]{row.get(0), row.get(1), row.get(2), row.get(3), row.get(4), row.get(5), row.get(6), row.get(7), row.get(8), controlModeStr, row.get(10), row.get(11)});
            }
            DataSet dataSet = builder.build();
            return dataSet;
        }
    }

    /*
     * Exception decompiling
     */
    public static DataSet getRolePermDS(String roleFilter, String appFilter, String entityFilter, String permFilter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static DataSet getFuncAndDataRuleDs2(String roleFilter, String appFilter, String entityFilter, String permFilter, DataSetBuilder dataSetBuilder, String localeName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static DataSet getRoleDataRuleDS(String roleFilter, String appFilter, String entityFilter, String permFilter, String localeName) {
        StringBuilder roleDataRuleSql = new StringBuilder();
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        if (hasEnableRoleDataRuleNewModel) {
            roleDataRuleSql.append("select rdr.froleid as roleid2,rdr.fappid as appid2,rdr.fentitynum as entity2,rdr.fpermitemid as datarulepermitem,").append("case when drl.fname is null or drl.fname = '' or drl.fname = ' ' ").append("then dr.fname else drl.fname end as datarulename, ").append("dr.frule as datarule ").append("from t_perm_roledatarule rdr ").append("join t_perm_datarule dr on (rdr.fdataruleid = dr.fid and dr.fenable = '1') ").append("left join t_perm_datarule_l drl on (dr.fid = drl.fid and drl.flocaleid = ? ) ").append("where 1=1 ");
            PermQueryReportUtil.appendFilters(roleDataRuleSql, roleFilter, "rdr", "froleid");
            PermQueryReportUtil.appendFilters(roleDataRuleSql, permFilter, "rdr", "fpermitemid");
            PermQueryReportUtil.appendFilters(roleDataRuleSql, entityFilter, "rdr", "fentitynum");
            PermQueryReportUtil.appendFilters(roleDataRuleSql, appFilter, "rdr", "fappid");
        } else {
            roleDataRuleSql.append("select rdrs.froleid as roleid2,drse.fbizappid as appid2,drse.fentitynum as entity2,dre.fpermitemid as datarulepermitem,").append("case when drl.fname is null or drl.fname = '' or drl.fname = ' ' ").append("then dr.fname else drl.fname end as datarulename, ").append("dr.frule as datarule ").append("from t_perm_roledatarules rdrs ").append("join t_perm_datarules_entry drse on (rdrs.fdatarulesid = drse.fid) ").append("join t_perm_datarule_entry dre on (drse.fdataruleid = dre.fid) ").append("join t_perm_datarule dr on (dre.fdataruleid = dr.fid and dr.fisdetail = '1' and dr.fenable = '1') ").append("left join t_perm_datarule_l drl on (dr.fid = drl.fid and drl.flocaleid = ? ) ").append("where 1=1 ");
            PermQueryReportUtil.appendFilters(roleDataRuleSql, roleFilter, "rdrs", "froleid");
            PermQueryReportUtil.appendFilters(roleDataRuleSql, permFilter, "dre", "fpermitemid");
            PermQueryReportUtil.appendFilters(roleDataRuleSql, entityFilter, "drse", "fentitynum");
            PermQueryReportUtil.appendFilters(roleDataRuleSql, appFilter, "drse", "fbizappid");
        }
        return DB.queryDataSet((String)"PermQueryReportUtil.getRoleDataRuleDS", (DBRoute)DBRoute.permission, (String)roleDataRuleSql.toString(), (Object[])new Object[]{localeName});
    }

    private static DataSet getRoleFuncPermDS(String roleFilter, String appFilter, String entityFilter, String permFilter) {
        StringBuilder roleFuncPermSql = new StringBuilder();
        roleFuncPermSql.append("select rpd.froleid as roleid,rpd.fbizappid as appid,rpd.fentitytypeid as entity, rpd.fpermitemid as funcpermitem ").append("from t_perm_rolepermdetial rpd where 1=1 ");
        PermQueryReportUtil.appendFilters(roleFuncPermSql, roleFilter, "rpd", "froleid");
        PermQueryReportUtil.appendFilters(roleFuncPermSql, permFilter, "rpd", "fpermitemid");
        PermQueryReportUtil.appendFilters(roleFuncPermSql, entityFilter, "rpd", "fentitytypeid");
        PermQueryReportUtil.appendFilters(roleFuncPermSql, appFilter, "rpd", "fbizappid");
        return DB.queryDataSet((String)"PermQueryReportUtil.getRoleFuncPermDS", (DBRoute)DBRoute.permission, (String)roleFuncPermSql.toString());
    }

    public static String updateAppFilterIfOnlyCloud(String cloudFilter, String appFilter) {
        if (!cloudFilter.equals("('')") && appFilter.equals("('')")) {
            StringBuilder sql = new StringBuilder();
            sql.append("select app.fid as appid ").append("from t_meta_bizapp app ").append("join t_meta_bizcloud cloud on app.fbizcloudid=cloud.fid ").append("where cloud.fid in ").append(cloudFilter);
            String appIdsFilter = (String)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet resultSet) throws Exception {
                    StringBuilder appIdFilter = new StringBuilder("(");
                    while (resultSet.next()) {
                        String appId = resultSet.getString("appid");
                        appIdFilter.append('\'').append(appId).append('\'').append(',');
                    }
                    appIdFilter.deleteCharAt(appIdFilter.length() - 1);
                    appIdFilter.append(')');
                    return appIdFilter.toString();
                }
            });
            if (!")".equals(appIdsFilter)) {
                appFilter = appIdsFilter;
            }
        }
        return appFilter;
    }

    public static DataSet getSelDimTypeEntity(String selectDimType, String entityFilter) {
        String upperCaseDimType = PermCommonUtil.getSuitableDimType((String)selectDimType)[0];
        StringBuilder sql = new StringBuilder();
        sql.append("select fnumber as entity from t_meta_entity where fkey = 'CtrlType' and ftype = ").append(RuntimeMetaType.PermissionControlType.getValue()).append(" and (fdata like '%DIM_NULL%' or fdata like '%").append(upperCaseDimType).append("%') ");
        if (!"('')".equals(entityFilter)) {
            sql.append(" and fnumber in ").append(entityFilter);
        }
        return DB.queryDataSet((String)"PermQueryReportUtil_getSelDimTypeEntity", (DBRoute)DBRoute.meta, (String)sql.toString());
    }

    public static void loadFieldNumMap(Map<String, String> fieldNumMap, String entityId) {
        if (!fieldNumMap.isEmpty()) {
            return;
        }
        String USER_PERM_REPORT = "userspermreport";
        String PERM_FIELDPERM_REPORT = "perm_fieldperm_report";
        String PERM_DATARULE_REPORT = "perm_datarule_report";
        String ROLE_PERM_REPORT = "role_perm_report";
        String BIZROLE_PERM_REPORT = "bizrole_perm_report";
        fieldNumMap.put("selectdimtype", "selectdimtype");
        fieldNumMap.put("orgfilter", "orgfilter");
        fieldNumMap.put("dimfilter", "dimfilter");
        fieldNumMap.put("userfilter", "userfilter");
        fieldNumMap.put("cloudfilter", "cloudfilter");
        fieldNumMap.put("appfilter", "appfilter");
        fieldNumMap.put("entityfilter", "entityfilter");
        fieldNumMap.put("permitemfilter", "permitemfilter");
        fieldNumMap.put("selectpermstatus", "selectpermstatus");
        if ("userspermreport".equals(entityId) || "perm_fieldperm_report".equals(entityId) || "perm_datarule_report".equals(entityId) || "bizrole_perm_report".equals(entityId)) {
            fieldNumMap.put("orgfilter", "orgs");
            fieldNumMap.put("dimfilter", "dims");
            fieldNumMap.put("userfilter", "users");
            fieldNumMap.put("appfilter", "apps");
            fieldNumMap.put("entityfilter", "objecttypes");
            fieldNumMap.put("permitemfilter", "permfilter");
        } else if ("role_perm_report".equals(entityId)) {
            fieldNumMap.put("cloudfilter", "selectcloud");
            fieldNumMap.put("appfilter", "selectapp");
            fieldNumMap.put("entityfilter", "selectentitytype");
            fieldNumMap.put("permitemfilter", "selectperm");
        }
    }

    public static int getUserRolePermDataCount(Map<String, Object> params) {
        if (CollectionUtils.isEmpty(params)) {
            return 0;
        }
        StringBuilder whereStr = new StringBuilder();
        String dimType = (String)params.get("selectDimType");
        PermQueryReportUtil.appendFilters(whereStr, (String)params.get("userFilter"), "ur", "fuserid");
        PermQueryReportUtil.appendFilters(whereStr, dimType, (String)params.get("orgFilter"), (Long)params.get("dim"), "ur", "forgid");
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from t_perm_userrole ur where ur.fdimtype = ? ").append((CharSequence)whereStr);
        int userRoleCount = (Integer)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{dimType}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt(1);
            }
            return 0;
        });
        if (userRoleCount == 0) {
            return 0;
        }
        sql.setLength(0);
        sql.append("select distinct froleid from t_perm_userrole ur where ur.fdimtype = ? ").append((CharSequence)whereStr);
        List roleIds = (List)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{dimType}, resultSet -> {
            ArrayList<String> result = new ArrayList<String>(10);
            while (resultSet.next()) {
                result.add(resultSet.getString("froleid"));
            }
            return result;
        });
        StringBuilder roleIdsStr = new StringBuilder("(");
        for (String roleId : roleIds) {
            roleIdsStr.append('\'').append(roleId).append('\'').append(',');
        }
        roleIdsStr.deleteCharAt(roleIdsStr.length() - 1);
        roleIdsStr.append(')');
        whereStr.setLength(0);
        PermQueryReportUtil.appendFilters(whereStr, (String)params.get("permFilter"), "rpd", "fpermitemid");
        PermQueryReportUtil.appendFilters(whereStr, (String)params.get("entityFilter"), "rpd", "fentitytypeid");
        PermQueryReportUtil.appendFilters(whereStr, (String)params.get("appFilter"), "rpd", "fbizappid");
        sql.setLength(0);
        sql.append("select count(1) from t_perm_rolepermdetial rpd where rpd.froleid in ").append((CharSequence)roleIdsStr).append((CharSequence)whereStr);
        int rolePermDetailCount = (Integer)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt(1);
            }
            return 0;
        });
        if (rolePermDetailCount == 0) {
            return 0;
        }
        int avgPermDetailCountPerRole = rolePermDetailCount / roleIds.size();
        return userRoleCount * avgPermDetailCountPerRole;
    }

    @Deprecated
    public static void writeLog(String bizAppId, String entityId, String opName, String opDesc) {
        PermCommonUtil.addLog((String)opName, (String)opDesc, (String)entityId, null, null, (String)bizAppId);
    }
}

