/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.permission.formplugin.enumeration.PermTreeLevel;
import kd.bos.permission.formplugin.util.AllFuncPermTreeUtil;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermTreeUtil {
    public static final int RECURSIVE_MAXLEVEL = PermTreeLevel.FIFTH.getIntLevel() + 1;

    public static void trimSubNode(TreeNode allNode, int delLevel) {
        PermTreeLevel level = PermTreeLevel.findPermTreeLevel(delLevel);
        allNode.iterate(delLevel, n -> {
            if (n.getId().contains("#" + (Object)((Object)level))) {
                n.setChildren(new ArrayList());
            }
        });
    }

    public static TreeNode copyNewTreeNode(TreeNode oldTree) {
        boolean isParent = oldTree.getChildren() != null;
        TreeNode newTree = new TreeNode(oldTree.getParentid(), oldTree.getId(), oldTree.getText(), isParent, oldTree.getData());
        if (isParent) {
            List oldChildList = oldTree.getChildren();
            int oldChildListSize = oldChildList.size();
            ArrayList<TreeNode> newChildList = new ArrayList<TreeNode>(oldChildListSize);
            for (int i = 0; i < oldChildListSize; ++i) {
                TreeNode newChildNode = PermTreeUtil.copyNewTreeNode((TreeNode)oldChildList.get(i));
                newChildList.add(newChildNode);
            }
            newTree.setChildren(newChildList);
        } else {
            newTree.setChildren(null);
        }
        return newTree;
    }

    public static int getTreeNodeLevel(String treeNodeId) {
        String suffix = treeNodeId.substring(treeNodeId.indexOf(35));
        int level = -1;
        if (suffix.equals(AllFuncPermTreeUtil.NODESUFFIX_FIRST)) {
            level = 0;
        } else if (suffix.equals("#cloud")) {
            level = 1;
        } else if (suffix.equals("#app")) {
            level = 2;
        } else if (suffix.equals("#entity")) {
            level = 3;
        } else if (suffix.equals("#permItem")) {
            level = 4;
        }
        return level;
    }

    public static List<AppMenuElement> getSortedMenuList(String appId) {
        ArrayList<AppMenuElement> listMenuNode = BizAppServiceHelp.getAllAppMenusByAppID((String)appId);
        Collections.sort(listMenuNode, new Comparator<AppMenuElement>(){

            @Override
            public int compare(AppMenuElement ame1, AppMenuElement ame2) {
                return ame1.getSeq() - ame2.getSeq();
            }
        });
        ArrayList<AppMenuElement> allLevelOneMenu = new ArrayList<AppMenuElement>();
        Iterator iterator = listMenuNode.iterator();
        while (iterator.hasNext()) {
            AppMenuElement appMenuElement = (AppMenuElement)iterator.next();
            String parentId = appMenuElement.getParentId();
            if (!StringUtils.isEmpty((String)parentId) && !appId.equals(parentId)) continue;
            allLevelOneMenu.add(appMenuElement);
            iterator.remove();
        }
        int allLevelOneMenuSize = allLevelOneMenu.size();
        ArrayList<AppMenuElement> newListMenuNode = new ArrayList<AppMenuElement>(allLevelOneMenuSize);
        for (int i = 0; i < allLevelOneMenuSize; ++i) {
            AppMenuElement levelOneMenu = (AppMenuElement)allLevelOneMenu.get(i);
            String curMenuId = levelOneMenu.getId();
            newListMenuNode.add(levelOneMenu);
            Iterator iterator2 = listMenuNode.iterator();
            while (iterator2.hasNext()) {
                AppMenuElement levelTwoMenu = (AppMenuElement)iterator2.next();
                String parentId = levelTwoMenu.getParentId();
                if (!curMenuId.equals(parentId)) continue;
                newListMenuNode.add(levelTwoMenu);
                iterator2.remove();
            }
        }
        listMenuNode = newListMenuNode;
        return listMenuNode;
    }
}

