/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.domainsplit.form;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.facade.FacadeResult;
import kd.bos.facade.form.IFormLifecycleFacade;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoCheckDataPermissionArgs;
import kd.bos.form.operate.Copy;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.Modify;
import kd.bos.form.operate.New;
import kd.bos.form.operate.View;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.OrgHelper;
import kd.bos.permission.cache.helper.OrgViewSchemaHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.model.Org;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.CheckDimObjParam;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.utils.DbTypeConverter;

public class PermFormFacadeImpl
implements IFormLifecycleFacade {
    private static Log log = LogFactory.getLog(PermFormFacadeImpl.class);
    private static final String PERMISSION = "permission";
    private static final String SYSTEM = "bos-mservice-permission";
    private FormOperate formOperate = null;
    private IFormView formView = null;
    private OperateOption option = null;
    private OperationResult operationResult = null;
    private String realEntityId = "";
    private String permissionItemId = "";
    private String operateKey = null;
    private boolean needSelectData = false;
    private LocaleString operateName = null;
    private String entityId = "";
    private Long mainOrgId = null;
    private ListSelectedRowCollection listSelectedData = null;
    private List<ListSelectedRow> checkRightRows = null;
    private static final String PERM_IGNORE_CHECKAPP = "PERM_IGNORE_CHECKAPP";

    public FacadeResult hasRight(Map<String, Object> map) {
        FacadeResult facadeResult = new FacadeResult();
        facadeResult.setCode(1);
        this.formOperate = (FormOperate)map.get("formOperate");
        this.formView = this.formOperate.getView();
        FormShowParameter fsp = this.formView.getFormShowParameter();
        Object skipAllOpCheckRightObj = fsp.getCustomParam("FormOperate_SkipAllOpCheckRight");
        Object skipCheckPermItemIdsObj = fsp.getCustomParam("FormOperate_SkipCheckPermItemIds");
        Boolean skipAllOpCheckRight = null;
        if (skipAllOpCheckRightObj instanceof Boolean) {
            skipAllOpCheckRight = (Boolean)skipAllOpCheckRightObj;
        }
        List skipCheckPermItemIds = null;
        if (skipCheckPermItemIdsObj instanceof List) {
            skipCheckPermItemIds = (List)skipCheckPermItemIdsObj;
        }
        this.operateKey = this.formOperate.getOperateKey();
        this.option = this.formOperate.getOption();
        this.entityId = this.formOperate.getEntityId();
        this.needSelectData = this.formOperate.needSelectData();
        this.operateName = this.formOperate.getOperateName();
        this.listSelectedData = this.formOperate.getListSelectedData();
        this.permissionItemId = (String)map.get("permissionItemId");
        this.operationResult = (OperationResult)map.get("operationResult");
        this.realEntityId = (String)map.get("realEntityId");
        this.mainOrgId = (Long)map.get("mainOrgId");
        if (log.isInfoEnabled()) {
            log.debug("OperateKey={}, permissionItemId={}", (Object)this.operateKey, (Object)this.permissionItemId);
        }
        Set permissionItems = EntityMetadataCache.getPermissionItems((String)this.realEntityId);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.realEntityId);
        if (!mainEntityType.getPermissionControlType().isControlFunction() || permissionItems == null || permissionItems.isEmpty()) {
            return facadeResult;
        }
        if (mainEntityType.getPermissionControlType().isAnonymousUserControl() && RequestContext.get().getUserId().equalsIgnoreCase("-1")) {
            return facadeResult;
        }
        boolean isHasRight = Boolean.parseBoolean(this.option.getVariableValue("ishasright", String.valueOf(false)));
        if (isHasRight) {
            log.info("PermFormFacadeImpl.hasRight: option set ishasright = true, pass");
            return facadeResult;
        }
        if (Boolean.TRUE.equals(skipAllOpCheckRight)) {
            log.info("PermFormFacadeImpl.hasRight: FormShowParameter set skipAllOpCheckRight = true, pass");
            this.option.setVariableValue("ishasright", String.valueOf(true));
            String checkRightAppId = this.getCheckRightAppId();
            this.option.setVariableValue("currbizappid", checkRightAppId);
            this.option.setVariableValue("skipCheckDataPermission", String.valueOf(true));
            return facadeResult;
        }
        if (StringUtils.isBlank((CharSequence)this.permissionItemId)) {
            boolean formShowParahasRight;
            if (this.formOperate instanceof Save) {
                boolean addNew;
                DynamicObject dataEntity = this.formOperate.getView().getModel().getDataEntity(true);
                boolean bl = addNew = !dataEntity.getDataEntityState().getFromDatabase();
                if (addNew) {
                    if (permissionItems.contains("47156aff000000ac")) {
                        this.permissionItemId = "47156aff000000ac";
                    }
                } else if (permissionItems.contains("4715a0df000000ac")) {
                    this.permissionItemId = "4715a0df000000ac";
                }
            } else if (this.formOperate instanceof Modify) {
                if (permissionItems.contains("4715a0df000000ac")) {
                    this.permissionItemId = "4715a0df000000ac";
                    log.info("Not found modify permission in OperteContext, reset permissionItemId to PermItemConst.ITEM_MODIFY ");
                } else if (permissionItems.contains("47150e89000000ac")) {
                    this.permissionItemId = "47150e89000000ac";
                    log.info("Not found modify permission in OperteContext, reset permissionItemId to PermItemConst.ITEM_VIEW");
                }
            } else if (this.formOperate instanceof View) {
                if (permissionItems.contains("47150e89000000ac")) {
                    this.permissionItemId = "47150e89000000ac";
                    log.info("Not found view permission in OperteContext, reset permissionItemId to PermItemConst.ITEM_VIEW");
                }
            } else if (this.formOperate instanceof Refresh && permissionItems.contains("47150e89000000ac")) {
                this.permissionItemId = "47150e89000000ac";
                log.info("Not found Refresh permission in OperteContext, reset permissionItemId to PermItemConst.ITEM_VIEW");
            }
            if ("47150e89000000ac".equals(this.permissionItemId) && (formShowParahasRight = this.formView.getFormShowParameter().isHasRight())) {
                log.info("PermFormFacadeImpl.hasRight: check view permission when formShowParameter is 'HasRight'. pass checkPerm.");
                return facadeResult;
            }
            if (StringUtils.isBlank((CharSequence)this.permissionItemId)) {
                log.info("PermFormFacadeImpl.hasRight: operate does not bind permissionItem, pass checkPerm.");
                return facadeResult;
            }
        }
        if (skipCheckPermItemIds != null && !skipCheckPermItemIds.isEmpty() && skipCheckPermItemIds.contains(this.permissionItemId)) {
            log.info("PermFormFacadeImpl.hasRight: FormShowParameter set skipCheckPermItemIds contains '" + this.permissionItemId + "', pass");
            this.option.setVariableValue("ishasright", String.valueOf(true));
            String checkRightAppId = this.getCheckRightAppId();
            this.option.setVariableValue("currbizappid", checkRightAppId);
            this.option.setVariableValue("skipCheckDataPermission", String.valueOf(true));
            return facadeResult;
        }
        if (this.formOperate instanceof New) {
            int ret;
            String checkRightAppId;
            long userId = RequestContext.get().getCurrUserId();
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            boolean hasPerm = permissionService.checkPermission(userId, checkRightAppId = this.getCheckRightAppId(), this.realEntityId, this.permissionItemId);
            int n = ret = hasPerm ? 1 : 0;
            if (ret == 0) {
                String msg = this.getNoPermMsg();
                ValidateResult validateResult = new ValidateResult();
                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
                validateResult.addErrorInfo((OperateErrorInfo)info);
                this.operationResult.setSuccess(false);
                this.operationResult.getValidateResult().addValidateError(PERMISSION, validateResult);
                AppLogInfo logInfo = this.buildLogInfo(msg, this.mainOrgId);
                this.addNewOperLog(logInfo);
                facadeResult.setCode(ret);
            }
            return facadeResult;
        }
        this.option.setVariableValue("ishasright", String.valueOf(true));
        String checkRightAppId = this.getCheckRightAppId();
        this.option.setVariableValue("currbizappid", checkRightAppId);
        if (this.formView instanceof IListView) {
            this.checkRightInListForm(mainEntityType, this.operationResult);
        } else if (this.formView instanceof IBillView) {
            this.checkRightInBillForm(mainEntityType, this.operationResult);
        } else {
            this.checkRightInDynamicForm(mainEntityType, this.operationResult);
        }
        if (!this.operationResult.isSuccess()) {
            this.option.removeVariable("ishasright");
            facadeResult.setCode(0);
            return facadeResult;
        }
        return facadeResult;
    }

    private void addNewOperLog(AppLogInfo logInfo) {
        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u8d8a\u6743\u8bbf\u95ee", "PermFormFacadeImpl_6", SYSTEM);
        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", "PermFormFacadeImpl_0", SYSTEM);
        String curEntityName = FormMetadataCache.getFormConfig((String)this.entityId).getCaption().toString();
        String permItemName = PermItemHelper.getPermItemNameById((String)this.permissionItemId);
        String[] opDescParam = new String[]{curEntityName, permItemName};
        String opNameZh_CN = null == this.operateName ? "" : this.operateName.getLocaleValue_zh_CN();
        PermCommonUtil.addLog((String)this.operateKey, (String)opNameZh_CN, (String)logInfo.getBizObjID(), null, (String)"0", (String)this.operateKey, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)logInfo.getOpDescription(), (Date)logInfo.getOpTime(), (String)logInfo.getClientIP(), (String)logInfo.getBizAppID());
    }

    private String getNoPermMsg() {
        String curEntityName = FormMetadataCache.getFormConfig((String)this.entityId).getCaption().toString();
        String permItemName = PermItemHelper.getPermItemNameById((String)this.permissionItemId);
        String finalMsg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PermFormFacadeImpl_0", (String)SYSTEM, (Object[])new Object[0]), curEntityName, permItemName);
        return finalMsg;
    }

    protected int checkRightInBillForm(MainEntityType mainEntityType, OperationResult result) {
        int hasRight = this.checkRightInDynamicForm(mainEntityType, result);
        if (!result.isSuccess()) {
            this.option.removeVariable("ishasright");
            return 0;
        }
        this.doDataRuleCheckInBill(mainEntityType, result);
        return hasRight;
    }

    private void doDataRuleCheckInBill(MainEntityType mainEntityType, OperationResult result) {
        if (mainEntityType == null) {
            return;
        }
        Object pkId = null;
        FormShowParameter showParameter = this.formView.getFormShowParameter();
        if (showParameter instanceof BillShowParameter) {
            BillShowParameter billParam = (BillShowParameter)showParameter;
            pkId = billParam.getPkId();
        }
        if (pkId == null) {
            pkId = this.formView.getModel().getDataEntity().getPkValue();
        }
        if (pkId == null) {
            return;
        }
        int dbType = mainEntityType.getPrimaryKey().getDbType();
        pkId = DbTypeConverter.safeConvert((int)dbType, (Object)pkId);
        BeforeDoCheckDataPermissionArgs checkArgs = new BeforeDoCheckDataPermissionArgs(this.formOperate);
        checkArgs.setPkId(pkId);
        this.commonCheckDataRule(mainEntityType, result, checkArgs, new Object[]{pkId}, null);
    }

    protected int checkRightInDynamicForm(MainEntityType mainEntityType, OperationResult result) {
        String dimType = mainEntityType.getPermissionControlType().getDimension();
        String dimFldKey = mainEntityType.getPermissionControlType().getDataDimensionField();
        String dimAssistFldKey = mainEntityType.getPermissionControlType().getDataAssistDimensionField();
        if (StringUtils.isNotBlank((CharSequence)dimFldKey) && mainEntityType.findProperty(dimFldKey) == null) {
            dimFldKey = null;
        }
        if (StringUtils.isNotBlank((CharSequence)dimAssistFldKey) && mainEntityType.findProperty(dimAssistFldKey) == null) {
            dimAssistFldKey = null;
        }
        ArrayList<CheckDimObjParam> dimObjParamList = new ArrayList<CheckDimObjParam>();
        CheckDimObjParam dimObjParam = new CheckDimObjParam();
        if (StringUtils.isNotBlank((CharSequence)dimAssistFldKey)) {
            DynamicObject tempAssistObjId = (DynamicObject)this.formView.getModel().getValue(dimAssistFldKey);
            long dimAssistObjId = tempAssistObjId == null ? 0L : tempAssistObjId.getLong("id");
            dimObjParam.setAssistDimensionOrg(dimAssistObjId);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_ORG") && StringUtils.isBlank((CharSequence)dimFldKey) && StringUtils.isNotBlank((CharSequence)mainEntityType.getMainOrg())) {
            dimFldKey = mainEntityType.getMainOrg();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_NULL") || StringUtils.isBlank((CharSequence)dimFldKey)) {
            this.doPermission(result, this.permissionItemId, 0L, null);
        } else {
            IDataEntityProperty findProperty = mainEntityType.findProperty(dimFldKey);
            boolean isMulBdProp = findProperty instanceof MulBasedataProp;
            Object dimFieldObj = this.formView.getModel().getValue(dimFldKey);
            Object pkId = this.formView.getModel().getDataEntity().getPkValue();
            if (dimFieldObj instanceof DynamicObject) {
                DynamicObject tempObjId = (DynamicObject)dimFieldObj;
                long dimObjId = tempObjId == null ? 0L : tempObjId.getLong("id");
                dimObjParam.setDimensionOrg(dimObjId);
                dimObjParam.setId(pkId);
                dimObjParamList.add(dimObjParam);
            } else if (isMulBdProp && dimFieldObj instanceof DynamicObjectCollection) {
                DynamicObjectCollection rows = (DynamicObjectCollection)dimFieldObj;
                for (DynamicObject row : rows) {
                    Long bdId = row.getLong("fbasedataid_id");
                    if (bdId == null || Long.compare(0L, bdId) == 0) continue;
                    dimObjParam = new CheckDimObjParam();
                    dimObjParam.setDimensionOrg(bdId.longValue());
                    dimObjParam.setId(pkId);
                    dimObjParamList.add(dimObjParam);
                }
            }
            if (dimObjParam.getDimensionOrg() == null || dimObjParam.getDimensionOrg() == 0L || dimObjParamList.isEmpty()) {
                this.doPermission(result, this.permissionItemId, 0L, dimType);
            } else {
                this.doPermissionBatch(result, this.permissionItemId, dimObjParamList, mainEntityType);
            }
        }
        return 1;
    }

    protected List<ListSelectedRow> getCheckRightRowsInList() {
        ArrayList<ListSelectedRow> list = new ArrayList<ListSelectedRow>();
        if (this.listSelectedData != null) {
            list.addAll((Collection<ListSelectedRow>)this.listSelectedData);
        }
        return list;
    }

    protected int checkRightInListForm(MainEntityType mainEntityType, OperationResult result) {
        if (!this.needSelectData) {
            PermissionControlType permissionControlType = mainEntityType.getPermissionControlType();
            String dimType = permissionControlType.getDimension();
            this.doPermission(result, this.permissionItemId, 0L, dimType);
        } else {
            this.checkRightRows = this.getCheckRightRowsInList();
            if (CollectionUtils.isEmpty(this.checkRightRows)) {
                this.doPermission(result, this.permissionItemId, 0L, null);
            } else {
                PermissionControlType permissionControlType = mainEntityType.getPermissionControlType();
                String dimType = permissionControlType.getDimension();
                String dimFldKey = permissionControlType.getDataDimensionField();
                String dimAssitFldKey = permissionControlType.getDataAssistDimensionField();
                if (StringUtils.isNotBlank((CharSequence)dimFldKey) && mainEntityType.findProperty(dimFldKey) == null) {
                    dimFldKey = null;
                }
                if (StringUtils.isNotBlank((CharSequence)dimAssitFldKey) && mainEntityType.findProperty(dimAssitFldKey) == null) {
                    dimAssitFldKey = null;
                }
                HashSet<Long> dimFldValues = new HashSet<Long>();
                IPageCache pageCache = (IPageCache)this.formView.getService(IPageCache.class);
                String verifyOrg = pageCache.get("verifyOrg");
                if (verifyOrg != null && verifyOrg.trim().length() > 0) {
                    dimFldValues.add(Long.parseLong(verifyOrg));
                    for (Long orgId : dimFldValues) {
                        this.doPermission(result, this.permissionItemId, orgId, null);
                    }
                    return 1;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_ORG") || StringUtils.isBlank((CharSequence)dimFldKey)) {
                    dimType = "DIM_ORG";
                    if (StringUtils.isNotBlank((CharSequence)mainEntityType.getMainOrg())) {
                        dimFldKey = mainEntityType.getMainOrg();
                    }
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_NULL") || StringUtils.isBlank((CharSequence)dimFldKey)) {
                    this.doPermission(result, this.permissionItemId, 0L, null);
                } else {
                    HashSet<Object> pkIds = new HashSet<Object>(16);
                    for (ListSelectedRow row : this.checkRightRows) {
                        Object pkId = row.getPrimaryKeyValue();
                        pkIds.add(pkId);
                    }
                    QFilter[] filters = new QFilter[]{pkIds.size() == 1 ? new QFilter("id", "=", pkIds.iterator().next()) : new QFilter("id", "in", (Object)pkIds.toArray())};
                    String algoKey = mainEntityType.getName();
                    String entityName = mainEntityType.getName();
                    String selectFields = "id";
                    if (StringUtils.isNotBlank((CharSequence)dimFldKey)) {
                        selectFields = selectFields + "," + dimFldKey;
                    }
                    if (dimAssitFldKey != null && StringUtils.isNotBlank((CharSequence)dimAssitFldKey) && !dimAssitFldKey.equals(dimFldKey)) {
                        selectFields = selectFields + "," + dimAssitFldKey;
                    }
                    String orderBys = null;
                    ORM orm = ORM.create();
                    ArrayList<CheckDimObjParam> dimObjParamList = new ArrayList<CheckDimObjParam>();
                    try (DataSet ds = orm.queryDataSet(algoKey, entityName, selectFields, filters, orderBys);){
                        DynamicObjectCollection objs = orm.toPlainDynamicObjectCollection(ds);
                        for (DynamicObject obj : objs) {
                            CheckDimObjParam dimObjParam = new CheckDimObjParam();
                            if (StringUtils.isNotBlank((CharSequence)dimFldKey)) {
                                dimObjParam.setDimensionOrg(obj.getLong(dimFldKey));
                                dimObjParam.setId(obj.get("id"));
                            }
                            if (dimAssitFldKey != null && StringUtils.isNotBlank((CharSequence)dimAssitFldKey) && !dimAssitFldKey.equals(dimFldKey)) {
                                dimObjParam.setAssistDimensionOrg(obj.getLong(dimAssitFldKey));
                            }
                            if (dimObjParam.getDimensionOrg() == null) continue;
                            dimObjParamList.add(dimObjParam);
                        }
                    }
                    if (!dimObjParamList.isEmpty()) {
                        this.doPermissionBatch(result, this.permissionItemId, dimObjParamList, mainEntityType);
                    } else {
                        this.doPermission(result, this.permissionItemId, 0L, dimType);
                    }
                }
            }
        }
        if (!result.isSuccess()) {
            this.option.removeVariable("ishasright");
            return 0;
        }
        this.doDataRuleCheckInList(mainEntityType, result);
        if (!result.isSuccess()) {
            return 0;
        }
        return 1;
    }

    private void doDataRuleCheckInList(MainEntityType mainEntityType, OperationResult result) {
        if (!this.needSelectData || this.listSelectedData.isEmpty()) {
            return;
        }
        BeforeDoCheckDataPermissionArgs checkArgs = new BeforeDoCheckDataPermissionArgs(this.formOperate);
        checkArgs.setListSelectedData(this.listSelectedData);
        if (this.formOperate != null && this.formOperate.getListFocusRow() != null) {
            if ("4715a0df000000ac".equals(this.permissionItemId) && this.formOperate instanceof Modify) {
                Object primaryKeyValue = this.formOperate.getListFocusRow().getPrimaryKeyValue();
                if (primaryKeyValue != null) {
                    this.commonCheckDataRule(mainEntityType, result, checkArgs, new Object[]{primaryKeyValue}, null);
                }
                return;
            }
            ListSelectedRowCollection listSelectedRows = this.formOperate.getListSelectedData();
            ArrayList<Object> primaryKeyValues = new ArrayList<Object>(listSelectedRows.size());
            HashMap<Object, String> pkBillNoMap = new HashMap<Object, String>(listSelectedRows.size());
            for (ListSelectedRow listSelectedRow : listSelectedRows) {
                Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                primaryKeyValues.add(primaryKeyValue);
                pkBillNoMap.put(primaryKeyValue, listSelectedRow.getBillNo());
            }
            if (!primaryKeyValues.isEmpty()) {
                this.commonCheckDataRule(mainEntityType, result, checkArgs, primaryKeyValues.toArray(), pkBillNoMap);
            }
        }
    }

    private void commonCheckDataRule(MainEntityType mainEntityType, OperationResult result, BeforeDoCheckDataPermissionArgs checkArgs, Object[] primaryKeyValues, Map<Object, String> pkBillNoMap) {
        if (!PermFormFacadeImpl.hasEnableOldDataRule()) {
            FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)this.formView.getService(FormViewPluginProxy.class);
            formViewPluginProxy.fireBeforeCheckDataPermission(checkArgs);
            if (checkArgs.isCancel()) {
                ValidateResult validateResult = new ValidateResult();
                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", checkArgs.getCancelMessage(), ErrorLevel.FatalError);
                validateResult.addErrorInfo((OperateErrorInfo)info);
                result.setSuccess(false);
                result.getValidateResult().addValidateError(PERMISSION, validateResult);
            }
            if (checkArgs.isSkipCheckDataPermission()) {
                this.option.getVariables().put("skipCheckDataPermission", "true");
            }
            if (!checkArgs.isSkipCheckDataPermission() && !checkArgs.isCancel() && this.isExtraFormOperate()) {
                String fatalErrorMsg;
                boolean existError;
                Map pkMatchMap;
                block13: {
                    long userId = RequestContext.get().getCurrUserId();
                    String bizAppId = this.formView.getFormShowParameter().getCheckRightAppId();
                    PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                    pkMatchMap = new HashMap(8);
                    existError = false;
                    fatalErrorMsg = null;
                    try {
                        pkMatchMap = permissionService.matchDataRule(userId, bizAppId, mainEntityType.getName(), this.permissionItemId, primaryKeyValues, null);
                    }
                    catch (KDException e) {
                        ErrorCode errorCode = e.getErrorCode();
                        if (errorCode == null) break block13;
                        if ("ERR_DATARULE_NOT_SUPPORTED_NOTVIEW_MULBD".equals(errorCode.getCode())) {
                            fatalErrorMsg = errorCode.getMessage();
                            this.formView.showErrorNotification(fatalErrorMsg);
                            existError = true;
                        }
                        throw e;
                    }
                }
                String entityName = mainEntityType.getDisplayName().getLocaleValue();
                result.setBillCount(primaryKeyValues.length);
                ValidateResult validateResult = new ValidateResult();
                ArrayList<String> errorBillNos = new ArrayList<String>(primaryKeyValues.length);
                for (Map.Entry entry : pkMatchMap.entrySet()) {
                    Object pkId = entry.getKey();
                    if (((Boolean)entry.getValue()).booleanValue()) continue;
                    existError = true;
                    if (pkBillNoMap == null) continue;
                    errorBillNos.add(pkBillNoMap.get(pkId));
                }
                if (existError) {
                    String errorMsg = null;
                    if (StringUtils.isNotBlank((CharSequence)fatalErrorMsg)) {
                        errorMsg = fatalErrorMsg;
                    } else if (primaryKeyValues.length > 1) {
                        String errorBillNosStr = ((Object)errorBillNos).toString();
                        String substring = errorBillNosStr.substring(1, errorBillNosStr.length() - 1);
                        errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u53ea\u6709\u5168\u90e8\u5355\u636e\u6ee1\u8db3\u3010%2$s\u3011\u3010%3$s\u3011\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\u624d\u53ef\u6210\u529f\u6267\u884c\u3002\u5176\u4e2d\u6709\u3010%4$s\u3011\u6761\u5355\u636e\u4e0d\u6ee1\u8db3\u6570\u636e\u89c4\u5219\uff0c\u5177\u4f53\u4e3a\uff1a%5$s\u3002", (String)"PermFormFacadeImpl_2", (String)SYSTEM, (Object[])new Object[0]), this.getLocaleOperateName(), entityName, PermItemHelper.getPermItemNameById((String)this.permissionItemId), errorBillNos.size(), substring);
                    } else {
                        errorMsg = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd%1$s\u3002\u60a8\u6ca1\u6709\u3010%2$s\u3011\u3010%3$s\u3011\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PermFormFacadeImpl_4", (String)SYSTEM, (Object[])new Object[0]), this.getLocaleOperateName(), entityName, PermItemHelper.getPermItemNameById((String)this.permissionItemId));
                    }
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "errorcode_001", this.getLocaleOperateName(), errorMsg, ErrorLevel.FatalError);
                    validateResult.addErrorInfo((OperateErrorInfo)info);
                    result.setSuccess(false);
                    result.getValidateResult().addValidateError(PERMISSION, validateResult);
                }
            }
        }
    }

    private static boolean hasEnableOldDataRule() {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"perm_olddataruleenable");
        Map rets = BusinessDataReader.loadFromCache((Object[])new Object[]{1L}, (DynamicObjectType)type, (boolean)false);
        DynamicObject dObj = (DynamicObject)rets.get(1L);
        if (dObj == null) {
            return true;
        }
        return dObj.getBoolean("enable_olddatarule");
    }

    private void doPermission(OperationResult result, String permissionItemId, long dimId, String dimType) {
        if (this.checkFunctionPermission(dimId, dimType, permissionItemId) != 1) {
            String msg = this.getNoPermMsg();
            ValidateResult validateResult = new ValidateResult();
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
            validateResult.addErrorInfo((OperateErrorInfo)info);
            result.setSuccess(false);
            result.getValidateResult().addValidateError(PERMISSION, validateResult);
            AppLogInfo logInfo = this.buildLogInfo(msg, this.mainOrgId);
            this.addNewOperLog(logInfo);
        }
    }

    private void doPermissionBatch(OperationResult result, String permissionItemId, List<CheckDimObjParam> dimObjParamList, MainEntityType mainEntityType) {
        if (!this.checkOrgBusiOperValid(result, permissionItemId, dimObjParamList)) {
            return;
        }
        ArrayList<CheckDimObjParam> tempDimObjParamList = new ArrayList<CheckDimObjParam>(dimObjParamList);
        List<CheckDimObjParam> checkList = this.checkFunctionPermissionBatch(permissionItemId, dimObjParamList);
        if (mainEntityType instanceof QueryEntityType) {
            HashSet<Object> pkIds = new HashSet<Object>(8);
            for (CheckDimObjParam checkDimObjParam : tempDimObjParamList) {
                Object pkId = checkDimObjParam.getId();
                pkIds.add(pkId);
            }
            if (checkList != null) {
                int checkListCount = checkList.size();
                if (checkListCount == 0) {
                    return;
                }
                tempDimObjParamList.removeAll(checkList);
                for (CheckDimObjParam tempParam : tempDimObjParamList) {
                    Object pkId = tempParam.getId();
                    pkIds.remove(pkId);
                }
            }
            if (!pkIds.isEmpty()) {
                String msg = this.getNoPermMsg();
                ValidateResult validateResult = new ValidateResult();
                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
                validateResult.addErrorInfo((OperateErrorInfo)info);
                result.setSuccess(false);
                result.getValidateResult().addValidateError(PERMISSION, validateResult);
                AppLogInfo logInfo = this.buildLogInfo(msg, this.mainOrgId);
                this.addNewOperLog(logInfo);
            }
        } else if (checkList == null || !checkList.isEmpty()) {
            String msg = this.getNoPermMsg();
            ValidateResult validateResult = new ValidateResult();
            ValidationErrorInfo validationErrorInfo = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
            validateResult.addErrorInfo((OperateErrorInfo)validationErrorInfo);
            result.setSuccess(false);
            result.getValidateResult().addValidateError(PERMISSION, validateResult);
            AppLogInfo logInfo = this.buildLogInfo(msg, this.mainOrgId);
            this.addNewOperLog(logInfo);
        }
    }

    private boolean checkOrgBusiOperValid(OperationResult result, String permissionItemId, List<CheckDimObjParam> dimObjParamList) {
        if (this.formOperate instanceof Copy && null != dimObjParamList && !dimObjParamList.isEmpty() && Objects.equals(1, dimObjParamList.size())) {
            CheckDimObjParam checkDimObjParam = dimObjParamList.get(0);
            if (null == checkDimObjParam) {
                return true;
            }
            Long dimId = checkDimObjParam.getDimensionOrg();
            if (null == dimId || Objects.equals(0L, dimId) || !"47156aff000000ac".equals(permissionItemId)) {
                return true;
            }
            String dimType = FormHelper.getPermissionControlType((String)this.realEntityId).getDimension();
            if ("bos_org".equals(dimType) || "DIM_ORG".equals(dimType)) {
                String viewNum = PermCommonUtil.getPermOrgViewScheme((String)this.realEntityId);
                long viewId = OrgViewSchemaHelper.getViewId((String)viewNum);
                ArrayList filterOrgList = Lists.newArrayList((Object[])new Long[]{dimId});
                String orgFunc = PermCommonUtil.getPermOrgFuncId((String)this.realEntityId);
                boolean orgOK = true;
                if ("01".equals(orgFunc)) {
                    List notFreezeList = OrgUnitServiceHelper.filterOrg((List)filterOrgList, (long)viewId, (boolean)false, (boolean)true);
                    if (!notFreezeList.contains(dimId)) {
                        orgOK = false;
                    }
                } else {
                    List enableList = OrgUnitServiceHelper.filterOrg((List)filterOrgList, (long)viewId, (boolean)true, (boolean)false);
                    if (enableList.contains(dimId)) {
                        List notFreezeList = OrgUnitServiceHelper.filterOrg((List)filterOrgList, (long)viewId, (boolean)false, (boolean)true);
                        if (!notFreezeList.contains(dimId)) {
                            orgOK = false;
                        }
                    } else {
                        orgOK = false;
                    }
                }
                if (!orgOK) {
                    Map orgMap = OrgHelper.getOrgMap((List)filterOrgList);
                    Org org = null == orgMap || orgMap.isEmpty() ? null : (Org)orgMap.get(dimId);
                    String orgName = null == org ? "" : org.getOrgName();
                    String msg = ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u7ecf\u7981\u7528\u6216\u804c\u80fd\u5c01\u5b58\uff0c\u4e0d\u80fd\u590d\u5236\u3002", (String)"PermFormFacadeImpl_5", (String)SYSTEM, (Object[])new Object[]{orgName});
                    ValidateResult validateResult = new ValidateResult();
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "001", "", msg, ErrorLevel.FatalError);
                    validateResult.addErrorInfo((OperateErrorInfo)info);
                    result.setSuccess(false);
                    result.getValidateResult().addValidateError(PERMISSION, validateResult);
                    return false;
                }
            }
        }
        return true;
    }

    protected AppLogInfo buildLogInfo(String msg, Long orgId) {
        AppInfo appInfo;
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        String appNumber = this.formView.getFormShowParameter().getAppId();
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppHelper.getMetaAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
            String billFormId = "";
            if (this.formView.getFormShowParameter() instanceof ListShowParameter) {
                ListShowParameter param = (ListShowParameter)this.formView.getFormShowParameter();
                billFormId = param.getBillFormId();
            } else if (this.formView.getFormShowParameter() instanceof BillShowParameter) {
                BillShowParameter param = (BillShowParameter)this.formView.getFormShowParameter();
                billFormId = param.getFormId();
            }
            if (StringUtils.isNotBlank((CharSequence)billFormId)) {
                appId = bizAppService.getAppIdByFormNum(billFormId);
            }
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(this.entityId);
        if (orgId != null && Long.compare(0L, orgId) != 0) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(this.getLocaleOperateName());
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    private String getLocaleOperateName() {
        String localeName = this.operateName.toString();
        return localeName == null ? "" : localeName;
    }

    protected int checkFunctionPermission(long dimId, String dimType, String permissionItemId) {
        boolean needIgnoreCheckApp;
        long userId = RequestContext.get().getCurrUserId();
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String bizAppId = this.getCheckRightAppId();
        Boolean ignoreCheckAppFlag = (Boolean)this.formView.getFormShowParameter().getCustomParam(PERM_IGNORE_CHECKAPP);
        boolean bl = needIgnoreCheckApp = StringUtils.isEmpty((CharSequence)bizAppId) || Boolean.TRUE.equals(ignoreCheckAppFlag);
        if (needIgnoreCheckApp) {
            bizAppId = "";
        }
        String dimensionType = "";
        dimensionType = StringUtils.isEmpty((CharSequence)dimType) ? (Objects.equals(0L, dimId) ? "DIM_NULL" : "DIM_ORG") : dimType;
        return permissionService.checkPermission(userId, dimensionType, dimId, bizAppId, this.realEntityId, permissionItemId);
    }

    protected List<CheckDimObjParam> checkFunctionPermissionBatch(String permissionItemId, List<CheckDimObjParam> dimObjParamList) {
        boolean needIgnoreCheckApp;
        long userId = RequestContext.get().getCurrUserId();
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String bizAppId = this.getCheckRightAppId();
        Boolean ignoreCheckAppFlag = (Boolean)this.formView.getFormShowParameter().getCustomParam(PERM_IGNORE_CHECKAPP);
        boolean bl = needIgnoreCheckApp = StringUtils.isEmpty((CharSequence)bizAppId) || Boolean.TRUE.equals(ignoreCheckAppFlag);
        if (needIgnoreCheckApp) {
            bizAppId = "";
        }
        return permissionService.checkPermissionBatch(Long.valueOf(userId), bizAppId, this.realEntityId, permissionItemId, dimObjParamList);
    }

    private String getCheckRightAppId() {
        Object customParam = this.formView.getFormShowParameter().getCustomParam(PERM_IGNORE_CHECKAPP);
        if (customParam != null && Boolean.TRUE.equals(customParam)) {
            return null;
        }
        String bizAppNumber = this.formView.getFormShowParameter().getCheckRightAppId();
        if (StringUtils.isNotBlank((CharSequence)bizAppNumber)) {
            AppInfo appInfo = AppHelper.getMetaAppInfo((String)bizAppNumber);
            return appInfo.getId();
        }
        return null;
    }

    private boolean isExtraFormOperate() {
        boolean view = this.formOperate instanceof View;
        boolean print = "4730fc9e000000ac".equals(this.permissionItemId);
        boolean push = "4730fc9f000002ae".equals(this.permissionItemId);
        boolean modifyOper = "4715a0df000000ac".equals(this.permissionItemId) && this.formOperate instanceof Modify;
        boolean newEntry = this.formOperate instanceof NewEntry && StringUtils.isNotEmpty((CharSequence)this.permissionItemId);
        boolean deleteEntry = this.formOperate instanceof DeleteEntry && StringUtils.isNotEmpty((CharSequence)this.permissionItemId);
        return modifyOper || view || print || push || newEntry || deleteEntry;
    }
}

