/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.duplicator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.util.StringUtils;

public class UserDisFunPermDuplicator {
    private static Log logger = LogFactory.getLog(UserDisFunPermDuplicator.class);

    public static void copy(Long sourceUserId, Long targetUserId) {
        String algoKey = UserDisFunPermDuplicator.class.getName();
        String perm_disfunperm = "perm_disfunperm";
        ORM orm = ORM.create();
        QFilter[] qFilters = new QFilter[]{new QFilter("user.id", "=", (Object)sourceUserId)};
        QFilter[] qFilters2 = new QFilter[]{new QFilter("user.id", "=", (Object)targetUserId)};
        try (DataSet sourceDS = orm.queryDataSet(algoKey, perm_disfunperm, "org.id, dimtype, bizapp.id, entitytype.id, permitem.id, includesuborg", qFilters);
             DataSet targetDS = orm.queryDataSet(algoKey, perm_disfunperm, "id, user.id, org.id, dimtype, bizapp.id, entitytype.id, permitem.id, includesuborg", qFilters2);
             DataSet preCopyDS = sourceDS.join(targetDS, JoinType.LEFT).on("org.id", "org.id").on("dimtype", "dimtype").on("permitem.id", "permitem.id").on("bizapp.id", "bizapp.id").on("entitytype.id", "entitytype.id").select(new String[]{"org.id", "dimtype", "bizapp.id", "entitytype.id", "permitem.id", "includesuborg"}, new String[]{"id as targetFId", "user.id as targetuser", "includesuborg as targetIncludesub"}).finish();){
            LinkedList insertList = new LinkedList();
            LinkedList<String> updateUserRoleFidList = new LinkedList<String>();
            HashMap<String, Object> innerMap = null;
            for (Row row : preCopyDS) {
                Boolean sourceIncludeSub = row.getBoolean("includesuborg");
                Boolean targetIncludesub = row.getBoolean("targetIncludesub");
                boolean finalIncludeSub = false;
                if (StringUtils.isEmpty((String)row.getString("targetuser"))) {
                    innerMap = new HashMap<String, Object>(8);
                    innerMap.put("forgid", row.get("org.id"));
                    innerMap.put("fuserid", targetUserId);
                    innerMap.put("fpermitemid", row.get("permitem.id"));
                    innerMap.put("fentitytypeid", row.get("entitytype.id"));
                    innerMap.put("fbizappid", row.get("bizapp.id"));
                    innerMap.put("fdimtype", row.get("dimtype"));
                    innerMap.put("fisincludesuborg", sourceIncludeSub);
                    insertList.add(innerMap);
                    continue;
                }
                if (sourceIncludeSub.booleanValue() || targetIncludesub.booleanValue()) {
                    finalIncludeSub = true;
                }
                if (!finalIncludeSub || !sourceIncludeSub.booleanValue() || targetIncludesub.booleanValue()) continue;
                updateUserRoleFidList.add(row.getString("targetFId"));
            }
            if (!CollectionUtils.isEmpty(insertList)) {
                int size = insertList.size();
                String[] ids = DB.genStringIds((String)"t_perm_disfunperm", (int)size);
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
                int index = 0;
                for (Map map : insertList) {
                    paramList.add(new Object[]{ids[index++], map.get("fuserid"), map.get("forgid"), map.get("fpermitemid"), map.get("fentitytypeid"), map.get("fbizappid"), map.get("fdimtype"), map.get("fisincludesuborg")});
                }
                String sql = "insert into t_perm_disfunperm (fid, fuserid, forgid, fpermitemid, fentitytypeid, fbizappid, fdimtype, fisincludesuborg) values (?,?,?,?,?,?,?,?)";
                SqlUtil.asyncInsertThrowE(paramList, (String)sql, (Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (DBRoute)DBRoute.basedata);
            }
            if (!CollectionUtils.isEmpty(updateUserRoleFidList)) {
                String updateUserRoleFidsStr = String.join((CharSequence)"','", updateUserRoleFidList);
                StringBuilder updateSql = new StringBuilder();
                updateSql.append("update t_perm_disfunperm set fisincludesuborg = '1'");
                updateSql.append(" where fid in ('").append(updateUserRoleFidsStr).append("')");
                DB.execute((DBRoute)DBRoute.basedata, (String)updateSql.toString());
            }
        }
    }
}

