/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.factory;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PermServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();
    private static Log log = LogFactory.getLog((String)"PermApiServiceFactory");
    private static final ThreadLocal<Map<String, Object>> serviceInstanceMap = new ThreadLocal();

    public static <T> T getService(Class<T> clazz) {
        String key = clazz.getSimpleName();
        if (serviceInstanceMap.get() != null && serviceInstanceMap.get().containsKey(key)) {
            return (T)serviceInstanceMap.get().get(key);
        }
        return (T)PermServiceFactory.getService(key);
    }

    public static void putService(String serviceName, String serviceImpl) {
        serviceMap.put(serviceName, serviceImpl);
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            String appName = Instance.getAppName();
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s\u672a\u627e\u5230", (String)"PermServiceFactory_0", (String)"bos-mservice-permission", (Object[])new Object[0]), serviceName, appName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put("AdminGroupService", "kd.bos.permission.service.AdminGroupService");
        serviceMap.put("AdmGrpFunpermService", "kd.bos.permission.service.admingroup.AdmGrpFunpermService");
        serviceMap.put("AdmGrpBizUnitService", "kd.bos.permission.service.admingroup.AdmGrpBizUnitService");
        serviceMap.put("AdmGrpOrgService", "kd.bos.permission.service.admingroup.AdmGrpOrgService");
        serviceMap.put("AdmGrpOrgAddUserService", "kd.bos.permission.service.admingroup.AdmGrpOrgAddUserService");
        serviceMap.put("AdmGrpAppService", "kd.bos.permission.service.admingroup.AdmGrpAppService");
        serviceMap.put("UserAdmGrpService", "kd.bos.permission.service.admingroup.UserAdmGrpService");
        serviceMap.put("ComRoleFuncPermService", "kd.bos.permission.service.comrole.ComRoleFuncPermService");
        serviceMap.put("ComRoleService", "kd.bos.permission.service.ComRoleService");
        serviceMap.put("UserRoleService", "kd.bos.permission.service.UserRoleService");
        serviceMap.put("UsrGrpRoleService", "kd.bos.permission.service.UsrGrpRoleService");
        serviceMap.put("BusiRoleService", "kd.bos.permission.service.BusiRoleService");
        serviceMap.put("UserBusiRoleService", "kd.bos.permission.service.UserBusiRoleService");
        serviceMap.put("UserDirectPermService", "kd.bos.permission.service.UserDirectPermService");
        serviceMap.put("UserDisPermService", "kd.bos.permission.service.UserDisPermService");
        serviceMap.put("OperationRuleService", "kd.bos.permission.service.OperationRuleService");
        serviceMap.put("PermissionServiceHelper", "kd.bos.servicehelper.permission.PermissionServiceHelper");
        serviceMap.put("BosOrgPermCtrlTypeExt", "kd.bos.permission.service.permctrltype.BosOrgPermCtrlTypeExt");
    }
}

