/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.migration;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.migration.ImportResult;
import kd.bos.permission.migration.model.PermMigratedBean;
import kd.bos.util.StringUtils;

public class PermMigration {
    private static Log logger = LogFactory.getLog((String)"PermMigrationFactory");
    private static final String FIELDSCHEME = "perm_fieldscheme";
    private static final String DATARULE = "perm_datarule";
    private static final String COMROLE = "perm_role";
    private static final String USERROLE = "perm_userrole_multype";
    private static final String BUSIROLE = "perm_busirole";
    private static final String USERBIZROLE = "perm_userbizrole";
    private static final String USERPERM = "bos_user";
    private static final String USRGRPROLE = "perm_usrgrprole";
    private static final String USRGRPBUSIROLE = "perm_usrgrpbusirole";
    static Map<String, String> migratoryDimMap = new HashMap<String, String>(10);

    private static PermMigratedBean getPermMigratedBean(String migratoryDim) {
        String className = migratoryDimMap.get(migratoryDim);
        if (StringUtils.isEmpty((String)className)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8fc1\u79fb\u7ef4\u5ea6\u5b9e\u73b0\u3002", (String)"PermMigration_0", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (PermMigratedBean)clazz.newInstance();
        }
        catch (Exception e) {
            logger.warn("PermMigrationFactory.getMigration error.", (Object)e.getMessage());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fc1\u79fb\u7ef4\u5ea6\u5b9e\u73b0\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25\uff1a%1$s", (String)"PermMigration_1", (String)"bos-mservice-permission", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static String exportData(String migratoryDim, Set<Object> exportDataIds, String exportPath) {
        if (exportDataIds == null || exportDataIds.isEmpty()) {
            logger.debug("PermMigration.export: exportDataIds == null || exportDataIds.isEmpty()");
            return "";
        }
        String json = PermMigration.getPermMigratedBean(migratoryDim).generateJson(exportDataIds);
        if (StringUtils.isEmpty((String)json)) {
            logger.debug("PermMigration.exportData: exportDataJson is empty ");
            return "";
        }
        String fileName = "exportData_" + migratoryDim + "_" + new SimpleDateFormat("yyyyMMdd HHmmss").format(new Date()) + ".json";
        if (StringUtils.isEmpty((String)exportPath)) {
            String url;
            try (ByteArrayInputStream ins = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));){
                url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)ins, 5000);
            }
            catch (IOException e) {
                logger.debug("PermMigration.exportData IO error.", (Object)e);
                return "";
            }
            return url;
        }
        if (!exportPath.endsWith(File.separator)) {
            exportPath = exportPath + File.separator;
        }
        fileName = exportPath + fileName;
        File file = new File(fileName);
        try (FileOutputStream stream = new FileOutputStream(file);){
            stream.write(json.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.debug("PermMigration.exportData IO error.", (Object)e);
            file.deleteOnExit();
            return "";
        }
        return fileName;
    }

    public static ImportResult importData(String url) throws Exception {
        StringBuilder errorMes = new StringBuilder();
        ImportResult importResult = new ImportResult();
        if (StringUtils.isEmpty((String)url)) {
            errorMes.append(ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25", (String)"PermMigration_2", (String)"bos-mservice-permission", (Object[])new Object[0]));
            importResult.setAllSuccess(false);
            return importResult;
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            InputStream inputStream = service.getInputStream(url);
            String json = CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            if (StringUtils.isEmpty((String)json)) {
                errorMes.append(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25", (String)"PermMigration_3", (String)"bos-mservice-permission", (Object[])new Object[0]));
                importResult.setAllSuccess(false);
                return importResult;
            }
            String[] tempSplit = url.split("exportData_");
            String migratoryDim = tempSplit[1].split("_20")[0];
            importResult = PermMigration.getPermMigratedBean(migratoryDim).importData(json, errorMes);
            CacheMrg.clearAllCache();
        }
        catch (Exception e) {
            logger.warn("PermMigration.importData: wrong file:{}", (Object)url, (Object)e.getMessage());
            throw e;
        }
        return importResult;
    }

    static {
        migratoryDimMap.put(FIELDSCHEME, "kd.bos.permission.migration.model.FieldSchemeMigration");
        migratoryDimMap.put(DATARULE, "kd.bos.permission.migration.model.DataRuleMigration");
        migratoryDimMap.put(COMROLE, "kd.bos.permission.migration.model.ComRoleMigration");
        migratoryDimMap.put(USERROLE, "kd.bos.permission.migration.model.UserRoleMigration");
        migratoryDimMap.put(BUSIROLE, "kd.bos.permission.migration.model.BusiRoleMigration");
        migratoryDimMap.put(USERBIZROLE, "kd.bos.permission.migration.model.UserBizRoleMigration");
        migratoryDimMap.put(USERPERM, "kd.bos.permission.migration.model.UserPermMigration");
        migratoryDimMap.put(USRGRPROLE, "");
        migratoryDimMap.put(USRGRPBUSIROLE, "");
    }
}

