/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.migration;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class PermMigrationHelper {
    private static final Log log = LogFactory.getLog(PermMigrationHelper.class);

    public static String getAppIdByAppNum(String appNumber) {
        DynamicObject appObj;
        String appId = "";
        if (!StringUtils.isEmpty((String)appNumber) && (appObj = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)appNumber)})) != null) {
            appId = appObj.getString("id");
        }
        return appId;
    }

    public static void setUnimportantInfo(DynamicObject dynamicObject, boolean containStatus) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        dynamicObject.set("creator", (Object)currUserId);
        dynamicObject.set("createtime", (Object)now);
        dynamicObject.set("modifier", (Object)currUserId);
        dynamicObject.set("modifytime", (Object)now);
        if (containStatus) {
            dynamicObject.set("status", (Object)"C");
        }
    }

    public static void addPermLog(PermLogBusiType permLogBusiType, String afterData, Object successPkId, String number, String name, String preData, String busiFrom, String diffContent) {
        if (PermCommonUtil.isEnablePermLog()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            map.put("busi_from", busiFrom);
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", "0QLCSO6KKZC9");
            map.put("app_id", "0XWTKVOQW+ML");
            map.put("form_identity", "perm_datamigration");
            map.put("opbtn", ResManager.loadKDString((String)"\u6743\u9650\u5bfc\u5165", (String)"PermDataMigrationNewUtils_4", (String)"bos-mservice-permission", (Object[])new Object[0]));
            map.put("interface_method", "kd.bos.permission.util.PermDataMigrationNewUtils.addPermLog");
            map.put("op_item_id", successPkId);
            map.put("op_item_number", number);
            map.put("op_item_name", name);
            map.put("pre_data", preData);
            map.put("after_data", afterData);
            map.put("diff_content", diffContent);
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
    }

    public static boolean isValidateDataNumsExist(String importDataNum, Set<String> validateDataNums, String entityName, List<String> errorList, String errorMes) {
        if (CollectionUtils.isEmpty(validateDataNums)) {
            return true;
        }
        DynamicObjectCollection existDataCol = QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", validateDataNums)});
        Set existDataNums = existDataCol.stream().map(k -> k.getString("number")).collect(Collectors.toSet());
        Sets.SetView notExistDataNums = Sets.difference(validateDataNums, existDataNums);
        if (!notExistDataNums.isEmpty()) {
            String notExistDataNumsStr = notExistDataNums.toString();
            notExistDataNumsStr = notExistDataNumsStr.substring(1, notExistDataNumsStr.length() - 1);
            errorList.add(String.format(errorMes, notExistDataNumsStr));
        }
        return true;
    }

    public static boolean isUserTypeExist(String importDataNum, String userTypeStr, Map<Long, String> bosUserTypeMap, Map<Long, String> sourceUserTypeMap, List<String> errorList) {
        String[] split;
        if (StringUtils.isNotEmpty((String)userTypeStr) && null != (split = userTypeStr.split(",")) && split.length > 0) {
            Set<String> collect = Arrays.stream(split).filter(x -> StringUtils.isNotEmpty((String)x)).collect(Collectors.toSet());
            if ((split = collect.toArray(new String[0])).length > 5) {
                errorList.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801 \u201c%1$s\u201d \u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff1a%2$s\u3002\r\n", (String)"PermDataMigrationValidator_0", (String)"bos-mservice-permission", (Object[])new Object[0]), importDataNum, ResManager.loadKDString((String)"\u201c\u9002\u7528\u7528\u6237\u7c7b\u578b\u201d\u957f\u5ea6\u8fc7\u957f\uff0c\u5efa\u8bae\u52fe\u9009\u4e0d\u8d85\u8fc75\u9879", (String)"PermDataMigrationValidator_20", (String)"bos-mservice-permission", (Object[])new Object[0])));
            }
            bosUserTypeMap = null == bosUserTypeMap ? PermCommonUtil.getBosUserTypeMap() : bosUserTypeMap;
            HashSet<Long> bosUserTypeIdSet = new HashSet<Long>(bosUserTypeMap.keySet());
            Set curUserTypeIdSet = null;
            try {
                curUserTypeIdSet = Arrays.stream(split).map(x -> Long.valueOf(x)).collect(Collectors.toSet());
            }
            catch (Exception e) {
                log.warn("PermMigrationHelper.isUserTypeExist error.", (Throwable)e);
                errorList.add(ResManager.loadKDString((String)"\u201c\u9002\u7528\u7528\u6237\u7c7b\u578b\u201d\u6570\u503c\u683c\u5f0f\u9519\u8bef", (String)"PermDataMigrationValidator_18", (String)"bos-mservice-permission", (Object[])new Object[0]));
            }
            Sets.SetView notInUserTypeId = Sets.difference(curUserTypeIdSet, bosUserTypeIdSet);
            if (null != notInUserTypeId && !notInUserTypeId.isEmpty()) {
                Set userTypeNameSet = notInUserTypeId.stream().map(sourceUserTypeMap::get).collect(Collectors.toSet());
                errorList.add(String.format(ResManager.loadKDString((String)"\u9002\u7528\u7528\u6237\u7c7b\u578b\u201c%1$s\u201d\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_19", (String)"bos-mservice-permission", (Object[])new Object[0]), Strings.join((Iterable)userTypeNameSet.stream().map(String::valueOf).collect(Collectors.toSet()), (String)"\u3001")));
            }
        }
        return true;
    }

    public static boolean isComRoleNumExist(String importDataNum, Set<String> comRoleNums, List<String> errorList) {
        return PermMigrationHelper.isValidateDataNumsExist(importDataNum, comRoleNums, "perm_role", errorList, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u901a\u7528\u89d2\u8272\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_12", (String)"bos-mservice-permission", (Object[])new Object[0]));
    }

    public static boolean isDimTypeNumExist(String importDataNum, Set<String> dimTypeNum, List<String> errorList) {
        return PermMigrationHelper.isValidateDataNumsExist(importDataNum, dimTypeNum, "perm_ctrltype", errorList, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u6743\u9650\u63a7\u5236\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_5", (String)"bos-mservice-permission", (Object[])new Object[0]));
    }

    public static boolean isDimNumExist(String importDataNum, String dimEntNum, Set<String> dimNums, List<String> errorList) {
        String[] suitableDimType = PermCommonUtil.getSuitableDimType((String)dimEntNum);
        return PermMigrationHelper.isValidateDataNumsExist(importDataNum, dimNums, dimEntNum, errorList, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684%2$s\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_14", (String)"bos-mservice-permission", (Object[])new Object[0]), suitableDimType[3]));
    }

    public static boolean isEntityNumExist(String importDataNum, Set<String> entityNums, List<String> errorList) {
        return PermMigrationHelper.isValidateDataNumsExist(importDataNum, entityNums, "bos_entityobject", errorList, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_1", (String)"bos-mservice-permission", (Object[])new Object[0]));
    }

    public static boolean isAppNumExist(String importDataNum, Set<String> appNums, List<String> errorList) {
        return PermMigrationHelper.isValidateDataNumsExist(importDataNum, appNums, "bos_devportal_bizapp", errorList, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u5e94\u7528\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_3", (String)"bos-mservice-permission", (Object[])new Object[0]));
    }

    public static boolean isPermItemNumExist(String importDataNum, Set<String> permItemNums, List<String> errorList) {
        return PermMigrationHelper.isValidateDataNumsExist(importDataNum, permItemNums, "perm_permitem", errorList, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u6743\u9650\u9879\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_6", (String)"bos-mservice-permission", (Object[])new Object[0]));
    }

    public static boolean isFieldNumExist(String importDataNum, Set<String> fieldKeys, String entityNum, List<String> errorList) {
        if (CollectionUtils.isEmpty(fieldKeys) || StringUtils.isEmpty((String)entityNum)) {
            return true;
        }
        MainEntityType entityTypeInfo = EntityMetadataCache.getDataEntityType((String)entityNum);
        Set existFieldKeys = entityTypeInfo.getAllFields().keySet();
        Sets.SetView notExistFieldKeys = Sets.difference(fieldKeys, existFieldKeys);
        if (!notExistFieldKeys.isEmpty()) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u4e1a\u52a1\u5bf9\u8c61\u5185\u4e0d\u5b58\u5728\u6807\u8bc6\u4e3a \u201c%2$s\u201d \u7684\u5b57\u6bb5", (String)"PermDataMigrationValidator_17", (String)"bos-mservice-permission", (Object[])new Object[0]), entityNum, Strings.join((Iterable)notExistFieldKeys, (String)"\u3001")));
        }
        return true;
    }

    public static boolean isFieldSchemeNumEntNumExist(String importDataNum, Map<String, String> fieldSchemeNumEntNumMap, List<String> errorList) {
        if (fieldSchemeNumEntNumMap == null || fieldSchemeNumEntNumMap.isEmpty()) {
            return true;
        }
        Set<String> fieldSchemeNums = fieldSchemeNumEntNumMap.keySet();
        DynamicObjectCollection existFieldSchemeCol = QueryServiceHelper.query((String)"perm_fieldscheme", (String)"number,ent_id", (QFilter[])new QFilter[]{new QFilter("number", "in", fieldSchemeNums)});
        HashMap<String, String> existFieldSchemeMap = new HashMap<String, String>(10);
        for (DynamicObject existFieldScheme : existFieldSchemeCol) {
            existFieldSchemeMap.put(existFieldScheme.getString("number"), existFieldScheme.getString("ent_id"));
        }
        Sets.SetView notExistFieldSchemeNums = Sets.difference(fieldSchemeNums, existFieldSchemeMap.keySet());
        if (!notExistFieldSchemeNums.isEmpty()) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u5b57\u6bb5\u6743\u9650\u65b9\u6848\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_7", (String)"bos-mservice-permission", (Object[])new Object[0]), Strings.join((Iterable)notExistFieldSchemeNums, (String)"\u3001")));
        }
        for (Map.Entry existFieldSchemeEntNum : existFieldSchemeMap.entrySet()) {
            String fieldSchemeNum;
            String validateEntNum;
            String entNum = (String)existFieldSchemeEntNum.getValue();
            if (StringUtils.isEmpty((String)entNum) || entNum.equals(validateEntNum = fieldSchemeNumEntNumMap.get(fieldSchemeNum = (String)existFieldSchemeEntNum.getKey()))) continue;
            errorList.add(String.format(ResManager.loadKDString((String)"\u5f85\u5bfc\u5165\u6570\u636e\u4e2d\u7f16\u7801\u4e3a \u201c%1$s\u201d \u5b57\u6bb5\u6743\u9650\u65b9\u6848\u4e2d\u7684\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u4e0e\u73af\u5883\u5185\u540c\u7f16\u7801\u65b9\u6848\u7684\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u4e0d\u4e00\u81f4", (String)"PermDataMigrationValidator_9", (String)"bos-mservice-permission", (Object[])new Object[0]), fieldSchemeNum));
        }
        return true;
    }

    public static boolean isNewDrNumEntNumExist(String importDataNum, Map<String, String> newDrNumEntNumMap, List<String> errorList) {
        if (newDrNumEntNumMap == null || newDrNumEntNumMap.isEmpty()) {
            return true;
        }
        Set<String> newDrNums = newDrNumEntNumMap.keySet();
        DynamicObjectCollection existNewDrCol = QueryServiceHelper.query((String)"perm_datarule", (String)"number,entity_id", (QFilter[])new QFilter[]{new QFilter("number", "in", newDrNums)});
        HashMap<String, String> existNewDrMap = new HashMap<String, String>(10);
        for (DynamicObject existNewDr : existNewDrCol) {
            existNewDrMap.put(existNewDr.getString("number"), existNewDr.getString("entity_id"));
        }
        Sets.SetView notExistNewDrNums = Sets.difference(newDrNums, existNewDrMap.keySet());
        if (!notExistNewDrNums.isEmpty()) {
            errorList.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u6570\u636e\u89c4\u5219\u65b9\u6848\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_8", (String)"bos-mservice-permission", (Object[])new Object[0]), Strings.join((Iterable)notExistNewDrNums, (String)"\u3001")));
        }
        for (Map.Entry existNewDrEntNum : existNewDrMap.entrySet()) {
            String validateEntNum;
            String newDrNum = (String)existNewDrEntNum.getKey();
            String entNum = (String)existNewDrEntNum.getValue();
            if (entNum.equals(validateEntNum = newDrNumEntNumMap.get(newDrNum))) continue;
            errorList.add(String.format(ResManager.loadKDString((String)"\u5f85\u5bfc\u5165\u6570\u636e\u4e2d\u7f16\u7801\u4e3a \u201c%1$s\u201d \u6570\u636e\u89c4\u5219\u65b9\u6848\u4e2d\u7684\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u4e0e\u73af\u5883\u5185\u540c\u7f16\u7801\u65b9\u6848\u7684\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u4e0d\u4e00\u81f4", (String)"PermDataMigrationValidator_10", (String)"bos-mservice-permission", (Object[])new Object[0]), newDrNum));
        }
        return true;
    }

    public static boolean isAdminGrpNumExist(String importDataNum, Set<String> adminGrpNums, List<String> errorList) {
        return PermMigrationHelper.isValidateDataNumsExist(importDataNum, adminGrpNums, "perm_admingroup", errorList, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a \u201c%1$s\u201d \u7684\u7ba1\u7406\u5458\u7ec4\u4e0d\u5b58\u5728", (String)"PermDataMigrationValidator_4", (String)"bos-mservice-permission", (Object[])new Object[0]));
    }
}

